<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Elementor_Seosight_Title extends \Elementor\Widget_Base {

	public function get_name() {
		return 'seosight_title';
	}

	public function get_title() {
		return esc_html__( 'Title', 'elementor-seosight' );
	}

	public function get_icon() {
		return 'crum-el-w-title';
	}

	public function get_categories() {
		return [ 'elementor-seosight' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'seosight_title',
			[
				'label' => esc_html__( 'Title', 'elementor-seosight' ),
			]
		);

		$this->add_control(
			'post_title',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Use post title?', 'elementor-seosight' ),
                'description' => esc_html__( 'Use the title of current post/page as content element instead of text input value.', 'elementor-seosight' ),
                'default'     => 'no',
			]
        );
        
        $this->add_control(
            'title',
            [
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Title', 'elementor-seosight'),
				'default'   => 'The Title',
				'condition' => [
                    'post_title!' => 'yes',
                ],
                'separator' => 'before'
            ]
		);
		
		$this->add_control(
			'type',
			[
				'type'      => \Elementor\Controls_Manager::SELECT,
				'label'     => esc_html__( 'Title Tag', 'elementor-seosight' ),
				'options'   => [
					'h1'   => 'H1',
					'h2'   => 'H2',
					'h3'   => 'H3',
					'h4'   => 'H4',
					'h5'   => 'H5',
					'h6'   => 'H6',
					'div'  => 'div',
					'span' => 'Span',
					'p'    => 'P'
				],
                'default'   => 'h1',
                'separator' => 'before'
			]
		);

		$this->add_control(
			'el_class',
			[
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label'       => esc_html__( 'Tag class', 'elementor-seosight' ),
				'description' => esc_html__( 'Add class name for title tag only', 'elementor-seosight' ),
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'inline_link',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Add inline link?', 'elementor-seosight' ),
				'description' => esc_html__( 'Additional text with link on one line with title text', 'elementor-seosight' ),
                'default'     => 'no',
                'separator'   => 'before'
			]
		);

		$this->add_control(
			'title_link_name',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Add Link Name', 'elementor-seosight' ),
				'condition' => [
                    'inline_link' => 'yes',
                ],
                'separator' => 'before'
			]
		);

		$this->add_control(
			'title_link',
			[
				'type'        => \Elementor\Controls_Manager::URL,
				'label'       => esc_html__( 'Add Link', 'elementor-seosight' ),
				'description' => esc_html__( 'Add link with title text', 'elementor-seosight' ),
                'condition'   => [
                    'inline_link' => 'yes',
                ],
			]
		);

		$this->add_control(
			'title_delim',
			[
				'type'        => \Elementor\Controls_Manager::SWITCHER,
				'label'       => esc_html__( 'Title decoration', 'elementor-seosight' ),
				'description' => esc_html__( 'Visual decoration lines below title text', 'elementor-seosight' ),
                'default'     => 'no',
                'separator'   => 'before'
			]
		);

		$this->add_control(
			'subtitle',
			[
				'type'      => \Elementor\Controls_Manager::TEXT,
				'label'     => esc_html__( 'Subtitle',  'elementor-seosight' ),
				'separator' => 'before'
			]
		);

		$this->add_control(
            'align', 
            [
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'label'     => esc_html__( 'Content align', 'elementor-seosight' ),
                'options'   => [
					'align-left'   => [
						'title' => esc_html__( 'Left', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-left',
                    ],
                    'align-center' => [
						'title' => esc_html__( 'Centered', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-center',
                    ],
					'align-right'  => [
						'title' => esc_html__( 'Right', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-right',
					]
                ],
                'default'   => 'align-center',
                'condition' => [
                    'inline_link!' => 'yes',
                ],
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'class',
            [
                'type'        => \Elementor\Controls_Manager::TEXT,
                'label'       => esc_html__( 'Extra class', 'elementor-seosight' ),
                'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'elementor-seosight' ),
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Title', 'elementor-seosight' ),
			]
        );

		$this->add_control(
			'title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-seosight' ),
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .heading-title' => 'color: {{SCHEME}};'
				],
				'separator' => 'after'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .heading-title',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'sub-title-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Subtitle', 'elementor-seosight' ),
			]
        );

		$this->add_control(
			'sub-title-color',
			[
				'type'      => \Elementor\Controls_Manager::COLOR,
				'label'     => esc_html__( 'Color', 'elementor-seosight' ),
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .heading-text' => 'color: {{SCHEME}};'
				],
				'separator' => 'after'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'sub-title_typography',
				'scheme'   => \Elementor\Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .heading-text'
			]
		);

		$this->add_control(
            'sub-title-opacity',
            [
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'label'      => __( 'Opacity', 'elementor-seosight' ),
                'size_units' => [ 'px' ],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1,
                        'step' => 0.01,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .heading-text' => 'opacity: {{SIZE}};',
                ],
                'separator'  => 'before'
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'decoration-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Decoration', 'elementor-seosight' ),
			]
        );

		$this->add_control(
			'decoration-color',
			[
				'label'     => esc_html__( 'Color', 'elementor-seosight' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .heading-decoration' => 'color: {{SCHEME}};'
				]
			]
		);

		$this->add_control(
			'decoration-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-seosight' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'box-css',
			[
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Box Style', 'elementor-seosight' ),
			]
        );

        $this->add_control(
            'box-align', 
            [
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'label'   => esc_html__( 'Align', 'elementor-seosight' ),
                'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-left',
                    ],
                    'center'  => [
						'title' => esc_html__( 'Centered', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-center',
                    ],
					'right'   => [
						'title' => esc_html__( 'Right', 'elementor-seosight' ),
						'icon'  => 'fa fa-align-right',
					]
                ],
                'default' => 'center'
            ]
        );

        $this->add_control(
			'box-padding',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Padding', 'elementor-seosight' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

		$this->add_control(
			'box-margin',
			[
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'label'      => __( 'Margin', 'elementor-seosight' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before'
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		global $allowedposttags;

		$link_html = '';

		$settings = $this->get_settings_for_display();

		$type  = ! empty( $settings['type'] ) ? $settings['type'] : 'h1';
		$title = ! empty( $settings['title'] ) ? $settings['title'] : '';
		
		$wrap_class = [ 'crumina-module', 'crumina-heading' ];
		if ( empty( $settings['inline_link'] ) || ( ! empty( $settings['inline_link'] ) && $settings['inline_link'] != 'yes' ) ) {
			$wrap_class[] = ! empty( $settings['align'] ) ? $settings['align'] : '';
		}
		if ( ! empty( $settings['class'] ) ) {
			$wrap_class[] = $settings['class'];
		}

		if ( ! empty( $settings['inline_link'] ) && $settings['inline_link'] == 'yes' && ! empty( $settings['title_link']['url'] ) ) {
			$wrap_class[] = 'with-read-more';
			
			$link_title = ! empty( $settings['title_link_name'] ) ? $settings['title_link_name'] : esc_html__( 'Read more', 'elementor-seosight' );
			$target     = 'target="'. ( ! empty( $settings['title_link']['is_external'] ) ? '_blank' : '_self' ) . '"';
            $nofollow   = ! empty( $settings['title_link']['nofollow'] ) ? 'rel="nofollow"' : '';
			
			$link_html = '<a href="' . esc_url( $settings['title_link']['url'] ) . '" class="read-more" title="' . esc_attr( $link_title ) . '" ' . $target . ' ' . $nofollow . '>' . esc_html( $link_title ) . '<i class="seoicon-right-arrow"></i></a>';
		}

		if ( ! empty( $settings['post_title'] ) && $settings['post_title'] == 'yes' ) {
			$text_title = get_the_title();
			if ( ! empty( $text_title ) ) {
				$title = esc_attr( $text_title );
			}
		}

		$el_class = 'heading-title';
		if ( ! empty( $settings['el_class'] ) ) {
			$el_class.= ' ' . $settings['el_class'];
		}
		$settings['box-align'] = ! empty( $settings['align'] ) ? '' : $settings['box-align'];
		?>
		<header class="<?php echo esc_attr( implode( ' ', $wrap_class ) ); ?>" <?php echo ( ! empty( $settings['box-align'] ) ? 'style="text-align: ' . $settings['box-align'] . ';"' : '' ); ?>>
		    <div class="title-text-wrap">
		    	<<?php echo esc_attr( $type ) ?> class="<?php echo esc_attr( $el_class ); ?>">
					<?php echo esc_html( $title ); ?>
				</<?php echo esc_attr( $type ) ?>>
				<?php es_render( $link_html ); ?>
		    </div>
			<?php if ( ! empty( $settings['title_delim'] ) && $settings['title_delim'] == 'yes' ) { ?>
		        <div class="heading-decoration"><span class="first"></span><span class="second"></span></div>
			<?php }
			if ( ! empty( $settings['subtitle'] ) ) { ?>
		        <div class="h5 heading-text"><?php echo html_entity_decode( wp_kses( $settings['subtitle'], $allowedposttags ) ); ?></div>
			<?php } ?>
		</header>
		<?php
	}
}