<?php
/** @var array $atts */
$type    = $wrap_class = $current_class = $pointdate = '';
$options = array();
wp_enqueue_script( 'seosight-timeline' );
extract( $atts );

//Kingcomposer wrapper class for each element
$wrap_class = apply_filters( 'kc-el-class', $atts );
//custom class element
$wrap_class[] = 'theme-module';
$i       = 0;
?>
<div class="<?php echo implode( ' ', $wrap_class ); ?>">
    <?php if ( ! empty( $options ) ) {
        ?>
        <section class="cd-h-timeline js-cd-h-timeline">
            <?php ob_start(); ?>
            <div class="cd-h-timeline__container">
                <div class="cd-h-timeline__dates">
					<div class="cd-h-timeline__line">
                        <ol>
                            <?php
                            $i = 0;
                            foreach ( $options as $option ) {
                                $datetime     = $option->pointdate;
                                $datetime = str_replace('/','-',$datetime);
                                $date         = ( ! empty( $datetime ) && $datetime !== '__empty__' ) ? $datetime : date( "D M d Y", strtotime( "+1 week" ) );
                                $data_date    = date( 'd/m/Y', strtotime( $date ) );
                                $year         = date( 'Y', strtotime( $date ) );
                                $curent_class = $i == 0 ? 'cd-h-timeline__date--selected' : '';
                                ?>
                                <li>
                                    <a href="#0" data-date="<?php echo esc_attr( $data_date ) ?>"
                                       class="cd-h-timeline__date <?php echo esc_attr( $curent_class ) ?>"><?php echo esc_html( $year ) ?></a>
                                </li>
                                <?php
                                $i ++;
                            } ?>
                            <!-- other dates here -->
                        </ol>
                        <span class="cd-h-timeline__filling-line" aria-hidden="true"></span>
                    </div> <!-- .events -->
                </div> <!-- .events-wrapper -->

                <ul>
                    <li><a href="#0" class="text-replace cd-h-timeline__navigation cd-h-timeline__navigation--prev cd-h-timeline__navigation--inactive seoicon-play"><?php esc_html_e( 'Prev', 'kingcomposer-seosight' ) ?></a>
                    </li>
                    <li><a href="#0" class="text-replace cd-h-timeline__navigation cd-h-timeline__navigation--next seoicon-play"><?php esc_html_e( 'Next', 'kingcomposer-seosight' ) ?></a></li>
                </ul> <!-- .cd-timeline-navigation -->
            </div> <!-- .timeline -->
            <?php
            $timeline = ob_get_clean();
            if ( 'bottom' !== $type ) {
                seosight_render( $timeline );
            }
            ?>
            <div class="cd-h-timeline__events">
                <ol>
                    <?php
                    $i = 0;
                    foreach ( $options as $option ) {
                        $datetime     = $option->pointdate;
                        $datetime = str_replace('/','-',$datetime);
                        $date         = ( ! empty( $datetime ) && $datetime !== '__empty__' ) ? $datetime : date( "D M d Y", strtotime( "+1 week" ) );
                        $data_date    = date( 'd/m/Y', strtotime( $date ) );
                        $year         = date( 'M, Y', strtotime( $date ) );
                        $curent_class = $i == 0 ? 'cd-h-timeline__event--selected' : '';
                        ?>
                        <li class="cd-h-timeline__event <?php echo esc_attr( $curent_class ) ?>"
                            data-date="<?php echo esc_attr( $data_date ) ?>">
                            <div class="row">
                                <?php
                                if ( ! empty( $option->image ) ) {
                                    $content_class = 'col-lg-8 col-lg-offset-1 col-md-8 col-md-offset-1 col-sm-9 col-xs-12 table-cell';
                                    ?>
                                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 table-cell">
                                        <div class="time-line-thumb">
	                                        <?php echo wp_get_attachment_image( $option->image, 'full' ); ?>
                                        </div>
                                    </div>
                                <?php } else {
                                    $content_class = 'col-sm-12';
                                }
                                ?>
                                <div class="<?php echo esc_attr( $content_class ) ?>">
                                    <div class="time-line-content">
                                        <h6 class="time-line-subtitle"><?php echo esc_html( $year ) ?></h6>
                                        <h5 class="time-line-title"><?php echo esc_html( $option->title ) ?></h5>
                                        <div class="time-line-text"><?php echo wpautop( $option->desc ) ?></div>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <?php
                        $i ++;
                    } ?>
                    <!-- other descriptions here -->
                </ol>
            </div> <!-- .events-content -->
            <?php if ( 'bottom' === $type ) {
                seosight_render( $timeline );
            } ?>
        </section>
    <?php } else { ?>
        <?php esc_html_e( 'Please create any timeline points', 'kingcomposer-seosight' ); ?>
    <?php } ?>
</div>
