<?php
global $allowedposttags;
$output = $wrap_class = $css = $title = $desc = $image = $direction = '';

extract( $atts );

$el_class = apply_filters( 'kc-el-class', $atts );
$el_class[] = 'crumina-module';
$el_class[] = 'crumina-product-description-border';
if ( $direction === 'rightimage' ) {
	$el_class[] = 'even';
}

$el_class[]  = $wrap_class;

?>

<div class="<?php echo esc_attr( implode( ' ', $el_class ) ) ?>">


    <div class="product-description-thumb">
	    <?php echo wp_get_attachment_image( $image, 'full', '', array( 'class' => 'shadow-image' ) ); ?>
    </div>

    <div class="product-description-content">
        <div class="crumina-module crumina-heading">
            <h4 class="h1 heading-title"><?php echo esc_html( $title ) ?></h4>
            <div class="heading-decoration">
                <span class="first"></span>
                <span class="second"></span>
            </div>
            <div class="product-description-text"> <?php echo wp_kses( $desc, $allowedposttags ); ?></div>
            </div>
    </div>

    <div class="product-description-border"></div>
</div>