<?php

/*
  Extension Name: WooCommerce
  Extension Preview: -
  Description:
  Version: 1.0
  Author: Crumina
  Author URI: https://wpcode.pro/
 */

if ( !defined( 'ABSPATH' ) ) {
    header( 'HTTP/1.0 403 Forbidden' );
    exit;
}

if ( !function_exists( 'kc_add_map' ) ) {
    return;
}

/**
 * Get lists of categories.
 *
 * @param $parent_id
 * @param array $array
 * @param $level
 * @param array $dropdown - passed by  reference
 * @param array $dropdown_ids - passed by  reference
 */
function seosight_get_category_childs_full( $parent_id, $array, $level,
                                          &$dropdown, &$dropdown_ids ) {
    $keys = array_keys( $array );
    $i    = 0;
    while ( $i < count( $array ) ) {
        $key  = $keys[ $i ];
        $item = $array[ $key ];
        $i ++;
        if ( $item->category_parent == $parent_id ) {
            $name                           = str_repeat( '- ', $level ) . $item->name;
            $dropdown[ $item->slug ]        = $name . '(' . $item->term_id . ')';
            $dropdown_ids[ $item->term_id ] = $name . '(' . $item->term_id . ')';
            unset( $array[ $key ] );
            $array                          = seosight_get_category_childs_full( $item->term_id, $array, $level + 1, $dropdown, $dropdown_ids );
            $keys                           = array_keys( $array );
            $i                              = 0;
        }
    }

    return $array;
}

$order_by_values = array(
    'date'          => esc_html__( 'Date', 'kingcomposer-seosight' ),
    'ID'            => esc_html__( 'ID', 'kingcomposer-seosight' ),
    'author'        => esc_html__( 'Author', 'kingcomposer-seosight' ),
    'title'         => esc_html__( 'Title', 'kingcomposer-seosight' ),
    'modified'      => esc_html__( 'Modified', 'kingcomposer-seosight' ),
    'rand'          => esc_html__( 'Random', 'kingcomposer-seosight' ),
    'comment_count' => esc_html__( 'Comment count', 'kingcomposer-seosight' ),
    'menu_order'    => esc_html__( 'Menu order', 'kingcomposer-seosight' ),
);

$order_way_values = array(
    'DESC' => esc_html__( 'Descending', 'kingcomposer-seosight' ),
    'ASC'  => esc_html__( 'Ascending', 'kingcomposer-seosight' ),
);

$categories = get_categories( array(
    'type'         => 'post',
    'child_of'     => 0,
    'parent'       => '',
    'orderby'      => 'name',
    'order'        => 'ASC',
    'hide_empty'   => false,
    'hierarchical' => 1,
    'exclude'      => '',
    'include'      => '',
    'number'       => '',
    'taxonomy'     => 'product_cat',
    'pad_counts'   => false,
) );

$product_categories_dropdown     = array();
$product_categories_dropdown_ids = array();
seosight_get_category_childs_full( 0, $categories, 0, $product_categories_dropdown, $product_categories_dropdown_ids );

global $post, $typenow, $current_screen;
$post_type = '';

if ( $post && $post->post_type ) {
    //we have a post so we can just get the post type from that
    $post_type = $post->post_type;
} elseif ( $typenow ) {
    //check the global $typenow - set in admin.php
    $post_type = $typenow;
} elseif ( $current_screen && $current_screen->post_type ) {
    //check the global $current_screen object - set in sceen.php
    $post_type = $current_screen->post_type;
} elseif ( isset( $_REQUEST[ 'post_type' ] ) ) {
    //lastly check the post_type querystring
    $post_type = sanitize_key( $_REQUEST[ 'post_type' ] );
    //we do not know the post type!
}

kc_add_map( array(
    'woocommerce_cart'           => array(
        'name'        => esc_html__( 'Cart', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Displays the cart contents', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array()
    ),
    'woocommerce_checkout'       => array(
        'name'        => esc_html__( 'Checkout', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Displays the checkout', 'kingcomposer-seosight' ),
        'params'      => array()
    ),
    'woocommerce_order_tracking' => array(
        'name'        => esc_html__( 'Order Tracking Form', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Lets a user see the status of an order', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array()
    ),
    'woocommerce_my_account'     => array(
        'name'        => esc_html__( 'My Account', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Shows the "my account" section', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Order count', 'kingcomposer-seosight' ),
                'value'       => 15,
                'name'        => 'order_count',
                'description' => esc_html__( 'You can specify the number or order to show, it\'s set by default to 15 (use -1 to display all orders.)', 'kingcomposer-seosight' ),
            ),
        )
    ),
    'recent_products'            => array(
        'name'        => esc_html__( 'Recent products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Lists recent products', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
        )
    ),
    'featured_products'          => array(
        'name'        => esc_html__( 'Featured products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Display products set as "featured"', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
        )
    ),
    'product'                    => array(
        'name'        => esc_html__( 'Product', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show a single product', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'autocomplete',
                'label'       => esc_html__( 'Product', 'kingcomposer-seosight' ),
                'name'        => 'id',
                'description' => esc_html__( 'Input product title to see suggestions', 'kingcomposer-seosight' ),
                'options'     => array(
                    'multiple'  => false,
                    'post_type' => 'product',
                ),
            ),
        )
    ),
    'products'                   => array(
        'name'        => esc_html__( 'Products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show a multiple products', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'autocomplete',
                'label'       => esc_html__( 'Products', 'kingcomposer-seosight' ),
                'name'        => 'ids',
                'description' => esc_html__( 'Input product title to see suggestions', 'kingcomposer-seosight' ),
                'options'     => array(
                    'multiple'  => true,
                    'post_type' => 'product',
                ),
            ),
        )
    ),
    'add_to_cart'                => array(
        'name'        => esc_html__( 'Add to cart', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show multiple products by ID or SKU', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'autocomplete',
                'label'       => esc_html__( 'Product', 'kingcomposer-seosight' ),
                'name'        => 'id',
                'description' => esc_html__( 'Input product title to see suggestions', 'kingcomposer-seosight' ),
                'options'     => array(
                    'multiple'  => false,
                    'post_type' => 'product',
                ),
            ),
            array(
                'type'  => 'textfield',
                'name'  => 'style',
                'label' => esc_html__( 'Wrapper inline style', 'kingcomposer-seosight' ),
            ),
        )
    ),
    'add_to_cart_url'            => array(
        'name'        => esc_html__( 'Add to cart URL', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show URL on the add to cart button', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'autocomplete',
                'label'       => esc_html__( 'Product', 'kingcomposer-seosight' ),
                'name'        => 'id',
                'description' => esc_html__( 'Input product title to see suggestions', 'kingcomposer-seosight' ),
                'options'     => array(
                    'multiple'  => false,
                    'post_type' => 'product',
                ),
            ),
        )
    ),
    'product_page'               => array(
        'name'        => esc_html__( 'Product page', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show single product by ID or SKU', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'autocomplete',
                'label'       => esc_html__( 'Product', 'kingcomposer-seosight' ),
                'name'        => 'id',
                'description' => esc_html__( 'Input product title to see suggestions', 'kingcomposer-seosight' ),
                'options'     => array(
                    'multiple'  => false,
                    'post_type' => 'product',
                ),
            ),
        )
    ),
    'product_category'           => array(
        'name'        => esc_html__( 'Product category', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Show multiple products in a category', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Category', 'kingcomposer-seosight' ),
                'name'        => 'category',
                'options'     => $product_categories_dropdown,
                'description' => esc_html__( 'Product category list', 'kingcomposer-seosight' ),
            ),
        )
    ),
    'product_categories'         => array(
        'name'        => esc_html__( 'Product categories', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'Display product categories loop', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'multiple',
                'label'       => esc_html__( 'Categories', 'kingcomposer-seosight' ),
                'name'        => 'ids',
                'options'     => $product_categories_dropdown_ids,
                'description' => esc_html__( 'List of product categories', 'kingcomposer-seosight' ),
            ),
        )
    ),
    'sale_products'              => array(
        'name'        => esc_html__( 'Sale products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'List all products on sale', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
        )
    ),
    'best_selling_products'      => array(
        'name'        => esc_html__( 'Best Selling Products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'List best selling products on sale', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            )
        )
    ),
    'top_rated_products'         => array(
        'name'        => esc_html__( 'Top Rated Products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'List all products on sale', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
        )
    ),
    'related_products'           => array(
        'name'        => esc_html__( 'Related Products', 'kingcomposer-seosight' ),
        'description' => esc_html__( 'List related products', 'kingcomposer-seosight' ),
        'icon'        => 'seoicon-woo-logo',
        'category'    => esc_html__( 'WooCommerce', 'kingcomposer-seosight' ),
        'params'      => array(
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Per page', 'kingcomposer-seosight' ),
                'value'       => 12,
                'name'        => 'per_page',
                'description' => esc_html__( 'The "per_page" shortcode determines how many products to show on the page', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'textfield',
                'label'       => esc_html__( 'Columns', 'kingcomposer-seosight' ),
                'value'       => 4,
                'name'        => 'columns',
                'description' => esc_html__( 'The columns attribute controls how many columns wide the products should be before wrapping.', 'kingcomposer-seosight' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Order by', 'kingcomposer-seosight' ),
                'name'        => 'orderby',
                'options'     => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
            array(
                'type'        => 'select',
                'label'       => esc_html__( 'Sort order', 'kingcomposer-seosight' ),
                'name'        => 'order',
                'options'     => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'kingcomposer-seosight' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
            ),
        )
    ),
) );
