<?php
/*
Extension Name: Vertical slider
Extension Preview: -
Description:
Version: 1.0
Author: Crumina
Author URI: https://wpcode.pro/
*/

if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

$live_tmpl   = KC_SEOSIGHT_ADDONS_PL_PATH . '/shortcodes/live_editor/';
$images_path = KC_SEOSIGHT_ADDONS_PL_URL . '/images/';

if ( function_exists( 'kc_add_map' ) ) {
	kc_add_map(
		array(
			'crum_vertical_slider' => array(
				'name'         => esc_html__( 'Vertical slider', 'kingcomposer-seosight' ),
				'title'        => esc_html__( 'Vertical slider', 'kingcomposer-seosight' ),
				'icon'         => 'kc-crum-icon kc-crum-icon-vertical-slider',
				'category'     => esc_html__( 'SeoSight', 'kingcomposer-seosight' ),
				'nested'       => true,
				'accept_child' => 'kc_row_inner',
				'description'  => esc_html__( 'Slider with blocks scrolled vertically', 'kingcomposer-seosight' ),
				'live_editor' => $live_tmpl . 'crum_vertical_slider.tpl',
				'params'       => array(
					array(
						'name'    => 'effect',
						'label'   => esc_html__( 'Slide effect', 'kingcomposer-seosight' ),
						'type'    => 'select',
						'value'   => 'slide',
						'options' => array(
							'slide'     => esc_html__( 'Slide', 'kingcomposer-seosight' ),
							'fade'      => esc_html__( 'Fade', 'kingcomposer-seosight' ),
							'cube'      => esc_html__( 'Cube', 'kingcomposer-seosight' ),
							'coverflow' => esc_html__( 'Coverflow', 'kingcomposer-seosight' ),
							'flip'      => esc_html__( 'Flip', 'kingcomposer-seosight' ),
						),
					),
					array(
						'name'        => 'loop',
						'label'       => esc_html__( 'Loop slides', 'kingcomposer-seosight' ),
						'type'        => 'toggle',
						'description' => esc_html__( 'Enable continuous loop mode', 'kingcomposer-seosight' ),
						'value'       => 'no',
					),
					array(
						'name'        => 'autoscroll',
						'label'       => esc_html__( 'Autoslide', 'kingcomposer-seosight' ),
						'type'        => 'toggle',
						'description' => esc_html__( 'Automatic auto scroll slides', 'kingcomposer-seosight' ),
						'value'       => 'no',
					),
					array(
						'name'     => 'time',
						'label'    => esc_html__( 'Delay between scroll', 'kingcomposer-seosight' ),
						'type'     => 'number_slider',
						'options'  => array(
							'min'        => 1,
							'max'        => 30,
							'unit'       => 'sec',
							'show_input' => true
						),
						'value'    => '5',
						'relation' => array(
							'parent'    => 'autoscroll',
							'show_when' => 'yes'
						)
					),
					array(
						'name'        => 'el_class',
						'label'       => esc_html__( 'Extra class', 'kingcomposer-seosight' ),
						'type'        => 'text',
						'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'kingcomposer-seosight' ),
					),
				)
			),
		)
	);
}