<?php
/*
Extension Name: Animated counters
Extension Preview: -
Description:
Version: 1.0
Author: Crumina
Author URI: https://wpcode.pro/
*/

if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

$live_tmpl   = KC_SEOSIGHT_ADDONS_PL_PATH . '/shortcodes/live_editor/';
$images_path = KC_SEOSIGHT_ADDONS_PL_URL . '/images/';

if ( function_exists( 'kc_add_map' ) ) {
	kc_add_map(
	// Buttons
		array(
			'crum_counter' => array(
				'name'        => esc_html__( 'Counter Box', 'kingcomposer-seosight' ),
				'icon'        => 'kc-crum-icon kc-crum-icon-counter-box',
				'category'    => esc_html__( 'SeoSight', 'kingcomposer-seosight' ),
				'live_editor' => $live_tmpl . 'crum_counter.tpl',
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'layout',
							'label'       => esc_html__( 'Select layout', 'kingcomposer-seosight' ),
							'type'        => 'radio_image',
							'options'     => array(
								'default' => $images_path . 'counter-on.png',
								'modern'  => $images_path . 'counter-top.png',
							),
							'value'       => 'default',
							'description' => esc_html__( 'Select format of module', 'kingcomposer-seosight' ),
						),
						array(
							'type'        => 'toggle',
							'name'        => 'icon_show',
							'label'       => esc_html__( 'Display Icon', 'kingcomposer-seosight' ),
							'description' => esc_html__( 'Display icon in box counter', 'kingcomposer-seosight' )
						),
						array(
							'type'        => 'icon_picker',
							'label'       => esc_html__( 'Select Icon', 'kingcomposer-seosight' ),
							'value'       => 'et-puzzle',
							'description' => esc_html__( 'Choose an icon to display', 'kingcomposer-seosight' ),
							'name'        => 'icon',
							'relation'    => array(
								'parent'    => 'icon_show',
								'show_when' => array( 'yes' )
							)
						),
						array(
							'type'        => 'text',
							'label'       => esc_html__( 'Targeted number', 'kingcomposer-seosight' ),
							'name'        => 'number',
							'description' => esc_html__( 'The targeted number to count up to (From zero).', 'kingcomposer-seosight' ),
							'admin_label' => true,
							'value'       => '100'
						),
						array(
							'type'        => 'text',
							'name'        => 'units',
							'label'       => esc_html__( 'Units', 'kingcomposer-seosight' ),
							'description' => esc_html__( 'Type unit near counter numbers ( % , + , etc. )', 'kingcomposer-seosight' )
						),
						array(
							'type'        => 'text',
							'label'       => esc_html__( 'Label', 'kingcomposer-seosight' ),
							'name'        => 'label',
							'description' => esc_html__( 'The text description of the counter.', 'kingcomposer-seosight' ),
							'admin_label' => true,
							'value'       => 'Percent number'
						),
						array(
							'type'        => 'toggle',
							'name'        => 'line_show',
							'label'       => esc_html__( 'Title underline', 'kingcomposer-seosight' ),
							'description' => esc_html__( 'Underline Title Text', 'kingcomposer-seosight' )
						),
						array(
							'name'        => 'wrap_class',
							'label'       => esc_html__( 'Extra class', 'kingcomposer-seosight' ),
							'type'        => 'text',
							'description' => esc_html__( 'If you wish to style a particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'kingcomposer-seosight' ),
						)
					),
					'styling' => array(
						array(
							'name'    => 'css_custom',
							'type'    => 'css',
							'options' => array(
								array(
									'screens'                             => "any,1024,999,767,479",
									esc_html__( 'Text', 'kingcomposer-seosight' )      => array(
										array(
											'property' => 'color',
											'label'    => 'Color',
											'selector' => '.counter-title'
										),
										array(
											'property' => 'font-family',
											'label'    => 'Font Family',
											'selector' => '.counter-title'
										),
										array(
											'property' => 'font-size',
											'label'    => 'Font Size',
											'selector' => '.counter-title'
										),
										array(
											'property' => 'font-weight',
											'label'    => 'Font Weight',
											'selector' => '.counter-title'
										),
									),
									esc_html__( 'Number', 'kingcomposer-seosight' )    => array(
										array(
											'property' => 'color',
											'label'    => 'Color',
											'selector' => '.counter-numbers'
										),
										array(
											'property' => 'font-family',
											'label'    => 'Font Family',
											'selector' => '.counter-numbers'
										),
										array(
											'property' => 'font-size',
											'label'    => 'Font Size',
											'selector' => '.counter-numbers'
										),
										array(
											'property' => 'font-weight',
											'label'    => 'Font Weight',
											'selector' => '.counter-numbers'
										),
									),
									esc_html__( 'Icon', 'kingcomposer-seosight' )      => array(
										array(
											'property' => 'color',
											'label'    => 'Color Icon ',
											'selector' => '.element-icon i'
										),
										array(
											'property' => 'font-size',
											'label'    => 'Size Icon',
											'selector' => '.element-icon i'
										),
										array(
											'property' => 'background-color',
											'label'    => 'Background Color',
											'selector' => '.element-icon'
										),
										array(
											'property' => 'padding',
											'label'    => 'Padding',
											'selector' => '.element-icon'
										),
										array(
											'property' => 'margin',
											'label'    => 'Margin',
											'selector' => '.element-icon'
										),
										array(
											'property' => 'border-radius',
											'label'    => 'Border Radius',
											'selector' => '.element-icon'
										),
										array(
											'property' => 'border',
											'label'    => 'Border',
											'selector' => '.element-icon'
										),
									),
									esc_html__( 'Delimiter', 'kingcomposer-seosight' ) => array(
										array(
											'property' => 'background-color',
											'label'    => 'Color',
											'selector' => '.counter-line *'
										),
									),
									esc_html__( 'Box Style', 'kingcomposer-seosight' ) => array(
										array( 'property' => 'text-align', 'label' => 'Text Align' ),
										array( 'property' => 'padding', 'label' => 'Padding' ),
										array( 'property' => 'margin', 'label' => 'Margin' ),
									)
								)
							)
						)
					),
					'animate' => array(
						array(
							'name' => 'animate',
							'type' => 'animate'
						)
					),
				)
			),
		)
	);
}