<?php
/*
Extension Name: Buttons
Extension Preview: -
Description:
Version: 1.0
Author: Crumina
Author URI: https://wpcode.pro/
*/

if ( ! defined( 'ABSPATH' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	exit;
}

$live_tmpl   = KC_SEOSIGHT_ADDONS_PL_PATH . '/shortcodes/live_editor/';
$images_path = KC_SEOSIGHT_ADDONS_PL_URL . '/images/';

if ( function_exists( 'kc_add_map' ) ) {
	kc_add_map(
	// Buttons
		array(
			'crum_chartjs' => array(
				'name'        => esc_html__( 'Chart JS module', 'kingcomposer-seosight' ),
				'icon'        => 'kc-icon-pie',
				'category'    => esc_html__( 'SeoSight', 'kingcomposer-seosight' ),
				'live_editor' => $live_tmpl . 'crum_chartjs.tpl',
				'assets'      =>
					array(
						'scripts' =>
							array(
								'chart-js' => '', // Leave empty to call built-in assets
							),
					),
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'chart_type',
							'label'       => esc_html__( 'Chart type', 'kingcomposer-seosight' ),
							'type'        => 'radio_image',
							'description' => '',
							'options'     => array(
								'doughnut'  => $images_path . 'doughnut-chart.png',
								'pie'       => $images_path . 'pie-chart.png',
								'polarArea' => $images_path . 'polar-area-chart.png',
								'line'      => $images_path . 'line-chart.png',
								/*'radar'     => $images_path . 'radar-chart.png',*/
								'bar'       => $images_path . 'bar-chart.png',
							)
						),
						array(
							'name'        => 'hide_labels',
							'label'       => esc_html__( 'Hide Labels ?', 'kingcomposer-seosight' ),
							'type'        => 'toggle',
							'description' => esc_html__( 'Hide chart legend labels', 'kingcomposer-seosight' )
						),
						array(
							'type'    => 'group',
							'label'   => esc_html__( 'Chart options', 'kingcomposer-seosight' ),
							'name'    => 'options',
							'options' => array( 'add_text' => esc_html__( 'Add new data', 'kingcomposer-seosight' ) ),
							'params'  => array(
								array(
									'type'        => 'text',
									'label'       => esc_html__( 'Label', 'kingcomposer-seosight' ),
									'name'        => 'label',
									'description' => esc_html__( 'Enter text used as title of the bar.', 'kingcomposer-seosight' ),
									'admin_label' => true,
								),
								array(
									'type'        => 'crum-number',
									'label'       => esc_html__( 'Value', 'kingcomposer-seosight' ),
									'name'        => 'value',
									'description' => esc_html__( 'Enter targeted value', 'kingcomposer-seosight' ),
									'admin_label' => true,
									'options'     => array(
										'min' => 1,
										'max' => 100,
									),
									'value'       => '80'
								),
								array(
									'type'        => 'color_picker',
									'label'       => esc_html__( 'Color', 'kingcomposer-seosight' ),
									'name'        => 'prob_color',
									'description' => esc_html__( 'Customized color.', 'kingcomposer-seosight' ),
								),
							),
						),
						array(
							'type'        => 'text',
							'label'       => esc_html__( 'Wrapper class name', 'kingcomposer-seosight' ),
							'name'        => 'wrap_class',
							'description' => esc_html__( 'Custom class for wrapper of the shortcode widget.', 'kingcomposer-seosight' ),
						)
					),
					'styling' => array(
						esc_html__( 'Text', 'kingcomposer-seosight' ) => array(
							array(
								'property' => 'color',
								'label'    => 'Color',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
							array(
								'property' => 'font-family',
								'label'    => 'Font Family',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
							array(
								'property' => 'font-size',
								'label'    => 'Font Size',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
							array(
								'property' => 'font-weight',
								'label'    => 'Font Weight',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
							array(
								'property' => 'line-height',
								'label'    => 'Line Height',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
							array(
								'property' => 'text-transform',
								'label'    => 'Text Transform',
								'selector' => '.points-item-count, .points-item-count .c-gray'
							),
						),
					),
					'animate' => array(
						array(
							'name' => 'animate',
							'type' => 'animate'
						)
					),
				)
			),
		)
	);
}