<?php
/**
 * Plugin Name: KingComposer Seosight
 * Description: Seosight addons for Kingcomposer
 * Plugin URI:  https://crumina.net/
 * Version:     1.4
 * Author:
 * Author URI:  https://crumina.net/
 * Text Domain: kingcomposer-seosight
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Verify KingKomposer Extended license.
define( 'KC_LICENSE', 'cotqi27p-3esf-2rv6-ogzf-lspn-i25jk11s1brl' );

if ( ! defined( 'KC_SEOSIGHT_ADDONS_PL_PATH' ) ) {
	define( 'KC_SEOSIGHT_ADDONS_PL_PATH', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'KC_SEOSIGHT_ADDONS_PL_URL' ) ) {
	define( 'KC_SEOSIGHT_ADDONS_PL_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'KC_SEOSIGHT_ADDONS_PL_FILE' ) ) {
	define( 'KC_SEOSIGHT_ADDONS_PL_FILE', __FILE__ );
}

/**
 * Main KingComposer Seosight Class
 *
 * The main class that initiates and runs the plugin.
 *
 * @since 1.0.0
 */
final class KingComposer_Seosight {
	private static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function __construct() {

		// Check requirements
		if ( ! $this->check_requirements() ) {
			return;
		}

		/*
		* KingComposer editor additional hooks and actions.
		*/
		add_action( 'init', array( $this, 'seosight_kingcomposer_modifications' ), 999 );
		add_action( 'init', array( $this, 'kc_seosight_exclude_kc_section_search' ), 99 );

		add_action( 'admin_enqueue_scripts', array( $this, 'kc_seosight_customizations' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'kc_seosight_yoast_kc_compitablity' ) );

		add_filter( 'kc_add_map', array( $this, 'kc_seosight_custom_live_shortcode_filter' ), 0, 2 );
		add_filter( 'shortcode_kc_row', array( $this, 'kc_seosight_include_youtube_api_js' ) );
		add_filter( 'shortcode_kc_row', array( $this, 'kc_seosight_row_animation_filter' ), 99 );

		add_action( "wp_ajax_crumina_yoast_kc_get_content", array( $this, 'kc_seosight_yoast_kc_get_content' ) );
		add_action( "wp_ajax_nopriv_crumina_yoast_kc_get_content", array( $this, 'kc_seosight_yoast_kc_get_content' ) );

		add_filter( 'fw_ext_ajax_portfolio_kc_shortcode', array(
			$this,
			'kc_seosight_ajax_portfolio_kc_shortcode'
		), 99 );
		add_filter( 'fw_ext_ajax_portfolio_kc_shortcode_default', array(
			$this,
			'kc_seosight_ajax_portfolio_kc_shortcode_default'
		), 99 );

		add_filter( 'upload_mimes', array($this, 'kc_seosight_svg_mime_type') );
	}

	public function kc_seosight_svg_mime_type( $mimes = array() ) {
		$mimes[ 'svg' ]	 = 'image/svg+xml';
		$mimes[ 'svgz' ] = 'image/svg+xml';
		return $mimes;
	}

	private function check_requirements() {
		if ( ! in_array( 'kingcomposer/kingcomposer.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			add_action( 'admin_notices', array( $this, 'seosight_required_plugin_notice' ) );

			return false;
		}

		$theme = wp_get_theme(); // gets the current theme
		if ( 'Seosight' != $theme->name && 'Seosight' != $theme->parent_theme ) {
			add_action( 'admin_notices', array( $this, 'seosight_required_theme_notice' ) );

			return false;
		}

		return true;
	}

	public function seosight_required_theme_notice() {
		?>
        <div class="notice notice-error">
            <p>
				<?php
				printf( __( '<b>KingComposer Seosight</b> is enabled but not effective. It requires %s in order to work.', 'kingcomposer-seosight' ), '<a href="https://seosight.crumina.net/" target="_blank">Seosight</a>' );
				?>
            <p>
        </div>
		<?php
	}

	public function seosight_required_plugin_notice() {
		?>
        <div class="notice notice-error">
            <p>
				<?php
				printf( __( '<b>KingComposer Seosight</b> is enabled but not effective. It requires %s in order to work.', 'kingcomposer-seosight' ), '<a href="https://wordpress.org/plugins/kingcomposer/" target="_blank">King Composer</a>' );
				?>
            <p>
        </div>
		<?php
	}

	public function kc_seosight_customizations( $hook ) {
		if ( 'post.php' !== $hook ) {
			return;
		}
		wp_enqueue_style( 'seosight-kc-admin', plugin_dir_url( __FILE__ ) . '/css/seosight-kc.css', false, 1, 'all' );
		wp_enqueue_script( 'pikaday', plugin_dir_url( __FILE__ ) . '/js/pikaday.js' );
	}

	// Theme modifcations and new modules
	public function seosight_kingcomposer_modifications() {
		if ( function_exists( 'determine_locale' ) ) {
			$locale = determine_locale();
		} else {
			// @todo Remove when start supporting WP 5.0 or later.
			$locale = is_admin() ? get_user_locale() : get_locale();
		}

		load_textdomain( 'kingcomposer-seosight', WP_LANG_DIR . '/kingcomposer-seosight/kingcomposer-seosight-' . $locale . '.mo' );
		load_plugin_textdomain( 'kingcomposer-seosight', false, plugin_basename( dirname( KC_SEOSIGHT_ADDONS_PL_FILE ) ) . '/languages' );

		global $kc;
		//add new parameters for composer
		$kc->add_param_type( 'html-full', 'kc_seosight_html_field' );
		$kc->add_param_type( 'crum-number', 'kc_seosight_number_field' );
		$kc->add_param_type( 'crum_date_picker', 'kc_seosight_date_field' );

		$kc->set_template_path( plugin_dir_path( __FILE__ ) . KDS . 'shortcodes' . KDS );

		// Add custom icon pack.
		if ( function_exists( 'kc_add_icon' ) ) {
			kc_add_icon( plugin_dir_url( __FILE__ ) . '/css/seotheme.css' );
		}

		$live_tmpl   = plugin_dir_path( __FILE__ ) . '/shortcodes/live_editor/';
		$images_path = plugin_dir_url( __FILE__ ) . '/images/';


		/* Row options modifications */
		$kc->remove_map_param( 'kc_row', 'animate', 'animate' );

		$kc->update_map( 'kc_row', 'live_editor', $live_tmpl . 'crum_row.tpl' );

		$kc->add_map_param( 'kc_row', array(
			'name'        => 'row_animation',
			'label'       => esc_html__( 'Row animation effect on scroll', 'kingcomposer-seosight' ),
			'type'        => 'radio_image',
			'options'     => array(
				'your-score'           => $images_path . 'animation-1.png',
				'background-mountains' => $images_path . 'animation-2.png',
				'testimonial-slider'   => $images_path . 'animation-3.png',
				'subscribe'            => $images_path . 'animation-4.png',
				'our-vision'           => $images_path . 'animation-5.png',
			),
			'description' => esc_html__( 'Animations will be hidden in frontend editor for better performance.', 'kingcomposer-seosight' )
		), 1, 'animate' );

		$kc->add_map_param( 'kc_row', array(
			'name'        => 'row_animation_custom',
			'label'       => esc_html__( 'Upload custom animation image', 'kingcomposer-seosight' ),
			'type'        => 'attach_image_url',
		), 1, 'animate' );

		$kc->add_map_param( 'kc_row', array(
			'name'        => 'row_animation_custom_position',
			'label'       => esc_html__( 'Custom animation image position', 'kingcomposer-seosight' ),
			'type'        => 'select',
			'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
				'b_c' => esc_html__( 'Bottom center', 'kingcomposer-seosight' ),
				't_c' => esc_html__( 'Top center', 'kingcomposer-seosight' ),
				'c_c' => esc_html__( 'Center center', 'kingcomposer-seosight' ),
			),
			'value' => 'b_c',
		), 1, 'animate' );

		$kc->add_map_param( 'kc_row', array(
			'name'        => 'row_text_color',
			'label'       => esc_html__( 'Text color', 'kingcomposer-seosight' ),
			'type'        => 'color_picker',
			'description' => esc_html__( 'Primary color option for inner text. Can be changed in any inner module.', 'kingcomposer-seosight' )
		), 1, 'styling' );

		$kc->add_map_param( 'kc_row', array(
			'name'  => 'enable_particle_bg',
			'label' => esc_html__( 'Enable particle background effect?', 'kingcomposer-seosight' ),
			'type'  => 'toggle',
			'value' => 'no'
		), 15 );

		$kc->add_map_param( 'kc_row', array(
			'name'  => 'particle_bg_color',
			'label' => esc_html__( 'Particles color', 'kingcomposer-seosight' ),
			'type'  => 'color_picker',
			'relation' => array(
				'parent' => 'enable_particle_bg',
				'show_when' => 'yes'
			),
		), 16 );

		$kc->add_map_param( 'kc_row', array(
			'name'  => 'particle_shape',
			'label' => esc_html__( 'Particles shape', 'kingcomposer-seosight' ),
			'type'  => 'select',
			'options' => array(  // THIS FIELD REQUIRED THE PARAM OPTIONS
				'star' => esc_html__( 'Star', 'kingcomposer-seosight' ),
				'circle' => esc_html__( 'Circle', 'kingcomposer-seosight' ),
				'edge' => esc_html__( 'Edge', 'kingcomposer-seosight' ),
				'triangle' => esc_html__( 'Triangle', 'kingcomposer-seosight' ),
				'polygon' => esc_html__( 'Polygon', 'kingcomposer-seosight' ),
			),
			'value' => 'star',
			'relation' => array(
				'parent' => 'enable_particle_bg',
				'show_when' => 'yes'
			),
		), 17 );

		// Remove some default modules.
		if ( function_exists( 'kc_remove_map' ) ) {
			kc_remove_map( 'kc_nested' );
			kc_remove_map( 'kc_box' );
			kc_remove_map( 'kc_coundown_timer' );
			kc_remove_map( 'kc_pricing' );
			kc_remove_map( 'kc_image_hover_effects' );
			kc_remove_map( 'kc_creative_button' );
			kc_remove_map( 'kc_tooltip' );
			kc_remove_map( 'kc_blog_posts' );
			kc_remove_map( 'kc_post_type_list' );
			kc_remove_map( 'kc_creative_button' );
			kc_remove_map( 'kc_flip_box' );
			kc_remove_map( 'kc_progress_bars' );
			kc_remove_map( 'kc_pie_chart' );
			kc_remove_map( 'kc_button' );
			kc_remove_map( 'kc_title' );
			kc_remove_map( 'kc_accordion' );
			kc_remove_map( 'kc_team' );
			kc_remove_map( 'kc_single_image' );
			kc_remove_map( 'kc_dropcaps' );
			kc_remove_map( 'kc_google_maps' );
			kc_remove_map( 'kc_video_play' );
			kc_remove_map( 'kc_counter_box' );
			kc_remove_map( 'kc_icon' );
			kc_remove_map( 'kc_feature_box' );
			kc_remove_map( 'kc_testimonial' );
			kc_remove_map( 'kc_call_to_action' );
			kc_remove_map( 'kc_carousel_post' );
		}

		// Small text shortcodes. Without dedicated blocks.
		if ( function_exists( 'kc_add_map' ) ) {
			kc_add_map(
				array(
					'tip' => array(
						'name'        => 'Tooltip',
						'system_only' => true,
						'assets'      =>
							array(
								'styles'  =>
									array(
										'tippy-css' => plugin_dir_url( __FILE__ ) . '/css/tippy.css',
									),
								'scripts' =>
									array(
										'tippy-js' => plugin_dir_url( __FILE__ ) . '/js/tippy.min.js',
									),
							),
						'params'      => array(
							'general' => array(
								array(
									'name'  => 'text',
									'label' => esc_html__( 'Text', 'kingcomposer-seosight' ),
									'type'  => 'text',
								),
							),
						)
					),
				)
			);
		}

		$modules_path = plugin_dir_path( __FILE__ ) . 'modules';

		// activate addons one by one from modules directory
		foreach ( glob( $modules_path . "/*.php" ) as $module ) {
			load_template( $module, true );
		}

		function seosight_dequeue_kingcomposer_front_css( $styles ) {

			unset( $styles['kc-general'] );

			return $styles;
		}

		add_filter( 'kc_enqueue_styles', 'seosight_dequeue_kingcomposer_front_css', 10, 1 );

		/*        add_action( 'admin_init', '_action_seosight_fw_ext_page_builder_remove_support' );

				function _action_seosight_fw_ext_page_builder_remove_support() {
					$extensions = get_option( 'fw_active_extensions' );
					if ( isset( $extensions[ 'page-builder' ] ) ) {
						unset( $extensions[ 'page-builder' ] );
						update_option( 'fw_active_extensions', $extensions );
					}
				}*/

		add_action( 'wp_enqueue_scripts', '_action_seosight_kingcomposer_extend_styles' );
		function _action_seosight_kingcomposer_extend_styles() {
			wp_enqueue_style( 'kingcomposer-extend', plugin_dir_url( __FILE__ ) . '/css/kingcomposer.css' );
		}

		load_template( plugin_dir_path( __FILE__ ) . 'extensions/contact-form-7.php', true );
		load_template( plugin_dir_path( __FILE__ ) . 'extensions/media.php', true );
		load_template( plugin_dir_path( __FILE__ ) . 'extensions/forms.php', true );

		// Plain HTML field for composer admin panel.
		function kc_seosight_html_field() {
			echo '<div id="{{data.name}}" class="kc-param">{{{data.value}}}</div>';
		}

		// Number field for composer admin panel.
		function kc_seosight_number_field() {
			echo '<input name="{{data.name}}" class="kc-param" value="{{data.value}}" type="number" min="1" />';
		}

		// Proper date field for composer admin panel.
		function kc_seosight_date_field() {
			?>
            <input name="{{data.name}}" class="kc-param" value="{{data.value}}" type="text"/>
            <#
            data.callback = function( wrp, $ ){
            var d = new Pikaday(
            {
            field: wrp.find('.kc-param').get(0),
            firstDay: 1,
            formatStrict:true,
            format: 'L',
            minDate: false,
            maxDate: false,
            yearRange: [1900,2030],
            format: 'DD/MM/YYYY'
            });
            }
            #>
			<?php

		}
	}

	// Live editor template for row shortcode.
	public function kc_seosight_custom_live_shortcode_filter( $atts, $base ) {

		$live_tmpl = plugin_dir_path( __FILE__ ) . 'shortcodes/live_editor/';
		if ( $base == 'kc_row' ) {
			$atts['live_editor'] = $live_tmpl . 'crum_row.php';
		}

		return $atts; // required
	}

	/**
	 * Enable YouTube Video BG for our KingComposer Rows
	 */
	public function kc_seosight_include_youtube_api_js( $atts ) {
		if ( isset( $atts['video_bg'] ) && $atts['video_bg'] == 'yes' ) {
			wp_register_script( 'kc-youtube-iframe-api', 'https://www.youtube.com/iframe_api', null, '', true );
			wp_enqueue_script( 'kc-youtube-iframe-api' );
		}

		return $atts;
	}

	public function kc_seosight_row_animation_filter( $atts ) {
		if ( ! empty( $atts['row_animation'] ) ) {
			wp_enqueue_script( 'scrollmagic-velocity' );
		}
	}

	/**
	 * Exclude kc Section Post type from search query
	 */
	public function kc_seosight_exclude_kc_section_search() {
		global $wp_post_types;
		if ( post_type_exists( 'kc-section' ) ) {
			$wp_post_types['kc-section']->exclude_from_search = true;
		}
	}

	public function kc_seosight_yoast_kc_compitablity() {
		global $pagenow, $typenow;

		$post_ID = filter_input( INPUT_GET, 'post', FILTER_VALIDATE_INT );
		if ( ! defined( 'WPSEO_VERSION' ) || ! $post_ID ) {
			return;
		}

		if ( empty( $typenow ) ) {
			$post    = get_post( $_GET['post'] );
			$typenow = $post->post_type;
		}
		if ( ( $pagenow == 'post.php' && $typenow == 'page' ) || ( $pagenow == 'post-new.php' && $typenow == 'page' ) ) {
			wp_enqueue_script( 'crum-yoast-seo', plugin_dir_url( __FILE__ ) . '/js/king-yoast.js', array( 'jquery' ), '1', true );

			wp_localize_script( 'crum-yoast-seo', 'cruminaKingYoastConf', array(
				'ajaxUrl' => admin_url( 'admin-ajax.php' ),
				'action'  => 'crumina_yoast_kc_get_content',
				'post_ID' => $post_ID
			) );
		}
	}

	public function kc_seosight_yoast_kc_get_content() {
		global $allowedposttags;
		$post_ID = filter_input( INPUT_POST, 'post_ID', FILTER_VALIDATE_INT );

		if ( $post_ID ) {
			$content = get_post_field( 'post_content', $post_ID );

			$builder_meta = get_post_meta( $post_ID, 'kc_data', true );

			if ( function_exists( 'kc_do_shortcode' ) && isset( $builder_meta['mode'] ) && $builder_meta['mode'] === 'kc' ) {
				$content = kc_do_shortcode( $content );

				$content = preg_replace( "/<style.+?<\/style>/", "", $content );
				$content = preg_replace( "/<script.+?<\/script>/", "", $content );
				$content = preg_replace( "/[\s\r\n]+/", " ", $content );

				echo strip_tags( $content, '<p><a><ul><li><ol><h1><h2><h3><h4><h5><h6><img><em><strong><blockquote><del><cite><i><strike><pre><code><acronym>' );
			}
		}

		die();
	}

	public function kc_seosight_ajax_portfolio_kc_shortcode( $options ) {

		$options['ajax-portfolio']['params'][] = array(
			'label' => esc_html__( 'Show 2 portfolio items in first row', 'seosight' ),
			'name'  => 'two_portfolio_items',
			'type'  => 'toggle',
			'value' => 'yes',
		);

		return $options;
	}

	public function kc_seosight_ajax_portfolio_kc_shortcode_default( $options ) {
		$options['two_portfolio_items'] = 'yes';

		return $options;
	}
}

KingComposer_Seosight::instance();