<?php
/**
 * Note: All the variables are under the ThemeMountain namespace.
 * Anything decalred here are under the ThemeMountain namespace but not that of global.
 */
namespace ThemeMountain;

$thememountain_use_sidebar = TM_TemplateServices::get_current_page_data(array('options','tm_use_sidebar'));
$thememountain_sticky_sidebar = TM_TemplateServices::get_current_page_data(array('options','tm_sticky_sidebar'));
$thememountain_sticky_sidebar_extra_space_top = TM_TemplateServices::get_current_page_data(array('options','tm_sticky_sidebar_extra_space_top'));
$thememountain_add_background_to_sidebar = TM_TemplateServices::get_current_page_data(array('options','tm_add_background_to_sidebar'));

// TM_TemplateServices runtime variable cache used to hand over tm_use_sidebar settings.
TM_TemplateServices::set_runtime_variable_cache( 'thememountain_use_sidebar', $thememountain_use_sidebar);
TM_TemplateServices::set_runtime_variable_cache( 'thememountain_sticky_sidebar', $thememountain_sticky_sidebar);
TM_TemplateServices::set_runtime_variable_cache( 'thememountain_sticky_sidebar_extra_space_top', $thememountain_sticky_sidebar_extra_space_top);
TM_TemplateServices::set_runtime_variable_cache( 'thememountain_add_background_to_sidebar', $thememountain_add_background_to_sidebar);

// Add Background to Post Content option
$thememountain_add_background_to_post_content = TM_TemplateServices::get_current_page_data(array('options','tm_add_background_to_post_content'));

// excerpt top padding
$thememountain_excerpt_top_padding = TM_TemplateServices::get_current_page_data(array('options','tm_excerpt_top_padding'));
$thememountain_padding_top = (!is_null($thememountain_excerpt_top_padding) && $thememountain_excerpt_top_padding !== 'inherit' ) ? ' pt-'.$thememountain_excerpt_top_padding : '';

$thememountain_hide_excerpt_in_loop = TM_TemplateServices::get_current_page_data(array('options','tm_hide_excerpt_in_loop'));

if($thememountain_use_sidebar === 'left') {
	$thememountain_col_class = ' width-9 push-3';
} else if ($thememountain_use_sidebar === 'right') {
	$thememountain_col_class = ' width-9';
} else {
	$thememountain_col_class = ' width-10 offset-1';
}

/**
 * post_rollover_background_color
 */
$thememountain_post_rollover_background_color_wide_grids = TM_TemplateServices::get_current_page_data(array('options','tm_post_rollover_background_color_wide_grids'));
$thememountain_post_rollover_background_color_wide_grids = TM_TemplateServices::tm_fromRGBtoHEX($thememountain_post_rollover_background_color_wide_grids);
?>
<div class="section-block clearfix no-padding-bottom post-articles<?php echo esc_attr($thememountain_padding_top); ?>">
	<?php get_template_part('block-parts/post_recent_post_title'); ?>
	<div class="row">
		<div class="column content-inner blog-regular<?php echo esc_attr($thememountain_col_class); ?>">
<?php if (have_posts()) :
	while (have_posts()) :
		the_post();
			$thememountain_runtime_post_variables_array = TM_TemplateServices::get_runtime_page_data('',TRUE);
			$thememountain_runtime_post_date = $thememountain_runtime_post_variables_array['post_date'];
			$thememountain_runtime_author_posts_url = $thememountain_runtime_post_variables_array['author_posts_url'];
			$thememountain_runtime_nickname = $thememountain_runtime_post_variables_array['nickname'];
			$thememountain_runtime_thumbnail_image_src = (array_key_exists('thumbnail_image_src', $thememountain_runtime_post_variables_array)) ? $thememountain_runtime_post_variables_array['thumbnail_image_src'] : NULL;
			$thememountain_runtime_cat_name = (array_key_exists('cat_name', $thememountain_runtime_post_variables_array)) ? $thememountain_runtime_post_variables_array['cat_name'] : NULL;
			// video
			$thememountain_runtime_use_video_for_featured = (is_array($thememountain_runtime_post_variables_array['options']) && array_key_exists('tm_use_video_for_featured', $thememountain_runtime_post_variables_array['options'])) ? $thememountain_runtime_post_variables_array['options']['tm_use_video_for_featured'] : FALSE;
			// audio
			$thememountain_runtime_use_audio_for_featured = (array_key_exists('tm_use_audio_for_featured', $thememountain_runtime_post_variables_array['options'])) ? $thememountain_runtime_post_variables_array['options']['tm_use_audio_for_featured'] : FALSE;
			// cat ID
			$thememountain_runtime_cat_ID = (isset($thememountain_runtime_post_variables_array['cat_ID'])) ? $thememountain_runtime_post_variables_array['cat_ID'] : NULL;

			// .post-content / .content-outer
			$thememountain_grid_layout_box_article_background_color_item = (array_key_exists('tm_grid_layout_box_article_background_color_item', $thememountain_runtime_post_variables_array['options']) && $thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_background_color_item'] !== '') ? 'background-color:'.$thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_background_color_item'].';' : '';
			// .post-title, .post-title a
			$thememountain_grid_layout_box_article_title_color_item = (array_key_exists('tm_grid_layout_box_article_title_color_item', $thememountain_runtime_post_variables_array['options']) && $thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_title_color_item'] !== '') ? 'color:'.$thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_title_color_item'].';' : '';
			// .post-content / .content-outer
			$thememountain_grid_layout_box_article_color_item = (array_key_exists('tm_grid_layout_box_article_color_item', $thememountain_runtime_post_variables_array['options']) && $thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_color_item'] !== '') ? 'color:'.$thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_color_item'].';' : '';
			// .post-date, .read-more
			$thememountain_grid_layout_box_article_link_color_item = (array_key_exists('tm_grid_layout_box_article_link_color_item', $thememountain_runtime_post_variables_array['options']) && $thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_link_color_item'] !== '') ? 'color:'.$thememountain_runtime_post_variables_array['options']['tm_grid_layout_box_article_link_color_item'].';' : '';
	?>
			<article <?php post_class('post'); ?>>
				<?php if( $thememountain_hide_excerpt_in_loop == FALSE ) : ?>
				<div class="post-content<?php if($thememountain_add_background_to_post_content == TRUE) echo ' with-background'; ?>">
					<?php if( $thememountain_runtime_use_video_for_featured == TRUE || $thememountain_runtime_use_audio_for_featured == TRUE) {
						get_template_part('block-parts/post_media');
					} else if( isset($thememountain_runtime_thumbnail_image_src) ) { ?>
					<div class="post-media">
						<div class="thumbnail img-scale-in" data-hover-easing="easeInOut" data-hover-speed="700"<?php if(isset($thememountain_post_rollover_background_color_wide_grids) && is_array($thememountain_post_rollover_background_color_wide_grids)) { echo " data-hover-bkg-color='".esc_attr($thememountain_post_rollover_background_color_wide_grids[0])."' data-hover-bkg-opacity='".esc_attr($thememountain_post_rollover_background_color_wide_grids[1])."'"; } ?>>
							<a class="overlay-link" href="<?php  the_permalink(); ?>">
								<?php TM_TemplateServices::generate_image_tag_from_id($thememountain_runtime_thumbnail_image_src[0], get_the_title(), TRUE); ?>
								<?php if( $thememountain_runtime_cat_name !== '' ) { ?>
								<span class="overlay-info">
									<span>
										<span>
											<?php echo esc_html($thememountain_runtime_cat_name); ?>
										</span>
									</span>
								</span>
								<?php } ?>
							</a>
						</div>
					</div>
					<?php } ?>
					<h2 class="post-title" style="<?php echo esc_attr($thememountain_grid_layout_box_article_link_color_item.$thememountain_grid_layout_box_article_background_color_item); ?>"><a href="<?php the_permalink(); ?>" style="<?php echo esc_attr($thememountain_grid_layout_box_article_link_color_item.$thememountain_grid_layout_box_article_background_color_item); ?>"><?php the_title(); ?></a></h2>
					<div class="post-info">
						<span class="post-date" style="<?php echo esc_attr($thememountain_grid_layout_box_article_title_color_item); ?>"><?php echo esc_html($thememountain_runtime_post_date); ?></span>/<span class="post-autor"><?php if($thememountain_runtime_author_posts_url) { ?> By <a href="<?php echo esc_url($thememountain_runtime_author_posts_url); ?>" ><?php } ?><?php echo esc_html($thememountain_runtime_nickname); ?><?php if($thememountain_runtime_author_posts_url) { ?></a><?php } ?></span><!-- /<span class="post-love"><a href="#" class="post-love"><span class="icon-heart"></span>768</a></span> -->
					</div>
					<?php the_excerpt(); ?>
				</div>
				<?php endif; ?>
			</article>
<?php
	endwhile;
endif;
wp_reset_postdata();
?>
		</div>
		<?php
		if($thememountain_use_sidebar == 'right' || $thememountain_use_sidebar == 'left') {
			get_sidebar();
		}
		// delete runtime variable cache
		TM_TemplateServices::delete_runtime_variable_cache('thememountain_use_sidebar');
		TM_TemplateServices::delete_runtime_variable_cache('thememountain_sticky_sidebar');
		TM_TemplateServices::delete_runtime_variable_cache('thememountain_sticky_sidebar_extra_space_top');
		TM_TemplateServices::delete_runtime_variable_cache('thememountain_add_background_to_sidebar');
		?>
	</div>
</div>