<?php
namespace ThemeMountain;

/**
 * Font settings presets.
 *
 * Loaded in TM_Customizer::__construct()
 *
 * @uses       TM_Customizer::$font_presets
 * @uses       TM_Customizer::get_registered_font_pairs_choices()
 * @see        TM_Customizer::customize_preview_js_css()
 * @see        custom-customizer-ui.js
 */
TM_Customizer::tm_add_customizer_font_pairs ( array (

	"Informal Inconsolata & Inconsolata" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Informal Hip Permanent Marker & Roboto Slab" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Permanent Marker',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Informal Elegant Nixie One & Lato" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nixie One',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nixie One',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Karla & Inconsolata" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Hip Roboto & Inconsolata" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Inconsolata',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Modern Oswald & Roboto" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Oswald',
			'variant'        => '400',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Arvo & Lato" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Arvo',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Merriweather & Muli" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Muli',
			'variant'        => "300",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Muli',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Muli',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Modern - Pt Sans & Bitter" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Sans',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Bitter',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Bitter',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Bitter',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Modern - Questrial & Alegreya" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Questrial',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual Modern - Varela Round & Noto Serif" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Varela Round',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Ovo & Quattrocento Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Ovo',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Libre Baskerville & Nunito" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Baskerville',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nunito',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nunito',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nunito',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Cardo & Libre Franklin" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cardo',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Franklin',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Franklin',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Franklin',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Goudy Bookletter 1911 & Average Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Goudy Bookletter 1911',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Neuton & Work Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Neuton',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Neuton & Work Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Neuton',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Patua One & Maven Pro" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Patua One',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Maven Pro',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Maven Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Maven Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Casual - Shrikhand & Fanwood Text" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Shrikhand',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fanwood Text',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fanwood Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fanwood Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Neutral Lato & Karla" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,input, button, .button, select, textarea,header .navigation > ul > li > a, .side-navigation > ul > li > a, .overlay-navigation > ul > li > a, .grid-filter-menu a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Neutral Simple Lato & Open Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,input, button, .button, select, textarea,header .navigation > ul > li > a, .side-navigation > ul > li > a, .overlay-navigation > ul > li > a, .grid-filter-menu a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Neutral Minimal Karla & Karla" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Neutral Agency Montserrat & Hind" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Montserrat',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,input, button, .button, select, textarea,header .navigation > ul > li > a, .side-navigation > ul > li > a, .overlay-navigation > ul > li > a, .grid-filter-menu a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Hind',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Hind',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Hind',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal Lato & Merriweather" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,header .navigation > ul > li a, .side-navigation > ul > li a, .overlay-navigation > ul > li a, .grid-filter-menu a, .post-info, .widget .post-info + a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => 'regular',
			'font-size'      => '13px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => '300italic',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal Simple Montserrat & Neuton" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Montserrat',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,header .navigation > ul > li a, .side-navigation > ul > li a, .overlay-navigation > ul > li a, .grid-filter-menu a, .post-info, .widget .post-info + a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Neuton',
			'variant'        => '300',
			'font-size'      => '16px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Neuton',
			'variant'        => '300',
			'font-size'      => '22px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Neuton',
			'variant'        => '300italic',
			'font-size'      => '22px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal Agency Montserrat & Playfair Display" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Montserrat',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1,header .navigation > ul > li a, .side-navigation > ul > li a, .overlay-navigation > ul > li a, .grid-filter-menu a, .post-info, .widget .post-info + a',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'italic',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal Elegant Playfair Display & Open Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'italic',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Neutral - Roboto Condensed Bold & Cabin Reglar" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cabin',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cabin',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cabin',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Raleway & Open Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Raleway',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Cororant Garamond & Fira Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cormorant Garamond',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fira Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fira Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fira Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Cinzel & Fauna One" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Cinzel',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fauna One',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fauna One',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Fauna One',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Old Standard TT - Rubik" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Old Standard TT',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Rubik',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Rubik',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Rubik',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant Modern - Julius Sans One & Monda" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Julius Sans One',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Monda',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Monda',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Monda',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Vollkorn & Raleway" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Vollkorn',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Raleway',
			'variant'        => "500",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Raleway',
			'variant'        => '500',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Raleway',
			'variant'        => '500',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Rufina & PT Serif" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Rufina',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Serif',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant Casual - Chivo & Crimson Text" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Chivo',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Elegant - Prata & Lato" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Prata',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal - Playfair Display & Source Sans Pro" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal - Ruda & Roboto Slab" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Ruda',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto Slab',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Formal - Lato & Catamaran" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Catamaran',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Catamaran',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Catamaran',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Roboto & Lora" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - PT Sans & Playfair Display" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Sans',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Oswald & Quattrocento" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Oswald',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Quattrocento',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Ubuntu & Open Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Ubuntu',
			'variant'        => '700',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful Casual - Source Sans Pro & Sintony" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => '900',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful Casual - Source Sans Pro & Sintony" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => '900',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Sintony',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Bree Serif & Alegreya" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Bree Serif',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Alegreya',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Anton & Signika" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Anton',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => "300",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Anton & Signika" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Anton',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => "300",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Signika',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Impactful - Eczar & Merriweather" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Eczar',
			'variant'        => '600',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Magazine - Abril Fatface & Poppins" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Abril Fatface',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Poppins',
			'variant'        => "300",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Poppins',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Poppins',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

		"Modern Impactful - Roboto & Libre Baserville" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '500',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Baskerville',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Baskerville',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Libre Baskerville',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Roboto & Playfair Display" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Roboto',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Oxygen & Noto Serif" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Oxygen',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Noto Serif',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Work Sans & Open Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Work Sans',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Open Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Nunito & PT Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Nunito',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Sans',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'PT Sans',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern Hip - Unica One & Crimson Text Roman" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Unica One',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Crimson Text',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern Elegant - Dosis & Titillium Web" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Dosis',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Titillium Web',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Titillium Web',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Titillium Web',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern Casual - Oswald & Esteban" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Oswald',
			'variant'        => '300',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Esteban',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Esteban',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Esteban',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Catamaran & Merriweather Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Catamaran',
			'variant'        => '600',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather Sans',
			'variant'        => "300",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather Sans',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Merriweather Sans',
			'variant'        => '300',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern Casual - Istock Web & Average" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Istok Web',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern Casual - Istock Web & Average" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Istok Web',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Average',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Modern - Rubik & Karla" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Rubik',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Karla',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Hip - Permanent Marker & Overpass" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Permanent Marker',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Overpass',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Overpass',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Overpass',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Hip - Slabo & Lora" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Slabo',
			'variant'        => 'regular',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Lora',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

	"Hip - Playfair Display & Source Sans" => array (
		"tm_title_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Playfair Display',
			'variant'        => '900',
			'font-size'      => '14px',
			'line-height'    => '1',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_title_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'h1, h2, h3, h4, h5, h6, .title-small, .title-medium, .title-large, .title-xlarge, .font-alt-1',
		),
		"tm_body_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => "regular",
			'font-size'      => '14px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_body_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'body, input, button, .button, select, textarea',
		),
		"tm_lead_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#666666',
		),
		"tm_lead_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => '.lead',
		),
		"tm_blockquote_font" => array(
			'type'				 => 'typography',
			'font-family'    => 'Source Sans Pro',
			'variant'        => 'regular',
			'font-size'      => '20px',
			'line-height'    => '1.8',
			'letter-spacing' => '0',
			'color'          => '#000000',
		),
		"tm_blockquote_font_target" => array(
			'type'				 => 'text',
			'css_selector'          => 'blockquote p',
		),
		"tm_font_link_color" => array(
			'type'				 => 'color',
			'color'          => '#232323',
		),
		"tm_font_link_color_hover" => array(
			'type'				 => 'color',
			'color'          => '#ff4556',
		),
	),

) ); // end array