<?php
/**
 * ThemeMountain namespace reserved for ThemeMountain Wordpress themes
 * If you do not know what namespace is, please read http://php.net/manual/en/language.namespaces.php
 */
namespace ThemeMountain {
	/**
	 * ThemeMountain parent core class providing common utility methods
	 *
	 * @package ThemeMountain
	 * @subpackage Core
	 * @since 1.0
	 */
	class TM_ThemeStrings {
		/**
		 * Configs
		 */
		/**
		 * Theme Text Domain ID.
		 * @var        string
		 */
		public static $theme_id = "thememountain-sartre";

		/**
		 * Text strings
		 */
		public static $text_strings = array ();

		/**
		 * Class Constructor Magic Method.
		 *
		 * Cache theme version, execute class setup method and add filter for option fields in the admin panel.
		 *
		 * @since 1.0
		 * @access public
		 * @uses Wordpress code wp_get_theme(), TM_ThemeServices::$theme_version, 'tm_admin_option_option_fields' filter hook of TM_admin::option_fields() in tm-plugin.
		 */
		public function __construct() {
			self::define_text_strings();
		}

		/**
		 * @since 1.0.8
		 * @access public
		 * @uses       TM_ThemeStrings::$theme_id
		 */
		public static function define_text_strings () {
			self::$text_strings['TM_CustomTagList'] = array(
				'custom_tag_class_attribute' => esc_html__('Custom Class Attribute',"thememountain-sartre"),
				'enter_class_attribute' => esc_html__('Enter Class Attribute',"thememountain-sartre"),
			);

			self::$text_strings['TM_MastheadServices'] = array(
				'by' => esc_html__('By ',"thememountain-sartre"),
				'in' => esc_html__('In ',"thememountain-sartre"),
			);

			self::$text_strings['TM_CustomCategoryPage'] = array(
				'custom_category_page' => esc_html__('Custom Category Page',"thememountain-sartre"),
				'do_not_use_custom_page' => esc_html__('Do not use custom page',"thememountain-sartre"),
				'choose_page' => esc_html__('Choose Page',"thememountain-sartre"),
			);

			self::$text_strings['TM_CustomFunctions'] = array(
				'comment_waiting_for_moderation' => esc_html__('Your comment is awaiting moderation.',"thememountain-sartre"),
				'comment_time' => esc_html__('%1$s',"thememountain-sartre"),
				'edit' => esc_html__('Edit',"thememountain-sartre"),
				'excerpt' => esc_html__('Excerpt',"thememountain-sartre"),
			);

			self::$text_strings['TM_NavMenuServices'] = array(
				'hide_navigation_menu' => esc_html__('Hide Navigation Menu',"thememountain-sartre"),
				'none' => esc_html__('None',"thememountain-sartre"),
				'please_create_a_new_menu' => esc_html__('Please create a new menu',"thememountain-sartre"),
			);

			self::$text_strings['TM_TemplateServices'] = array(
				'category_archives' => esc_html__('Category Archives: %s',"thememountain-sartre"),
				'search_results_for' => esc_html__('Search Results for: %s',"thememountain-sartre"),
				'search_more' => esc_html__('Search further.',"thememountain-sartre"),
				'all_posts_by' => esc_html__('All posts by %s',"thememountain-sartre"),
				'not_found_title_caption' => esc_html__('404 Not Found',"thememountain-sartre"),
				'results_not_found_message' => esc_html__('Please check the URL for proper spelling or capitalization. Alternatively try to search below.',"thememountain-sartre"),
				'portfolio' => esc_html__('Portfolio',"thememountain-sartre"),
				'get_category_name_and_links' => esc_html__('View all posts in %s',"thememountain-sartre"),
			);

			self::$text_strings['TM_NavMenuCustomField'] = array(
				'tm_custom_nav' => esc_html__('Register Menu Item As:',"thememountain-sartre"),
				'tm_custom_nav_none' => esc_html__('None',"thememountain-sartre"),
				'tm_custom_nav_megamenu' => esc_html__('Mega Menu Parent Link',"thememountain-sartre"),
				'tm_custom_nav_button' => esc_html__('Regular button (links to URL)',"thememountain-sartre"),
				'tm_custom_nav_icon' => esc_html__('Icon (links to URL)',"thememountain-sartre"),
				'tm_custom_nav_modalButton' => esc_html__('Modal button (links to modal)',"thememountain-sartre"),
				'tm_custom_nav_modal_aux_classes' => esc_html__('Modal Auxiliary Classes',"thememountain-sartre"),
				'tm_custom_nav_make_current_for_folio_page' => esc_html__('Make this menu item as current for ThemeMountain Folio pages',"thememountain-sartre"),

			);

			/**
			 * Navigation Location
			 */
			self::$text_strings['nav_menu_locations'] = array(
				'main_nav_menu' => esc_html__('Main Navigation Menu',"thememountain-sartre"),
				/** overlay */
				'overlay_menu'	=> esc_html__('Overlay Menu',"thememountain-sartre"),
				'overlay_secondary_menu' => esc_html__('Overlay Secondary Menu',"thememountain-sartre"),
				'overlay_social_links' => esc_html__('Overlay Social Links',"thememountain-sartre"),
				/** off canvas */
				'off_canvas_menu'	=> esc_html__('Off-Canvas Menu',"thememountain-sartre"),
				'off_canvas_secondary_menu'	=> esc_html__('Off-Canvas Secondary Menu',"thememountain-sartre"),
				'off_canvas_social_links' => esc_html__('Off-Canvas Social Links',"thememountain-sartre"),
				);

			/**
			 * Menu Style Names
			 */
			self::$text_strings['nav_menu_styles'] = array(
				'default' => esc_html__('Default',"thememountain-sartre"),
				'hamburger' => esc_html__('Hamburger',"thememountain-sartre"),
				'hide' => esc_html__('Hide Nav Menu',"thememountain-sartre"),
				'hybrid' => esc_html__('Default and Hamburger (hybrid)',"thememountain-sartre"),
				);

			/**
			 * Navigation Customizer Settings
			 * array index 0 for label and 1 for description.
			 */
			self::$text_strings['nav_menu_customizer'] = array(
				/** default menu style */
				'tm_header_navigation_alignment' => array(
					esc_html__( 'Navigation Menu Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the main navigation alignment.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_header_width' => array(
					esc_html__( 'Header Width', "thememountain-sartre" ),
					esc_html__( 'Determines the inner width of the header, defaults to fixed, 1140px.', "thememountain-sartre" ),
					esc_html__( 'Fixed Width', "thememountain-sartre" ),
					esc_html__( 'Full Width', "thememountain-sartre" ),
					),
				'tm_header_secondary_navigation_alignment' => array(
					esc_html__( 'Secondary Navigation Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the secondary navigation(buttons, icons, cart etc.) alignment.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				// Top Header Navigation Color
				'tm_page_header_nav_default_menu_top_color' => array(
					esc_html__( 'Top Header Navigation Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_top_color_hover' => array(
					esc_html__( 'Top Header Navigation Hover Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_top_color_current' => array(
					esc_html__( 'Top Header Navigation Current Color', "thememountain-sartre" ),
					),
				// Header Nenu Menu Body
				'tm_page_header_nav_default_menu_body_color' => array(
					esc_html__( 'Body Header Navigation Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_body_color_hover' => array(
					esc_html__( 'Body Header Navigation Hover Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_body_color_active' => array(
					esc_html__( 'Body Header Navigation Active Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_sub_bkg_color' => array(
					esc_html__( 'Sub Menu Background Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_sub_link_color' => array(
					esc_html__( 'Sub Menu Link Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_sub_link_color_hover' => array(
					esc_html__( 'Sub Menu Link Hover Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_sub_link_color_active' => array(
					esc_html__( 'Sub Menu Link Active Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_default_menu_sub_link_background_color_hover' => array(
					esc_html__( 'Sub Menu Link & Active Background Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_mega_submenu_border_color' => array(
					esc_html__( 'Mega Sub Menu Border Color', "thememountain-sartre" ),
					),
				'tm_page_header_default_menu_top_bkg_color' => array(
					esc_html__( 'Top Header Background Color', "thememountain-sartre" ),
					),
				'tm_page_header_default_menu_body_bkg_color' => array(
					esc_html__( 'Body Header Background Color', "thememountain-sartre" ),
					esc_html__( 'The background color the header receives as the user begins to scroll the page.', "thememountain-sartre" ),
					),
				/** hamburger menu style */
				'tm_page_header_hamburger_menu_bkg_color' => array(
					esc_html__( 'Hamburger Navigation Background Color', "thememountain-sartre" ),
					),
				'tm_page_header_hamberger_menu_icon_color' => array(
					esc_html__( 'Hamburger Navigation Color', "thememountain-sartre" ),
					),
				'tm_page_header_hamberger_menu_icon_hover_color' => array(
					esc_html__( 'Hamburger Navigation Hover Color', "thememountain-sartre" ),
					),
				'tm_page_header_hamberger_mobile_header_background_color' => array(
					esc_html__( 'Hamburger Mobile Header Background Color', "thememountain-sartre" ),
					),
				'tm_page_header_hamberger_mobile_header_border_color' => array(
					esc_html__( 'Mobile Header Border Color', "thememountain-sartre" ),
					),
				/* Logo Background Color */
				'tm_page_header_logo_background_color' => array(
					esc_html__( 'Logo Background Color', "thememountain-sartre" ),
				),
				/** tm_page_header_button_appearance */
				// TOP
				'tm_top_header_nav_button_background_color' => array(
					esc_html__( 'Top Header Button Background Color', "thememountain-sartre" ),
					),
				'tm_top_header_nav_button_border_color' => array(
					esc_html__( 'Top Header Button Border Color', "thememountain-sartre" ),
					),
				'tm_top_header_nav_button_text_color' => array(
					esc_html__( 'Top Header Button Text Color', "thememountain-sartre" ),
					),
				'tm_top_header_nav_button_background_color_hover' => array(
					esc_html__( 'Top Header Button Hover Background Color', "thememountain-sartre" ),
					),
				'tm_top_header_nav_button_border_color_hover' => array(
					esc_html__( 'Top Header Button Hover Border Color', "thememountain-sartre" ),
					),
				'tm_top_header_nav_button_text_color_hover' => array(
					esc_html__( 'Top Header Button Hover Text Color', "thememountain-sartre" ),
					),
				// BODY
				'tm_body_header_nav_button_background_color' => array(
					esc_html__( 'Body Header Button Background Color', "thememountain-sartre" ),
					),
				'tm_body_header_nav_button_border_color' => array(
					esc_html__( 'Body Header Button Border Color', "thememountain-sartre" ),
					),
				'tm_body_header_nav_button_text_color' => array(
					esc_html__( 'Body Header Button Text Color', "thememountain-sartre" ),
					),
				'tm_body_header_nav_button_background_color_hover' => array(
					esc_html__( 'Body Header Button Hover Background Color', "thememountain-sartre" ),
					),
				'tm_body_header_nav_button_border_color_hover' => array(
					esc_html__( 'Body Header Button Hover Border Color', "thememountain-sartre" ),
					),
				'tm_body_header_nav_button_text_color_hover' => array(
					esc_html__( 'Body Header Button Hover Text Color', "thememountain-sartre" ),
					),
				);

			/**
			 * Preheader Customizer Settings
			 */
			self::$text_strings['preheader_customizer'] = array(
				/** default menu style */
				'tm_preheader_type' => array(
					esc_html__( 'Show Pre Header', "thememountain-sartre" ),
					esc_html__( 'Determines if a pre-header should be shown.', "thememountain-sartre" ),
					esc_html__( 'Use preheader', "thememountain-sartre" ),
					esc_html__( 'Do not show preheader', "thememountain-sartre" ),
					esc_html__( 'Use the settings as set in the Customizer', "thememountain-sartre" ),
					),
				'tm_preheader_height' => array(
					esc_html__( 'Pre Header Height', "thememountain-sartre" ),
					esc_html__( 'Determines initial pre-header height. Defaults to auto, which means it auto expands to its content. Any numerical value requires the suffix px to be entered.', "thememountain-sartre" ),
					),
				'tm_preheader_id_to_show' => array(
					esc_html__( 'Pre Header to show', "thememountain-sartre" ),
					esc_html__( 'Determines the pre-header to be shown', "thememountain-sartre" ),
					),
				'tm_preheader_link_color' => array(
					esc_html__( 'Pre Header Link Color', "thememountain-sartre" ),
					),
				'tm_preheader_link_color_hover' => array(
					esc_html__( 'Pre Header Link Hover Color', "thememountain-sartre" ),
					),
				); // end

			/**
			 * TM Dropdown Customizer Settings
			 */
			self::$text_strings['dropdown_page_options'] = array(
				/** default menu style */
				'tm_dropdown_width' => array(
					esc_html__( 'Dropdown Width', "thememountain-sartre" ),
					esc_html__( 'Enter a width value i.e. 300, which represents 300px.', "thememountain-sartre" ),
					),
				); // end

			/**
			 * customizer panels
			 */
			self::$text_strings['customizer_panels'] = array(
				'tm_header_settings' => array(
					esc_html__( 'Header Settings', "thememountain-sartre" ),
					esc_html__( 'This section allows you to manage your site logo, main and mobile navigation colors, header background color states and positions.', "thememountain-sartre" ),
					),
				'tm_aux_nav_settings' => array(
					esc_html__( 'Auxiliary Navigation Settings', "thememountain-sartre" ),
					),
				'tm_content_settings' => array(
					esc_html__( 'Content Settings', "thememountain-sartre" ),
					esc_html__( 'In this section you can manage everything from fonts, font colors, to default titles for pages such as Tm folio, 404 pages, archive, category, search and author index pages.', "thememountain-sartre" ),
					),
				'tm_footer_settings' => array(
					esc_html__( 'Footer Settings', "thememountain-sartre" ),
					esc_html__( 'In this section you can manage the number of footer columns, footer colors and footer form colors.', "thememountain-sartre" ),
					),
				'tm_form_settings' => array(
					esc_html__( 'Form Settings', "thememountain-sartre" ),
					esc_html__( 'In this section you can manage all form colors relating to contact forms, comment forms, and search fields.', "thememountain-sartre" ),
					),
				);

			/**
			 * customizer sections
			 */
			self::$text_strings['customizer_sections'] = array(
				// Navigation Header
				'tm_navigation_header_logo' => array(
					esc_html__( 'Header Logo', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_page_header_nav_appearance' => array(
					esc_html__( 'Header Navigation Appearance', "thememountain-sartre" ),
					esc_html__( 'Determines whether your site should employ a default main navigation or the more modern, hamburger navigation. Below are dependent color options for each navigation type.', "thememountain-sartre" ),
					),
				'tm_page_header_appearance' => array(
					esc_html__( 'Header Appearance', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_page_header_button_appearance' => array(
					esc_html__( 'Header Button Appearance', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_page_header_site_search_appearance' => array(
					esc_html__( 'Site Search Appearance', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_preheader_settings' => array(
					esc_html__( 'Pre-Header Settings', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				// Overlay Navigation
				'tm_overlay_nav_settings' => array(
					esc_html__( 'Overlay Navigation Settings', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_off_canvas_nav_settings' => array(
					esc_html__( 'Off-Canvas Navigation Settings', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				// Content Layout Settings
				'tm_language_settings' => array(
					esc_html__( 'Language', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_content_font_settings' => array(
					esc_html__( 'Fonts', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_content_navigation' => array(
					esc_html__( 'Content Navigation', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_content_body' => array(
					esc_html__( 'Content Body Color', "thememountain-sartre" ),
					esc_html__( 'Page Layout Settings for content body', "thememountain-sartre" ),
					),
				// home / global
				'tm_layout_home' => array(
					esc_html__( 'Blog Index Page', "thememountain-sartre" ),
					''
					),
				// single post
				'tm_layout_post' => array(
					esc_html__( 'Single Post', "thememountain-sartre" ),
					''
					),
				'tm_layout_page' => array(
					esc_html__( 'Page', "thememountain-sartre" ),
					''
					),
				'tm_layout_tm_folio' => array(
					esc_html__( 'Project Page', "thememountain-sartre" ),
					''
					),
				'tm_layout_404' => array(
					esc_html__( '404 Page', "thememountain-sartre" ),
					''
					),
				'tm_layout_shop' => array(
					esc_html__( 'Shop Page', "thememountain-sartre" ),
					esc_html__( 'WooCommerce Shop Page Product Archive Page Layout', "thememountain-sartre" ),
					),
				// Index Pages
				'tm_layout_archive' => array(
					esc_html__( 'Archive Index Page', "thememountain-sartre" ),
					esc_html__( 'This section allows you to manage global settings for the archive index page.', "thememountain-sartre" ),
					),
				'tm_layout_category' => array(
					esc_html__( 'Category Index Page', "thememountain-sartre" ),
					esc_html__( 'This section allows you to manage global settings for the category index page.', "thememountain-sartre" ),
					),
				'tm_layout_search' => array(
					esc_html__( 'Search Index Page', "thememountain-sartre" ),
					esc_html__( 'This section allows you to manage global settings for the search index page.', "thememountain-sartre" ),
					),
				'tm_layout_author' => array(
					esc_html__( 'Author Index Page', "thememountain-sartre" ),
					esc_html__( 'This section allows you to manage global settings for the author index page.', "thememountain-sartre" ),
					),
				'tm_light_box' => array(
					esc_html__( 'Lightbox', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_loader' => array(
					esc_html__( 'Loader', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				// Footer Settings sections
				'tm_footer_columns' => array(
					esc_html__( 'Footer Columns', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_footer_color' => array(
					esc_html__( 'Footer Colors', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_footer_form_color' => array(
					esc_html__( 'Footer Form Colors', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				// Form
				'tm_cf7_border_style_section' => array(
					esc_html__( 'Form Border Style', "thememountain-sartre" ),
					esc_html__( '-', "thememountain-sartre" ),
					),
				'tm_cf7_color' => array(
					esc_html__( 'Contact Form 7 & Woo Form Colors', "thememountain-sartre" ),
					esc_html__( 'In this section you can manage all colors relating to Contact Form 7 and Woo Commerce form elements.', "thememountain-sartre" ),
					),
				'tm_theme_form_color' => array(
					esc_html__( 'Theme Form Colors', "thememountain-sartre" ),
					esc_html__( 'In this section you can manage all colors relating to theme forest such as post reply forms, search forms, and sidebar subscribe forms.', "thememountain-sartre" ),
					),
				// WooCommerce
				'tm_woocommerce_shop_color' => array(
					esc_html__( 'Shop Colors', "thememountain-sartre" ),
					esc_html__( 'Description', "thememountain-sartre" ),
					),
				);

			/**
			 * Customizer Settings
			 * array index 0 for label and 1 for description
			 */
			self::$text_strings['customizer'] = array(
				// fields.php
				'tm_show_back_to_top' => array(
					esc_html__( 'Show back to top button', "thememountain-sartre" ),
					esc_html__( 'Determines if a back-to-top link should be shown in the bottom right-hand corner of the site.', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					),
				// fields_content_font_settings.php
				'tm_copyright_notice' => array(
					esc_html__( 'Copyright Notice', "thememountain-sartre" ),
					esc_html__( '&#169; 2018 THEMEMOUNTAIN. All Rights Reserved.', "thememountain-sartre" ),
					esc_html__( 'Copyright Notice', "thememountain-sartre" ),
					),
				'tm_privacy_policy_link' => array(
					esc_html__( 'Link to privacy policy', "thememountain-sartre" ),
					),
				'tm_cookie_policy_link' => array(
					esc_html__( 'Link to cookie policy', "thememountain-sartre" ),
					),
				// fields_content_layout_settings.php
				// Language settings
				// Font settings
				'tm_content_font_presets' => array(
					esc_html__( 'Font Presets', "thememountain-sartre" ),
					esc_html__( 'Determines a font preset to load. These presets are carefully selected fonts that work well together. Select from 30+ presets.', "thememountain-sartre" ),
					esc_html__( 'Please choose a preset to load.', "thememountain-sartre" ),
					),
				// font settings
				'tm_body_font' => array(
					esc_html__( 'Body Font', "thememountain-sartre" ),
					),
				'tm_body_font_target' => array(
					esc_html__( 'Body Font CSS Target', "thememountain-sartre" ),
					),
				'tm_title_font' => array(
					esc_html__( 'Title Font', "thememountain-sartre" ),
					),
				'tm_title_font_target' => array(
					esc_html__( 'Title Font CSS Target', "thememountain-sartre" ),
					),
				'tm_lead_font' => array(
					esc_html__( 'Lead Font', "thememountain-sartre" ),
					),
				'tm_lead_font_target' => array(
					esc_html__( 'Lead Font CSS Target', "thememountain-sartre" ),
					),
				/** Navigation */
				'tm_navigation_font' => array(
					esc_html__( 'Navigation Font', "thememountain-sartre" ),
					),
				'tm_navigation_font_target' => array(
					esc_html__( 'Navigation Font CSS Target', "thememountain-sartre" ),
					),
				/** Form */
				'tm_form_font' => array(
					esc_html__( 'Form Font', "thememountain-sartre" ),
					),
				'tm_form_font_target' => array(
					esc_html__( 'Form Font CSS Target', "thememountain-sartre" ),
					),
				/** Project Title and Description Elements */
				'tm_project_title_and_description_font' => array(
					esc_html__( 'Project Title and Description Font', "thememountain-sartre" ),
					),
				'tm_project_title_and_description_font_target' => array(
					esc_html__( 'Project Title and Description Font CSS Target', "thememountain-sartre" ),
					),
				'tm_blockquote_font' => array(
					esc_html__( 'Blockquote Font', "thememountain-sartre" ),
					),
				'tm_blockquote_font_target' => array(
					esc_html__( 'Blockquote Font CSS Target', "thememountain-sartre" ),
					),
				// alt fonts
				'tm_alt_font_1' => array(
					esc_html__( 'Font Alternative 1', "thememountain-sartre" ),
					),
				'tm_alt_font_1_target' => array(
					esc_html__( 'Font Alternative 1 CSS Target', "thememountain-sartre" ),
					),
				'tm_alt_font_2' => array(
					esc_html__( 'Font Alternative 2', "thememountain-sartre" ),
					),
				'tm_alt_font_2_target' => array(
					esc_html__( 'Font Alternative 2 CSS Target', "thememountain-sartre" ),
					),
				'tm_alt_font_3' => array(
					esc_html__( 'Font Alternative 3', "thememountain-sartre" ),
					),
				'tm_alt_font_3_target' => array(
					esc_html__( 'Font Alternative 3 CSS Target', "thememountain-sartre" ),
					),
				// heading titles
				'tm_h_tag_font_sizes' => array(
					esc_html__( 'H Tag Font Sizes', "thememountain-sartre" ),
					),
				'tm_aux_title_font_sizes' => array(
					esc_html__( 'Auxiliary Title Font Sizes', "thememountain-sartre" ),
					),
				'tm_lead_font_size' => array(
					esc_html__( 'Lead Font Size', "thememountain-sartre" ),
					),
				'tm_aux_text_font_sizes' => array(
					esc_html__( 'Auxiliary Text Font Sizes', "thememountain-sartre" ),
					),
				/* H Tag Font Sizes */
				'tm_title_font_size_h1' => array(
					esc_html__( 'Title H1 Font Size', "thememountain-sartre" ),
					),
				'tm_title_font_size_h2' => array(
					esc_html__( 'Title H2 Font Size', "thememountain-sartre" ),
					),
				'tm_title_font_size_h3' => array(
					esc_html__( 'Title H3 Font Size', "thememountain-sartre" ),
					),
				'tm_title_font_size_h4' => array(
					esc_html__( 'Title H4 Font Size', "thememountain-sartre" ),
					),
				'tm_title_font_size_h5' => array(
					esc_html__( 'Title H5 Font Size', "thememountain-sartre" ),
					),
				'tm_title_font_size_h6' => array(
					esc_html__( 'Title H6 Font Size', "thememountain-sartre" ),
					),
				/* Auxiliary Title Font Sizes */
				'tm_title_font_size_extra_large' => array(
					esc_html__( 'Extra Large Title Font Size', "thememountain-sartre" ),
				),
				'tm_title_font_size_large' => array(
					esc_html__( 'Large Title Font Size', "thememountain-sartre" ),
				),
				'tm_title_font_size_medium' => array(
					esc_html__( 'Medium Title Font Size', "thememountain-sartre" ),
				),
				'tm_title_font_size_small' => array(
					esc_html__( 'Small Title Font Size', "thememountain-sartre" ),
				),
				/* Lead Font Size */
				'tm_title_font_size_lead' => array(
					esc_html__( 'Lead Font Size', "thememountain-sartre" ),
				),
				/* Auxiliary Text Font Sizes */
				'tm_text_font_size_extra_large' => array(
					esc_html__( 'Extra Large Text Font Size', "thememountain-sartre" ),
				),
				'tm_text_font_size_large' => array(
					esc_html__( 'Large Text Font Size', "thememountain-sartre" ),
				),
				'tm_text_font_size_medium' => array(
					esc_html__( 'Medium Text Font Size', "thememountain-sartre" ),
				),
				'tm_text_font_size_small' => array(
					esc_html__( 'Small Text Font Size', "thememountain-sartre" ),
				),
				'tm_masthead_title_font_size' => array(
					esc_html__( 'Masthead Title Font Size', "thememountain-sartre" ),
				),
				'tm_blog_post_title_font_size' => array(
					esc_html__( 'Blog Post Title Font Size', "thememountain-sartre" ),
				),
				'tm_masonry_post_title_font_size' => array(
					esc_html__( 'Blog Masonry Post Title Font Size', "thememountain-sartre" ),
				),
				'tm_creative_post_title_font_size' => array(
					esc_html__( 'Blog Creative Post Title Font Size', "thememountain-sartre" ),
				),

				// fields_footer_form.php
				// Global Loop Settings
				'tm_global_loop_info_intro' => array(
					esc_html__( 'This section allows you to manage global settings for Blog Index Pages. Global settings can be overriden on a per page basis under Custom options for homepage with posts.', "thememountain-sartre" ),
					),
				'tm_post_pinterest' => array(
					esc_html__( 'Enable Pinterest icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Pinterest share icon', "thememountain-sartre" ),
					),
				'tm_post_facebook' => array(
					esc_html__( 'Enable Facebook SNS icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Facebook share icon', "thememountain-sartre" ),
					),
				'tm_post_twitter' => array(
					esc_html__( 'Enable Twitter SNS icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Twitter share icon', "thememountain-sartre" ),
					),
				'tm_post_googleplus' => array(
					esc_html__( 'Enable Google + SNS icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Google+ share icon', "thememountain-sartre" ),
					),
				'tm_post_linkedin' => array(
					esc_html__( 'Enable Linkedin icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Linkedin share icon', "thememountain-sartre" ),
					),
				'tm_post_email' => array(
					esc_html__( 'Enable Email icon', "thememountain-sartre" ),
					esc_html__( 'Determines if the single post page should have a Email share icon', "thememountain-sartre" ),
					),
				// Home
				'tm_page_header_title_home' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for the blog index. Leave blank to use the site tag line.', "thememountain-sartre" ),
					),
				// 404
				'tm_error_page_type' => array(
					esc_html__( 'Error Page Type', "thememountain-sartre" ),
					esc_html__( 'Determines if a default or custom error page should be used. For a custom error page, use TM Error Page custom post type to build your error page.', "thememountain-sartre" ),
					esc_html__( 'Use Default Layout', "thememountain-sartre" ),
					esc_html__( 'Use TM Error Page', "thememountain-sartre" ),
				),
				'tm_error_page_id_to_show' => array(
					esc_html__( 'TM Error Page to Show', "thememountain-sartre" ),
					'',
					esc_html__( 'Select a Error Page', "thememountain-sartre" ),
					),
				'tm_page_header_title_404' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for the 404 error index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				'tm_search_message_404' => array(
					esc_html__( 'Search Message', "thememountain-sartre" ),
					esc_html__( 'Determines the search message for the 404 error index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// Search
				'tm_page_header_title_search' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for the search index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				'tm_search_message_search' => array(
					esc_html__( 'Search Message', "thememountain-sartre" ),
					esc_html__( 'Sets the page title for the search message page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// Archive
				'tm_page_header_title_archive' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for archive index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// Category
				'tm_page_header_title_category' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for category index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// Author
				'tm_page_header_title_author' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for the author index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// tm_folio
				'tm_page_header_title_tm_folio' => array(
					esc_html__( 'Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title for the TM Folio custom post type index page. Leave blank to use default.', "thememountain-sartre" ),
					),
				// Search Info
				'tm_search_loop_info_intro' => array(
					esc_html__( 'This is for %ssearch index page%s.', "thememountain-sartre" ),
					),
				// 404
				'tm_404_info_intro' => array(
					esc_html__( 'This is for %s404 index page%s.', "thememountain-sartre" ),
					),
				// Advanced menu
				'tm_use_custom_settings_home' => array(
					esc_html__( 'Show advanced setting items', "thememountain-sartre" ),
					esc_html__( 'This section controls advanced settings such as excerpt layout style, sidebar settings and masthead styles.', "thememountain-sartre" ),
					),
				'tm_use_custom_settings_a' => array(
					esc_html__( 'Use Custom Settings', "thememountain-sartre" ),
					esc_html__( 'Determines if custom settings should be used for this section.', "thememountain-sartre" ),
					),
				'tm_use_custom_settings_b' => array(
					esc_html__( 'Use Custom Settings', "thememountain-sartre" ),
					esc_html__( 'By default global settings are used.', "thememountain-sartre" ),
					),
				// Recent Post Title
				'show_recent_post_title_' => array(
					esc_html__( 'Show Recent Post Title', "thememountain-sartre" ),
					esc_html__( 'Yes. Recent post title will be shown above post layout.', "thememountain-sartre" ),
					),
				'recent_post_title_' => array(
					esc_html__( 'Recent Post Title', "thememountain-sartre" ),
					esc_html__( 'Enter a recent post title.', "thememountain-sartre" ),
					esc_html__( 'Recent Posts', "thememountain-sartre" ),
					),
				'recent_post_title_alignment_' => array(
					esc_html__( 'Recent Post Title Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the horizontal recent post title alignment.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'recent_post_title_bottom_padding_' => array(
					esc_html__( 'Recent Post Title Bottom Padding', "thememountain-sartre" ),
					esc_html__( 'Determines bottom padding of the recent post title.', "thememountain-sartre" ),
					),
				// Excerpt Layout Style
				'tm_loop_style_' => array(
					esc_html__( 'Excerpt Layout Style', "thememountain-sartre" ),
					esc_html__( 'Determines the blog index page layout.', "thememountain-sartre" ),
					esc_html__( 'Wide Layout', "thememountain-sartre" ),
					esc_html__( 'Grid Layout', "thememountain-sartre" ),
					esc_html__( 'Creative Layout', "thememountain-sartre" ),
					esc_html__( 'List Layout', "thememountain-sartre" ),
					),
				'tm_excerpt_top_padding' => array(
					esc_html__( 'Excerpt Top Padding', "thememountain-sartre" ),
					''
					),
				'tm_excerpt_grid_layout_columns_' => array(
					esc_html__( 'Grid Layout Columns', "thememountain-sartre" ),
					esc_html__( 'Determines the number of grid columns.', "thememountain-sartre" ),
					esc_html__( '2', "thememountain-sartre" ),
					esc_html__( '3', "thememountain-sartre" ),
					esc_html__( '4', "thememountain-sartre" ),
					),
				'tm_column_gutters_' => array(
					esc_html__( 'Column Gutters', "thememountain-sartre" ),
					esc_html__( 'Determines the grid gutter size.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Small', "thememountain-sartre" ),
					esc_html__( 'Large', "thememountain-sartre" ),
					),
				'tm_loop_thumbnail_ratio_' => array(
					esc_html__( 'Thumbnail Ratio', "thememountain-sartre" ),
					esc_html__( 'The ratio used for calculating grid item with and height. Changing the ratio will change the height of the masonry grid items.', "thememountain-sartre" ),
					),
				'tm_grid_layout_width_' => array(
					esc_html__( 'Grid Layout Width', "thememountain-sartre" ),
					esc_html__( 'Determines whether the blog index page layout should be fixed or full width.', "thememountain-sartre" ),
					esc_html__( 'Fixed Width', "thememountain-sartre" ),
					esc_html__( 'Full Width', "thememountain-sartre" ),
					),
				// Blog grid item background color and post color needs color options in Customiser #192
				'tm_grid_layout_box_article_background_color_item' => array(
					esc_html__( 'Article Background Color', "thememountain-sartre" ),
					'',
					),
				// Please add a new color picker options and call it Blog Index Background Color all-wordpress-themes/5
				'tm_index_loop_background_color_' => array(
					esc_html__( 'Index Loop Background Color', "thememountain-sartre" ),
					'',
					),
				'tm_grid_layout_box_article_color_' => array(
					esc_html__( 'Article Color', "thememountain-sartre" ),
					'',
					),
				'tm_grid_layout_box_article_title_color_' => array(
					esc_html__( 'Article Title Color', "thememountain-sartre" ),
					'',
					),
				'tm_grid_layout_box_article_title_color_hover_' => array(
					esc_html__( 'Article Title Hover Color', "thememountain-sartre" ),
					'',
					),
				'tm_grid_layout_box_article_link_color_' => array(
					esc_html__( 'Article Link Color', "thememountain-sartre" ),
					'',
					),
				'tm_grid_layout_box_article_link_color_hover_' => array(
					esc_html__( 'Article Link Hover Color', "thememountain-sartre" ),
					'',
					),
				// End #192
				// #226
				'tm_grid_layout_box_article_post_meta_color_' => array(
					esc_html__( 'Article Post Meta Color', "thememountain-sartre" ),
					'',
					),
				// End #226
				// https://github.com/ThemeMountain/all-wordpress-themes/issues/6
				'tm_post_page_background_color_' => array(
					esc_html__( 'Post Page Background Color', "thememountain-sartre" ),
					'',
					),
				// End all-wordpress-themes/issues/6
				'tm_use_sidebar_' => array(
					esc_html__( 'Sidebar Settings', "thememountain-sartre" ),
					esc_html__( 'Determines if a sidebar should be shown for the blog index.', "thememountain-sartre" ),
					esc_html__( 'No side bar', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					),
				/** Update Customiser and custom options for page with sidebar option all-wordpress-themes/issues/1 **/
				'tm_sticky_sidebar_' => array(
					esc_html__( 'Sticky Sidebar', "thememountain-sartre" ),
					esc_html__( 'Determines if the sidebar should become sticky upon scrolling the page.', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
					esc_html__( 'No', "thememountain-sartre" ),
				),
				'tm_sticky_sidebar_extra_space_top_' => array(
					esc_html__( 'Sticky Sidebar Extra Space Top', "thememountain-sartre" ),
					esc_html__( "Determines the extra space above the sidebar once it's set to sticky, defaults to 100px.", "thememountain-sartre" ),
				),
				// End all-wordpress-themes/issues/1
				// For blog single post page add new option to Customiser and call it Add Background to Post Content
				'tm_add_background_to_post_content_' => array(
					esc_html__( 'Add Background to Post Content', "thememountain-sartre" ),
					esc_html__( 'Determines if the post content should be boxed. This option will add padding to the post content and provide the option of setting background and border color.', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
					esc_html__( 'No', "thememountain-sartre" ),
				),
				'tm_post_content_background_color_' => array(
					esc_html__( 'Post Content Background Color', "thememountain-sartre" ),
				),
				'tm_post_content_border_color_' => array(
					esc_html__( 'Post Content Border Color', "thememountain-sartre" ),
				),
				// End ThemeMountain/wordpress-faulkner/issues/21
				// Add new wrapper to sidebar called div.with-background all-wordpress-themes/issues/2
				'tm_add_background_to_sidebar_' => array(
					esc_html__( 'Add Background to Sidebar', "thememountain-sartre" ),
					esc_html__( 'Determines if the sidebar should be boxed. This option will add padding to the sidebar and provide the option of setting background and border color.', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
					esc_html__( 'No', "thememountain-sartre" ),
				),
				'tm_sidebar_background_color_' => array(
					esc_html__( 'Sidebar Background Color', "thememountain-sartre" ),
				),
				'tm_sidebar_border_color_' => array(
					esc_html__( 'Sidebar Border Color', "thememountain-sartre" ),
				),
				// end all-wordpress-themes/issues/2
				/** Add overlay info color colorpicker to Under Customizing> Content Settings > Blog Index Page #90 */
				'tm_post_rollover_background_color_wide_grids_' => array(
					esc_html__( 'Post Rollover Background Color', "thememountain-sartre" ),
					),
				'tm_post_rollover_background_color_creative_' => array(
					esc_html__( 'Post Rollover Background Color', "thememountain-sartre" ),
					),
				// end #90
				// Add blog rollover color option to customiser #180
				// Content Settings > Blog Index Page, and Page options, Recent Posts
				'tm_post_rollover_color_wide_grids_home' => array(
					esc_html__( 'Post Rollover Color', "thememountain-sartre" ),
					''
				),
				'tm_post_rollover_color_creative_home' => array(
					esc_html__( 'Post Rollover Color', "thememountain-sartre" ),
					''
				),
				//
				// end #180
				'tm_use_masthead_title_' => array(
					esc_html__( 'Use Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines if a masthead title should be used.', "thememountain-sartre" ),
					),
				/** Page Head Background Title Color */
				'tm_page_head_title_background_color_' => array(
					esc_html__( 'Masthead Title Background Color', "thememountain-sartre" ),
					),
				'tm_page_head_title_font_color_' => array(
					esc_html__( 'Masthead Title Font Color', "thememountain-sartre" ),
					),
				'tm_page_head_title_background_image_' => array(
					esc_html__( 'Masthead Title Background Image', "thememountain-sartre" ),
					esc_html__( 'Upload a masthead background image.', "thememountain-sartre" ),
					),
				'tm_page_head_title_overlay_background_color_' => array(
					esc_html__( 'Masthead Overlay Background Color', "thememountain-sartre" ),
					),
				// Pagination Options
				'tm_pagination_background_color_' => array(
					esc_html__( 'Pagination Link Background Color', "thememountain-sartre" ),
				),
				'tm_pagination_background_color_hover_' => array(
					esc_html__( 'Pagination Link Background Hover Color', "thememountain-sartre" ),
				),
				'tm_pagination_background_color_active_' => array(
					esc_html__( 'Link Active Background Color', "thememountain-sartre" ),
				),
				'tm_pagination_border_color_' => array(
					esc_html__( 'Pagination LInk Border Color', "thememountain-sartre" ),
				),
				'tm_pagination_border_color_hover_' => array(
					esc_html__( 'Pagination Link Border Hover Color', "thememountain-sartre" ),
				),
				'tm_pagination_border_color_active_' => array(
					esc_html__( 'Pagination Link Active Border Color', "thememountain-sartre" ),
				),
				'tm_pagination_link_color_' => array(
					esc_html__( 'Pagination Link Color', "thememountain-sartre" ),
				),
				'tm_pagination_link_color_hover_' => array(
					esc_html__( 'Pagination Link Hover Color', "thememountain-sartre" ),
				),
				'tm_pagination_link_color_active_' => array(
					esc_html__( 'Pagination Link Active Color', "thememountain-sartre" ),
				),
				'tm_pagination_return_to_index_' => array(
					esc_html__( 'Pagination Return to Index', "thememountain-sartre" ),
					esc_html__( 'Determines the return to index format.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Label', "thememountain-sartre" ),
					esc_html__( 'Icon', "thememountain-sartre" ),
				),
				'tm_pagination_return_to_index_label_' => array(
					esc_html__( 'Pagination Return to Index Label', "thememountain-sartre" ),
				),
				// content body
				'tm_content_body_background_color' => array(
					esc_html__( 'Body Background Color', "thememountain-sartre" ),
					),
				'tm_section_block_background_color' => array(
					esc_html__( 'Section Block Background Color', "thememountain-sartre" ),
					),
				'tm_content_body_text_color' => array(
					esc_html__( 'Content Body Text Color', "thememountain-sartre" ),
					),
				'tm_content_body_title_color' => array(
					esc_html__( 'Title Color', "thememountain-sartre" ),
					),
				'tm_content_body_title_link_color' => array(
					esc_html__( 'Title Link Color', "thememountain-sartre" ),
					),
				'tm_content_body_title_link_color_hover' => array(
					esc_html__( 'Title Link Hover Color', "thememountain-sartre" ),
					),
				'tm_content_body_link_color' => array(
					esc_html__( 'Link Color', "thememountain-sartre" ),
					),
				'tm_content_body_link_color_hover' => array(
					esc_html__( 'Link Hover Color', "thememountain-sartre" ),
					),
				'tm_lead_font_color' => array(
					esc_html__( 'Lead Font Color', "thememountain-sartre" ),
					),
				// Single Post Options
				'tm_show_author_bio' => array(
					esc_html__( 'Show Author Bio', "thememountain-sartre" ),
					esc_html__( 'Determines if author bio should be down at the end of the post.', "thememountain-sartre" ),
					),
				// Global Button Color
				'tm_button_set_global_color' => array(
					esc_html__( 'Set Global Button Color', "thememountain-sartre" ),
					esc_html__( 'Determines if global button sizes, styles and colors should apply. Global button settings can be overriden using the button shortcode.', "thememountain-sartre" ),
					),
				// Button Size (dropdown)
				'tm_button_size' => array(
					esc_html__( 'Button Size', "thememountain-sartre" ),
					esc_html__( 'Determines the default button size.', "thememountain-sartre" ),
					esc_html__( 'Small', "thememountain-sartre" ),
					esc_html__( 'Medium', "thememountain-sartre" ),
					esc_html__( 'Large', "thememountain-sartre" ),
					esc_html__( 'Extra Large', "thememountain-sartre" ),
					),
				// Button Style (dropdown)
				'tm_button_style' => array(
					esc_html__( 'Button Style', "thememountain-sartre" ),
					esc_html__( 'Determines the default button border radius.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Rounded', "thememountain-sartre" ),
					esc_html__( 'Pill', "thememountain-sartre" ),
					),
				// Global Button Background Color (colorpicker)
				'tm_button_bkg_color' => array(
					esc_html__( 'Global Button Background Color', "thememountain-sartre" ),
					),
				// Global Button Background Color Hover (colorpicker)
				'tm_button_bkg_color_hover' => array(
					esc_html__( 'Global Button Background Color Hover', "thememountain-sartre" ),
					),
				// Global Button Border Color (colorpicker)
				'tm_button_border_color' => array(
					esc_html__( 'Global Button Border Color', "thememountain-sartre" ),
					),
				// Global Button Border Color Hover (colorpicker)
				'tm_button_border_color_hover' => array(
					esc_html__( 'Global Button Border Color Hover', "thememountain-sartre" ),
					),
				// Global Button Label Color (colorpicker)
				'tm_button_label_color' => array(
					esc_html__( 'Global Button Label Color', "thememountain-sartre" ),
					),
				// Global Button Label Color Hover (colorpicker)
				'tm_button_label_color_hover' => array(
					esc_html__( 'Global Button Label Color Hover', "thememountain-sartre" ),
					),
				// fields_footer.php
				'tm_footer_type' => array(
					esc_html__( 'Footer Type', "thememountain-sartre" ),
					esc_html__( 'Determines if the footer should use the WordPress default widget space, or, TM Footer custom post type. For custom built footers, use TM Footer.', "thememountain-sartre" ),
					esc_html__( 'Use Widget Space', "thememountain-sartre" ),
					esc_html__( 'Use TM Footer', "thememountain-sartre" ),
					esc_html__( 'Hide Footer', "thememountain-sartre" ),
					),
				'tm_footer_id_to_show' => array(
					esc_html__( 'TM Footer To Show', "thememountain-sartre" ),
					esc_html__( 'Determines the custom footer to show.', "thememountain-sartre" ),
					),
				'tm_footer_column_number' => array(
					esc_html__( 'Footer Columns', "thememountain-sartre" ),
					esc_html__( 'Determines the number of footer columns.', "thememountain-sartre" ),
					esc_html__( '1 Column', "thememountain-sartre" ),
					esc_html__( '2 Columns', "thememountain-sartre" ),
					esc_html__( '3 Columns', "thememountain-sartre" ),
					esc_html__( '4 Columns', "thememountain-sartre" ),
					esc_html__( '5 Columns', "thememountain-sartre" ),
					),
				'tm_footer_column_align_' => array(
					esc_html__( 'Column %s Content Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the content alignment of this column.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_footer_position' => array(
					esc_html__( 'Footer Position', "thememountain-sartre" ),
					esc_html__( 'Determines whether the footer should scroll with the content or fixed and revealed by the content.', "thememountain-sartre" ),
					esc_html__( 'Relative', "thememountain-sartre" ),
					esc_html__( 'Fixed', "thememountain-sartre" ),
					),
				'tm_footer_scale_content_upon_footer_reveal' => array(
					esc_html__( 'Scale content upon footer reveal', "thememountain-sartre" ),
					esc_html__( 'Determines if the content should scale and animate as the footer is revealed.', "thememountain-sartre" ),
					),
				// Footer Color Section
				'tm_footer_background_color' => array(
					esc_html__( 'Footer Background Color', "thememountain-sartre" ),
					),
				'tm_footer_text_color' => array(
					esc_html__( 'Footer Text Color', "thememountain-sartre" ),
					),
				'tm_footer_link_text_color' => array(
					esc_html__( 'Footer Link Text Color', "thememountain-sartre" ),
					),
				'tm_footer_link_text_color_hover' => array(
					esc_html__( 'Footer Link Hover Color', "thememountain-sartre" ),
					),
				'tm_footer_title_color' => array(
					esc_html__( 'Footer Title Color', "thememountain-sartre" ),
					),
				'tm_footer_text_font_size' => array(
					esc_html__( 'Footer Text Font Size', "thememountain-sartre" ),
					),
				'tm_footer_form_background_color' => array(
					esc_html__( 'Form Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_border_color' => array(
					esc_html__( 'Form Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_placeholder_color' => array(
					esc_html__( 'Form Placeholder Color', "thememountain-sartre" ),
					),
				'tm_footer_form_focus_background_color' => array(
					esc_html__( 'Form Focus Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_focus_border_color' => array(
					esc_html__( 'Form Focus Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_focus_text_color' => array(
					esc_html__( 'Form Focus Text Color', "thememountain-sartre" ),
					),
				'tm_footer_form_required_background_color' => array(
					esc_html__( 'Form Required Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_required_border_color' => array(
					esc_html__( 'Form Required Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_required_text_color' => array(
					esc_html__( 'Form Required Text Color', "thememountain-sartre" ),
					),
				'tm_footer_form_error_background_color' => array(
					esc_html__( 'Form Error Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_error_border_color' => array(
					esc_html__( 'Form Error Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_error_text_color' => array(
					esc_html__( 'Form Error Text Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_background_color' => array(
					esc_html__( 'Form Submit Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_border_color' => array(
					esc_html__( 'Form Submit Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_text_color' => array(
					esc_html__( 'Form Submit Text Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_hover_background_color' => array(
					esc_html__( 'Form Submit Hover Background Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_hover_border_color' => array(
					esc_html__( 'Form Submit Hover Border Color', "thememountain-sartre" ),
					),
				'tm_footer_form_submit_hover_text_color' => array(
					esc_html__( 'Form Submit Hover Text Color', "thememountain-sartre" ),
					),
				'tm_footer_form_response_message_color' => array(
					esc_html__( 'Form Response Message Color', "thememountain-sartre" ),
					),
				// fields_form.php
				'tm_theme_form_background_color' => array(
					esc_html__( 'Form Background Color', "thememountain-sartre" ),
					),
				'tm_theme_form_border_color' => array(
					esc_html__( 'Form Border Color', "thememountain-sartre" ),
					),
				'tm_theme_form_placeholder_color' => array(
					esc_html__( 'Form Placeholder Color', "thememountain-sartre" ),
					),
				'tm_theme_form_placeholder_focus_color' => array(
					esc_html__( 'Form Placeholder Focus Color', "thememountain-sartre" ),
					),
				'tm_theme_form_focus_background_color' => array(
					esc_html__( 'Form Focus Background Color', "thememountain-sartre" ),
					),
				'tm_theme_form_focus_border_color' => array(
					esc_html__( 'Form Focus Border Color', "thememountain-sartre" ),
					),
				'tm_theme_form_focus_text_color' => array(
					esc_html__( 'Form Focus Text Color', "thememountain-sartre" ),
					),
				// submit
				'tm_theme_form_submit_background_color' => array(
					esc_html__( 'Form Submit Background Color', "thememountain-sartre" ),
					),
				'tm_theme_form_submit_border_color' => array(
					esc_html__( 'Form Submit Border Color', "thememountain-sartre" ),
					),
				'tm_theme_form_submit_text_color' => array(
					esc_html__( 'Form Submit Text Color', "thememountain-sartre" ),
					),
				'tm_theme_form_submit_hover_background_color' => array(
					esc_html__( 'Form Submit Hover Background Color', "thememountain-sartre" ),
					),
				'tm_theme_form_submit_hover_border_color' => array(
					esc_html__( 'Form Submit Hover Border Color', "thememountain-sartre" ),
					),
				'tm_theme_form_submit_hover_text_color' => array(
					esc_html__( 'Form Submit Hover Text Color', "thememountain-sartre" ),
					),
				// fields_form_cf7.php
				// tm_cf7_border_style_section
				'tm_cf7_border_style' => array(
					esc_html__( 'Form Border Style', "thememountain-sartre" ),
					esc_html__( 'Determines the border radius of form elements.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Rounded', "thememountain-sartre" ),
					esc_html__( 'Pill', "thememountain-sartre" ),
				),
				'tm_cf7_background_color' => array(
					esc_html__( 'Form Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_border_color' => array(
					esc_html__( 'Form Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_placeholder_color' => array(
					esc_html__( 'Form Placeholder Color', "thememountain-sartre" ),
					),
				'tm_cf7_form_text_color' => array(
					esc_html__( 'Form Text Color', "thememountain-sartre" ),
					),
				'tm_cf7_placeholder_focus_color' => array(
					esc_html__( 'Form Placeholder Focus Color', "thememountain-sartre" ),
					),
				'tm_cf7_focus_background_color' => array(
					esc_html__( 'Form Focus Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_focus_border_color' => array(
					esc_html__( 'Form Focus Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_focus_text_color' => array(
					esc_html__( 'Form Focus Text Color', "thememountain-sartre" ),
					),
				'tm_cf7_error_background_color' => array(
					esc_html__( 'Form Error Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_error_border_color' => array(
					esc_html__( 'Form Error Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_error_text_color' => array(
					esc_html__( 'Form Error Text Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_background_color' => array(
					esc_html__( 'Form Submit Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_border_color' => array(
					esc_html__( 'Form Submit Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_text_color' => array(
					esc_html__( 'Form Submit Text Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_hover_background_color' => array(
					esc_html__( 'Form Submit Hover Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_hover_border_color' => array(
					esc_html__( 'Form Submit Hover Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_submit_hover_text_color' => array(
					esc_html__( 'Form Submit Hover Text Color', "thememountain-sartre" ),
					),
				'tm_cf7_response_message_color' => array(
					esc_html__( 'Form Response Message Color', "thememountain-sartre" ),
					),
				'tm_cf7_checkbox_radio_background_color' => array(
					esc_html__( 'Checkbox & Radio Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_checkbox_radio_border_color' => array(
					esc_html__( 'Checkbox & Radio Border Color', "thememountain-sartre" ),
					),
				'tm_cf7_checkbox_checked_background_color' => array(
					esc_html__( 'Checkbox Checked Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_radio_checked_background_color' => array(
					esc_html__( 'Radio Checked Background Color', "thememountain-sartre" ),
					),
				'tm_cf7_checkbox_check_color' => array(
					esc_html__( 'Checkbox Check Color', "thememountain-sartre" ),
					),
				'tm_cf7_radiobutton_checked_color' => array(
					esc_html__( 'Radio Button Checked Color', "thememountain-sartre" ),
					),
				// fields_lightbox.php
				'tm_lightbox_overlay_background_color' => array(
					esc_html__( 'Lightbox Overlay Background Color', "thememountain-sartre" ),
					),
				'tm_lightbox_navigation_color' => array(
					esc_html__( 'Lightbox Navigation Color', "thememountain-sartre" ),
					),
				'tm_lightbox_caption_background_color' => array(
					esc_html__( 'Lightbox Caption Background Color', "thememountain-sartre" ),
					),
				'tm_lightbox_caption_color' => array(
					esc_html__( 'Lightbox Caption Color', "thememountain-sartre" ),
					),
				// fields_loader.php
				'tm_loader_color' => array(
					esc_html__( 'Loader Color', "thememountain-sartre" ),
					),
				'tm_loader_border_thickness' => array(
					esc_html__( 'Loader Border Thickness', "thememountain-sartre" ),
					),
				'tm_loader_size' => array(
					esc_html__( 'Loader Size', "thememountain-sartre" ),
					),
				// #175. In tm_off_canvas_nav_settings in fields_off_canvas_nav_settings.php
				'tm_off_canvas_nav_menu_width' => array(
					esc_html__( 'Off-canvas Navigation Width', "thememountain-sartre" ),
					esc_html__( 'Determines the off-canvas navigation width.', "thememountain-sartre" ),
					esc_html__( 'Default', "thememountain-sartre" ),
					esc_html__( '50%', "thememountain-sartre" ),
					),
				// tm_off_canvas_nav_settings in fields_off_canvas_nav_settings.php
				'tm_off_canvas_nav_menu_alignment' => array(
					esc_html__( 'Off-canvas Navigation Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the off-canvas navigation links alignment.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_off_canvas_title_display' => array(
					esc_html__( 'Off-Canvas Menu Title Display', "thememountain-sartre" ),
					esc_html__( 'Determines if a title should be shown for the off-canvas primary navigation.', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					),
				'tm_secondary_off_canvas_title_display' => array(
					esc_html__( 'Off-Canvas Secondary Menu Title Display', "thememountain-sartre" ),
					esc_html__( 'Determines if a title should be shown for the off-canvas secondary navigation.', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					),
				// Off-Canvas Navigation Color
				'tm_off_canvas_nav_color' => array(
					esc_html__( 'Off-Canvas Navigation Color', "thememountain-sartre" ),
					),
				'tm_off_canvas_nav_color_hover_active' => array(
					esc_html__( 'Off-Canvas Navigation Hover & Active Color', "thememountain-sartre" ),
					),
				'tm_off_canvas_background_color' => array(
					esc_html__( 'Off-Canvas Background Color', "thememountain-sartre" ),
					),
				'tm_offcanvas_exit_button_color' => array(
					esc_html__( 'Off-Canvas Exit Button Color', "thememountain-sartre" ),
					),
				'tm_offcanvas_exit_button_color_hover' => array(
					esc_html__( 'Off-Canvas Exit Button Hover Color', "thememountain-sartre" ),
					),
				'tm_off_canvas_nav_copyright_color' => array(
					esc_html__( 'Off-Canvas Navigation Copyright Color', "thememountain-sartre" ),
					),
				'tm_off_canvas_nav_position' => array(
					esc_html__( 'Off-Canvas Navigation Position', "thememountain-sartre" ),
					esc_html__( 'Determines the side of the viewport the off-canvas navigation should enter.', "thememountain-sartre" ),
					esc_html__( 'Enter Left', "thememountain-sartre" ),
					esc_html__( 'Enter Right', "thememountain-sartre" ),
					),
				'tm_off_canvas_nav_animation' => array(
					esc_html__( 'Off-Canvas Navigation Animation', "thememountain-sartre" ),
					esc_html__( 'Determines the off-canvas animation upon entering the viewport.', "thememountain-sartre" ),
					esc_html__( 'Content slide out', "thememountain-sartre" ),
					esc_html__( 'Nav slide in', "thememountain-sartre" ),
					esc_html__( 'Nav push in', "thememountain-sartre" ),
					esc_html__( 'Nav scale in', "thememountain-sartre" ),
					),
				// Add color options for cart to Side Navigation options in Customiser: #211
				'tm_offcanvas_sub_menu_navigation_color' => array(
					esc_html__( 'Off-Canvas Sub Menu Navigation Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_sub_menu_navigation_color_hover' => array(
					esc_html__( 'Off-Canvas Sub Menu Navigation Hover Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_delete_button_background_color' => array(
					esc_html__( 'Off-Canvas Cart Delete Button Bkg Color', "thememountain-sartre" ),
				),
				// Added in #218
				'tm_offcanvas_cart_badge_background_color' => array(
					esc_html__( 'Off-Canvas Cart Badge Background Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_badge_color' => array(
					esc_html__( 'Off-Canvas Cart Badge Color', "thememountain-sartre" ),
				),
				// End #218
				'tm_offcanvas_cart_delete_button_color' => array(
					esc_html__( 'Off-Canvas Cart Delete Button Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_delete_button_color_hover' => array(
					esc_html__( 'Off-Canvas Cart Delete Button Hover Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_price_color' => array(
					esc_html__( 'Off-Canvas Cart Price Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_total_color' => array(
					esc_html__( 'Off-Canvas Cart Total Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_cart_total_divider_color' => array(
					esc_html__( 'Off-Canvas Cart Total Divider Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_background_color' => array(
					esc_html__( 'Off-Canvas Button Background Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_border_color' => array(
					esc_html__( 'Off-Canvas Button Border Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_text_color' => array(
					esc_html__( 'Off-Canvas Button Text Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_background_color_hover' => array(
					esc_html__( 'Off-Canvas Button Hover Background Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_border_color_hover' => array(
					esc_html__( 'Off-Canvas Button Hover Border Color', "thememountain-sartre" ),
				),
				'tm_offcanvas_button_text_color_hover' => array(
					esc_html__( 'Off-Canvas Button Hover Text Color', "thememountain-sartre" ),
				),
				// end #211
				// fields_overlay_appearance.php
				'tm_overlay_nav_menu_alignment' => array(
					esc_html__( 'Overlay Navigation Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the overlay navigation links alignment.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_overlay_menu_title_display' => array(
					esc_html__( 'Overlay Menu Title Display', "thememountain-sartre" ),
					esc_html__( 'Determines if a title should be shown for the overlay primary navigation.', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					),
				'tm_secondary_overlay_title_display' => array(
					esc_html__( 'Overlay Secondary Menu Title Display', "thememountain-sartre" ),
					esc_html__( 'Determines if a title should be shown for the overlay secondary navigation.', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					),
				// Overlay Navigation Color
				'tm_overlay_background_color' => array(
					esc_html__( 'Overlay Navigation Background Color', "thememountain-sartre" ),
					),
				'tm_overlay_exit_button_color' => array(
					esc_html__( 'Overlay Navigation Exit Button Color', "thememountain-sartre" ),
					),
				'tm_overlay_exit_button_color_hover' => array(
					esc_html__( 'Overlay Navigation Exit Button Color', "thememountain-sartre" ),
					),
				'tm_overlay_nav_title_color' => array(
					esc_html__( 'Overlay Navigation Title Color', "thememountain-sartre" ),
					),
				'tm_overlay_nav_copyright_color' => array(
					esc_html__( 'Overlay Navigation Copyright Color', "thememountain-sartre" ),
					),
				'tm_overlay_nav_animation' => array(
					esc_html__( 'Overlay Navigation Animation', "thememountain-sartre" ),
					'',
					esc_html__( 'Slide in Top', "thememountain-sartre" ),
					esc_html__( 'Slide in Right', "thememountain-sartre" ),
					esc_html__( 'Slide in Bottom', "thememountain-sartre" ),
					esc_html__( 'Slide in Left', "thememountain-sartre" ),
					esc_html__( 'Scale In', "thememountain-sartre" ),
					),
				// fields_overlay_nav_appearance.php
				'tm_overlay_navigation_color' => array(
					esc_html__( 'Overlay Navigation Color', "thememountain-sartre" ),
					),
				'tm_overlay_navigation_color_hover_active' => array(
					esc_html__( 'Overlay Navigation Hover & Active Color', "thememountain-sartre" ),
					),
				// Add color options for cart to Side Navigation options in Customiser: #212
				'tm_overlay_sub_menu_navigation_color' => array(
					esc_html__( 'Overlay Sub Menu Navigation Color', "thememountain-sartre" ),
				),
				'tm_overlay_sub_menu_navigation_color_hover' => array(
					esc_html__( 'Overlay Sub Menu Navigation Hover Color', "thememountain-sartre" ),
				),
				// Added in #218
				'tm_overlay_cart_badge_background_color' => array(
					esc_html__( 'Overlay Cart Badge Background Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_badge_color' => array(
					esc_html__( 'Overlay Cart Badge Color', "thememountain-sartre" ),
				),
				// End #218
				'tm_overlay_cart_delete_button_background_color' => array(
					esc_html__( 'Overlay Cart Delete Button Bkg Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_delete_button_color' => array(
					esc_html__( 'Overlay Cart Delete Button Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_delete_button_color_hover' => array(
					esc_html__( 'Overlay Cart Delete Button Hover Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_price_color' => array(
					esc_html__( 'Overlay Cart Price Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_total_color' => array(
					esc_html__( 'Overlay Cart Total Color', "thememountain-sartre" ),
				),
				'tm_overlay_cart_total_divider_color' => array(
					esc_html__( 'Overlay Cart Total Divider Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_background_color' => array(
					esc_html__( 'Overlay Button Background Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_border_color' => array(
					esc_html__( 'Overlay Button Border Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_text_color' => array(
					esc_html__( 'Overlay Button Text Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_background_color_hover' => array(
					esc_html__( 'Overlay Button Hover Background Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_border_color_hover' => array(
					esc_html__( 'Overlay Button Hover Border Color', "thememountain-sartre" ),
				),
				'tm_overlay_button_text_color_hover' => array(
					esc_html__( 'Overlay Button Hover Text Color', "thememountain-sartre" ),
				),
				// end #212
				// Site Search
				'tm_search_modal_overlay_background_color' => array(
					esc_html__( 'Search Modal Overlay Background Color', "thememountain-sartre" ),
					),
				'tm_search_modal_form_placeholder_color' => array(
					esc_html__( 'Search Modal Form Placeholder Color', "thememountain-sartre" ),
					),
				'tm_search_modal_form_focus_color' => array(
					esc_html__( 'Search Modal Form Focus Text Color', "thememountain-sartre" ),
					),
				'tm_search_modal_close_link_color' => array(
					esc_html__( 'Search Modal Close Link Color', "thememountain-sartre" ),
					),
				// fields_tm_navigation_header_logo.php
				'tm_use_top_logo' => array(
					esc_html__( 'Use top logo', "thememountain-sartre" ),
					esc_html__( 'Determines if the header should use one top and one body header logo. The first appears by default, and the second appears as the user begins to scroll the page.', "thememountain-sartre" ),
					),
				'custom_logo' => array(
					esc_html__( 'Top Logo Image', "thememountain-sartre" ),
					esc_html__( 'Upload a top logo. Default logo width is set to 95px, which means your logo should measure at least 190px to look sharp on retina displays.', "thememountain-sartre" ),
					),
				'tm_page_header_logo_common_menu_hover_opacity' => array(
					esc_html__( 'Header Logo Hover Opacity', "thememountain-sartre" ),
					esc_html__( 'Determines the logo opacity upon hover.', "thememountain-sartre" ),
					),
				'tm_logo_top_width_hamburger' => array(
					esc_html__( 'Top Logo Width (hamburger)', "thememountain-sartre" ),
					esc_html__( 'Determines the initial width of the top logo, defaults to 120px. The logo will proportionally scale in height based on its width. If using a vertical logo, consider modifying the "Top Header Height" and "Body Header Height" under "Header Settings > Header Navigation Apperance".', "thememountain-sartre" ),
					),
				'tm_logo_top_width_default' => array(
					esc_html__( 'Top Logo Width (default)', "thememountain-sartre" ),
					esc_html__( 'Determines the width of the top logo, defaults to 120px. The logo will proportionally scale in height based on its width. If using a vertical logo, consider modifying the "Top Header Height" and "Body Header Height" under "Header Settings > Header Navigation Apperance".', "thememountain-sartre" ),
					),
				'tm_use_body_logo' => array(
					esc_html__( 'Use body logo', "thememountain-sartre" ),
					esc_html__( 'Determines whether the same logo used for the top header should be used for the body header.', "thememountain-sartre" ),
					esc_html__( 'Same as the top logo', "thememountain-sartre" ),
					esc_html__( 'Different from top logo', "thememountain-sartre" ),
					esc_html__( 'Do not use body logo', "thememountain-sartre" ),
					),
				'tm_logo_body' => array(
					esc_html__( 'Body Logo Image', "thememountain-sartre" ),
					esc_html__( 'Upload a body logo.', "thememountain-sartre" ),
					),
				'tm_logo_body_width_default' => array(
					esc_html__( 'Body Logo Width', "thememountain-sartre" ),
					esc_html__( 'Determines the width of the body logo. If the header is reduced in height upon scroll, consider reducing the logo width as well for the body logo.', "thememountain-sartre" ),
					),
				// fields_tm_page_header_appearance.php
				'tm_body_header_presets' => array(
					esc_html__( 'Header Style Presets', "thememountain-sartre" ),
					esc_html__( 'Determines the header style and position. These are presets and each can be overriden by the options below.', "thememountain-sartre" ),
					esc_html__( 'Header Above Content', "thememountain-sartre" ),
					esc_html__( 'Header Above Content - Sticky on Scroll', "thememountain-sartre" ),
					esc_html__( 'Header Over Content', "thememountain-sartre" ),
					esc_html__( 'Header Over Content - Sticky on Scroll', "thememountain-sartre" ),
					esc_html__( 'Header Over Content - Fixed', "thememountain-sartre" ),
					esc_html__( 'Header Bottom', "thememountain-sartre" ),
					esc_html__( 'Header Bottom - Sticky on Scroll', "thememountain-sartre" ),
					),
				'tm_header_position' => array(
					esc_html__( 'Header Position', "thememountain-sartre" ),
					esc_html__( 'Determines the initial position of the header. It can be positioned relative to the page (i.e. appears above page content), positioned absolute (overlays the content but scrolls with the page), or, positioned fixed (overlays content and remains sticky at all times).', "thememountain-sartre" ),
					esc_html__( 'Relative', "thememountain-sartre" ),
					esc_html__( 'Absolute', "thememountain-sartre" ),
					esc_html__( 'Fixed', "thememountain-sartre" ),
					),
				'tm_header_fixed_on_mobile' => array(
					esc_html__( 'Header Position Mobile', "thememountain-sartre" ),
					esc_html__( 'Determines if the header should scroll with the content or remain fixed on mobile.', "thememountain-sartre" ),
					esc_html__( 'Fix header on mobile', "thememountain-sartre" ),
					esc_html__( 'Do not fix header on mobile', "thememountain-sartre" ),
					),
				'tm_header_vertical_alignment' => array(
					esc_html__( 'Header Vertical Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines if the header should be position top or bottom of the viewport.', "thememountain-sartre" ),
					esc_html__( 'Top', "thememountain-sartre" ),
					esc_html__( 'Bottom', "thememountain-sartre" ),
					),
				'tm_header_vertical_alignment_bottom_value' => array(
					esc_html__( 'Header Bottom Value', "thememountain-sartre" ),
					esc_html__( 'Determines the bottom position of the header i.e. 0, which represents 0px.', "thememountain-sartre" ),
					),
				'tm_top_header_common_menu_height' => array(
					esc_html__( 'Top Header Height', "thememountain-sartre" ),
					esc_html__( 'Determines initial header height, defaults to 80px.', "thememountain-sartre" ),
					),
				'tm_body_header_default_menu_height' => array(
					esc_html__( 'Body Header Height', "thememountain-sartre" ),
					esc_html__( 'Determines body header height, defaults to 65px.', "thememountain-sartre" ),
					),
				'tm_body_header_default_menu_height_threshold' => array(
					esc_html__( 'Body Header Height Threshold', "thememountain-sartre" ),
					esc_html__( 'Determines the number of pixels the user must scroll before the header swaps height. Defaults to 100px, leave blank not to apply.', "thememountain-sartre" ),
					),
				'tm_body_header_background_color_threshold' => array(
					esc_html__( 'Body Header Background Color Threshold', "thememountain-sartre" ),
					esc_html__( 'Determines the number of pixels the user must scroll before the header swaps background color. Defaults to 100px, leave blank not to apply.', "thememountain-sartre" ),
					),
				'tm_body_header_compact_threshold' => array(
					esc_html__( 'Body Header Compact Threshold', "thememountain-sartre" ),
					esc_html__( 'Determines the number of pixels the user must scroll before the header should be reduced in height(compacted), leave blank not to apply.', "thememountain-sartre" ),
					),
				'tm_body_header_sticky_threshold' => array(
					esc_html__( 'Header Sticky Threshold', "thememountain-sartre" ),
					esc_html__( 'Determines the number of pixels the user must scroll before the header should become sticky(fixed), leave blank not to apply.', "thememountain-sartre" ),
					),
				'tm_body_header_helper_out_threshold' => array(
					esc_html__( 'Header Helper Out Threshold', "thememountain-sartre" ),
					esc_html__( 'Determines the number of pixels the user must scroll before the header should slide out and default to its original position, leave blank not to apply.', "thememountain-sartre" ),
					),
				// fields_tm_page_header_nav_appearance.php
				'tm_header_navigation_type' => array(
					esc_html__( 'Header Navigation Type', "thememountain-sartre" ),
					esc_html__( 'Determines if the  header should employ a default main navigation, or, the more modern, hamburger navigation.', "thememountain-sartre" ),
					),
				// common-assets #240
				'tm_header_navigation_header_sub_menu_indicator' => array(
					esc_html__( 'Header Sub Menu Indicator', "thememountain-sartre" ),
					esc_html__( 'Determines if arrows shuold be added to top level navigation items to indicate existence of sub menu.', "thememountain-sartre" ),
					esc_html__( 'Hide', "thememountain-sartre" ),
					esc_html__( 'Show', "thememountain-sartre" ),
					),
				'tm_page_header_nav_top_header_border_color' => array(
					esc_html__( 'Top Header Border Color', "thememountain-sartre" ),
					),
				'tm_page_header_nav_body_header_border_color' => array(
					esc_html__( 'Body Header Border Color', "thememountain-sartre" ),
					),
				// Added #218
				'tm_page_header_cart_badge_background_color' => array(
					esc_html__( 'Header Cart Badge Background Color', "thememountain-sartre" ),
				),
				'tm_page_header_cart_badge_color' => array(
					esc_html__( 'Header Cart Badge Color', "thememountain-sartre" ),
				),
				// End #218
				// #245
				'tm_sub_menu_shadow_color' => array(
					esc_html__( 'Sub Menu Shadow Color', "thememountain-sartre" ),
				),
				'tm_sub_menu_horizontal_offset' => array(
					esc_html__( 'Sub Menu Horizontal Offset', "thememountain-sartre" ),
				),
				'tm_sub_menu_vertical_offset' => array(
					esc_html__( 'Sub Menu Vertical Offset', "thememountain-sartre" ),
				),
				'tm_sub_menu_blur' => array(
					esc_html__( 'Sub Menu Blur', "thememountain-sartre" ),
				),
				'tm_sub_menu_spread' => array(
					esc_html__( 'Sub Menu Spread', "thememountain-sartre" ),
				),
				'tm_apply_top_header_shadow' => array(
					esc_html__( 'Apply Top Header Shadow', "thememountain-sartre" ),
					'',
					esc_html__( 'No', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),

				),
				'tm_top_header_shadow_color' => array(
					esc_html__( 'Top Header Shadow Color', "thememountain-sartre" ),
				),
				'tm_top_header_horizontal_offset' => array(
					esc_html__( 'Top Header Horizontal Offset', "thememountain-sartre" ),
				),
				'tm_top_header_vertical_offset' => array(
					esc_html__( 'Top Header Vertical Offset', "thememountain-sartre" ),
				),
				'tm_top_header_blur' => array(
					esc_html__( 'Top Header Blur', "thememountain-sartre" ),
				),
				'tm_top_header_spread' => array(
					esc_html__( 'Top Header Spread', "thememountain-sartre" ),
				),
				'tm_apply_body_header_shadow' => array(
					esc_html__( 'Apply Body Header Shadow', "thememountain-sartre" ),
					'',
					esc_html__( 'No', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
				),
				'tm_body_header_shadow_color' => array(
					esc_html__( 'Body Header Shadow Color', "thememountain-sartre" ),
				),
				'tm_body_header_horizontal_offset' => array(
					esc_html__( 'Body Header Horizontal Offset', "thememountain-sartre" ),
				),
				'tm_body_header_vertical_offset' => array(
					esc_html__( 'Body Header Vertical Offset', "thememountain-sartre" ),
				),
				'tm_body_header_blur' => array(
					esc_html__( 'Body Header Blur', "thememountain-sartre" ),
				),
				'tm_body_header_spread' => array(
					esc_html__( 'Body Header Spread', "thememountain-sartre" ),
				),
				// End #245
				// default values for tm_pagination_return_to_index_label
				'tm_pagination_return_to_index_label_tm_folio' => esc_html__( 'Folio index', "thememountain-sartre" ),
				'tm_pagination_return_to_index_label_home' => esc_html__( 'Blog index', "thememountain-sartre" ),
				// WooCommerce
				'tm_woo_shop_backround_color' => array(
					esc_html__( 'Shop Background Color', "thememountain-sartre" ),
					''
				),
				'tm_woo_shop_divider_color' => array(
					esc_html__( 'Shop Divider Colors', "thememountain-sartre" ),
					''
				),
			);

			/**
			 * Page Options Settings
			 * array index 0 for label and 1 for description
			 */
			self::$text_strings['page_options'] = array(
				/** Tab strings */
				'homepage_with_posts' => array(
					esc_html__( 'Custom options for homepage with posts', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Recent Posts', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					),
				'page' => array(
					esc_html__( 'Custom options for page', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Sidebar Location', "thememountain-sartre" ),
					esc_html__( 'Loop', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					),
				'post' => array(
					esc_html__( 'Custom options for post', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Post Media', "thememountain-sartre" ),
					esc_html__( 'Post Content', "thememountain-sartre" ),
					esc_html__( 'Sidebar Location', "thememountain-sartre" ),
					esc_html__( 'Loop', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					),
				'tm_error_page' => array(
					esc_html__( 'Custom options for TM Error Page', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Sidebar Location', "thememountain-sartre" ),
					esc_html__( 'Loop', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					),
				'tm_folio' => array(
					esc_html__( 'Custom options for Folio', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Loop', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					esc_html__( 'Pagination', "thememountain-sartre" ),
					),
				'tm_modal' => array(
					esc_html__( 'Custom options for Modal items', "thememountain-sartre" ),
					esc_html__( 'Modal Animation Settings', "thememountain-sartre" ),
					),
				'tm_dropdown' => array(
					esc_html__( 'Custom options for Dropdown content', "thememountain-sartre" ),
					esc_html__( 'Dropdown Settings', "thememountain-sartre" ),
					),
				/** for WooCommerce */
				'product' => array(
					esc_html__( 'Custom options for WooCommerce product page', "thememountain-sartre" ),
					esc_html__( 'Pre-Header', "thememountain-sartre" ),
					esc_html__( 'Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Footer', "thememountain-sartre" ),
					esc_html__( 'Featured Media', "thememountain-sartre" ),
					esc_html__( 'Sidebar Location', "thememountain-sartre" ),
					esc_html__( 'Grids', "thememountain-sartre" ),
					),
				/** Featured Media */
				'tm_featured_media_type' => array(
					esc_html__( 'Featured Media Type', "thememountain-sartre" ),
					esc_html__( 'Determines featured media type.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Image', "thememountain-sartre" ),
					esc_html__( 'Use Vimeo Video', "thememountain-sartre" ),
					esc_html__( 'Use YouTube Video', "thememountain-sartre" ),
					esc_html__( 'Use HTML5 Video', "thememountain-sartre" ),
					),
				'tm_featured_media_youtube' => array(
					esc_html__( 'YouTube Video ID', "thememountain-sartre" ),
					esc_html__( 'Enter the YouTube video ID, not the full URL. Generally the ID is displayed at the end of the video embed URL. For example, the ID in this URL: https://www.youtube.com/watch?v=bPg4tk7VFR0.', "thememountain-sartre" ),
					),
				'tm_featured_media_vimeo' => array(
					esc_html__( 'Vimeo Video ID', "thememountain-sartre" ),
					esc_html__( 'Enter the Vimeo video ID, not the full URL. Generally the ID is displayed at the end of the video embed URL. For example, the ID in this URL: https://vimeo.com/46697798, is 46697798.', "thememountain-sartre" ),
					),
				'tm_featured_media_image_alternative' => array(
					esc_html__( 'Alternate Image', "thememountain-sartre" ),
					esc_html__( 'Set an image here, only if, you want to use a different image for the masthead than the on uploaded for the featured image for this page.', "thememountain-sartre" ),
					esc_html__( 'Select an image file.', "thememountain-sartre" ),
					),
				'tm_featured_media_video_mp4' => array(
					esc_html__( 'Video File (mp4)', "thememountain-sartre" ),
					'',
					esc_html__( 'Select an mp4 video.', "thememountain-sartre" ),
					),
				'tm_featured_media_video_webm' => array(
					esc_html__( 'Video File (webm)', "thememountain-sartre" ),
					'',
					esc_html__( 'Select a webm video', "thememountain-sartre" ),
					),
				'tm_featured_media_thumbnail' => array(
					esc_html__( 'Video Thumbnail', "thememountain-sartre" ),
					'',
					esc_html__( 'Select a video poster image.', "thememountain-sartre" ),
					),
				'tm_featured_media_loop_video' => array(
					esc_html__( 'Loop Video', "thememountain-sartre" ),
					esc_html__( 'Determines if video should replay upon reaching the end.', "thememountain-sartre" ),
					esc_html__( 'Do not loop', "thememountain-sartre" ),
					esc_html__( 'Loop', "thememountain-sartre" ),
					),
				'tm_featured_media_mute_video' => array(
					esc_html__( 'Mute Sound', "thememountain-sartre" ),
					esc_html__( 'Determines if video should be muted.', "thememountain-sartre" ),
					esc_html__( 'Mute', "thememountain-sartre" ),
					esc_html__( 'Play sound', "thememountain-sartre" ),
					),
				'tm_featured_media_video_mode' => array(
					esc_html__( 'Video Format', "thememountain-sartre" ),
					esc_html__( 'Determines video format.', "thememountain-sartre" ),
					esc_html__( 'Regular (with controls)', "thememountain-sartre" ),
					esc_html__( 'Background Video (no controls)', "thememountain-sartre" ),
					),
				/** Page Head */
				'tm_use_masthead_title_settings_of' => array(
					esc_html__( 'Custom Masthead Title', "thememountain-sartre" ),
					esc_html__( 'Determines if customiser settings should be used for the masthead, or, if custom settings should be used.', "thememountain-sartre" ),
					esc_html__( 'Use customiser settings', "thememountain-sartre" ),
					esc_html__( 'Set masthead title options for this post', "thememountain-sartre" ),
					esc_html__( 'Hide the masthead title', "thememountain-sartre" ),
					),
				'tm_show_post_title_in_post_content' => array(
					esc_html__( 'Show Post Title In Post Content', "thememountain-sartre" ),
					'',
					),
				'tm_masthead_height' => array(
					esc_html__( 'Post Media Height', "thememountain-sartre" ),
					esc_html__( 'Determines post media height.', "thememountain-sartre" ),
					esc_html__( 'Default (500px)', "thememountain-sartre" ),
					esc_html__( 'Window Height', "thememountain-sartre" ),
					esc_html__( 'Custom', "thememountain-sartre" ),
					),
				'tm_page_head_min_height' => array(
					esc_html__( 'Minimum Height', "thememountain-sartre" ),
					esc_html__( 'Determines the height beyond which the slider will not scale i.e. 265, which represents 265px.', "thememountain-sartre" ),
					),
				'tm_masthead_height_custom' => array(
					esc_html__( 'Custom Page Head Height', "thememountain-sartre" ),
					esc_html__( 'Enter a custom height value i.e. 500, which represents 500px.', "thememountain-sartre" ),
					),
				'tm_page_head_title_animation' => array(
					esc_html__( 'Masthead Title Animation', "thememountain-sartre" ),
					esc_html__( 'Determines the masthead title animation.', "thememountain-sartre" ),
					esc_html__( 'No animation effects', "thememountain-sartre" ),
					esc_html__( 'Fade in', "thememountain-sartre" ),
					esc_html__( 'Slide in from bottom short', "thememountain-sartre" ),
					esc_html__( 'Slide in from right short', "thememountain-sartre" ),
					esc_html__( 'Slide in from top short', "thememountain-sartre" ),
					esc_html__( 'Slide in from left short', "thememountain-sartre" ),
					esc_html__( 'Slide in from bottom long', "thememountain-sartre" ),
					esc_html__( 'Slide in from right long', "thememountain-sartre" ),
					esc_html__( 'Slide in from top long', "thememountain-sartre" ),
					esc_html__( 'Slide in from left long', "thememountain-sartre" ),
					esc_html__( 'Bounce in', "thememountain-sartre" ),
					esc_html__( 'Bounce out', "thememountain-sartre" ),
					esc_html__( 'Bounce in from bottom', "thememountain-sartre" ),
					esc_html__( 'Bounce in from right', "thememountain-sartre" ),
					esc_html__( 'Bounce in from top', "thememountain-sartre" ),
					esc_html__( 'Bounce in from left', "thememountain-sartre" ),
					esc_html__( 'Scale in', "thememountain-sartre" ),
					esc_html__( 'Scale out', "thememountain-sartre" ),
					esc_html__( 'Flip in X', "thememountain-sartre" ),
					esc_html__( 'Flip in Y', "thememountain-sartre" ),
					esc_html__( 'Spin in X', "thememountain-sartre" ),
					esc_html__( 'Spin in Y', "thememountain-sartre" ),
					esc_html__( 'Helicopter in', "thememountain-sartre" ),
					esc_html__( 'Helicopter out', "thememountain-sartre" ),
					esc_html__( 'Sign swing in from top', "thememountain-sartre" ),
					esc_html__( 'Sign swing in from right', "thememountain-sartre" ),
					esc_html__( 'Sign swing in from bottom', "thememountain-sartre" ),
					esc_html__( 'Sign swing in from left', "thememountain-sartre" ),
					esc_html__( 'Wiggle X', "thememountain-sartre" ),
					esc_html__( 'Wiggle Y', "thememountain-sartre" ),
					esc_html__( 'Drop in from bottom', "thememountain-sartre" ),
					esc_html__( 'Drop in from top', "thememountain-sartre" ),
					esc_html__( 'Roll in from left', "thememountain-sartre" ),
					esc_html__( 'Roll in from right', "thememountain-sartre" ),
					esc_html__( 'Turn in from right', "thememountain-sartre" ),
					esc_html__( 'Turn in from left', "thememountain-sartre" ),
					),
				'tm_page_head_title_animation_duration' => array(
					esc_html__( 'Animation Duration', "thememountain-sartre" ),
					esc_html__( 'Determines the duration of the animation. Expressed in milliseconds i.e. 1000 represents 1 second.', "thememountain-sartre" ),
					),
				'tm_page_head_title_animation_delay' => array(
					esc_html__( 'Animation Delay', "thememountain-sartre" ),
					esc_html__( 'Determines the duration before the animation should begin upon entering the viewport. Expressed in milliseconds i.e. 100 represents 0.1 second.', "thememountain-sartre" ),
					),
				/** Sidebar */
				'tm_use_sidebar' => array(
					esc_html__( 'Sidebar Location', "thememountain-sartre" ),
					esc_html__( 'Determines if a sidebar should be shown.', "thememountain-sartre" ),
					esc_html__( 'Use the Customiser setting', "thememountain-sartre" ),
					esc_html__( 'Show sidebar on right', "thememountain-sartre" ),
					esc_html__( 'Show sidebar on left', "thememountain-sartre" ),
					esc_html__( 'Do not show sidebar', "thememountain-sartre" ),
					),
				/** Post Media */
				'tm_use_post_media' => array(
					esc_html__( 'Post Media', "thememountain-sartre" ),
					esc_html__( 'Determines if post media should be shown. Post media appears first in the post content.', "thememountain-sartre" ),
					esc_html__( 'Do not use media', "thememountain-sartre" ),
					esc_html__( 'Use Vimeo', "thememountain-sartre" ),
					esc_html__( 'Use YouTube', "thememountain-sartre" ),
					esc_html__( 'Use self hosted video', "thememountain-sartre" ),
					esc_html__( 'Use self hosted audio', "thememountain-sartre" ),
					),
				'tm_media_height' => array(
					esc_html__( 'Post Media Height', "thememountain-sartre" ),
					esc_html__( 'Determines post media height.', "thememountain-sartre" ),
					esc_html__( 'Default (500px)', "thememountain-sartre" ),
					esc_html__( 'Window Height', "thememountain-sartre" ),
					esc_html__( 'Custom', "thememountain-sartre" ),
					),
				'tm_media_height_custom' => array(
					esc_html__( 'Custom Video Height', "thememountain-sartre" ),
					esc_html__( 'Enter a custom height value i.e. 500, which represents 500px.', "thememountain-sartre" ),
					),
				'tm_media_youtube' => array(
					esc_html__( 'YouTube Video ID', "thememountain-sartre" ),
					esc_html__( 'Enter the YouTube video ID, not the full URL. Generally the ID is displayed at the end of the video embed URL. For example, the ID in this URL: https://www.youtube.com/watch?v=bPg4tk7VFR0.', "thememountain-sartre" ),
					),
				'tm_media_vimeo' => array(
					esc_html__( 'Vimeo Video ID', "thememountain-sartre" ),
					esc_html__( 'Enter the Vimeo video ID, not the full URL. Generally the ID is displayed at the end of the video embed URL. For example, the ID in this URL: https://vimeo.com/46697798, is 46697798.', "thememountain-sartre" ),
					),
				'tm_media_video_mp4' => array(
					esc_html__( 'Video File (mp4)', "thememountain-sartre" ),
					'',
					esc_html__( 'Select an mp4 video.', "thememountain-sartre" ),
					),
				'tm_media_video_webm' => array(
					esc_html__( 'Video File (webm)', "thememountain-sartre" ),
					'',
					esc_html__( 'Select a webm video.', "thememountain-sartre" ),
					),
				'tm_media_thumbnail' => array(
					esc_html__( 'Video Thumbnail', "thememountain-sartre" ),
					'',
					esc_html__( 'Select a video poster image.', "thememountain-sartre" ),
					),
				'tm_use_video_for_featured' => array(
					esc_html__( 'Show Featured Media in Blog Index', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
					),
				/** Audio */
				'tm_media_audio' => array(
					esc_html__( 'Audio File (mp3)', "thememountain-sartre" ),
					'',
					esc_html__( 'Select an mp3 track.', "thememountain-sartre" ),
					),
				'tm_use_audio_for_featured' => array(
					esc_html__( 'Show Featured Media in Blog Index', "thememountain-sartre" ),
					'',
					),
				/** Fields Loop */
				'tm_hide_excerpt_in_loop' => array(
					esc_html__( 'Excerpt in loop', "thememountain-sartre" ),
					esc_html__( 'Yes. This will show the excerpt in the Blog Index.', "thememountain-sartre" ),
					),
				/** Grids */
				'tm_grid_thumbnail' => array(
					esc_html__( 'Grid Thumbnail', "thememountain-sartre" ),
					esc_html__( 'Upload a grid thumbnail. Defaults to Featured Image if none is set.', "thememountain-sartre" ),
					esc_html__( 'Select a grid thumbnail image.', "thememountain-sartre" ),
					),
				'tm_grid_linked_item' => array(
					esc_html__( 'Link Grid Item To', "thememountain-sartre" ),
					esc_html__( 'Determines what the grid thumbnail should link to.', "thememountain-sartre" ),
					esc_html__( 'Post', "thememountain-sartre" ),
					esc_html__( 'Lightbox', "thememountain-sartre" ),
					esc_html__( 'Modal', "thememountain-sartre" ),
					esc_html__( 'Custom URL', "thememountain-sartre" ),
					esc_html__( 'Not Linked', "thememountain-sartre" ),
					),
				'tm_grid_linked_item_modal_id' => array(
					esc_html__( 'Modal to show', "thememountain-sartre" ),
					''
					),
				'tm_grid_custom_url' => array(
					esc_html__( 'Custom URL', "thememountain-sartre" ),
					esc_html__( 'Enter the page or site URL the image should link to.', "thememountain-sartre" ),
					),
				'tm_grid_lightbox_caption' => array(
					esc_html__( 'Lightbox Caption', "thememountain-sartre" ),
					esc_html__( 'Enter the lightbox media caption. Leave blank if no caption is wanted.', "thememountain-sartre" ),
					),
				/**
				 * see tm_grid item need to add an additional option to grid rollovers #39
				 *  - text_with_thumbnail_rollover added and labels for text_with_thumbnail has been changed
				 */
				'tm_grid_box_type' => array(
					esc_html__( 'Grid Item Format', "thememountain-sartre" ),
					esc_html__( 'Determines the format of the page/post in the grid.', "thememountain-sartre" ),
					esc_html__( 'Ignored if no Featured Media or grid thumbnail has been set', "thememountain-sartre" ),
					esc_html__( 'Show thumb with project title & description below', "thememountain-sartre" ),
					esc_html__( 'Show thumb with project title & description on rollover', "thememountain-sartre" ),
					esc_html__( 'Show title & excerpt with solid background color', "thememountain-sartre" ),
					esc_html__( 'Do not show in the grid', "thememountain-sartre" ),
					),
				/**
				 * see tm_grid item need to add an additional option to grid rollovers #39
				 */
				'tm_grid_box_title' => array(
					esc_html__( 'Grid Item Title', "thememountain-sartre" ),
					esc_html__( 'Enter a grid item title. Location of title depends on Grid Item Format.', "thememountain-sartre" ),
					),
				/**
				 * see tm_grid item need to add an additional option to grid rollovers #39
				 */
				'tm_grid_box_description' => array(
					esc_html__( 'Grid Box Description', "thememountain-sartre" ),
					esc_html__( 'Enter a grid item description. Location of description depends on Grid Item Format.', "thememountain-sartre" ),
					),
				'tm_grid_box_thumb_format' => array(
					esc_html__( 'Grid item thumbnail format and size', "thememountain-sartre" ),
					esc_html__( 'Determines the orientation of the thumbnail in the grid.', "thememountain-sartre" ),
					esc_html__( 'Do not specify', "thememountain-sartre" ),
					esc_html__( 'Large Landscape', "thememountain-sartre" ),
					esc_html__( 'Portrait', "thememountain-sartre" ),
					esc_html__( 'Large Portrait', "thememountain-sartre" ),
					esc_html__( 'Wide', "thememountain-sartre" ),
					),
				// Blog Creative Layout Options and Fixes #15
				'tm_grid_box_content_vertical_alignment' => array(
					esc_html__( 'Grid Item Content Vertical Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the vertical alignment of grid item title and description.', "thememountain-sartre" ),
					esc_html__( 'Top', "thememountain-sartre" ),
					esc_html__( 'Middle', "thememountain-sartre" ),
					esc_html__( 'Bottom', "thememountain-sartre" ),
					),
				'tm_grid_box_content_horizontal_alignment' => array(
					esc_html__( 'Gird Item Content Horizontal Alignment', "thememountain-sartre" ),
					esc_html__( 'Determines the horizontal alignment of grid item title and description.', "thememountain-sartre" ),
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				// Blog Creative Layout Options and Fixes #15 End
				'tm_grid_box_text' => array(
					esc_html__( 'Grid Item Text', "thememountain-sartre" ),
					esc_html__( 'Enter grid item text.', "thememountain-sartre" ),
					),
				/** Pagination (for tm_folio) */
				'tm_pagination_hide' => array(
					esc_html__( 'Hide Pagination', "thememountain-sartre" ),
					esc_html__( 'Yes', "thememountain-sartre" ),
					),
				/** Navigation Menu */
				'tm_navigation_menu_deviate' => array(
					esc_html__( 'Change Navigation Appearance for this Page', "thememountain-sartre" ),
					esc_html__( 'Yes. This option will override the default navigation options in Customiser for this page/post only.', "thememountain-sartre" ),
					),
				'tm_deviate_logo' => array(
					esc_html__( 'Logo', "thememountain-sartre" ),
					esc_html__( 'Determines the logo to be used in the header.', "thememountain-sartre" ),
					esc_html__( 'User Customiser Setting', "thememountain-sartre" ),
					esc_html__( 'Use Top Logo', "thememountain-sartre" ),
					esc_html__( 'Use Body Logo', "thememountain-sartre" ),
					),
				'tm_navigation_menu_override_top_logo' => array(
					esc_html__( 'Override Top Logo', "thememountain-sartre" ),
					esc_html__( 'Upload a logo image if you want to show a different top logo image for this page.', "thememountain-sartre" ),
					esc_html__( 'Select an image.', "thememountain-sartre" ),
					),
				'tm_navigation_menu_item_main_nav_menu' => array(
					esc_html__( 'Main Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Determines which menu will be shown in the header.', "thememountain-sartre" ),
					),
				'tm_navigation_menu_item_overlay_menu' => array(
					esc_html__( 'Overlay Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Determines the primary overlay menu to be shown.', "thememountain-sartre" ),
					),
				'tm_navigation_menu_item_overlay_secondary_menu' => array(
					esc_html__( 'Overlay Secondary Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Determines the secondary overlay menu to be shown.', "thememountain-sartre" ),
					),
				'tm_navigation_menu_item_off_canvas_menu' => array(
					esc_html__( 'Off-Canvas Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Determines the primary off-canvas menu to be shown.', "thememountain-sartre" ),
					),
				'tm_navigation_menu_item_off_canvas_secondary_menu' => array(
					esc_html__( 'Off-Canvas Secondary Navigation Menu', "thememountain-sartre" ),
					esc_html__( 'Determines the secondary off-canvas menu to be shown.', "thememountain-sartre" ),
					),
				'tm_navigation_color_set' => array(
					esc_html__( 'Navigation Colors', "thememountain-sartre" ),
					esc_html__( 'Determines if default navigation colors should be used.', "thememountain-sartre" ),
					esc_html__( 'Default to Customiser settings', "thememountain-sartre" ),
					esc_html__( 'Override for this page', "thememountain-sartre" ),
					),
				/** Homepage with Posts Template Options */
				'tm_hide_pagination' => array(
					esc_html__( 'Hide Pagination', "thememountain-sartre" ),
					esc_html__( 'Yes.', "thememountain-sartre" ),
					),
				'tm_post_count' => array(
					esc_html__( 'Post Count', "thememountain-sartre" ),
					esc_html__( 'Determines the number of posts to be shown.', "thememountain-sartre" ),
					),
				/** TM Footer */
				'tm_footer_type' => array(
					esc_html__( 'Footer Type', "thememountain-sartre" ),
					esc_html__( 'Determines the footer type for this page/post.', "thememountain-sartre" ),
					esc_html__( 'Use Customizer Settings', "thememountain-sartre" ),
					esc_html__( 'Use Widget Space', "thememountain-sartre" ),
					esc_html__( 'Use TM Footer', "thememountain-sartre" ),
					esc_html__( 'Hide Footer', "thememountain-sartre" ),
					),
				'tm_footer_id_to_show' => array(
					esc_html__( 'TM Footer to show', "thememountain-sartre" ),
					esc_html__( 'Determines the footer to be shown.', "thememountain-sartre" ),
					),
				'tm_footer_column_number' => array(
					esc_html__( 'The number of columns in the footer', "thememountain-sartre" ),
					esc_html__( 'Determines the number of columns the footer should have.', "thememountain-sartre" ),
					esc_html__( '1 Column', "thememountain-sartre" ),
					esc_html__( '2 Columns', "thememountain-sartre" ),
					esc_html__( '3 Columns', "thememountain-sartre" ),
					esc_html__( '4 Columns', "thememountain-sartre" ),
					esc_html__( '5 Columns', "thememountain-sartre" ),
					),
				'tm_footer_column_align_1' => array(
					esc_html__( 'Column 1 Content Alignment', "thememountain-sartre" ),
					'',
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_footer_column_align_2' => array(
					esc_html__( 'Column 2 Content Alignment', "thememountain-sartre" ),
					'',
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_footer_column_align_3' => array(
					esc_html__( 'Column 3 Content Alignment', "thememountain-sartre" ),
					'',
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_footer_column_align_4' => array(
					esc_html__( 'Column 4 Content Alignment', "thememountain-sartre" ),
					'',
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				'tm_footer_column_align_5' => array(
					esc_html__( 'Column 5 Content Alignment', "thememountain-sartre" ),
					'',
					esc_html__( 'Left', "thememountain-sartre" ),
					esc_html__( 'Center', "thememountain-sartre" ),
					esc_html__( 'Right', "thememountain-sartre" ),
					),
				/** TM Modal */
				'tm_modal_width' => array(
					esc_html__( 'Modal Width', "thememountain-sartre" ),
					esc_html__( 'Enter a width value i.e. 500, which represents 500px.', "thememountain-sartre" ),
					),
				'tm_modal_content_animation' => array(
					esc_html__( 'Modal Content Animation', "thememountain-sartre" ),
					esc_html__( 'Determines how the content gets animated.', "thememountain-sartre" ),
					esc_html__( 'Fade', "thememountain-sartre" ),
					esc_html__( 'Slide in top', "thememountain-sartre" ),
					esc_html__( 'Slide in bottom', "thememountain-sartre" ),
					esc_html__( 'Scale in', "thememountain-sartre" ),
					esc_html__( 'Scale out', "thememountain-sartre" ),
					),
				'tm_modal_lightbox_overlay_animation' => array(
					esc_html__( 'Lightbox Overlay Animation', "thememountain-sartre" ),
					esc_html__( 'Determines lightbox overlay gets animated.', "thememountain-sartre" ),
					esc_html__( 'Fade', "thememountain-sartre" ),
					esc_html__( 'Slide in top', "thememountain-sartre" ),
					esc_html__( 'Slide in right', "thememountain-sartre" ),
					esc_html__( 'Slide in bottom', "thememountain-sartre" ),
					esc_html__( 'Slide in left', "thememountain-sartre" ),
					),
				/** tm modal add a few options to Custom options for modal items #69 */
				'tm_modal_header' => array(
					esc_html__( 'Add Modal Header', "thememountain-sartre" ),
					esc_html__( 'Yes. This will add a header to the modal.', "thememountain-sartre" ),
					),
				// tm_modal custom post type add an option for rounded corners for lightbox #74
				'tm_modal_border_style' => array(
					esc_html__( 'Modal Border Style', "thememountain-sartre" ),
					esc_html__( 'Determines the modal border radius.', "thememountain-sartre" ),
					esc_html__( 'None', "thememountain-sartre" ),
					esc_html__( 'Rounded', "thememountain-sartre" ),
				),
				'tm_modal_header_title' => array(
					esc_html__( 'Modal Header Title', "thememountain-sartre" ),
					esc_html__( 'Enter a title.', "thememountain-sartre" ),
					),
				'tm_modal_header_background_color' => array(
					esc_html__( 'Modal Header Background Color', "thememountain-sartre" ),
					''
					),
				'tm_modal_header_title_color' => array(
					esc_html__( 'Modal Header Title Color', "thememountain-sartre" ),
					''
					),
				'tm_modal_close_button_color' => array(
					esc_html__( 'Modal Close Button Color', "thememountain-sartre" ),
					''
				),
				'tm_modal_custom_classes' => array(
					esc_html__( 'Modal Custom Classes', "thememountain-sartre" ),
					esc_html__( 'If you wish to style the modal differently, then use the extra class name field to add one or several class names and then refer to it in your css file or under Appearance > Customize > Additional CSS.', "thememountain-sartre" ),
					),
				/* #69 end */
				'tm_modal_auto_launch' => array(
					esc_html__( 'Auto Launch Modal', "thememountain-sartre" ),
					esc_html__( 'Yes. Determines if the modal should launch automatically upon page load.', "thememountain-sartre" ),
					),
				'tm_modal_auto_launch_delay' => array(
					esc_html__( 'Modal Auto Launch Delay', "thememountain-sartre" ),
					esc_html__( 'Yes. Determines the duration before the animation should begin upon entering the viewport. Expressed in milliseconds i.e. 1000 represents 1 second.', "thememountain-sartre" ),
					),
				'tm_modal_auto_close' => array(
					esc_html__( 'Auto Close Modal', "thememountain-sartre" ),
					esc_html__( 'Determines if should auto close. IMPORTANT: This option will only work if you have added a Contact Form to the modal, where the modal will auto close upon form success.', "thememountain-sartre" ),
					),
				'tm_modal_auto_launch_cookie' => array(
					esc_html__( 'Set Cookie', "thememountain-sartre" ),
					esc_html__( 'Determines if a cookie should be set to prevent the modal from relaunching upon page load. This is useful when create an auto launching subscribe modal.', "thememountain-sartre" ),
					),
				);
		}

		/**
		 * End
		 */
	}
}
