<?php
namespace ThemeMountain;

// ThemeStrings - see theme files
$thememountain_customizer_str = TM_ThemeStrings::$text_strings['customizer'];

/**
 * Page Header Navigation Appearance (tm_page_header_nav_appearance)
 */

// common settings for all the styles

/* Header Navigation Type */
TM_Customizer::tm_add_customizer_field('tm_header_navigation_type',array (
	TM_ThemeStrings::$theme_id, array(
		'type'     => 'select',
		'label'    => $thememountain_customizer_str['tm_header_navigation_type'][0],
		'section'  => 'tm_page_header_nav_appearance',
		'description' => $thememountain_customizer_str['tm_header_navigation_type'][1],
		'default'  => TM_NavMenuServices::get_default_nav_menu_style(),
		'priority' => 10,
		'choices'     => TM_NavMenuServices::get_available_nav_menu_styles(),
		) ));

/* Header Sub Menu Indication */
TM_Customizer::tm_add_customizer_field('tm_header_navigation_header_sub_menu_indicator',array (
	TM_ThemeStrings::$theme_id, array(
		'type'     => 'select',
		'label'    => $thememountain_customizer_str['tm_header_navigation_header_sub_menu_indicator'][0],
		'section'  => 'tm_page_header_nav_appearance',
		'description' => $thememountain_customizer_str['tm_header_navigation_header_sub_menu_indicator'][1],
		'default'  => 'hide',
		'priority' => 10,
		'choices'     => array(
			'hide' => $thememountain_customizer_str['tm_header_navigation_header_sub_menu_indicator'][2],
			'show' => $thememountain_customizer_str['tm_header_navigation_header_sub_menu_indicator'][3]
			),
		) ));

/**
 * These options are used for multiple nav styles
 */
	/** See TM_NavMenuServices::preprocess_custom_options_for_nav_menu() where this is eneueued */
	TM_Customizer::tm_add_customizer_field('tm_page_header_nav_top_header_border_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_page_header_nav_top_header_border_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => 'rgba(255,255,255,0.2)',
			'priority'    => 14,
						'do_custom_enqueue' =>	TRUE,
			'css_selector'	 => '.header-transparent .header-inner > .nav-bar',
			'css' => 'border-bottom-color: %s;',
			'active_callback'  => array(
				array(
					'setting'  => 'tm_header_navigation_type',
					'operator' => 'contains',
					'value'    => array('default','hamburger','hybrid'),
					),
				),
			) ));

	TM_Customizer::tm_add_customizer_field('tm_page_header_nav_body_header_border_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_page_header_nav_body_header_border_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => 'rgba(255,255,255,0.2)',
			'priority'    => 14,
			'do_custom_enqueue' =>	TRUE,
			'css_selector'	 => '.header-background .header-inner, .header-background .header-inner > .nav-bar',
			'css' => 'border-bottom-color: %s;',
			'active_callback'  => array(
				array(
					'setting'  => 'tm_header_navigation_type',
					'operator' => 'contains',
					'value'    => array('default','hamburger','hybrid'),
					),
				),
			) ));

/**
 * Header Cart Badge Color settings
 */

	// Header Cart Badge Bkg Color (colorpicker)
	TM_Customizer::tm_add_customizer_field('tm_page_header_cart_badge_background_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_page_header_cart_badge_background_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => '',
			'priority'    => 22,
			'css_selector'	=> '.header .cart .badge',
			'css'			=> 'background-color: %s;',
			) ));

	// Header Cart Badge Color (colorpicker)
	TM_Customizer::tm_add_customizer_field('tm_page_header_cart_badge_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_page_header_cart_badge_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => '',
			'priority'    => 22,
			'css_selector'	=> '.header .cart .badge',
			'css'			=> 'color: %s;',
			) ));

/**
 * Header shadow options under Customizing > Header Settings > Header Navigation Appearance #245
 * @see ThemeMountain-TM_NavMenuServices.php
 */

	// Sub Menu Shadow Color
	TM_Customizer::tm_add_customizer_field('tm_sub_menu_shadow_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_sub_menu_shadow_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => 'rgba(0,0,0,0.15)',
			'priority'    => 22,
			) ));

	// Sub Menu Horizontal Offset
	TM_Customizer::tm_add_customizer_field('tm_sub_menu_horizontal_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_sub_menu_horizontal_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'css' => '',
		) ));

	// Sub Menu Vertical Offset
	TM_Customizer::tm_add_customizer_field('tm_sub_menu_vertical_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_sub_menu_vertical_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0.2rem',
			'priority' => 22,
			'css' => '',
		) ));

	// Sub Menu Blur
	TM_Customizer::tm_add_customizer_field('tm_sub_menu_blur',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_sub_menu_blur'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0.2rem',
			'priority' => 22,
			'css' => '',
		) ));

	// Sub Menu Spread
	TM_Customizer::tm_add_customizer_field('tm_sub_menu_spread',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_sub_menu_spread'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'css' => '',
		) ));

	// Apply Top Header Shadow (dropdown)
	TM_Customizer::tm_add_customizer_field('tm_apply_top_header_shadow',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'select',
			'label'    => $thememountain_customizer_str['tm_apply_top_header_shadow'][0],
			'section'  => 'tm_page_header_nav_appearance',
			'description' => $thememountain_customizer_str['tm_apply_top_header_shadow'][1],
			'default'  => 'no',
			'priority' => 22,
			'choices'     => array(
				'no' => $thememountain_customizer_str['tm_apply_top_header_shadow'][2],
				'yes' => $thememountain_customizer_str['tm_apply_top_header_shadow'][3]
			),
		) ));

	// Top Header Shadow Color (colorpicker)
	TM_Customizer::tm_add_customizer_field('tm_top_header_shadow_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_top_header_shadow_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => 'rgba(0,0,0,0.15)',
			'priority'    => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_top_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
				),
			),
		) ));

	// Top Header Horizontal Offset
	TM_Customizer::tm_add_customizer_field('tm_top_header_horizontal_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_top_header_horizontal_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_top_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Top Header Vertical Offset
	TM_Customizer::tm_add_customizer_field('tm_top_header_vertical_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_top_header_vertical_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0.4rem',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_top_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Top Header Blur
	TM_Customizer::tm_add_customizer_field('tm_top_header_blur',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_top_header_blur'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '2.4rem',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_top_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Top Header Spread
	TM_Customizer::tm_add_customizer_field('tm_top_header_spread',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_top_header_spread'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_top_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Apply Body Header Shadow (dropdown)
	TM_Customizer::tm_add_customizer_field('tm_apply_body_header_shadow',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'select',
			'label'    => $thememountain_customizer_str['tm_apply_body_header_shadow'][0],
			'section'  => 'tm_page_header_nav_appearance',
			'description' => $thememountain_customizer_str['tm_apply_body_header_shadow'][1],
			'default'  => 'no',
			'priority' => 22,
			'choices'     => array(
				'no' => $thememountain_customizer_str['tm_apply_body_header_shadow'][2],
				'yes' => $thememountain_customizer_str['tm_apply_body_header_shadow'][3]
			),
		) ));

	// Body Header Shadow Color (colorpicker)
	TM_Customizer::tm_add_customizer_field('tm_body_header_shadow_color',array (
		TM_ThemeStrings::$theme_id, array(
			'type'        => 'color-alpha',
			'label'       => $thememountain_customizer_str['tm_body_header_shadow_color'][0],
			'section'     => 'tm_page_header_nav_appearance',
			'default'     => 'rgba(0,0,0,0.15)',
			'priority'    => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_body_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
				),
			),
		) ));

	// Body Header Horizontal Offset
	TM_Customizer::tm_add_customizer_field('tm_body_header_horizontal_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_body_header_horizontal_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_body_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Body Header Vertical Offset
	TM_Customizer::tm_add_customizer_field('tm_body_header_vertical_offset',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_body_header_vertical_offset'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0.4rem',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_body_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Body Header Blur
	TM_Customizer::tm_add_customizer_field('tm_body_header_blur',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_body_header_blur'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '2.4rem',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_body_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

	// Body Header Spread
	TM_Customizer::tm_add_customizer_field('tm_body_header_spread',array (
		TM_ThemeStrings::$theme_id, array(
			'type'     => 'text',
			'label'    => $thememountain_customizer_str['tm_body_header_spread'][0],
			'description' => '',
			'section'  => 'tm_page_header_nav_appearance',
			'default'  => '0',
			'priority' => 22,
			'active_callback'  => array(
				array(
					'setting'  => 'tm_apply_body_header_shadow',
					'operator' => '==',
					'value'    => 'yes',
					),
				),
		) ));

/**
 * All the rest of configs are queued in the nav menu style config files
 *
 * @see        TM_NavMenuServices class
 */
