<?php
namespace ThemeMountain {
	/**
	 * TM Custom Walker Class
	 *
	 * ThemeMountain Mega Menu specs (html Markup example)
	 *
	 * 		li.contains-mega-sub-menu 	(depth 0)
	 * 			a
	 * 			ul.mega-sub-menu
	 * 				li 					First column (depth 1)
	 * 					a
	 * 					ul
	 * 						li 			(depth 2)
	 * 						 	a
	 * 			     		li
	 * 			     			a
	 * 			     li 				Second column (depth 1)
	 * 			     	a
	 * 			     	ul
	 * 			     		li 			(depth 2)
	 * 			    	......
	 *
	 * @package ThemeMountain
	 * @subpackage wordpress-common-assets
	TM_NavMenuCustomField::enqueue_footer_HTML();
	 * @since 1.0
	 *
	 * @see        http://codex.wordpress.org/Function_Reference/wp_nav_menu#Using_a_Custom_Walker_Function Please see this page for how the walker class customization works.
	 */
	class TM_WalkerNavMenu extends \Walker_Nav_Menu {
		/**
		 * Internal register
		 * @var mixed FALSE or depth (Int)
		*/
		public $megamenu = FALSE;

		/**
		 * Theme Location set in the display_element method.
		 */
		public $theme_location = '';

		/**
		 * Overrides defailt Walker_Nav_Menu
		 */

		/**
		 * display_element is called for each menu item.
		 */
		function display_element( $element, &$children_elements, $max_depth, $depth=0, $args, &$output ) {
			// reset
			if($depth === 0) $this->megamenu = FALSE;

			// this theme location. Primarirly used to detect off_canvas_menu
			$this->theme_location = (isset($args[0]->theme_location)) ? $args[0]->theme_location : FALSE;
			// set id of field
			$id_field = $this->db_fields['id'];

			/**
			 * Sets if the menu hierarchy has children. Used for a tag with child menu underneath (start_el())
			 */
			if ( is_object( $args[0] ) ) {
				$args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
			}

			/**
			 * mega menu check up. user has to define megamenu in class attribute to make it a megamenu
			 * the followings set megamenu depth if megamenu is defined at the root
			 * Resets once the mega menu hierarchy is over
			 *
			 * the megamenu is applicable only when the location is "main_nav_menu"
			 */
			if(isset($args[0]->theme_location) && $args[0]->theme_location === 'main_nav_menu') {
				// searches for the megamenu class
				if ($this->megamenu !== FALSE && $depth == 0 ) {
					// the megamenu hierarchy is over
					$this->megamenu = FALSE;
				} else if( $this->megamenu !== FALSE && $depth !== 0 ) {
					// continuing the mega sub menu hiearcy. update the depth level
					$this->megamenu = $depth;
				} else {
					// check up if the hierarchy has megamenu class.
					$_tm_custom_nav = get_post_meta($element->ID, 'menu-item-tm_custom_nav', true);

					if( $_tm_custom_nav === 'megamenu_parent' && $depth == 0 ) {
					// megamenu class found and the current depth is 0
						$this->megamenu = $depth;
					}
				}
			}
			return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
		}

		/**
		 * Called in starting a new UL level. It adds the UL markup to begin with.
		 */
		function start_lvl( &$output, $depth = 0, $args = array() ) {
			$indent = ( $depth > 0 ) ? str_repeat("\t",$depth ) : "";
			$display_depth=($depth+1);
			/**
			 * assign megamenu class to UL once for the mega menu parent hierarchy
			 */
			if($this->megamenu === 0) {
				$class_names = " class='mega-sub-menu row'";
			} else if($this->megamenu > 0) {
				$class_names = " class='menu-even sub-sub-menu menu-depth-".($this->megamenu + 1)."'";
			} else {
				$_classes = array(
					'sub-menu',
					( $display_depth % 2 ? 'menu-odd' : 'menu-even' ),
					( $display_depth >=2 ? 'sub-sub-menu' : '' ),
					'menu-depth-' . $display_depth
					);
				$class_names = " class='".implode( ' ', $_classes )."'";
			}
			/**
			 * Finally add the UL html markup code
			 */
			$output.="\n{$indent}<ul{$class_names}>\n";
		}

		/**
		 * Add up li and a tags underneath each ul level.
		 */
		function start_el(  &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			/**
			 * Do nothing if the following criteria match.
			 */
			if($item->object === 'tm_dropdown' && $this->theme_location === 'off_canvas_menu') return;
			/**
			 * Continue if the item is any other types.
			 */
			global $wp_query;

			/** find indent */
			$indent = ( $depth > 0 ? str_repeat( "\t", $depth ) : '' ); // code indent
			// add misc classes
			$depth_classes = array(
				( $depth == 0 ? 'main-menu-item' : 'sub-menu-item' ),
				( $depth >=2 ? 'sub-sub-menu-item' : '' ),
				( $depth % 2 ? 'menu-item-odd' : 'menu-item-even' ),
				'menu-item-depth-' . $depth
				);

			/**
			 * Add contains-mega-sub-menu class to LI tag if this is the root megamenu level
			 * In other terms it initiates the megamenu.
			 * This is detected only when the $megamenu is set to the depth 0. (once)
			 */
			if($this->megamenu === 0 || $item->object === 'tm_dropdown') {
				array_push($depth_classes, 'contains-mega-sub-menu');
			} else if ($this->megamenu > 0 && $depth === 1) {
				array_push($depth_classes, 'column');
			}
			/**
			 * Class treatment
			 */
			// remove blank
			$depth_classes = array_filter($depth_classes, function($value) { return $value !== ''; });
			// joint array with space
			$depth_class_names = esc_attr( implode( ' ', $depth_classes ) );

			/**
			 * menu id
			 */
			if(isset($args->menu_id)) {
				$id = apply_filters( 'nav_menu_item_id', $args->menu_id. $item->ID, $item, $args, $depth );
				$id = ($id) ? ' id="' . esc_attr( $id ) . '"' : '';
			} else {
				$id = '';
			}

			/**
			 * Find if it is a button / icon or not.
			 */
			$_tm_custom_nav = get_post_meta($item->ID, 'menu-item-tm_custom_nav', true);
			if(preg_match("/button|icon/",$_tm_custom_nav)) {
				// button, icon, tm_modal
				// Class names
				// add current if it is current
				if( $item -> current == true ) array_push($_classes, 'current');
				// build html, LI level
				$_li_level_opener = $indent . '<li>';
				// $item_output
				switch($_tm_custom_nav) {
					case 'button':
						$_url = esc_attr( $item->url );
						$_scroll_link_class = '';
						if (substr($_url,  0, strlen('#')) === '#') {
							$_scroll_link_class = 'scroll-link ';
						}
						$_classes = empty( $item->classes ) ? array() : (array) $item->classes;
						$_class_names = esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $_classes ), $item ) ) );
						$item_output = "<div class='v-align-middle'><a href='{$_url}' class='button {$_scroll_link_class}{$_class_names}'>".apply_filters( 'the_title', $item->title, $item->ID )."</a></div>";
						break;
					case 'icon':
						$_url = esc_attr( $item->url );
						$_scroll_link_class = '';
						if (substr($_url,  0, strlen('#')) === '#') {
							$_scroll_link_class = 'scroll-link ';
						}
						$_classes = empty( $item->classes ) ? array() : (array) $item->classes;
						$_class_names = esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $_classes ), $item ) ) );
						$item_output = "<div class='v-align-middle'><a href='{$_url}' class='nav-icon {$_scroll_link_class}{$_class_names}'><span class='icon-label'>".apply_filters( 'the_title', $item->title, $item->ID )."</span></a></div>";
						break;
					case 'modal_button':
						$_data_aux_classes = get_post_meta($item->ID, 'menu-item-tm_custom_nav_modal_aux_classes', true);

						// $_data_aux_classes def value treatment
						$_data_aux_classes = (empty($_data_aux_classes)) ? 'tml-form-modal height-auto' : 'tml-form-modal height-auto '.$_data_aux_classes;
						// class names
						$_classes = empty( $item->classes ) ? array() : (array) $item->classes;
						$_class_names = esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $_classes ), $item ) ) );
						// output the button markup and enqueue the modal html output
						$item_output = "<div class='v-align-middle'>".TM_NavMenuServices::registerModalButton($item->object_id,apply_filters( 'the_title', $item->title, $item->ID ),$_class_names,$_data_aux_classes)."</div>";
						break;
					default:
						// Any other id beginning with "button"
						return;
				}
			} else {
				/**
				 * Counts child sub menu (only when it is in megamenu mode and the depth level is at 0)
				 */
				if($item->object === 'tm_dropdown'){
					$column_text = $this->get_nav_menu_custom_content($item->object_id,$_tm_custom_nav);
				} else if($this->megamenu === 0) {
					$locations = get_nav_menu_locations();
					if(array_key_exists('main_nav_menu', $locations)){
						$menu = wp_get_nav_menu_object( $locations['main_nav_menu'] );
						$menu_items = wp_get_nav_menu_items($menu->term_id);
						$count = 0;
						if(is_array($menu_items)) {
							foreach( $menu_items as $menu_item ){
								if( $menu_item->menu_item_parent == $item->ID ){
									$count++;
								}
							}
						}
					}
				} else if ($this->megamenu === 1) {
					// megatext
					if(!empty($item->description)) {
						$column_text = '<ul><li><p>'.$item->description.'</p></li></ul>';
					}
				}

				// href check up
				$_url = esc_attr( $item->url );
				$_scroll_link_class = '';
				if (substr($_url,  0, strlen('#')) === '#') {
					$_scroll_link_class = 'scroll-link ';
				}
				// attributes except for class
				$attributes = '';
				$attributes = ! empty( $item->attr_title ) ? ' title="' . esc_attr( $item->attr_title ) .'"' : '';
				$attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) .'"' : '';
				$attributes .= ! empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) .'"' : '';
				$attributes .= (! empty( $item->url ) && $item->object !== 'tm_dropdown') ? ' href="' . $_url .'"' : '';

				// build link attributes for the following A tag right underneath.
				// if it is NOT a megamenu and has_children, add class of contains-sub-menu
				$_contains_sub_menu_class = '';
				if(isset( $args->has_children ) && isset($this->megamenu) && $args->has_children === TRUE && $this->megamenu === FALSE) {
					$attributes .= ' class="menu-link contains-sub-menu ' . $_scroll_link_class . ( $depth > 0 ? 'sub-menu-link' : 'main-menu-link' ) . '"';
					if($args->theme_location === 'main_nav_menu') {
						$_contains_sub_menu_class = ' contains-sub-menu';
					}
				} else {
					$attributes .= ' class="menu-link ' . $_scroll_link_class . ( $depth > 0 ? 'sub-menu-link' : 'main-menu-link' ) . '"';
				}

				// Class name attributes
				// passed classes
				$_classes = empty( $item->classes ) ? array() : (array) $item->classes;
				// add current if it is current
				if( $item -> current == true ) array_push($_classes, 'current');
				// build html, LI level
				$_li_level_opener = $indent . '<li'.$id.' class="' . $depth_class_names . ' ' . esc_attr( implode( ' ', apply_filters( 'nav_menu_css_class', array_filter( $_classes ), $item ) ) ) . $_contains_sub_menu_class. '">';

				// sprintf output
				$item_output = sprintf( '%1$s<a%2$s>%3$s%4$s%5$s</a>%6$s%7$s',
					isset($args->before) ? $args->before : '',
					$attributes,
					isset($args->link_before) ? $args->link_before : '',
					apply_filters( 'the_title', $item->title, $item->ID ),
					isset($args->link_after) ? $args->link_after : '',
					isset($column_text) ? $column_text : '',
					isset($args->after) ? $args->after : ''
					);
			}

			/**
			 * Build html. Requires $_li_level_opener, $item_output, $item, $depth, $args, $id.
			 * $output is a reference.
			 */
			$output .= $_li_level_opener.apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args , $id);
		}

		/**
		 * Ends the element output, if needed. (customized)
		 *
		 * @since 3.0.0
		 *
		 * @see Walker::end_el()
		 *
		 * @param string   $output Passed by reference. Used to append additional content.
		 * @param WP_Post  $item   Page data object. Not used.
		 * @param int      $depth  Depth of page. Not Used.
		 * @param stdClass $args   An object of wp_nav_menu() arguments.
		 */
		public function end_el( &$output, $item, $depth = 0, $args = array() ) {
			//If button, do nothing. Or redandunt LI tag will be output. The button markup has already been output.
			$_tm_custom_nav = get_post_meta($item->ID, 'menu-item-tm_custom_nav', true);
			if(preg_match("/button|icon/",$_tm_custom_nav)) return;
			// When the object is tm_dropdown and is for off_canvas_menu, skip output of closing li tag
			if($item->object === 'tm_dropdown' && (isset($this->theme_location) && $this->theme_location === 'off_canvas_menu')) return;

			if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
				$t = '';
				$n = '';
			} else {
				$t = "\t";
				$n = "\n";
			}
			$output .= "</li>{$n}";
		}

		/**
		 * Custom Nav Menu Content
		 */

		/**
		 * Sub Menu Custom Content
		 */
		/**
		 * Get nav menu custom content description
		 * @param  [type] $menu_url   [description]
		 * @param  [type] $menu_title [description]
		 * @param  [type] $pageID     [description]
		 * @return [type]             [description]
		 */
		public function get_nav_menu_custom_content($pageID,$tm_custom_nav) {
			/* get tm_dropdown content options */
			$_dropdown_content_settings = TM_PageOptions::get_page_options($pageID,'tm_dropdown');
			$_tm_dropdown_width = intval($_dropdown_content_settings['tm_dropdown_width']);
			$_tm_dropdown_style = ($_tm_dropdown_width !=='') ? " style='width:{$_tm_dropdown_width}px;'" : '';
			$_sub_menu_class = ($tm_custom_nav === 'megamenu_parent') ? 'mega-sub-menu' : 'sub-menu';
			if(class_exists('\\ThemeMountain\\TM_Shortcodes') && isset(TM_Shortcodes::$enquque_deferred_style_in_footer)) {
				TM_Shortcodes::$enquque_deferred_style_in_footer = TRUE;
			}
			$_dropdown_content = "<div class='{$_sub_menu_class} custom-content'{$_tm_dropdown_style}>".apply_filters( 'the_content', get_post_field('post_content', $pageID) ).'</div>';
			if(class_exists('\\ThemeMountain\\TM_Shortcodes') && isset(TM_Shortcodes::$enquque_deferred_style_in_footer)) {
				TM_Shortcodes::$enquque_deferred_style_in_footer = FALSE;
			}
			 return $_dropdown_content;
		}

		/**
		 * End
		 */
	}
} // namespace ThemeMountain ends