<?php
/**
 * ThemeMountain namespace reserved for ThemeMountain Wordpress themes
 * If you do not know what namespace is, please read http://php.net/manual/en/language.namespaces.php
 */
namespace ThemeMountain {
	/**
	 * Adds Custom Category Page Feature
	 *
	 * @package ThemeMountain
	 * @subpackage Core
	 * @since 1.0.2
	 */
	class TM_CustomTagList extends TM_ThemeMountain {
		/**
		 * Public Configuration variable
		 */


		/**
		 * End Properties
		 *
		 * Begin Method
		 */

		/**
		 * Class Constructor Magic Method.
		 *
		 * Cache theme version, execute class setup method and add filter for option fields in the admin panel.
		 *
		 * @since 1.0.2
		 * @access public
		 */
		public function __construct() {
			if(is_admin()) {
				// Adds extra fields in category editor
				add_action ( 'edit_tag_form_fields', ['ThemeMountain\\TM_CustomTagList','tm_extra_tag_fields']);
				add_action ( 'tm_folio_edit_tag_form_fields', ['ThemeMountain\\TM_CustomTagList','tm_extra_tag_fields']);
				// Saves a change to settings
				add_action ( 'edit_term', ['ThemeMountain\\TM_CustomTagList','tm_save_extra_tag_fileds']);
			}
		}

		/**
		 * Public Methods to be used in templates
		 */

		/**
		 * Output tags list with enhancement (class attributes)
		 *
		 * @param      Boolean  $use_original  The use wp original
		 */
		public static function tm_tags ($use_original = FALSE,  $before = null, $sep = ', ', $after = '') {
			if($use_original === TRUE) {
				the_tags();
			} else {
				echo apply_filters( 'the_tags', self::tm_get_the_term_list( 0, 'post_tag', $before, $sep, $after ), $before, $sep, $after );
			}
		}

		/**
		 * Retrieve a post's terms as a list with specified format. Based on the Wordpress core code.
		 *
		 * @param int $id Post ID.
		 * @param string $taxonomy Taxonomy name.
		 * @param string $before Optional. Before list.
		 * @param string $sep Optional. Separate items using this.
		 * @param string $after Optional. After list.
		 * @return string|false|WP_Error A list of terms on success, false if there are no terms, WP_Error on failure.
		 */
		public static function tm_get_the_term_list( $id, $taxonomy, $before = '', $sep = '', $after = '' ) {
			$_terms = get_the_terms( $id, $taxonomy );

			if ( is_wp_error( $_terms ) )
				return $_terms;

			if ( empty( $_terms ) )
				return false;

			$_links = array();

			foreach ( $_terms as $_term ) {
				$_link = get_term_link( $_term, $taxonomy );
				if ( is_wp_error( $_link ) ) {
					return $_link;
				}
				// class
				$_class = self::get_custom_tag_class_attribute($taxonomy,$_term->slug);
				$_class_attr = ($_class) ? ' class="post-tag '.esc_attr($_class).'"' : '';
				// add tag link
				$_links[] = '<a href="' . esc_url( $_link ) . '" rel="tag"'.$_class_attr.'>' . $_term->name . '</a>';
			}

			$_term_links = apply_filters( "term_links-{$taxonomy}", $_links );

			return $before . join( $sep, $_term_links ) . $after;
		}

		/**
		 * Public Methods for hooks
		 */

		/**
		 * Add extra category field(s) for custom category page.
		 *
		 * @uses       edit_tag_form_fields Wordpress action hook
		 * @see        TM_TemplateServices::set_current_template_data()
		 */
		public static function tm_extra_tag_fields($tag) {
			/** category Id */
			$_term_id = $tag->term_id;
			// category meta
			$_tag_meta = get_option( "tm_tag_meta_".$_term_id );
			/** find selected */
			$_field_value = (isset($_tag_meta['class_attributes']) && !empty($_tag_meta['class_attributes'])) ? $_tag_meta['class_attributes'] : '';
			?>
			<tr class="form-field">
				<th scope="row" valign="top"><label for="custom_tag_class_attribute[class_attributes]"><?php echo TM_ThemeStrings::$text_strings['TM_CustomTagList']['custom_tag_class_attribute']; ?></label></th>
				<td>
					<input name="custom_tag_class_attribute[class_attributes]" id="custom_tag_class_attribute" type="text" value="<?php echo esc_attr($_field_value); ?>" size="40" aria-required="true" />
		            <p class="description"><?php echo TM_ThemeStrings::$text_strings['TM_CustomTagList']['enter_class_attribute']; ?></p>
		        </td>
			</tr>
			<?php
		}

		/**
		 * Saves settings of extra category field(s) for custom category page.
		 *
		 * @uses       edited_tag Wordpress action hook
		 *
		 */
		public static function tm_save_extra_tag_fileds($term_id) {
			if ( isset( $_POST['custom_tag_class_attribute'] ) ) {
				$_tag_meta = get_option( "tm_tag_meta_".$term_id);
				$_cat_keys = array_keys($_POST['custom_tag_class_attribute']);
				foreach ($_cat_keys as $key){
					if (isset($_POST['custom_tag_class_attribute'][$key])){
						$cat_meta[$key] = $_POST['custom_tag_class_attribute'][$key];
					}
				}
      			//save the option array
				$a = update_option( "tm_tag_meta_".$term_id, $cat_meta );
			}
		}


		/**
		 * Public Methods for both classes and front end template files.
		 */

		/**
		 * Gets the custom category page identifier.
		 *
		 * @see        TM_TemplateServices::set_current_template_data()
		 *
		 * @param      $_taxonomy_slug
		 *
		 * @return     <type>  The custom category page identifier.
		 */
		private static function get_custom_tag_class_attribute($taxonomy,$slug) {
			$_taxonomy_object = get_term_by('slug' , $slug, $taxonomy);
			if($_taxonomy_object) {
				$_term_id = $_taxonomy_object->term_id;
				$_tag_meta = get_option( "tm_tag_meta_".$_term_id);
				if(isset($_tag_meta['class_attributes']) && !empty($_tag_meta['class_attributes'])) {
					return $_tag_meta['class_attributes'];
				} else {
					return FALSE;
				}
			} else {
				return FALSE;
			}
		}

		/**
		 * Protected methods
		 */


		/**
		 * End
		 */
	}
}