<?php
// Shop page
Redux::setSection('saasland_opt', array(
    'title'            => esc_html__( 'Shop Settings', 'saasland' ),
    'id'               => 'shop_opt',
    'icon'             => 'dashicons dashicons-cart',
    'fields'           => array(
        array(
            'title'     => esc_html__('Page title', 'saasland'),
            'subtitle'  => esc_html__('Give here the shop page title', 'saasland'),
            'desc'      => esc_html__('This text will show on the shop page banner', 'saasland'),
            'id'        => 'shop_title',
            'type'      => 'text',
            'default'   => esc_html__('Shop', 'saasland'),
        ),
        array(
            'title'     => esc_html__('Shop Page Subtitle', 'saasland'),
            'id'        => 'shop_subtitle',
            'type'      => 'textarea',
        ),
        array(
            'title'     => esc_html__('Title bar background', 'saasland'),
            'subtitle'  => esc_html__('Upload image file as Shop page title bar background', 'saasland'),
            'id'        => 'shop_header_bg',
            'type'      => 'media',
        ),
        array(
            'title'     => esc_html__('Layout', 'saasland'),
            'subtitle'  => esc_html__('Select the product view layout', 'saasland'),
            'id'        => 'shop_layout',
            'type'      => 'image_select',
            'options'   => array(
                'shop_list' => array(
                    'alt' => esc_html__('List Layout', 'saasland'),
                    'img' => SAASLAND_DIR_IMG.'/layouts/list.jpg'
                ),
                'shop_grid' => array(
                    'alt' => esc_html__('Grid Layout', 'saasland'),
                    'img' => SAASLAND_DIR_IMG.'/layouts/grid.jpg'
                ),
            ),
            'default' => 'shop_grid'
        ),
        array(
            'title'     => esc_html__('Sidebar', 'saasland'),
            'subtitle'  => esc_html__('Select the sidebar position of Shop page', 'saasland'),
            'id'        => 'shop_sidebar',
            'type'      => 'image_select',
            'options'   => array(
                'left' => array(
                    'alt' => esc_html__('Left Sidebar', 'saasland'),
                    'img' => SAASLAND_DIR_IMG.'/layouts/sidebar_left.jpg'
                ),
                'right' => array(
                    'alt' => esc_html__('Right Sidebar', 'saasland'),
                    'img' => SAASLAND_DIR_IMG.'/layouts/sidebar_right.jpg',
                ),
                'full' => array(
                    'alt' => esc_html__('Full Width', 'saasland'),
                    'img' => SAASLAND_DIR_IMG.'/layouts/fullwidth.png',
                ),
            ),
            'default' => 'left'
        ),
        array(
            'title'     => esc_html__('Product Light-box', 'saasland'),
            'id'        => 'is_product_lightbox',
            'type'      => 'switch',
            'on'        => esc_html__('Enabled', 'saasland'),
            'off'       => esc_html__('Disabled', 'saasland'),
            'default'   => '1'
        ),
    ),
));


// Product Single Options
Redux::setSection('saasland_opt', array(
    'title'            => esc_html__( 'Product Single', 'saasland' ),
    'id'               => 'product_single_opt',
    'subsection'       => true,
    'icon'             => '',
    'fields'           => array(
        array(
            'title'     => esc_html__('Related Products Title', 'saasland'),
            'id'        => 'related_products_title',
            'type'      => 'text',
            'default'   => esc_html__('Related products', 'saasland'),
        ),
        array(
            'title'     => esc_html__('Related Products Subtitle', 'saasland'),
            'id'        => 'related_products_subtitle',
            'type'      => 'textarea',
        ),
    )
));