<?php

// Navbar styling
Redux::setSection('saasland_opt', array(
    'title'            => esc_html__( 'Menu Settings', 'saasland' ),
    'id'               => 'menu_opt',
    'icon'             => 'el el-lines',
    'fields'           => array(

        array(
            'id'            => 'menu_typo',
            'type'          => 'typography',
            'title'         => esc_html__( 'Menu Typography', 'saasland'),
            'subtitle'      => esc_html__( 'Menu item typography options', 'saasland'),
            'color'         => false,
            'output'        => '.header_area .navbar .navbar-nav .menu-item a,
                                .menu > .nav-item.submenu .dropdown-menu .nav-item .nav-link'
        ),

        array(
            'id'            => 'thumb_mega_menu_typo',
            'type'          => 'typography',
            'title'         => esc_html__( 'Thumbnail Mega Menu Typography', 'saasland'),
            'subtitle'      => esc_html__( 'Typography options for Thumbnail mega menu.', 'saasland'),
            'output'        => '.menu > .nav-item.submenu.mega_menu.mega_menu_two .mega_menu_inner .dropdown-menu .nav-item .item .text'
        ),

        array(
            'title'     => esc_html__('Menu Item Color', 'saasland'),
            'subtitle'  => esc_html__('Menu item font color', 'saasland'),
            'id'        => 'menu_font_color',
            'output'    => '.header_area .navbar .navbar-nav .menu-item a, .navbar .search_cart .search a.nav-link i',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu Active Color', 'saasland'),
            'subtitle'  => esc_html__('Menu item active and hover font color', 'saasland'),
            'id'        => 'menu_active_font_color',
            'output'    => array(
                'color' => '.header_area .navbar .navbar-nav .menu-item a:hover, .header_area .menu > .nav-item.active .nav-link, 
                            .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item:hover > .nav-link,
                            .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item.active > .nav-link,
                            .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item:hover > .nav-link span.arrow_carrot-right,
                            .menu_six .menu > .nav-item:hover .nav-link, .menu_six .menu > .nav-item.active .nav-link',
            ),
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu item margin', 'saasland'),
            'subtitle'  => esc_html__('Margin around menu item.', 'saasland'),
            'id'        => 'menu_item_margin',
            'type'      => 'spacing',
            'output'    => array( 'header_area .navbar .navbar-nav .menu-item' ),
            'mode'      => 'margin',
            'units'     => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',
        ),

        // Sticky menu settings section
        array(
            'id' => 'sticky_menu_start',
            'type' => 'section',
            'title' => esc_html__('Sticky menu settings', 'saasland'),
            'subtitle' => esc_html__('The following settings will only apply on the sticky header mode..', 'saasland'),
            'indent' => true
        ),

        array(
            'title'     => esc_html__('Menu Color', 'saasland'),
            'subtitle'  => esc_html__('Menu item font color on sticky menu mode.', 'saasland'),
            'id'        => 'sticky_menu_font_color',
            'output'    => '.header_area header.navbar_fixed .menu > .nav-item > .nav-link, header.header_area.navbar_fixed .navbar .navbar-nav .menu-item a',
            'type'      => 'color',
        ),

        array(
            'title'     => esc_html__('Menu Active Color', 'saasland'),
            'subtitle'  => esc_html__('Menu item active font color on header sticky mode', 'saasland'),
            'id'        => 'menu_sticky_active_font_color',
            'output'    => array(
                'color' => '
                    .header_area .navbar_fixed .navbar .navbar-nav .menu-item a:hover, 
                    .header_area .navbar_fixed .menu > .nav-item.active .nav-link,
                    .header_area.navbar_fixed .menu_six .menu > .nav-item:hover > .nav-link,
                    .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item:hover > .nav-link span.arrow_carrot-right,
                    .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item.active > .nav-link, 
                    .menu_six .menu > .nav-item.submenu .dropdown-menu .nav-item:hover > .nav-link,
                    .header_area.navbar_fixed .menu_six .menu > .nav-item.active > .nav-link
                ',
            ),
            'type'      => 'color',
        ),

        array(
            'id'     => 'sticky_menu_end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
));