<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package saasland
 */


// Image sizes
add_image_size('saasland_370x360', 370, 360, true); // Posts carousel thumbnail
add_image_size('saasland_770x480', 770, 480, true); // Blog list thumbnail
add_image_size('saasland_570x340', 570, 340, true);
add_image_size('saasland_110x80', 110, 80, true);
add_image_size('saasland_800x400', 800, 400, true);
add_image_size('saasland_455x600', 455, 600, true);
add_image_size('saasland_520x300', 520, 300, true);
add_image_size('saasland_75x75', 75, 75, true);


// Pagination
function saasland_pagination() {
    the_posts_pagination(array(
        'screen_reader_text' => ' ',
        'prev_text'          => '<i class="ti-arrow-left"></i>',
        'next_text'          => '<i class="ti-arrow-right"></i>'
    ));
}


// Comment list
function saasland_comments($comment, $args, $depth){
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
    ?>
    <li <?php comment_class( $args['has_children'] ? 'post_comment has_children' :'post_comment') ?> id="comment-<?php comment_ID() ?>">
        <div class="media post_author_two">
            <?php
            if(get_avatar($comment)) {
                echo get_avatar($comment, 70, null, null, array('class'=> 'img_rounded'));
            }
            ?>
            <div class="media-body">
                <div class="comment_info">
                    <h3> <?php comment_author(); ?> </h3>
                    <div class="comment-date"> <?php comment_date(get_option('date_format')); ?> </div>
                </div>
                <?php comment_reply_link(array_merge( $args, array('reply_text' => 'Reply' . '<i class="arrow_right"></i>', 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>

                <?php if ($comment->comment_approved == '0') : ?>
                    <em> <?php esc_html_e('Your comment is awaiting moderation.', 'saasland') ?></em><br />
                <?php endif; ?>
                <?php comment_text(); ?>
            </div>
        </div>
    <?php
}


// Social Links
function saasland_social_links() {
    $opt = get_option('saasland_opt');
    ?>
    <?php if(!empty($opt['facebook'])) { ?>
        <li> <a href="<?php echo esc_url($opt['facebook']); ?>"><i class="ti-facebook" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['twitter'])) { ?>
        <li> <a href="<?php echo esc_url($opt['twitter']); ?>"><i class="ti-twitter-alt" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['googleplus'])) { ?>
        <li> <a href="<?php echo esc_url($opt['googleplus']); ?>"><i class="ti-google" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['instagram'])) { ?>
        <li> <a href="<?php echo esc_url($opt['instagram']); ?>"><i class="ti-instagram" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['linkedin'])) { ?>
        <li> <a href="<?php echo esc_url($opt['linkedin']); ?>"><i class="ti-linkedin" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['youtube'])) { ?>
        <li> <a href="<?php echo esc_url($opt['youtube']); ?>"><i class="ti-youtube" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php if(!empty($opt['dribble'])) { ?>
        <li> <a href="<?php echo esc_url($opt['dribble']); ?>"><i class="ti-dribbble" aria-hidden="true"></i></a> </li>
    <?php } ?>
    <?php
}

// Search form
function saasland_search_form($is_button=true) {
    ?>
    <div class="saasland-search">
        <form class="form-wrapper" action="<?php echo esc_url(home_url('/')); ?>" _lpchecked="1">
            <input type="text" id="search" placeholder="<?php esc_attr_e('Search ...', 'saasland'); ?>" name="s">
            <button type="submit" class="btn"><i class="fa fa-search"></i></button>
        </form>
        <?php if($is_button==true) { ?>
        <a href="<?php echo esc_url(home_url('/')); ?>" class="home_btn"> <?php esc_html_e('Back to home Page', 'saasland'); ?> </a>
        <?php } ?>
    </div>
    <?php
}


// Day link to archive page
function saasland_day_link() {
    $archive_year   = get_the_time('Y');
    $archive_month  = get_the_time('m');
    $archive_day    = get_the_time('d');
    echo get_day_link( $archive_year, $archive_month, $archive_day);
}


// Limit latter
function saasland_limit_latter($string, $limit_length, $suffix = '...') {
    if (strlen($string) > $limit_length) {
        echo strip_shortcodes(substr($string, 0, $limit_length) . $suffix);
    }
    else {
        echo strip_shortcodes(esc_html($string));
    }
}


// Get comment count text
function saasland_comment_count($post_id, $no_comments = 'No Comments') {
    $comments_number = get_comments_number($post_id);
    if($comments_number == 0) {
        $comment_text = $no_comments;
    }elseif($comments_number == 1) {
        $comment_text = esc_html__('1 Comment', 'saasland');
    }elseif($comments_number > 1) {
        $comment_text = $comments_number.esc_html__(' Comments', 'saasland');
    }
    echo esc_html($comment_text);
}


// Post's excerpt text
function saasland_excerpt($redux_opt, $settings_key, $echo = true) {
    $opt = get_option($redux_opt);
    $excerpt_limit = !empty($opt[$settings_key]) ? $opt[$settings_key] : 40;
    $excerpt = wp_trim_words(get_the_content(), $excerpt_limit, '');
    if($echo == true) {
        echo esc_html($excerpt);
    }else {
        return esc_html($excerpt);
    }
}


// Get author role
function saasland_get_author_role() {
    global $authordata;
    $author_roles = $authordata->roles;
    $author_role = array_shift($author_roles);
    return esc_html($author_role);
}


// Banner Title
function saasland_banner_title() {
    $opt = get_option('saasland_opt');
    if (class_exists('WooCommerce')) {
        if (is_shop()) {
            echo !empty($opt['shop_title']) ? esc_html($opt['shop_title']) : esc_html__('Shop', 'saasland');
        }
        elseif(is_archive()) {
            the_archive_title();
        }
        elseif(is_home()) {
            $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'saasland');
            echo esc_html($blog_title);
        }
        elseif(is_page() || is_single()) {
            the_title();
        }
        elseif(is_category()) {
            single_cat_title();
        }
        elseif(is_archive()) {
            the_archive_title();
        }
        elseif(is_search()) {
            esc_html_e('Search result for: “', 'saasland'); echo get_search_query().'”';
        }
        else {
            the_title();
        }
    }

    else {
        if (is_home()) {
            $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'saasland');
            echo esc_html($blog_title);
        } elseif (is_page() || is_single()) {
            the_title();
        } elseif (is_category()) {
            single_cat_title();
        } elseif (is_archive()) {
            the_archive_title();
        } elseif (is_search()) {
            esc_html_e('Search result for: “', 'saasland');
            echo get_search_query() . '”';
        } else {
            the_title();
        }
    }
}

function saasland_banner_subtitle() {
    $opt = get_option('saasland_opt');

    if (class_exists('WooCommerce')) {
        if (is_shop()) {
            echo !empty($opt['shop_subtitle']) ? wp_kses_post(nl2br($opt['shop_subtitle'])) : '';
        }
        elseif(is_home()) {
            $blog_subtitle = !empty($opt['blog_subtitle']) ? $opt['blog_subtitle'] : get_bloginfo('description');
            echo esc_html($blog_subtitle);
        }
        elseif(is_page() || is_single()) {
            if(has_excerpt()) {
                while(have_posts()) {
                    the_post();
                    echo nl2br(get_the_excerpt(get_the_ID()));
                }
            }
        }
        else {
            the_title();
        }
    }

    else {
        if (is_home()) {
            $blog_subtitle = !empty($opt['blog_subtitle']) ? $opt['blog_subtitle'] : get_bloginfo('description');
            echo esc_html($blog_subtitle);
        }
        elseif (is_page() || is_single()) {
            if (has_excerpt()) {
                while (have_posts()) {
                    the_post();
                    echo nl2br(get_the_excerpt(get_the_ID()));
                }
            }
        }
    }
}

// Banner 02 subtitle
function saasland_banner_subtitle2() {
    $opt = get_option('saasland_opt');
    if( is_home() ) {
        $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'saasland');
        echo esc_html($blog_title);
    }
    elseif ( is_archive() ) {
        the_archive_title();
    }
    elseif( is_page() || is_single() ) {
        the_title();
    }

}

// Post title array
function saasland_get_postTitleArray($postType = 'post') {
    $post_type_query  = new WP_Query(
        array (
            'post_type'      => $postType,
            'posts_per_page' => -1
        )
    );
    // we need the array of posts
    $posts_array      = $post_type_query->posts;
    // the key equals the ID, the value is the post_title
    if( $posts_array ) {
        $post_title_array = wp_list_pluck($posts_array, 'post_title', 'ID');
    } else {
        $post_title_array['default'] = esc_html__('Default', 'saasland');
    }

    return $post_title_array;
}

/**
 * Get a specific html tag from content
 * @return a specific HTML tag from the loaded content
 */
function saasland_get_html_tag( $tag = 'blockquote', $content = '' ) {
    $dom = new DOMDocument();
    $dom->loadHTML($content);
    $divs = $dom->getElementsByTagName( $tag );
    $i = 0;
    foreach ($divs as $div) {
        if($i == 1) {
            break;
        }
        echo "<p>{$div->nodeValue}</p>";
        ++$i;
    }
}

// Get the page id by page template
function saasland_get_page_template_id( $template = 'page-job-apply-form.php' ) {
    $pages = get_pages(array(
        'meta_key' => '_wp_page_template',
        'meta_value' => $template
    ));
    foreach($pages as $page){
        $page_id = $page->ID;
    }
    return $page_id;
}