<?php
// OneClick Demo Importer
add_filter( 'pt-ocdi/import_files', 'saasland_import_files' );
function saasland_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Main Demo (All Pages)', 'saasland' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demos/all/contents.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/all/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ).'inc/demos/all/screenshot.png',
            'import_notice'                => wp_kses_post(__( 'Install and activate all required plugins before you click on the "Import" button. 
            <br> All pages will be imported. If you fail to import the demo data, follow the alternative way <a href="https://goo.gl/mMLj3B" target="_blank"> here </a>', 'saasland' )),
            'preview_url'                  => '//saasland.droitthemes.com',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/demos/all/settings.json',
                    'option_name' => 'saasland_opt',
                ),
            ),
        ),
        array(
            'import_file_name'             => esc_html__('Demo (Shop Excluded))', 'saasland'),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demos/without_shop/contents.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/without_shop/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ).'inc/demos/without_shop/screenshot.png',
            'import_notice'                => wp_kses_post(__( 'Import this demo, if you no need the Shop pages. WooCommerce and Wishlist plugins are not required for this demo.
            <br>If you fail to import the demo data, follow the alternative way <a href="https://goo.gl/mMLj3B" target="_blank"> here </a>', 'saasland' )),
            'preview_url'                  => '//saasland.droitthemes.com',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/demos/without_shop/settings.json',
                    'option_name' => 'saasland_opt',
                ),
            ),
        ),
        array(
            'import_file_name'             => esc_html__('OnePage', 'saasland'),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demos/onepage/contents.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/onepage/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ).'inc/demos/onepage/screenshot.jpg',
            'import_notice'                => wp_kses_post(__( 'WooCommerce and WooCommerce Wishlist plugins are not required for this demo.
            <br>If you fail to import the demo data, follow the alternative way <a href="https://goo.gl/mMLj3B" target="_blank"> here </a>', 'saasland' )),
            'preview_url'                  => '//saasland.droitthemes.com/onepage',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . 'inc/demos/onepage/settings.json',
                    'option_name' => 'saasland_opt',
                ),
            ),
        ),
        array(
            'import_file_name'             => esc_html__('New Homepages', 'saasland'),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demos/new/contents.xml',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ).'inc/demos/new/screenshot.png',
            'import_notice'                => esc_html__( 'You must have to import a existing demo to import this demo. Only three new homepage demos (Hosting, POS, ERP) will be imported from this.', 'saasland' ),
            'preview_url'                  => 'https://saasland2.droitthemes.com/',
        ),
    );
}


function saasland_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main_menu' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    // Disable Elementor's Default Colors and Default Fonts
    update_option( 'elementor_disable_color_schemes', 'yes' );
    update_option( 'elementor_disable_typography_schemes', 'yes' );
    update_option( 'elementor_global_image_lightbox', '' );

    // Set the home page and blog page
    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'saasland_after_import_setup' );