<?php
defined( 'ABSPATH' ) || die();

require_once __DIR__ . '/widgets/App_info.php';
require_once __DIR__ . '/widgets/Tabs_horizontal.php';
require_once __DIR__ . '/widgets/Appart_features.php';
require_once __DIR__ . '/widgets/Appart_hero_buttons.php';
require_once __DIR__ . '/widgets/Appart_pricing_table.php';
require_once __DIR__ . '/widgets/Appart_screen_feature.php';
require_once __DIR__ . '/widgets/Appart_testimonials.php';
require_once __DIR__ . '/widgets/Navbar_buttons.php';
require_once __DIR__ . '/widgets/Circle_counter.php';
require_once __DIR__ . '/widgets/Client_logos.php';
require_once __DIR__ . '/widgets/counter.php';
require_once __DIR__ . '/widgets/get_app_download.php';
require_once __DIR__ . '/widgets/Event_schedule.php';
require_once __DIR__ . '/widgets/Features.php';
require_once __DIR__ . '/widgets/Features_with_image_dark.php';
require_once __DIR__ . '/widgets/Features_tabs.php';
require_once __DIR__ . '/widgets/Hero_buttons.php';
require_once __DIR__ . '/widgets/Hero_videos.php';
require_once __DIR__ . '/widgets/Hero_integrations.php';
require_once __DIR__ . '/widgets/Hero_app_animated_images.php';

$widgets_map = [
    /**
     * Alert
     */
    'saasland_alerts_box' => [
        'fields'     => [
            [
                'field' => 'alert_title',
                'type' => __('Alert Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'alert_description',
                'type' => __('Alert Description', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
    ],

    /**
     * App Info
     */
    'saasland_appart_app_info' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('App Info: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('App Info: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\App_info',
    ],

    /**
     * Tabs Horizontal
     */
    'Saasland_tabs_horizontal' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Tabs Horizontal: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Tabs_horizontal',
    ],

    /**
     * Call to Action
     */
    'saasland_appart_c2a' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Call to Action: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Call to Action: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'btn_label',
                'type' => __('Call to Action: Button Label', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
    ],

    /**
     * Features
     */
    'saasland_appart_features' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Features: Section Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Features: Section Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Appart_features',
    ],

    /**
     * App Hero
     */
    'saasland_appart_hero' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('App Hero: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('App Hero: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Appart_hero_buttons',
    ],

    /**
     * Hero (Parallax Images)
     */
    'Appart_parallax_hero' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero (Parallax Images): Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero (Parallax Images): Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'btn_label',
                'type' => __('Hero (Parallax Images): Button Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Pricing Table
     */
    'Saasland_appart_pricing_table' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Pricing Table: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Pricing Table: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Appart_pricing_table',
    ],

    /**
     * Products (Grid View)
     */
    'Saasland_appart_products' => [
        'fields' => [
            [
                'field' => 'btn_label',
                'type' => __('Products (Grid View): Button label', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Pricing Table: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
    ],

    /**
     * Screen Features
     */
    'saasland_appart_screen_feature' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Screen Features: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Screen Features: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Appart_screen_feature',
    ],

    /**
     * Single info with icon
     */
    'Saasland_appart_single_info_with_icon' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Single info with icon: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Single info with icon: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
    ],

    /**
     * Single Video 02
     */
    'Saasland_appart_single_video' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Single Video 02: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Single Video 02: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'play_btn_label',
                'type' => __('Single Video 02: Play button label', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Testimonials Style
     */
    'saasland_appart_testimonials' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Testimonials Style: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle_text',
                'type' => __('Testimonials Style: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Appart_testimonials',
    ],

    /**
     * Blog Posts
     */
    'saasland_blog' => [
        'fields' => [
            [
                'field' => 'btn_title',
                'type' => __('Blog Posts: Button Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Bubble Features
     */
    'saasland_bubble_features' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Bubble Features: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Bubble Features: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'btn_title',
                'type' => __('Bubble Features: Button title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Bubble_features',
    ],

    /**
     * Saasland Navbar
     */
    'saasland-navbar' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Navbar_buttons',
    ],

    /**
     * Text Button with Icon
     */
    'saasland_button_icons' => [
        'fields' => [
            [
                'field' => 'btn_label',
                'type' => __('Text Button with Icon: Button Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Call to Action
     */
    'saasland_c2a' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Call to Action: Title', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'btn_label',
                'type' => __('Call to Action: Button Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Circle Counter
     */
    'saasland_circle_counter' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Circle_counter',
    ],

    /**
     * Client Logos
     */
    'saasland_client_logos' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Client_logos',
    ],

    /**
     * Date Countdown
     */
    'saasland_countdown' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Date Countdown: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Stats counter
     */
    'saasland_stats_counter' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Stats counter: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'desc',
                'type' => __('Stats counter: Description Text', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Counter',
    ],

    /**
     * Domain Search form
     */
    'saasland_domain_form' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Domain search form: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Download Section
     */
    'saasland-download-sec' => [
        'fields' => [
            [
                'field' => 'contents',
                'type' => __('Download Section: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Get_app_download',
    ],

    /**
     * Event Schedule Tabs
     */
    'saasland_event_schedule' => [
        'fields' => [
            [
                'field' => 'sec_title',
                'type' => __('Event Schedule Tabs: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Event_schedule',
    ],

    /**
     * FAQ with Tabs
     */
    'saasland_faq' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('FAQ with Tabs: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
    ],

    /**
     * Features
     */
    'saasland_main_features' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Features: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Features: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Features',
    ],

    /**
     * Features Tabs
     */
    'Saasland_features_tabs' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Features_tabs',
    ],

    /**
     * Features (Vertical)
     */
    'Saasland_features_vertical' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Features: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Features: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Features',
    ],

    /**
     * Features with Image (Dark)
     */
    'Saasland_features_with_image' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Features_with_image_dark',
    ],

    /**
     * Features with Image (White)
     */
    'Saasland_features_with_image_white' => [
        'fields' => [],
        'integration-class' => 'SaaslandCore\WPML\Features_with_image_white',
    ],

    /**
     * Features with Shapes (Dark)
     */
    'Saasland_features_with_shapes' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Features with Shapes (Dark): Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'desc',
                'type' => __('Features with Shapes (Dark): Description', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'btn_label',
                'type' => __('Features with Shapes (Dark): Button Title', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Features_with_shapes',
    ],

    /**
     * Hero Mobile
     */
    'saasland-hero-app' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero Mobile: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero Mobile: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_app_animated_images', 'SaaslandCore\WPML\Hero_buttons'],
    ],

    /**
     * Hero Section
     */
    'saasland_hero' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero Section: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero Section: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
            [
                'field' => 'upper_title',
                'type' => __('Hero Section: Upper Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Hero_buttons',
    ],

    /**
     * Hero SEO
     */
    'saasland_hero_seo' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero SEO: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero SEO: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => 'SaaslandCore\WPML\Hero_buttons',
    ],

    /**
     * Hero Video Slides
     */
    'saasland_hero_videos' => [
        'fields' => [
            [
                'field' => 'content',
                'type' => __('Hero Video Slides: Contents', 'saasland-core'),
                'editor_type' => 'VISUAL'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_videos', 'SaaslandCore\WPML\Hero_buttons'],
    ],

    /**
     * Hero Integrations
     */
    'saasland_hero_integration' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero Integrations: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_integrations', 'SaaslandCore\WPML\Hero_buttons'],
    ],

    /**
     * Hero ERP
     */
    'Saasland_hero_erp' => [
        'fields' => [
            [
                'field' => 'title_text',
                'type' => __('Hero ERP: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero ERP: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_buttons'],
    ],

    /**
     * Hero CRM
     */
    'saasland_hero_crm' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero CRM Software: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero CRM Software: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_app_animated_images', 'SaaslandCore\WPML\Hero_buttons'],
    ],

    /**
     * Hero with Background Image
     */
    'saasland_hero_with_bg_img' => [
        'fields' => [
            [
                'field' => 'title',
                'type' => __('Hero with Background Image: Title', 'saasland-core'),
                'editor_type' => 'LINE'
            ],
            [
                'field' => 'subtitle',
                'type' => __('Hero with Background Image: Subtitle', 'saasland-core'),
                'editor_type' => 'AREA'
            ],
        ],
        'integration-class' => ['SaaslandCore\WPML\Hero_buttons'],
    ],
];


foreach ( $widgets_map as $widget_name => $data ) {
    $entry = [
        'conditions' => [
            'widgetType' => $widget_name,
        ],
        'fields' => $data['fields'],
    ];

    if ( isset( $data['integration-class'] ) ) {
        $entry['integration-class'] = $data['integration-class'];
    }

    $widgets[ $widget_name ] = $entry;
}