<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$sku_v = ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'saasland' );

?>
<div class="pr_footer mt_40 mb-30">

    <ul class="product_meta list-unstyled">

        <?php do_action( 'woocommerce_product_meta_start' ); ?>

        <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

            <li class="sku_wrapper"> <span> <?php esc_html_e( 'SKU:', 'saasland' ); ?> </span> <?php echo wp_kses_post($sku_v) ?></li>

        <?php endif; ?>

        <?php echo wc_get_product_category_list( $product->get_id(), ', ', '<li class="posted_in"> <span>' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'saasland' ) .'</span>' , '</li>' ); ?>

        <?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<li class="tagged_as">' . _n( 'Tag:', 'Tags: ', count( $product->get_tag_ids() ), 'saasland' ) . '<span>', '</span></li>' ); ?>

        <?php do_action( 'woocommerce_product_meta_end' ); ?>

    </ul>

    <div class="share-link">
        <label> <?php esc_html_e( 'Share ON:', 'saasland' ) ?> </label>
        <ul class="social-icon list-unstyled">
            <li><a class="facebook" title="<?php esc_attr_e( 'Facebook', 'saasland' ) ?>" href="https://facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="ti-facebook"> </i></a></li>
            <li><a class="twitter" title="<?php esc_attr_e( 'Twitter', 'saasland' ) ?>" href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>"><i class="ti-twitter"> </i></a></li>
            <li><a class="linkedin" title="<?php esc_attr_e( 'Pinterest', 'saasland' ) ?>'" href="https://www.pinterest.com/pin/create/button/?url=<?php the_permalink() ?>"><i class="ti-pinterest"> </i></a></li>
            <li><a class="rss" title="<?php esc_attr_e( 'Linkedin', 'saasland' ) ?>" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink() ?>"><i class="ti-linkedin"> </i></a></li>
        </ul>
    </div>
</div>