<?php
/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$total_item = sizeof(WC()->cart->get_cart());
if (!isset($args) || !isset($args['list_class'])) {
	$args['list_class'] = '';
}
?>

<?php do_action('woocommerce_before_mini_cart'); ?>
<div class="shopping-cart-icon">
    <div class="subtotal-info-wrapper">
        <span class="total-item"><?php echo esc_html($total_item); ?> <?php esc_html_e('Items', 'g5plus-ruby-build'); ?></span> - <?php echo WC()->cart->get_cart_subtotal(); ?>
    </div>
    <div class="icon">
        <a href="<?php echo esc_url( wc_get_cart_url() ); ?>">
            <span><?php echo esc_html($total_item); ?></span>
            <i class="ti-shopping-cart"></i>
        </a>
    </div>
</div>
<div class="shopping-cart-list drop-shadow">
	<ul class="cart_list product_list_widget <?php echo esc_attr($args['list_class']); ?>">
		<?php  do_action( 'woocommerce_before_mini_cart_contents' ); ?>
		
		<?php if (!WC()->cart->is_empty()) : ?>

			<?php
			foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
				$_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
				$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

				if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
                    $product_name      = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
                    $thumbnail         = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                    $product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                    $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
					?>
					<li class="<?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>">
						<?php
						echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
							'<a href="%s" class="remove" title="%s" data-product_id="%s" data-product_sku="%s"><i class="ion-android-close"></i></a>',
							esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
							esc_html__('Remove this item', 'g5plus-ruby-build'),
							esc_attr($product_id),
							esc_attr($_product->get_sku())
						), $cart_item_key);
						?>
						<?php if (!$_product->is_visible()) : ?>
							<?php echo str_replace(array('http:', 'https:'), '', $thumbnail) . $product_name . '&nbsp;'; ?>
						<?php else : ?>
							<a href="<?php echo esc_url($product_permalink); ?>" class="product-item-name">
								<?php echo str_replace(array('http:', 'https:'), '', $thumbnail) . '<span>' . $product_name .'</span>'; ?>
							</a>
						<?php endif; ?>
						<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>

						<?php echo apply_filters('woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf('%s &times; %s', $product_price, $cart_item['quantity']) . '</span>', $cart_item, $cart_item_key); ?>
					</li>
				<?php
				}
			}
			?>

		<?php else : ?>
            <?php $cart_empty_text = g5plusRubyBuild()->options()->get_shop_cart_empty_text();?>
			<li class="empty"><?php echo wp_kses_post($cart_empty_text); ?></li>
		<?php endif; ?>
		<?php  do_action( 'woocommerce_mini_cart_contents' ); ?>
	</ul>
	<!-- end product list -->

	<?php if (!WC()->cart->is_empty()) : ?>

		<p class="total"><strong><?php _e('Subtotal', 'g5plus-ruby-build'); ?>
				:</strong> <?php echo WC()->cart->get_cart_subtotal(); ?></p>

		<?php do_action('woocommerce_widget_shopping_cart_before_buttons'); ?>

		<p class="buttons">
			<a href="<?php echo esc_url(wc_get_cart_url()); ?>"
			   class="wc-forward btn btn-outline btn-sm btn-black"><?php _e('View Cart', 'g5plus-ruby-build'); ?></a>
			<a href="<?php echo esc_url(wc_get_checkout_url()); ?>"
			   class="checkout wc-forward btn btn-black btn-sm"><?php _e('Checkout', 'g5plus-ruby-build'); ?></a>
		</p>

	<?php endif; ?>

	<?php do_action('woocommerce_after_mini_cart'); ?>
</div>