<?php
/**
 * The template for displaying post-author-info.php
 */
$single_author_info_enable = g5plusRubyBuild()->options()->get_single_author_info_enable();
$author_description = get_the_author_meta('description');
if (($single_author_info_enable !== 'on') || empty($author_description)) return;
?>
<div class="gf-author-info-wrap">
	<div class="gf-author-avatar">
		<?php
		$author_bio_avatar_size = apply_filters( 'g5plus_author_bio_avatar_size', 120 );
		echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
		?>
	</div>
	<div class="gf-author-content">
		<h2 class="gf-author-title"><?php esc_html_e('About The Author', 'g5plus-ruby-build')?></h2>
		<?php g5plusRubyBuild()->templates()->userSocialNetworks(get_the_author_meta('ID')); ?>
        <p class="gf-author-description text-italic"><?php echo wp_kses_post($author_description);?></p>
	</div>
</div>
