<?php
/**
 * The template for displaying social-share.php
 * @var $page_permalink
 * @var $page_title
 * @var $layout - Accepts 'classic', 'circle', 'square'
 * @var $show_title
 */
$social_share = g5plusRubyBuild()->metaBoxOurTeam()->get_social_networks();
if (sizeof($social_share) === 0) return;
$wrapper_classes = array(
	'gsf-our-team-share',
	'gf-social-icon',
	'gf-inline'
);
$wrapper_class = implode(' ', array_filter($wrapper_classes));
?>
<ul class="<?php echo esc_attr($wrapper_class)?>">
	<?php foreach($social_share as $social_share_item) {
		if(!empty($social_share_item['social_link']) && !empty($social_share_item['social_icon'])):
			$link = $social_share_item['social_link'];
			$icon = $social_share_item['social_icon'];
			$social_name = $social_share_item['social_name'];?>
			<li class="<?php echo esc_attr($social_name);?>">
			<a  href="<?php echo esc_url($link); ?>" data-toggle="tooltip" title="<?php echo esc_attr($social_name)?>" target="_blank" rel="nofollow">
				<i class="<?php echo esc_attr($icon); ?>"></i>
			</a>
			</li>
		<?php endif;
	}
	?>
</ul>
