<?php
/**
 * The template for displaying content-large-image
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 * @var $image_size
 * @var $post_class
 * @var $post_inner_class
 * @var $placeholder_enable
 */
/*add_action('g5plus_ruby_build_after_post_thumbnail',array(g5plusRubyBuild()->blog(),'cat_badge_markup'));*/
?>
<article <?php post_class($post_class) ?>>
	<div class="<?php echo esc_attr($post_inner_class); ?>">
		<?php g5plusRubyBuild()->blog()->render_post_thumbnail_markup(array(
			'image_size' => $image_size,
			'placeholder_enable' => $placeholder_enable,
			'mode' => 'full'
		)); ?>
		<div class="gf-post-content">
			<div class="gf-post-title-wrap">
				<?php g5plusRubyBuild()->helper()->getTemplate('loop/post-title') ?>
				<?php g5plusRubyBuild()->helper()->getTemplate('loop/post-meta') ?>
			</div>
			<div class="gf-post-excerpt">
				<?php the_excerpt(); ?>
			</div>
			<a href="<?php the_permalink(); ?>" class="btn-read-more accent-color fs-14 heading_font">
				<?php esc_html_e('Read More', 'g5plus-ruby-build'); ?>
				<i class="fa fa-long-arrow-right"></i>
			</a>
		</div>
	</div>
</article>
<?php /*remove_action('g5plus_ruby_build_after_post_thumbnail',array(g5plusRubyBuild()->blog(),'cat_badge_markup')); */?>