<?php
/**
 * The template for displaying layout-1
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 * @var $header_layout
 * @var $header_float_enable
 * @var $header_border
 * @var $header_content_full_width
 * @var $header_sticky_enable
 * @var $navigation_skin
 * @var $page_menu
 */

$header_classes = array(
	'header-wrap'
);

$header_above_inner_classes = array(
	'header-inner',
	'clearfix'
);

$header_above_classes = array(
	'header-above'
);

$navigation_classes = array(
	'primary-menu'
);

$navigation_inner_classes = array(
	'primary-menu-inner',
    'x-nav-menu-container'
);

$navigation_skin_attributes = array();

if (!empty($navigation_skin)) {
	$navigation_skin_classes = g5plusRubyBuild()->helper()->getSkinClass($navigation_skin);
    $navigation_inner_classes = array_merge($navigation_inner_classes, $navigation_skin_classes);
	$navigation_skin_attributes[] = 'data-nav-skin="gf-skin ' . $navigation_skin . '"';
}

if ($header_border === 'container') {
	$navigation_inner_classes[] = 'gf-border-bottom';
	$navigation_inner_classes[] = 'border-color';
}

if ($header_border == 'full') {
	$header_classes[] = 'gf-border-bottom';
	$header_classes[] = 'border-color';
}

if ($header_sticky_enable == 'on') {
	$navigation_classes[] = 'header-sticky';
}

if ($header_content_full_width === 'on') {
	$header_above_classes[] = 'header-full-width';
	$header_classes[] = 'header-full-width';
}

$header_above_border = g5plusRubyBuild()->options()->get_header_above_border();
if ($header_above_border === 'container') {
	$header_above_inner_classes[] = 'gf-border-bottom';
	$header_above_inner_classes[] = 'border-color';
}

if ($header_above_border == 'full') {
	$header_above_classes[] = 'gf-border-bottom';
	$header_above_classes[] = 'border-color';
}

$header_class = implode(' ', array_filter($header_classes));
$header_above_inner_class = implode(' ', array_filter($header_above_inner_classes));
$header_above_class = implode(' ', array_filter($header_above_classes));
$navigation_class = implode(' ', array_filter($navigation_classes));
$navigation_inner_class = implode(' ', array_filter($navigation_inner_classes));
?>
<div class="<?php echo esc_attr($header_class) ?>">
	<div class="<?php echo esc_attr($header_above_class); ?>">
		<div class="container">
			<div class="<?php echo esc_attr($header_above_inner_class) ?>">
				<?php g5plusRubyBuild()->helper()->getTemplate('header/desktop/logo', array('header_layout' => $header_layout)); ?>
				<?php g5plusRubyBuild()->helper()->getTemplate('header/header-customize', array('customize_location' => 'right', 'canvas_position' => 'right')); ?>
			</div>
		</div>
	</div>
    <div class="<?php echo esc_attr($navigation_class); ?>">
        <nav class="container">
            <div <?php echo implode(' ', $navigation_skin_attributes); ?> class="<?php echo esc_attr($navigation_inner_class); ?>">
                <?php if (has_nav_menu('primary') || $page_menu): ?>
                    <?php
                    $arg_menu = array(
                        'menu_id'        => 'main-menu',
                        'container'      => '',
                        'theme_location' => 'primary',
                        'menu_class'     => 'main-menu heading-color clearfix',
                        'main_menu'      => true
                    );
                    if (!empty($page_menu)) {
                        $arg_menu['menu'] = $page_menu;
                    }
                    wp_nav_menu($arg_menu);
                    ?>
                <?php else: ?>
                    <div class="no-menu"><?php printf(wp_kses_post(__('Please assign a menu to the <b>Primary Menu</b> in Appearance > <a title="Menus" href="%s">Menus</a>', 'g5plus-ruby-build')), admin_url('nav-menus.php')); ?></div>
                <?php endif; ?>
                <?php g5plusRubyBuild()->helper()->getTemplate('header/header-customize', array('customize_location' => 'nav', 'canvas_position' => 'right')); ?>
            </div>
        </nav>
    </div>

</div>


