<?php
/**
 * The template for displaying header.php
 *
 * @package WordPress
 * @subpackage ruby build
 * @since ruby build 1.0
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<?php
	/**
	 * @hooked - g5plusRubyBuild()->templates()->site_loading() - 5
	 **/
	do_action('g5plus_ruby_build_before_page_wrapper');
	?>
	<?php
		/**
		 * Color Skin
		 */
		$skin = g5plusRubyBuild()->options()->get_content_skin();
		$skin_classes = g5plusRubyBuild()->helper()->getSkinClass($skin);
		$class  = implode(' ',$skin_classes);
	?>
	<!-- Open Wrapper -->
	<div id="gf-wrapper" class="<?php echo esc_attr($class)?>">
		<?php
		/**
		 * @hooked - g5plusRubyBuild()->templates()->top_drawer() - 10
		 * @hooked - g5plusRubyBuild()->templates()->header() - 15
		 **/
		do_action('g5plus_ruby_build_before_page_wrapper_content');
		?>
		<!-- Open Wrapper Content -->
		<div id="wrapper-content" class="clearfix ">
			<?php
			/**
			 *
			 * @hooked - g5plusRubyBuild()->templates()->content_wrapper_start() - 1
			 **/
			do_action('g5plus_ruby_build_main_wrapper_content_start');
			?>
