<?php

namespace Arts\Optimizer\Managers;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class HTML
 *
 * Used to manage the HTML output buffer.
 *
 * @package Arts\Optimizer\Managers
 */
class HTML extends BaseManager {
	/**
	 * Removes unnecessary white space from HTML more efficiently.
	 *
	 * @param string $buffer The HTML output buffer.
	 * @return string The minified HTML.
	 */
	public function remove_white_space( $buffer ) {
		$pattern     = '~>\s*\n\s*<~';
		$replacement = '><';

		// For extremely large buffers, use chunking
		if ( strlen( $buffer ) > 1000000 ) { // 1MB+
			$chunks = str_split( $buffer, 50000 );
			$result = '';

			foreach ( $chunks as $chunk ) {
				$result .= preg_replace( $pattern, $replacement, $chunk );
			}

			return $result;
		}

		// For normal sized buffers, use simple regex
		return preg_replace( $pattern, $replacement, $buffer );
	}
}
