<?php
/**
 * Plugin Name: Rhye Core
 * Description: Core Plugin for Rhye WordPress Theme
 * Plugin URI: https://artemsemkin.com/
 * Version: 4.2.0
 * Requires at least: 6.4
 * Requires PHP: 7.0
 * Author: Artem Semkin
 * Update URI: artemsemkin.com
 * Tested up to: 6
 * Text Domain: rhye
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once __DIR__ . '/vendor/autoload.php';

use \Arts\Utilities\Utilities;

$theme_version  = Utilities::get_parent_theme_version();
$plugin_version = Utilities::get_plugin_version( __FILE__ );
$theme_slug     = Utilities::get_parent_theme_slug();

define( 'ARTS_RHYE_CORE_PLUGIN_THEME_VERSION', $theme_version );
define( 'ARTS_RHYE_CORE_PLUGIN_VERSION', $plugin_version );
define( 'ARTS_RHYE_CORE_PLUGIN_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'ARTS_RHYE_CORE_PLUGIN_URL', untrailingslashit( plugin_dir_url( __FILE__ ) ) );

/**
 * Theme Constants
 */
require_once __DIR__ . '/inc/constants.php';

/**
 * ACF Helper Functions
 */
require_once __DIR__ . '/inc/acf_helpers.php';

/**
 * Ability to upload custom fonts
 * to the media library
 */
require_once __DIR__ . '/inc/add_custom_mime_types.php';

/**
 * Register Custom Elementor Widgets
 */
require_once __DIR__ . '/elementor/rhye_elementor_extension.php';

/**
 * Extra Panels: Document Settings
 */
require_once __DIR__ . '/elementor/document/page_header.php';
require_once __DIR__ . '/elementor/document/page_masthead.php';
require_once __DIR__ . '/elementor/document/page_bottom_navigation.php';
require_once __DIR__ . '/elementor/document/page_footer.php';
require_once __DIR__ . '/elementor/document/page_ajax.php';

/**
 * Extra Panels: Elementor Section
 */
require_once __DIR__ . '/elementor/extensions/section_settings.php';

/**
 * Extra Panels: Elementor Column
 */
require_once __DIR__ . '/elementor/extensions/column_settings.php';

/**
 * Register Custom Post Types
 */
require_once __DIR__ . '/inc/cpt.php';

/**
 * Elementor Helper Functions
 */
require_once __DIR__ . '/inc/helper_functions.php';

/**
 * Plugin Frontend
 */
require_once __DIR__ . '/inc/frontend.php';

/**
 * Shortcodes
 */
require_once __DIR__ . '/inc/shortcodes.php';

/**
 * Taxonomies
 */
require_once __DIR__ . '/inc/taxonomies.php';

/**
 * WordPress Custom Widgets
 */
require_once __DIR__ . '/inc/widgets.php';

/**
* ArtsOptimizer Configuration
*/
add_filter( 'arts/optimizer/preloads_injection_enabled', 'filter_arts_optimizer_preload_injection_enabled' );
if ( ! function_exists( 'filter_arts_optimizer_preload_injection_enabled' ) ) {
	function filter_arts_optimizer_preload_injection_enabled( $enabled ) {
		$enabled = get_theme_mod( 'inject_preload_prefetch_links_enabled', true );

		return $enabled;
	}
}

add_filter( 'arts/optimizer/preloads/enqueue_css_assets', 'filter_arts_optimizer_enqueue_preloaded_css_as_stylesheets_enabled' );
if ( ! function_exists( 'filter_arts_optimizer_enqueue_preloaded_css_as_stylesheets_enabled' ) ) {
	function filter_arts_optimizer_enqueue_preloaded_css_as_stylesheets_enabled( $enabled ) {
		$enabled = get_theme_mod( 'inject_preload_prefetch_links_enabled', true ) && get_theme_mod( 'enqueue_preloaded_css_as_stylesheets_enabled', false );

		return $enabled;
	}
}

add_filter( 'arts/optimizer/html_minification_enabled', 'filter_arts_optimizer_html_minification_enabled' );
if ( ! function_exists( 'filter_arts_optimizer_html_minification_enabled' ) ) {
	function filter_arts_optimizer_html_minification_enabled( $enabled ) {
		$enabled = get_theme_mod( 'html_minification_enabled', false );

		return $enabled;
	}
}

\Arts\Optimizer\Plugin::instance();
/**
 * Plugins Updater
 */
new \Arts\PluginsUpdater\Plugin(
	array(
		'theme_id'        => $theme_slug,
		'current_plugin'  => array(
			'update_uri' => 'artemsemkin.com',
			'plugin_id'  => plugin_basename( __FILE__ ),
			'endpoint'   => esc_url( "https://artemsemkin.com/wp-json/edd/v1/update/{$theme_slug}/core-plugin" ),
			'method'     => 'POST',
			'icons'      => array(
				'svg' => esc_url( trailingslashit( ARTS_RHYE_CORE_PLUGIN_URL ) . 'assets/icon.svg' ),
				'1x'  => esc_url( trailingslashit( ARTS_RHYE_CORE_PLUGIN_URL ) . 'assets/icon-128x128.jpg' ),
				'2x'  => esc_url( trailingslashit( ARTS_RHYE_CORE_PLUGIN_URL ) . 'assets/icon-256x256.jpg' ),
			),
			'banners'    => array(
				'low'  => esc_url( trailingslashit( ARTS_RHYE_CORE_PLUGIN_URL ) . 'assets/banner-772x250.jpg' ),
				'high' => esc_url( trailingslashit( ARTS_RHYE_CORE_PLUGIN_URL ) . 'assets/banner-1544x500.jpg' ),
			),
		),
		'bundled_plugins' => array(
			'acf_pro' => array(
				'plugin_id' => 'advanced-custom-fields-pro/acf.php',
				'endpoint'  => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/update/acf-pro/plugin' ),
				'method'    => 'POST',
			),
		),
	),
	array(
		'error-json-decode'         => 'Failed to decode JSON response.',
		'error-fetch'               => 'Failed to fetch remote data.',
		'license-page-url'          => admin_url( "admin.php?page={$theme_slug}-license" ),
		'license-page-text'         => 'Theme License',
		'license-purchase-url-text' => 'Envato Market',
	)
);

add_action( 'init', 'arts_load_textdomain' );
function arts_load_textdomain() {
	load_plugin_textdomain( 'rhye' );
}
