<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

if ( ! function_exists( 'arts_get_document_option' ) ) {
	/**
	 * Retrieve a specific document option for a given post.
	 *
	 * @param string   $option_name    The name of the option to retrieve.
	 * @param int|null $post_id        The ID of the post. Defaults to null.
	 * @param mixed    $option_default The value to return if the option is not found. Defaults to an empty string.
	 *
	 * @return mixed The value of the option, or the fallback value if not found.
	 *
	 * @deprecated 4.0.0 Use `\Arts\Utilities\Utilities::get_document_option()` method instead.
	 */
	function arts_get_document_option( $option, $post_id = null, $option_default = false ) {
		if ( did_action( 'elementor/loaded' ) ) {
			return Utilities::get_document_option( $option, $post_id, $option_default );
		} else {
			return $option_default;
		}
	}
}

if ( ! function_exists( 'arts_elementor_get_document_option' ) ) {
	/**
	 * Retrieve a specific document option for a given post.
	 *
	 * @param string   $option_name    The name of the option to retrieve.
	 * @param int|null $post_id        The ID of the post. Defaults to null.
	 * @param mixed    $option_default The value to return if the option is not found. Defaults to an empty string.
	 *
	 * @return mixed The value of the option, or the fallback value if not found.
	 * @deprecated 4.0.0 Use `\Arts\Utilities\Utilities::get_document_option()` method instead.
	 */
	function arts_elementor_get_document_option( $option, $post_id = null, $option_default = false ) {
		return Utilities::get_document_option( $option, $post_id, $option_default );
	}
}

if ( ! function_exists( 'arts_is_async_assets_loading_enabled' ) ) {
	/**
	 * Check the theme compatibility with async assets loading mode and if it's actually enabled
	 *
	 * @return bool
	 * @deprecated 2.4.0
	 */
	function arts_is_async_assets_loading_enabled() {
		return true;
	}
}

if ( ! function_exists( 'arts_is_elementor_editor_active' ) ) {
	/**
	 * Checks if the Elementor editor is active and in preview mode.
	 *
	 * @return bool True if Elementor editor is active and in preview mode, false otherwise.
	 * @deprecated 4.0.0 Use `\Arts\Utilities\Utilities::is_elementor_editor_active()` method instead.
	 */
	function arts_is_elementor_editor_active() {
		return Utilities::is_elementor_editor_active();
	}
}

if ( ! function_exists( 'arts_get_gmap_key' ) ) {
	/**
	 * Retrieve the Google Maps API key.
	 *
	 * It first checks for the key stored under the `elementor_google_maps_api_key` option.
	 * If that key is not found or is invalid, it then checks for a legacy key stored under the 'arts_gmap' option.
	 *
	 * @return string The Google Maps API key if found, otherwise an empty string.
	 */
	function arts_get_gmap_key() {
		$gmap_key = get_option( 'elementor_google_maps_api_key' );

		if ( is_string( $gmap_key ) && ! empty( $gmap_key ) ) {
			return $gmap_key;
		}

		$gmap_key_legacy = get_option( 'arts_gmap' );

		if ( is_array( $gmap_key_legacy ) && array_key_exists( 'key', $gmap_key_legacy ) && is_string( $gmap_key_legacy['key'] ) && ! empty( $gmap_key_legacy['key'] ) ) {
			return $gmap_key_legacy['key'];
		}

		return '';
	}
}
