<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'elementor/element/column/layout/before_section_end', 'arts_add_responsive_column_order', 10, 2 );
/**
 * Add responsive column order control to Elementor column element
 *
 * @param \Elementor\Element_Base $element Elementor element instance
 * @param array                   $args Elementor element arguments
 *
 * @return void
 */
function arts_add_responsive_column_order( $element, $args ) {
	$element->add_responsive_control(
		'responsive_column_order',
		array(
			'label'     => esc_html__( 'Responsive Column Order', 'rhye' ),
			'type'      => \Elementor\Controls_Manager::NUMBER,
			'separator' => 'before',
			'selectors' => array(
				'{{WRAPPER}}' => '-webkit-order: {{VALUE}}; -ms-flex-order: {{VALUE}}; order: {{VALUE}};',
			),
		)
	);
}
