/*!
 * Arts License Manager v1.0.2
 * https://artemsemkin.com
 * © 2025 Artem Semkin
 * License: MIT
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["ArtsNoticeManager"] = factory();
	else
		root["ArtsNoticeManager"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __objRest: () => (/* binding */ __objRest),
/* harmony export */   __spreadProps: () => (/* binding */ __spreadProps),
/* harmony export */   __spreadValues: () => (/* binding */ __spreadValues)
/* harmony export */ });
"use client";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   batch: () => (/* binding */ batch),
/* harmony export */   createStore: () => (/* binding */ createStore),
/* harmony export */   init: () => (/* binding */ init),
/* harmony export */   mergeStore: () => (/* binding */ mergeStore),
/* harmony export */   omit: () => (/* binding */ omit2),
/* harmony export */   pick: () => (/* binding */ pick2),
/* harmony export */   setup: () => (/* binding */ setup),
/* harmony export */   subscribe: () => (/* binding */ subscribe),
/* harmony export */   sync: () => (/* binding */ sync),
/* harmony export */   throwOnConflictingProps: () => (/* binding */ throwOnConflictingProps)
/* harmony export */ });
/* harmony import */ var _PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PBFD2E7P.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";



// src/utils/store.ts
function getInternal(store, key) {
  const internals = store.__unstableInternals;
  (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.invariant)(internals, "Invalid store");
  return internals[key];
}
function createStore(initialState, ...stores) {
  let state = initialState;
  let prevStateBatch = state;
  let lastUpdate = Symbol();
  let destroy = _PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.noop;
  const instances = /* @__PURE__ */ new Set();
  const updatedKeys = /* @__PURE__ */ new Set();
  const setups = /* @__PURE__ */ new Set();
  const listeners = /* @__PURE__ */ new Set();
  const batchListeners = /* @__PURE__ */ new Set();
  const disposables = /* @__PURE__ */ new WeakMap();
  const listenerKeys = /* @__PURE__ */ new WeakMap();
  const storeSetup = (callback) => {
    setups.add(callback);
    return () => setups.delete(callback);
  };
  const storeInit = () => {
    const initialized = instances.size;
    const instance = Symbol();
    instances.add(instance);
    const maybeDestroy = () => {
      instances.delete(instance);
      if (instances.size) return;
      destroy();
    };
    if (initialized) return maybeDestroy;
    const desyncs = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.getKeys)(state).map(
      (key) => (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.chain)(
        ...stores.map((store) => {
          var _a;
          const storeState = (_a = store == null ? void 0 : store.getState) == null ? void 0 : _a.call(store);
          if (!storeState) return;
          if (!(0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(storeState, key)) return;
          return sync(store, [key], (state2) => {
            setState(
              key,
              state2[key],
              // @ts-expect-error - Not public API. This is just to prevent
              // infinite loops.
              true
            );
          });
        })
      )
    );
    const teardowns = [];
    for (const setup2 of setups) {
      teardowns.push(setup2());
    }
    const cleanups = stores.map(init);
    destroy = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.chain)(...desyncs, ...teardowns, ...cleanups);
    return maybeDestroy;
  };
  const sub = (keys, listener, set = listeners) => {
    set.add(listener);
    listenerKeys.set(listener, keys);
    return () => {
      var _a;
      (_a = disposables.get(listener)) == null ? void 0 : _a();
      disposables.delete(listener);
      listenerKeys.delete(listener);
      set.delete(listener);
    };
  };
  const storeSubscribe = (keys, listener) => sub(keys, listener);
  const storeSync = (keys, listener) => {
    disposables.set(listener, listener(state, state));
    return sub(keys, listener);
  };
  const storeBatch = (keys, listener) => {
    disposables.set(listener, listener(state, prevStateBatch));
    return sub(keys, listener, batchListeners);
  };
  const storePick = (keys) => createStore((0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.pick)(state, keys), finalStore);
  const storeOmit = (keys) => createStore((0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.omit)(state, keys), finalStore);
  const getState = () => state;
  const setState = (key, value, fromStores = false) => {
    var _a;
    if (!(0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(state, key)) return;
    const nextValue = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.applyState)(value, state[key]);
    if (nextValue === state[key]) return;
    if (!fromStores) {
      for (const store of stores) {
        (_a = store == null ? void 0 : store.setState) == null ? void 0 : _a.call(store, key, nextValue);
      }
    }
    const prevState = state;
    state = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, state), { [key]: nextValue });
    const thisUpdate = Symbol();
    lastUpdate = thisUpdate;
    updatedKeys.add(key);
    const run = (listener, prev, uKeys) => {
      var _a2;
      const keys = listenerKeys.get(listener);
      const updated = (k) => uKeys ? uKeys.has(k) : k === key;
      if (!keys || keys.some(updated)) {
        (_a2 = disposables.get(listener)) == null ? void 0 : _a2();
        disposables.set(listener, listener(state, prev));
      }
    };
    for (const listener of listeners) {
      run(listener, prevState);
    }
    queueMicrotask(() => {
      if (lastUpdate !== thisUpdate) return;
      const snapshot = state;
      for (const listener of batchListeners) {
        run(listener, prevStateBatch, updatedKeys);
      }
      prevStateBatch = snapshot;
      updatedKeys.clear();
    });
  };
  const finalStore = {
    getState,
    setState,
    __unstableInternals: {
      setup: storeSetup,
      init: storeInit,
      subscribe: storeSubscribe,
      sync: storeSync,
      batch: storeBatch,
      pick: storePick,
      omit: storeOmit
    }
  };
  return finalStore;
}
function setup(store, ...args) {
  if (!store) return;
  return getInternal(store, "setup")(...args);
}
function init(store, ...args) {
  if (!store) return;
  return getInternal(store, "init")(...args);
}
function subscribe(store, ...args) {
  if (!store) return;
  return getInternal(store, "subscribe")(...args);
}
function sync(store, ...args) {
  if (!store) return;
  return getInternal(store, "sync")(...args);
}
function batch(store, ...args) {
  if (!store) return;
  return getInternal(store, "batch")(...args);
}
function omit2(store, ...args) {
  if (!store) return;
  return getInternal(store, "omit")(...args);
}
function pick2(store, ...args) {
  if (!store) return;
  return getInternal(store, "pick")(...args);
}
function mergeStore(...stores) {
  const initialState = stores.reduce((state, store2) => {
    var _a;
    const nextState = (_a = store2 == null ? void 0 : store2.getState) == null ? void 0 : _a.call(store2);
    if (!nextState) return state;
    return Object.assign(state, nextState);
  }, {});
  const store = createStore(initialState, ...stores);
  return Object.assign({}, ...stores, store);
}
function throwOnConflictingProps(props, store) {
  if (false) {}
  if (!store) return;
  const defaultKeys = Object.entries(props).filter(([key, value]) => key.startsWith("default") && value !== void 0).map(([key]) => {
    var _a;
    const stateKey = key.replace("default", "");
    return `${((_a = stateKey[0]) == null ? void 0 : _a.toLowerCase()) || ""}${stateKey.slice(1)}`;
  });
  if (!defaultKeys.length) return;
  const storeState = store.getState();
  const conflictingProps = defaultKeys.filter(
    (key) => (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(storeState, key)
  );
  if (!conflictingProps.length) return;
  throw new Error(
    `Passing a store prop in conjunction with a default state is not supported.

const store = useSelectStore();
<SelectProvider store={store} defaultValue="Apple" />
                ^             ^

Instead, pass the default state to the topmost store:

const store = useSelectStore({ defaultValue: "Apple" });
<SelectProvider store={store} />

See https://github.com/ariakit/ariakit/pull/2745 for more details.

If there's a particular need for this, please submit a feature request at https://github.com/ariakit/ariakit
`
  );
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   canUseDOM: () => (/* binding */ canUseDOM),
/* harmony export */   contains: () => (/* binding */ contains),
/* harmony export */   getActiveElement: () => (/* binding */ getActiveElement),
/* harmony export */   getDocument: () => (/* binding */ getDocument),
/* harmony export */   getPopupItemRole: () => (/* binding */ getPopupItemRole),
/* harmony export */   getPopupRole: () => (/* binding */ getPopupRole),
/* harmony export */   getScrollingElement: () => (/* binding */ getScrollingElement),
/* harmony export */   getTextboxSelection: () => (/* binding */ getTextboxSelection),
/* harmony export */   getTextboxValue: () => (/* binding */ getTextboxValue),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   isButton: () => (/* binding */ isButton),
/* harmony export */   isFrame: () => (/* binding */ isFrame),
/* harmony export */   isPartiallyHidden: () => (/* binding */ isPartiallyHidden),
/* harmony export */   isTextField: () => (/* binding */ isTextField),
/* harmony export */   isTextbox: () => (/* binding */ isTextbox),
/* harmony export */   isVisible: () => (/* binding */ isVisible),
/* harmony export */   scrollIntoViewIfNeeded: () => (/* binding */ scrollIntoViewIfNeeded),
/* harmony export */   setSelectionRange: () => (/* binding */ setSelectionRange),
/* harmony export */   sortBasedOnDOMPosition: () => (/* binding */ sortBasedOnDOMPosition)
/* harmony export */ });
"use client";

// src/utils/dom.ts
var canUseDOM = checkIsBrowser();
function checkIsBrowser() {
  var _a;
  return typeof window !== "undefined" && !!((_a = window.document) == null ? void 0 : _a.createElement);
}
function getDocument(node) {
  if (!node) return document;
  if ("self" in node) return node.document;
  return node.ownerDocument || document;
}
function getWindow(node) {
  if (!node) return self;
  if ("self" in node) return node.self;
  return getDocument(node).defaultView || window;
}
function getActiveElement(node, activeDescendant = false) {
  const { activeElement } = getDocument(node);
  if (!(activeElement == null ? void 0 : activeElement.nodeName)) {
    return null;
  }
  if (isFrame(activeElement) && activeElement.contentDocument) {
    return getActiveElement(
      activeElement.contentDocument.body,
      activeDescendant
    );
  }
  if (activeDescendant) {
    const id = activeElement.getAttribute("aria-activedescendant");
    if (id) {
      const element = getDocument(activeElement).getElementById(id);
      if (element) {
        return element;
      }
    }
  }
  return activeElement;
}
function contains(parent, child) {
  return parent === child || parent.contains(child);
}
function isFrame(element) {
  return element.tagName === "IFRAME";
}
function isButton(element) {
  const tagName = element.tagName.toLowerCase();
  if (tagName === "button") return true;
  if (tagName === "input" && element.type) {
    return buttonInputTypes.indexOf(element.type) !== -1;
  }
  return false;
}
var buttonInputTypes = [
  "button",
  "color",
  "file",
  "image",
  "reset",
  "submit"
];
function isVisible(element) {
  if (typeof element.checkVisibility === "function") {
    return element.checkVisibility();
  }
  const htmlElement = element;
  return htmlElement.offsetWidth > 0 || htmlElement.offsetHeight > 0 || element.getClientRects().length > 0;
}
function isTextField(element) {
  try {
    const isTextInput = element instanceof HTMLInputElement && element.selectionStart !== null;
    const isTextArea = element.tagName === "TEXTAREA";
    return isTextInput || isTextArea || false;
  } catch (error) {
    return false;
  }
}
function isTextbox(element) {
  return element.isContentEditable || isTextField(element);
}
function getTextboxValue(element) {
  if (isTextField(element)) {
    return element.value;
  }
  if (element.isContentEditable) {
    const range = getDocument(element).createRange();
    range.selectNodeContents(element);
    return range.toString();
  }
  return "";
}
function getTextboxSelection(element) {
  let start = 0;
  let end = 0;
  if (isTextField(element)) {
    start = element.selectionStart || 0;
    end = element.selectionEnd || 0;
  } else if (element.isContentEditable) {
    const selection = getDocument(element).getSelection();
    if ((selection == null ? void 0 : selection.rangeCount) && selection.anchorNode && contains(element, selection.anchorNode) && selection.focusNode && contains(element, selection.focusNode)) {
      const range = selection.getRangeAt(0);
      const nextRange = range.cloneRange();
      nextRange.selectNodeContents(element);
      nextRange.setEnd(range.startContainer, range.startOffset);
      start = nextRange.toString().length;
      nextRange.setEnd(range.endContainer, range.endOffset);
      end = nextRange.toString().length;
    }
  }
  return { start, end };
}
function getPopupRole(element, fallback) {
  const allowedPopupRoles = ["dialog", "menu", "listbox", "tree", "grid"];
  const role = element == null ? void 0 : element.getAttribute("role");
  if (role && allowedPopupRoles.indexOf(role) !== -1) {
    return role;
  }
  return fallback;
}
function getPopupItemRole(element, fallback) {
  var _a;
  const itemRoleByPopupRole = {
    menu: "menuitem",
    listbox: "option",
    tree: "treeitem"
  };
  const popupRole = getPopupRole(element);
  if (!popupRole) return fallback;
  const key = popupRole;
  return (_a = itemRoleByPopupRole[key]) != null ? _a : fallback;
}
function scrollIntoViewIfNeeded(element, arg) {
  if (isPartiallyHidden(element) && "scrollIntoView" in element) {
    element.scrollIntoView(arg);
  }
}
function getScrollingElement(element) {
  if (!element) return null;
  const isScrollableOverflow = (overflow) => {
    if (overflow === "auto") return true;
    if (overflow === "scroll") return true;
    return false;
  };
  if (element.clientHeight && element.scrollHeight > element.clientHeight) {
    const { overflowY } = getComputedStyle(element);
    if (isScrollableOverflow(overflowY)) return element;
  } else if (element.clientWidth && element.scrollWidth > element.clientWidth) {
    const { overflowX } = getComputedStyle(element);
    if (isScrollableOverflow(overflowX)) return element;
  }
  return getScrollingElement(element.parentElement) || document.scrollingElement || document.body;
}
function isPartiallyHidden(element) {
  const elementRect = element.getBoundingClientRect();
  const scroller = getScrollingElement(element);
  if (!scroller) return false;
  const scrollerRect = scroller.getBoundingClientRect();
  const isHTML = scroller.tagName === "HTML";
  const scrollerTop = isHTML ? scrollerRect.top + scroller.scrollTop : scrollerRect.top;
  const scrollerBottom = isHTML ? scroller.clientHeight : scrollerRect.bottom;
  const scrollerLeft = isHTML ? scrollerRect.left + scroller.scrollLeft : scrollerRect.left;
  const scrollerRight = isHTML ? scroller.clientWidth : scrollerRect.right;
  const top = elementRect.top < scrollerTop;
  const left = elementRect.left < scrollerLeft;
  const bottom = elementRect.bottom > scrollerBottom;
  const right = elementRect.right > scrollerRight;
  return top || left || bottom || right;
}
function setSelectionRange(element, ...args) {
  if (/text|search|password|tel|url/i.test(element.type)) {
    element.setSelectionRange(...args);
  }
}
function sortBasedOnDOMPosition(items, getElement) {
  const pairs = items.map((item, index) => [index, item]);
  let isOrderDifferent = false;
  pairs.sort(([indexA, a], [indexB, b]) => {
    const elementA = getElement(a);
    const elementB = getElement(b);
    if (elementA === elementB) return 0;
    if (!elementA || !elementB) return 0;
    if (isElementPreceding(elementA, elementB)) {
      if (indexA > indexB) {
        isOrderDifferent = true;
      }
      return -1;
    }
    if (indexA < indexB) {
      isOrderDifferent = true;
    }
    return 1;
  });
  if (isOrderDifferent) {
    return pairs.map(([_, item]) => item);
  }
  return items;
}
function isElementPreceding(a, b) {
  return Boolean(
    b.compareDocumentPosition(a) & Node.DOCUMENT_POSITION_PRECEDING
  );
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/FZZ2AVHF.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/FZZ2AVHF.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDialogStore: () => (/* binding */ createDialogStore)
/* harmony export */ });
/* harmony import */ var _RCQ5P4YE_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RCQ5P4YE.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/RCQ5P4YE.js");
"use client";


// src/dialog/dialog-store.ts
function createDialogStore(props = {}) {
  return (0,_RCQ5P4YE_js__WEBPACK_IMPORTED_MODULE_0__.createDisclosureStore)(props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/JTLIIJ4U.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/JTLIIJ4U.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createHovercardStore: () => (/* binding */ createHovercardStore)
/* harmony export */ });
/* harmony import */ var _ME2CUF3F_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ME2CUF3F.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/ME2CUF3F.js");
/* harmony import */ var _BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BCALMBPZ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var _PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PBFD2E7P.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";





// src/hovercard/hovercard-store.ts
function createHovercardStore(props = {}) {
  var _a;
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const popover = (0,_ME2CUF3F_js__WEBPACK_IMPORTED_MODULE_0__.createPopoverStore)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, props), {
    placement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(
      props.placement,
      syncState == null ? void 0 : syncState.placement,
      "bottom"
    )
  }));
  const timeout = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.timeout, syncState == null ? void 0 : syncState.timeout, 500);
  const initialState = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, popover.getState()), {
    timeout,
    showTimeout: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.showTimeout, syncState == null ? void 0 : syncState.showTimeout),
    hideTimeout: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.hideTimeout, syncState == null ? void 0 : syncState.hideTimeout),
    autoFocusOnShow: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(syncState == null ? void 0 : syncState.autoFocusOnShow, false)
  });
  const hovercard = (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_3__.createStore)(initialState, popover, props.store);
  return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, popover), hovercard), {
    setAutoFocusOnShow: (value) => hovercard.setState("autoFocusOnShow", value)
  });
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/ME2CUF3F.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/ME2CUF3F.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopoverStore: () => (/* binding */ createPopoverStore)
/* harmony export */ });
/* harmony import */ var _FZZ2AVHF_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FZZ2AVHF.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/FZZ2AVHF.js");
/* harmony import */ var _BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BCALMBPZ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var _PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PBFD2E7P.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";





// src/popover/popover-store.ts
function createPopoverStore(_a = {}) {
  var _b = _a, {
    popover: otherPopover
  } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__objRest)(_b, [
    "popover"
  ]);
  const store = (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_1__.mergeStore)(
    props.store,
    (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_1__.omit)(otherPopover, [
      "arrowElement",
      "anchorElement",
      "contentElement",
      "popoverElement",
      "disclosureElement"
    ])
  );
  (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_1__.throwOnConflictingProps)(props, store);
  const syncState = store == null ? void 0 : store.getState();
  const dialog = (0,_FZZ2AVHF_js__WEBPACK_IMPORTED_MODULE_2__.createDialogStore)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, props), { store }));
  const placement = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_3__.defaultValue)(
    props.placement,
    syncState == null ? void 0 : syncState.placement,
    "bottom"
  );
  const initialState = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, dialog.getState()), {
    placement,
    currentPlacement: placement,
    anchorElement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_3__.defaultValue)(syncState == null ? void 0 : syncState.anchorElement, null),
    popoverElement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_3__.defaultValue)(syncState == null ? void 0 : syncState.popoverElement, null),
    arrowElement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_3__.defaultValue)(syncState == null ? void 0 : syncState.arrowElement, null),
    rendered: Symbol("rendered")
  });
  const popover = (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_1__.createStore)(initialState, dialog, store);
  return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, dialog), popover), {
    setAnchorElement: (element) => popover.setState("anchorElement", element),
    setPopoverElement: (element) => popover.setState("popoverElement", element),
    setArrowElement: (element) => popover.setState("arrowElement", element),
    render: () => popover.setState("rendered", Symbol("rendered"))
  });
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterPaint: () => (/* binding */ afterPaint),
/* harmony export */   applyState: () => (/* binding */ applyState),
/* harmony export */   beforePaint: () => (/* binding */ beforePaint),
/* harmony export */   chain: () => (/* binding */ chain),
/* harmony export */   cx: () => (/* binding */ cx),
/* harmony export */   defaultValue: () => (/* binding */ defaultValue),
/* harmony export */   disabledFromProps: () => (/* binding */ disabledFromProps),
/* harmony export */   getKeys: () => (/* binding */ getKeys),
/* harmony export */   hasOwnProperty: () => (/* binding */ hasOwnProperty),
/* harmony export */   identity: () => (/* binding */ identity),
/* harmony export */   invariant: () => (/* binding */ invariant),
/* harmony export */   isEmpty: () => (/* binding */ isEmpty),
/* harmony export */   isFalsyBooleanCallback: () => (/* binding */ isFalsyBooleanCallback),
/* harmony export */   isInteger: () => (/* binding */ isInteger),
/* harmony export */   isObject: () => (/* binding */ isObject),
/* harmony export */   noop: () => (/* binding */ noop),
/* harmony export */   normalizeString: () => (/* binding */ normalizeString),
/* harmony export */   omit: () => (/* binding */ omit),
/* harmony export */   pick: () => (/* binding */ pick),
/* harmony export */   removeUndefinedValues: () => (/* binding */ removeUndefinedValues),
/* harmony export */   shallowEqual: () => (/* binding */ shallowEqual)
/* harmony export */ });
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";


// src/utils/misc.ts
function noop(..._) {
}
function shallowEqual(a, b) {
  if (a === b) return true;
  if (!a) return false;
  if (!b) return false;
  if (typeof a !== "object") return false;
  if (typeof b !== "object") return false;
  const aKeys = Object.keys(a);
  const bKeys = Object.keys(b);
  const { length } = aKeys;
  if (bKeys.length !== length) return false;
  for (const key of aKeys) {
    if (a[key] !== b[key]) {
      return false;
    }
  }
  return true;
}
function applyState(argument, currentValue) {
  if (isUpdater(argument)) {
    const value = isLazyValue(currentValue) ? currentValue() : currentValue;
    return argument(value);
  }
  return argument;
}
function isUpdater(argument) {
  return typeof argument === "function";
}
function isLazyValue(value) {
  return typeof value === "function";
}
function isObject(arg) {
  return typeof arg === "object" && arg != null;
}
function isEmpty(arg) {
  if (Array.isArray(arg)) return !arg.length;
  if (isObject(arg)) return !Object.keys(arg).length;
  if (arg == null) return true;
  if (arg === "") return true;
  return false;
}
function isInteger(arg) {
  if (typeof arg === "number") {
    return Math.floor(arg) === arg;
  }
  return String(Math.floor(Number(arg))) === arg;
}
function hasOwnProperty(object, prop) {
  if (typeof Object.hasOwn === "function") {
    return Object.hasOwn(object, prop);
  }
  return Object.prototype.hasOwnProperty.call(object, prop);
}
function chain(...fns) {
  return (...args) => {
    for (const fn of fns) {
      if (typeof fn === "function") {
        fn(...args);
      }
    }
  };
}
function cx(...args) {
  return args.filter(Boolean).join(" ") || void 0;
}
function normalizeString(str) {
  return str.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
}
function omit(object, keys) {
  const result = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_0__.__spreadValues)({}, object);
  for (const key of keys) {
    if (hasOwnProperty(result, key)) {
      delete result[key];
    }
  }
  return result;
}
function pick(object, paths) {
  const result = {};
  for (const key of paths) {
    if (hasOwnProperty(object, key)) {
      result[key] = object[key];
    }
  }
  return result;
}
function identity(value) {
  return value;
}
function beforePaint(cb = noop) {
  const raf = requestAnimationFrame(cb);
  return () => cancelAnimationFrame(raf);
}
function afterPaint(cb = noop) {
  let raf = requestAnimationFrame(() => {
    raf = requestAnimationFrame(cb);
  });
  return () => cancelAnimationFrame(raf);
}
function invariant(condition, message) {
  if (condition) return;
  if (typeof message !== "string") throw new Error("Invariant failed");
  throw new Error(message);
}
function getKeys(obj) {
  return Object.keys(obj);
}
function isFalsyBooleanCallback(booleanOrCallback, ...args) {
  const result = typeof booleanOrCallback === "function" ? booleanOrCallback(...args) : booleanOrCallback;
  if (result == null) return false;
  return !result;
}
function disabledFromProps(props) {
  return props.disabled || props["aria-disabled"] === true || props["aria-disabled"] === "true";
}
function removeUndefinedValues(obj) {
  const result = {};
  for (const key in obj) {
    if (obj[key] !== void 0) {
      result[key] = obj[key];
    }
  }
  return result;
}
function defaultValue(...values) {
  for (const value of values) {
    if (value !== void 0) return value;
  }
  return void 0;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isApple: () => (/* binding */ isApple),
/* harmony export */   isFirefox: () => (/* binding */ isFirefox),
/* harmony export */   isMac: () => (/* binding */ isMac),
/* harmony export */   isSafari: () => (/* binding */ isSafari),
/* harmony export */   isTouchDevice: () => (/* binding */ isTouchDevice)
/* harmony export */ });
/* harmony import */ var _DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DTR5TSDJ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
"use client";


// src/utils/platform.ts
function isTouchDevice() {
  return _DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && !!navigator.maxTouchPoints;
}
function isApple() {
  if (!_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM) return false;
  return /mac|iphone|ipad|ipod/i.test(navigator.platform);
}
function isSafari() {
  return _DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && isApple() && /apple/i.test(navigator.vendor);
}
function isFirefox() {
  return _DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && /firefox\//i.test(navigator.userAgent);
}
function isMac() {
  return _DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.canUseDOM && navigator.platform.startsWith("Mac") && !isTouchDevice();
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/RCQ5P4YE.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/RCQ5P4YE.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDisclosureStore: () => (/* binding */ createDisclosureStore)
/* harmony export */ });
/* harmony import */ var _BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BCALMBPZ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var _PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PBFD2E7P.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";




// src/disclosure/disclosure-store.ts
function createDisclosureStore(props = {}) {
  const store = (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.mergeStore)(
    props.store,
    (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.omit)(props.disclosure, ["contentElement", "disclosureElement"])
  );
  (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.throwOnConflictingProps)(props, store);
  const syncState = store == null ? void 0 : store.getState();
  const open = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(
    props.open,
    syncState == null ? void 0 : syncState.open,
    props.defaultOpen,
    false
  );
  const animated = (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(props.animated, syncState == null ? void 0 : syncState.animated, false);
  const initialState = {
    open,
    animated,
    animating: !!animated && open,
    mounted: open,
    contentElement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(syncState == null ? void 0 : syncState.contentElement, null),
    disclosureElement: (0,_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_1__.defaultValue)(syncState == null ? void 0 : syncState.disclosureElement, null)
  };
  const disclosure = (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.createStore)(initialState, store);
  (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.sync)(disclosure, ["animated", "animating"], (state) => {
      if (state.animated) return;
      disclosure.setState("animating", false);
    })
  );
  (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.subscribe)(disclosure, ["open"], () => {
      if (!disclosure.getState().animated) return;
      disclosure.setState("animating", true);
    })
  );
  (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.setup)(
    disclosure,
    () => (0,_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_0__.sync)(disclosure, ["open", "animating"], (state) => {
      disclosure.setState("mounted", state.open || state.animating);
    })
  );
  return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, disclosure), {
    disclosure: props.disclosure,
    setOpen: (value) => disclosure.setState("open", value),
    show: () => disclosure.setState("open", true),
    hide: () => disclosure.setState("open", false),
    toggle: () => disclosure.setState("open", (open2) => !open2),
    stopAnimation: () => disclosure.setState("animating", false),
    setContentElement: (value) => disclosure.setState("contentElement", value),
    setDisclosureElement: (value) => disclosure.setState("disclosureElement", value)
  });
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/tooltip/tooltip-store.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/tooltip/tooltip-store.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createTooltipStore: () => (/* binding */ createTooltipStore)
/* harmony export */ });
/* harmony import */ var _chunks_JTLIIJ4U_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/JTLIIJ4U.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/JTLIIJ4U.js");
/* harmony import */ var _chunks_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../__chunks/BCALMBPZ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var _chunks_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/PBFD2E7P.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";








// src/tooltip/tooltip-store.ts
function createTooltipStore(props = {}) {
  var _a;
  if (true) {
    if (props.type === "label") {
      console.warn(
        "The `type` option on the tooltip store is deprecated.",
        "Render a visually hidden label or use the `aria-label` or `aria-labelledby` attributes on the anchor element instead.",
        "See https://ariakit.org/components/tooltip#tooltip-anchors-must-have-accessible-names"
      );
    }
  }
  const syncState = (_a = props.store) == null ? void 0 : _a.getState();
  const hovercard = (0,_chunks_JTLIIJ4U_js__WEBPACK_IMPORTED_MODULE_0__.createHovercardStore)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, props), {
    placement: (0,_chunks_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(
      props.placement,
      syncState == null ? void 0 : syncState.placement,
      "top"
    ),
    hideTimeout: (0,_chunks_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.hideTimeout, syncState == null ? void 0 : syncState.hideTimeout, 0)
  }));
  const initialState = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, hovercard.getState()), {
    type: (0,_chunks_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.type, syncState == null ? void 0 : syncState.type, "description"),
    skipTimeout: (0,_chunks_PBFD2E7P_js__WEBPACK_IMPORTED_MODULE_2__.defaultValue)(props.skipTimeout, syncState == null ? void 0 : syncState.skipTimeout, 300)
  });
  const tooltip = (0,_chunks_BCALMBPZ_js__WEBPACK_IMPORTED_MODULE_3__.createStore)(initialState, hovercard, props.store);
  return (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, hovercard), tooltip);
}



/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addGlobalEventListener: () => (/* binding */ addGlobalEventListener),
/* harmony export */   fireBlurEvent: () => (/* binding */ fireBlurEvent),
/* harmony export */   fireClickEvent: () => (/* binding */ fireClickEvent),
/* harmony export */   fireEvent: () => (/* binding */ fireEvent),
/* harmony export */   fireFocusEvent: () => (/* binding */ fireFocusEvent),
/* harmony export */   fireKeyboardEvent: () => (/* binding */ fireKeyboardEvent),
/* harmony export */   getInputType: () => (/* binding */ getInputType),
/* harmony export */   isDownloading: () => (/* binding */ isDownloading),
/* harmony export */   isFocusEventOutside: () => (/* binding */ isFocusEventOutside),
/* harmony export */   isOpeningInNewTab: () => (/* binding */ isOpeningInNewTab),
/* harmony export */   isPortalEvent: () => (/* binding */ isPortalEvent),
/* harmony export */   isSelfTarget: () => (/* binding */ isSelfTarget),
/* harmony export */   queueBeforeEvent: () => (/* binding */ queueBeforeEvent)
/* harmony export */ });
/* harmony import */ var _chunks_QAGXQEUG_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/QAGXQEUG.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js");
/* harmony import */ var _chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/DTR5TSDJ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";




// src/utils/events.ts
function isPortalEvent(event) {
  return Boolean(
    event.currentTarget && !(0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.contains)(event.currentTarget, event.target)
  );
}
function isSelfTarget(event) {
  return event.target === event.currentTarget;
}
function isOpeningInNewTab(event) {
  const element = event.currentTarget;
  if (!element) return false;
  const isAppleDevice = (0,_chunks_QAGXQEUG_js__WEBPACK_IMPORTED_MODULE_1__.isApple)();
  if (isAppleDevice && !event.metaKey) return false;
  if (!isAppleDevice && !event.ctrlKey) return false;
  const tagName = element.tagName.toLowerCase();
  if (tagName === "a") return true;
  if (tagName === "button" && element.type === "submit") return true;
  if (tagName === "input" && element.type === "submit") return true;
  return false;
}
function isDownloading(event) {
  const element = event.currentTarget;
  if (!element) return false;
  const tagName = element.tagName.toLowerCase();
  if (!event.altKey) return false;
  if (tagName === "a") return true;
  if (tagName === "button" && element.type === "submit") return true;
  if (tagName === "input" && element.type === "submit") return true;
  return false;
}
function fireEvent(element, type, eventInit) {
  const event = new Event(type, eventInit);
  return element.dispatchEvent(event);
}
function fireBlurEvent(element, eventInit) {
  const event = new FocusEvent("blur", eventInit);
  const defaultAllowed = element.dispatchEvent(event);
  const bubbleInit = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, eventInit), { bubbles: true });
  element.dispatchEvent(new FocusEvent("focusout", bubbleInit));
  return defaultAllowed;
}
function fireFocusEvent(element, eventInit) {
  const event = new FocusEvent("focus", eventInit);
  const defaultAllowed = element.dispatchEvent(event);
  const bubbleInit = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, eventInit), { bubbles: true });
  element.dispatchEvent(new FocusEvent("focusin", bubbleInit));
  return defaultAllowed;
}
function fireKeyboardEvent(element, type, eventInit) {
  const event = new KeyboardEvent(type, eventInit);
  return element.dispatchEvent(event);
}
function fireClickEvent(element, eventInit) {
  const event = new MouseEvent("click", eventInit);
  return element.dispatchEvent(event);
}
function isFocusEventOutside(event, container) {
  const containerElement = container || event.currentTarget;
  const relatedTarget = event.relatedTarget;
  return !relatedTarget || !(0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.contains)(containerElement, relatedTarget);
}
function getInputType(event) {
  const nativeEvent = "nativeEvent" in event ? event.nativeEvent : event;
  if (!nativeEvent) return;
  if (!("inputType" in nativeEvent)) return;
  if (typeof nativeEvent.inputType !== "string") return;
  return nativeEvent.inputType;
}
function queueBeforeEvent(element, type, callback, timeout) {
  const createTimer = (callback2) => {
    if (timeout) {
      const timerId2 = setTimeout(callback2, timeout);
      return () => clearTimeout(timerId2);
    }
    const timerId = requestAnimationFrame(callback2);
    return () => cancelAnimationFrame(timerId);
  };
  const cancelTimer = createTimer(() => {
    element.removeEventListener(type, callSync, true);
    callback();
  });
  const callSync = () => {
    cancelTimer();
    callback();
  };
  element.addEventListener(type, callSync, { once: true, capture: true });
  return cancelTimer;
}
function addGlobalEventListener(type, listener, options, scope = window) {
  const children = [];
  try {
    scope.document.addEventListener(type, listener, options);
    for (const frame of Array.from(scope.frames)) {
      children.push(addGlobalEventListener(type, listener, options, frame));
    }
  } catch (e) {
  }
  const removeEventListener = () => {
    try {
      scope.document.removeEventListener(type, listener, options);
    } catch (e) {
    }
    for (const remove of children) {
      remove();
    }
  };
  return removeEventListener;
}



/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableFocus: () => (/* binding */ disableFocus),
/* harmony export */   disableFocusIn: () => (/* binding */ disableFocusIn),
/* harmony export */   focusIfNeeded: () => (/* binding */ focusIfNeeded),
/* harmony export */   focusIntoView: () => (/* binding */ focusIntoView),
/* harmony export */   getAllFocusable: () => (/* binding */ getAllFocusable),
/* harmony export */   getAllFocusableIn: () => (/* binding */ getAllFocusableIn),
/* harmony export */   getAllTabbable: () => (/* binding */ getAllTabbable),
/* harmony export */   getAllTabbableIn: () => (/* binding */ getAllTabbableIn),
/* harmony export */   getClosestFocusable: () => (/* binding */ getClosestFocusable),
/* harmony export */   getFirstFocusable: () => (/* binding */ getFirstFocusable),
/* harmony export */   getFirstFocusableIn: () => (/* binding */ getFirstFocusableIn),
/* harmony export */   getFirstTabbable: () => (/* binding */ getFirstTabbable),
/* harmony export */   getFirstTabbableIn: () => (/* binding */ getFirstTabbableIn),
/* harmony export */   getLastTabbable: () => (/* binding */ getLastTabbable),
/* harmony export */   getLastTabbableIn: () => (/* binding */ getLastTabbableIn),
/* harmony export */   getNextTabbable: () => (/* binding */ getNextTabbable),
/* harmony export */   getNextTabbableIn: () => (/* binding */ getNextTabbableIn),
/* harmony export */   getPreviousTabbable: () => (/* binding */ getPreviousTabbable),
/* harmony export */   getPreviousTabbableIn: () => (/* binding */ getPreviousTabbableIn),
/* harmony export */   hasFocus: () => (/* binding */ hasFocus),
/* harmony export */   hasFocusWithin: () => (/* binding */ hasFocusWithin),
/* harmony export */   isFocusable: () => (/* binding */ isFocusable),
/* harmony export */   isTabbable: () => (/* binding */ isTabbable),
/* harmony export */   restoreFocusIn: () => (/* binding */ restoreFocusIn)
/* harmony export */ });
/* harmony import */ var _chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../__chunks/DTR5TSDJ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/3YLGPPWQ.js");
"use client";



// src/utils/focus.ts
var selector = "input:not([type='hidden']):not([disabled]), select:not([disabled]), textarea:not([disabled]), a[href], button:not([disabled]), [tabindex], summary, iframe, object, embed, area[href], audio[controls], video[controls], [contenteditable]:not([contenteditable='false'])";
function hasNegativeTabIndex(element) {
  const tabIndex = Number.parseInt(element.getAttribute("tabindex") || "0", 10);
  return tabIndex < 0;
}
function isFocusable(element) {
  if (!element.matches(selector)) return false;
  if (!(0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.isVisible)(element)) return false;
  if (element.closest("[inert]")) return false;
  return true;
}
function isTabbable(element) {
  if (!isFocusable(element)) return false;
  if (hasNegativeTabIndex(element)) return false;
  if (!("form" in element)) return true;
  if (!element.form) return true;
  if (element.checked) return true;
  if (element.type !== "radio") return true;
  const radioGroup = element.form.elements.namedItem(element.name);
  if (!radioGroup) return true;
  if (!("length" in radioGroup)) return true;
  const activeElement = (0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return true;
  if (activeElement === element) return true;
  if (!("form" in activeElement)) return true;
  if (activeElement.form !== element.form) return true;
  if (activeElement.name !== element.name) return true;
  return false;
}
function getAllFocusableIn(container, includeContainer) {
  const elements = Array.from(
    container.querySelectorAll(selector)
  );
  if (includeContainer) {
    elements.unshift(container);
  }
  const focusableElements = elements.filter(isFocusable);
  focusableElements.forEach((element, i) => {
    if ((0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.isFrame)(element) && element.contentDocument) {
      const frameBody = element.contentDocument.body;
      focusableElements.splice(i, 1, ...getAllFocusableIn(frameBody));
    }
  });
  return focusableElements;
}
function getAllFocusable(includeBody) {
  return getAllFocusableIn(document.body, includeBody);
}
function getFirstFocusableIn(container, includeContainer) {
  const [first] = getAllFocusableIn(container, includeContainer);
  return first || null;
}
function getFirstFocusable(includeBody) {
  return getFirstFocusableIn(document.body, includeBody);
}
function getAllTabbableIn(container, includeContainer, fallbackToFocusable) {
  const elements = Array.from(
    container.querySelectorAll(selector)
  );
  const tabbableElements = elements.filter(isTabbable);
  if (includeContainer && isTabbable(container)) {
    tabbableElements.unshift(container);
  }
  tabbableElements.forEach((element, i) => {
    if ((0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.isFrame)(element) && element.contentDocument) {
      const frameBody = element.contentDocument.body;
      const allFrameTabbable = getAllTabbableIn(
        frameBody,
        false,
        fallbackToFocusable
      );
      tabbableElements.splice(i, 1, ...allFrameTabbable);
    }
  });
  if (!tabbableElements.length && fallbackToFocusable) {
    return elements;
  }
  return tabbableElements;
}
function getAllTabbable(fallbackToFocusable) {
  return getAllTabbableIn(document.body, false, fallbackToFocusable);
}
function getFirstTabbableIn(container, includeContainer, fallbackToFocusable) {
  const [first] = getAllTabbableIn(
    container,
    includeContainer,
    fallbackToFocusable
  );
  return first || null;
}
function getFirstTabbable(fallbackToFocusable) {
  return getFirstTabbableIn(document.body, false, fallbackToFocusable);
}
function getLastTabbableIn(container, includeContainer, fallbackToFocusable) {
  const allTabbable = getAllTabbableIn(
    container,
    includeContainer,
    fallbackToFocusable
  );
  return allTabbable[allTabbable.length - 1] || null;
}
function getLastTabbable(fallbackToFocusable) {
  return getLastTabbableIn(document.body, false, fallbackToFocusable);
}
function getNextTabbableIn(container, includeContainer, fallbackToFirst, fallbackToFocusable) {
  const activeElement = (0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(container);
  const allFocusable = getAllFocusableIn(container, includeContainer);
  const activeIndex = allFocusable.indexOf(activeElement);
  const nextFocusableElements = allFocusable.slice(activeIndex + 1);
  return nextFocusableElements.find(isTabbable) || (fallbackToFirst ? allFocusable.find(isTabbable) : null) || (fallbackToFocusable ? nextFocusableElements[0] : null) || null;
}
function getNextTabbable(fallbackToFirst, fallbackToFocusable) {
  return getNextTabbableIn(
    document.body,
    false,
    fallbackToFirst,
    fallbackToFocusable
  );
}
function getPreviousTabbableIn(container, includeContainer, fallbackToLast, fallbackToFocusable) {
  const activeElement = (0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(container);
  const allFocusable = getAllFocusableIn(container, includeContainer).reverse();
  const activeIndex = allFocusable.indexOf(activeElement);
  const previousFocusableElements = allFocusable.slice(activeIndex + 1);
  return previousFocusableElements.find(isTabbable) || (fallbackToLast ? allFocusable.find(isTabbable) : null) || (fallbackToFocusable ? previousFocusableElements[0] : null) || null;
}
function getPreviousTabbable(fallbackToFirst, fallbackToFocusable) {
  return getPreviousTabbableIn(
    document.body,
    false,
    fallbackToFirst,
    fallbackToFocusable
  );
}
function getClosestFocusable(element) {
  while (element && !isFocusable(element)) {
    element = element.closest(selector);
  }
  return element || null;
}
function hasFocus(element) {
  const activeElement = (0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return false;
  if (activeElement === element) return true;
  const activeDescendant = activeElement.getAttribute("aria-activedescendant");
  if (!activeDescendant) return false;
  return activeDescendant === element.id;
}
function hasFocusWithin(element) {
  const activeElement = (0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.getActiveElement)(element);
  if (!activeElement) return false;
  if ((0,_chunks_DTR5TSDJ_js__WEBPACK_IMPORTED_MODULE_0__.contains)(element, activeElement)) return true;
  const activeDescendant = activeElement.getAttribute("aria-activedescendant");
  if (!activeDescendant) return false;
  if (!("id" in element)) return false;
  if (activeDescendant === element.id) return true;
  return !!element.querySelector(`#${CSS.escape(activeDescendant)}`);
}
function focusIfNeeded(element) {
  if (!hasFocusWithin(element) && isFocusable(element)) {
    element.focus();
  }
}
function disableFocus(element) {
  var _a;
  const currentTabindex = (_a = element.getAttribute("tabindex")) != null ? _a : "";
  element.setAttribute("data-tabindex", currentTabindex);
  element.setAttribute("tabindex", "-1");
}
function disableFocusIn(container, includeContainer) {
  const tabbableElements = getAllTabbableIn(container, includeContainer);
  for (const element of tabbableElements) {
    disableFocus(element);
  }
}
function restoreFocusIn(container) {
  const elements = container.querySelectorAll("[data-tabindex]");
  const restoreTabIndex = (element) => {
    const tabindex = element.getAttribute("data-tabindex");
    element.removeAttribute("data-tabindex");
    if (tabindex) {
      element.setAttribute("tabindex", tabindex);
    } else {
      element.removeAttribute("tabindex");
    }
  };
  if (container.hasAttribute("data-tabindex")) {
    restoreTabIndex(container);
  }
  for (const element of elements) {
    restoreTabIndex(element);
  }
}
function focusIntoView(element, options) {
  if (!("scrollIntoView" in element)) {
    element.focus();
  } else {
    element.focus({ preventScroll: true });
    element.scrollIntoView((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({ block: "nearest", inline: "nearest" }, options));
  }
}



/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElementMarked: () => (/* binding */ isElementMarked),
/* harmony export */   markAncestor: () => (/* binding */ markAncestor),
/* harmony export */   markElement: () => (/* binding */ markElement),
/* harmony export */   markTreeOutside: () => (/* binding */ markTreeOutside)
/* harmony export */ });
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
"use client";




// src/dialog/utils/mark-tree-outside.ts

function getPropertyName(id = "", ancestor = false) {
  return `__ariakit-dialog-${ancestor ? "ancestor" : "outside"}${id ? `-${id}` : ""}`;
}
function markElement(element, id = "") {
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.chain)(
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(), true),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(id), true)
  );
}
function markAncestor(element, id = "") {
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.chain)(
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName("", true), true),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getPropertyName(id, true), true)
  );
}
function isElementMarked(element, id) {
  const ancestorProperty = getPropertyName(id, true);
  if (element[ancestorProperty]) return true;
  const elementProperty = getPropertyName(id);
  do {
    if (element[elementProperty]) return true;
    if (!element.parentElement) return false;
    element = element.parentElement;
  } while (true);
}
function markTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_2__.walkTreeOutside)(
    id,
    elements,
    (element) => {
      if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_3__.isBackdrop)(element, ...ids)) return;
      cleanups.unshift(markElement(element, id));
    },
    (ancestor, element) => {
      const isAnotherDialogAncestor = element.hasAttribute("data-dialog") && element.id !== id;
      if (isAnotherDialogAncestor) return;
      cleanups.unshift(markAncestor(ancestor, id));
    }
  );
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __objRest: () => (/* binding */ __objRest),
/* harmony export */   __spreadProps: () => (/* binding */ __spreadProps),
/* harmony export */   __spreadValues: () => (/* binding */ __spreadValues)
/* harmony export */ });
"use client";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

var react__WEBPACK_IMPORTED_MODULE_0___namespace_cache;
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAttribute: () => (/* binding */ useAttribute),
/* harmony export */   useBooleanEvent: () => (/* binding */ useBooleanEvent),
/* harmony export */   useDeferredValue: () => (/* binding */ useDeferredValue),
/* harmony export */   useEvent: () => (/* binding */ useEvent),
/* harmony export */   useForceUpdate: () => (/* binding */ useForceUpdate),
/* harmony export */   useId: () => (/* binding */ useId),
/* harmony export */   useInitialValue: () => (/* binding */ useInitialValue),
/* harmony export */   useIsMouseMoving: () => (/* binding */ useIsMouseMoving),
/* harmony export */   useLazyValue: () => (/* binding */ useLazyValue),
/* harmony export */   useLiveRef: () => (/* binding */ useLiveRef),
/* harmony export */   useMergeRefs: () => (/* binding */ useMergeRefs),
/* harmony export */   useMetadataProps: () => (/* binding */ useMetadataProps),
/* harmony export */   usePortalRef: () => (/* binding */ usePortalRef),
/* harmony export */   usePreviousValue: () => (/* binding */ usePreviousValue),
/* harmony export */   useSafeLayoutEffect: () => (/* binding */ useSafeLayoutEffect),
/* harmony export */   useTagName: () => (/* binding */ useTagName),
/* harmony export */   useTransactionState: () => (/* binding */ useTransactionState),
/* harmony export */   useUpdateEffect: () => (/* binding */ useUpdateEffect),
/* harmony export */   useUpdateLayoutEffect: () => (/* binding */ useUpdateLayoutEffect),
/* harmony export */   useWrapElement: () => (/* binding */ useWrapElement)
/* harmony export */ });
/* harmony import */ var _SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SK3NAZA3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SK3NAZA3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";



// src/utils/hooks.ts




var _React = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, /*#__PURE__*/ (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache || (react__WEBPACK_IMPORTED_MODULE_0___namespace_cache = __webpack_require__.t(react__WEBPACK_IMPORTED_MODULE_0__, 2))));
var useReactId = _React.useId;
var useReactDeferredValue = _React.useDeferredValue;
var useReactInsertionEffect = _React.useInsertionEffect;
var useSafeLayoutEffect = _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__.canUseDOM ? react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect : react__WEBPACK_IMPORTED_MODULE_0__.useEffect;
function useInitialValue(value) {
  const [initialValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  return initialValue;
}
function useLazyValue(init) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  if (ref.current === void 0) {
    ref.current = init();
  }
  return ref.current;
}
function useLiveRef(value) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(value);
  useSafeLayoutEffect(() => {
    ref.current = value;
  });
  return ref;
}
function usePreviousValue(value) {
  const [previousValue, setPreviousValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  if (value !== previousValue) {
    setPreviousValue(value);
  }
  return previousValue;
}
function useEvent(callback) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(() => {
    throw new Error("Cannot call an event handler while rendering.");
  });
  if (useReactInsertionEffect) {
    useReactInsertionEffect(() => {
      ref.current = callback;
    });
  } else {
    ref.current = callback;
  }
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((...args) => {
    var _a;
    return (_a = ref.current) == null ? void 0 : _a.call(ref, ...args);
  }, []);
}
function useTransactionState(callback) {
  const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  useSafeLayoutEffect(() => {
    if (state == null) return;
    if (!callback) return;
    let prevState = null;
    callback((prev) => {
      prevState = prev;
      return state;
    });
    return () => {
      callback(prevState);
    };
  }, [state, callback]);
  return [state, setState];
}
function useMergeRefs(...refs) {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    if (!refs.some(Boolean)) return;
    return (value) => {
      for (const ref of refs) {
        (0,_SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_3__.setRef)(ref, value);
      }
    };
  }, refs);
}
function useId(defaultId) {
  if (useReactId) {
    const reactId = useReactId();
    if (defaultId) return defaultId;
    return reactId;
  }
  const [id, setId] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(defaultId);
  useSafeLayoutEffect(() => {
    if (defaultId || id) return;
    const random = Math.random().toString(36).slice(2, 8);
    setId(`id-${random}`);
  }, [defaultId, id]);
  return defaultId || id;
}
function useDeferredValue(value) {
  if (useReactDeferredValue) {
    return useReactDeferredValue(value);
  }
  const [deferredValue, setDeferredValue] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(value);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const raf = requestAnimationFrame(() => setDeferredValue(value));
    return () => cancelAnimationFrame(raf);
  }, [value]);
  return deferredValue;
}
function useTagName(refOrElement, type) {
  const stringOrUndefined = (type2) => {
    if (typeof type2 !== "string") return;
    return type2;
  };
  const [tagName, setTagName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(() => stringOrUndefined(type));
  useSafeLayoutEffect(() => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    setTagName((element == null ? void 0 : element.tagName.toLowerCase()) || stringOrUndefined(type));
  }, [refOrElement, type]);
  return tagName;
}
function useAttribute(refOrElement, attributeName, defaultValue) {
  const initialValue = useInitialValue(defaultValue);
  const [attribute, setAttribute] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(initialValue);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const element = refOrElement && "current" in refOrElement ? refOrElement.current : refOrElement;
    if (!element) return;
    const callback = () => {
      const value = element.getAttribute(attributeName);
      setAttribute(value == null ? initialValue : value);
    };
    const observer = new MutationObserver(callback);
    observer.observe(element, { attributeFilter: [attributeName] });
    callback();
    return () => observer.disconnect();
  }, [refOrElement, attributeName, initialValue]);
  return attribute;
}
function useUpdateEffect(effect, deps) {
  const mounted = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useUpdateLayoutEffect(effect, deps) {
  const mounted = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  useSafeLayoutEffect(() => {
    if (mounted.current) {
      return effect();
    }
    mounted.current = true;
  }, deps);
  useSafeLayoutEffect(
    () => () => {
      mounted.current = false;
    },
    []
  );
}
function useForceUpdate() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(() => [], []);
}
function useBooleanEvent(booleanOrCallback) {
  return useEvent(
    typeof booleanOrCallback === "function" ? booleanOrCallback : () => booleanOrCallback
  );
}
function useWrapElement(props, callback, deps = []) {
  const wrapElement = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
    (element) => {
      if (props.wrapElement) {
        element = props.wrapElement(element);
      }
      return callback(element);
    },
    [...deps, props.wrapElement]
  );
  return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, props), { wrapElement });
}
function usePortalRef(portalProp = false, portalRefProp) {
  const [portalNode, setPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const portalRef = useMergeRefs(setPortalNode, portalRefProp);
  const domReady = !portalProp || portalNode;
  return { portalRef, portalNode, domReady };
}
function useMetadataProps(props, key, value) {
  const parent = props.onLoadedMetadataCapture;
  const onLoadedMetadataCapture = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    return Object.assign(() => {
    }, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, parent), { [key]: value }));
  }, [parent, key, value]);
  return [parent == null ? void 0 : parent[key], { onLoadedMetadataCapture }];
}
var hasInstalledGlobalEventListeners = false;
function useIsMouseMoving() {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (hasInstalledGlobalEventListeners) return;
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("mousemove", setMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("mousedown", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("mouseup", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("keydown", resetMouseMoving, true);
    (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_4__.addGlobalEventListener)("scroll", resetMouseMoving, true);
    hasInstalledGlobalEventListeners = true;
  }, []);
  const isMouseMoving = useEvent(() => mouseMoving);
  return isMouseMoving;
}
var mouseMoving = false;
var previousScreenX = 0;
var previousScreenY = 0;
function hasMouseMovement(event) {
  const movementX = event.movementX || event.screenX - previousScreenX;
  const movementY = event.movementY || event.screenY - previousScreenY;
  previousScreenX = event.screenX;
  previousScreenY = event.screenY;
  return movementX || movementY || "development" === "test";
}
function setMouseMoving(event) {
  if (!hasMouseMovement(event)) return;
  mouseMoving = true;
}
function resetMouseMoving() {
  mouseMoving = false;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingLevel: () => (/* binding */ HeadingLevel)
/* harmony export */ });
/* harmony import */ var _CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CZ4GFWYL.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";


// src/heading/heading-level.tsx


function HeadingLevel({ level, children }) {
  const contextLevel = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_2__.HeadingContext);
  const nextLevel = Math.max(
    Math.min(level || contextLevel + 1, 6),
    1
  );
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_CZ4GFWYL_js__WEBPACK_IMPORTED_MODULE_2__.HeadingContext.Provider, { value: nextLevel, children });
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isBackdrop: () => (/* binding */ isBackdrop)
/* harmony export */ });
"use client";

// src/dialog/utils/is-backdrop.ts
function isBackdrop(element, ...ids) {
  if (!element) return false;
  const backdrop = element.getAttribute("data-backdrop");
  if (backdrop == null) return false;
  if (backdrop === "") return true;
  if (backdrop === "true") return true;
  if (!ids.length) return true;
  return ids.some((id) => backdrop === id);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   supportsInert: () => (/* binding */ supportsInert)
/* harmony export */ });
"use client";

// src/dialog/utils/supports-inert.ts
function supportsInert() {
  return "inert" in HTMLElement.prototype;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   prependHiddenDismiss: () => (/* binding */ prependHiddenDismiss)
/* harmony export */ });
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
"use client";

// src/dialog/utils/prepend-hidden-dismiss.ts

function prependHiddenDismiss(container, onClick) {
  const document = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocument)(container);
  const button = document.createElement("button");
  button.type = "button";
  button.tabIndex = -1;
  button.textContent = "Dismiss popup";
  Object.assign(button.style, {
    border: "0px",
    clip: "rect(0 0 0 0)",
    height: "1px",
    margin: "-1px",
    overflow: "hidden",
    padding: "0px",
    position: "absolute",
    whiteSpace: "nowrap",
    width: "1px"
  });
  button.addEventListener("click", onClick);
  container.prepend(button);
  const removeHiddenDismiss = () => {
    button.removeEventListener("click", onClick);
    button.remove();
  };
  return removeHiddenDismiss;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/7Z7JH52O.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/7Z7JH52O.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HovercardContextProvider: () => (/* binding */ HovercardContextProvider),
/* harmony export */   HovercardScopedContextProvider: () => (/* binding */ HovercardScopedContextProvider),
/* harmony export */   useHovercardContext: () => (/* binding */ useHovercardContext),
/* harmony export */   useHovercardProviderContext: () => (/* binding */ useHovercardProviderContext),
/* harmony export */   useHovercardScopedContext: () => (/* binding */ useHovercardScopedContext)
/* harmony export */ });
/* harmony import */ var _Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Y67KZUMI.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y67KZUMI.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
"use client";



// src/hovercard/hovercard-context.tsx
var ctx = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createStoreContext)(
  [_Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_1__.PopoverContextProvider],
  [_Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_1__.PopoverScopedContextProvider]
);
var useHovercardContext = ctx.useContext;
var useHovercardScopedContext = ctx.useScopedContext;
var useHovercardProviderContext = ctx.useProviderContext;
var HovercardContextProvider = ctx.ContextProvider;
var HovercardScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/ABN76PSX.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/ABN76PSX.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DisclosureContextProvider: () => (/* binding */ DisclosureContextProvider),
/* harmony export */   DisclosureScopedContextProvider: () => (/* binding */ DisclosureScopedContextProvider),
/* harmony export */   useDisclosureContext: () => (/* binding */ useDisclosureContext),
/* harmony export */   useDisclosureProviderContext: () => (/* binding */ useDisclosureProviderContext),
/* harmony export */   useDisclosureScopedContext: () => (/* binding */ useDisclosureScopedContext)
/* harmony export */ });
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
"use client";


// src/disclosure/disclosure-context.tsx
var ctx = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createStoreContext)();
var useDisclosureContext = ctx.useContext;
var useDisclosureScopedContext = ctx.useScopedContext;
var useDisclosureProviderContext = ctx.useProviderContext;
var DisclosureContextProvider = ctx.ContextProvider;
var DisclosureScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PortalContext: () => (/* binding */ PortalContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";

// src/portal/portal-context.tsx

var PortalContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createWalkTreeSnapshot: () => (/* binding */ createWalkTreeSnapshot),
/* harmony export */   isValidElement: () => (/* binding */ isValidElement),
/* harmony export */   walkTreeOutside: () => (/* binding */ walkTreeOutside)
/* harmony export */ });
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
"use client";


// src/dialog/utils/walk-tree-outside.ts


var ignoreTags = ["SCRIPT", "STYLE"];
function getSnapshotPropertyName(id) {
  return `__ariakit-dialog-snapshot-${id}`;
}
function inSnapshot(id, element) {
  const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocument)(element);
  const propertyName = getSnapshotPropertyName(id);
  if (!doc.body[propertyName]) return true;
  do {
    if (element === doc.body) return false;
    if (element[propertyName]) return true;
    if (!element.parentElement) return false;
    element = element.parentElement;
  } while (true);
}
function isValidElement(id, element, ignoredElements) {
  if (ignoreTags.includes(element.tagName)) return false;
  if (!inSnapshot(id, element)) return false;
  return !ignoredElements.some(
    (enabledElement) => enabledElement && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.contains)(element, enabledElement)
  );
}
function walkTreeOutside(id, elements, callback, ancestorCallback) {
  for (let element of elements) {
    if (!(element == null ? void 0 : element.isConnected)) continue;
    const hasAncestorAlready = elements.some((maybeAncestor) => {
      if (!maybeAncestor) return false;
      if (maybeAncestor === element) return false;
      return maybeAncestor.contains(element);
    });
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocument)(element);
    const originalElement = element;
    while (element.parentElement && element !== doc.body) {
      ancestorCallback == null ? void 0 : ancestorCallback(element.parentElement, originalElement);
      if (!hasAncestorAlready) {
        for (const child of element.parentElement.children) {
          if (isValidElement(id, child, elements)) {
            callback(child, originalElement);
          }
        }
      }
      element = element.parentElement;
    }
  }
}
function createWalkTreeSnapshot(id, elements) {
  const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocument)(elements[0]);
  const cleanups = [];
  const markElement = (element) => {
    cleanups.push((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(element, getSnapshotPropertyName(id), true));
  };
  walkTreeOutside(id, elements, markElement);
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.chain)((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_1__.setProperty)(body, getSnapshotPropertyName(id), true), () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  });
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/BZZ52UJN.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/BZZ52UJN.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useTooltipStore: () => (/* binding */ useTooltipStore),
/* harmony export */   useTooltipStoreProps: () => (/* binding */ useTooltipStoreProps)
/* harmony export */ });
/* harmony import */ var _GVVKDT6A_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./GVVKDT6A.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/GVVKDT6A.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _ariakit_core_tooltip_tooltip_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/tooltip/tooltip-store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/tooltip/tooltip-store.js");
"use client";



// src/tooltip/tooltip-store.ts

function useTooltipStoreProps(store, update, props) {
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "type");
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "skipTimeout");
  return (0,_GVVKDT6A_js__WEBPACK_IMPORTED_MODULE_1__.useHovercardStoreProps)(store, update, props);
}
function useTooltipStore(props = {}) {
  const [store, update] = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStore)(_ariakit_core_tooltip_tooltip_store__WEBPACK_IMPORTED_MODULE_2__.createTooltipStore, props);
  return useTooltipStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/C6DAL6ZN.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/C6DAL6ZN.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popover: () => (/* binding */ Popover),
/* harmony export */   usePopover: () => (/* binding */ usePopover)
/* harmony export */ });
/* harmony import */ var _CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CAGBPNDP.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CAGBPNDP.js");
/* harmony import */ var _Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Y67KZUMI.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y67KZUMI.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @floating-ui/dom */ "./node_modules/.pnpm/@floating-ui+dom@1.7.4/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";






// src/popover/popover.tsx




var TagName = "div";
function createDOMRect(x = 0, y = 0, width = 0, height = 0) {
  if (typeof DOMRect === "function") {
    return new DOMRect(x, y, width, height);
  }
  const rect = {
    x,
    y,
    width,
    height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x
  };
  return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, rect), { toJSON: () => rect });
}
function getDOMRect(anchorRect) {
  if (!anchorRect) return createDOMRect();
  const { x, y, width, height } = anchorRect;
  return createDOMRect(x, y, width, height);
}
function getAnchorElement(anchorElement, getAnchorRect) {
  const contextElement = anchorElement || void 0;
  return {
    contextElement,
    getBoundingClientRect: () => {
      const anchor = anchorElement;
      const anchorRect = getAnchorRect == null ? void 0 : getAnchorRect(anchor);
      if (anchorRect || !anchor) {
        return getDOMRect(anchorRect);
      }
      return anchor.getBoundingClientRect();
    }
  };
}
function isValidPlacement(flip2) {
  return /^(?:top|bottom|left|right)(?:-(?:start|end))?$/.test(flip2);
}
function roundByDPR(value) {
  const dpr = window.devicePixelRatio || 1;
  return Math.round(value * dpr) / dpr;
}
function getOffsetMiddleware(arrowElement, props) {
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.offset)(({ placement }) => {
    var _a;
    const arrowOffset = ((arrowElement == null ? void 0 : arrowElement.clientHeight) || 0) / 2;
    const finalGutter = typeof props.gutter === "number" ? props.gutter + arrowOffset : (_a = props.gutter) != null ? _a : arrowOffset;
    const hasAlignment = !!placement.split("-")[1];
    return {
      crossAxis: !hasAlignment ? props.shift : void 0,
      mainAxis: finalGutter,
      alignmentAxis: props.shift
    };
  });
}
function getFlipMiddleware(props) {
  if (props.flip === false) return;
  const fallbackPlacements = typeof props.flip === "string" ? props.flip.split(" ") : void 0;
  (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
    !fallbackPlacements || fallbackPlacements.every(isValidPlacement),
     true && "`flip` expects a spaced-delimited list of placements"
  );
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.flip)({
    padding: props.overflowPadding,
    fallbackPlacements
  });
}
function getShiftMiddleware(props) {
  if (!props.slide && !props.overlap) return;
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.shift)({
    mainAxis: props.slide,
    crossAxis: props.overlap,
    padding: props.overflowPadding,
    limiter: (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.limitShift)()
  });
}
function getSizeMiddleware(props) {
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.size)({
    padding: props.overflowPadding,
    apply({ elements, availableWidth, availableHeight, rects }) {
      const wrapper = elements.floating;
      const referenceWidth = Math.round(rects.reference.width);
      availableWidth = Math.floor(availableWidth);
      availableHeight = Math.floor(availableHeight);
      wrapper.style.setProperty(
        "--popover-anchor-width",
        `${referenceWidth}px`
      );
      wrapper.style.setProperty(
        "--popover-available-width",
        `${availableWidth}px`
      );
      wrapper.style.setProperty(
        "--popover-available-height",
        `${availableHeight}px`
      );
      if (props.sameWidth) {
        wrapper.style.width = `${referenceWidth}px`;
      }
      if (props.fitViewport) {
        wrapper.style.maxWidth = `${availableWidth}px`;
        wrapper.style.maxHeight = `${availableHeight}px`;
      }
    }
  });
}
function getArrowMiddleware(arrowElement, props) {
  if (!arrowElement) return;
  return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.arrow)({
    element: arrowElement,
    padding: props.arrowPadding
  });
}
var usePopover = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.createHook)(
  function usePopover2(_a) {
    var _b = _a, {
      store,
      modal = false,
      portal = !!modal,
      preserveTabOrder = true,
      autoFocusOnShow = true,
      wrapperProps,
      fixed = false,
      flip: flip2 = true,
      shift: shift2 = 0,
      slide = true,
      overlap = false,
      sameWidth = false,
      fitViewport = false,
      gutter,
      arrowPadding = 4,
      overflowPadding = 8,
      getAnchorRect,
      updatePosition
    } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__objRest)(_b, [
      "store",
      "modal",
      "portal",
      "preserveTabOrder",
      "autoFocusOnShow",
      "wrapperProps",
      "fixed",
      "flip",
      "shift",
      "slide",
      "overlap",
      "sameWidth",
      "fitViewport",
      "gutter",
      "arrowPadding",
      "overflowPadding",
      "getAnchorRect",
      "updatePosition"
    ]);
    const context = (0,_Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_6__.usePopoverProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
      store,
       true && "Popover must receive a `store` prop or be wrapped in a PopoverProvider component."
    );
    const arrowElement = store.useState("arrowElement");
    const anchorElement = store.useState("anchorElement");
    const disclosureElement = store.useState("disclosureElement");
    const popoverElement = store.useState("popoverElement");
    const contentElement = store.useState("contentElement");
    const placement = store.useState("placement");
    const mounted = store.useState("mounted");
    const rendered = store.useState("rendered");
    const defaultArrowElementRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const [positioned, setPositioned] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const { portalRef, domReady } = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.usePortalRef)(portal, props.portalRef);
    const getAnchorRectProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useEvent)(getAnchorRect);
    const updatePositionProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useEvent)(updatePosition);
    const hasCustomUpdatePosition = !!updatePosition;
    (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
      if (!(popoverElement == null ? void 0 : popoverElement.isConnected)) return;
      popoverElement.style.setProperty(
        "--popover-overflow-padding",
        `${overflowPadding}px`
      );
      const anchor = getAnchorElement(anchorElement, getAnchorRectProp);
      const updatePosition2 = async () => {
        if (!mounted) return;
        if (!arrowElement) {
          defaultArrowElementRef.current = defaultArrowElementRef.current || document.createElement("div");
        }
        const arrow2 = arrowElement || defaultArrowElementRef.current;
        const middleware = [
          getOffsetMiddleware(arrow2, { gutter, shift: shift2 }),
          getFlipMiddleware({ flip: flip2, overflowPadding }),
          getShiftMiddleware({ slide, shift: shift2, overlap, overflowPadding }),
          getArrowMiddleware(arrow2, { arrowPadding }),
          getSizeMiddleware({
            sameWidth,
            fitViewport,
            overflowPadding
          })
        ];
        const pos = await (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.computePosition)(anchor, popoverElement, {
          placement,
          strategy: fixed ? "fixed" : "absolute",
          middleware
        });
        store == null ? void 0 : store.setState("currentPlacement", pos.placement);
        setPositioned(true);
        const x = roundByDPR(pos.x);
        const y = roundByDPR(pos.y);
        Object.assign(popoverElement.style, {
          top: "0",
          left: "0",
          transform: `translate3d(${x}px,${y}px,0)`
        });
        if (arrow2 && pos.middlewareData.arrow) {
          const { x: arrowX, y: arrowY } = pos.middlewareData.arrow;
          const side = pos.placement.split("-")[0];
          const centerX = arrow2.clientWidth / 2;
          const centerY = arrow2.clientHeight / 2;
          const originX = arrowX != null ? arrowX + centerX : -centerX;
          const originY = arrowY != null ? arrowY + centerY : -centerY;
          popoverElement.style.setProperty(
            "--popover-transform-origin",
            {
              top: `${originX}px calc(100% + ${centerY}px)`,
              bottom: `${originX}px ${-centerY}px`,
              left: `calc(100% + ${centerX}px) ${originY}px`,
              right: `${-centerX}px ${originY}px`
            }[side]
          );
          Object.assign(arrow2.style, {
            left: arrowX != null ? `${arrowX}px` : "",
            top: arrowY != null ? `${arrowY}px` : "",
            [side]: "100%"
          });
        }
      };
      const update = async () => {
        if (hasCustomUpdatePosition) {
          await updatePositionProp({ updatePosition: updatePosition2 });
          setPositioned(true);
        } else {
          await updatePosition2();
        }
      };
      const cancelAutoUpdate = (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_3__.autoUpdate)(anchor, popoverElement, update, {
        // JSDOM doesn't support ResizeObserver
        elementResize: typeof ResizeObserver === "function"
      });
      return () => {
        setPositioned(false);
        cancelAutoUpdate();
      };
    }, [
      store,
      rendered,
      popoverElement,
      arrowElement,
      anchorElement,
      popoverElement,
      placement,
      mounted,
      domReady,
      fixed,
      flip2,
      shift2,
      slide,
      overlap,
      sameWidth,
      fitViewport,
      gutter,
      arrowPadding,
      overflowPadding,
      getAnchorRectProp,
      hasCustomUpdatePosition,
      updatePositionProp
    ]);
    (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
      if (!mounted) return;
      if (!domReady) return;
      if (!(popoverElement == null ? void 0 : popoverElement.isConnected)) return;
      if (!(contentElement == null ? void 0 : contentElement.isConnected)) return;
      const applyZIndex = () => {
        popoverElement.style.zIndex = getComputedStyle(contentElement).zIndex;
      };
      applyZIndex();
      let raf = requestAnimationFrame(() => {
        raf = requestAnimationFrame(applyZIndex);
      });
      return () => cancelAnimationFrame(raf);
    }, [mounted, domReady, popoverElement, contentElement]);
    const position = fixed ? "fixed" : "absolute";
    props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(
        "div",
        (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, wrapperProps), {
          style: (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({
            // https://floating-ui.com/docs/computeposition#initial-layout
            position,
            top: 0,
            left: 0,
            width: "max-content"
          }, wrapperProps == null ? void 0 : wrapperProps.style),
          ref: store == null ? void 0 : store.setPopoverElement,
          children: element
        })
      ),
      [store, position, wrapperProps]
    );
    props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_6__.PopoverScopedContextProvider, { value: store, children: element }),
      [store]
    );
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({
      // data-placing is not part of the public API. We're setting this here so
      // we can wait for the popover to be positioned before other components
      // move focus into it. For example, this attribute is observed by the
      // Combobox component with the autoSelect behavior.
      "data-placing": !positioned || void 0
    }, props), {
      style: (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({
        position: "relative"
      }, props.style)
    });
    props = (0,_CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_8__.useDialog)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({
      store,
      modal,
      portal,
      preserveTabOrder,
      preserveTabOrderAnchor: disclosureElement || anchorElement,
      autoFocusOnShow: positioned && autoFocusOnShow
    }, props), {
      portalRef
    }));
    return props;
  }
);
var Popover = (0,_CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_8__.createDialogComponent)(
  (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(function Popover2(props) {
    const htmlProps = usePopover(props);
    return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.createElement)(TagName, htmlProps);
  }),
  _Y67KZUMI_js__WEBPACK_IMPORTED_MODULE_6__.usePopoverProviderContext
);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CAGBPNDP.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CAGBPNDP.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dialog: () => (/* binding */ Dialog),
/* harmony export */   createDialogComponent: () => (/* binding */ createDialogComponent),
/* harmony export */   useDialog: () => (/* binding */ useDialog)
/* harmony export */ });
/* harmony import */ var _M5DFOEFU_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./M5DFOEFU.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/M5DFOEFU.js");
/* harmony import */ var _5M6RIVE2_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./5M6RIVE2.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5M6RIVE2.js");
/* harmony import */ var _LC6GJMGV_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./LC6GJMGV.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/LC6GJMGV.js");
/* harmony import */ var _6GXEOXGT_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./6GXEOXGT.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/6GXEOXGT.js");
/* harmony import */ var _JZEJYXOQ_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./JZEJYXOQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/JZEJYXOQ.js");
/* harmony import */ var _PVECYOSC_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./PVECYOSC.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/PVECYOSC.js");
/* harmony import */ var _SOMPWLIQ_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SOMPWLIQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SOMPWLIQ.js");
/* harmony import */ var _Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Z5GCVBAY.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js");
/* harmony import */ var _677M2CI3_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./677M2CI3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js");
/* harmony import */ var _FVE2C5B3_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./FVE2C5B3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/FVE2C5B3.js");
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K4R5DNTX_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./K4R5DNTX.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K4R5DNTX.js");
/* harmony import */ var _Y2U4BRIM_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Y2U4BRIM.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y2U4BRIM.js");
/* harmony import */ var _T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./T2AZQXQU.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T2AZQXQU.js");
/* harmony import */ var _OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./OE2EFRVA.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/OE2EFRVA.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";





















// src/dialog/dialog.tsx







var TagName = "div";
var isSafariBrowser = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_2__.isSafari)();
function isAlreadyFocusingAnotherElement(dialog) {
  const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getActiveElement)();
  if (!activeElement) return false;
  if (dialog && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(dialog, activeElement)) return false;
  if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.isFocusable)(activeElement)) return true;
  return false;
}
function getElementFromProp(prop, focusable = false) {
  if (!prop) return null;
  const element = "current" in prop ? prop.current : prop;
  if (!element) return null;
  if (focusable) return (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.isFocusable)(element) ? element : null;
  return element;
}
var useDialog = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.createHook)(function useDialog2(_a) {
  var _b = _a, {
    store: storeProp,
    open: openProp,
    onClose,
    focusable = true,
    modal = true,
    portal = !!modal,
    backdrop = !!modal,
    hideOnEscape = true,
    hideOnInteractOutside = true,
    getPersistentElements,
    preventBodyScroll = !!modal,
    autoFocusOnShow = true,
    autoFocusOnHide = true,
    initialFocus,
    finalFocus,
    unmountOnHide,
    unstable_treeSnapshotKey
  } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__objRest)(_b, [
    "store",
    "open",
    "onClose",
    "focusable",
    "modal",
    "portal",
    "backdrop",
    "hideOnEscape",
    "hideOnInteractOutside",
    "getPersistentElements",
    "preventBodyScroll",
    "autoFocusOnShow",
    "autoFocusOnHide",
    "initialFocus",
    "finalFocus",
    "unmountOnHide",
    "unstable_treeSnapshotKey"
  ]);
  const context = (0,_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.useDialogProviderContext)();
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const store = (0,_Y2U4BRIM_js__WEBPACK_IMPORTED_MODULE_8__.useDialogStore)({
    store: storeProp || context,
    open: openProp,
    setOpen(open2) {
      if (open2) return;
      const dialog = ref.current;
      if (!dialog) return;
      const event = new Event("close", { bubbles: false, cancelable: true });
      if (onClose) {
        dialog.addEventListener("close", onClose, { once: true });
      }
      dialog.dispatchEvent(event);
      if (!event.defaultPrevented) return;
      store.setOpen(true);
    }
  });
  const { portalRef, domReady } = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.usePortalRef)(portal, props.portalRef);
  const preserveTabOrderProp = props.preserveTabOrder;
  const preserveTabOrder = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__.useStoreState)(
    store,
    (state) => preserveTabOrderProp && !modal && state.mounted
  );
  const id = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useId)(props.id);
  const open = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__.useStoreState)(store, "open");
  const mounted = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__.useStoreState)(store, "mounted");
  const contentElement = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__.useStoreState)(store, "contentElement");
  const hidden = (0,_K4R5DNTX_js__WEBPACK_IMPORTED_MODULE_11__.isHidden)(mounted, props.hidden, props.alwaysVisible);
  (0,_SOMPWLIQ_js__WEBPACK_IMPORTED_MODULE_12__.usePreventBodyScroll)(contentElement, id, preventBodyScroll && !hidden);
  (0,_JZEJYXOQ_js__WEBPACK_IMPORTED_MODULE_13__.useHideOnInteractOutside)(store, hideOnInteractOutside, domReady);
  const { wrapElement, nestedDialogs } = (0,_PVECYOSC_js__WEBPACK_IMPORTED_MODULE_14__.useNestedDialogs)(store);
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useWrapElement)(props, wrapElement, [wrapElement]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useSafeLayoutEffect)(() => {
    if (!open) return;
    const dialog = ref.current;
    const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getActiveElement)(dialog, true);
    if (!activeElement) return;
    if (activeElement.tagName === "BODY") return;
    if (dialog && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(dialog, activeElement)) return;
    store.setDisclosureElement(activeElement);
  }, [store, open]);
  if (isSafariBrowser) {
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!mounted) return;
      const { disclosureElement } = store.getState();
      if (!disclosureElement) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.isButton)(disclosureElement)) return;
      const onMouseDown = () => {
        let receivedFocus = false;
        const onFocus = () => {
          receivedFocus = true;
        };
        const options = { capture: true, once: true };
        disclosureElement.addEventListener("focusin", onFocus, options);
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_15__.queueBeforeEvent)(disclosureElement, "mouseup", () => {
          disclosureElement.removeEventListener("focusin", onFocus, true);
          if (receivedFocus) return;
          (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.focusIfNeeded)(disclosureElement);
        });
      };
      disclosureElement.addEventListener("mousedown", onMouseDown);
      return () => {
        disclosureElement.removeEventListener("mousedown", onMouseDown);
      };
    }, [store, mounted]);
  }
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    const win = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getWindow)(dialog);
    const viewport = win.visualViewport || win;
    const setViewportHeight = () => {
      var _a2, _b2;
      const height = (_b2 = (_a2 = win.visualViewport) == null ? void 0 : _a2.height) != null ? _b2 : win.innerHeight;
      dialog.style.setProperty("--dialog-viewport-height", `${height}px`);
    };
    setViewportHeight();
    viewport.addEventListener("resize", setViewportHeight);
    return () => {
      viewport.removeEventListener("resize", setViewportHeight);
    };
  }, [mounted, domReady]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!modal) return;
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    const existingDismiss = dialog.querySelector("[data-dialog-dismiss]");
    if (existingDismiss) return;
    return (0,_6GXEOXGT_js__WEBPACK_IMPORTED_MODULE_16__.prependHiddenDismiss)(dialog, store.hide);
  }, [store, modal, mounted, domReady]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useSafeLayoutEffect)(() => {
    if (!(0,_677M2CI3_js__WEBPACK_IMPORTED_MODULE_17__.supportsInert)()) return;
    if (open) return;
    if (!mounted) return;
    if (!domReady) return;
    const dialog = ref.current;
    if (!dialog) return;
    return (0,_Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_18__.disableTree)(dialog);
  }, [open, mounted, domReady]);
  const canTakeTreeSnapshot = open && domReady;
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useSafeLayoutEffect)(() => {
    if (!id) return;
    if (!canTakeTreeSnapshot) return;
    const dialog = ref.current;
    return (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_19__.createWalkTreeSnapshot)(id, [dialog]);
  }, [id, canTakeTreeSnapshot, unstable_treeSnapshotKey]);
  const getPersistentElementsProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useEvent)(getPersistentElements);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useSafeLayoutEffect)(() => {
    if (!id) return;
    if (!canTakeTreeSnapshot) return;
    const { disclosureElement } = store.getState();
    const dialog = ref.current;
    const persistentElements = getPersistentElementsProp() || [];
    const allElements = [
      dialog,
      ...persistentElements,
      ...nestedDialogs.map((dialog2) => dialog2.getState().contentElement)
    ];
    if (modal) {
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_20__.chain)(
        (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_21__.markTreeOutside)(id, allElements),
        (0,_Z5GCVBAY_js__WEBPACK_IMPORTED_MODULE_18__.disableTreeOutside)(id, allElements)
      );
    }
    return (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_21__.markTreeOutside)(id, [disclosureElement, ...allElements]);
  }, [
    id,
    store,
    canTakeTreeSnapshot,
    getPersistentElementsProp,
    nestedDialogs,
    modal,
    unstable_treeSnapshotKey
  ]);
  const mayAutoFocusOnShow = !!autoFocusOnShow;
  const autoFocusOnShowProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useBooleanEvent)(autoFocusOnShow);
  const [autoFocusEnabled, setAutoFocusEnabled] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!open) return;
    if (!mayAutoFocusOnShow) return;
    if (!domReady) return;
    if (!(contentElement == null ? void 0 : contentElement.isConnected)) return;
    const element = getElementFromProp(initialFocus, true) || // If no initial focus is specified, we try to focus the first element
    // with the autofocus attribute. If it's an Ariakit component, the
    // Focusable component will consume the autoFocus prop and add the
    // data-autofocus attribute to the element instead.
    contentElement.querySelector(
      "[data-autofocus=true],[autofocus]"
    ) || // We have to fallback to the first focusable element otherwise portaled
    // dialogs with preserveTabOrder set to true will not receive focus
    // properly because the elements aren't tabbable until the dialog receives
    // focus.
    (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.getFirstTabbableIn)(contentElement, true, portal && preserveTabOrder) || // Finally, we fallback to the dialog element itself.
    contentElement;
    const isElementFocusable = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.isFocusable)(element);
    if (!autoFocusOnShowProp(isElementFocusable ? element : null)) return;
    setAutoFocusEnabled(true);
    queueMicrotask(() => {
      element.focus();
      if (!isSafariBrowser) return;
      if (!isElementFocusable) return;
      element.scrollIntoView({ block: "nearest", inline: "nearest" });
    });
  }, [
    open,
    mayAutoFocusOnShow,
    domReady,
    contentElement,
    initialFocus,
    portal,
    preserveTabOrder,
    autoFocusOnShowProp
  ]);
  const mayAutoFocusOnHide = !!autoFocusOnHide;
  const autoFocusOnHideProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useBooleanEvent)(autoFocusOnHide);
  const [hasOpened, setHasOpened] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!open) return;
    setHasOpened(true);
    return () => setHasOpened(false);
  }, [open]);
  const focusOnHide = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
    (dialog, retry = true) => {
      const { disclosureElement } = store.getState();
      if (isAlreadyFocusingAnotherElement(dialog)) return;
      let element = getElementFromProp(finalFocus) || disclosureElement;
      if (element == null ? void 0 : element.id) {
        const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(element);
        const selector = `[aria-activedescendant="${element.id}"]`;
        const composite = doc.querySelector(selector);
        if (composite) {
          element = composite;
        }
      }
      if (element && !(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.isFocusable)(element)) {
        const maybeParentDialog = element.closest("[data-dialog]");
        if (maybeParentDialog == null ? void 0 : maybeParentDialog.id) {
          const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(maybeParentDialog);
          const selector = `[aria-controls~="${maybeParentDialog.id}"]`;
          const control = doc.querySelector(selector);
          if (control) {
            element = control;
          }
        }
      }
      const isElementFocusable = element && (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_4__.isFocusable)(element);
      if (!isElementFocusable && retry) {
        requestAnimationFrame(() => focusOnHide(dialog, false));
        return;
      }
      if (!autoFocusOnHideProp(isElementFocusable ? element : null)) return;
      if (!isElementFocusable) return;
      element == null ? void 0 : element.focus({ preventScroll: true });
    },
    [store, finalFocus, autoFocusOnHideProp]
  );
  const focusedOnHideRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useSafeLayoutEffect)(() => {
    if (open) return;
    if (!hasOpened) return;
    if (!mayAutoFocusOnHide) return;
    const dialog = ref.current;
    focusedOnHideRef.current = true;
    focusOnHide(dialog);
  }, [open, hasOpened, domReady, mayAutoFocusOnHide, focusOnHide]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!hasOpened) return;
    if (!mayAutoFocusOnHide) return;
    const dialog = ref.current;
    return () => {
      if (focusedOnHideRef.current) {
        focusedOnHideRef.current = false;
        return;
      }
      focusOnHide(dialog);
    };
  }, [hasOpened, mayAutoFocusOnHide, focusOnHide]);
  const hideOnEscapeProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useBooleanEvent)(hideOnEscape);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!domReady) return;
    if (!mounted) return;
    const onKeyDown = (event) => {
      if (event.key !== "Escape") return;
      if (event.defaultPrevented) return;
      const dialog = ref.current;
      if (!dialog) return;
      if ((0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_21__.isElementMarked)(dialog)) return;
      const target = event.target;
      if (!target) return;
      const { disclosureElement } = store.getState();
      const isValidTarget = () => {
        if (target.tagName === "BODY") return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(dialog, target)) return true;
        if (!disclosureElement) return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(disclosureElement, target)) return true;
        return false;
      };
      if (!isValidTarget()) return;
      if (!hideOnEscapeProp(event)) return;
      store.hide();
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_15__.addGlobalEventListener)("keydown", onKeyDown, true);
  }, [store, domReady, mounted, hideOnEscapeProp]);
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_5M6RIVE2_js__WEBPACK_IMPORTED_MODULE_22__.HeadingLevel, { level: modal ? 1 : void 0, children: element }),
    [modal]
  );
  const hiddenProp = props.hidden;
  const alwaysVisible = props.alwaysVisible;
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useWrapElement)(
    props,
    (element) => {
      if (!backdrop) return element;
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, { children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(
          _FVE2C5B3_js__WEBPACK_IMPORTED_MODULE_23__.DialogBackdrop,
          {
            store,
            backdrop,
            hidden: hiddenProp,
            alwaysVisible
          }
        ),
        element
      ] });
    },
    [store, backdrop, hiddenProp, alwaysVisible]
  );
  const [headingId, setHeadingId] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
  const [descriptionId, setDescriptionId] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)();
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.DialogScopedContextProvider, { value: store, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.DialogHeadingContext.Provider, { value: setHeadingId, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.DialogDescriptionContext.Provider, { value: setDescriptionId, children: element }) }) }),
    [store]
  );
  props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({
    id,
    "data-dialog": "",
    role: "dialog",
    tabIndex: focusable ? -1 : void 0,
    "aria-labelledby": headingId,
    "aria-describedby": descriptionId
  }, props), {
    ref: (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_9__.useMergeRefs)(ref, props.ref)
  });
  props = (0,_LC6GJMGV_js__WEBPACK_IMPORTED_MODULE_24__.useFocusableContainer)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({}, props), {
    autoFocusOnShow: autoFocusEnabled
  }));
  props = (0,_K4R5DNTX_js__WEBPACK_IMPORTED_MODULE_11__.useDisclosureContent)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({ store }, props));
  props = (0,_OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_25__.useFocusable)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({}, props), { focusable }));
  props = (0,_M5DFOEFU_js__WEBPACK_IMPORTED_MODULE_26__.usePortal)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({ portal }, props), { portalRef, preserveTabOrder }));
  return props;
});
function createDialogComponent(Component, useProviderContext = _T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.useDialogProviderContext) {
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(function DialogComponent(props) {
    const context = useProviderContext();
    const store = props.store || context;
    const mounted = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_10__.useStoreState)(
      store,
      (state) => !props.unmountOnHide || (state == null ? void 0 : state.mounted) || !!props.open
    );
    if (!mounted) return null;
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Component, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_6__.__spreadValues)({}, props));
  });
}
var Dialog = createDialogComponent(
  (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(function Dialog2(props) {
    const htmlProps = useDialog(props);
    return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_5__.createElement)(TagName, htmlProps);
  }),
  _T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_7__.useDialogProviderContext
);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CZ4GFWYL.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HeadingContext: () => (/* binding */ HeadingContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";

// src/heading/heading-context.tsx

var HeadingContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(0);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/DXGKYUAD.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/DXGKYUAD.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VisuallyHidden: () => (/* binding */ VisuallyHidden),
/* harmony export */   useVisuallyHidden: () => (/* binding */ useVisuallyHidden)
/* harmony export */ });
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
"use client";



// src/visually-hidden/visually-hidden.tsx
var TagName = "span";
var useVisuallyHidden = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createHook)(
  function useVisuallyHidden2(props) {
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, props), {
      style: (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({
        border: 0,
        clip: "rect(0 0 0 0)",
        height: "1px",
        margin: "-1px",
        overflow: "hidden",
        padding: 0,
        position: "absolute",
        whiteSpace: "nowrap",
        width: "1px"
      }, props.style)
    });
    return props;
  }
);
var VisuallyHidden = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function VisuallyHidden2(props) {
  const htmlProps = useVisuallyHidden(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/FVE2C5B3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/FVE2C5B3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DialogBackdrop: () => (/* binding */ DialogBackdrop)
/* harmony export */ });
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _K4R5DNTX_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./K4R5DNTX.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K4R5DNTX.js");
/* harmony import */ var _T22PY7TE_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./T22PY7TE.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T22PY7TE.js");
/* harmony import */ var _QJ4LGO2N_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./QJ4LGO2N.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/QJ4LGO2N.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";








// src/dialog/dialog-backdrop.tsx


function DialogBackdrop({
  store,
  backdrop,
  alwaysVisible,
  hidden
}) {
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const disclosure = (0,_T22PY7TE_js__WEBPACK_IMPORTED_MODULE_2__.useDisclosureStore)({ disclosure: store });
  const contentElement = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_3__.useStoreState)(store, "contentElement");
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    const backdrop2 = ref.current;
    const dialog = contentElement;
    if (!backdrop2) return;
    if (!dialog) return;
    backdrop2.style.zIndex = getComputedStyle(dialog).zIndex;
  }, [contentElement]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_4__.useSafeLayoutEffect)(() => {
    const id = contentElement == null ? void 0 : contentElement.id;
    if (!id) return;
    const backdrop2 = ref.current;
    if (!backdrop2) return;
    return (0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_5__.markAncestor)(backdrop2, id);
  }, [contentElement]);
  const props = (0,_K4R5DNTX_js__WEBPACK_IMPORTED_MODULE_6__.useDisclosureContent)({
    ref,
    store: disclosure,
    role: "presentation",
    "data-backdrop": (contentElement == null ? void 0 : contentElement.id) || "",
    alwaysVisible,
    hidden: hidden != null ? hidden : void 0,
    style: {
      position: "fixed",
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    }
  });
  if (!backdrop) return null;
  if ((0,react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(backdrop)) {
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_QJ4LGO2N_js__WEBPACK_IMPORTED_MODULE_7__.Role, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadValues)({}, props), { render: backdrop }));
  }
  const Component = typeof backdrop !== "boolean" ? backdrop : "div";
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_QJ4LGO2N_js__WEBPACK_IMPORTED_MODULE_7__.Role, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadValues)({}, props), { render: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Component, {}) }));
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/GVVKDT6A.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/GVVKDT6A.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHovercardStore: () => (/* binding */ useHovercardStore),
/* harmony export */   useHovercardStoreProps: () => (/* binding */ useHovercardStoreProps)
/* harmony export */ });
/* harmony import */ var _RUY5BUJG_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RUY5BUJG.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RUY5BUJG.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _ariakit_core_hovercard_hovercard_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/hovercard/hovercard-store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/JTLIIJ4U.js");
"use client";



// src/hovercard/hovercard-store.ts

function useHovercardStoreProps(store, update, props) {
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "timeout");
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "showTimeout");
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStoreProps)(store, props, "hideTimeout");
  return (0,_RUY5BUJG_js__WEBPACK_IMPORTED_MODULE_1__.usePopoverStoreProps)(store, update, props);
}
function useHovercardStore(props = {}) {
  const [store, update] = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_0__.useStore)(_ariakit_core_hovercard_hovercard_store__WEBPACK_IMPORTED_MODULE_2__.createHovercardStore, props);
  return useHovercardStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePreviousMouseDownRef: () => (/* binding */ usePreviousMouseDownRef)
/* harmony export */ });
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";

// src/dialog/utils/use-previous-mouse-down-ref.ts


function usePreviousMouseDownRef(enabled) {
  const previousMouseDownRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!enabled) {
      previousMouseDownRef.current = null;
      return;
    }
    const onMouseDown = (event) => {
      previousMouseDownRef.current = event.target;
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_1__.addGlobalEventListener)("mousedown", onMouseDown, true);
  }, [enabled]);
  return previousMouseDownRef;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isFocusTrap: () => (/* binding */ isFocusTrap)
/* harmony export */ });
"use client";

// src/dialog/utils/is-focus-trap.ts
function isFocusTrap(element, ...ids) {
  if (!element) return false;
  const attr = element.getAttribute("data-focus-trap");
  if (attr == null) return false;
  if (!ids.length) return true;
  if (attr === "") return false;
  return ids.some((id) => attr === id);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IUFFNNPK.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IUFFNNPK.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Hovercard: () => (/* binding */ Hovercard),
/* harmony export */   useHovercard: () => (/* binding */ useHovercard)
/* harmony export */ });
/* harmony import */ var _X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./X7QOZUD3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js");
/* harmony import */ var _7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./7Z7JH52O.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/7Z7JH52O.js");
/* harmony import */ var _C6DAL6ZN_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./C6DAL6ZN.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/C6DAL6ZN.js");
/* harmony import */ var _CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./CAGBPNDP.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CAGBPNDP.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";








// src/hovercard/hovercard.tsx







var TagName = "div";
function isMovingOnHovercard(target, card, anchor, nested) {
  if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_2__.hasFocusWithin)(card)) return true;
  if (!target) return false;
  if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(card, target)) return true;
  if (anchor && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(anchor, target)) return true;
  if (nested == null ? void 0 : nested.some((card2) => isMovingOnHovercard(target, card2, anchor))) {
    return true;
  }
  return false;
}
function useAutoFocusOnHide(_a) {
  var _b = _a, {
    store
  } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__objRest)(_b, [
    "store"
  ]);
  const [autoFocusOnHide, setAutoFocusOnHide] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const mounted = store.useState("mounted");
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!mounted) {
      setAutoFocusOnHide(false);
    }
  }, [mounted]);
  const onFocusProp = props.onFocus;
  const onFocus = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useEvent)((event) => {
    onFocusProp == null ? void 0 : onFocusProp(event);
    if (event.defaultPrevented) return;
    setAutoFocusOnHide(true);
  });
  const finalFocusRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_6__.sync)(store, ["anchorElement"], (state) => {
      finalFocusRef.current = state.anchorElement;
    });
  }, []);
  props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({
    autoFocusOnHide,
    finalFocus: finalFocusRef
  }, props), {
    onFocus
  });
  return props;
}
var NestedHovercardContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(null);
var useHovercard = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_7__.createHook)(
  function useHovercard2(_a) {
    var _b = _a, {
      store,
      modal = false,
      portal = !!modal,
      hideOnEscape = true,
      hideOnHoverOutside = true,
      disablePointerEventsOnApproach = !!hideOnHoverOutside
    } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__objRest)(_b, [
      "store",
      "modal",
      "portal",
      "hideOnEscape",
      "hideOnHoverOutside",
      "disablePointerEventsOnApproach"
    ]);
    const context = (0,_7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_8__.useHovercardProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.invariant)(
      store,
       true && "Hovercard must receive a `store` prop or be wrapped in a HovercardProvider component."
    );
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const [nestedHovercards, setNestedHovercards] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const hideTimeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0);
    const enterPointRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const { portalRef, domReady } = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.usePortalRef)(portal, props.portalRef);
    const isMouseMoving = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useIsMouseMoving)();
    const mayHideOnHoverOutside = !!hideOnHoverOutside;
    const hideOnHoverOutsideProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useBooleanEvent)(hideOnHoverOutside);
    const mayDisablePointerEvents = !!disablePointerEventsOnApproach;
    const disablePointerEventsProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useBooleanEvent)(
      disablePointerEventsOnApproach
    );
    const open = store.useState("open");
    const mounted = store.useState("mounted");
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!domReady) return;
      if (!mounted) return;
      if (!mayHideOnHoverOutside && !mayDisablePointerEvents) return;
      const element = ref.current;
      if (!element) return;
      const onMouseMove = (event) => {
        if (!store) return;
        if (!isMouseMoving()) return;
        const { anchorElement, hideTimeout, timeout } = store.getState();
        const enterPoint = enterPointRef.current;
        const [target] = event.composedPath();
        const anchor = anchorElement;
        if (isMovingOnHovercard(target, element, anchor, nestedHovercards)) {
          enterPointRef.current = target && anchor && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.contains)(anchor, target) ? (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.getEventPoint)(event) : null;
          window.clearTimeout(hideTimeoutRef.current);
          hideTimeoutRef.current = 0;
          return;
        }
        if (hideTimeoutRef.current) return;
        if (enterPoint) {
          const currentPoint = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.getEventPoint)(event);
          const polygon = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.getElementPolygon)(element, enterPoint);
          if ((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.isPointInPolygon)(currentPoint, polygon)) {
            enterPointRef.current = currentPoint;
            if (!disablePointerEventsProp(event)) return;
            event.preventDefault();
            event.stopPropagation();
            return;
          }
        }
        if (!hideOnHoverOutsideProp(event)) return;
        hideTimeoutRef.current = window.setTimeout(() => {
          hideTimeoutRef.current = 0;
          store == null ? void 0 : store.hide();
        }, hideTimeout != null ? hideTimeout : timeout);
      };
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.chain)(
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__.addGlobalEventListener)("mousemove", onMouseMove, true),
        () => clearTimeout(hideTimeoutRef.current)
      );
    }, [
      store,
      isMouseMoving,
      domReady,
      mounted,
      mayHideOnHoverOutside,
      mayDisablePointerEvents,
      nestedHovercards,
      disablePointerEventsProp,
      hideOnHoverOutsideProp
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!domReady) return;
      if (!mounted) return;
      if (!mayDisablePointerEvents) return;
      const disableEvent = (event) => {
        const element = ref.current;
        if (!element) return;
        const enterPoint = enterPointRef.current;
        if (!enterPoint) return;
        const polygon = (0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.getElementPolygon)(element, enterPoint);
        if ((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.isPointInPolygon)((0,_X7QOZUD3_js__WEBPACK_IMPORTED_MODULE_10__.getEventPoint)(event), polygon)) {
          if (!disablePointerEventsProp(event)) return;
          event.preventDefault();
          event.stopPropagation();
        }
      };
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.chain)(
        // Note: we may need to add pointer events here in the future.
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__.addGlobalEventListener)("mouseenter", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__.addGlobalEventListener)("mouseover", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__.addGlobalEventListener)("mouseout", disableEvent, true),
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_11__.addGlobalEventListener)("mouseleave", disableEvent, true)
      );
    }, [domReady, mounted, mayDisablePointerEvents, disablePointerEventsProp]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!domReady) return;
      if (open) return;
      store == null ? void 0 : store.setAutoFocusOnShow(false);
    }, [store, domReady, open]);
    const openRef = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useLiveRef)(open);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!domReady) return;
      return () => {
        if (!openRef.current) {
          store == null ? void 0 : store.setAutoFocusOnShow(false);
        }
      };
    }, [store, domReady]);
    const registerOnParent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(NestedHovercardContext);
    (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => {
      if (modal) return;
      if (!portal) return;
      if (!mounted) return;
      if (!domReady) return;
      const element = ref.current;
      if (!element) return;
      return registerOnParent == null ? void 0 : registerOnParent(element);
    }, [modal, portal, mounted, domReady]);
    const registerNestedHovercard = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
      (element) => {
        setNestedHovercards((prevElements) => [...prevElements, element]);
        const parentUnregister = registerOnParent == null ? void 0 : registerOnParent(element);
        return () => {
          setNestedHovercards(
            (prevElements) => prevElements.filter((item) => item !== element)
          );
          parentUnregister == null ? void 0 : parentUnregister();
        };
      },
      [registerOnParent]
    );
    props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_8__.HovercardScopedContextProvider, { value: store, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(NestedHovercardContext.Provider, { value: registerNestedHovercard, children: element }) }),
      [store, registerNestedHovercard]
    );
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, props), {
      ref: (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useMergeRefs)(ref, props.ref)
    });
    props = useAutoFocusOnHide((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({ store }, props));
    const autoFocusOnShow = store.useState(
      (state) => modal || state.autoFocusOnShow
    );
    props = (0,_C6DAL6ZN_js__WEBPACK_IMPORTED_MODULE_12__.usePopover)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({
      store,
      modal,
      portal,
      autoFocusOnShow
    }, props), {
      portalRef,
      hideOnEscape(event) {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_9__.isFalsyBooleanCallback)(hideOnEscape, event)) return false;
        requestAnimationFrame(() => {
          requestAnimationFrame(() => {
            store == null ? void 0 : store.hide();
          });
        });
        return true;
      }
    }));
    return props;
  }
);
var Hovercard = (0,_CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_13__.createDialogComponent)(
  (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_7__.forwardRef)(function Hovercard2(props) {
    const htmlProps = useHovercard(props);
    return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_7__.createElement)(TagName, htmlProps);
  }),
  _7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_8__.useHovercardProviderContext
);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/JZEJYXOQ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/JZEJYXOQ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHideOnInteractOutside: () => (/* binding */ useHideOnInteractOutside)
/* harmony export */ });
/* harmony import */ var _HLTQOHKZ_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./HLTQOHKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/HLTQOHKZ.js");
/* harmony import */ var _3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./3NDVDEB4.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3NDVDEB4.js");
/* harmony import */ var _OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./OE2EFRVA.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/OE2EFRVA.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";







// src/dialog/utils/use-hide-on-interact-outside.ts



function isInDocument(target) {
  if (target.tagName === "HTML") return true;
  return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.contains)((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(target).body, target);
}
function isDisclosure(disclosure, target) {
  if (!disclosure) return false;
  if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.contains)(disclosure, target)) return true;
  const activeId = target.getAttribute("aria-activedescendant");
  if (activeId) {
    const activeElement = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(disclosure).getElementById(activeId);
    if (activeElement) {
      return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.contains)(disclosure, activeElement);
    }
  }
  return false;
}
function isMouseEventOnDialog(event, dialog) {
  if (!("clientY" in event)) return false;
  const rect = dialog.getBoundingClientRect();
  if (rect.width === 0 || rect.height === 0) return false;
  return rect.top <= event.clientY && event.clientY <= rect.top + rect.height && rect.left <= event.clientX && event.clientX <= rect.left + rect.width;
}
function useEventOutside({
  store,
  type,
  listener,
  capture,
  domReady
}) {
  const callListener = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)(listener);
  const open = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_3__.useStoreState)(store, "open");
  const focusedRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useSafeLayoutEffect)(() => {
    if (!open) return;
    if (!domReady) return;
    const { contentElement } = store.getState();
    if (!contentElement) return;
    const onFocus = () => {
      focusedRef.current = true;
    };
    contentElement.addEventListener("focusin", onFocus, true);
    return () => contentElement.removeEventListener("focusin", onFocus, true);
  }, [store, open, domReady]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!open) return;
    const onEvent = (event) => {
      const { contentElement, disclosureElement } = store.getState();
      const target = event.target;
      if (!contentElement) return;
      if (!target) return;
      if (!isInDocument(target)) return;
      if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.contains)(contentElement, target)) return;
      if (isDisclosure(disclosureElement, target)) return;
      if (target.hasAttribute("data-focus-trap")) return;
      if (isMouseEventOnDialog(event, contentElement)) return;
      const focused = focusedRef.current;
      if (focused && !(0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_4__.isElementMarked)(target, contentElement.id)) return;
      if ((0,_OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_5__.isSafariFocusAncestor)(target)) return;
      callListener(event);
    };
    return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_6__.addGlobalEventListener)(type, onEvent, capture);
  }, [open, capture]);
}
function shouldHideOnInteractOutside(hideOnInteractOutside, event) {
  if (typeof hideOnInteractOutside === "function") {
    return hideOnInteractOutside(event);
  }
  return !!hideOnInteractOutside;
}
function useHideOnInteractOutside(store, hideOnInteractOutside, domReady) {
  const open = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_3__.useStoreState)(store, "open");
  const previousMouseDownRef = (0,_HLTQOHKZ_js__WEBPACK_IMPORTED_MODULE_7__.usePreviousMouseDownRef)(open);
  const props = { store, domReady, capture: true };
  useEventOutside((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadValues)({}, props), {
    type: "click",
    listener: (event) => {
      const { contentElement } = store.getState();
      const previousMouseDown = previousMouseDownRef.current;
      if (!previousMouseDown) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.isVisible)(previousMouseDown)) return;
      if (!(0,_3NDVDEB4_js__WEBPACK_IMPORTED_MODULE_4__.isElementMarked)(previousMouseDown, contentElement == null ? void 0 : contentElement.id)) return;
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  }));
  useEventOutside((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadValues)({}, props), {
    type: "focusin",
    listener: (event) => {
      const { contentElement } = store.getState();
      if (!contentElement) return;
      if (event.target === (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_1__.getDocument)(contentElement)) return;
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  }));
  useEventOutside((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_8__.__spreadValues)({}, props), {
    type: "contextmenu",
    listener: (event) => {
      if (!shouldHideOnInteractOutside(hideOnInteractOutside, event)) return;
      store.hide();
    }
  }));
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assignStyle: () => (/* binding */ assignStyle),
/* harmony export */   orchestrate: () => (/* binding */ orchestrate),
/* harmony export */   setAttribute: () => (/* binding */ setAttribute),
/* harmony export */   setCSSProperty: () => (/* binding */ setCSSProperty),
/* harmony export */   setProperty: () => (/* binding */ setProperty)
/* harmony export */ });
"use client";

// src/dialog/utils/orchestrate.ts
var cleanups = /* @__PURE__ */ new WeakMap();
function orchestrate(element, key, setup) {
  if (!cleanups.has(element)) {
    cleanups.set(element, /* @__PURE__ */ new Map());
  }
  const elementCleanups = cleanups.get(element);
  const prevCleanup = elementCleanups.get(key);
  if (!prevCleanup) {
    elementCleanups.set(key, setup());
    return () => {
      var _a;
      (_a = elementCleanups.get(key)) == null ? void 0 : _a();
      elementCleanups.delete(key);
    };
  }
  const cleanup = setup();
  const nextCleanup = () => {
    cleanup();
    prevCleanup();
    elementCleanups.delete(key);
  };
  elementCleanups.set(key, nextCleanup);
  return () => {
    const isCurrent = elementCleanups.get(key) === nextCleanup;
    if (!isCurrent) return;
    cleanup();
    elementCleanups.set(key, prevCleanup);
  };
}
function setAttribute(element, attr, value) {
  const setup = () => {
    const previousValue = element.getAttribute(attr);
    element.setAttribute(attr, value);
    return () => {
      if (previousValue == null) {
        element.removeAttribute(attr);
      } else {
        element.setAttribute(attr, previousValue);
      }
    };
  };
  return orchestrate(element, attr, setup);
}
function setProperty(element, property, value) {
  const setup = () => {
    const exists = property in element;
    const previousValue = element[property];
    element[property] = value;
    return () => {
      if (!exists) {
        delete element[property];
      } else {
        element[property] = previousValue;
      }
    };
  };
  return orchestrate(element, property, setup);
}
function assignStyle(element, style) {
  if (!element) return () => {
  };
  const setup = () => {
    const prevStyle = element.style.cssText;
    Object.assign(element.style, style);
    return () => {
      element.style.cssText = prevStyle;
    };
  };
  return orchestrate(element, "style", setup);
}
function setCSSProperty(element, property, value) {
  if (!element) return () => {
  };
  const setup = () => {
    const previousValue = element.style.getPropertyValue(property);
    element.style.setProperty(property, value);
    return () => {
      if (previousValue) {
        element.style.setProperty(property, previousValue);
      } else {
        element.style.removeProperty(property);
      }
    };
  };
  return orchestrate(element, property, setup);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K4R5DNTX.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K4R5DNTX.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DisclosureContent: () => (/* binding */ DisclosureContent),
/* harmony export */   isHidden: () => (/* binding */ isHidden),
/* harmony export */   useDisclosureContent: () => (/* binding */ useDisclosureContent)
/* harmony export */ });
/* harmony import */ var _T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./T2AZQXQU.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T2AZQXQU.js");
/* harmony import */ var _ABN76PSX_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ABN76PSX.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/ABN76PSX.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";







// src/disclosure/disclosure-content.tsx




var TagName = "div";
function afterTimeout(timeoutMs, cb) {
  const timeoutId = setTimeout(cb, timeoutMs);
  return () => clearTimeout(timeoutId);
}
function afterPaint(cb) {
  let raf = requestAnimationFrame(() => {
    raf = requestAnimationFrame(cb);
  });
  return () => cancelAnimationFrame(raf);
}
function parseCSSTime(...times) {
  return times.join(", ").split(", ").reduce((longestTime, currentTimeString) => {
    const multiplier = currentTimeString.endsWith("ms") ? 1 : 1e3;
    const currentTime = Number.parseFloat(currentTimeString || "0s") * multiplier;
    if (currentTime > longestTime) return currentTime;
    return longestTime;
  }, 0);
}
function isHidden(mounted, hidden, alwaysVisible) {
  return !alwaysVisible && hidden !== false && (!mounted || !!hidden);
}
var useDisclosureContent = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.createHook)(function useDisclosureContent2(_a) {
  var _b = _a, { store, alwaysVisible } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__objRest)(_b, ["store", "alwaysVisible"]);
  const context = (0,_ABN76PSX_js__WEBPACK_IMPORTED_MODULE_5__.useDisclosureProviderContext)();
  store = store || context;
  (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.invariant)(
    store,
     true && "DisclosureContent must receive a `store` prop or be wrapped in a DisclosureProvider component."
  );
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const id = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useId)(props.id);
  const [transition, setTransition] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const open = store.useState("open");
  const mounted = store.useState("mounted");
  const animated = store.useState("animated");
  const contentElement = store.useState("contentElement");
  const otherElement = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_8__.useStoreState)(store.disclosure, "contentElement");
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
    if (!ref.current) return;
    store == null ? void 0 : store.setContentElement(ref.current);
  }, [store]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
    let previousAnimated;
    store == null ? void 0 : store.setState("animated", (animated2) => {
      previousAnimated = animated2;
      return true;
    });
    return () => {
      if (previousAnimated === void 0) return;
      store == null ? void 0 : store.setState("animated", previousAnimated);
    };
  }, [store]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
    if (!animated) return;
    if (!(contentElement == null ? void 0 : contentElement.isConnected)) {
      setTransition(null);
      return;
    }
    return afterPaint(() => {
      setTransition(open ? "enter" : mounted ? "leave" : null);
    });
  }, [animated, contentElement, open, mounted]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useSafeLayoutEffect)(() => {
    if (!store) return;
    if (!animated) return;
    if (!transition) return;
    if (!contentElement) return;
    const stopAnimation = () => store == null ? void 0 : store.setState("animating", false);
    const stopAnimationSync = () => (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(stopAnimation);
    if (transition === "leave" && open) return;
    if (transition === "enter" && !open) return;
    if (typeof animated === "number") {
      const timeout2 = animated;
      return afterTimeout(timeout2, stopAnimationSync);
    }
    const {
      transitionDuration,
      animationDuration,
      transitionDelay,
      animationDelay
    } = getComputedStyle(contentElement);
    const {
      transitionDuration: transitionDuration2 = "0",
      animationDuration: animationDuration2 = "0",
      transitionDelay: transitionDelay2 = "0",
      animationDelay: animationDelay2 = "0"
    } = otherElement ? getComputedStyle(otherElement) : {};
    const delay = parseCSSTime(
      transitionDelay,
      animationDelay,
      transitionDelay2,
      animationDelay2
    );
    const duration = parseCSSTime(
      transitionDuration,
      animationDuration,
      transitionDuration2,
      animationDuration2
    );
    const timeout = delay + duration;
    if (!timeout) {
      if (transition === "enter") {
        store.setState("animated", false);
      }
      stopAnimation();
      return;
    }
    const frameRate = 1e3 / 60;
    const maxTimeout = Math.max(timeout - frameRate, 0);
    return afterTimeout(maxTimeout, stopAnimationSync);
  }, [store, animated, contentElement, otherElement, open, transition]);
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_9__.DialogScopedContextProvider, { value: store, children: element }),
    [store]
  );
  const hidden = isHidden(mounted, props.hidden, alwaysVisible);
  const styleProp = props.style;
  const style = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    if (hidden) {
      return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, styleProp), { display: "none" });
    }
    return styleProp;
  }, [hidden, styleProp]);
  props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({
    id,
    "data-open": open || void 0,
    "data-enter": transition === "enter" || void 0,
    "data-leave": transition === "leave" || void 0,
    hidden
  }, props), {
    ref: (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_7__.useMergeRefs)(id ? store.setContentElement : null, ref, props.ref),
    style
  });
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.removeUndefinedValues)(props);
});
var DisclosureContentImpl = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function DisclosureContentImpl2(props) {
  const htmlProps = useDisclosureContent(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.createElement)(TagName, htmlProps);
});
var DisclosureContent = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function DisclosureContent2(_a) {
  var _b = _a, {
    unmountOnHide
  } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__objRest)(_b, [
    "unmountOnHide"
  ]);
  const context = (0,_ABN76PSX_js__WEBPACK_IMPORTED_MODULE_5__.useDisclosureProviderContext)();
  const store = props.store || context;
  const mounted = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_8__.useStoreState)(
    store,
    (state) => !unmountOnHide || (state == null ? void 0 : state.mounted)
  );
  if (mounted === false) return null;
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(DisclosureContentImpl, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, props));
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/L3J7PHFC.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/L3J7PHFC.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TooltipContextProvider: () => (/* binding */ TooltipContextProvider),
/* harmony export */   TooltipScopedContextProvider: () => (/* binding */ TooltipScopedContextProvider),
/* harmony export */   useTooltipContext: () => (/* binding */ useTooltipContext),
/* harmony export */   useTooltipProviderContext: () => (/* binding */ useTooltipProviderContext),
/* harmony export */   useTooltipScopedContext: () => (/* binding */ useTooltipScopedContext)
/* harmony export */ });
/* harmony import */ var _7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./7Z7JH52O.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/7Z7JH52O.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
"use client";



// src/tooltip/tooltip-context.tsx
var ctx = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createStoreContext)(
  [_7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_1__.HovercardContextProvider],
  [_7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_1__.HovercardScopedContextProvider]
);
var useTooltipContext = ctx.useContext;
var useTooltipScopedContext = ctx.useScopedContext;
var useTooltipProviderContext = ctx.useProviderContext;
var TooltipContextProvider = ctx.ContextProvider;
var TooltipScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/LC6GJMGV.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/LC6GJMGV.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusableContainer: () => (/* binding */ FocusableContainer),
/* harmony export */   useFocusableContainer: () => (/* binding */ useFocusableContainer)
/* harmony export */ });
/* harmony import */ var _SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SWN3JYXT.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";





// src/focusable/focusable-container.tsx

var TagName = "div";
var useFocusableContainer = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(function useFocusableContainer2(_a) {
  var _b = _a, { autoFocusOnShow = true } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__objRest)(_b, ["autoFocusOnShow"]);
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__.useWrapElement)(
    props,
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_4__.FocusableContext.Provider, { value: autoFocusOnShow, children: element }),
    [autoFocusOnShow]
  );
  return props;
});
var FocusableContainer = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function FocusableContainer2(props) {
  const htmlProps = useFocusableContainer(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/M5DFOEFU.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/M5DFOEFU.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Portal: () => (/* binding */ Portal),
/* harmony export */   usePortal: () => (/* binding */ usePortal)
/* harmony export */ });
/* harmony import */ var _AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AOQQTIBO.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOQQTIBO.js");
/* harmony import */ var _S2F2XXEH_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./S2F2XXEH.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S2F2XXEH.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./SK3NAZA3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SK3NAZA3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";







// src/portal/portal.tsx






var TagName = "div";
function getRootElement(element) {
  return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(element).body;
}
function getPortalElement(element, portalElement) {
  if (!portalElement) {
    return (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(element).createElement("div");
  }
  if (typeof portalElement === "function") {
    return portalElement(element);
  }
  return portalElement;
}
function getRandomId(prefix = "id") {
  return `${prefix ? `${prefix}-` : ""}${Math.random().toString(36).slice(2, 8)}`;
}
function queueFocus(element) {
  queueMicrotask(() => {
    element == null ? void 0 : element.focus();
  });
}
var usePortal = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_4__.createHook)(function usePortal2(_a) {
  var _b = _a, {
    preserveTabOrder,
    preserveTabOrderAnchor,
    portalElement,
    portalRef,
    portal = true
  } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_5__.__objRest)(_b, [
    "preserveTabOrder",
    "preserveTabOrderAnchor",
    "portalElement",
    "portalRef",
    "portal"
  ]);
  const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const refProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useMergeRefs)(ref, props.ref);
  const context = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_7__.PortalContext);
  const [portalNode, setPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const [anchorPortalNode, setAnchorPortalNode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(
    null
  );
  const outerBeforeRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const innerBeforeRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const innerAfterRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  const outerAfterRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useSafeLayoutEffect)(() => {
    const element = ref.current;
    if (!element || !portal) {
      setPortalNode(null);
      return;
    }
    const portalEl = getPortalElement(element, portalElement);
    if (!portalEl) {
      setPortalNode(null);
      return;
    }
    const isPortalInDocument = portalEl.isConnected;
    if (!isPortalInDocument) {
      const rootElement = context || getRootElement(element);
      rootElement.appendChild(portalEl);
    }
    if (!portalEl.id) {
      portalEl.id = element.id ? `portal/${element.id}` : getRandomId();
    }
    setPortalNode(portalEl);
    (0,_SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_8__.setRef)(portalRef, portalEl);
    if (isPortalInDocument) return;
    return () => {
      portalEl.remove();
      (0,_SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_8__.setRef)(portalRef, null);
    };
  }, [portal, portalElement, context, portalRef]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useSafeLayoutEffect)(() => {
    if (!portal) return;
    if (!preserveTabOrder) return;
    if (!preserveTabOrderAnchor) return;
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(preserveTabOrderAnchor);
    const element = doc.createElement("span");
    element.style.position = "fixed";
    preserveTabOrderAnchor.insertAdjacentElement("afterend", element);
    setAnchorPortalNode(element);
    return () => {
      element.remove();
      setAnchorPortalNode(null);
    };
  }, [portal, preserveTabOrder, preserveTabOrderAnchor]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!portalNode) return;
    if (!preserveTabOrder) return;
    let raf = 0;
    const onFocus = (event) => {
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__.isFocusEventOutside)(event)) return;
      const focusing = event.type === "focusin";
      cancelAnimationFrame(raf);
      if (focusing) {
        return (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.restoreFocusIn)(portalNode);
      }
      raf = requestAnimationFrame(() => {
        (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.disableFocusIn)(portalNode, true);
      });
    };
    portalNode.addEventListener("focusin", onFocus, true);
    portalNode.addEventListener("focusout", onFocus, true);
    return () => {
      cancelAnimationFrame(raf);
      portalNode.removeEventListener("focusin", onFocus, true);
      portalNode.removeEventListener("focusout", onFocus, true);
    };
  }, [portalNode, preserveTabOrder]);
  props = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useWrapElement)(
    props,
    (element) => {
      element = // While the portal node is not in the DOM, we need to pass the
      // current context to the portal context, otherwise it's going to
      // reset to the body element on nested portals.
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_AOQQTIBO_js__WEBPACK_IMPORTED_MODULE_7__.PortalContext.Provider, { value: portalNode || context, children: element });
      if (!portal) return element;
      if (!portalNode) {
        return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(
          "span",
          {
            ref: refProp,
            id: props.id,
            style: { position: "fixed" },
            hidden: true
          }
        );
      }
      element = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, { children: [
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(
          _S2F2XXEH_js__WEBPACK_IMPORTED_MODULE_11__.FocusTrap,
          {
            ref: innerBeforeRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-inner-before",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__.isFocusEventOutside)(event, portalNode)) {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.getNextTabbable)());
              } else {
                queueFocus(outerBeforeRef.current);
              }
            }
          }
        ),
        element,
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(
          _S2F2XXEH_js__WEBPACK_IMPORTED_MODULE_11__.FocusTrap,
          {
            ref: innerAfterRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-inner-after",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__.isFocusEventOutside)(event, portalNode)) {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.getPreviousTabbable)());
              } else {
                queueFocus(outerAfterRef.current);
              }
            }
          }
        )
      ] });
      if (portalNode) {
        element = (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(element, portalNode);
      }
      let preserveTabOrderElement = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, { children: [
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(
          _S2F2XXEH_js__WEBPACK_IMPORTED_MODULE_11__.FocusTrap,
          {
            ref: outerBeforeRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-outer-before",
            onFocus: (event) => {
              const fromOuter = event.relatedTarget === outerAfterRef.current;
              if (!fromOuter && (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__.isFocusEventOutside)(event, portalNode)) {
                queueFocus(innerBeforeRef.current);
              } else {
                queueFocus((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.getPreviousTabbable)());
              }
            }
          }
        ),
        preserveTabOrder && // We're using position: fixed here so that the browser doesn't
        // add margin to the element when setting gap on a parent element.
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", { "aria-owns": portalNode == null ? void 0 : portalNode.id, style: { position: "fixed" } }),
        preserveTabOrder && portalNode && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(
          _S2F2XXEH_js__WEBPACK_IMPORTED_MODULE_11__.FocusTrap,
          {
            ref: outerAfterRef,
            "data-focus-trap": props.id,
            className: "__focus-trap-outer-after",
            onFocus: (event) => {
              if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_9__.isFocusEventOutside)(event, portalNode)) {
                queueFocus(innerAfterRef.current);
              } else {
                const nextTabbable = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.getNextTabbable)();
                if (nextTabbable === innerBeforeRef.current) {
                  requestAnimationFrame(() => {
                    var _a2;
                    return (_a2 = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_10__.getNextTabbable)()) == null ? void 0 : _a2.focus();
                  });
                  return;
                }
                queueFocus(nextTabbable);
              }
            }
          }
        )
      ] });
      if (anchorPortalNode && preserveTabOrder) {
        preserveTabOrderElement = (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.createPortal)(
          preserveTabOrderElement,
          anchorPortalNode
        );
      }
      return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, { children: [
        preserveTabOrderElement,
        element
      ] });
    },
    [portalNode, context, portal, props.id, preserveTabOrder, anchorPortalNode]
  );
  props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_5__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_5__.__spreadValues)({}, props), {
    ref: refProp
  });
  return props;
});
var Portal = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_4__.forwardRef)(function Portal2(props) {
  const htmlProps = usePortal(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_4__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/OE2EFRVA.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/OE2EFRVA.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Focusable: () => (/* binding */ Focusable),
/* harmony export */   isSafariFocusAncestor: () => (/* binding */ isSafariFocusAncestor),
/* harmony export */   useFocusable: () => (/* binding */ useFocusable)
/* harmony export */ });
/* harmony import */ var _SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./SWN3JYXT.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";





// src/focusable/focusable.tsx






var TagName = "div";
var isSafariBrowser = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_1__.isSafari)();
var alwaysFocusVisibleInputTypes = [
  "text",
  "search",
  "url",
  "tel",
  "email",
  "password",
  "number",
  "date",
  "month",
  "week",
  "time",
  "datetime",
  "datetime-local"
];
var safariFocusAncestorSymbol = Symbol("safariFocusAncestor");
function isSafariFocusAncestor(element) {
  if (!element) return false;
  return !!element[safariFocusAncestorSymbol];
}
function markSafariFocusAncestor(element, value) {
  if (!element) return;
  element[safariFocusAncestorSymbol] = value;
}
function isAlwaysFocusVisible(element) {
  const { tagName, readOnly, type } = element;
  if (tagName === "TEXTAREA" && !readOnly) return true;
  if (tagName === "SELECT" && !readOnly) return true;
  if (tagName === "INPUT" && !readOnly) {
    return alwaysFocusVisibleInputTypes.includes(type);
  }
  if (element.isContentEditable) return true;
  const role = element.getAttribute("role");
  if (role === "combobox" && element.dataset.name) {
    return true;
  }
  return false;
}
function getLabels(element) {
  if ("labels" in element) {
    return element.labels;
  }
  return null;
}
function isNativeCheckboxOrRadio(element) {
  const tagName = element.tagName.toLowerCase();
  if (tagName === "input" && element.type) {
    return element.type === "radio" || element.type === "checkbox";
  }
  return false;
}
function isNativeTabbable(tagName) {
  if (!tagName) return true;
  return tagName === "button" || tagName === "summary" || tagName === "input" || tagName === "select" || tagName === "textarea" || tagName === "a";
}
function supportsDisabledAttribute(tagName) {
  if (!tagName) return true;
  return tagName === "button" || tagName === "input" || tagName === "select" || tagName === "textarea";
}
function getTabIndex(focusable, trulyDisabled, nativeTabbable, supportsDisabled, tabIndexProp) {
  if (!focusable) {
    return tabIndexProp;
  }
  if (trulyDisabled) {
    if (nativeTabbable && !supportsDisabled) {
      return -1;
    }
    return;
  }
  if (nativeTabbable) {
    return tabIndexProp;
  }
  return tabIndexProp || 0;
}
function useDisableEvent(onEvent, disabled) {
  return (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
    onEvent == null ? void 0 : onEvent(event);
    if (event.defaultPrevented) return;
    if (disabled) {
      event.stopPropagation();
      event.preventDefault();
    }
  });
}
var hasInstalledGlobalEventListeners = false;
var isKeyboardModality = true;
function onGlobalMouseDown(event) {
  const target = event.target;
  if (target && "hasAttribute" in target) {
    if (!target.hasAttribute("data-focus-visible")) {
      isKeyboardModality = false;
    }
  }
}
function onGlobalKeyDown(event) {
  if (event.metaKey) return;
  if (event.ctrlKey) return;
  if (event.altKey) return;
  isKeyboardModality = true;
}
var useFocusable = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.createHook)(
  function useFocusable2(_a) {
    var _b = _a, {
      focusable = true,
      accessibleWhenDisabled,
      autoFocus,
      onFocusVisible
    } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__objRest)(_b, [
      "focusable",
      "accessibleWhenDisabled",
      "autoFocus",
      "onFocusVisible"
    ]);
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!focusable) return;
      if (hasInstalledGlobalEventListeners) return;
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.addGlobalEventListener)("mousedown", onGlobalMouseDown, true);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.addGlobalEventListener)("keydown", onGlobalKeyDown, true);
      hasInstalledGlobalEventListeners = true;
    }, [focusable]);
    if (isSafariBrowser) {
      (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (!focusable) return;
        const element = ref.current;
        if (!element) return;
        if (!isNativeCheckboxOrRadio(element)) return;
        const labels = getLabels(element);
        if (!labels) return;
        const onMouseUp = () => queueMicrotask(() => element.focus());
        for (const label of labels) {
          label.addEventListener("mouseup", onMouseUp);
        }
        return () => {
          for (const label of labels) {
            label.removeEventListener("mouseup", onMouseUp);
          }
        };
      }, [focusable]);
    }
    const disabled = focusable && (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.disabledFromProps)(props);
    const trulyDisabled = !!disabled && !accessibleWhenDisabled;
    const [focusVisible, setFocusVisible] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!focusable) return;
      if (trulyDisabled && focusVisible) {
        setFocusVisible(false);
      }
    }, [focusable, trulyDisabled, focusVisible]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!focusable) return;
      if (!focusVisible) return;
      const element = ref.current;
      if (!element) return;
      if (typeof IntersectionObserver === "undefined") return;
      const observer = new IntersectionObserver(() => {
        if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.isFocusable)(element)) {
          setFocusVisible(false);
        }
      });
      observer.observe(element);
      return () => observer.disconnect();
    }, [focusable, focusVisible]);
    const onKeyPressCapture = useDisableEvent(
      props.onKeyPressCapture,
      disabled
    );
    const onMouseDownCapture = useDisableEvent(
      props.onMouseDownCapture,
      disabled
    );
    const onClickCapture = useDisableEvent(props.onClickCapture, disabled);
    const onMouseDownProp = props.onMouseDown;
    const onMouseDown = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onMouseDownProp == null ? void 0 : onMouseDownProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      const element = event.currentTarget;
      if (!isSafariBrowser) return;
      if ((0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.isPortalEvent)(event)) return;
      if (!(0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_8__.isButton)(element) && !isNativeCheckboxOrRadio(element)) return;
      let receivedFocus = false;
      const onFocus = () => {
        receivedFocus = true;
      };
      const options = { capture: true, once: true };
      element.addEventListener("focusin", onFocus, options);
      const focusableContainer = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.getClosestFocusable)(element.parentElement);
      markSafariFocusAncestor(focusableContainer, true);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.queueBeforeEvent)(element, "mouseup", () => {
        element.removeEventListener("focusin", onFocus, true);
        markSafariFocusAncestor(focusableContainer, false);
        if (receivedFocus) return;
        (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.focusIfNeeded)(element);
      });
    });
    const handleFocusVisible = (event, currentTarget) => {
      if (currentTarget) {
        event.currentTarget = currentTarget;
      }
      if (!focusable) return;
      const element = event.currentTarget;
      if (!element) return;
      if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.hasFocus)(element)) return;
      onFocusVisible == null ? void 0 : onFocusVisible(event);
      if (event.defaultPrevented) return;
      element.dataset.focusVisible = "true";
      setFocusVisible(true);
    };
    const onKeyDownCaptureProp = props.onKeyDownCapture;
    const onKeyDownCapture = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onKeyDownCaptureProp == null ? void 0 : onKeyDownCaptureProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      if (focusVisible) return;
      if (event.metaKey) return;
      if (event.altKey) return;
      if (event.ctrlKey) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.isSelfTarget)(event)) return;
      const element = event.currentTarget;
      const applyFocusVisible = () => handleFocusVisible(event, element);
      (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.queueBeforeEvent)(element, "focusout", applyFocusVisible);
    });
    const onFocusCaptureProp = props.onFocusCapture;
    const onFocusCapture = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onFocusCaptureProp == null ? void 0 : onFocusCaptureProp(event);
      if (event.defaultPrevented) return;
      if (!focusable) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.isSelfTarget)(event)) {
        setFocusVisible(false);
        return;
      }
      const element = event.currentTarget;
      const applyFocusVisible = () => handleFocusVisible(event, element);
      if (isKeyboardModality || isAlwaysFocusVisible(event.target)) {
        (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.queueBeforeEvent)(event.target, "focusout", applyFocusVisible);
      } else {
        setFocusVisible(false);
      }
    });
    const onBlurProp = props.onBlur;
    const onBlur = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((event) => {
      onBlurProp == null ? void 0 : onBlurProp(event);
      if (!focusable) return;
      if (!(0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.isFocusEventOutside)(event)) return;
      event.currentTarget.removeAttribute("data-focus-visible");
      setFocusVisible(false);
    });
    const autoFocusOnShow = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_SWN3JYXT_js__WEBPACK_IMPORTED_MODULE_9__.FocusableContext);
    const autoFocusRef = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useEvent)((element) => {
      if (!focusable) return;
      if (!autoFocus) return;
      if (!element) return;
      if (!autoFocusOnShow) return;
      queueMicrotask(() => {
        if ((0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.hasFocus)(element)) return;
        if (!(0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_7__.isFocusable)(element)) return;
        element.focus();
      });
    });
    const tagName = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useTagName)(ref);
    const nativeTabbable = focusable && isNativeTabbable(tagName);
    const supportsDisabled = focusable && supportsDisabledAttribute(tagName);
    const styleProp = props.style;
    const style = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
      if (trulyDisabled) {
        return (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({ pointerEvents: "none" }, styleProp);
      }
      return styleProp;
    }, [trulyDisabled, styleProp]);
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({
      "data-focus-visible": focusable && focusVisible || void 0,
      "data-autofocus": autoFocus || void 0,
      "aria-disabled": disabled || void 0
    }, props), {
      ref: (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useMergeRefs)(ref, autoFocusRef, props.ref),
      style,
      tabIndex: getTabIndex(
        focusable,
        trulyDisabled,
        nativeTabbable,
        supportsDisabled,
        props.tabIndex
      ),
      disabled: supportsDisabled && trulyDisabled ? true : void 0,
      // TODO: Test Focusable contentEditable.
      contentEditable: disabled ? void 0 : props.contentEditable,
      onKeyPressCapture,
      onClickCapture,
      onMouseDownCapture,
      onMouseDown,
      onKeyDownCapture,
      onFocusCapture,
      onBlur
    });
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_6__.removeUndefinedValues)(props);
  }
);
var Focusable = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(function Focusable2(props) {
  const htmlProps = useFocusable(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_3__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/PVECYOSC.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/PVECYOSC.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useNestedDialogs: () => (/* binding */ useNestedDialogs)
/* harmony export */ });
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";


// src/dialog/utils/use-nested-dialogs.tsx




var NestedDialogsContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
function useNestedDialogs(store) {
  const context = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(NestedDialogsContext);
  const [dialogs, setDialogs] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
  const add = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
    (dialog) => {
      var _a;
      setDialogs((dialogs2) => [...dialogs2, dialog]);
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.chain)((_a = context.add) == null ? void 0 : _a.call(context, dialog), () => {
        setDialogs((dialogs2) => dialogs2.filter((d) => d !== dialog));
      });
    },
    [context]
  );
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__.useSafeLayoutEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_4__.sync)(store, ["open", "contentElement"], (state) => {
      var _a;
      if (!state.open) return;
      if (!state.contentElement) return;
      return (_a = context.add) == null ? void 0 : _a.call(context, store);
    });
  }, [store, context]);
  const providerValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => ({ store, add }), [store, add]);
  const wrapElement = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
    (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(NestedDialogsContext.Provider, { value: providerValue, children: element }),
    [providerValue]
  );
  return { wrapElement, nestedDialogs: dialogs };
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/QJ4LGO2N.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/QJ4LGO2N.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Role: () => (/* binding */ Role),
/* harmony export */   useRole: () => (/* binding */ useRole)
/* harmony export */ });
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
"use client";


// src/role/role.tsx
var TagName = "div";
var elements = [
  "a",
  "button",
  "details",
  "dialog",
  "div",
  "form",
  "h1",
  "h2",
  "h3",
  "h4",
  "h5",
  "h6",
  "header",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "section",
  "select",
  "span",
  "summary",
  "textarea",
  "ul",
  "svg"
];
var useRole = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createHook)(
  function useRole2(props) {
    return props;
  }
);
var Role = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(
  // @ts-expect-error
  function Role2(props) {
    return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(TagName, props);
  }
);
Object.assign(
  Role,
  elements.reduce((acc, element) => {
    acc[element] = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function Role3(props) {
      return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(element, props);
    });
    return acc;
  }, {})
);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useStore: () => (/* binding */ useStore),
/* harmony export */   useStoreProps: () => (/* binding */ useStoreProps),
/* harmony export */   useStoreState: () => (/* binding */ useStoreState),
/* harmony export */   useStoreStateObject: () => (/* binding */ useStoreStateObject)
/* harmony export */ });
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var use_sync_external_store_shim_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-sync-external-store/shim/index.js */ "./node_modules/.pnpm/use-sync-external-store@1.5.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js");
"use client";



// src/utils/store.tsx




var { useSyncExternalStore } = use_sync_external_store_shim_index_js__WEBPACK_IMPORTED_MODULE_1__;
var noopSubscribe = () => () => {
};
function useStoreState(store, keyOrSelector = _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.identity) {
  const storeSubscribe = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__.subscribe)(store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const key = typeof keyOrSelector === "string" ? keyOrSelector : null;
    const selector = typeof keyOrSelector === "function" ? keyOrSelector : null;
    const state = store == null ? void 0 : store.getState();
    if (selector) return selector(state);
    if (!state) return;
    if (!key) return;
    if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.hasOwnProperty)(state, key)) return;
    return state[key];
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreStateObject(store, object) {
  const objRef = react__WEBPACK_IMPORTED_MODULE_0__.useRef(
    {}
  );
  const storeSubscribe = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (callback) => {
      if (!store) return noopSubscribe();
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__.subscribe)(store, null, callback);
    },
    [store]
  );
  const getSnapshot = () => {
    const state = store == null ? void 0 : store.getState();
    let updated = false;
    const obj = objRef.current;
    for (const prop in object) {
      const keyOrSelector = object[prop];
      if (typeof keyOrSelector === "function") {
        const value = keyOrSelector(state);
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
      if (typeof keyOrSelector === "string") {
        if (!state) continue;
        if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.hasOwnProperty)(state, keyOrSelector)) continue;
        const value = state[keyOrSelector];
        if (value !== obj[prop]) {
          obj[prop] = value;
          updated = true;
        }
      }
    }
    if (updated) {
      objRef.current = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, obj);
    }
    return objRef.current;
  };
  return useSyncExternalStore(storeSubscribe, getSnapshot, getSnapshot);
}
function useStoreProps(store, props, key, setKey) {
  const value = (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.hasOwnProperty)(props, key) ? props[key] : void 0;
  const setValue = setKey ? props[setKey] : void 0;
  const propsRef = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useLiveRef)({ value, setValue });
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => {
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__.sync)(store, [key], (state, prev) => {
      const { value: value2, setValue: setValue2 } = propsRef.current;
      if (!setValue2) return;
      if (state[key] === prev[key]) return;
      if (state[key] === value2) return;
      setValue2(state[key]);
    });
  }, [store, key]);
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => {
    if (value === void 0) return;
    store.setState(key, value);
    return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__.batch)(store, [key], () => {
      if (value === void 0) return;
      store.setState(key, value);
    });
  });
}
function useStore(createStore, props) {
  const [store, setStore] = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => createStore(props));
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useSafeLayoutEffect)(() => (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_3__.init)(store), [store]);
  const useState2 = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(
    (keyOrSelector) => useStoreState(store, keyOrSelector),
    [store]
  );
  const memoizedStore = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(
    () => (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, store), { useState: useState2 }),
    [store, useState2]
  );
  const updateStore = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useEvent)(() => {
    setStore((store2) => createStore((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_4__.__spreadValues)({}, props), store2.getState())));
  });
  return [memoizedStore, updateStore];
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RUY5BUJG.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RUY5BUJG.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePopoverStore: () => (/* binding */ usePopoverStore),
/* harmony export */   usePopoverStoreProps: () => (/* binding */ usePopoverStoreProps)
/* harmony export */ });
/* harmony import */ var _Y2U4BRIM_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Y2U4BRIM.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y2U4BRIM.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _ariakit_core_popover_popover_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/popover/popover-store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/ME2CUF3F.js");
"use client";




// src/popover/popover-store.ts

function usePopoverStoreProps(store, update, props) {
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_0__.useUpdateEffect)(update, [props.popover]);
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "placement");
  return (0,_Y2U4BRIM_js__WEBPACK_IMPORTED_MODULE_2__.useDialogStoreProps)(store, update, props);
}
function usePopoverStore(props = {}) {
  const [store, update] = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_popover_popover_store__WEBPACK_IMPORTED_MODULE_3__.createPopoverStore, props);
  return usePopoverStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S2F2XXEH.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S2F2XXEH.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusTrap: () => (/* binding */ FocusTrap),
/* harmony export */   useFocusTrap: () => (/* binding */ useFocusTrap)
/* harmony export */ });
/* harmony import */ var _DXGKYUAD_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DXGKYUAD.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/DXGKYUAD.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
"use client";




// src/focus-trap/focus-trap.tsx
var TagName = "span";
var useFocusTrap = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createHook)(
  function useFocusTrap2(props) {
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({
      "data-focus-trap": "",
      tabIndex: 0,
      "aria-hidden": true
    }, props), {
      style: (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({
        // Prevents unintended scroll jumps.
        position: "fixed",
        top: 0,
        left: 0
      }, props.style)
    });
    props = (0,_DXGKYUAD_js__WEBPACK_IMPORTED_MODULE_2__.useVisuallyHidden)(props);
    return props;
  }
);
var FocusTrap = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function FocusTrap2(props) {
  const htmlProps = useFocusTrap(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableAccessibilityTreeOutside: () => (/* binding */ disableAccessibilityTreeOutside),
/* harmony export */   hideElementFromAccessibilityTree: () => (/* binding */ hideElementFromAccessibilityTree)
/* harmony export */ });
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
"use client";




// src/dialog/utils/disable-accessibility-tree-outside.ts
function hideElementFromAccessibilityTree(element) {
  return (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_0__.setAttribute)(element, "aria-hidden", "true");
}
function disableAccessibilityTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_1__.walkTreeOutside)(id, elements, (element) => {
    if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_2__.isBackdrop)(element, ...ids)) return;
    cleanups.unshift(hideElementFromAccessibilityTree(element));
  });
  const restoreAccessibilityTree = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreAccessibilityTree;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SK3NAZA3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SK3NAZA3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRefProperty: () => (/* binding */ getRefProperty),
/* harmony export */   isValidElementWithRef: () => (/* binding */ isValidElementWithRef),
/* harmony export */   mergeProps: () => (/* binding */ mergeProps),
/* harmony export */   setRef: () => (/* binding */ setRef)
/* harmony export */ });
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";


// src/utils/misc.ts


function setRef(ref, value) {
  if (typeof ref === "function") {
    ref(value);
  } else if (ref) {
    ref.current = value;
  }
}
function isValidElementWithRef(element) {
  if (!element) return false;
  if (!(0,react__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(element)) return false;
  if ("ref" in element.props) return true;
  if ("ref" in element) return true;
  return false;
}
function getRefProperty(element) {
  if (!isValidElementWithRef(element)) return null;
  const props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, element.props);
  return props.ref || element.ref;
}
function mergeProps(base, overrides) {
  const props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, base);
  for (const key in overrides) {
    if (!(0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_2__.hasOwnProperty)(overrides, key)) continue;
    if (key === "className") {
      const prop = "className";
      props[prop] = base[prop] ? `${base[prop]} ${overrides[prop]}` : overrides[prop];
      continue;
    }
    if (key === "style") {
      const prop = "style";
      props[prop] = base[prop] ? (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_1__.__spreadValues)({}, base[prop]), overrides[prop]) : overrides[prop];
      continue;
    }
    const overrideValue = overrides[key];
    if (typeof overrideValue === "function" && key.startsWith("on")) {
      const baseValue = base[key];
      if (typeof baseValue === "function") {
        props[key] = (...args) => {
          overrideValue(...args);
          baseValue(...args);
        };
        continue;
      }
    }
    props[key] = overrideValue;
  }
  return props;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SOMPWLIQ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SOMPWLIQ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   usePreventBodyScroll: () => (/* binding */ usePreventBodyScroll)
/* harmony export */ });
/* harmony import */ var _W6WVJJEY_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./W6WVJJEY.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/W6WVJJEY.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/platform */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/QAGXQEUG.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";



// src/dialog/utils/use-prevent-body-scroll.ts




function getPaddingProperty(documentElement) {
  const documentLeft = documentElement.getBoundingClientRect().left;
  const scrollbarX = Math.round(documentLeft) + documentElement.scrollLeft;
  return scrollbarX ? "paddingLeft" : "paddingRight";
}
function usePreventBodyScroll(contentElement, contentId, enabled) {
  const isRootDialog = (0,_W6WVJJEY_js__WEBPACK_IMPORTED_MODULE_1__.useRootDialog)({
    attribute: "data-dialog-prevent-body-scroll",
    contentElement,
    contentId,
    enabled
  });
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!isRootDialog()) return;
    if (!contentElement) return;
    const doc = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocument)(contentElement);
    const win = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(contentElement);
    const { documentElement, body } = doc;
    const cssScrollbarWidth = documentElement.style.getPropertyValue("--scrollbar-width");
    const scrollbarWidth = cssScrollbarWidth ? Number.parseInt(cssScrollbarWidth) : win.innerWidth - documentElement.clientWidth;
    const setScrollbarWidthProperty = () => (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_3__.setCSSProperty)(
      documentElement,
      "--scrollbar-width",
      `${scrollbarWidth}px`
    );
    const paddingProperty = getPaddingProperty(documentElement);
    const setStyle = () => (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_3__.assignStyle)(body, {
      overflow: "hidden",
      [paddingProperty]: `${scrollbarWidth}px`
    });
    const setIOSStyle = () => {
      var _a, _b;
      const { scrollX, scrollY, visualViewport } = win;
      const offsetLeft = (_a = visualViewport == null ? void 0 : visualViewport.offsetLeft) != null ? _a : 0;
      const offsetTop = (_b = visualViewport == null ? void 0 : visualViewport.offsetTop) != null ? _b : 0;
      const restoreStyle = (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_3__.assignStyle)(body, {
        position: "fixed",
        overflow: "hidden",
        top: `${-(scrollY - Math.floor(offsetTop))}px`,
        left: `${-(scrollX - Math.floor(offsetLeft))}px`,
        right: "0",
        [paddingProperty]: `${scrollbarWidth}px`
      });
      return () => {
        restoreStyle();
        if (true) {
          win.scrollTo({ left: scrollX, top: scrollY, behavior: "instant" });
        }
      };
    };
    const isIOS = (0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__.isApple)() && !(0,_ariakit_core_utils_platform__WEBPACK_IMPORTED_MODULE_4__.isMac)();
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.chain)(
      setScrollbarWidthProperty(),
      isIOS ? setIOSStyle() : setStyle()
    );
  }, [isRootDialog, contentElement]);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SWN3JYXT.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FocusableContext: () => (/* binding */ FocusableContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";

// src/focusable/focusable-context.tsx

var FocusableContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(true);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T22PY7TE.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T22PY7TE.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDisclosureStore: () => (/* binding */ useDisclosureStore),
/* harmony export */   useDisclosureStoreProps: () => (/* binding */ useDisclosureStoreProps)
/* harmony export */ });
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _ariakit_core_disclosure_disclosure_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/disclosure/disclosure-store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/RCQ5P4YE.js");
"use client";



// src/disclosure/disclosure-store.ts

function useDisclosureStoreProps(store, update, props) {
  (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_0__.useUpdateEffect)(update, [props.store, props.disclosure]);
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "open", "setOpen");
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "mounted", "setMounted");
  (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStoreProps)(store, props, "animated");
  return Object.assign(store, { disclosure: props.disclosure });
}
function useDisclosureStore(props = {}) {
  const [store, update] = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_disclosure_disclosure_store__WEBPACK_IMPORTED_MODULE_2__.createDisclosureStore, props);
  return useDisclosureStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T2AZQXQU.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T2AZQXQU.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DialogContextProvider: () => (/* binding */ DialogContextProvider),
/* harmony export */   DialogDescriptionContext: () => (/* binding */ DialogDescriptionContext),
/* harmony export */   DialogHeadingContext: () => (/* binding */ DialogHeadingContext),
/* harmony export */   DialogScopedContextProvider: () => (/* binding */ DialogScopedContextProvider),
/* harmony export */   useDialogContext: () => (/* binding */ useDialogContext),
/* harmony export */   useDialogProviderContext: () => (/* binding */ useDialogProviderContext),
/* harmony export */   useDialogScopedContext: () => (/* binding */ useDialogScopedContext)
/* harmony export */ });
/* harmony import */ var _ABN76PSX_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ABN76PSX.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/ABN76PSX.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";



// src/dialog/dialog-context.tsx

var ctx = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createStoreContext)(
  [_ABN76PSX_js__WEBPACK_IMPORTED_MODULE_2__.DisclosureContextProvider],
  [_ABN76PSX_js__WEBPACK_IMPORTED_MODULE_2__.DisclosureScopedContextProvider]
);
var useDialogContext = ctx.useContext;
var useDialogScopedContext = ctx.useScopedContext;
var useDialogProviderContext = ctx.useProviderContext;
var DialogContextProvider = ctx.ContextProvider;
var DialogScopedContextProvider = ctx.ScopedContextProvider;
var DialogHeadingContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0);
var DialogDescriptionContext = (0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)(void 0);




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/TRDK6LYC.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/TRDK6LYC.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HovercardAnchor: () => (/* binding */ HovercardAnchor),
/* harmony export */   useHovercardAnchor: () => (/* binding */ useHovercardAnchor)
/* harmony export */ });
/* harmony import */ var _7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./7Z7JH52O.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/7Z7JH52O.js");
/* harmony import */ var _OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./OE2EFRVA.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/OE2EFRVA.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/events */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/events.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";






// src/hovercard/hovercard-anchor.tsx



var TagName = "a";
var useHovercardAnchor = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(
  function useHovercardAnchor2(_a) {
    var _b = _a, { store, showOnHover = true } = _b, props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__objRest)(_b, ["store", "showOnHover"]);
    const context = (0,_7Z7JH52O_js__WEBPACK_IMPORTED_MODULE_3__.useHovercardProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
      store,
       true && "HovercardAnchor must receive a `store` prop or be wrapped in a HovercardProvider component."
    );
    const disabled = (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.disabledFromProps)(props);
    const showTimeoutRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(0);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => () => window.clearTimeout(showTimeoutRef.current), []);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      const onMouseLeave = (event) => {
        if (!store) return;
        const { anchorElement } = store.getState();
        if (!anchorElement) return;
        if (event.target !== anchorElement) return;
        window.clearTimeout(showTimeoutRef.current);
        showTimeoutRef.current = 0;
      };
      return (0,_ariakit_core_utils_events__WEBPACK_IMPORTED_MODULE_5__.addGlobalEventListener)("mouseleave", onMouseLeave, true);
    }, [store]);
    const onMouseMoveProp = props.onMouseMove;
    const showOnHoverProp = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useBooleanEvent)(showOnHover);
    const isMouseMoving = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useIsMouseMoving)();
    const onMouseMove = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useEvent)((event) => {
      onMouseMoveProp == null ? void 0 : onMouseMoveProp(event);
      if (disabled) return;
      if (!store) return;
      if (event.defaultPrevented) return;
      if (showTimeoutRef.current) return;
      if (!isMouseMoving()) return;
      if (!showOnHoverProp(event)) return;
      const element = event.currentTarget;
      store.setAnchorElement(element);
      store.setDisclosureElement(element);
      const { showTimeout, timeout } = store.getState();
      const showHovercard = () => {
        showTimeoutRef.current = 0;
        if (!isMouseMoving()) return;
        store == null ? void 0 : store.setAnchorElement(element);
        store == null ? void 0 : store.show();
        queueMicrotask(() => {
          store == null ? void 0 : store.setDisclosureElement(element);
        });
      };
      const timeoutMs = showTimeout != null ? showTimeout : timeout;
      if (timeoutMs === 0) {
        showHovercard();
      } else {
        showTimeoutRef.current = window.setTimeout(showHovercard, timeoutMs);
      }
    });
    const onClickProp = props.onClick;
    const onClick = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useEvent)((event) => {
      onClickProp == null ? void 0 : onClickProp(event);
      if (!store) return;
      window.clearTimeout(showTimeoutRef.current);
      showTimeoutRef.current = 0;
    });
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(
      (element) => {
        if (!store) return;
        const { anchorElement } = store.getState();
        if (anchorElement == null ? void 0 : anchorElement.isConnected) return;
        store.setAnchorElement(element);
      },
      [store]
    );
    props = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), {
      ref: (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useMergeRefs)(ref, props.ref),
      onMouseMove,
      onClick
    });
    props = (0,_OE2EFRVA_js__WEBPACK_IMPORTED_MODULE_7__.useFocusable)(props);
    return props;
  }
);
var HovercardAnchor = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function HovercardAnchor2(props) {
  const htmlProps = useHovercardAnchor(props);
  return (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
});




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   createHook: () => (/* binding */ createHook),
/* harmony export */   createStoreContext: () => (/* binding */ createStoreContext),
/* harmony export */   forwardRef: () => (/* binding */ forwardRef2),
/* harmony export */   memo: () => (/* binding */ memo2)
/* harmony export */ });
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SK3NAZA3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/SK3NAZA3.js");
/* harmony import */ var _3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";




// src/utils/system.tsx


function forwardRef2(render) {
  const Role = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef((props, ref) => render((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), { ref })));
  Role.displayName = render.displayName || render.name;
  return Role;
}
function memo2(Component, propsAreEqual) {
  return react__WEBPACK_IMPORTED_MODULE_0__.memo(Component, propsAreEqual);
}
function createElement(Type, props) {
  const _a = props, { wrapElement, render } = _a, rest = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__objRest)(_a, ["wrapElement", "render"]);
  const mergedRef = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_3__.useMergeRefs)(props.ref, (0,_SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_4__.getRefProperty)(render));
  let element;
  if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(render)) {
    const renderProps = (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, render.props), { ref: mergedRef });
    element = react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(render, (0,_SK3NAZA3_js__WEBPACK_IMPORTED_MODULE_4__.mergeProps)(rest, renderProps));
  } else if (render) {
    element = render(rest);
  } else {
    element = /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Type, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, rest));
  }
  if (wrapElement) {
    return wrapElement(element);
  }
  return element;
}
function createHook(useProps) {
  const useRole = (props = {}) => {
    return useProps(props);
  };
  useRole.displayName = useProps.name;
  return useRole;
}
function createStoreContext(providers = [], scopedProviders = []) {
  const context = react__WEBPACK_IMPORTED_MODULE_0__.createContext(void 0);
  const scopedContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext(void 0);
  const useContext2 = () => react__WEBPACK_IMPORTED_MODULE_0__.useContext(context);
  const useScopedContext = (onlyScoped = false) => {
    const scoped = react__WEBPACK_IMPORTED_MODULE_0__.useContext(scopedContext);
    const store = useContext2();
    if (onlyScoped) return scoped;
    return scoped || store;
  };
  const useProviderContext = () => {
    const scoped = react__WEBPACK_IMPORTED_MODULE_0__.useContext(scopedContext);
    const store = useContext2();
    if (scoped && scoped === store) return;
    return store;
  };
  const ContextProvider = (props) => {
    return providers.reduceRight(
      (children, Provider) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Provider, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), { children })),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(context.Provider, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props))
    );
  };
  const ScopedContextProvider = (props) => {
    return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(ContextProvider, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), { children: scopedProviders.reduceRight(
      (children, Provider) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(Provider, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), { children })),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(scopedContext.Provider, (0,_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props))
    ) }));
  };
  return {
    context,
    scopedContext,
    useContext: useContext2,
    useScopedContext,
    useProviderContext,
    ContextProvider,
    ScopedContextProvider
  };
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/W6WVJJEY.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/W6WVJJEY.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useRootDialog: () => (/* binding */ useRootDialog)
/* harmony export */ });
/* harmony import */ var _5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js");
"use client";


// src/dialog/utils/use-root-dialog.ts



function useRootDialog({
  attribute,
  contentId,
  contentElement,
  enabled
}) {
  const [updated, retry] = (0,_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_2__.useForceUpdate)();
  const isRootDialog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(() => {
    if (!enabled) return false;
    if (!contentElement) return false;
    const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(contentElement);
    const id = body.getAttribute(attribute);
    return !id || id === contentId;
  }, [updated, enabled, contentElement, attribute, contentId]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!enabled) return;
    if (!contentId) return;
    if (!contentElement) return;
    const { body } = (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_3__.getDocument)(contentElement);
    if (isRootDialog()) {
      body.setAttribute(attribute, contentId);
      return () => body.removeAttribute(attribute);
    }
    const observer = new MutationObserver(() => (0,react_dom__WEBPACK_IMPORTED_MODULE_1__.flushSync)(retry));
    observer.observe(body, { attributeFilter: [attribute] });
    return () => observer.disconnect();
  }, [updated, enabled, contentId, contentElement, isRootDialog, attribute]);
  return isRootDialog;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/X7QOZUD3.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getElementPolygon: () => (/* binding */ getElementPolygon),
/* harmony export */   getEventPoint: () => (/* binding */ getEventPoint),
/* harmony export */   isPointInPolygon: () => (/* binding */ isPointInPolygon)
/* harmony export */ });
"use client";

// src/hovercard/utils/polygon.ts
function getEventPoint(event) {
  return [event.clientX, event.clientY];
}
function isPointInPolygon(point, polygon) {
  const [x, y] = point;
  let inside = false;
  const length = polygon.length;
  for (let l = length, i = 0, j = l - 1; i < l; j = i++) {
    const [xi, yi] = polygon[i];
    const [xj, yj] = polygon[j];
    const [, vy] = polygon[j === 0 ? l - 1 : j - 1] || [0, 0];
    const where = (yi - yj) * (x - xi) - (xi - xj) * (y - yi);
    if (yj < yi) {
      if (y >= yj && y < yi) {
        if (where === 0) return true;
        if (where > 0) {
          if (y === yj) {
            if (y > vy) {
              inside = !inside;
            }
          } else {
            inside = !inside;
          }
        }
      }
    } else if (yi < yj) {
      if (y > yi && y <= yj) {
        if (where === 0) return true;
        if (where < 0) {
          if (y === yj) {
            if (y < vy) {
              inside = !inside;
            }
          } else {
            inside = !inside;
          }
        }
      }
    } else if (y === yi && (x >= xj && x <= xi || x >= xi && x <= xj)) {
      return true;
    }
  }
  return inside;
}
function getEnterPointPlacement(enterPoint, rect) {
  const { top, right, bottom, left } = rect;
  const [x, y] = enterPoint;
  const placementX = x < left ? "left" : x > right ? "right" : null;
  const placementY = y < top ? "top" : y > bottom ? "bottom" : null;
  return [placementX, placementY];
}
function getElementPolygon(element, enterPoint) {
  const rect = element.getBoundingClientRect();
  const { top, right, bottom, left } = rect;
  const [x, y] = getEnterPointPlacement(enterPoint, rect);
  const polygon = [enterPoint];
  if (x) {
    if (y !== "top") {
      polygon.push([x === "left" ? left : right, top]);
    }
    polygon.push([x === "left" ? right : left, top]);
    polygon.push([x === "left" ? right : left, bottom]);
    if (y !== "bottom") {
      polygon.push([x === "left" ? left : right, bottom]);
    }
  } else if (y === "top") {
    polygon.push([left, top]);
    polygon.push([left, bottom]);
    polygon.push([right, bottom]);
    polygon.push([right, top]);
  } else {
    polygon.push([left, bottom]);
    polygon.push([left, top]);
    polygon.push([right, top]);
    polygon.push([right, bottom]);
  }
  return polygon;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y2U4BRIM.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y2U4BRIM.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDialogStore: () => (/* binding */ useDialogStore),
/* harmony export */   useDialogStoreProps: () => (/* binding */ useDialogStoreProps)
/* harmony export */ });
/* harmony import */ var _T22PY7TE_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./T22PY7TE.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T22PY7TE.js");
/* harmony import */ var _RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RTNCFSKZ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _ariakit_core_dialog_dialog_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ariakit/core/dialog/dialog-store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/FZZ2AVHF.js");
"use client";



// src/dialog/dialog-store.ts

function useDialogStoreProps(store, update, props) {
  return (0,_T22PY7TE_js__WEBPACK_IMPORTED_MODULE_0__.useDisclosureStoreProps)(store, update, props);
}
function useDialogStore(props = {}) {
  const [store, update] = (0,_RTNCFSKZ_js__WEBPACK_IMPORTED_MODULE_1__.useStore)(_ariakit_core_dialog_dialog_store__WEBPACK_IMPORTED_MODULE_2__.createDialogStore, props);
  return useDialogStoreProps(store, update, props);
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y67KZUMI.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Y67KZUMI.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PopoverContextProvider: () => (/* binding */ PopoverContextProvider),
/* harmony export */   PopoverScopedContextProvider: () => (/* binding */ PopoverScopedContextProvider),
/* harmony export */   usePopoverContext: () => (/* binding */ usePopoverContext),
/* harmony export */   usePopoverProviderContext: () => (/* binding */ usePopoverProviderContext),
/* harmony export */   usePopoverScopedContext: () => (/* binding */ usePopoverScopedContext)
/* harmony export */ });
/* harmony import */ var _T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./T2AZQXQU.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/T2AZQXQU.js");
/* harmony import */ var _VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
"use client";



// src/popover/popover-context.tsx
var ctx = (0,_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_0__.createStoreContext)(
  [_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_1__.DialogContextProvider],
  [_T2AZQXQU_js__WEBPACK_IMPORTED_MODULE_1__.DialogScopedContextProvider]
);
var usePopoverContext = ctx.useContext;
var usePopoverScopedContext = ctx.useScopedContext;
var usePopoverProviderContext = ctx.useProviderContext;
var PopoverContextProvider = ctx.ContextProvider;
var PopoverScopedContextProvider = ctx.ScopedContextProvider;




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/Z5GCVBAY.js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   disableTree: () => (/* binding */ disableTree),
/* harmony export */   disableTreeOutside: () => (/* binding */ disableTreeOutside)
/* harmony export */ });
/* harmony import */ var _IGR4SXG2_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./IGR4SXG2.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IGR4SXG2.js");
/* harmony import */ var _677M2CI3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./677M2CI3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/677M2CI3.js");
/* harmony import */ var _S7U6BLGA_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./S7U6BLGA.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/S7U6BLGA.js");
/* harmony import */ var _AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AOUGVQZ3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/AOUGVQZ3.js");
/* harmony import */ var _K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./K2ZF5NU7.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/K2ZF5NU7.js");
/* harmony import */ var _63XF7ACK_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./63XF7ACK.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/63XF7ACK.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ariakit/core/utils/focus */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/utils/focus.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
"use client";







// src/dialog/utils/disable-tree.ts



function disableTree(element, ignoredElements) {
  if (!("style" in element)) return _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.noop;
  if ((0,_677M2CI3_js__WEBPACK_IMPORTED_MODULE_1__.supportsInert)()) {
    return (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__.setProperty)(element, "inert", true);
  }
  const tabbableElements = (0,_ariakit_core_utils_focus__WEBPACK_IMPORTED_MODULE_3__.getAllTabbableIn)(element, true);
  const enableElements = tabbableElements.map((element2) => {
    if (ignoredElements == null ? void 0 : ignoredElements.some((el) => el && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_4__.contains)(el, element2))) return _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.noop;
    const restoreFocusMethod = (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__.orchestrate)(element2, "focus", () => {
      element2.focus = _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.noop;
      return () => {
        delete element2.focus;
      };
    });
    return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.chain)((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__.setAttribute)(element2, "tabindex", "-1"), restoreFocusMethod);
  });
  return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_0__.chain)(
    ...enableElements,
    (0,_S7U6BLGA_js__WEBPACK_IMPORTED_MODULE_5__.hideElementFromAccessibilityTree)(element),
    (0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__.assignStyle)(element, {
      pointerEvents: "none",
      userSelect: "none",
      cursor: "default"
    })
  );
}
function disableTreeOutside(id, elements) {
  const cleanups = [];
  const ids = elements.map((el) => el == null ? void 0 : el.id);
  (0,_AOUGVQZ3_js__WEBPACK_IMPORTED_MODULE_6__.walkTreeOutside)(
    id,
    elements,
    (element) => {
      if ((0,_63XF7ACK_js__WEBPACK_IMPORTED_MODULE_7__.isBackdrop)(element, ...ids)) return;
      if ((0,_IGR4SXG2_js__WEBPACK_IMPORTED_MODULE_8__.isFocusTrap)(element, ...ids)) return;
      cleanups.unshift(disableTree(element, elements));
    },
    (element) => {
      if (!element.hasAttribute("role")) return;
      if (elements.some((el) => el && (0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_4__.contains)(el, element))) return;
      cleanups.unshift((0,_K2ZF5NU7_js__WEBPACK_IMPORTED_MODULE_2__.setAttribute)(element, "role", "none"));
    }
  );
  const restoreTreeOutside = () => {
    for (const cleanup of cleanups) {
      cleanup();
    }
  };
  return restoreTreeOutside;
}




/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip-anchor.js":
/*!******************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip-anchor.js ***!
  \******************************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TooltipAnchor: () => (/* binding */ TooltipAnchor),
/* harmony export */   useTooltipAnchor: () => (/* binding */ useTooltipAnchor)
/* harmony export */ });
/* harmony import */ var _chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../__chunks/L3J7PHFC.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/L3J7PHFC.js");
/* harmony import */ var _chunks_TRDK6LYC_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../__chunks/TRDK6LYC.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/TRDK6LYC.js");
/* harmony import */ var _chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../__chunks/5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../__chunks/3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var _ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ariakit/core/utils/store */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/BCALMBPZ.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
"use client";













// src/tooltip/tooltip-anchor.tsx



var TagName = "div";
var globalStore = (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_1__.createStore)({
  activeStore: null
});
function createRemoveStoreCallback(store) {
  return () => {
    const { activeStore } = globalStore.getState();
    if (activeStore !== store) return;
    globalStore.setState("activeStore", null);
  };
}
var useTooltipAnchor = (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_2__.createHook)(
  function useTooltipAnchor2(_a) {
    var _b = _a, { store, showOnHover = true } = _b, props = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_3__.__objRest)(_b, ["store", "showOnHover"]);
    const context = (0,_chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_4__.useTooltipProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.invariant)(
      store,
       true && "TooltipAnchor must receive a `store` prop or be wrapped in a TooltipProvider component."
    );
    const canShowOnHoverRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      return (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_1__.sync)(store, ["mounted"], (state) => {
        if (state.mounted) return;
        canShowOnHoverRef.current = false;
      });
    }, [store]);
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
      if (!store) return;
      return (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.chain)(
        // Immediately remove the current store from the global store when
        // the component unmounts. This is useful, for example, to avoid
        // showing tooltips immediately on serial tests.
        createRemoveStoreCallback(store),
        (0,_ariakit_core_utils_store__WEBPACK_IMPORTED_MODULE_1__.sync)(store, ["mounted", "skipTimeout"], (state) => {
          if (!store) return;
          if (state.mounted) {
            const { activeStore } = globalStore.getState();
            if (activeStore !== store) {
              activeStore == null ? void 0 : activeStore.hide();
            }
            return globalStore.setState("activeStore", store);
          }
          const id = setTimeout(
            createRemoveStoreCallback(store),
            state.skipTimeout
          );
          return () => clearTimeout(id);
        })
      );
    }, [store]);
    const onMouseEnterProp = props.onMouseEnter;
    const onMouseEnter = (0,_chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useEvent)((event) => {
      onMouseEnterProp == null ? void 0 : onMouseEnterProp(event);
      canShowOnHoverRef.current = true;
    });
    const onFocusVisibleProp = props.onFocusVisible;
    const onFocusVisible = (0,_chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useEvent)((event) => {
      onFocusVisibleProp == null ? void 0 : onFocusVisibleProp(event);
      if (event.defaultPrevented) return;
      store == null ? void 0 : store.setAnchorElement(event.currentTarget);
      store == null ? void 0 : store.show();
    });
    const onBlurProp = props.onBlur;
    const onBlur = (0,_chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_6__.useEvent)((event) => {
      onBlurProp == null ? void 0 : onBlurProp(event);
      if (event.defaultPrevented) return;
      const { activeStore } = globalStore.getState();
      canShowOnHoverRef.current = false;
      if (activeStore === store) {
        globalStore.setState("activeStore", null);
      }
    });
    const type = store.useState("type");
    const contentId = store.useState((state) => {
      var _a2;
      return (_a2 = state.contentElement) == null ? void 0 : _a2.id;
    });
    props = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_3__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_3__.__spreadValues)({
      "aria-labelledby": type === "label" ? contentId : void 0
    }, props), {
      onMouseEnter,
      onFocusVisible,
      onBlur
    });
    props = (0,_chunks_TRDK6LYC_js__WEBPACK_IMPORTED_MODULE_7__.useHovercardAnchor)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_3__.__spreadValues)({
      store,
      showOnHover(event) {
        if (!canShowOnHoverRef.current) return false;
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_5__.isFalsyBooleanCallback)(showOnHover, event)) return false;
        const { activeStore } = globalStore.getState();
        if (!activeStore) return true;
        store == null ? void 0 : store.show();
        return false;
      }
    }, props));
    return props;
  }
);
var TooltipAnchor = (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(function TooltipAnchor2(props) {
  const htmlProps = useTooltipAnchor(props);
  return (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_2__.createElement)(TagName, htmlProps);
});



/***/ }),

/***/ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip.js":
/*!***********************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip.js ***!
  \***********************************************************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Tooltip: () => (/* binding */ Tooltip),
/* harmony export */   useTooltip: () => (/* binding */ useTooltip)
/* harmony export */ });
/* harmony import */ var _chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../__chunks/L3J7PHFC.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/L3J7PHFC.js");
/* harmony import */ var _chunks_IUFFNNPK_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../__chunks/IUFFNNPK.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/IUFFNNPK.js");
/* harmony import */ var _chunks_CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../__chunks/CAGBPNDP.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/CAGBPNDP.js");
/* harmony import */ var _chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../__chunks/VOQWLFSQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/VOQWLFSQ.js");
/* harmony import */ var _chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../__chunks/5GGHRIN3.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/5GGHRIN3.js");
/* harmony import */ var _chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../__chunks/3YLGPPWQ.js */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/3YLGPPWQ.js");
/* harmony import */ var _ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/core/utils/dom */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/DTR5TSDJ.js");
/* harmony import */ var _ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ariakit/core/utils/misc */ "./node_modules/.pnpm/@ariakit+core@0.4.15/node_modules/@ariakit/core/esm/__chunks/PBFD2E7P.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
"use client";











































// src/tooltip/tooltip.tsx



var TagName = "div";
var useTooltip = (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createHook)(
  function useTooltip2(_a) {
    var _b = _a, {
      store,
      portal = true,
      gutter = 8,
      preserveTabOrder = false,
      hideOnHoverOutside = true,
      hideOnInteractOutside = true
    } = _b, props = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__objRest)(_b, [
      "store",
      "portal",
      "gutter",
      "preserveTabOrder",
      "hideOnHoverOutside",
      "hideOnInteractOutside"
    ]);
    const context = (0,_chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_3__.useTooltipProviderContext)();
    store = store || context;
    (0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.invariant)(
      store,
       true && "Tooltip must receive a `store` prop or be wrapped in a TooltipProvider component."
    );
    props = (0,_chunks_5GGHRIN3_js__WEBPACK_IMPORTED_MODULE_5__.useWrapElement)(
      props,
      (element) => /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_3__.TooltipScopedContextProvider, { value: store, children: element }),
      [store]
    );
    const role = store.useState(
      (state) => state.type === "description" ? "tooltip" : "none"
    );
    props = (0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({ role }, props);
    props = (0,_chunks_IUFFNNPK_js__WEBPACK_IMPORTED_MODULE_6__.useHovercard)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadProps)((0,_chunks_3YLGPPWQ_js__WEBPACK_IMPORTED_MODULE_2__.__spreadValues)({}, props), {
      store,
      portal,
      gutter,
      preserveTabOrder,
      hideOnHoverOutside(event) {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.isFalsyBooleanCallback)(hideOnHoverOutside, event)) return false;
        const anchorElement = store == null ? void 0 : store.getState().anchorElement;
        if (!anchorElement) return true;
        if ("focusVisible" in anchorElement.dataset) return false;
        return true;
      },
      hideOnInteractOutside: (event) => {
        if ((0,_ariakit_core_utils_misc__WEBPACK_IMPORTED_MODULE_4__.isFalsyBooleanCallback)(hideOnInteractOutside, event)) return false;
        const anchorElement = store == null ? void 0 : store.getState().anchorElement;
        if (!anchorElement) return true;
        if ((0,_ariakit_core_utils_dom__WEBPACK_IMPORTED_MODULE_7__.contains)(anchorElement, event.target)) return false;
        return true;
      }
    }));
    return props;
  }
);
var Tooltip = (0,_chunks_CAGBPNDP_js__WEBPACK_IMPORTED_MODULE_8__.createDialogComponent)(
  (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(function Tooltip2(props) {
    const htmlProps = useTooltip(props);
    return (0,_chunks_VOQWLFSQ_js__WEBPACK_IMPORTED_MODULE_1__.createElement)(TagName, htmlProps);
  }),
  _chunks_L3J7PHFC_js__WEBPACK_IMPORTED_MODULE_3__.useTooltipProviderContext
);



/***/ }),

/***/ "./node_modules/.pnpm/@babel+runtime@7.25.7/node_modules/@babel/runtime/helpers/esm/extends.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@babel+runtime@7.25.7/node_modules/@babel/runtime/helpers/esm/extends.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _extends)
/* harmony export */ });
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function (n) {
    for (var e = 1; e < arguments.length; e++) {
      var t = arguments[e];
      for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]);
    }
    return n;
  }, _extends.apply(null, arguments);
}


/***/ }),

/***/ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js":
/*!*****************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createCache)
/* harmony export */ });
/* harmony import */ var _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/sheet */ "./node_modules/.pnpm/@emotion+sheet@1.4.0/node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Tokenizer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Utility.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Enum.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Serializer.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Middleware.js");
/* harmony import */ var stylis__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! stylis */ "./node_modules/.pnpm/stylis@4.2.0/node_modules/stylis/src/Parser.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/.pnpm/@emotion+weak-memoize@0.4.0/node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/.pnpm/@emotion+memoize@0.9.0/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");





var identifierWithPointTracking = function identifierWithPointTracking(begin, points, index) {
  var previous = 0;
  var character = 0;

  while (true) {
    previous = character;
    character = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)(); // &\f

    if (previous === 38 && character === 12) {
      points[index] = 1;
    }

    if ((0,stylis__WEBPACK_IMPORTED_MODULE_3__.token)(character)) {
      break;
    }

    (0,stylis__WEBPACK_IMPORTED_MODULE_3__.next)();
  }

  return (0,stylis__WEBPACK_IMPORTED_MODULE_3__.slice)(begin, stylis__WEBPACK_IMPORTED_MODULE_3__.position);
};

var toRules = function toRules(parsed, points) {
  // pretend we've started with a comma
  var index = -1;
  var character = 44;

  do {
    switch ((0,stylis__WEBPACK_IMPORTED_MODULE_3__.token)(character)) {
      case 0:
        // &\f
        if (character === 38 && (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)() === 12) {
          // this is not 100% correct, we don't account for literal sequences here - like for example quoted strings
          // stylis inserts \f after & to know when & where it should replace this sequence with the context selector
          // and when it should just concatenate the outer and inner selectors
          // it's very unlikely for this sequence to actually appear in a different context, so we just leverage this fact here
          points[index] = 1;
        }

        parsed[index] += identifierWithPointTracking(stylis__WEBPACK_IMPORTED_MODULE_3__.position - 1, points, index);
        break;

      case 2:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_3__.delimit)(character);
        break;

      case 4:
        // comma
        if (character === 44) {
          // colon
          parsed[++index] = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.peek)() === 58 ? '&\f' : '';
          points[index] = parsed[index].length;
          break;
        }

      // fallthrough

      default:
        parsed[index] += (0,stylis__WEBPACK_IMPORTED_MODULE_4__.from)(character);
    }
  } while (character = (0,stylis__WEBPACK_IMPORTED_MODULE_3__.next)());

  return parsed;
};

var getRules = function getRules(value, points) {
  return (0,stylis__WEBPACK_IMPORTED_MODULE_3__.dealloc)(toRules((0,stylis__WEBPACK_IMPORTED_MODULE_3__.alloc)(value), points));
}; // WeakSet would be more appropriate, but only WeakMap is supported in IE11


var fixedElements = /* #__PURE__ */new WeakMap();
var compat = function compat(element) {
  if (element.type !== 'rule' || !element.parent || // positive .length indicates that this rule contains pseudo
  // negative .length indicates that this rule has been already prefixed
  element.length < 1) {
    return;
  }

  var value = element.value;
  var parent = element.parent;
  var isImplicitRule = element.column === parent.column && element.line === parent.line;

  while (parent.type !== 'rule') {
    parent = parent.parent;
    if (!parent) return;
  } // short-circuit for the simplest case


  if (element.props.length === 1 && value.charCodeAt(0) !== 58
  /* colon */
  && !fixedElements.get(parent)) {
    return;
  } // if this is an implicitly inserted rule (the one eagerly inserted at the each new nested level)
  // then the props has already been manipulated beforehand as they that array is shared between it and its "rule parent"


  if (isImplicitRule) {
    return;
  }

  fixedElements.set(element, true);
  var points = [];
  var rules = getRules(value, points);
  var parentRules = parent.props;

  for (var i = 0, k = 0; i < rules.length; i++) {
    for (var j = 0; j < parentRules.length; j++, k++) {
      element.props[k] = points[i] ? rules[i].replace(/&\f/g, parentRules[j]) : parentRules[j] + " " + rules[i];
    }
  }
};
var removeLabel = function removeLabel(element) {
  if (element.type === 'decl') {
    var value = element.value;

    if ( // charcode for l
    value.charCodeAt(0) === 108 && // charcode for b
    value.charCodeAt(2) === 98) {
      // this ignores label
      element["return"] = '';
      element.value = '';
    }
  }
};
var ignoreFlag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';

var isIgnoringComment = function isIgnoringComment(element) {
  return element.type === 'comm' && element.children.indexOf(ignoreFlag) > -1;
};

var createUnsafeSelectorsAlarm = function createUnsafeSelectorsAlarm(cache) {
  return function (element, index, children) {
    if (element.type !== 'rule' || cache.compat) return;
    var unsafePseudoClasses = element.value.match(/(:first|:nth|:nth-last)-child/g);

    if (unsafePseudoClasses) {
      var isNested = !!element.parent; // in nested rules comments become children of the "auto-inserted" rule and that's always the `element.parent`
      //
      // considering this input:
      // .a {
      //   .b /* comm */ {}
      //   color: hotpink;
      // }
      // we get output corresponding to this:
      // .a {
      //   & {
      //     /* comm */
      //     color: hotpink;
      //   }
      //   .b {}
      // }

      var commentContainer = isNested ? element.parent.children : // global rule at the root level
      children;

      for (var i = commentContainer.length - 1; i >= 0; i--) {
        var node = commentContainer[i];

        if (node.line < element.line) {
          break;
        } // it is quite weird but comments are *usually* put at `column: element.column - 1`
        // so we seek *from the end* for the node that is earlier than the rule's `element` and check that
        // this will also match inputs like this:
        // .a {
        //   /* comm */
        //   .b {}
        // }
        //
        // but that is fine
        //
        // it would be the easiest to change the placement of the comment to be the first child of the rule:
        // .a {
        //   .b { /* comm */ }
        // }
        // with such inputs we wouldn't have to search for the comment at all
        // TODO: consider changing this comment placement in the next major version


        if (node.column < element.column) {
          if (isIgnoringComment(node)) {
            return;
          }

          break;
        }
      }

      unsafePseudoClasses.forEach(function (unsafePseudoClass) {
        console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
      });
    }
  };
};

var isImportRule = function isImportRule(element) {
  return element.type.charCodeAt(1) === 105 && element.type.charCodeAt(0) === 64;
};

var isPrependedWithRegularRules = function isPrependedWithRegularRules(index, children) {
  for (var i = index - 1; i >= 0; i--) {
    if (!isImportRule(children[i])) {
      return true;
    }
  }

  return false;
}; // use this to remove incorrect elements from further processing
// so they don't get handed to the `sheet` (or anything else)
// as that could potentially lead to additional logs which in turn could be overhelming to the user


var nullifyElement = function nullifyElement(element) {
  element.type = '';
  element.value = '';
  element["return"] = '';
  element.children = '';
  element.props = '';
};

var incorrectImportAlarm = function incorrectImportAlarm(element, index, children) {
  if (!isImportRule(element)) {
    return;
  }

  if (element.parent) {
    console.error("`@import` rules can't be nested inside other rules. Please move it to the top level and put it before regular rules. Keep in mind that they can only be used within global styles.");
    nullifyElement(element);
  } else if (isPrependedWithRegularRules(index, children)) {
    console.error("`@import` rules can't be after other rules. Please put your `@import` rules before your other rules.");
    nullifyElement(element);
  }
};

/* eslint-disable no-fallthrough */

function prefix(value, length) {
  switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.hash)(value, length)) {
    // color-adjust
    case 5103:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'print-' + value + value;
    // animation, animation-(delay|direction|duration|fill-mode|iteration-count|name|play-state|timing-function)

    case 5737:
    case 4201:
    case 3177:
    case 3433:
    case 1641:
    case 4457:
    case 2921: // text-decoration, filter, clip-path, backface-visibility, column, box-decoration-break

    case 5572:
    case 6356:
    case 5844:
    case 3191:
    case 6645:
    case 3005: // mask, mask-image, mask-(mode|clip|size), mask-(repeat|origin), mask-position, mask-composite,

    case 6391:
    case 5879:
    case 5623:
    case 6135:
    case 4599:
    case 4855: // background-clip, columns, column-(count|fill|gap|rule|rule-color|rule-style|rule-width|span|width)

    case 4215:
    case 6389:
    case 5109:
    case 5365:
    case 5621:
    case 3829:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + value;
    // appearance, user-select, transform, hyphens, text-size-adjust

    case 5349:
    case 4246:
    case 4810:
    case 6968:
    case 2756:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
    // flex, flex-direction

    case 6828:
    case 4268:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
    // order

    case 6165:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-' + value + value;
    // align-items

    case 5187:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(\w+).+(:[^]+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-$1$2' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-$1$2') + value;
    // align-self

    case 5443:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-item-' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /flex-|-self/, '') + value;
    // align-content

    case 4675:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-line-pack' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /align-content|flex-|-self/, '') + value;
    // flex-shrink

    case 5548:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'shrink', 'negative') + value;
    // flex-basis

    case 5292:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'basis', 'preferred-size') + value;
    // flex-grow

    case 6060:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-' + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, '-grow', '') + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'grow', 'positive') + value;
    // transition

    case 4554:
      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /([^-])(transform)/g, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2') + value;
    // cursor

    case 6187:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(zoom-|grab)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1'), /(image-set)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1'), value, '') + value;
    // background, background-image

    case 5495:
    case 3959:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(image-set\([^]*)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1' + '$`$1');
    // justify-content

    case 4968:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)(flex-)?(.*)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'box-pack:$3' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'flex-pack:$3'), /s.+-b[^;]+/, 'justify') + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + value;
    // (margin|padding)-inline-(start|end)

    case 4095:
    case 3583:
    case 4068:
    case 2532:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+)-inline(.+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$1$2') + value;
    // (min|max)?(width|height|inline-size|block-size)

    case 8116:
    case 7059:
    case 5753:
    case 5535:
    case 5445:
    case 5701:
    case 4933:
    case 4677:
    case 5533:
    case 5789:
    case 5021:
    case 4765:
      // stretch, max-content, min-content, fill-available
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.strlen)(value) - 1 - length > 6) switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 1)) {
        // (m)ax-content, (m)in-content
        case 109:
          // -
          if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 4) !== 45) break;
        // (f)ill-available, (f)it-content

        case 102:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)(.+)-([^]+)/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2-$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 3) == 108 ? '$3' : '$2-$3')) + value;
        // (s)tretch

        case 115:
          return ~(0,stylis__WEBPACK_IMPORTED_MODULE_4__.indexof)(value, 'stretch') ? prefix((0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, 'stretch', 'fill-available'), length) + value : value;
      }
      break;
    // position: sticky

    case 4949:
      // (s)ticky?
      if ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 1) !== 115) break;
    // display: (flex|inline-flex)

    case 6444:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, (0,stylis__WEBPACK_IMPORTED_MODULE_4__.strlen)(value) - 3 - (~(0,stylis__WEBPACK_IMPORTED_MODULE_4__.indexof)(value, '!important') && 10))) {
        // stic(k)y
        case 107:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, ':', ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT) + value;
        // (inline-)?fl(e)x

        case 101:
          return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /(.+:)([^;!]+)(;|!.+)?/, '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, 14) === 45 ? 'inline-' : '') + 'box$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + '$2$3' + '$1' + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + '$2box$3') + value;
      }

      break;
    // writing-mode

    case 5936:
      switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.charat)(value, length + 11)) {
        // vertical-l(r)
        case 114:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb') + value;
        // vertical-r(l)

        case 108:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'tb-rl') + value;
        // horizontal(-)tb

        case 45:
          return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /[svh]\w+-[tblr]{2}/, 'lr') + value;
      }

      return stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + value + stylis__WEBPACK_IMPORTED_MODULE_5__.MS + value + value;
  }

  return value;
}

var prefixer = function prefixer(element, index, children, callback) {
  if (element.length > -1) if (!element["return"]) switch (element.type) {
    case stylis__WEBPACK_IMPORTED_MODULE_5__.DECLARATION:
      element["return"] = prefix(element.value, element.length);
      break;

    case stylis__WEBPACK_IMPORTED_MODULE_5__.KEYFRAMES:
      return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
        value: (0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(element.value, '@', '@' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT)
      })], callback);

    case stylis__WEBPACK_IMPORTED_MODULE_5__.RULESET:
      if (element.length) return (0,stylis__WEBPACK_IMPORTED_MODULE_4__.combine)(element.props, function (value) {
        switch ((0,stylis__WEBPACK_IMPORTED_MODULE_4__.match)(value, /(::plac\w+|:read-\w+)/)) {
          // :read-(only|write)
          case ':read-only':
          case ':read-write':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(read-\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + '$1')]
            })], callback);
          // :placeholder

          case '::placeholder':
            return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)([(0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.WEBKIT + 'input-$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, ':' + stylis__WEBPACK_IMPORTED_MODULE_5__.MOZ + '$1')]
            }), (0,stylis__WEBPACK_IMPORTED_MODULE_3__.copy)(element, {
              props: [(0,stylis__WEBPACK_IMPORTED_MODULE_4__.replace)(value, /:(plac\w+)/, stylis__WEBPACK_IMPORTED_MODULE_5__.MS + 'input-$1')]
            })], callback);
        }

        return '';
      });
  }
};

var defaultStylisPlugins = [prefixer];
var getSourceMap;

{
  var sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//g;

  getSourceMap = function getSourceMap(styles) {
    var matches = styles.match(sourceMapPattern);
    if (!matches) return;
    return matches[matches.length - 1];
  };
}

var createCache = function createCache(options) {
  var key = options.key;

  if (!key) {
    throw new Error("You have to configure `key` for your cache. Please make sure it's unique (and not equal to 'css') as it's used for linking styles to your cache.\n" + "If multiple caches share the same key they might \"fight\" for each other's style elements.");
  }

  if (key === 'css') {
    var ssrStyles = document.querySelectorAll("style[data-emotion]:not([data-s])"); // get SSRed styles out of the way of React's hydration
    // document.head is a safe place to move them to(though note document.head is not necessarily the last place they will be)
    // note this very very intentionally targets all style elements regardless of the key to ensure
    // that creating a cache works inside of render of a React component

    Array.prototype.forEach.call(ssrStyles, function (node) {
      // we want to only move elements which have a space in the data-emotion attribute value
      // because that indicates that it is an Emotion 11 server-side rendered style elements
      // while we will already ignore Emotion 11 client-side inserted styles because of the :not([data-s]) part in the selector
      // Emotion 10 client-side inserted styles did not have data-s (but importantly did not have a space in their data-emotion attributes)
      // so checking for the space ensures that loading Emotion 11 after Emotion 10 has inserted some styles
      // will not result in the Emotion 10 styles being destroyed
      var dataEmotionAttribute = node.getAttribute('data-emotion');

      if (dataEmotionAttribute.indexOf(' ') === -1) {
        return;
      }

      document.head.appendChild(node);
      node.setAttribute('data-s', '');
    });
  }

  var stylisPlugins = options.stylisPlugins || defaultStylisPlugins;

  {
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {};
  var container;
  var nodesToHydrate = [];

  {
    container = options.container || document.head;
    Array.prototype.forEach.call( // this means we will ignore elements which don't have a space in them which
    // means that the style elements we're looking at are only Emotion 11 server-rendered style elements
    document.querySelectorAll("style[data-emotion^=\"" + key + " \"]"), function (node) {
      var attrib = node.getAttribute("data-emotion").split(' ');

      for (var i = 1; i < attrib.length; i++) {
        inserted[attrib[i]] = true;
      }

      nodesToHydrate.push(node);
    });
  }

  var _insert;

  var omnipresentPlugins = [compat, removeLabel];

  {
    omnipresentPlugins.push(createUnsafeSelectorsAlarm({
      get compat() {
        return cache.compat;
      }

    }), incorrectImportAlarm);
  }

  {
    var currentSheet;
    var finalizingPlugins = [stylis__WEBPACK_IMPORTED_MODULE_6__.stringify, function (element) {
      if (!element.root) {
        if (element["return"]) {
          currentSheet.insert(element["return"]);
        } else if (element.value && element.type !== stylis__WEBPACK_IMPORTED_MODULE_5__.COMMENT) {
          // insert empty rule in non-production environments
          // so @emotion/jest can grab `key` from the (JS)DOM for caches without any rules inserted yet
          currentSheet.insert(element.value + "{}");
        }
      }
    } ];
    var serializer = (0,stylis__WEBPACK_IMPORTED_MODULE_7__.middleware)(omnipresentPlugins.concat(stylisPlugins, finalizingPlugins));

    var stylis = function stylis(styles) {
      return (0,stylis__WEBPACK_IMPORTED_MODULE_6__.serialize)((0,stylis__WEBPACK_IMPORTED_MODULE_8__.compile)(styles), serializer);
    };

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      currentSheet = sheet;

      if (getSourceMap) {
        var sourceMap = getSourceMap(serialized.styles);

        if (sourceMap) {
          currentSheet = {
            insert: function insert(rule) {
              sheet.insert(rule + sourceMap);
            }
          };
        }
      }

      stylis(selector ? selector + "{" + serialized.styles + "}" : serialized.styles);

      if (shouldCache) {
        cache.inserted[serialized.name] = true;
      }
    };
  }

  var cache = {
    key: key,
    sheet: new _emotion_sheet__WEBPACK_IMPORTED_MODULE_0__.StyleSheet({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy,
      prepend: options.prepend,
      insertionPoint: options.insertionPoint
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  cache.sheet.hydrate(nodesToHydrate);
  return cache;
};




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js":
/*!***********************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js ***!
  \***********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createEmotion)
/* harmony export */ });
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");




function insertWithoutScoping(cache, serialized) {
  if (cache.inserted[serialized.name] === undefined) {
    return cache.insert('', serialized, cache.sheet, true);
  }
}

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles)(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var createEmotion = function createEmotion(options) {
  var cache = (0,_emotion_cache__WEBPACK_IMPORTED_MODULE_0__["default"])(options);

  cache.sheet.speedy = function (value) {
    if (this.ctr !== 0) {
      throw new Error('speedy must be changed before any rules are inserted');
    }

    this.isSpeedy = value;
  };

  cache.compat = true;

  var css = function css() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered, undefined);
    (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var keyframes = function keyframes() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered);
    var animation = "animation-" + serialized.name;
    insertWithoutScoping(cache, {
      name: serialized.name,
      styles: "@keyframes " + animation + "{" + serialized.styles + "}"
    });
    return animation;
  };

  var injectGlobal = function injectGlobal() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(args, cache.registered);
    insertWithoutScoping(cache, serialized);
  };

  var cx = function cx() {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return merge(cache.registered, css, classnames(args));
  };

  return {
    css: css,
    cx: cx,
    injectGlobal: injectGlobal,
    keyframes: keyframes,
    hydrate: function hydrate(ids) {
      ids.forEach(function (key) {
        cache.inserted[key] = true;
      });
    },
    flush: function flush() {
      cache.registered = {};
      cache.inserted = {};
      cache.sheet.flush();
    },
    sheet: cache.sheet,
    cache: cache,
    getRegisteredStyles: _emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles.bind(null, cache.registered),
    merge: merge.bind(null, cache.registered, css)
  };
};

var classnames = function classnames(args) {
  var cls = '';

  for (var i = 0; i < args.length; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/dist/emotion-css.development.esm.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/dist/emotion-css.development.esm.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cache: () => (/* binding */ cache),
/* harmony export */   css: () => (/* binding */ css),
/* harmony export */   cx: () => (/* binding */ cx),
/* harmony export */   flush: () => (/* binding */ flush),
/* harmony export */   getRegisteredStyles: () => (/* binding */ getRegisteredStyles),
/* harmony export */   hydrate: () => (/* binding */ hydrate),
/* harmony export */   injectGlobal: () => (/* binding */ injectGlobal),
/* harmony export */   keyframes: () => (/* binding */ keyframes),
/* harmony export */   merge: () => (/* binding */ merge),
/* harmony export */   sheet: () => (/* binding */ sheet)
/* harmony export */ });
/* harmony import */ var _create_instance_dist_emotion_css_create_instance_development_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../create-instance/dist/emotion-css-create-instance.development.esm.js */ "./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/create-instance/dist/emotion-css-create-instance.development.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");





var _createEmotion = (0,_create_instance_dist_emotion_css_create_instance_development_esm_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
  key: 'css'
}),
    flush = _createEmotion.flush,
    hydrate = _createEmotion.hydrate,
    cx = _createEmotion.cx,
    merge = _createEmotion.merge,
    getRegisteredStyles = _createEmotion.getRegisteredStyles,
    injectGlobal = _createEmotion.injectGlobal,
    keyframes = _createEmotion.keyframes,
    css = _createEmotion.css,
    sheet = _createEmotion.sheet,
    cache = _createEmotion.cache;




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+hash@0.9.2/node_modules/@emotion/hash/dist/emotion-hash.esm.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+hash@0.9.2/node_modules/@emotion/hash/dist/emotion-hash.esm.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ murmur2)
/* harmony export */ });
/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+is-prop-valid@1.4.0/node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+is-prop-valid@1.4.0/node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isPropValid)
/* harmony export */ });
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/.pnpm/@emotion+memoize@0.9.0/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");


// eslint-disable-next-line no-undef
var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|abbr|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|disableRemotePlayback|download|draggable|encType|enterKeyHint|fetchpriority|fetchPriority|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|popover|popoverTarget|popoverTargetAction|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|translate|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|incremental|fallback|inert|itemProp|itemScope|itemType|itemID|itemRef|on|option|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

var isPropValid = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_0__["default"])(function (prop) {
  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
  /* o */
  && prop.charCodeAt(1) === 110
  /* n */
  && prop.charCodeAt(2) < 91;
}
/* Z+1 */
);




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+memoize@0.9.0/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+memoize@0.9.0/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ memoize)
/* harmony export */ });
function memoize(fn) {
  var cache = Object.create(null);
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js":
/*!*********************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js ***!
  \*********************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hoistNonReactStatics)
/* harmony export */ });
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/.pnpm/hoist-non-react-statics@3.3.2/node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0__);


// this file isolates this package that is not tree-shakeable
// and if this module doesn't actually contain any logic of its own
// then Rollup just use 'hoist-non-react-statics' directly in other chunks

var hoistNonReactStatics = (function (targetComponent, sourceComponent) {
  return hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_0___default()(targetComponent, sourceComponent);
});




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js":
/*!**************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js ***!
  \**************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   C: () => (/* binding */ CacheProvider),
/* harmony export */   E: () => (/* binding */ Emotion$1),
/* harmony export */   T: () => (/* binding */ ThemeContext),
/* harmony export */   _: () => (/* binding */ __unsafe_useEmotionCache),
/* harmony export */   a: () => (/* binding */ ThemeProvider),
/* harmony export */   b: () => (/* binding */ withTheme),
/* harmony export */   c: () => (/* binding */ createEmotionProps),
/* harmony export */   h: () => (/* binding */ hasOwn),
/* harmony export */   u: () => (/* binding */ useTheme),
/* harmony export */   w: () => (/* binding */ withEmotionCache)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/.pnpm/@babel+runtime@7.25.7/node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/.pnpm/@emotion+weak-memoize@0.4.0/node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var _isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/.pnpm/@emotion+use-insertion-effect-with-fallbacks@1.2.0_react@18.3.1/node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");










var EmotionCacheContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
// because this module is primarily intended for the browser and node
// but it's also required in react native and similar environments sometimes
// and we could have a special build just for that
// but this is much easier and the native packages
// might use a different theme context in the future anyway
typeof HTMLElement !== 'undefined' ? /* #__PURE__ */(0,_emotion_cache__WEBPACK_IMPORTED_MODULE_1__["default"])({
  key: 'css'
}) : null);

{
  EmotionCacheContext.displayName = 'EmotionCacheContext';
}

var CacheProvider = EmotionCacheContext.Provider;
var __unsafe_useEmotionCache = function useEmotionCache() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
};

var withEmotionCache = function withEmotionCache(func) {
  return /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(function (props, ref) {
    // the cache will never be null in the browser
    var cache = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(EmotionCacheContext);
    return func(props, cache, ref);
  });
};

var ThemeContext = /* #__PURE__ */react__WEBPACK_IMPORTED_MODULE_0__.createContext({});

{
  ThemeContext.displayName = 'EmotionThemeContext';
}

var useTheme = function useTheme() {
  return react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
};

var getTheme = function getTheme(outerTheme, theme) {
  if (typeof theme === 'function') {
    var mergedTheme = theme(outerTheme);

    if ((mergedTheme == null || typeof mergedTheme !== 'object' || Array.isArray(mergedTheme))) {
      throw new Error('[ThemeProvider] Please return an object from your theme function, i.e. theme={() => ({})}!');
    }

    return mergedTheme;
  }

  if ((theme == null || typeof theme !== 'object' || Array.isArray(theme))) {
    throw new Error('[ThemeProvider] Please make your theme prop a plain object');
  }

  return (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({}, outerTheme, theme);
};

var createCacheWithTheme = /* #__PURE__ */(0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (outerTheme) {
  return (0,_emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_3__["default"])(function (theme) {
    return getTheme(outerTheme, theme);
  });
});
var ThemeProvider = function ThemeProvider(props) {
  var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);

  if (props.theme !== theme) {
    theme = createCacheWithTheme(theme)(props.theme);
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(ThemeContext.Provider, {
    value: theme
  }, props.children);
};
function withTheme(Component) {
  var componentName = Component.displayName || Component.name || 'Component';
  var WithTheme = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function render(props, ref) {
    var theme = react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Component, (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_2__["default"])({
      theme: theme,
      ref: ref
    }, props));
  });
  WithTheme.displayName = "WithTheme(" + componentName + ")";
  return (0,_isolated_hnrs_dist_emotion_react_isolated_hnrs_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_7__["default"])(WithTheme, Component);
}

var hasOwn = {}.hasOwnProperty;

var getLastPart = function getLastPart(functionName) {
  // The match may be something like 'Object.createEmotionProps' or
  // 'Loader.prototype.render'
  var parts = functionName.split('.');
  return parts[parts.length - 1];
};

var getFunctionNameFromStackTraceLine = function getFunctionNameFromStackTraceLine(line) {
  // V8
  var match = /^\s+at\s+([A-Za-z0-9$.]+)\s/.exec(line);
  if (match) return getLastPart(match[1]); // Safari / Firefox

  match = /^([A-Za-z0-9$.]+)@/.exec(line);
  if (match) return getLastPart(match[1]);
  return undefined;
};

var internalReactFunctionNames = /* #__PURE__ */new Set(['renderWithHooks', 'processChild', 'finishClassComponent', 'renderToString']); // These identifiers come from error stacks, so they have to be valid JS
// identifiers, thus we only need to replace what is a valid character for JS,
// but not for CSS.

var sanitizeIdentifier = function sanitizeIdentifier(identifier) {
  return identifier.replace(/\$/g, '-');
};

var getLabelFromStackTrace = function getLabelFromStackTrace(stackTrace) {
  if (!stackTrace) return undefined;
  var lines = stackTrace.split('\n');

  for (var i = 0; i < lines.length; i++) {
    var functionName = getFunctionNameFromStackTraceLine(lines[i]); // The first line of V8 stack traces is just "Error"

    if (!functionName) continue; // If we reach one of these, we have gone too far and should quit

    if (internalReactFunctionNames.has(functionName)) break; // The component name is the first function in the stack that starts with an
    // uppercase letter

    if (/^[A-Z]/.test(functionName)) return sanitizeIdentifier(functionName);
  }

  return undefined;
};

var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';
var createEmotionProps = function createEmotionProps(type, props) {
  if (typeof props.css === 'string' && // check if there is a css declaration
  props.css.indexOf(':') !== -1) {
    throw new Error("Strings are not allowed as css prop values, please wrap it in a css template literal from '@emotion/react' like this: css`" + props.css + "`");
  }

  var newProps = {};

  for (var _key in props) {
    if (hasOwn.call(props, _key)) {
      newProps[_key] = props[_key];
    }
  }

  newProps[typePropName] = type; // Runtime labeling is an opt-in feature because:
  // - It causes hydration warnings when using Safari and SSR
  // - It can degrade performance if there are a huge number of elements
  //
  // Even if the flag is set, we still don't compute the label if it has already
  // been determined by the Babel plugin.

  if (typeof globalThis !== 'undefined' && !!globalThis.EMOTION_RUNTIME_AUTO_LABEL && !!props.css && (typeof props.css !== 'object' || !('name' in props.css) || typeof props.css.name !== 'string' || props.css.name.indexOf('-') === -1)) {
    var label = getLabelFromStackTrace(new Error().stack);
    if (label) newProps[labelPropName] = label;
  }

  return newProps;
};

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serialized = _ref.serialized,
      isStringTag = _ref.isStringTag;
  (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.registerStyles)(cache, serialized, isStringTag);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_6__.useInsertionEffectAlwaysWithSyncFallback)(function () {
    return (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.insertStyles)(cache, serialized, isStringTag);
  });

  return null;
};

var Emotion = /* #__PURE__ */withEmotionCache(function (props, cache, ref) {
  var cssProp = props.css; // so that using `css` from `emotion` and passing the result to the css prop works
  // not passing the registered cache to serializeStyles because it would
  // make certain babel optimisations not possible

  if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
    cssProp = cache.registered[cssProp];
  }

  var WrappedComponent = props[typePropName];
  var registeredStyles = [cssProp];
  var className = '';

  if (typeof props.className === 'string') {
    className = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_4__.getRegisteredStyles)(cache.registered, registeredStyles, props.className);
  } else if (props.className != null) {
    className = props.className + " ";
  }

  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_5__.serializeStyles)(registeredStyles, undefined, react__WEBPACK_IMPORTED_MODULE_0__.useContext(ThemeContext));

  if (serialized.name.indexOf('-') === -1) {
    var labelFromStack = props[labelPropName];

    if (labelFromStack) {
      serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_5__.serializeStyles)([serialized, 'label:' + labelFromStack + ';']);
    }
  }

  className += cache.key + "-" + serialized.name;
  var newProps = {};

  for (var _key2 in props) {
    if (hasOwn.call(props, _key2) && _key2 !== 'css' && _key2 !== typePropName && (_key2 !== labelPropName)) {
      newProps[_key2] = props[_key2];
    }
  }

  newProps.className = className;

  if (ref) {
    newProps.ref = ref;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Insertion, {
    cache: cache,
    serialized: serialized,
    isStringTag: typeof WrappedComponent === 'string'
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(WrappedComponent, newProps));
});

{
  Emotion.displayName = 'EmotionCssPropInternal';
}

var Emotion$1 = Emotion;




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js":
/*!***************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js ***!
  \***************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CacheProvider: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.C),
/* harmony export */   ClassNames: () => (/* binding */ ClassNames),
/* harmony export */   Global: () => (/* binding */ Global),
/* harmony export */   ThemeContext: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T),
/* harmony export */   ThemeProvider: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.a),
/* harmony export */   __unsafe_useEmotionCache: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__._),
/* harmony export */   createElement: () => (/* binding */ jsx),
/* harmony export */   css: () => (/* binding */ css),
/* harmony export */   jsx: () => (/* binding */ jsx),
/* harmony export */   keyframes: () => (/* binding */ keyframes),
/* harmony export */   useTheme: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.u),
/* harmony export */   withEmotionCache: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w),
/* harmony export */   withTheme: () => (/* reexport safe */ _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.b)
/* harmony export */ });
/* harmony import */ var _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emotion-element-489459f2.browser.development.esm.js */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/.pnpm/@emotion+use-insertion-effect-with-fallbacks@1.2.0_react@18.3.1/node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var _babel_runtime_helpers_extends__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/.pnpm/@babel+runtime@7.25.7/node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_weak_memoize__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @emotion/weak-memoize */ "./node_modules/.pnpm/@emotion+weak-memoize@0.4.0/node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! hoist-non-react-statics */ "./node_modules/.pnpm/hoist-non-react-statics@3.3.2/node_modules/hoist-non-react-statics/dist/hoist-non-react-statics.cjs.js");
/* harmony import */ var hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(hoist_non_react_statics__WEBPACK_IMPORTED_MODULE_8__);












var isDevelopment = true;

var pkg = {
	name: "@emotion/react",
	version: "11.14.0",
	main: "dist/emotion-react.cjs.js",
	module: "dist/emotion-react.esm.js",
	types: "dist/emotion-react.cjs.d.ts",
	exports: {
		".": {
			types: {
				"import": "./dist/emotion-react.cjs.mjs",
				"default": "./dist/emotion-react.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				worker: {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./dist/emotion-react.development.edge-light.esm.js",
					"import": "./dist/emotion-react.development.edge-light.cjs.mjs",
					"default": "./dist/emotion-react.development.edge-light.cjs.js"
				},
				browser: {
					module: "./dist/emotion-react.browser.development.esm.js",
					"import": "./dist/emotion-react.browser.development.cjs.mjs",
					"default": "./dist/emotion-react.browser.development.cjs.js"
				},
				module: "./dist/emotion-react.development.esm.js",
				"import": "./dist/emotion-react.development.cjs.mjs",
				"default": "./dist/emotion-react.development.cjs.js"
			},
			"edge-light": {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			worker: {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			workerd: {
				module: "./dist/emotion-react.edge-light.esm.js",
				"import": "./dist/emotion-react.edge-light.cjs.mjs",
				"default": "./dist/emotion-react.edge-light.cjs.js"
			},
			browser: {
				module: "./dist/emotion-react.browser.esm.js",
				"import": "./dist/emotion-react.browser.cjs.mjs",
				"default": "./dist/emotion-react.browser.cjs.js"
			},
			module: "./dist/emotion-react.esm.js",
			"import": "./dist/emotion-react.cjs.mjs",
			"default": "./dist/emotion-react.cjs.js"
		},
		"./jsx-runtime": {
			types: {
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				worker: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.edge-light.cjs.js"
				},
				browser: {
					module: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.esm.js",
					"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.cjs.mjs",
					"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.development.cjs.js"
				},
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.development.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.development.cjs.js"
			},
			"edge-light": {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			worker: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			workerd: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.edge-light.cjs.js"
			},
			browser: {
				module: "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.esm.js",
				"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.cjs.mjs",
				"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.browser.cjs.js"
			},
			module: "./jsx-runtime/dist/emotion-react-jsx-runtime.esm.js",
			"import": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.mjs",
			"default": "./jsx-runtime/dist/emotion-react-jsx-runtime.cjs.js"
		},
		"./_isolated-hnrs": {
			types: {
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				worker: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.edge-light.cjs.js"
				},
				browser: {
					module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.esm.js",
					"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.cjs.mjs",
					"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.development.cjs.js"
				},
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.development.cjs.js"
			},
			"edge-light": {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			worker: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			workerd: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.edge-light.cjs.js"
			},
			browser: {
				module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.esm.js",
				"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.cjs.mjs",
				"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.browser.cjs.js"
			},
			module: "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.esm.js",
			"import": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.mjs",
			"default": "./_isolated-hnrs/dist/emotion-react-_isolated-hnrs.cjs.js"
		},
		"./jsx-dev-runtime": {
			types: {
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
			},
			development: {
				"edge-light": {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				worker: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				workerd: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.edge-light.cjs.js"
				},
				browser: {
					module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.esm.js",
					"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.cjs.mjs",
					"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.development.cjs.js"
				},
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.development.cjs.js"
			},
			"edge-light": {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			worker: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			workerd: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.edge-light.cjs.js"
			},
			browser: {
				module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.esm.js",
				"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.cjs.mjs",
				"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.browser.cjs.js"
			},
			module: "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.esm.js",
			"import": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.mjs",
			"default": "./jsx-dev-runtime/dist/emotion-react-jsx-dev-runtime.cjs.js"
		},
		"./package.json": "./package.json",
		"./types/css-prop": "./types/css-prop.d.ts",
		"./macro": {
			types: {
				"import": "./macro.d.mts",
				"default": "./macro.d.ts"
			},
			"default": "./macro.js"
		}
	},
	imports: {
		"#is-development": {
			development: "./src/conditions/true.ts",
			"default": "./src/conditions/false.ts"
		},
		"#is-browser": {
			"edge-light": "./src/conditions/false.ts",
			workerd: "./src/conditions/false.ts",
			worker: "./src/conditions/false.ts",
			browser: "./src/conditions/true.ts",
			"default": "./src/conditions/is-browser.ts"
		}
	},
	files: [
		"src",
		"dist",
		"jsx-runtime",
		"jsx-dev-runtime",
		"_isolated-hnrs",
		"types/css-prop.d.ts",
		"macro.*"
	],
	sideEffects: false,
	author: "Emotion Contributors",
	license: "MIT",
	scripts: {
		"test:typescript": "dtslint types"
	},
	dependencies: {
		"@babel/runtime": "^7.18.3",
		"@emotion/babel-plugin": "^11.13.5",
		"@emotion/cache": "^11.14.0",
		"@emotion/serialize": "^1.3.3",
		"@emotion/use-insertion-effect-with-fallbacks": "^1.2.0",
		"@emotion/utils": "^1.4.2",
		"@emotion/weak-memoize": "^0.4.0",
		"hoist-non-react-statics": "^3.3.1"
	},
	peerDependencies: {
		react: ">=16.8.0"
	},
	peerDependenciesMeta: {
		"@types/react": {
			optional: true
		}
	},
	devDependencies: {
		"@definitelytyped/dtslint": "0.0.112",
		"@emotion/css": "11.13.5",
		"@emotion/css-prettifier": "1.2.0",
		"@emotion/server": "11.11.0",
		"@emotion/styled": "11.14.0",
		"@types/hoist-non-react-statics": "^3.3.5",
		"html-tag-names": "^1.1.2",
		react: "16.14.0",
		"svg-tag-names": "^1.1.1",
		typescript: "^5.4.5"
	},
	repository: "https://github.com/emotion-js/emotion/tree/main/packages/react",
	publishConfig: {
		access: "public"
	},
	"umd:main": "dist/emotion-react.umd.min.js",
	preconstruct: {
		entrypoints: [
			"./index.ts",
			"./jsx-runtime.ts",
			"./jsx-dev-runtime.ts",
			"./_isolated-hnrs.ts"
		],
		umdName: "emotionReact",
		exports: {
			extra: {
				"./types/css-prop": "./types/css-prop.d.ts",
				"./macro": {
					types: {
						"import": "./macro.d.mts",
						"default": "./macro.d.ts"
					},
					"default": "./macro.js"
				}
			}
		}
	}
};

var jsx = function jsx(type, props) {
  // eslint-disable-next-line prefer-rest-params
  var args = arguments;

  if (props == null || !_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.h.call(props, 'css')) {
    return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(undefined, args);
  }

  var argsLength = args.length;
  var createElementArgArray = new Array(argsLength);
  createElementArgArray[0] = _emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.E;
  createElementArgArray[1] = (0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.c)(type, props);

  for (var i = 2; i < argsLength; i++) {
    createElementArgArray[i] = args[i];
  }

  return react__WEBPACK_IMPORTED_MODULE_1__.createElement.apply(null, createElementArgArray);
};

(function (_jsx) {
  var JSX;

  (function (_JSX) {})(JSX || (JSX = _jsx.JSX || (_jsx.JSX = {})));
})(jsx || (jsx = {}));

var warnedAboutCssPropForGlobal = false; // maintain place over rerenders.
// initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
// initial client-side render from SSR, use place of hydrating tag

var Global = /* #__PURE__ */(0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  if (!warnedAboutCssPropForGlobal && ( // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // I don't really want to add it to the type since it shouldn't be used
  'className' in props && props.className || 'css' in props && props.css)) {
    console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
    warnedAboutCssPropForGlobal = true;
  }

  var styles = props.styles;
  var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)([styles], undefined, react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T));
  // but it is based on a constant that will never change at runtime
  // it's effectively like having two implementations and switching them out
  // so it's not actually breaking anything


  var sheetRef = react__WEBPACK_IMPORTED_MODULE_1__.useRef();
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var key = cache.key + "-global"; // use case of https://github.com/emotion-js/emotion/issues/2675

    var sheet = new cache.sheet.constructor({
      key: key,
      nonce: cache.sheet.nonce,
      container: cache.sheet.container,
      speedy: cache.sheet.isSpeedy
    });
    var rehydrating = false;
    var node = document.querySelector("style[data-emotion=\"" + key + " " + serialized.name + "\"]");

    if (cache.sheet.tags.length) {
      sheet.before = cache.sheet.tags[0];
    }

    if (node !== null) {
      rehydrating = true; // clear the hash so this node won't be recognizable as rehydratable by other <Global/>s

      node.setAttribute('data-emotion', key);
      sheet.hydrate([node]);
    }

    sheetRef.current = [sheet, rehydrating];
    return function () {
      sheet.flush();
    };
  }, [cache]);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectWithLayoutFallback)(function () {
    var sheetRefCurrent = sheetRef.current;
    var sheet = sheetRefCurrent[0],
        rehydrating = sheetRefCurrent[1];

    if (rehydrating) {
      sheetRefCurrent[1] = false;
      return;
    }

    if (serialized.next !== undefined) {
      // insert keyframes
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serialized.next, true);
    }

    if (sheet.tags.length) {
      // if this doesn't exist then it will be null so the style element will be appended
      var element = sheet.tags[sheet.tags.length - 1].nextElementSibling;
      sheet.before = element;
      sheet.flush();
    }

    cache.insert("", serialized, sheet, false);
  }, [cache, serialized.name]);
  return null;
});

{
  Global.displayName = 'EmotionGlobal';
}

function css() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args);
}

function keyframes() {
  var insertable = css.apply(void 0, arguments);
  var name = "animation-" + insertable.name;
  return {
    name: name,
    styles: "@keyframes " + name + "{" + insertable.styles + "}",
    anim: 1,
    toString: function toString() {
      return "_EMO_" + this.name + "_" + this.styles + "_EMO_";
    }
  };
}

var classnames = function classnames(args) {
  var len = args.length;
  var i = 0;
  var cls = '';

  for (; i < len; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            if (arg.styles !== undefined && arg.name !== undefined) {
              console.error('You have passed styles created with `css` from `@emotion/react` package to the `cx`.\n' + '`cx` is meant to compose class names (strings) so you should convert those styles to a class name by passing them to the `css` received from <ClassNames/> component.');
            }

            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.getRegisteredStyles)(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serializedArr = _ref.serializedArr;
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_3__.useInsertionEffectAlwaysWithSyncFallback)(function () {

    for (var i = 0; i < serializedArr.length; i++) {
      (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.insertStyles)(cache, serializedArr[i], false);
    }
  });

  return null;
};

var ClassNames = /* #__PURE__ */(0,_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.w)(function (props, cache) {
  var hasRendered = false;
  var serializedArr = [];

  var css = function css() {
    if (hasRendered && isDevelopment) {
      throw new Error('css can only be used during render');
    }

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_4__.serializeStyles)(args, cache.registered);
    serializedArr.push(serialized); // registration has to happen here as the result of this might get consumed by `cx`

    (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_2__.registerStyles)(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var cx = function cx() {
    if (hasRendered && isDevelopment) {
      throw new Error('cx can only be used during render');
    }

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return merge(cache.registered, css, classnames(args));
  };

  var content = {
    css: css,
    cx: cx,
    theme: react__WEBPACK_IMPORTED_MODULE_1__.useContext(_emotion_element_489459f2_browser_development_esm_js__WEBPACK_IMPORTED_MODULE_0__.T)
  };
  var ele = props.children(content);
  hasRendered = true;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(react__WEBPACK_IMPORTED_MODULE_1__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_1__.createElement(Insertion, {
    cache: cache,
    serializedArr: serializedArr
  }), ele);
});

{
  ClassNames.displayName = 'EmotionClassNames';
}

{
  var isBrowser = typeof document !== 'undefined'; // #1727, #2905 for some reason Jest and Vitest evaluate modules twice if some consuming module gets mocked

  var isTestEnv = typeof jest !== 'undefined' || typeof vi !== 'undefined';

  if (isBrowser && !isTestEnv) {
    // globalThis has wide browser support - https://caniuse.com/?search=globalThis, Node.js 12 and later
    var globalContext = typeof globalThis !== 'undefined' ? globalThis // eslint-disable-line no-undef
    : isBrowser ? window : __webpack_require__.g;
    var globalKey = "__EMOTION_REACT_" + pkg.version.split('.')[0] + "__";

    if (globalContext[globalKey]) {
      console.warn('You are loading @emotion/react when it is already loaded. Running ' + 'multiple instances may cause problems. This can happen if multiple ' + 'versions are used, or if multiple builds of the same version are ' + 'used.');
    }

    globalContext[globalKey] = true;
  }
}




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js ***!
  \*******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeStyles: () => (/* binding */ serializeStyles)
/* harmony export */ });
/* harmony import */ var _emotion_hash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/hash */ "./node_modules/.pnpm/@emotion+hash@0.9.2/node_modules/@emotion/hash/dist/emotion-hash.esm.js");
/* harmony import */ var _emotion_unitless__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/unitless */ "./node_modules/.pnpm/@emotion+unitless@0.10.0/node_modules/@emotion/unitless/dist/emotion-unitless.esm.js");
/* harmony import */ var _emotion_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/memoize */ "./node_modules/.pnpm/@emotion+memoize@0.9.0/node_modules/@emotion/memoize/dist/emotion-memoize.esm.js");




var isDevelopment = true;

var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
var hyphenateRegex = /[A-Z]|^ms/g;
var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

var isCustomProperty = function isCustomProperty(property) {
  return property.charCodeAt(1) === 45;
};

var isProcessableValue = function isProcessableValue(value) {
  return value != null && typeof value !== 'boolean';
};

var processStyleName = /* #__PURE__ */(0,_emotion_memoize__WEBPACK_IMPORTED_MODULE_2__["default"])(function (styleName) {
  return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
});

var processStyleValue = function processStyleValue(key, value) {
  switch (key) {
    case 'animation':
    case 'animationName':
      {
        if (typeof value === 'string') {
          return value.replace(animationRegex, function (match, p1, p2) {
            cursor = {
              name: p1,
              styles: p2,
              next: cursor
            };
            return p1;
          });
        }
      }
  }

  if (_emotion_unitless__WEBPACK_IMPORTED_MODULE_1__["default"][key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
    return value + 'px';
  }

  return value;
};

{
  var contentValuePattern = /(var|attr|counters?|url|element|(((repeating-)?(linear|radial))|conic)-gradient)\(|(no-)?(open|close)-quote/;
  var contentValues = ['normal', 'none', 'initial', 'inherit', 'unset'];
  var oldProcessStyleValue = processStyleValue;
  var msPattern = /^-ms-/;
  var hyphenPattern = /-(.)/g;
  var hyphenatedCache = {};

  processStyleValue = function processStyleValue(key, value) {
    if (key === 'content') {
      if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
        throw new Error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
      }
    }

    var processed = oldProcessStyleValue(key, value);

    if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
      hyphenatedCache[key] = true;
      console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
        return _char.toUpperCase();
      }) + "?");
    }

    return processed;
  };
}

var noComponentSelectorMessage = 'Component selectors can only be used in conjunction with ' + '@emotion/babel-plugin, the swc Emotion plugin, or another Emotion-aware ' + 'compiler transform.';

function handleInterpolation(mergedProps, registered, interpolation) {
  if (interpolation == null) {
    return '';
  }

  var componentSelector = interpolation;

  if (componentSelector.__emotion_styles !== undefined) {
    if (String(componentSelector) === 'NO_COMPONENT_SELECTOR') {
      throw new Error(noComponentSelectorMessage);
    }

    return componentSelector;
  }

  switch (typeof interpolation) {
    case 'boolean':
      {
        return '';
      }

    case 'object':
      {
        var keyframes = interpolation;

        if (keyframes.anim === 1) {
          cursor = {
            name: keyframes.name,
            styles: keyframes.styles,
            next: cursor
          };
          return keyframes.name;
        }

        var serializedStyles = interpolation;

        if (serializedStyles.styles !== undefined) {
          var next = serializedStyles.next;

          if (next !== undefined) {
            // not the most efficient thing ever but this is a pretty rare case
            // and there will be very few iterations of this generally
            while (next !== undefined) {
              cursor = {
                name: next.name,
                styles: next.styles,
                next: cursor
              };
              next = next.next;
            }
          }

          var styles = serializedStyles.styles + ";";
          return styles;
        }

        return createStringFromObject(mergedProps, registered, interpolation);
      }

    case 'function':
      {
        if (mergedProps !== undefined) {
          var previousCursor = cursor;
          var result = interpolation(mergedProps);
          cursor = previousCursor;
          return handleInterpolation(mergedProps, registered, result);
        } else {
          console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
        }

        break;
      }

    case 'string':
      {
        var matched = [];
        var replaced = interpolation.replace(animationRegex, function (_match, _p1, p2) {
          var fakeVarName = "animation" + matched.length;
          matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
          return "${" + fakeVarName + "}";
        });

        if (matched.length) {
          console.error("`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\nInstead of doing this:\n\n" + [].concat(matched, ["`" + replaced + "`"]).join('\n') + "\n\nYou should wrap it with `css` like this:\n\ncss`" + replaced + "`");
        }
      }

      break;
  } // finalize string values (regular strings and functions interpolated into css calls)


  var asString = interpolation;

  if (registered == null) {
    return asString;
  }

  var cached = registered[asString];
  return cached !== undefined ? cached : asString;
}

function createStringFromObject(mergedProps, registered, obj) {
  var string = '';

  if (Array.isArray(obj)) {
    for (var i = 0; i < obj.length; i++) {
      string += handleInterpolation(mergedProps, registered, obj[i]) + ";";
    }
  } else {
    for (var key in obj) {
      var value = obj[key];

      if (typeof value !== 'object') {
        var asString = value;

        if (registered != null && registered[asString] !== undefined) {
          string += key + "{" + registered[asString] + "}";
        } else if (isProcessableValue(asString)) {
          string += processStyleName(key) + ":" + processStyleValue(key, asString) + ";";
        }
      } else {
        if (key === 'NO_COMPONENT_SELECTOR' && isDevelopment) {
          throw new Error(noComponentSelectorMessage);
        }

        if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
          for (var _i = 0; _i < value.length; _i++) {
            if (isProcessableValue(value[_i])) {
              string += processStyleName(key) + ":" + processStyleValue(key, value[_i]) + ";";
            }
          }
        } else {
          var interpolated = handleInterpolation(mergedProps, registered, value);

          switch (key) {
            case 'animation':
            case 'animationName':
              {
                string += processStyleName(key) + ":" + interpolated + ";";
                break;
              }

            default:
              {
                if (key === 'undefined') {
                  console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                }

                string += key + "{" + interpolated + "}";
              }
          }
        }
      }
    }
  }

  return string;
}

var labelPattern = /label:\s*([^\s;{]+)\s*(;|$)/g; // this is the cursor for keyframes
// keyframes are stored on the SerializedStyles object as a linked list

var cursor;
function serializeStyles(args, registered, mergedProps) {
  if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
    return args[0];
  }

  var stringMode = true;
  var styles = '';
  cursor = undefined;
  var strings = args[0];

  if (strings == null || strings.raw === undefined) {
    stringMode = false;
    styles += handleInterpolation(mergedProps, registered, strings);
  } else {
    var asTemplateStringsArr = strings;

    if (asTemplateStringsArr[0] === undefined) {
      console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
    }

    styles += asTemplateStringsArr[0];
  } // we start at 1 since we've already handled the first arg


  for (var i = 1; i < args.length; i++) {
    styles += handleInterpolation(mergedProps, registered, args[i]);

    if (stringMode) {
      var templateStringsArr = strings;

      if (templateStringsArr[i] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles += templateStringsArr[i];
    }
  } // using a global regex with .exec is stateful so lastIndex has to be reset each time


  labelPattern.lastIndex = 0;
  var identifierName = '';
  var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

  while ((match = labelPattern.exec(styles)) !== null) {
    identifierName += '-' + match[1];
  }

  var name = (0,_emotion_hash__WEBPACK_IMPORTED_MODULE_0__["default"])(styles) + identifierName;

  {
    var devStyles = {
      name: name,
      styles: styles,
      next: cursor,
      toString: function toString() {
        return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
      }
    };
    return devStyles;
  }
}




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+sheet@1.4.0/node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js":
/*!*******************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+sheet@1.4.0/node_modules/@emotion/sheet/dist/emotion-sheet.development.esm.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyleSheet: () => (/* binding */ StyleSheet)
/* harmony export */ });
var isDevelopment = true;

/*

Based off glamor's StyleSheet, thanks Sunil ❤️

high performance StyleSheet for css-in-js systems

- uses multiple style tags behind the scenes for millions of rules
- uses `insertRule` for appending in production for *much* faster performance

// usage

import { StyleSheet } from '@emotion/sheet'

let styleSheet = new StyleSheet({ key: '', container: document.head })

styleSheet.insert('#box { border: 1px solid red; }')
- appends a css rule into the stylesheet

styleSheet.flush()
- empties the stylesheet of all its contents

*/

function sheetForTag(tag) {
  if (tag.sheet) {
    return tag.sheet;
  } // this weirdness brought to you by firefox

  /* istanbul ignore next */


  for (var i = 0; i < document.styleSheets.length; i++) {
    if (document.styleSheets[i].ownerNode === tag) {
      return document.styleSheets[i];
    }
  } // this function should always return with a value
  // TS can't understand it though so we make it stop complaining here


  return undefined;
}

function createStyleElement(options) {
  var tag = document.createElement('style');
  tag.setAttribute('data-emotion', options.key);

  if (options.nonce !== undefined) {
    tag.setAttribute('nonce', options.nonce);
  }

  tag.appendChild(document.createTextNode(''));
  tag.setAttribute('data-s', '');
  return tag;
}

var StyleSheet = /*#__PURE__*/function () {
  // Using Node instead of HTMLElement since container may be a ShadowRoot
  function StyleSheet(options) {
    var _this = this;

    this._insertTag = function (tag) {
      var before;

      if (_this.tags.length === 0) {
        if (_this.insertionPoint) {
          before = _this.insertionPoint.nextSibling;
        } else if (_this.prepend) {
          before = _this.container.firstChild;
        } else {
          before = _this.before;
        }
      } else {
        before = _this.tags[_this.tags.length - 1].nextSibling;
      }

      _this.container.insertBefore(tag, before);

      _this.tags.push(tag);
    };

    this.isSpeedy = options.speedy === undefined ? !isDevelopment : options.speedy;
    this.tags = [];
    this.ctr = 0;
    this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

    this.key = options.key;
    this.container = options.container;
    this.prepend = options.prepend;
    this.insertionPoint = options.insertionPoint;
    this.before = null;
  }

  var _proto = StyleSheet.prototype;

  _proto.hydrate = function hydrate(nodes) {
    nodes.forEach(this._insertTag);
  };

  _proto.insert = function insert(rule) {
    // the max length is how many rules we have per style tag, it's 65000 in speedy mode
    // it's 1 in dev because we insert source maps that map a single rule to a location
    // and you can only have one source map per style tag
    if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
      this._insertTag(createStyleElement(this));
    }

    var tag = this.tags[this.tags.length - 1];

    {
      var isImportRule = rule.charCodeAt(0) === 64 && rule.charCodeAt(1) === 105;

      if (isImportRule && this._alreadyInsertedOrderInsensitiveRule) {
        // this would only cause problem in speedy mode
        // but we don't want enabling speedy to affect the observable behavior
        // so we report this error at all times
        console.error("You're attempting to insert the following rule:\n" + rule + '\n\n`@import` rules must be before all other types of rules in a stylesheet but other rules have already been inserted. Please ensure that `@import` rules are before all other rules.');
      }

      this._alreadyInsertedOrderInsensitiveRule = this._alreadyInsertedOrderInsensitiveRule || !isImportRule;
    }

    if (this.isSpeedy) {
      var sheet = sheetForTag(tag);

      try {
        // this is the ultrafast version, works across browsers
        // the big drawback is that the css won't be editable in devtools
        sheet.insertRule(rule, sheet.cssRules.length);
      } catch (e) {
        if (!/:(-moz-placeholder|-moz-focus-inner|-moz-focusring|-ms-input-placeholder|-moz-read-write|-moz-read-only|-ms-clear|-ms-expand|-ms-reveal){/.test(rule)) {
          console.error("There was a problem inserting the following rule: \"" + rule + "\"", e);
        }
      }
    } else {
      tag.appendChild(document.createTextNode(rule));
    }

    this.ctr++;
  };

  _proto.flush = function flush() {
    this.tags.forEach(function (tag) {
      var _tag$parentNode;

      return (_tag$parentNode = tag.parentNode) == null ? void 0 : _tag$parentNode.removeChild(tag);
    });
    this.tags = [];
    this.ctr = 0;

    {
      this._alreadyInsertedOrderInsensitiveRule = false;
    }
  };

  return StyleSheet;
}();




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+styled@11.14.1_@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1__@types+react@18.3.24_react@18.3.1/node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js":
/*!**************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+styled@11.14.1_@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1__@types+react@18.3.24_react@18.3.1/node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js ***!
  \**************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createStyled)
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/esm/extends */ "./node_modules/.pnpm/@babel+runtime@7.25.7/node_modules/@babel/runtime/helpers/esm/extends.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _emotion_serialize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/serialize */ "./node_modules/.pnpm/@emotion+serialize@1.3.3/node_modules/@emotion/serialize/dist/emotion-serialize.development.esm.js");
/* harmony import */ var _emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/use-insertion-effect-with-fallbacks */ "./node_modules/.pnpm/@emotion+use-insertion-effect-with-fallbacks@1.2.0_react@18.3.1/node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _emotion_is_prop_valid__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/is-prop-valid */ "./node_modules/.pnpm/@emotion+is-prop-valid@1.4.0/node_modules/@emotion/is-prop-valid/dist/emotion-is-prop-valid.esm.js");








var isDevelopment = true;

var testOmitPropsOnStringTag = _emotion_is_prop_valid__WEBPACK_IMPORTED_MODULE_5__["default"];

var testOmitPropsOnComponent = function testOmitPropsOnComponent(key) {
  return key !== 'theme';
};

var getDefaultShouldForwardProp = function getDefaultShouldForwardProp(tag) {
  return typeof tag === 'string' && // 96 is one less than the char code
  // for "a" so this is checking that
  // it's a lowercase character
  tag.charCodeAt(0) > 96 ? testOmitPropsOnStringTag : testOmitPropsOnComponent;
};
var composeShouldForwardProps = function composeShouldForwardProps(tag, options, isReal) {
  var shouldForwardProp;

  if (options) {
    var optionsShouldForwardProp = options.shouldForwardProp;
    shouldForwardProp = tag.__emotion_forwardProp && optionsShouldForwardProp ? function (propName) {
      return tag.__emotion_forwardProp(propName) && optionsShouldForwardProp(propName);
    } : optionsShouldForwardProp;
  }

  if (typeof shouldForwardProp !== 'function' && isReal) {
    shouldForwardProp = tag.__emotion_forwardProp;
  }

  return shouldForwardProp;
};

var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";

var Insertion = function Insertion(_ref) {
  var cache = _ref.cache,
      serialized = _ref.serialized,
      isStringTag = _ref.isStringTag;
  (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_3__.registerStyles)(cache, serialized, isStringTag);
  (0,_emotion_use_insertion_effect_with_fallbacks__WEBPACK_IMPORTED_MODULE_2__.useInsertionEffectAlwaysWithSyncFallback)(function () {
    return (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_3__.insertStyles)(cache, serialized, isStringTag);
  });

  return null;
};

var createStyled = function createStyled(tag, options) {
  {
    if (tag === undefined) {
      throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
    }
  }

  var isReal = tag.__emotion_real === tag;
  var baseTag = isReal && tag.__emotion_base || tag;
  var identifierName;
  var targetClassName;

  if (options !== undefined) {
    identifierName = options.label;
    targetClassName = options.target;
  }

  var shouldForwardProp = composeShouldForwardProps(tag, options, isReal);
  var defaultShouldForwardProp = shouldForwardProp || getDefaultShouldForwardProp(baseTag);
  var shouldUseAs = !defaultShouldForwardProp('as');
  return function () {
    // eslint-disable-next-line prefer-rest-params
    var args = arguments;
    var styles = isReal && tag.__emotion_styles !== undefined ? tag.__emotion_styles.slice(0) : [];

    if (identifierName !== undefined) {
      styles.push("label:" + identifierName + ";");
    }

    if (args[0] == null || args[0].raw === undefined) {
      // eslint-disable-next-line prefer-spread
      styles.push.apply(styles, args);
    } else {
      var templateStringsArr = args[0];

      if (templateStringsArr[0] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles.push(templateStringsArr[0]);
      var len = args.length;
      var i = 1;

      for (; i < len; i++) {
        if (templateStringsArr[i] === undefined) {
          console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
        }

        styles.push(args[i], templateStringsArr[i]);
      }
    }

    var Styled = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_6__.w)(function (props, cache, ref) {
      var FinalTag = shouldUseAs && props.as || baseTag;
      var className = '';
      var classInterpolations = [];
      var mergedProps = props;

      if (props.theme == null) {
        mergedProps = {};

        for (var key in props) {
          mergedProps[key] = props[key];
        }

        mergedProps.theme = react__WEBPACK_IMPORTED_MODULE_4__.useContext(_emotion_react__WEBPACK_IMPORTED_MODULE_6__.T);
      }

      if (typeof props.className === 'string') {
        className = (0,_emotion_utils__WEBPACK_IMPORTED_MODULE_3__.getRegisteredStyles)(cache.registered, classInterpolations, props.className);
      } else if (props.className != null) {
        className = props.className + " ";
      }

      var serialized = (0,_emotion_serialize__WEBPACK_IMPORTED_MODULE_1__.serializeStyles)(styles.concat(classInterpolations), cache.registered, mergedProps);
      className += cache.key + "-" + serialized.name;

      if (targetClassName !== undefined) {
        className += " " + targetClassName;
      }

      var finalShouldForwardProp = shouldUseAs && shouldForwardProp === undefined ? getDefaultShouldForwardProp(FinalTag) : defaultShouldForwardProp;
      var newProps = {};

      for (var _key in props) {
        if (shouldUseAs && _key === 'as') continue;

        if (finalShouldForwardProp(_key)) {
          newProps[_key] = props[_key];
        }
      }

      newProps.className = className;

      if (ref) {
        newProps.ref = ref;
      }

      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(react__WEBPACK_IMPORTED_MODULE_4__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(Insertion, {
        cache: cache,
        serialized: serialized,
        isStringTag: typeof FinalTag === 'string'
      }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4__.createElement(FinalTag, newProps));
    });
    Styled.displayName = identifierName !== undefined ? identifierName : "Styled(" + (typeof baseTag === 'string' ? baseTag : baseTag.displayName || baseTag.name || 'Component') + ")";
    Styled.defaultProps = tag.defaultProps;
    Styled.__emotion_real = Styled;
    Styled.__emotion_base = baseTag;
    Styled.__emotion_styles = styles;
    Styled.__emotion_forwardProp = shouldForwardProp;
    Object.defineProperty(Styled, 'toString', {
      value: function value() {
        if (targetClassName === undefined && isDevelopment) {
          return 'NO_COMPONENT_SELECTOR';
        }

        return "." + targetClassName;
      }
    });

    Styled.withComponent = function (nextTag, nextOptions) {
      var newStyled = createStyled(nextTag, (0,_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__["default"])({}, options, nextOptions, {
        shouldForwardProp: composeShouldForwardProps(Styled, nextOptions, true)
      }));
      return newStyled.apply(void 0, styles);
    };

    return Styled;
  };
};




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+unitless@0.10.0/node_modules/@emotion/unitless/dist/emotion-unitless.esm.js":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+unitless@0.10.0/node_modules/@emotion/unitless/dist/emotion-unitless.esm.js ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ unitlessKeys)
/* harmony export */ });
var unitlessKeys = {
  animationIterationCount: 1,
  aspectRatio: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  scale: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+use-insertion-effect-with-fallbacks@1.2.0_react@18.3.1/node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+use-insertion-effect-with-fallbacks@1.2.0_react@18.3.1/node_modules/@emotion/use-insertion-effect-with-fallbacks/dist/emotion-use-insertion-effect-with-fallbacks.browser.esm.js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useInsertionEffectAlwaysWithSyncFallback: () => (/* binding */ useInsertionEffectAlwaysWithSyncFallback),
/* harmony export */   useInsertionEffectWithLayoutFallback: () => (/* binding */ useInsertionEffectWithLayoutFallback)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


var syncFallback = function syncFallback(create) {
  return create();
};

var useInsertionEffect = react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] ? react__WEBPACK_IMPORTED_MODULE_0__['useInsertion' + 'Effect'] : false;
var useInsertionEffectAlwaysWithSyncFallback = useInsertionEffect || syncFallback;
var useInsertionEffectWithLayoutFallback = useInsertionEffect || react__WEBPACK_IMPORTED_MODULE_0__.useLayoutEffect;




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRegisteredStyles: () => (/* binding */ getRegisteredStyles),
/* harmony export */   insertStyles: () => (/* binding */ insertStyles),
/* harmony export */   registerStyles: () => (/* binding */ registerStyles)
/* harmony export */ });
var isBrowser = true;

function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = '';
  classNames.split(' ').forEach(function (className) {
    if (registered[className] !== undefined) {
      registeredStyles.push(registered[className] + ";");
    } else if (className) {
      rawClassName += className + " ";
    }
  });
  return rawClassName;
}
var registerStyles = function registerStyles(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;

  if ( // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (isStringTag === false || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  isBrowser === false ) && cache.registered[className] === undefined) {
    cache.registered[className] = serialized.styles;
  }
};
var insertStyles = function insertStyles(cache, serialized, isStringTag) {
  registerStyles(cache, serialized, isStringTag);
  var className = cache.key + "-" + serialized.name;

  if (cache.inserted[serialized.name] === undefined) {
    var current = serialized;

    do {
      cache.insert(serialized === current ? "." + className : '', current, cache.sheet, true);

      current = current.next;
    } while (current !== undefined);
  }
};




/***/ }),

/***/ "./node_modules/.pnpm/@emotion+weak-memoize@0.4.0/node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js":
/*!****************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@emotion+weak-memoize@0.4.0/node_modules/@emotion/weak-memoize/dist/emotion-weak-memoize.esm.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ weakMemoize)
/* harmony export */ });
var weakMemoize = function weakMemoize(func) {
  var cache = new WeakMap();
  return function (arg) {
    if (cache.has(arg)) {
      // Use non-null assertion because we just checked that the cache `has` it
      // This allows us to remove `undefined` from the return value
      return cache.get(arg);
    }

    var ret = func(arg);
    cache.set(arg, ret);
    return ret;
  };
};




/***/ }),

/***/ "./node_modules/.pnpm/@floating-ui+core@1.7.3/node_modules/@floating-ui/core/dist/floating-ui.core.mjs":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@floating-ui+core@1.7.3/node_modules/@floating-ui/core/dist/floating-ui.core.mjs ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   rectToClientRect: () => (/* reexport safe */ _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ "./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");



function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
  const alignmentAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
  const alignLength = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(alignmentAxis);
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const isVertical = sideAxis === 'y';
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement)) {
    case 'start':
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
  const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    x,
    y,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements,
      middlewareData
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
    const coords = {
      x,
      y
    };
    const axis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
    const length = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. To ensure `shift()` continues to take action,
    // a single reset is performed when this is true.
    const shouldAddOffset = !middlewareData.arrow && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset - alignmentOffset,
        ...(shouldAddOffset && {
          alignmentOffset
        })
      },
      reset: shouldAddOffset
    };
  }
});

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment), ...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) !== alignment)] : allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment || (autoAlignment ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAlignmentPlacement)(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const placements$1 = alignment !== undefined || allowedPlacements === _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements$1[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const alignmentSides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements$1[0]
          }
        };
      }
      const currentOverflows = [overflow[(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements$1[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

      // If a reset by the arrow was caused due to an alignment offset being
      // added, we should skip any logic now since `flip()` has already done its
      // work.
      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const initialSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(initialPlacement);
      const isBasePlacement = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositePlacement)(initialPlacement)] : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getExpandedPlacements)(initialPlacement));
      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== 'none';
      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
        fallbackPlacements.push(...(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxisPlacements)(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          const ignoreCrossAxisOverflow = checkCrossAxis === 'alignment' ? initialSideAxis !== (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(nextPlacement) : false;
          if (!ignoreCrossAxisOverflow ||
          // We leave the current main axis only if every placement on that axis
          // overflows the main axis.
          overflowsData.every(d => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement) === initialSideAxis ? d.overflows[0] > 0 : true)) {
            // Try next placement and re-run the lifecycle.
            return {
              data: {
                index: nextIndex,
                overflows: overflowsData
              },
              reset: {
                placement: nextPlacement
              }
            };
          }
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$filter2;
                const placement = (_overflowsData$filter2 = overflowsData.filter(d => {
                  if (hasFallbackAxisSideDirection) {
                    const currentSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement);
                    return currentSideAxis === initialSideAxis ||
                    // Create a bias to the `y` side axis due to horizontal
                    // reading directions favoring greater width.
                    currentSideAxis === 'y';
                  }
                  return true;
                }).map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.left));
  const minY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.top));
  const maxX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.right));
  const maxY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(nativeClientRects));
      const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'left';
          const maxRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...clientRects.map(rect => rect.right));
          const minLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

const originSides = /*#__PURE__*/new Set(['left', 'top']);

// For type backwards-compatibility, the `OffsetOptions` type was also
// Derivable.

async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
  const isVertical = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
  const mainAxisMulti = originSides.has(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: rawValue.mainAxis || 0,
    crossAxis: rawValue.crossAxis || 0,
    alignmentAxis: rawValue.alignmentAxis
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);

      // If the placement is the same and the arrow caused an alignment offset
      // then we don't need to change the positioning coordinates.
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y,
          enabled: {
            [mainAxis]: checkMainAxis,
            [crossAxis]: checkCrossAxis
          }
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = originSides.has((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      var _state$middlewareData, _state$middlewareData2;
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
      const isYAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const maximumClippingHeight = height - overflow.top - overflow.bottom;
      const maximumClippingWidth = width - overflow.left - overflow.right;
      const overflowAvailableHeight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(height - overflow[heightSide], maximumClippingHeight);
      const overflowAvailableWidth = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(width - overflow[widthSide], maximumClippingWidth);
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) {
        availableWidth = maximumClippingWidth;
      }
      if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) {
        availableHeight = maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, 0);
        const xMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.right, 0);
        const yMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, 0);
        const yMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};




/***/ }),

/***/ "./node_modules/.pnpm/@floating-ui+dom@1.7.4/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@floating-ui+dom@1.7.4/node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   autoUpdate: () => (/* binding */ autoUpdate),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   platform: () => (/* binding */ platform),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/utils */ "./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/core */ "./node_modules/.pnpm/@floating-ui+core@1.7.3/node_modules/@floating-ui/core/dist/floating-ui.core.mjs");
/* harmony import */ var _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils/dom */ "./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs");





function getCssDimensions(element) {
  const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(width) !== offsetWidth || (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}

function unwrapElement(element) {
  return !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.contextElement : element;
}

function getScale(element) {
  const domElement = unwrapElement(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(domElement)) {
    return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(rect.width) : rect.width) / width;
  let y = ($ ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

const noOffsets = /*#__PURE__*/(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);
function getVisualOffsets(element) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isWebKit)() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element)) {
    return false;
  }
  return isFixed;
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);
  if (includeScale) {
    if (offsetParent) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(domElement);
    const offsetWin = offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(offsetParent) ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getFrameElement)(currentWin);
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(currentIFrame);
      currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getFrameElement)(currentWin);
    }
  }
  return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.rectToClientRect)({
    width,
    height,
    x,
    y
  });
}

// If <html> has a CSS width greater than the viewport, then this will be
// incorrect for RTL.
function getWindowScrollBarX(element, rect) {
  const leftScroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(element).scrollLeft;
  if (!rect) {
    return getBoundingClientRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element)).left + leftScroll;
  }
  return rect.left + leftScroll;
}

function getHTMLOffset(documentElement, scroll) {
  const htmlRect = documentElement.getBoundingClientRect();
  const x = htmlRect.left + scroll.scrollLeft - getWindowScrollBarX(documentElement, htmlRect);
  const y = htmlRect.top + scroll.scrollTop;
  return {
    x,
    y
  };
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === 'fixed';
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(offsetParent);
  const topLayer = elements ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);
  const offsets = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(offsetParent);
    }
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y
  };
}

function getClientRects(element) {
  return Array.from(element.getClientRects());
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);
  const scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(element);
  const body = element.ownerDocument.body;
  const width = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(body).direction === 'rtl') {
    x += (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Safety check: ensure the scrollbar space is reasonable in case this
// calculation is affected by unusual styles.
// Most scrollbars leave 15-18px of space.
const SCROLLBAR_MAX = 25;
function getViewportRect(element, strategy) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isWebKit)();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  const windowScrollbarX = getWindowScrollBarX(html);
  // <html> `overflow: hidden` + `scrollbar-gutter: stable` reduces the
  // visual width of the <html> but this is not considered in the size
  // of `html.clientWidth`.
  if (windowScrollbarX <= 0) {
    const doc = html.ownerDocument;
    const body = doc.body;
    const bodyStyles = getComputedStyle(body);
    const bodyMarginInline = doc.compatMode === 'CSS1Compat' ? parseFloat(bodyStyles.marginLeft) + parseFloat(bodyStyles.marginRight) || 0 : 0;
    const clippingStableScrollbarWidth = Math.abs(html.clientWidth - body.clientWidth - bodyMarginInline);
    if (clippingStableScrollbarWidth <= SCROLLBAR_MAX) {
      width -= clippingStableScrollbarWidth;
    }
  } else if (windowScrollbarX <= SCROLLBAR_MAX) {
    // If the <body> scrollbar is on the left, the width needs to be extended
    // by the scrollbar amount so there isn't extra space on the right.
    width += windowScrollbarX;
  }
  return {
    width,
    height,
    x,
    y
  };
}

const absoluteOrFixed = /*#__PURE__*/new Set(['absolute', 'fixed']);
// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) ? getScale(element) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element));
  } else if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y,
      width: clippingAncestor.width,
      height: clippingAncestor.height
    };
  }
  return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.rectToClientRect)(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element);
  if (parentNode === stopNode || !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(parentNode) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(parentNode)) {
    return false;
  }
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(element, [], false).filter(el => (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(el) && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === 'fixed';
  let currentNode = elementIsFixed ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(currentNode) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(currentNode)) {
    const computedStyle = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(currentNode);
    const currentNodeIsContaining = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isContainingBlock)(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(rect.top, accRect.top);
    accRect.right = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent);
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);

  // If the <body> scrollbar appears on the left (e.g. RTL systems). Use
  // Firefox with layout.scrollbar.side = 3 in about:config to test this.
  function setLeftRTLScrollbarOffset() {
    offsets.x = getWindowScrollBarX(documentElement);
  }
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      setLeftRTLScrollbarOffset();
    }
  }
  if (isFixed && !isOffsetParentAnElement && documentElement) {
    setLeftRTLScrollbarOffset();
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);
  const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;
  const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}

function isStaticPositioned(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === 'static';
}

function getTrueOffsetParent(element, polyfill) {
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  let rawOffsetParent = element.offsetParent;

  // Firefox returns the <html> element as the offsetParent if it's non-static,
  // while Chrome and Safari return the <body> element. The <body> element must
  // be used to perform the correct calculations even if the <html> element is
  // non-static.
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element) === rawOffsetParent) {
    rawOffsetParent = rawOffsetParent.ownerDocument.body;
  }
  return rawOffsetParent;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(element)) {
    return win;
  }
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    let svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element);
    while (svgOffsetParent && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(svgOffsetParent)) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTableElement)(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(offsetParent) && isStaticPositioned(offsetParent) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isContainingBlock)(offsetParent)) {
    return win;
  }
  return offsetParent || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getContainingBlock)(element) || win;
}

const getElementRects = async function (data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};

function isRTL(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).direction === 'rtl';
}

const platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement,
  isRTL
};

function rectsAreEqual(a, b) {
  return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
}

// https://samthor.au/2021/observing-dom/
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const elementRectForRootMargin = element.getBoundingClientRect();
    const {
      left,
      top,
      width,
      height
    } = elementRectForRootMargin;
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(top);
    const insetRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(root.clientWidth - (left + width));
    const insetBottom = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(root.clientHeight - (top + height));
    const insetLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(0, (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          // If the reference is clipped, the ratio is 0. Throttle the refresh
          // to prevent an infinite loop of updates.
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1000);
        } else {
          refresh(false, ratio);
        }
      }
      if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {
        // It's possible that even though the ratio is reported as 1, the
        // element is not actually fully within the IntersectionObserver's root
        // area anymore. This can happen under performance constraints. This may
        // be a bug in the browser's IntersectionObserver implementation. To
        // work around this, we compare the element's bounding rect now with
        // what it was at the time we created the IntersectionObserver. If they
        // are not equal then the element moved, so we refresh.
        refresh();
      }
      isFirstUpdate = false;
    }

    // Older browsers don't support a `document` as the root and will throw an
    // error.
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (_e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === 'function',
    layoutShift = typeof IntersectionObserver === 'function',
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...(referenceEl ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(referenceEl) : []), ...(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(floating)] : [];
  ancestors.forEach(ancestor => {
    ancestorScroll && ancestor.addEventListener('scroll', update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver(_ref => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        // Prevent update loops when using the `size` middleware.
        // https://github.com/floating-ui/floating-ui/issues/1740
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
const detectOverflow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.detectOverflow;

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.offset;

/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.autoPlacement;

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.shift;

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.flip;

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.size;

/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.hide;

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.arrow;

/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.inline;

/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.limitShift;

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.computePosition)(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};




/***/ }),

/***/ "./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs":
/*!*********************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getComputedStyle: () => (/* binding */ getComputedStyle),
/* harmony export */   getContainingBlock: () => (/* binding */ getContainingBlock),
/* harmony export */   getDocumentElement: () => (/* binding */ getDocumentElement),
/* harmony export */   getFrameElement: () => (/* binding */ getFrameElement),
/* harmony export */   getNearestOverflowAncestor: () => (/* binding */ getNearestOverflowAncestor),
/* harmony export */   getNodeName: () => (/* binding */ getNodeName),
/* harmony export */   getNodeScroll: () => (/* binding */ getNodeScroll),
/* harmony export */   getOverflowAncestors: () => (/* binding */ getOverflowAncestors),
/* harmony export */   getParentNode: () => (/* binding */ getParentNode),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   isContainingBlock: () => (/* binding */ isContainingBlock),
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isLastTraversableNode: () => (/* binding */ isLastTraversableNode),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   isOverflowElement: () => (/* binding */ isOverflowElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot),
/* harmony export */   isTableElement: () => (/* binding */ isTableElement),
/* harmony export */   isTopLayer: () => (/* binding */ isTopLayer),
/* harmony export */   isWebKit: () => (/* binding */ isWebKit)
/* harmony export */ });
function hasWindow() {
  return typeof window !== 'undefined';
}
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || '').toLowerCase();
  }
  // Mocked nodes in testing environments may not be instances of Node. By
  // returning `#document` an infinite loop won't occur.
  // https://github.com/floating-ui/floating-ui/issues/2317
  return '#document';
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (!hasWindow() || typeof ShadowRoot === 'undefined') {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
const invalidOverflowDisplayValues = /*#__PURE__*/new Set(['inline', 'contents']);
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);
}
const tableElements = /*#__PURE__*/new Set(['table', 'td', 'th']);
function isTableElement(element) {
  return tableElements.has(getNodeName(element));
}
const topLayerSelectors = [':popover-open', ':modal'];
function isTopLayer(element) {
  return topLayerSelectors.some(selector => {
    try {
      return element.matches(selector);
    } catch (_e) {
      return false;
    }
  });
}
const transformProperties = ['transform', 'translate', 'scale', 'rotate', 'perspective'];
const willChangeValues = ['transform', 'translate', 'scale', 'rotate', 'perspective', 'filter'];
const containValues = ['paint', 'layout', 'strict', 'content'];
function isContainingBlock(elementOrCss) {
  const webkit = isWebKit();
  const css = isElement(elementOrCss) ? getComputedStyle(elementOrCss) : elementOrCss;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  // https://drafts.csswg.org/css-transforms-2/#individual-transforms
  return transformProperties.some(value => css[value] ? css[value] !== 'none' : false) || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || willChangeValues.some(value => (css.willChange || '').includes(value)) || containValues.some(value => (css.contain || '').includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else if (isTopLayer(currentNode)) {
      return null;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
const lastTraversableNodeNames = /*#__PURE__*/new Set(['html', 'body', '#document']);
function isLastTraversableNode(node) {
  return lastTraversableNodeNames.has(getNodeName(node));
}
function getComputedStyle(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    const frameElement = getFrameElement(win);
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}




/***/ }),

/***/ "./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs":
/*!*****************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@floating-ui+utils@0.2.10/node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs ***!
  \*****************************************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   alignments: () => (/* binding */ alignments),
/* harmony export */   clamp: () => (/* binding */ clamp),
/* harmony export */   createCoords: () => (/* binding */ createCoords),
/* harmony export */   evaluate: () => (/* binding */ evaluate),
/* harmony export */   expandPaddingObject: () => (/* binding */ expandPaddingObject),
/* harmony export */   floor: () => (/* binding */ floor),
/* harmony export */   getAlignment: () => (/* binding */ getAlignment),
/* harmony export */   getAlignmentAxis: () => (/* binding */ getAlignmentAxis),
/* harmony export */   getAlignmentSides: () => (/* binding */ getAlignmentSides),
/* harmony export */   getAxisLength: () => (/* binding */ getAxisLength),
/* harmony export */   getExpandedPlacements: () => (/* binding */ getExpandedPlacements),
/* harmony export */   getOppositeAlignmentPlacement: () => (/* binding */ getOppositeAlignmentPlacement),
/* harmony export */   getOppositeAxis: () => (/* binding */ getOppositeAxis),
/* harmony export */   getOppositeAxisPlacements: () => (/* binding */ getOppositeAxisPlacements),
/* harmony export */   getOppositePlacement: () => (/* binding */ getOppositePlacement),
/* harmony export */   getPaddingObject: () => (/* binding */ getPaddingObject),
/* harmony export */   getSide: () => (/* binding */ getSide),
/* harmony export */   getSideAxis: () => (/* binding */ getSideAxis),
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   rectToClientRect: () => (/* binding */ rectToClientRect),
/* harmony export */   round: () => (/* binding */ round),
/* harmony export */   sides: () => (/* binding */ sides)
/* harmony export */ });
/**
 * Custom positioning reference element.
 * @see https://floating-ui.com/docs/virtual-elements
 */

const sides = ['top', 'right', 'bottom', 'left'];
const alignments = ['start', 'end'];
const placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
const min = Math.min;
const max = Math.max;
const round = Math.round;
const floor = Math.floor;
const createCoords = v => ({
  x: v,
  y: v
});
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function clamp(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getOppositeAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}
function getAxisLength(axis) {
  return axis === 'y' ? 'height' : 'width';
}
const yAxisSides = /*#__PURE__*/new Set(['top', 'bottom']);
function getSideAxis(placement) {
  return yAxisSides.has(getSide(placement)) ? 'y' : 'x';
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
const lrPlacement = ['left', 'right'];
const rlPlacement = ['right', 'left'];
const tbPlacement = ['top', 'bottom'];
const btPlacement = ['bottom', 'top'];
function getSideList(side, isStart, rtl) {
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rlPlacement : lrPlacement;
      return isStart ? lrPlacement : rlPlacement;
    case 'left':
    case 'right':
      return isStart ? tbPlacement : btPlacement;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y,
    left: x,
    right: x + width,
    bottom: y + height,
    x,
    y
  };
}




/***/ }),

/***/ "./node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ compile)
/* harmony export */ });
/* harmony import */ var _tannin_postfix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/postfix */ "./node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js");
/* harmony import */ var _tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @tannin/evaluate */ "./node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js");



/**
 * Given a C expression, returns a function which can be called to evaluate its
 * result.
 *
 * @example
 *
 * ```js
 * import compile from '@tannin/compile';
 *
 * const evaluate = compile( 'n > 1' );
 *
 * evaluate( { n: 2 } );
 * // ⇒ true
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {(variables?:{[variable:string]:*})=>*} Compiled evaluator.
 */
function compile( expression ) {
	var terms = (0,_tannin_postfix__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( variables ) {
		return (0,_tannin_evaluate__WEBPACK_IMPORTED_MODULE_1__["default"])( terms, variables );
	};
}


/***/ }),

/***/ "./node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/.pnpm/@tannin+evaluate@1.2.0/node_modules/@tannin/evaluate/index.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ evaluate)
/* harmony export */ });
/**
 * Operator callback functions.
 *
 * @type {Object}
 */
var OPERATORS = {
	'!': function( a ) {
		return ! a;
	},
	'*': function( a, b ) {
		return a * b;
	},
	'/': function( a, b ) {
		return a / b;
	},
	'%': function( a, b ) {
		return a % b;
	},
	'+': function( a, b ) {
		return a + b;
	},
	'-': function( a, b ) {
		return a - b;
	},
	'<': function( a, b ) {
		return a < b;
	},
	'<=': function( a, b ) {
		return a <= b;
	},
	'>': function( a, b ) {
		return a > b;
	},
	'>=': function( a, b ) {
		return a >= b;
	},
	'==': function( a, b ) {
		return a === b;
	},
	'!=': function( a, b ) {
		return a !== b;
	},
	'&&': function( a, b ) {
		return a && b;
	},
	'||': function( a, b ) {
		return a || b;
	},
	'?:': function( a, b, c ) {
		if ( a ) {
			throw b;
		}

		return c;
	},
};

/**
 * Given an array of postfix terms and operand variables, returns the result of
 * the postfix evaluation.
 *
 * @example
 *
 * ```js
 * import evaluate from '@tannin/evaluate';
 *
 * // 3 + 4 * 5 / 6 ⇒ '3 4 5 * 6 / +'
 * const terms = [ '3', '4', '5', '*', '6', '/', '+' ];
 *
 * evaluate( terms, {} );
 * // ⇒ 6.333333333333334
 * ```
 *
 * @param {string[]} postfix   Postfix terms.
 * @param {Object}   variables Operand variables.
 *
 * @return {*} Result of evaluation.
 */
function evaluate( postfix, variables ) {
	var stack = [],
		i, j, args, getOperatorResult, term, value;

	for ( i = 0; i < postfix.length; i++ ) {
		term = postfix[ i ];

		getOperatorResult = OPERATORS[ term ];
		if ( getOperatorResult ) {
			// Pop from stack by number of function arguments.
			j = getOperatorResult.length;
			args = Array( j );
			while ( j-- ) {
				args[ j ] = stack.pop();
			}

			try {
				value = getOperatorResult.apply( null, args );
			} catch ( earlyReturn ) {
				return earlyReturn;
			}
		} else if ( variables.hasOwnProperty( term ) ) {
			value = variables[ term ];
		} else {
			value = +term;
		}

		stack.push( value );
	}

	return stack[ 0 ];
}


/***/ }),

/***/ "./node_modules/.pnpm/@tannin+plural-forms@1.1.0/node_modules/@tannin/plural-forms/index.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@tannin+plural-forms@1.1.0/node_modules/@tannin/plural-forms/index.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ pluralForms)
/* harmony export */ });
/* harmony import */ var _tannin_compile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @tannin/compile */ "./node_modules/.pnpm/@tannin+compile@1.1.0/node_modules/@tannin/compile/index.js");


/**
 * Given a C expression, returns a function which, when called with a value,
 * evaluates the result with the value assumed to be the "n" variable of the
 * expression. The result will be coerced to its numeric equivalent.
 *
 * @param {string} expression C expression.
 *
 * @return {Function} Evaluator function.
 */
function pluralForms( expression ) {
	var evaluate = (0,_tannin_compile__WEBPACK_IMPORTED_MODULE_0__["default"])( expression );

	return function( n ) {
		return +evaluate( { n: n } );
	};
}


/***/ }),

/***/ "./node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/.pnpm/@tannin+postfix@1.1.0/node_modules/@tannin/postfix/index.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ postfix)
/* harmony export */ });
var PRECEDENCE, OPENERS, TERMINATORS, PATTERN;

/**
 * Operator precedence mapping.
 *
 * @type {Object}
 */
PRECEDENCE = {
	'(': 9,
	'!': 8,
	'*': 7,
	'/': 7,
	'%': 7,
	'+': 6,
	'-': 6,
	'<': 5,
	'<=': 5,
	'>': 5,
	'>=': 5,
	'==': 4,
	'!=': 4,
	'&&': 3,
	'||': 2,
	'?': 1,
	'?:': 1,
};

/**
 * Characters which signal pair opening, to be terminated by terminators.
 *
 * @type {string[]}
 */
OPENERS = [ '(', '?' ];

/**
 * Characters which signal pair termination, the value an array with the
 * opener as its first member. The second member is an optional operator
 * replacement to push to the stack.
 *
 * @type {string[]}
 */
TERMINATORS = {
	')': [ '(' ],
	':': [ '?', '?:' ],
};

/**
 * Pattern matching operators and openers.
 *
 * @type {RegExp}
 */
PATTERN = /<=|>=|==|!=|&&|\|\||\?:|\(|!|\*|\/|%|\+|-|<|>|\?|\)|:/;

/**
 * Given a C expression, returns the equivalent postfix (Reverse Polish)
 * notation terms as an array.
 *
 * If a postfix string is desired, simply `.join( ' ' )` the result.
 *
 * @example
 *
 * ```js
 * import postfix from '@tannin/postfix';
 *
 * postfix( 'n > 1' );
 * // ⇒ [ 'n', '1', '>' ]
 * ```
 *
 * @param {string} expression C expression.
 *
 * @return {string[]} Postfix terms.
 */
function postfix( expression ) {
	var terms = [],
		stack = [],
		match, operator, term, element;

	while ( ( match = expression.match( PATTERN ) ) ) {
		operator = match[ 0 ];

		// Term is the string preceding the operator match. It may contain
		// whitespace, and may be empty (if operator is at beginning).
		term = expression.substr( 0, match.index ).trim();
		if ( term ) {
			terms.push( term );
		}

		while ( ( element = stack.pop() ) ) {
			if ( TERMINATORS[ operator ] ) {
				if ( TERMINATORS[ operator ][ 0 ] === element ) {
					// Substitution works here under assumption that because
					// the assigned operator will no longer be a terminator, it
					// will be pushed to the stack during the condition below.
					operator = TERMINATORS[ operator ][ 1 ] || operator;
					break;
				}
			} else if ( OPENERS.indexOf( element ) >= 0 || PRECEDENCE[ element ] < PRECEDENCE[ operator ] ) {
				// Push to stack if either an opener or when pop reveals an
				// element of lower precedence.
				stack.push( element );
				break;
			}

			// For each popped from stack, push to terms.
			terms.push( element );
		}

		if ( ! TERMINATORS[ operator ] ) {
			stack.push( operator );
		}

		// Slice matched fragment from expression to continue match.
		expression = expression.substr( match.index + operator.length );
	}

	// Push remainder of operand, if exists, to terms.
	expression = expression.trim();
	if ( expression ) {
		terms.push( expression );
	}

	// Pop remaining items from stack into terms.
	return terms.concat( stack.reverse() );
}


/***/ }),

/***/ "./node_modules/.pnpm/@tannin+sprintf@1.3.3/node_modules/@tannin/sprintf/src/index.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/.pnpm/@tannin+sprintf@1.3.3/node_modules/@tannin/sprintf/src/index.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sprintf)
/* harmony export */ });
/**
 * Regular expression matching format placeholder syntax.
 *
 * The pattern for matching named arguments is a naive and incomplete matcher
 * against valid JavaScript identifier names.
 *
 * via Mathias Bynens:
 *
 * >An identifier must start with $, _, or any character in the Unicode
 * >categories “Uppercase letter (Lu)”, “Lowercase letter (Ll)”, “Titlecase
 * >letter (Lt)”, “Modifier letter (Lm)”, “Other letter (Lo)”, or “Letter
 * >number (Nl)”.
 * >
 * >The rest of the string can contain the same characters, plus any U+200C zero
 * >width non-joiner characters, U+200D zero width joiner characters, and
 * >characters in the Unicode categories “Non-spacing mark (Mn)”, “Spacing
 * >combining mark (Mc)”, “Decimal digit number (Nd)”, or “Connector
 * >punctuation (Pc)”.
 *
 * If browser support is constrained to those supporting ES2015, this could be
 * made more accurate using the `u` flag:
 *
 * ```
 * /^[$_\p{L}\p{Nl}][$_\p{L}\p{Nl}\u200C\u200D\p{Mn}\p{Mc}\p{Nd}\p{Pc}]*$/u;
 * ```
 *
 * @see http://www.pixelbeat.org/programming/gcc/format_specs.html
 * @see https://mathiasbynens.be/notes/javascript-identifiers#valid-identifier-names
 *
 * @type {RegExp}
 */
var PATTERN =
	/%(((\d+)\$)|(\(([$_a-zA-Z][$_a-zA-Z0-9]*)\)))?[ +0#-]*\d*(\.(\d+|\*))?(ll|[lhqL])?([cduxXefgsp%])/g;
//               ▲         ▲                    ▲       ▲  ▲            ▲           ▲ type
//               │         │                    │       │  │            └ Length (unsupported)
//               │         │                    │       │  └ Precision / max width
//               │         │                    │       └ Min width (unsupported)
//               │         │                    └ Flags (unsupported)
//               └ Index   └ Name (for named arguments)
/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @overload
 * @param {T} string - string printf format string
 * @param {...import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */

/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @overload
 * @param {T} string - string printf format string
 * @param {import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */

/**
 * Given a format string, returns string with arguments interpolatation.
 * Arguments can either be provided directly via function arguments spread, or
 * with an array as the second argument.
 *
 * @see https://en.wikipedia.org/wiki/Printf_format_string
 *
 * @example
 *
 * ```js
 * import sprintf from '@tannin/sprintf';
 *
 * sprintf( 'Hello %s!', 'world' );
 * // ⇒ 'Hello world!'
 * ```
 * @template {string} T
 * @param {T} string - string printf format string
 * @param {...import('../types').SprintfArgs<T>} args - arguments to interpolate
 *
 * @return {string} Formatted string.
 */
function sprintf(string, ...args) {
	var i = 0;
	if (Array.isArray(args[0])) {
		args = /** @type {import('../types').SprintfArgs<T>[]} */ (
			/** @type {unknown} */ args[0]
		);
	}

	return string.replace(PATTERN, function () {
		var index,
			// name needs to be documented as `string | undefined` else value will have tpye unknown.
			/**
			 * Name of the argument to substitute, if any.
			 *
			 * @type {string | undefined}
			 */
			name,
			precision,
			type,
			value;

		index = arguments[3];
		name = arguments[5];
		precision = arguments[7];
		type = arguments[9];

		// There's no placeholder substitution in the explicit "%", meaning it
		// is not necessary to increment argument index.
		if (type === '%') {
			return '%';
		}

		// Asterisk precision determined by peeking / shifting next argument.
		if (precision === '*') {
			precision = args[i];
			i++;
		}

		if (name === undefined) {
			// If not a positional argument, use counter value.
			if (index === undefined) {
				index = i + 1;
			}

			i++;

			// Positional argument.
			value = args[index - 1];
		} else if (
			args[0] &&
			typeof args[0] === 'object' &&
			args[0].hasOwnProperty(name)
		) {
			// If it's a named argument, use name.
			value = args[0][name];
		}

		// Parse as type.
		if (type === 'f') {
			value = parseFloat(value) || 0;
		} else if (type === 'd') {
			value = parseInt(value) || 0;
		}

		// Apply precision.
		if (precision !== undefined) {
			if (type === 'f') {
				value = value.toFixed(precision);
			} else if (type === 's') {
				value = value.substr(0, precision);
			}
		}

		// To avoid "undefined" concatenation, return empty string if no
		// placeholder substitution can be performed.
		return value !== undefined && value !== null ? value : '';
	});
}


/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/index.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/index.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setup: () => (/* binding */ setup),
/* harmony export */   speak: () => (/* reexport safe */ _shared_index__WEBPACK_IMPORTED_MODULE_2__.speak)
/* harmony export */ });
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/dom-ready */ "./node_modules/.pnpm/@wordpress+dom-ready@4.30.0/node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _script_add_container__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./script/add-container */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-container.js");
/* harmony import */ var _script_add_intro_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./script/add-intro-text */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-intro-text.js");
/* harmony import */ var _shared_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/index */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/index.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




/**
 * Create the live regions.
 */
function setup() {
  const introText = document.getElementById('a11y-speak-intro-text');
  const containerAssertive = document.getElementById('a11y-speak-assertive');
  const containerPolite = document.getElementById('a11y-speak-polite');
  if (introText === null) {
    (0,_script_add_intro_text__WEBPACK_IMPORTED_MODULE_1__["default"])();
  }
  if (containerAssertive === null) {
    (0,_script_add_container__WEBPACK_IMPORTED_MODULE_0__["default"])('assertive');
  }
  if (containerPolite === null) {
    (0,_script_add_container__WEBPACK_IMPORTED_MODULE_0__["default"])('polite');
  }
}

/**
 * Run setup on domReady.
 */
(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_3__["default"])(setup);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-container.js":
/*!*********************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-container.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ addContainer)
/* harmony export */ });
/**
 * Build the live regions markup.
 *
 * @param {'polite'|'assertive'} [ariaLive] Value for the 'aria-live' attribute; default: 'polite'.
 *
 * @return {HTMLDivElement} The ARIA live region HTML element.
 */
function addContainer(ariaLive = 'polite') {
  const container = document.createElement('div');
  container.id = `a11y-speak-${ariaLive}`;
  container.className = 'a11y-speak-region';
  container.setAttribute('style', 'position:absolute;' + 'margin:-1px;' + 'padding:0;' + 'height:1px;' + 'width:1px;' + 'overflow:hidden;' + 'clip-path:inset(50%);' + 'border:0;' + 'word-wrap:normal !important;');
  container.setAttribute('aria-live', ariaLive);
  container.setAttribute('aria-relevant', 'additions text');
  container.setAttribute('aria-atomic', 'true');
  const {
    body
  } = document;
  if (body) {
    body.appendChild(container);
  }
  return container;
}
//# sourceMappingURL=add-container.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-intro-text.js":
/*!**********************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/script/add-intro-text.js ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ addIntroText)
/* harmony export */ });
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/.pnpm/@wordpress+i18n@6.3.0/node_modules/@wordpress/i18n/build-module/index.js");
/**
 * WordPress dependencies
 */


/**
 * Build the explanatory text to be placed before the aria live regions.
 *
 * This text is initially hidden from assistive technologies by using a `hidden`
 * HTML attribute which is then removed once a message fills the aria-live regions.
 *
 * @return {HTMLParagraphElement} The explanatory text HTML element.
 */
function addIntroText() {
  const introText = document.createElement('p');
  introText.id = 'a11y-speak-intro-text';
  introText.className = 'a11y-speak-intro-text';
  introText.textContent = (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_0__.__)('Notifications');
  introText.setAttribute('style', 'position:absolute;' + 'margin:-1px;' + 'padding:0;' + 'height:1px;' + 'width:1px;' + 'overflow:hidden;' + 'clip-path:inset(50%);' + 'border:0;' + 'word-wrap:normal !important;');
  introText.setAttribute('hidden', '');
  const {
    body
  } = document;
  if (body) {
    body.appendChild(introText);
  }
  return introText;
}
//# sourceMappingURL=add-intro-text.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/clear.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/clear.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ clear)
/* harmony export */ });
/**
 * Clears the a11y-speak-region elements and hides the explanatory text.
 */
function clear() {
  const regions = document.getElementsByClassName('a11y-speak-region');
  const introText = document.getElementById('a11y-speak-intro-text');
  for (let i = 0; i < regions.length; i++) {
    regions[i].textContent = '';
  }

  // Make sure the explanatory text is hidden from assistive technologies.
  if (introText) {
    introText.setAttribute('hidden', 'hidden');
  }
}
//# sourceMappingURL=clear.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/filter-message.js":
/*!**********************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/filter-message.js ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ filterMessage)
/* harmony export */ });
let previousMessage = '';

/**
 * Filter the message to be announced to the screenreader.
 *
 * @param {string} message The message to be announced.
 *
 * @return {string} The filtered message.
 */
function filterMessage(message) {
  /*
   * Strip HTML tags (if any) from the message string. Ideally, messages should
   * be simple strings, carefully crafted for specific use with A11ySpeak.
   * When re-using already existing strings this will ensure simple HTML to be
   * stripped out and replaced with a space. Browsers will collapse multiple
   * spaces natively.
   */
  message = message.replace(/<[^<>]+>/g, ' ');

  /*
   * Safari + VoiceOver don't announce repeated, identical strings. We use
   * a `no-break space` to force them to think identical strings are different.
   */
  if (previousMessage === message) {
    message += '\u00A0';
  }
  previousMessage = message;
  return message;
}
//# sourceMappingURL=filter-message.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/index.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/index.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   speak: () => (/* binding */ speak)
/* harmony export */ });
/* harmony import */ var _clear__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./clear */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/clear.js");
/* harmony import */ var _filter_message__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filter-message */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/shared/filter-message.js");
/**
 * Internal dependencies
 */



/**
 * Allows you to easily announce dynamic interface updates to screen readers using ARIA live regions.
 * This module is inspired by the `speak` function in `wp-a11y.js`.
 *
 * @param {string}               message    The message to be announced by assistive technologies.
 * @param {'polite'|'assertive'} [ariaLive] The politeness level for aria-live; default: 'polite'.
 *
 * @example
 * ```js
 * import { speak } from '@wordpress/a11y';
 *
 * // For polite messages that shouldn't interrupt what screen readers are currently announcing.
 * speak( 'The message you want to send to the ARIA live region' );
 *
 * // For assertive messages that should interrupt what screen readers are currently announcing.
 * speak( 'The message you want to send to the ARIA live region', 'assertive' );
 * ```
 */
function speak(message, ariaLive) {
  /*
   * Clear previous messages to allow repeated strings being read out and hide
   * the explanatory text from assistive technologies.
   */
  (0,_clear__WEBPACK_IMPORTED_MODULE_0__["default"])();
  message = (0,_filter_message__WEBPACK_IMPORTED_MODULE_1__["default"])(message);
  const introText = document.getElementById('a11y-speak-intro-text');
  const containerAssertive = document.getElementById('a11y-speak-assertive');
  const containerPolite = document.getElementById('a11y-speak-polite');
  if (containerAssertive && ariaLive === 'assertive') {
    containerAssertive.textContent = message;
  } else if (containerPolite) {
    containerPolite.textContent = message;
  }

  /*
   * Make the explanatory text available to assistive technologies by removing
   * the 'hidden' HTML attribute.
   */
  if (introText) {
    introText.removeAttribute('hidden');
  }
}
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/hooks.js":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/hooks.js ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useBaseControlProps: () => (/* binding */ useBaseControlProps)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! . */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/index.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

/**
 * Generate props for the `BaseControl` and the inner control itself.
 *
 * Namely, it takes care of generating a unique `id`, properly associating it with the `label` and `help` elements.
 *
 * @param props
 */
function useBaseControlProps(props) {
  const {
    help,
    id: preferredId,
    ...restProps
  } = props;
  const uniqueId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_0__["default"])(___WEBPACK_IMPORTED_MODULE_1__["default"], 'wp-components-base-control', preferredId);
  return {
    baseControlProps: {
      id: uniqueId,
      help,
      ...restProps
    },
    controlProps: {
      id: uniqueId,
      ...(!!help ? {
        'aria-describedby': `${uniqueId}__help`
      } : {})
    }
  };
}
//# sourceMappingURL=hooks.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/index.js":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/index.js ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseControl: () => (/* binding */ BaseControl),
/* harmony export */   VisualLabel: () => (/* binding */ VisualLabel),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   useBaseControlProps: () => (/* reexport safe */ _hooks__WEBPACK_IMPORTED_MODULE_2__.useBaseControlProps)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var _styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./styles/base-control-styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/* harmony import */ var _hooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hooks */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/hooks.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





const UnconnectedBaseControl = props => {
  const {
    __nextHasNoMarginBottom = false,
    __associatedWPComponentName = 'BaseControl',
    id,
    label,
    hideLabelFromVision = false,
    help,
    className,
    children
  } = (0,_context__WEBPACK_IMPORTED_MODULE_3__.useContextSystem)(props, 'BaseControl');
  if (!__nextHasNoMarginBottom) {
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_4__["default"])(`Bottom margin styles for wp.components.${__associatedWPComponentName}`, {
      since: '6.7',
      version: '7.0',
      hint: 'Set the `__nextHasNoMarginBottom` prop to true to start opting into the new styles, which will become the default in a future version.'
    });
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__.Wrapper, {
    className: className,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__.StyledField, {
      className: "components-base-control__field"
      // TODO: Official deprecation for this should start after all internal usages have been migrated
      ,
      __nextHasNoMarginBottom: __nextHasNoMarginBottom,
      children: [label && id && (hideLabelFromVision ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_6__["default"], {
        as: "label",
        htmlFor: id,
        children: label
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__.StyledLabel, {
        className: "components-base-control__label",
        htmlFor: id,
        children: label
      })), label && !id && (hideLabelFromVision ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_6__["default"], {
        as: "label",
        children: label
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(VisualLabel, {
        children: label
      })), children]
    }), !!help && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__.StyledHelp, {
      id: id ? id + '__help' : undefined,
      className: "components-base-control__help",
      __nextHasNoMarginBottom: __nextHasNoMarginBottom,
      children: help
    })]
  });
};
const UnforwardedVisualLabel = (props, ref) => {
  const {
    className,
    children,
    ...restProps
  } = props;
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_styles_base_control_styles__WEBPACK_IMPORTED_MODULE_5__.StyledVisualLabel, {
    ref: ref,
    ...restProps,
    className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-base-control__label', className),
    children: children
  });
};
const VisualLabel = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_7__.forwardRef)(UnforwardedVisualLabel);

/**
 * `BaseControl` is a component used to generate labels and help text for components handling user inputs.
 *
 * ```jsx
 * import { BaseControl, useBaseControlProps } from '@wordpress/components';
 *
 * // Render a `BaseControl` for a textarea input
 * const MyCustomTextareaControl = ({ children, ...baseProps }) => (
 * 	// `useBaseControlProps` is a convenience hook to get the props for the `BaseControl`
 * 	// and the inner control itself. Namely, it takes care of generating a unique `id`,
 * 	// properly associating it with the `label` and `help` elements.
 * 	const { baseControlProps, controlProps } = useBaseControlProps( baseProps );
 *
 * 	return (
 * 		<BaseControl { ...baseControlProps } __nextHasNoMarginBottom>
 * 			<textarea { ...controlProps }>
 * 			  { children }
 * 			</textarea>
 * 		</BaseControl>
 * 	);
 * );
 * ```
 */
const BaseControl = Object.assign((0,_context__WEBPACK_IMPORTED_MODULE_8__.contextConnectWithoutRef)(UnconnectedBaseControl, 'BaseControl'), {
  /**
   * `BaseControl.VisualLabel` is used to render a purely visual label inside a `BaseControl` component.
   *
   * It should only be used in cases where the children being rendered inside `BaseControl` are already accessibly labeled,
   * e.g., a button, but we want an additional visual label for that section equivalent to the labels `BaseControl` would
   * otherwise use if the `label` prop was passed.
   *
   * ```jsx
   * import { BaseControl } from '@wordpress/components';
   *
   * const MyBaseControl = () => (
   * 	<BaseControl
   * 		__nextHasNoMarginBottom
   * 		help="This button is already accessibly labeled."
   * 	>
   * 		<BaseControl.VisualLabel>Author</BaseControl.VisualLabel>
   * 		<Button>Select an author</Button>
   * 	</BaseControl>
   * );
   * ```
   */
  VisualLabel
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseControl);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js":
/*!************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/styles/base-control-styles.js ***!
  \************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyledField: () => (/* binding */ StyledField),
/* harmony export */   StyledHelp: () => (/* binding */ StyledHelp),
/* harmony export */   StyledLabel: () => (/* binding */ StyledLabel),
/* harmony export */   StyledVisualLabel: () => (/* binding */ StyledVisualLabel),
/* harmony export */   Wrapper: () => (/* binding */ Wrapper)
/* harmony export */ });
/* harmony import */ var _emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/styled/base */ "./node_modules/.pnpm/@emotion+styled@11.14.1_@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1__@types+react@18.3.24_react@18.3.1/node_modules/@emotion/styled/base/dist/emotion-styled-base.browser.development.esm.js");
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/box-sizing.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/base-label.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/space */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/space.js");

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */


const Wrapper = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "ej5x27r4",
  label: "Wrapper"
})("font-family:", (0,_utils__WEBPACK_IMPORTED_MODULE_1__.font)('default.fontFamily'), ";font-size:", (0,_utils__WEBPACK_IMPORTED_MODULE_1__.font)('default.fontSize'), ";", _utils__WEBPACK_IMPORTED_MODULE_2__.boxSizingReset, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const deprecatedMarginField = ({
  __nextHasNoMarginBottom = false
}) => {
  return !__nextHasNoMarginBottom && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.css)("margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_4__.space)(2), ";" + ( false ? 0 : ";label:deprecatedMarginField;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
const StyledField = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("div",  false ? 0 : {
  target: "ej5x27r3",
  label: "StyledField"
})(deprecatedMarginField, " .components-panel__row &{margin-bottom:inherit;}" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const labelStyles = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_3__.css)(_utils__WEBPACK_IMPORTED_MODULE_5__.baseLabelTypography, ";display:block;margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_4__.space)(2), ";padding:0;" + ( false ? 0 : ";label:labelStyles;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const StyledLabel = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("label",  false ? 0 : {
  target: "ej5x27r2",
  label: "StyledLabel"
})(labelStyles, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
var _ref =  false ? 0 : {
  name: "1xen9ob-deprecatedMarginHelp",
  styles: "margin-bottom:revert;label:deprecatedMarginHelp;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const deprecatedMarginHelp = ({
  __nextHasNoMarginBottom = false
}) => {
  return !__nextHasNoMarginBottom && _ref;
};
const StyledHelp = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("p",  false ? 0 : {
  target: "ej5x27r1",
  label: "StyledHelp"
})("margin-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_4__.space)(2), ";margin-bottom:0;font-size:", (0,_utils__WEBPACK_IMPORTED_MODULE_1__.font)('helpText.fontSize'), ";font-style:normal;color:", _utils__WEBPACK_IMPORTED_MODULE_6__.COLORS.gray[700], ";", deprecatedMarginHelp, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
const StyledVisualLabel = /*#__PURE__*/(0,_emotion_styled_base__WEBPACK_IMPORTED_MODULE_0__["default"])("span",  false ? 0 : {
  target: "ej5x27r0",
  label: "StyledVisualLabel"
})(labelStyles, ";" + ( false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"));
//# sourceMappingURL=base-control-styles.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/button/index.js":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/button/index.js ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: () => (/* binding */ Button),
/* harmony export */   UnforwardedButton: () => (/* binding */ UnforwardedButton),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../tooltip */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/tooltip/index.js");
/* harmony import */ var _icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../icon */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/icon/index.js");
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var _popover_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../popover/utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/popover/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const disabledEventsOnDisabledButton = ['onMouseDown', 'onClick'];
function useDeprecatedProps({
  __experimentalIsFocusable,
  isDefault,
  isPrimary,
  isSecondary,
  isTertiary,
  isLink,
  isPressed,
  isSmall,
  size,
  variant,
  describedBy,
  ...otherProps
}) {
  let computedSize = size;
  let computedVariant = variant;
  const newProps = {
    accessibleWhenDisabled: __experimentalIsFocusable,
    // @todo Mark `isPressed` as deprecated
    'aria-pressed': isPressed,
    description: describedBy
  };
  if (isSmall) {
    var _computedSize;
    (_computedSize = computedSize) !== null && _computedSize !== void 0 ? _computedSize : computedSize = 'small';
  }
  if (isPrimary) {
    var _computedVariant;
    (_computedVariant = computedVariant) !== null && _computedVariant !== void 0 ? _computedVariant : computedVariant = 'primary';
  }
  if (isTertiary) {
    var _computedVariant2;
    (_computedVariant2 = computedVariant) !== null && _computedVariant2 !== void 0 ? _computedVariant2 : computedVariant = 'tertiary';
  }
  if (isSecondary) {
    var _computedVariant3;
    (_computedVariant3 = computedVariant) !== null && _computedVariant3 !== void 0 ? _computedVariant3 : computedVariant = 'secondary';
  }
  if (isDefault) {
    var _computedVariant4;
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('wp.components.Button `isDefault` prop', {
      since: '5.4',
      alternative: 'variant="secondary"'
    });
    (_computedVariant4 = computedVariant) !== null && _computedVariant4 !== void 0 ? _computedVariant4 : computedVariant = 'secondary';
  }
  if (isLink) {
    var _computedVariant5;
    (_computedVariant5 = computedVariant) !== null && _computedVariant5 !== void 0 ? _computedVariant5 : computedVariant = 'link';
  }
  return {
    ...newProps,
    ...otherProps,
    size: computedSize,
    variant: computedVariant
  };
}
function UnforwardedButton(props, ref) {
  const {
    __next40pxDefaultSize,
    accessibleWhenDisabled,
    isBusy,
    isDestructive,
    className,
    disabled,
    icon,
    iconPosition = 'left',
    iconSize,
    showTooltip,
    tooltipPosition,
    shortcut,
    label,
    children,
    size = 'default',
    text,
    variant,
    description,
    ...buttonOrAnchorProps
  } = useDeprecatedProps(props);
  const {
    href,
    target,
    'aria-checked': ariaChecked,
    'aria-pressed': ariaPressed,
    'aria-selected': ariaSelected,
    ...additionalProps
  } = 'href' in buttonOrAnchorProps ? buttonOrAnchorProps : {
    href: undefined,
    target: undefined,
    ...buttonOrAnchorProps
  };
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["default"])(Button, 'components-button__description');
  const hasChildren = 'string' === typeof children && !!children || Array.isArray(children) && children?.[0] && children[0] !== null &&
  // Tooltip should not considered as a child
  children?.[0]?.props?.className !== 'components-tooltip';
  const truthyAriaPressedValues = [true, 'true', 'mixed'];
  const classes = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-button', className, {
    'is-next-40px-default-size': __next40pxDefaultSize,
    'is-secondary': variant === 'secondary',
    'is-primary': variant === 'primary',
    'is-small': size === 'small',
    'is-compact': size === 'compact',
    'is-tertiary': variant === 'tertiary',
    'is-pressed': truthyAriaPressedValues.includes(ariaPressed),
    'is-pressed-mixed': ariaPressed === 'mixed',
    'is-busy': isBusy,
    'is-link': variant === 'link',
    'is-destructive': isDestructive,
    'has-text': !!icon && (hasChildren || text),
    'has-icon': !!icon
  });
  const trulyDisabled = disabled && !accessibleWhenDisabled;
  const Tag = href !== undefined && !disabled ? 'a' : 'button';
  const buttonProps = Tag === 'button' ? {
    type: 'button',
    disabled: trulyDisabled,
    'aria-checked': ariaChecked,
    'aria-pressed': ariaPressed,
    'aria-selected': ariaSelected
  } : {};
  const anchorProps = Tag === 'a' ? {
    href,
    target
  } : {};
  const disableEventProps = {};
  if (disabled && accessibleWhenDisabled) {
    // In this case, the button will be disabled, but still focusable and
    // perceivable by screen reader users.
    buttonProps['aria-disabled'] = true;
    anchorProps['aria-disabled'] = true;
    for (const disabledEvent of disabledEventsOnDisabledButton) {
      disableEventProps[disabledEvent] = event => {
        if (event) {
          event.stopPropagation();
          event.preventDefault();
        }
      };
    }
  }

  // Should show the tooltip if...
  const shouldShowTooltip = !trulyDisabled && (
  // An explicit tooltip is passed or...
  showTooltip && !!label ||
  // There's a shortcut or...
  !!shortcut ||
  // There's a label and...
  !!label &&
  // The children are empty and...
  !children?.length &&
  // The tooltip is not explicitly disabled.
  false !== showTooltip);
  const descriptionId = description ? instanceId : undefined;
  const describedById = additionalProps['aria-describedby'] || descriptionId;
  const commonProps = {
    className: classes,
    'aria-label': additionalProps['aria-label'] || label,
    'aria-describedby': describedById,
    ref
  };
  const elementChildren = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [icon && iconPosition === 'left' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icon__WEBPACK_IMPORTED_MODULE_4__["default"], {
      icon: icon,
      size: iconSize
    }), text && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
      children: text
    }), children, icon && iconPosition === 'right' && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_icon__WEBPACK_IMPORTED_MODULE_4__["default"], {
      icon: icon,
      size: iconSize
    })]
  });
  const element = Tag === 'a' ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("a", {
    ...anchorProps,
    ...additionalProps,
    ...disableEventProps,
    ...commonProps,
    children: elementChildren
  }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("button", {
    ...buttonProps,
    ...additionalProps,
    ...disableEventProps,
    ...commonProps,
    children: elementChildren
  });

  // In order to avoid some React reconciliation issues, we are always rendering
  // the `Tooltip` component even when `shouldShowTooltip` is `false`.
  // In order to make sure that the tooltip doesn't show when it shouldn't,
  // we don't pass the props to the `Tooltip` component.
  const tooltipProps = shouldShowTooltip ? {
    text: children?.length && description ? description : label,
    shortcut,
    placement: tooltipPosition &&
    // Convert legacy `position` values to be used with the new `placement` prop
    (0,_popover_utils__WEBPACK_IMPORTED_MODULE_5__.positionToPlacement)(tooltipPosition)
  } : {};
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_tooltip__WEBPACK_IMPORTED_MODULE_6__["default"], {
      ...tooltipProps,
      children: element
    }), description && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_7__["default"], {
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
        id: descriptionId,
        children: description
      })
    })]
  });
}

/**
 * Lets users take actions and make choices with a single click or tap.
 *
 * ```jsx
 * import { Button } from '@wordpress/components';
 * const Mybutton = () => (
 *   <Button
 *     variant="primary"
 *     onClick={ handleClick }
 *   >
 *     Click here
 *   </Button>
 * );
 * ```
 */
const Button = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_8__.forwardRef)(UnforwardedButton);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/card/component.js":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/card/component.js ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: () => (/* binding */ Card),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-system-provider.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _elevation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../elevation */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/component.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../view */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/styles.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/card/hook.js");
/* harmony import */ var _utils_config_values__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/config-values */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */









function UnconnectedCard(props, forwardedRef) {
  const {
    children,
    elevation,
    isBorderless,
    isRounded,
    size,
    ...otherProps
  } = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useCard)(props);
  const elevationBorderRadius = isRounded ? _utils_config_values__WEBPACK_IMPORTED_MODULE_2__["default"].radiusLarge : 0;
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__.useCx)();
  const elevationClassName = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => cx(/*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)({
    borderRadius: elevationBorderRadius
  },  false ? 0 : ";label:elevationClassName;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvY2FyZC9jYXJkL2NvbXBvbmVudC50c3giXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBeUNZIiwiZmlsZSI6IkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvY2FyZC9jYXJkL2NvbXBvbmVudC50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5pbXBvcnQgdHlwZSB7IEZvcndhcmRlZFJlZiB9IGZyb20gJ3JlYWN0JztcblxuLyoqXG4gKiBXb3JkUHJlc3MgZGVwZW5kZW5jaWVzXG4gKi9cbmltcG9ydCB7IHVzZU1lbW8gfSBmcm9tICdAd29yZHByZXNzL2VsZW1lbnQnO1xuXG4vKipcbiAqIEludGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgdHlwZSB7IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyBjb250ZXh0Q29ubmVjdCwgQ29udGV4dFN5c3RlbVByb3ZpZGVyIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyBFbGV2YXRpb24gfSBmcm9tICcuLi8uLi9lbGV2YXRpb24nO1xuaW1wb3J0IHsgVmlldyB9IGZyb20gJy4uLy4uL3ZpZXcnO1xuaW1wb3J0ICogYXMgc3R5bGVzIGZyb20gJy4uL3N0eWxlcyc7XG5pbXBvcnQgeyB1c2VDYXJkIH0gZnJvbSAnLi9ob29rJztcbmltcG9ydCBDT05GSUcgZnJvbSAnLi4vLi4vdXRpbHMvY29uZmlnLXZhbHVlcyc7XG5pbXBvcnQgeyB1c2VDeCB9IGZyb20gJy4uLy4uL3V0aWxzL2hvb2tzL3VzZS1jeCc7XG5pbXBvcnQgdHlwZSB7IFByb3BzIH0gZnJvbSAnLi4vdHlwZXMnO1xuXG5mdW5jdGlvbiBVbmNvbm5lY3RlZENhcmQoXG5cdHByb3BzOiBXb3JkUHJlc3NDb21wb25lbnRQcm9wczwgUHJvcHMsICdkaXYnID4sXG5cdGZvcndhcmRlZFJlZjogRm9yd2FyZGVkUmVmPCBhbnkgPlxuKSB7XG5cdGNvbnN0IHtcblx0XHRjaGlsZHJlbixcblx0XHRlbGV2YXRpb24sXG5cdFx0aXNCb3JkZXJsZXNzLFxuXHRcdGlzUm91bmRlZCxcblx0XHRzaXplLFxuXHRcdC4uLm90aGVyUHJvcHNcblx0fSA9IHVzZUNhcmQoIHByb3BzICk7XG5cdGNvbnN0IGVsZXZhdGlvbkJvcmRlclJhZGl1cyA9IGlzUm91bmRlZCA/IENPTkZJRy5yYWRpdXNMYXJnZSA6IDA7XG5cblx0Y29uc3QgY3ggPSB1c2VDeCgpO1xuXG5cdGNvbnN0IGVsZXZhdGlvbkNsYXNzTmFtZSA9IHVzZU1lbW8oXG5cdFx0KCkgPT4gY3goIGNzcyggeyBib3JkZXJSYWRpdXM6IGVsZXZhdGlvbkJvcmRlclJhZGl1cyB9ICkgKSxcblx0XHRbIGN4LCBlbGV2YXRpb25Cb3JkZXJSYWRpdXMgXVxuXHQpO1xuXG5cdGNvbnN0IGNvbnRleHRQcm92aWRlclZhbHVlID0gdXNlTWVtbyggKCkgPT4ge1xuXHRcdGNvbnN0IGNvbnRleHRQcm9wcyA9IHtcblx0XHRcdHNpemUsXG5cdFx0XHRpc0JvcmRlcmxlc3MsXG5cdFx0fTtcblx0XHRyZXR1cm4ge1xuXHRcdFx0Q2FyZEJvZHk6IGNvbnRleHRQcm9wcyxcblx0XHRcdENhcmRIZWFkZXI6IGNvbnRleHRQcm9wcyxcblx0XHRcdENhcmRGb290ZXI6IGNvbnRleHRQcm9wcyxcblx0XHR9O1xuXHR9LCBbIGlzQm9yZGVybGVzcywgc2l6ZSBdICk7XG5cblx0cmV0dXJuIChcblx0XHQ8Q29udGV4dFN5c3RlbVByb3ZpZGVyIHZhbHVlPXsgY29udGV4dFByb3ZpZGVyVmFsdWUgfT5cblx0XHRcdDxWaWV3IHsgLi4ub3RoZXJQcm9wcyB9IHJlZj17IGZvcndhcmRlZFJlZiB9PlxuXHRcdFx0XHQ8VmlldyBjbGFzc05hbWU9eyBjeCggc3R5bGVzLkNvbnRlbnQgKSB9PnsgY2hpbGRyZW4gfTwvVmlldz5cblx0XHRcdFx0PEVsZXZhdGlvblxuXHRcdFx0XHRcdGNsYXNzTmFtZT17IGVsZXZhdGlvbkNsYXNzTmFtZSB9XG5cdFx0XHRcdFx0aXNJbnRlcmFjdGl2ZT17IGZhbHNlIH1cblx0XHRcdFx0XHR2YWx1ZT17IGVsZXZhdGlvbiA/IDEgOiAwIH1cblx0XHRcdFx0Lz5cblx0XHRcdFx0PEVsZXZhdGlvblxuXHRcdFx0XHRcdGNsYXNzTmFtZT17IGVsZXZhdGlvbkNsYXNzTmFtZSB9XG5cdFx0XHRcdFx0aXNJbnRlcmFjdGl2ZT17IGZhbHNlIH1cblx0XHRcdFx0XHR2YWx1ZT17IGVsZXZhdGlvbiB9XG5cdFx0XHRcdC8+XG5cdFx0XHQ8L1ZpZXc+XG5cdFx0PC9Db250ZXh0U3lzdGVtUHJvdmlkZXI+XG5cdCk7XG59XG5cbi8qKlxuICogYENhcmRgIHByb3ZpZGVzIGEgZmxleGlibGUgYW5kIGV4dGVuc2libGUgY29udGVudCBjb250YWluZXIuXG4gKiBgQ2FyZGAgYWxzbyBwcm92aWRlcyBhIGNvbnZlbmllbnQgc2V0IG9mIHN1Yi1jb21wb25lbnRzIHN1Y2ggYXMgYENhcmRCb2R5YCxcbiAqIGBDYXJkSGVhZGVyYCwgYENhcmRGb290ZXJgLCBhbmQgbW9yZS5cbiAqXG4gKiBgYGBqc3hcbiAqIGltcG9ydCB7XG4gKiAgIENhcmQsXG4gKiAgIENhcmRIZWFkZXIsXG4gKiAgIENhcmRCb2R5LFxuICogICBDYXJkRm9vdGVyLFxuICogICBfX2V4cGVyaW1lbnRhbFRleHQgYXMgVGV4dCxcbiAqICAgX19leHBlcmltZW50YWxIZWFkaW5nIGFzIEhlYWRpbmcsXG4gKiB9IGZyb20gYEB3b3JkcHJlc3MvY29tcG9uZW50c2A7XG4gKlxuICogZnVuY3Rpb24gRXhhbXBsZSgpIHtcbiAqICAgcmV0dXJuIChcbiAqICAgICA8Q2FyZD5cbiAqICAgICAgIDxDYXJkSGVhZGVyPlxuICogICAgICAgICA8SGVhZGluZyBsZXZlbD17IDQgfT5DYXJkIFRpdGxlPC9IZWFkaW5nPlxuICogICAgICAgPC9DYXJkSGVhZGVyPlxuICogICAgICAgPENhcmRCb2R5PlxuICogICAgICAgICA8VGV4dD5DYXJkIENvbnRlbnQ8L1RleHQ+XG4gKiAgICAgICA8L0NhcmRCb2R5PlxuICogICAgICAgPENhcmRGb290ZXI+XG4gKiAgICAgICAgIDxUZXh0PkNhcmQgRm9vdGVyPC9UZXh0PlxuICogICAgICAgPC9DYXJkRm9vdGVyPlxuICogICAgIDwvQ2FyZD5cbiAqICAgKTtcbiAqIH1cbiAqIGBgYFxuICovXG5leHBvcnQgY29uc3QgQ2FyZCA9IGNvbnRleHRDb25uZWN0KCBVbmNvbm5lY3RlZENhcmQsICdDYXJkJyApO1xuXG5leHBvcnQgZGVmYXVsdCBDYXJkO1xuIl19 */")), [cx, elevationBorderRadius]);
  const contextProviderValue = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    const contextProps = {
      size,
      isBorderless
    };
    return {
      CardBody: contextProps,
      CardHeader: contextProps,
      CardFooter: contextProps
    };
  }, [isBorderless, size]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_context__WEBPACK_IMPORTED_MODULE_6__.ContextSystemProvider, {
    value: contextProviderValue,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_view__WEBPACK_IMPORTED_MODULE_7__["default"], {
      ...otherProps,
      ref: forwardedRef,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_view__WEBPACK_IMPORTED_MODULE_7__["default"], {
        className: cx(_styles__WEBPACK_IMPORTED_MODULE_8__.Content),
        children: children
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_elevation__WEBPACK_IMPORTED_MODULE_9__["default"], {
        className: elevationClassName,
        isInteractive: false,
        value: elevation ? 1 : 0
      }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_elevation__WEBPACK_IMPORTED_MODULE_9__["default"], {
        className: elevationClassName,
        isInteractive: false,
        value: elevation
      })]
    })
  });
}

/**
 * `Card` provides a flexible and extensible content container.
 * `Card` also provides a convenient set of sub-components such as `CardBody`,
 * `CardHeader`, `CardFooter`, and more.
 *
 * ```jsx
 * import {
 *   Card,
 *   CardHeader,
 *   CardBody,
 *   CardFooter,
 *   __experimentalText as Text,
 *   __experimentalHeading as Heading,
 * } from `@wordpress/components`;
 *
 * function Example() {
 *   return (
 *     <Card>
 *       <CardHeader>
 *         <Heading level={ 4 }>Card Title</Heading>
 *       </CardHeader>
 *       <CardBody>
 *         <Text>Card Content</Text>
 *       </CardBody>
 *       <CardFooter>
 *         <Text>Card Footer</Text>
 *       </CardFooter>
 *     </Card>
 *   );
 * }
 * ```
 */
const Card = (0,_context__WEBPACK_IMPORTED_MODULE_10__.contextConnect)(UnconnectedCard, 'Card');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Card);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/card/hook.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/card/hook.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCard: () => (/* binding */ useCard)
/* harmony export */ });
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _surface__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../surface */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/hook.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/styles.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function useDeprecatedProps({
  elevation,
  isElevated,
  ...otherProps
}) {
  const propsToReturn = {
    ...otherProps
  };
  let computedElevation = elevation;
  if (isElevated) {
    var _computedElevation;
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__["default"])('Card isElevated prop', {
      since: '5.9',
      alternative: 'elevation'
    });
    (_computedElevation = computedElevation) !== null && _computedElevation !== void 0 ? _computedElevation : computedElevation = 2;
  }

  // The `elevation` prop should only be passed when it's not `undefined`,
  // otherwise it will override the value that gets derived from `useContextSystem`.
  if (typeof computedElevation !== 'undefined') {
    propsToReturn.elevation = computedElevation;
  }
  return propsToReturn;
}
function useCard(props) {
  const {
    className,
    elevation = 0,
    isBorderless = false,
    isRounded = true,
    size = 'medium',
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useContextSystem)(useDeprecatedProps(props), 'Card');
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_2__.useCx)();
  const classes = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    return cx(_styles__WEBPACK_IMPORTED_MODULE_4__.Card, isBorderless && _styles__WEBPACK_IMPORTED_MODULE_4__.boxShadowless, isRounded && _styles__WEBPACK_IMPORTED_MODULE_4__.rounded, className);
  }, [className, cx, isBorderless, isRounded]);
  const surfaceProps = (0,_surface__WEBPACK_IMPORTED_MODULE_5__.useSurface)({
    ...otherProps,
    className: classes
  });
  return {
    ...surfaceProps,
    elevation,
    isBorderless,
    isRounded,
    size
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/styles.js":
/*!********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/card/styles.js ***!
  \********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Body: () => (/* binding */ Body),
/* harmony export */   Card: () => (/* binding */ Card),
/* harmony export */   Content: () => (/* binding */ Content),
/* harmony export */   Divider: () => (/* binding */ Divider),
/* harmony export */   Footer: () => (/* binding */ Footer),
/* harmony export */   Header: () => (/* binding */ Header),
/* harmony export */   Media: () => (/* binding */ Media),
/* harmony export */   borderColor: () => (/* binding */ borderColor),
/* harmony export */   borderRadius: () => (/* binding */ borderRadius),
/* harmony export */   borderless: () => (/* binding */ borderless),
/* harmony export */   boxShadowless: () => (/* binding */ boxShadowless),
/* harmony export */   cardPaddings: () => (/* binding */ cardPaddings),
/* harmony export */   rounded: () => (/* binding */ rounded),
/* harmony export */   shady: () => (/* binding */ shady)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */


// Since the border for `Card` is rendered via the `box-shadow` property
// (as opposed to the `border` property), the value of the border radius needs
// to be adjusted by removing 1px (this is because the `box-shadow` renders
// as an "outer radius").
const adjustedBorderRadius = `calc(${_utils__WEBPACK_IMPORTED_MODULE_0__["default"].radiusLarge} - 1px)`;
const Card = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("box-shadow:0 0 0 1px ", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].surfaceBorderColor, ";outline:none;" + ( false ? 0 : ";label:Card;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const Header =  false ? 0 : {
  name: "euqiwd-Header",
  styles: "border-bottom:1px solid;box-sizing:border-box;&:last-child{border-bottom:none;};label:Header;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Footer =  false ? 0 : {
  name: "1rianq6-Footer",
  styles: "border-top:1px solid;box-sizing:border-box;&:first-of-type{border-top:none;};label:Footer;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Content =  false ? 0 : {
  name: "1ruapvy-Content",
  styles: "height:100%;label:Content;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Body =  false ? 0 : {
  name: "1klm29z-Body",
  styles: "box-sizing:border-box;height:auto;max-height:100%;label:Body;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Media =  false ? 0 : {
  name: "6f4wyb-Media",
  styles: "box-sizing:border-box;overflow:hidden;&>img,&>iframe{display:block;height:auto;max-width:100%;width:100%;};label:Media;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Divider =  false ? 0 : {
  name: "c5mt54-Divider",
  styles: "box-sizing:border-box;display:block;width:100%;label:Divider;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const borderRadius = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("&:first-of-type{border-top-left-radius:", adjustedBorderRadius, ";border-top-right-radius:", adjustedBorderRadius, ";}&:last-of-type{border-bottom-left-radius:", adjustedBorderRadius, ";border-bottom-right-radius:", adjustedBorderRadius, ";}" + ( false ? 0 : ";label:borderRadius;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const borderColor = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("border-color:", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].colorDivider, ";" + ( false ? 0 : ";label:borderColor;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const boxShadowless =  false ? 0 : {
  name: "14zofrl-boxShadowless",
  styles: "box-shadow:none;label:boxShadowless;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const borderless =  false ? 0 : {
  name: "kyy9w8-borderless",
  styles: "border:none;label:borderless;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const rounded = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("border-radius:", adjustedBorderRadius, ";" + ( false ? 0 : ";label:rounded;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const xSmallCardPadding = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("padding:", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].cardPaddingXSmall, ";" + ( false ? 0 : ";label:xSmallCardPadding;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const cardPaddings = {
  large: /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("padding:", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].cardPaddingLarge, ";" + ( false ? 0 : ";label:large;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),
  medium: /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("padding:", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].cardPaddingMedium, ";" + ( false ? 0 : ";label:medium;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),
  small: /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("padding:", _utils__WEBPACK_IMPORTED_MODULE_0__["default"].cardPaddingSmall, ";" + ( false ? 0 : ";label:small;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),
  xSmall: xSmallCardPadding,
  // The `extraSmall` size is not officially documented, but the following styles
  // are kept for legacy reasons to support older values of the `size` prop.
  extraSmall: xSmallCardPadding
};
const shady = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_1__.css)("background-color:", _utils__WEBPACK_IMPORTED_MODULE_2__.COLORS.ui.backgroundDisabled, ";" + ( false ? 0 : ";label:shady;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/checkbox-control/index.js":
/*!*******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/checkbox-control/index.js ***!
  \*******************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckboxControl: () => (/* binding */ CheckboxControl),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-ref-effect/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/.pnpm/@wordpress+icons@10.30.0_react@18.3.1/node_modules/@wordpress/icons/build-module/icon/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/.pnpm/@wordpress+icons@10.30.0_react@18.3.1/node_modules/@wordpress/icons/build-module/library/reset.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/.pnpm/@wordpress+icons@10.30.0_react@18.3.1/node_modules/@wordpress/icons/build-module/library/check.js");
/* harmony import */ var _base_control__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../base-control */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/index.js");
/* harmony import */ var _h_stack__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../h-stack */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/component.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



/**
 * Checkboxes allow the user to select one or more items from a set.
 *
 * ```jsx
 * import { CheckboxControl } from '@wordpress/components';
 * import { useState } from '@wordpress/element';
 *
 * const MyCheckboxControl = () => {
 *   const [ isChecked, setChecked ] = useState( true );
 *   return (
 *     <CheckboxControl
 *       __nextHasNoMarginBottom
 *       label="Is author"
 *       help="Is the user a author or not?"
 *       checked={ isChecked }
 *       onChange={ setChecked }
 *     />
 *   );
 * };
 * ```
 */
function CheckboxControl(props) {
  const {
    __nextHasNoMarginBottom,
    label,
    className,
    heading,
    checked,
    indeterminate,
    help,
    id: idProp,
    onChange,
    ...additionalProps
  } = props;
  if (heading) {
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_2__["default"])('`heading` prop in `CheckboxControl`', {
      alternative: 'a separate element to implement a heading',
      since: '5.8'
    });
  }
  const [showCheckedIcon, setShowCheckedIcon] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const [showIndeterminateIcon, setShowIndeterminateIcon] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);

  // Run the following callback every time the `ref` (and the additional
  // dependencies) change.
  const ref = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(node => {
    if (!node) {
      return;
    }

    // It cannot be set using an HTML attribute.
    node.indeterminate = !!indeterminate;
    setShowCheckedIcon(node.matches(':checked'));
    setShowIndeterminateIcon(node.matches(':indeterminate'));
  }, [checked, indeterminate]);
  const id = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(CheckboxControl, 'inspector-checkbox-control', idProp);
  const onChangeValue = event => onChange(event.target.checked);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_base_control__WEBPACK_IMPORTED_MODULE_6__["default"], {
    __nextHasNoMarginBottom: __nextHasNoMarginBottom,
    __associatedWPComponentName: "CheckboxControl",
    label: heading,
    id: id,
    help: help && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("span", {
      className: "components-checkbox-control__help",
      children: help
    }),
    className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-checkbox-control', className),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_h_stack__WEBPACK_IMPORTED_MODULE_7__["default"], {
      spacing: 0,
      justify: "start",
      alignment: "top",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("span", {
        className: "components-checkbox-control__input-container",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("input", {
          ref: ref,
          id: id,
          className: "components-checkbox-control__input",
          type: "checkbox",
          value: "1",
          onChange: onChangeValue,
          checked: checked,
          "aria-describedby": !!help ? id + '__help' : undefined,
          ...additionalProps
        }), showIndeterminateIcon ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
          className: "components-checkbox-control__indeterminate",
          role: "presentation"
        }) : null, showCheckedIcon ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_wordpress_icons__WEBPACK_IMPORTED_MODULE_8__["default"], {
          icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_10__["default"],
          className: "components-checkbox-control__checked",
          role: "presentation"
        }) : null]
      }), label && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("label", {
        className: "components-checkbox-control__label",
        htmlFor: id,
        children: label
      })]
    })
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxControl);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/constants.js":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/constants.js ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMPONENT_NAMESPACE: () => (/* binding */ COMPONENT_NAMESPACE),
/* harmony export */   CONNECTED_NAMESPACE: () => (/* binding */ CONNECTED_NAMESPACE),
/* harmony export */   CONNECT_STATIC_NAMESPACE: () => (/* binding */ CONNECT_STATIC_NAMESPACE)
/* harmony export */ });
const COMPONENT_NAMESPACE = 'data-wp-component';
const CONNECTED_NAMESPACE = 'data-wp-c16t';

/**
 * Special key where the connected namespaces are stored.
 * This is attached to Context connected components as a static property.
 */
const CONNECT_STATIC_NAMESPACE = '__contextSystemKey__';
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js":
/*!********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js ***!
  \********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contextConnect: () => (/* binding */ contextConnect),
/* harmony export */   contextConnectWithoutRef: () => (/* binding */ contextConnectWithoutRef),
/* harmony export */   getConnectNamespace: () => (/* binding */ getConnectNamespace),
/* harmony export */   hasConnectNamespace: () => (/* binding */ hasConnectNamespace)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/.pnpm/@wordpress+warning@3.30.0/node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/constants.js");
/* harmony import */ var _get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./get-styled-class-name-from-key */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Forwards ref (React.ForwardRef) and "Connects" (or registers) a component
 * within the Context system under a specified namespace.
 *
 * @param Component The component to register into the Context system.
 * @param namespace The namespace to register the component under.
 * @return The connected WordPressComponent
 */
function contextConnect(Component, namespace) {
  return _contextConnect(Component, namespace, {
    forwardsRef: true
  });
}

/**
 * "Connects" (or registers) a component within the Context system under a specified namespace.
 * Does not forward a ref.
 *
 * @param Component The component to register into the Context system.
 * @param namespace The namespace to register the component under.
 * @return The connected WordPressComponent
 */
function contextConnectWithoutRef(Component, namespace) {
  return _contextConnect(Component, namespace);
}

// This is an (experimental) evolution of the initial connect() HOC.
// The hope is that we can improve render performance by removing functional
// component wrappers.
function _contextConnect(Component, namespace, options) {
  const WrappedComponent = options?.forwardsRef ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.forwardRef)(Component) : Component;
  if (typeof namespace === 'undefined') {
    globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_1__["default"])('contextConnect: Please provide a namespace') : void 0;
  }

  // @ts-expect-error internal property
  let mergedNamespace = WrappedComponent[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE] || [namespace];

  /**
   * Consolidate (merge) namespaces before attaching it to the WrappedComponent.
   */
  if (Array.isArray(namespace)) {
    mergedNamespace = [...mergedNamespace, ...namespace];
  }
  if (typeof namespace === 'string') {
    mergedNamespace = [...mergedNamespace, namespace];
  }

  // @ts-expect-error We can't rely on inferred types here because of the
  // `as` prop polymorphism we're handling in https://github.com/WordPress/gutenberg/blob/4f3a11243c365f94892e479bff0b922ccc4ccda3/packages/components/src/context/wordpress-component.ts#L32-L33
  return Object.assign(WrappedComponent, {
    [_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]: [...new Set(mergedNamespace)],
    displayName: namespace,
    selector: `.${(0,_get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_3__.getStyledClassNameFromKey)(namespace)}`
  });
}

/**
 * Attempts to retrieve the connected namespace from a component.
 *
 * @param Component The component to retrieve a namespace from.
 * @return The connected namespaces.
 */
function getConnectNamespace(Component) {
  if (!Component) {
    return [];
  }
  let namespaces = [];

  // @ts-ignore internal property
  if (Component[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]) {
    // @ts-ignore internal property
    namespaces = Component[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE];
  }

  // @ts-ignore
  if (Component.type && Component.type[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE]) {
    // @ts-ignore
    namespaces = Component.type[_constants__WEBPACK_IMPORTED_MODULE_2__.CONNECT_STATIC_NAMESPACE];
  }
  return namespaces;
}

/**
 * Checks to see if a component is connected within the Context system.
 *
 * @param Component The component to retrieve a namespace from.
 * @param match     The namespace to check.
 */
function hasConnectNamespace(Component, match) {
  if (!Component) {
    return false;
  }
  if (typeof match === 'string') {
    return getConnectNamespace(Component).includes(match);
  }
  if (Array.isArray(match)) {
    return match.some(result => getConnectNamespace(Component).includes(result));
  }
  return false;
}
//# sourceMappingURL=context-connect.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-system-provider.js":
/*!****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-system-provider.js ***!
  \****************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ComponentsContext: () => (/* binding */ ComponentsContext),
/* harmony export */   ContextSystemProvider: () => (/* binding */ ContextSystemProvider),
/* harmony export */   useComponentsContext: () => (/* binding */ useComponentsContext)
/* harmony export */ });
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! deepmerge */ "./node_modules/.pnpm/deepmerge@4.3.1/node_modules/deepmerge/dist/cjs.js");
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! fast-deep-equal/es6 */ "./node_modules/.pnpm/fast-deep-equal@3.1.3/node_modules/fast-deep-equal/es6/index.js");
/* harmony import */ var fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var is_plain_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! is-plain-object */ "./node_modules/.pnpm/is-plain-object@5.0.0/node_modules/is-plain-object/dist/is-plain-object.mjs");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/.pnpm/@wordpress+warning@3.30.0/node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-update-effect.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */




/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const ComponentsContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.createContext)(/** @type {Record<string, any>} */{});
ComponentsContext.displayName = 'ComponentsContext';
const useComponentsContext = () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useContext)(ComponentsContext);

/**
 * Consolidates incoming ContextSystem values with a (potential) parent ContextSystem value.
 *
 * Note: This function will warn if it detects an un-memoized `value`
 *
 * @param {Object}              props
 * @param {Record<string, any>} props.value
 * @return {Record<string, any>} The consolidated value.
 */
function useContextSystemBridge({
  value
}) {
  const parentContext = useComponentsContext();
  const valueRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useRef)(value);
  (0,_utils__WEBPACK_IMPORTED_MODULE_5__["default"])(() => {
    if (
    // Objects are equivalent.
    fast_deep_equal_es6__WEBPACK_IMPORTED_MODULE_1___default()(valueRef.current, value) &&
    // But not the same reference.
    valueRef.current !== value) {
      globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_6__["default"])(`Please memoize your context: ${JSON.stringify(value)}`) : void 0;
    }
  }, [value]);

  // `parentContext` will always be memoized (i.e., the result of this hook itself)
  // or the default value from when the `ComponentsContext` was originally
  // initialized (which will never change, it's a static variable)
  // so this memoization will prevent `deepmerge()` from rerunning unless
  // the references to `value` change OR the `parentContext` has an actual material change
  // (because again, it's guaranteed to be memoized or a static reference to the empty object
  // so we know that the only changes for `parentContext` are material ones... i.e., why we
  // don't have to warn in the `useUpdateEffect` hook above for `parentContext` and we only
  // need to bother with the `value`). The `useUpdateEffect` above will ensure that we are
  // correctly warning when the `value` isn't being properly memoized. All of that to say
  // that this should be super safe to assume that `useMemo` will only run on actual
  // changes to the two dependencies, therefore saving us calls to `deepmerge()`!
  const config = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    // Deep clone `parentContext` to avoid mutating it later.
    return deepmerge__WEBPACK_IMPORTED_MODULE_0___default()(parentContext !== null && parentContext !== void 0 ? parentContext : {}, value !== null && value !== void 0 ? value : {}, {
      isMergeableObject: is_plain_object__WEBPACK_IMPORTED_MODULE_2__.isPlainObject
    });
  }, [parentContext, value]);
  return config;
}

/**
 * A Provider component that can modify props for connected components within
 * the Context system.
 *
 * @example
 * ```jsx
 * <ContextSystemProvider value={{ Button: { size: 'small' }}}>
 *   <Button>...</Button>
 * </ContextSystemProvider>
 * ```
 *
 * @template {Record<string, any>} T
 * @param {Object}                    options
 * @param {import('react').ReactNode} options.children Children to render.
 * @param {T}                         options.value    Props to render into connected components.
 * @return {JSX.Element} A Provider wrapped component.
 */
const BaseContextSystemProvider = ({
  children,
  value
}) => {
  const contextValue = useContextSystemBridge({
    value
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(ComponentsContext.Provider, {
    value: contextValue,
    children: children
  });
};
const ContextSystemProvider = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.memo)(BaseContextSystemProvider);
//# sourceMappingURL=context-system-provider.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js":
/*!***********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js ***!
  \***********************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStyledClassNameFromKey: () => (/* binding */ getStyledClassNameFromKey)
/* harmony export */ });
/* harmony import */ var change_case__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! change-case */ "./node_modules/.pnpm/param-case@3.0.4/node_modules/param-case/dist.es2015/index.js");
/* harmony import */ var memize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! memize */ "./node_modules/.pnpm/memize@2.1.1/node_modules/memize/dist/index.js");
/**
 * External dependencies
 */



/**
 * Generates the connected component CSS className based on the namespace.
 *
 * @param namespace The name of the connected component.
 * @return The generated CSS className.
 */
function getStyledClassName(namespace) {
  const kebab = (0,change_case__WEBPACK_IMPORTED_MODULE_1__.paramCase)(namespace);
  return `components-${kebab}`;
}
const getStyledClassNameFromKey = (0,memize__WEBPACK_IMPORTED_MODULE_0__["default"])(getStyledClassName);
//# sourceMappingURL=get-styled-class-name-from-key.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js ***!
  \***********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useContextSystem: () => (/* binding */ useContextSystem)
/* harmony export */ });
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/.pnpm/@wordpress+warning@3.30.0/node_modules/@wordpress/warning/build-module/index.js");
/* harmony import */ var _context_system_provider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./context-system-provider */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-system-provider.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/utils.js");
/* harmony import */ var _get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./get-styled-class-name-from-key */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/get-styled-class-name-from-key.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/**
 * @template TProps
 * @typedef {TProps & { className: string }} ConnectedProps
 */

/**
 * Custom hook that derives registered props from the Context system.
 * These derived props are then consolidated with incoming component props.
 *
 * @template {{ className?: string }} P
 * @param {P}      props     Incoming props from the component.
 * @param {string} namespace The namespace to register and to derive context props from.
 * @return {ConnectedProps<P>} The connected props.
 */
function useContextSystem(props, namespace) {
  const contextSystemProps = (0,_context_system_provider__WEBPACK_IMPORTED_MODULE_0__.useComponentsContext)();
  if (typeof namespace === 'undefined') {
    globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_1__["default"])('useContextSystem: Please provide a namespace') : void 0;
  }
  const contextProps = contextSystemProps?.[namespace] || {};

  /* eslint-disable jsdoc/no-undefined-types */
  /** @type {ConnectedProps<P>} */
  // @ts-ignore We fill in the missing properties below
  const finalComponentProps = {
    ...(0,_utils__WEBPACK_IMPORTED_MODULE_2__.getConnectedNamespace)(),
    ...(0,_utils__WEBPACK_IMPORTED_MODULE_2__.getNamespace)(namespace)
  };
  /* eslint-enable jsdoc/no-undefined-types */

  const {
    _overrides: overrideProps,
    ...otherContextProps
  } = contextProps;
  const initialMergedProps = Object.entries(otherContextProps).length ? Object.assign({}, otherContextProps, props) : props;
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__.useCx)();
  const classes = cx((0,_get_styled_class_name_from_key__WEBPACK_IMPORTED_MODULE_4__.getStyledClassNameFromKey)(namespace), props.className);

  // Provides the ability to customize the render of the component.
  const rendered = typeof initialMergedProps.renderChildren === 'function' ? initialMergedProps.renderChildren(initialMergedProps) : initialMergedProps.children;
  for (const key in initialMergedProps) {
    // @ts-ignore filling in missing props
    finalComponentProps[key] = initialMergedProps[key];
  }
  for (const key in overrideProps) {
    // @ts-ignore filling in missing props
    finalComponentProps[key] = overrideProps[key];
  }

  // Setting an `undefined` explicitly can cause unintended overwrites
  // when a `cloneElement()` is involved.
  if (rendered !== undefined) {
    // @ts-ignore
    finalComponentProps.children = rendered;
  }
  finalComponentProps.className = classes;
  return finalComponentProps;
}
//# sourceMappingURL=use-context-system.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/utils.js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/utils.js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getConnectedNamespace: () => (/* binding */ getConnectedNamespace),
/* harmony export */   getNamespace: () => (/* binding */ getNamespace)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/constants.js");
/**
 * Internal dependencies
 */


/**
 * Creates a dedicated context namespace HTML attribute for components.
 * ns is short for "namespace"
 *
 * @example
 * ```jsx
 * <div {...ns('Container')} />
 * ```
 *
 * @param {string} componentName The name for the component.
 * @return {Record<string, any>} A props object with the namespaced HTML attribute.
 */
function getNamespace(componentName) {
  return {
    [_constants__WEBPACK_IMPORTED_MODULE_0__.COMPONENT_NAMESPACE]: componentName
  };
}

/**
 * Creates a dedicated connected context namespace HTML attribute for components.
 * ns is short for "namespace"
 *
 * @example
 * ```jsx
 * <div {...cns()} />
 * ```
 *
 * @return {Record<string, any>} A props object with the namespaced HTML attribute.
 */
function getConnectedNamespace() {
  return {
    [_constants__WEBPACK_IMPORTED_MODULE_0__.CONNECTED_NAMESPACE]: true
  };
}
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/dashicon/index.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/dashicon/index.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");

/**
 * @typedef OwnProps
 *
 * @property {import('./types').IconKey} icon        Icon name
 * @property {string}                    [className] Class name
 * @property {number}                    [size]      Size of the icon
 */

/**
 * Internal dependencies
 */

function Dashicon({
  icon,
  className,
  size = 20,
  style = {},
  ...extraProps
}) {
  const iconClass = ['dashicon', 'dashicons', 'dashicons-' + icon, className].filter(Boolean).join(' ');

  // For retro-compatibility reasons (for example if people are overriding icon size with CSS), we add inline styles just if the size is different to the default
  const sizeStyles =
  // using `!=` to catch both 20 and "20"
  // eslint-disable-next-line eqeqeq
  20 != size ? {
    fontSize: `${size}px`,
    width: `${size}px`,
    height: `${size}px`
  } : {};
  const styles = {
    ...sizeStyles,
    ...style
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: iconClass,
    style: styles,
    ...extraProps
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Dashicon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/component.js":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/component.js ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Elevation: () => (/* binding */ Elevation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../view */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */





function UnconnectedElevation(props, forwardedRef) {
  const elevationProps = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useElevation)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_view__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...elevationProps,
    ref: forwardedRef
  });
}

/**
 * `Elevation` is a core component that renders shadow, using the component
 * system's shadow system.
 *
 * The shadow effect is generated using the `value` prop.
 *
 * ```jsx
 * import {
 *	__experimentalElevation as Elevation,
 *	__experimentalSurface as Surface,
 *	__experimentalText as Text,
 * } from '@wordpress/components';
 *
 * function Example() {
 *   return (
 *     <Surface>
 *       <Text>Code is Poetry</Text>
 *       <Elevation value={ 5 } />
 *     </Surface>
 *   );
 * }
 * ```
 */
const Elevation = (0,_context__WEBPACK_IMPORTED_MODULE_3__.contextConnect)(UnconnectedElevation, 'Elevation');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Elevation);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/hook.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/hook.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getBoxShadow: () => (/* binding */ getBoxShadow),
/* harmony export */   useElevation: () => (/* binding */ useElevation)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/styles.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/* harmony import */ var _utils_values__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/values */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/values.js");
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */






function getBoxShadow(value) {
  const boxShadowColor = `rgba(0, 0, 0, ${value / 20})`;
  const boxShadow = `0 ${value}px ${value * 2}px 0
	${boxShadowColor}`;
  return boxShadow;
}
function useElevation(props) {
  const {
    active,
    borderRadius = 'inherit',
    className,
    focus,
    hover,
    isInteractive = false,
    offset = 0,
    value = 0,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_0__.useContextSystem)(props, 'Elevation');
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_1__.useCx)();
  const classes = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    let hoverValue = (0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(hover) ? hover : value * 2;
    let activeValue = (0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(active) ? active : value / 2;
    if (!isInteractive) {
      hoverValue = (0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(hover) ? hover : undefined;
      activeValue = (0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(active) ? active : undefined;
    }
    const transition = `box-shadow ${_utils__WEBPACK_IMPORTED_MODULE_4__["default"].transitionDuration} ${_utils__WEBPACK_IMPORTED_MODULE_4__["default"].transitionTimingFunction}`;
    const sx = {};
    sx.Base = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)({
      borderRadius,
      bottom: offset,
      boxShadow: getBoxShadow(value),
      opacity: _utils__WEBPACK_IMPORTED_MODULE_4__["default"].elevationIntensity,
      left: offset,
      right: offset,
      top: offset
    }, /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)("@media not ( prefers-reduced-motion ){transition:", transition, ";}" + ( false ? 0 : ";label:sx-Base;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"),  false ? 0 : ";label:sx-Base;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
    if ((0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(hoverValue)) {
      sx.hover = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)("*:hover>&{box-shadow:", getBoxShadow(hoverValue), ";}" + ( false ? 0 : ";label:sx-hover;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZWxldmF0aW9uL2hvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBdUZpQiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2VsZXZhdGlvbi9ob29rLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHR5cGUgeyBTZXJpYWxpemVkU3R5bGVzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG4vKipcbiAqIFdvcmRQcmVzcyBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgdXNlTWVtbyB9IGZyb20gJ0B3b3JkcHJlc3MvZWxlbWVudCc7XG5cbi8qKlxuICogSW50ZXJuYWwgZGVwZW5kZW5jaWVzXG4gKi9cbmltcG9ydCB0eXBlIHsgV29yZFByZXNzQ29tcG9uZW50UHJvcHMgfSBmcm9tICcuLi9jb250ZXh0JztcbmltcG9ydCB7IHVzZUNvbnRleHRTeXN0ZW0gfSBmcm9tICcuLi9jb250ZXh0JztcbmltcG9ydCAqIGFzIHN0eWxlcyBmcm9tICcuL3N0eWxlcyc7XG5pbXBvcnQgeyBDT05GSUcgfSBmcm9tICcuLi91dGlscyc7XG5pbXBvcnQgeyB1c2VDeCB9IGZyb20gJy4uL3V0aWxzL2hvb2tzL3VzZS1jeCc7XG5pbXBvcnQgeyBpc1ZhbHVlRGVmaW5lZCB9IGZyb20gJy4uL3V0aWxzL3ZhbHVlcyc7XG5pbXBvcnQgdHlwZSB7IEVsZXZhdGlvblByb3BzIH0gZnJvbSAnLi90eXBlcyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRCb3hTaGFkb3coIHZhbHVlOiBudW1iZXIgKSB7XG5cdGNvbnN0IGJveFNoYWRvd0NvbG9yID0gYHJnYmEoMCwgMCwgMCwgJHsgdmFsdWUgLyAyMCB9KWA7XG5cdGNvbnN0IGJveFNoYWRvdyA9IGAwICR7IHZhbHVlIH1weCAkeyB2YWx1ZSAqIDIgfXB4IDBcblx0JHsgYm94U2hhZG93Q29sb3IgfWA7XG5cblx0cmV0dXJuIGJveFNoYWRvdztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHVzZUVsZXZhdGlvbihcblx0cHJvcHM6IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzPCBFbGV2YXRpb25Qcm9wcywgJ2RpdicgPlxuKSB7XG5cdGNvbnN0IHtcblx0XHRhY3RpdmUsXG5cdFx0Ym9yZGVyUmFkaXVzID0gJ2luaGVyaXQnLFxuXHRcdGNsYXNzTmFtZSxcblx0XHRmb2N1cyxcblx0XHRob3Zlcixcblx0XHRpc0ludGVyYWN0aXZlID0gZmFsc2UsXG5cdFx0b2Zmc2V0ID0gMCxcblx0XHR2YWx1ZSA9IDAsXG5cdFx0Li4ub3RoZXJQcm9wc1xuXHR9ID0gdXNlQ29udGV4dFN5c3RlbSggcHJvcHMsICdFbGV2YXRpb24nICk7XG5cblx0Y29uc3QgY3ggPSB1c2VDeCgpO1xuXG5cdGNvbnN0IGNsYXNzZXMgPSB1c2VNZW1vKCAoKSA9PiB7XG5cdFx0bGV0IGhvdmVyVmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCA9IGlzVmFsdWVEZWZpbmVkKCBob3ZlciApXG5cdFx0XHQ/IGhvdmVyXG5cdFx0XHQ6IHZhbHVlICogMjtcblx0XHRsZXQgYWN0aXZlVmFsdWU6IG51bWJlciB8IHVuZGVmaW5lZCA9IGlzVmFsdWVEZWZpbmVkKCBhY3RpdmUgKVxuXHRcdFx0PyBhY3RpdmVcblx0XHRcdDogdmFsdWUgLyAyO1xuXG5cdFx0aWYgKCAhIGlzSW50ZXJhY3RpdmUgKSB7XG5cdFx0XHRob3ZlclZhbHVlID0gaXNWYWx1ZURlZmluZWQoIGhvdmVyICkgPyBob3ZlciA6IHVuZGVmaW5lZDtcblx0XHRcdGFjdGl2ZVZhbHVlID0gaXNWYWx1ZURlZmluZWQoIGFjdGl2ZSApID8gYWN0aXZlIDogdW5kZWZpbmVkO1xuXHRcdH1cblxuXHRcdGNvbnN0IHRyYW5zaXRpb24gPSBgYm94LXNoYWRvdyAkeyBDT05GSUcudHJhbnNpdGlvbkR1cmF0aW9uIH0gJHsgQ09ORklHLnRyYW5zaXRpb25UaW1pbmdGdW5jdGlvbiB9YDtcblxuXHRcdGNvbnN0IHN4OiB7XG5cdFx0XHRCYXNlPzogU2VyaWFsaXplZFN0eWxlcztcblx0XHRcdGhvdmVyPzogU2VyaWFsaXplZFN0eWxlcztcblx0XHRcdGFjdGl2ZT86IFNlcmlhbGl6ZWRTdHlsZXM7XG5cdFx0XHRmb2N1cz86IFNlcmlhbGl6ZWRTdHlsZXM7XG5cdFx0fSA9IHt9O1xuXG5cdFx0c3guQmFzZSA9IGNzcyhcblx0XHRcdHtcblx0XHRcdFx0Ym9yZGVyUmFkaXVzLFxuXHRcdFx0XHRib3R0b206IG9mZnNldCxcblx0XHRcdFx0Ym94U2hhZG93OiBnZXRCb3hTaGFkb3coIHZhbHVlICksXG5cdFx0XHRcdG9wYWNpdHk6IENPTkZJRy5lbGV2YXRpb25JbnRlbnNpdHksXG5cdFx0XHRcdGxlZnQ6IG9mZnNldCxcblx0XHRcdFx0cmlnaHQ6IG9mZnNldCxcblx0XHRcdFx0dG9wOiBvZmZzZXQsXG5cdFx0XHR9LFxuXHRcdFx0Y3NzYFxuXHRcdFx0XHRAbWVkaWEgbm90ICggcHJlZmVycy1yZWR1Y2VkLW1vdGlvbiApIHtcblx0XHRcdFx0XHR0cmFuc2l0aW9uOiAkeyB0cmFuc2l0aW9uIH07XG5cdFx0XHRcdH1cblx0XHRcdGBcblx0XHQpO1xuXG5cdFx0aWYgKCBpc1ZhbHVlRGVmaW5lZCggaG92ZXJWYWx1ZSApICkge1xuXHRcdFx0c3guaG92ZXIgPSBjc3NgXG5cdFx0XHRcdCo6aG92ZXIgPiAmIHtcblx0XHRcdFx0XHRib3gtc2hhZG93OiAkeyBnZXRCb3hTaGFkb3coIGhvdmVyVmFsdWUgKSB9O1xuXHRcdFx0XHR9XG5cdFx0XHRgO1xuXHRcdH1cblxuXHRcdGlmICggaXNWYWx1ZURlZmluZWQoIGFjdGl2ZVZhbHVlICkgKSB7XG5cdFx0XHRzeC5hY3RpdmUgPSBjc3NgXG5cdFx0XHRcdCo6YWN0aXZlID4gJiB7XG5cdFx0XHRcdFx0Ym94LXNoYWRvdzogJHsgZ2V0Qm94U2hhZG93KCBhY3RpdmVWYWx1ZSApIH07XG5cdFx0XHRcdH1cblx0XHRcdGA7XG5cdFx0fVxuXG5cdFx0aWYgKCBpc1ZhbHVlRGVmaW5lZCggZm9jdXMgKSApIHtcblx0XHRcdHN4LmZvY3VzID0gY3NzYFxuXHRcdFx0XHQqOmZvY3VzID4gJiB7XG5cdFx0XHRcdFx0Ym94LXNoYWRvdzogJHsgZ2V0Qm94U2hhZG93KCBmb2N1cyApIH07XG5cdFx0XHRcdH1cblx0XHRcdGA7XG5cdFx0fVxuXG5cdFx0cmV0dXJuIGN4KFxuXHRcdFx0c3R5bGVzLkVsZXZhdGlvbixcblx0XHRcdHN4LkJhc2UsXG5cdFx0XHRzeC5ob3Zlcixcblx0XHRcdHN4LmZvY3VzLFxuXHRcdFx0c3guYWN0aXZlLFxuXHRcdFx0Y2xhc3NOYW1lXG5cdFx0KTtcblx0fSwgW1xuXHRcdGFjdGl2ZSxcblx0XHRib3JkZXJSYWRpdXMsXG5cdFx0Y2xhc3NOYW1lLFxuXHRcdGN4LFxuXHRcdGZvY3VzLFxuXHRcdGhvdmVyLFxuXHRcdGlzSW50ZXJhY3RpdmUsXG5cdFx0b2Zmc2V0LFxuXHRcdHZhbHVlLFxuXHRdICk7XG5cblx0cmV0dXJuIHsgLi4ub3RoZXJQcm9wcywgY2xhc3NOYW1lOiBjbGFzc2VzLCAnYXJpYS1oaWRkZW4nOiB0cnVlIH07XG59XG4iXX0= */");
    }
    if ((0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(activeValue)) {
      sx.active = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)("*:active>&{box-shadow:", getBoxShadow(activeValue), ";}" + ( false ? 0 : ";label:sx-active;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
    }
    if ((0,_utils_values__WEBPACK_IMPORTED_MODULE_3__.isValueDefined)(focus)) {
      sx.focus = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)("*:focus>&{box-shadow:", getBoxShadow(focus), ";}" + ( false ? 0 : ";label:sx-focus;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
    }
    return cx(_styles__WEBPACK_IMPORTED_MODULE_6__.Elevation, sx.Base, sx.hover, sx.focus, sx.active, className);
  }, [active, borderRadius, className, cx, focus, hover, isInteractive, offset, value]);
  return {
    ...otherProps,
    className: classes,
    'aria-hidden': true
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/styles.js":
/*!*************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/elevation/styles.js ***!
  \*************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Elevation: () => (/* binding */ Elevation)
/* harmony export */ });
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */

const Elevation =  false ? 0 : {
  name: "1n58bsy-Elevation",
  styles: "background:transparent;display:block;margin:0!important;pointer-events:none;position:absolute;will-change:box-shadow;label:Elevation;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZWxldmF0aW9uL3N0eWxlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFLNEIiLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy9lbGV2YXRpb24vc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRWxldmF0aW9uID0gY3NzYFxuXHRiYWNrZ3JvdW5kOiB0cmFuc3BhcmVudDtcblx0ZGlzcGxheTogYmxvY2s7XG5cdG1hcmdpbjogMCAhaW1wb3J0YW50O1xuXHRwb2ludGVyLWV2ZW50czogbm9uZTtcblx0cG9zaXRpb246IGFic29sdXRlO1xuXHR3aWxsLWNoYW5nZTogYm94LXNoYWRvdztcbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/context.js":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/context.js ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FlexContext: () => (/* binding */ FlexContext),
/* harmony export */   useFlexContext: () => (/* binding */ useFlexContext)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

const FlexContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  flexItemDisplay: undefined
});
const useFlexContext = () => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.useContext)(FlexContext);
//# sourceMappingURL=context.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/component.js":
/*!*********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/component.js ***!
  \*********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FlexItem: () => (/* binding */ FlexItem),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../view */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */





function UnconnectedFlexItem(props, forwardedRef) {
  const flexItemProps = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useFlexItem)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_view__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...flexItemProps,
    ref: forwardedRef
  });
}

/**
 * `FlexItem` is a primitive layout component that aligns content within layout
 * containers like `Flex`.
 *
 * ```jsx
 * import { Flex, FlexItem } from '@wordpress/components';
 *
 * function Example() {
 *   return (
 *     <Flex>
 *       <FlexItem>...</FlexItem>
 *     </Flex>
 *   );
 * }
 * ```
 */
const FlexItem = (0,_context__WEBPACK_IMPORTED_MODULE_3__.contextConnect)(UnconnectedFlexItem, 'FlexItem');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FlexItem);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/hook.js":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/hook.js ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFlexItem: () => (/* binding */ useFlexItem)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/context.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/styles.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * External dependencies
 */



/**
 * Internal dependencies
 */





function useFlexItem(props) {
  const {
    className,
    display: displayProp,
    isBlock = false,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_0__.useContextSystem)(props, 'FlexItem');
  const sx = {};
  const contextDisplay = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useFlexContext)().flexItemDisplay;
  sx.Base = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)({
    display: displayProp || contextDisplay
  },  false ? 0 : ";label:sx-Base;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9mbGV4LWl0ZW0vaG9vay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFnQ1ciLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy9mbGV4L2ZsZXgtaXRlbS9ob29rLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHR5cGUgeyBTZXJpYWxpemVkU3R5bGVzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG4vKipcbiAqIEludGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgdHlwZSB7IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyB1c2VDb250ZXh0U3lzdGVtIH0gZnJvbSAnLi4vLi4vY29udGV4dCc7XG5pbXBvcnQgeyB1c2VGbGV4Q29udGV4dCB9IGZyb20gJy4uL2NvbnRleHQnO1xuaW1wb3J0ICogYXMgc3R5bGVzIGZyb20gJy4uL3N0eWxlcyc7XG5pbXBvcnQgeyB1c2VDeCB9IGZyb20gJy4uLy4uL3V0aWxzL2hvb2tzL3VzZS1jeCc7XG5pbXBvcnQgdHlwZSB7IEZsZXhJdGVtUHJvcHMgfSBmcm9tICcuLi90eXBlcyc7XG5cbmV4cG9ydCBmdW5jdGlvbiB1c2VGbGV4SXRlbShcblx0cHJvcHM6IFdvcmRQcmVzc0NvbXBvbmVudFByb3BzPCBGbGV4SXRlbVByb3BzLCAnZGl2JyA+XG4pIHtcblx0Y29uc3Qge1xuXHRcdGNsYXNzTmFtZSxcblx0XHRkaXNwbGF5OiBkaXNwbGF5UHJvcCxcblx0XHRpc0Jsb2NrID0gZmFsc2UsXG5cdFx0Li4ub3RoZXJQcm9wc1xuXHR9ID0gdXNlQ29udGV4dFN5c3RlbSggcHJvcHMsICdGbGV4SXRlbScgKTtcblxuXHRjb25zdCBzeDoge1xuXHRcdEJhc2U/OiBTZXJpYWxpemVkU3R5bGVzO1xuXHR9ID0ge307XG5cblx0Y29uc3QgY29udGV4dERpc3BsYXkgPSB1c2VGbGV4Q29udGV4dCgpLmZsZXhJdGVtRGlzcGxheTtcblxuXHRzeC5CYXNlID0gY3NzKCB7XG5cdFx0ZGlzcGxheTogZGlzcGxheVByb3AgfHwgY29udGV4dERpc3BsYXksXG5cdH0gKTtcblxuXHRjb25zdCBjeCA9IHVzZUN4KCk7XG5cblx0Y29uc3QgY2xhc3NlcyA9IGN4KFxuXHRcdHN0eWxlcy5JdGVtLFxuXHRcdHN4LkJhc2UsXG5cdFx0aXNCbG9jayAmJiBzdHlsZXMuYmxvY2ssXG5cdFx0Y2xhc3NOYW1lXG5cdCk7XG5cblx0cmV0dXJuIHtcblx0XHQuLi5vdGhlclByb3BzLFxuXHRcdGNsYXNzTmFtZTogY2xhc3Nlcyxcblx0fTtcbn1cbiJdfQ== */");
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_3__.useCx)();
  const classes = cx(_styles__WEBPACK_IMPORTED_MODULE_4__.Item, sx.Base, isBlock && _styles__WEBPACK_IMPORTED_MODULE_4__.block, className);
  return {
    ...otherProps,
    className: classes
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex/hook.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex/hook.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFlex: () => (/* binding */ useFlex)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _utils_use_responsive_value__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/use-responsive-value */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/use-responsive-value.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/space */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/space.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/styles.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */






function useDeprecatedProps(props) {
  const {
    isReversed,
    ...otherProps
  } = props;
  if (typeof isReversed !== 'undefined') {
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__["default"])('Flex isReversed', {
      alternative: 'Flex direction="row-reverse" or "column-reverse"',
      since: '5.9'
    });
    return {
      ...otherProps,
      direction: isReversed ? 'row-reverse' : 'row'
    };
  }
  return otherProps;
}
function useFlex(props) {
  const {
    align,
    className,
    direction: directionProp = 'row',
    expanded = true,
    gap = 2,
    justify = 'space-between',
    wrap = false,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useContextSystem)(useDeprecatedProps(props), 'Flex');
  const directionAsArray = Array.isArray(directionProp) ? directionProp : [directionProp];
  const direction = (0,_utils_use_responsive_value__WEBPACK_IMPORTED_MODULE_2__.useResponsiveValue)(directionAsArray);
  const isColumn = typeof direction === 'string' && !!direction.includes('column');
  const cx = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.useCx)();
  const classes = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => {
    const base = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_5__.css)({
      alignItems: align !== null && align !== void 0 ? align : isColumn ? 'normal' : 'center',
      flexDirection: direction,
      flexWrap: wrap ? 'wrap' : undefined,
      gap: (0,_utils_space__WEBPACK_IMPORTED_MODULE_6__.space)(gap),
      justifyContent: justify,
      height: isColumn && expanded ? '100%' : undefined,
      width: !isColumn && expanded ? '100%' : undefined
    },  false ? 0 : ";label:base;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
    return cx(_styles__WEBPACK_IMPORTED_MODULE_7__.Flex, base, isColumn ? _styles__WEBPACK_IMPORTED_MODULE_7__.ItemsColumn : _styles__WEBPACK_IMPORTED_MODULE_7__.ItemsRow, className);
  }, [align, className, cx, direction, expanded, gap, isColumn, justify, wrap]);
  return {
    ...otherProps,
    className: classes,
    isColumn
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/styles.js":
/*!********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/styles.js ***!
  \********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flex: () => (/* binding */ Flex),
/* harmony export */   Item: () => (/* binding */ Item),
/* harmony export */   ItemsColumn: () => (/* binding */ ItemsColumn),
/* harmony export */   ItemsRow: () => (/* binding */ ItemsRow),
/* harmony export */   block: () => (/* binding */ block)
/* harmony export */ });
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */

const Flex =  false ? 0 : {
  name: "a57899-Flex",
  styles: "display:flex;label:Flex;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBS3VCIiwiZmlsZSI6IkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmV4cG9ydCBjb25zdCBGbGV4ID0gY3NzYFxuXHRkaXNwbGF5OiBmbGV4O1xuYDtcblxuZXhwb3J0IGNvbnN0IEl0ZW0gPSBjc3NgXG5cdGRpc3BsYXk6IGJsb2NrO1xuXHRtYXgtaGVpZ2h0OiAxMDAlO1xuXHRtYXgtd2lkdGg6IDEwMCU7XG5cdG1pbi1oZWlnaHQ6IDA7XG5cdG1pbi13aWR0aDogMDtcbmA7XG5cbmV4cG9ydCBjb25zdCBibG9jayA9IGNzc2Bcblx0ZmxleDogMTtcbmA7XG5cbi8qKlxuICogV29ya2Fyb3VuZCB0byBvcHRpbWl6ZSBET00gcmVuZGVyaW5nLlxuICogV2UnbGwgZW5oYW5jZSBhbGlnbm1lbnQgd2l0aCBuYWl2ZSBwYXJlbnQgZmxleCBhc3N1bXB0aW9ucy5cbiAqXG4gKiBUcmFkZS1vZmY6XG4gKiBGYXIgbGVzcyBET00gbGVzcy4gSG93ZXZlciwgVUkgcmVuZGVyaW5nIGlzIG5vdCBhcyByZWxpYWJsZS5cbiAqL1xuXG4vKipcbiAqIEltcHJvdmVzIHN0YWJpbGl0eSBvZiB3aWR0aC9oZWlnaHQgcmVuZGVyaW5nLlxuICogaHR0cHM6Ly9naXRodWIuY29tL0l0c0pvblEvZzIvcHVsbC8xNDlcbiAqL1xuZXhwb3J0IGNvbnN0IEl0ZW1zQ29sdW1uID0gY3NzYFxuXHQ+ICoge1xuXHRcdG1pbi1oZWlnaHQ6IDA7XG5cdH1cbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtc1JvdyA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4td2lkdGg6IDA7XG5cdH1cbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const Item =  false ? 0 : {
  name: "14ac8g8-Item",
  styles: "display:block;max-height:100%;max-width:100%;min-height:0;min-width:0;label:Item;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBU3VCIiwiZmlsZSI6IkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEV4dGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBjc3MgfSBmcm9tICdAZW1vdGlvbi9yZWFjdCc7XG5cbmV4cG9ydCBjb25zdCBGbGV4ID0gY3NzYFxuXHRkaXNwbGF5OiBmbGV4O1xuYDtcblxuZXhwb3J0IGNvbnN0IEl0ZW0gPSBjc3NgXG5cdGRpc3BsYXk6IGJsb2NrO1xuXHRtYXgtaGVpZ2h0OiAxMDAlO1xuXHRtYXgtd2lkdGg6IDEwMCU7XG5cdG1pbi1oZWlnaHQ6IDA7XG5cdG1pbi13aWR0aDogMDtcbmA7XG5cbmV4cG9ydCBjb25zdCBibG9jayA9IGNzc2Bcblx0ZmxleDogMTtcbmA7XG5cbi8qKlxuICogV29ya2Fyb3VuZCB0byBvcHRpbWl6ZSBET00gcmVuZGVyaW5nLlxuICogV2UnbGwgZW5oYW5jZSBhbGlnbm1lbnQgd2l0aCBuYWl2ZSBwYXJlbnQgZmxleCBhc3N1bXB0aW9ucy5cbiAqXG4gKiBUcmFkZS1vZmY6XG4gKiBGYXIgbGVzcyBET00gbGVzcy4gSG93ZXZlciwgVUkgcmVuZGVyaW5nIGlzIG5vdCBhcyByZWxpYWJsZS5cbiAqL1xuXG4vKipcbiAqIEltcHJvdmVzIHN0YWJpbGl0eSBvZiB3aWR0aC9oZWlnaHQgcmVuZGVyaW5nLlxuICogaHR0cHM6Ly9naXRodWIuY29tL0l0c0pvblEvZzIvcHVsbC8xNDlcbiAqL1xuZXhwb3J0IGNvbnN0IEl0ZW1zQ29sdW1uID0gY3NzYFxuXHQ+ICoge1xuXHRcdG1pbi1oZWlnaHQ6IDA7XG5cdH1cbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtc1JvdyA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4td2lkdGg6IDA7XG5cdH1cbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const block =  false ? 0 : {
  name: "1ya6i3g-block",
  styles: "flex:1;label:block;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBaUJ3QiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

/**
 * Workaround to optimize DOM rendering.
 * We'll enhance alignment with naive parent flex assumptions.
 *
 * Trade-off:
 * Far less DOM less. However, UI rendering is not as reliable.
 */

/**
 * Improves stability of width/height rendering.
 * https://github.com/ItsJonQ/g2/pull/149
 */
const ItemsColumn =  false ? 0 : {
  name: "9k4k7f-ItemsColumn",
  styles: ">*{min-height:0;};label:ItemsColumn;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBaUM4QiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
const ItemsRow =  false ? 0 : {
  name: "1ozeagb-ItemsRow",
  styles: ">*{min-width:0;};label:ItemsRow;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvZmxleC9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBdUMyQiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL2ZsZXgvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgRmxleCA9IGNzc2Bcblx0ZGlzcGxheTogZmxleDtcbmA7XG5cbmV4cG9ydCBjb25zdCBJdGVtID0gY3NzYFxuXHRkaXNwbGF5OiBibG9jaztcblx0bWF4LWhlaWdodDogMTAwJTtcblx0bWF4LXdpZHRoOiAxMDAlO1xuXHRtaW4taGVpZ2h0OiAwO1xuXHRtaW4td2lkdGg6IDA7XG5gO1xuXG5leHBvcnQgY29uc3QgYmxvY2sgPSBjc3NgXG5cdGZsZXg6IDE7XG5gO1xuXG4vKipcbiAqIFdvcmthcm91bmQgdG8gb3B0aW1pemUgRE9NIHJlbmRlcmluZy5cbiAqIFdlJ2xsIGVuaGFuY2UgYWxpZ25tZW50IHdpdGggbmFpdmUgcGFyZW50IGZsZXggYXNzdW1wdGlvbnMuXG4gKlxuICogVHJhZGUtb2ZmOlxuICogRmFyIGxlc3MgRE9NIGxlc3MuIEhvd2V2ZXIsIFVJIHJlbmRlcmluZyBpcyBub3QgYXMgcmVsaWFibGUuXG4gKi9cblxuLyoqXG4gKiBJbXByb3ZlcyBzdGFiaWxpdHkgb2Ygd2lkdGgvaGVpZ2h0IHJlbmRlcmluZy5cbiAqIGh0dHBzOi8vZ2l0aHViLmNvbS9JdHNKb25RL2cyL3B1bGwvMTQ5XG4gKi9cbmV4cG9ydCBjb25zdCBJdGVtc0NvbHVtbiA9IGNzc2Bcblx0PiAqIHtcblx0XHRtaW4taGVpZ2h0OiAwO1xuXHR9XG5gO1xuXG5leHBvcnQgY29uc3QgSXRlbXNSb3cgPSBjc3NgXG5cdD4gKiB7XG5cdFx0bWluLXdpZHRoOiAwO1xuXHR9XG5gO1xuIl19 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/component.js":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/component.js ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HStack: () => (/* binding */ HStack),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../view */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * Internal dependencies
 */





function UnconnectedHStack(props, forwardedRef) {
  const hStackProps = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useHStack)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_view__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...hStackProps,
    ref: forwardedRef
  });
}

/**
 * `HStack` (Horizontal Stack) arranges child elements in a horizontal line.
 *
 * `HStack` can render anything inside.
 *
 * ```jsx
 * import {
 * 	__experimentalHStack as HStack,
 * 	__experimentalText as Text,
 * } from `@wordpress/components`;
 *
 * function Example() {
 * 	return (
 * 		<HStack>
 * 			<Text>Code</Text>
 * 			<Text>is</Text>
 * 			<Text>Poetry</Text>
 * 		</HStack>
 * 	);
 * }
 * ```
 */
const HStack = (0,_context__WEBPACK_IMPORTED_MODULE_3__.contextConnect)(UnconnectedHStack, 'HStack');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HStack);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/hook.js":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/hook.js ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useHStack: () => (/* binding */ useHStack)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../flex */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex-item/component.js");
/* harmony import */ var _flex__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../flex */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/flex/flex/hook.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/utils.js");
/* harmony import */ var _utils_get_valid_children__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/get-valid-children */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/get-valid-children.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */






function useHStack(props) {
  const {
    alignment = 'edge',
    children,
    direction,
    spacing = 2,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_1__.useContextSystem)(props, 'HStack');
  const align = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getAlignmentProps)(alignment, direction);
  const validChildren = (0,_utils_get_valid_children__WEBPACK_IMPORTED_MODULE_3__.getValidChildren)(children);
  const clonedChildren = validChildren.map((child, index) => {
    const _isSpacer = (0,_context__WEBPACK_IMPORTED_MODULE_4__.hasConnectNamespace)(child, ['Spacer']);
    if (_isSpacer) {
      const childElement = child;
      const _key = childElement.key || `hstack-${index}`;
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_flex__WEBPACK_IMPORTED_MODULE_5__["default"], {
        isBlock: true,
        ...childElement.props
      }, _key);
    }
    return child;
  });
  const propsForFlex = {
    children: clonedChildren,
    direction,
    justify: 'center',
    ...align,
    ...otherProps,
    gap: spacing
  };

  // Omit `isColumn` because it's not used in HStack.
  const {
    isColumn,
    ...flexProps
  } = (0,_flex__WEBPACK_IMPORTED_MODULE_6__.useFlex)(propsForFlex);
  return flexProps;
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/utils.js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/h-stack/utils.js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAlignmentProps: () => (/* binding */ getAlignmentProps)
/* harmony export */ });
/* harmony import */ var _utils_values__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/values */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/values.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */


const H_ALIGNMENTS = {
  bottom: {
    align: 'flex-end',
    justify: 'center'
  },
  bottomLeft: {
    align: 'flex-end',
    justify: 'flex-start'
  },
  bottomRight: {
    align: 'flex-end',
    justify: 'flex-end'
  },
  center: {
    align: 'center',
    justify: 'center'
  },
  edge: {
    align: 'center',
    justify: 'space-between'
  },
  left: {
    align: 'center',
    justify: 'flex-start'
  },
  right: {
    align: 'center',
    justify: 'flex-end'
  },
  stretch: {
    align: 'stretch'
  },
  top: {
    align: 'flex-start',
    justify: 'center'
  },
  topLeft: {
    align: 'flex-start',
    justify: 'flex-start'
  },
  topRight: {
    align: 'flex-start',
    justify: 'flex-end'
  }
};
const V_ALIGNMENTS = {
  bottom: {
    justify: 'flex-end',
    align: 'center'
  },
  bottomLeft: {
    justify: 'flex-end',
    align: 'flex-start'
  },
  bottomRight: {
    justify: 'flex-end',
    align: 'flex-end'
  },
  center: {
    justify: 'center',
    align: 'center'
  },
  edge: {
    justify: 'space-between',
    align: 'center'
  },
  left: {
    justify: 'center',
    align: 'flex-start'
  },
  right: {
    justify: 'center',
    align: 'flex-end'
  },
  stretch: {
    align: 'stretch'
  },
  top: {
    justify: 'flex-start',
    align: 'center'
  },
  topLeft: {
    justify: 'flex-start',
    align: 'flex-start'
  },
  topRight: {
    justify: 'flex-start',
    align: 'flex-end'
  }
};
function getAlignmentProps(alignment, direction = 'row') {
  if (!(0,_utils_values__WEBPACK_IMPORTED_MODULE_0__.isValueDefined)(alignment)) {
    return {};
  }
  const isVertical = direction === 'column';
  const props = isVertical ? V_ALIGNMENTS : H_ALIGNMENTS;
  const alignmentProps = alignment in props ? props[alignment] : {
    align: alignment
  };
  return alignmentProps;
}
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/icon/index.js":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/icon/index.js ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/primitives */ "./node_modules/.pnpm/@wordpress+primitives@4.30.0_react@18.3.1/node_modules/@wordpress/primitives/build-module/svg/index.js");
/* harmony import */ var _dashicon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dashicon */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/dashicon/index.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Renders a raw icon without any initial styling or wrappers.
 *
 * ```jsx
 * import { wordpress } from '@wordpress/icons';
 *
 * <Icon icon={ wordpress } />
 * ```
 */
function Icon({
  icon = null,
  size = 'string' === typeof icon ? 20 : 24,
  ...additionalProps
}) {
  if ('string' === typeof icon) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_dashicon__WEBPACK_IMPORTED_MODULE_1__["default"], {
      icon: icon,
      size: size,
      ...additionalProps
    });
  }
  if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.isValidElement)(icon) && _dashicon__WEBPACK_IMPORTED_MODULE_1__["default"] === icon.type) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.cloneElement)(icon, {
      ...additionalProps
    });
  }
  if ('function' === typeof icon) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createElement)(icon, {
      size,
      ...additionalProps
    });
  }
  if (icon && (icon.type === 'svg' || icon.type === _wordpress_primitives__WEBPACK_IMPORTED_MODULE_3__.SVG)) {
    const appliedProps = {
      ...icon.props,
      width: size,
      height: size,
      ...additionalProps
    };
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_3__.SVG, {
      ...appliedProps
    });
  }
  if ((0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.isValidElement)(icon)) {
    return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.cloneElement)(icon, {
      // @ts-ignore Just forwarding the size prop along
      size,
      width: size,
      height: size,
      ...additionalProps
    });
  }
  return icon;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/aria-helper.js":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/aria-helper.js ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   elementShouldBeHidden: () => (/* binding */ elementShouldBeHidden),
/* harmony export */   modalize: () => (/* binding */ modalize),
/* harmony export */   unmodalize: () => (/* binding */ unmodalize)
/* harmony export */ });
const LIVE_REGION_ARIA_ROLES = new Set(['alert', 'status', 'log', 'marquee', 'timer']);
const hiddenElementsByDepth = [];

/**
 * Hides all elements in the body element from screen-readers except
 * the provided element and elements that should not be hidden from
 * screen-readers.
 *
 * The reason we do this is because `aria-modal="true"` currently is bugged
 * in Safari, and support is spotty in other browsers overall. In the future
 * we should consider removing these helper functions in favor of
 * `aria-modal="true"`.
 *
 * @param modalElement The element that should not be hidden.
 */
function modalize(modalElement) {
  const elements = Array.from(document.body.children);
  const hiddenElements = [];
  hiddenElementsByDepth.push(hiddenElements);
  for (const element of elements) {
    if (element === modalElement) {
      continue;
    }
    if (elementShouldBeHidden(element)) {
      element.setAttribute('aria-hidden', 'true');
      hiddenElements.push(element);
    }
  }
}

/**
 * Determines if the passed element should not be hidden from screen readers.
 *
 * @param element The element that should be checked.
 *
 * @return Whether the element should not be hidden from screen-readers.
 */
function elementShouldBeHidden(element) {
  const role = element.getAttribute('role');
  return !(element.tagName === 'SCRIPT' || element.hasAttribute('hidden') || element.hasAttribute('aria-hidden') || element.hasAttribute('aria-live') || role && LIVE_REGION_ARIA_ROLES.has(role));
}

/**
 * Accessibly reveals the elements hidden by the latest modal.
 */
function unmodalize() {
  const hiddenElements = hiddenElementsByDepth.pop();
  if (!hiddenElements) {
    return;
  }
  for (const element of hiddenElements) {
    element.removeAttribute('aria-hidden');
  }
}
//# sourceMappingURL=aria-helper.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/index.js":
/*!********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/index.js ***!
  \********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Modal: () => (/* binding */ Modal),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react-dom@18.3.1_react@18.3.1/node_modules/react-dom/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-focus-on-mount/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-constrained-tabbing/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-focus-return/index.js");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-merge-refs/index.js");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/.pnpm/@wordpress+i18n@6.3.0/node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/.pnpm/@wordpress+icons@10.30.0_react@18.3.1/node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @wordpress/dom */ "./node_modules/.pnpm/@wordpress+dom@4.30.0/node_modules/@wordpress/dom/build-module/dom/get-scroll-container.js");
/* harmony import */ var _aria_helper__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./aria-helper */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/aria-helper.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../button */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/button/index.js");
/* harmony import */ var _style_provider__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../style-provider */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/style-provider/index.js");
/* harmony import */ var _utils_with_ignore_ime_events__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/with-ignore-ime-events */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/with-ignore-ime-events.js");
/* harmony import */ var _spacer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../spacer */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/component.js");
/* harmony import */ var _use_modal_exit_animation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./use-modal-exit-animation */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/use-modal-exit-animation.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */







// Used to track and dismiss the prior modal when another opens unless nested.

const ModalContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.createContext)(new Set());
ModalContext.displayName = 'ModalContext';

// Used to track body class names applied while modals are open.
const bodyOpenClasses = new Map();
function UnforwardedModal(props, forwardedRef) {
  const {
    bodyOpenClassName = 'modal-open',
    role = 'dialog',
    title = null,
    focusOnMount = true,
    shouldCloseOnEsc = true,
    shouldCloseOnClickOutside = true,
    isDismissible = true,
    /* Accessibility. */
    aria = {
      labelledby: undefined,
      describedby: undefined
    },
    onRequestClose,
    icon,
    closeButtonLabel,
    children,
    style,
    overlayClassName: overlayClassnameProp,
    className,
    contentLabel,
    onKeyDown,
    isFullScreen = false,
    size,
    headerActions = null,
    __experimentalHideHeader = false
  } = props;
  const ref = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)();
  const instanceId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["default"])(Modal);
  const headingId = title ? `components-modal-header-${instanceId}` : aria.labelledby;

  // The focus hook does not support 'firstContentElement' but this is a valid
  // value for the Modal's focusOnMount prop. The following code ensures the focus
  // hook will focus the first focusable node within the element to which it is applied.
  // When `firstContentElement` is passed as the value of the focusOnMount prop,
  // the focus hook is applied to the Modal's content element.
  // Otherwise, the focus hook is applied to the Modal's ref. This ensures that the
  // focus hook will focus the first element in the Modal's **content** when
  // `firstContentElement` is passed.
  const focusOnMountRef = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_5__["default"])(focusOnMount === 'firstContentElement' ? 'firstElement' : focusOnMount);
  const constrainedTabbingRef = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const focusReturnRef = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_7__["default"])();
  const contentRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(null);
  const childrenContainerRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)(null);
  const [hasScrolledContent, setHasScrolledContent] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const [hasScrollableContent, setHasScrollableContent] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  let sizeClass;
  if (isFullScreen || size === 'fill') {
    sizeClass = 'is-full-screen';
  } else if (size) {
    sizeClass = `has-size-${size}`;
  }

  // Determines whether the Modal content is scrollable and updates the state.
  const isContentScrollable = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
    if (!contentRef.current) {
      return;
    }
    const closestScrollContainer = (0,_wordpress_dom__WEBPACK_IMPORTED_MODULE_8__["default"])(contentRef.current);
    if (contentRef.current === closestScrollContainer) {
      setHasScrollableContent(true);
    } else {
      setHasScrollableContent(false);
    }
  }, [contentRef]);

  // Accessibly isolates/unisolates the modal.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    _aria_helper__WEBPACK_IMPORTED_MODULE_9__.modalize(ref.current);
    return () => _aria_helper__WEBPACK_IMPORTED_MODULE_9__.unmodalize();
  }, []);

  // Keeps a fresh ref for the subsequent effect.
  const onRequestCloseRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useRef)();
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    onRequestCloseRef.current = onRequestClose;
  }, [onRequestClose]);

  // The list of `onRequestClose` callbacks of open (non-nested) Modals. Only
  // one should remain open at a time and the list enables closing prior ones.
  const dismissers = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useContext)(ModalContext);
  // Used for the tracking and dismissing any nested modals.
  const [nestedDismissers] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useState)(() => new Set());

  // Updates the stack tracking open modals at this level and calls
  // onRequestClose for any prior and/or nested modals as applicable.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    // add this modal instance to the dismissers set
    dismissers.add(onRequestCloseRef);
    // request that all the other modals close themselves
    for (const dismisser of dismissers) {
      if (dismisser !== onRequestCloseRef) {
        dismisser.current?.();
      }
    }
    return () => {
      // request that all the nested modals close themselves
      for (const dismisser of nestedDismissers) {
        dismisser.current?.();
      }
      // remove this modal instance from the dismissers set
      dismissers.delete(onRequestCloseRef);
    };
  }, [dismissers, nestedDismissers]);

  // Adds/removes the value of bodyOpenClassName to body element.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
    var _bodyOpenClasses$get;
    const theClass = bodyOpenClassName;
    const oneMore = 1 + ((_bodyOpenClasses$get = bodyOpenClasses.get(theClass)) !== null && _bodyOpenClasses$get !== void 0 ? _bodyOpenClasses$get : 0);
    bodyOpenClasses.set(theClass, oneMore);
    document.body.classList.add(bodyOpenClassName);
    return () => {
      const oneLess = bodyOpenClasses.get(theClass) - 1;
      if (oneLess === 0) {
        document.body.classList.remove(theClass);
        bodyOpenClasses.delete(theClass);
      } else {
        bodyOpenClasses.set(theClass, oneLess);
      }
    };
  }, [bodyOpenClassName]);
  const {
    closeModal,
    frameRef,
    frameStyle,
    overlayClassname
  } = (0,_use_modal_exit_animation__WEBPACK_IMPORTED_MODULE_10__.useModalExitAnimation)();

  // Calls the isContentScrollable callback when the Modal children container resizes.
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useLayoutEffect)(() => {
    if (!window.ResizeObserver || !childrenContainerRef.current) {
      return;
    }
    const resizeObserver = new ResizeObserver(isContentScrollable);
    resizeObserver.observe(childrenContainerRef.current);
    isContentScrollable();
    return () => {
      resizeObserver.disconnect();
    };
  }, [isContentScrollable, childrenContainerRef]);
  function handleEscapeKeyDown(event) {
    if (shouldCloseOnEsc && (event.code === 'Escape' || event.key === 'Escape') && !event.defaultPrevented) {
      event.preventDefault();
      closeModal().then(() => onRequestClose(event));
    }
  }
  const onContentContainerScroll = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)(e => {
    var _e$currentTarget$scro;
    const scrollY = (_e$currentTarget$scro = e?.currentTarget?.scrollTop) !== null && _e$currentTarget$scro !== void 0 ? _e$currentTarget$scro : -1;
    if (!hasScrolledContent && scrollY > 0) {
      setHasScrolledContent(true);
    } else if (hasScrolledContent && scrollY <= 0) {
      setHasScrolledContent(false);
    }
  }, [hasScrolledContent]);
  let pressTarget = null;
  const overlayPressHandlers = {
    onPointerDown: event => {
      if (event.target === event.currentTarget) {
        pressTarget = event.target;
        // Avoids focus changing so that focus return works as expected.
        event.preventDefault();
      }
    },
    // Closes the modal with two exceptions. 1. Opening the context menu on
    // the overlay. 2. Pressing on the overlay then dragging the pointer
    // over the modal and releasing. Due to the modal being a child of the
    // overlay, such a gesture is a `click` on the overlay and cannot be
    // excepted by a `click` handler. Thus the tactic of handling
    // `pointerup` and comparing its target to that of the `pointerdown`.
    onPointerUp: ({
      target,
      button
    }) => {
      const isSameTarget = target === pressTarget;
      pressTarget = null;
      if (button === 0 && isSameTarget) {
        closeModal().then(() => onRequestClose());
      }
    }
  };
  const modal =
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/no-static-element-interactions
  (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
    ref: (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_11__["default"])([ref, forwardedRef]),
    className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-modal__screen-overlay', overlayClassname, overlayClassnameProp),
    onKeyDown: (0,_utils_with_ignore_ime_events__WEBPACK_IMPORTED_MODULE_12__.withIgnoreIMEEvents)(handleEscapeKeyDown),
    ...(shouldCloseOnClickOutside ? overlayPressHandlers : {}),
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_style_provider__WEBPACK_IMPORTED_MODULE_13__["default"], {
      document: document,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
        className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-modal__frame', sizeClass, className),
        style: {
          ...frameStyle,
          ...style
        },
        ref: (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_11__["default"])([frameRef, constrainedTabbingRef, focusReturnRef, focusOnMount !== 'firstContentElement' ? focusOnMountRef : null]),
        role: role,
        "aria-label": contentLabel,
        "aria-labelledby": contentLabel ? undefined : headingId,
        "aria-describedby": aria.describedby,
        tabIndex: -1,
        onKeyDown: onKeyDown,
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
          className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-modal__content', {
            'hide-header': __experimentalHideHeader,
            'is-scrollable': hasScrollableContent,
            'has-scrolled-content': hasScrolledContent
          }),
          role: "document",
          onScroll: onContentContainerScroll,
          ref: contentRef,
          "aria-label": hasScrollableContent ? (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Scrollable section') : undefined,
          tabIndex: hasScrollableContent ? 0 : undefined,
          children: [!__experimentalHideHeader && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
            className: "components-modal__header",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)("div", {
              className: "components-modal__header-heading-container",
              children: [icon && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("span", {
                className: "components-modal__icon-container",
                "aria-hidden": true,
                children: icon
              }), title && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("h1", {
                id: headingId,
                className: "components-modal__header-heading",
                children: title
              })]
            }), headerActions, isDismissible && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.Fragment, {
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_spacer__WEBPACK_IMPORTED_MODULE_14__["default"], {
                marginBottom: 0,
                marginLeft: 2
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(_button__WEBPACK_IMPORTED_MODULE_15__["default"], {
                size: "compact",
                onClick: event => closeModal().then(() => onRequestClose(event)),
                icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_16__["default"],
                label: closeButtonLabel || (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Close')
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)("div", {
            ref: (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_11__["default"])([childrenContainerRef, focusOnMount === 'firstContentElement' ? focusOnMountRef : null]),
            children: children
          })]
        })
      })
    })
  });
  return (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_17__.createPortal)(/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx)(ModalContext.Provider, {
    value: nestedDismissers,
    children: modal
  }), document.body);
}

/**
 * Modals give users information and choices related to a task they’re trying to
 * accomplish. They can contain critical information, require decisions, or
 * involve multiple tasks.
 *
 * ```jsx
 * import { Button, Modal } from '@wordpress/components';
 * import { useState } from '@wordpress/element';
 *
 * const MyModal = () => {
 *   const [ isOpen, setOpen ] = useState( false );
 *   const openModal = () => setOpen( true );
 *   const closeModal = () => setOpen( false );
 *
 *   return (
 *     <>
 *       <Button variant="secondary" onClick={ openModal }>
 *         Open Modal
 *       </Button>
 *       { isOpen && (
 *         <Modal title="This is my modal" onRequestClose={ closeModal }>
 *           <Button variant="secondary" onClick={ closeModal }>
 *             My custom close button
 *           </Button>
 *         </Modal>
 *       ) }
 *     </>
 *   );
 * };
 * ```
 */
const Modal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.forwardRef)(UnforwardedModal);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Modal);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/use-modal-exit-animation.js":
/*!***************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/modal/use-modal-exit-animation.js ***!
  \***************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useModalExitAnimation: () => (/* binding */ useModalExitAnimation)
/* harmony export */ });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-reduced-motion/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/warning */ "./node_modules/.pnpm/@wordpress+warning@3.30.0/node_modules/@wordpress/warning/build-module/index.js");
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



// Animation duration (ms) extracted to JS in order to be used on a setTimeout.
const FRAME_ANIMATION_DURATION = _utils__WEBPACK_IMPORTED_MODULE_0__["default"].transitionDuration;
const FRAME_ANIMATION_DURATION_NUMBER = Number.parseInt(_utils__WEBPACK_IMPORTED_MODULE_0__["default"].transitionDuration);
const EXIT_ANIMATION_NAME = 'components-modal__disappear-animation';
function useModalExitAnimation() {
  const frameRef = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useRef)();
  const [isAnimatingOut, setIsAnimatingOut] = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const isReducedMotion = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__["default"])();
  const closeModal = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_1__.useCallback)(() => new Promise(closeModalResolve => {
    // Grab a "stable" reference of the frame element, since
    // the value held by the react ref might change at runtime.
    const frameEl = frameRef.current;
    if (isReducedMotion) {
      closeModalResolve();
      return;
    }
    if (!frameEl) {
      globalThis.SCRIPT_DEBUG === true ? (0,_wordpress_warning__WEBPACK_IMPORTED_MODULE_3__["default"])("wp.components.Modal: the Modal component can't be closed with an exit animation because of a missing reference to the modal frame element.") : void 0;
      closeModalResolve();
      return;
    }
    let handleAnimationEnd;
    const startAnimation = () => new Promise(animationResolve => {
      handleAnimationEnd = e => {
        if (e.animationName === EXIT_ANIMATION_NAME) {
          animationResolve();
        }
      };
      frameEl.addEventListener('animationend', handleAnimationEnd);
      setIsAnimatingOut(true);
    });
    const animationTimeout = () => new Promise(timeoutResolve => {
      setTimeout(() => timeoutResolve(),
      // Allow an extra 20% of the animation duration for the
      // animationend event to fire, in case the animation frame is
      // slightly delayes by some other events in the event loop.
      FRAME_ANIMATION_DURATION_NUMBER * 1.2);
    });
    Promise.race([startAnimation(), animationTimeout()]).then(() => {
      if (handleAnimationEnd) {
        frameEl.removeEventListener('animationend', handleAnimationEnd);
      }
      setIsAnimatingOut(false);
      closeModalResolve();
    });
  }), [isReducedMotion]);
  return {
    overlayClassname: isAnimatingOut ? 'is-animating-out' : undefined,
    frameRef,
    frameStyle: {
      '--modal-frame-animation-duration': `${FRAME_ANIMATION_DURATION}`
    },
    closeModal
  };
}
//# sourceMappingURL=use-modal-exit-animation.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/notice/index.js":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/notice/index.js ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/i18n */ "./node_modules/.pnpm/@wordpress+i18n@6.3.0/node_modules/@wordpress/i18n/build-module/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/@wordpress+element@6.30.0/node_modules/@wordpress/element/build-module/serialize.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/@wordpress+element@6.30.0/node_modules/@wordpress/element/build-module/raw-html.js");
/* harmony import */ var _wordpress_a11y__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/a11y */ "./node_modules/.pnpm/@wordpress+a11y@4.30.0/node_modules/@wordpress/a11y/build-module/index.js");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @wordpress/icons */ "./node_modules/.pnpm/@wordpress+icons@10.30.0_react@18.3.1/node_modules/@wordpress/icons/build-module/library/close.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../button */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/button/index.js");
/* harmony import */ var _visually_hidden__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../visually-hidden */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/visually-hidden/component.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



const noop = () => {};

/**
 * Custom hook which announces the message with the given politeness, if a
 * valid message is provided.
 */
function useSpokenMessage(message, politeness) {
  const spokenMessage = typeof message === 'string' ? message : (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_4__["default"])(message);
  (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (spokenMessage) {
      (0,_wordpress_a11y__WEBPACK_IMPORTED_MODULE_2__.speak)(spokenMessage, politeness);
    }
  }, [spokenMessage, politeness]);
}
function getDefaultPoliteness(status) {
  switch (status) {
    case 'success':
    case 'warning':
    case 'info':
      return 'polite';
    // The default will also catch the 'error' status.
    default:
      return 'assertive';
  }
}
function getStatusLabel(status) {
  switch (status) {
    case 'warning':
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Warning notice');
    case 'info':
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Information notice');
    case 'error':
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Error notice');
    // The default will also catch the 'success' status.
    default:
      return (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Notice');
  }
}

/**
 * `Notice` is a component used to communicate feedback to the user.
 *
 *```jsx
 * import { Notice } from `@wordpress/components`;
 *
 * const MyNotice = () => (
 *   <Notice status="error">An unknown error occurred.</Notice>
 * );
 * ```
 */
function Notice({
  className,
  status = 'info',
  children,
  spokenMessage = children,
  onRemove = noop,
  isDismissible = true,
  actions = [],
  politeness = getDefaultPoliteness(status),
  __unstableHTML,
  // onDismiss is a callback executed when the notice is dismissed.
  // It is distinct from onRemove, which _looks_ like a callback but is
  // actually the function to call to remove the notice from the UI.
  onDismiss = noop
}) {
  useSpokenMessage(spokenMessage, politeness);
  const classes = (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])(className, 'components-notice', 'is-' + status, {
    'is-dismissible': isDismissible
  });
  if (__unstableHTML && typeof children === 'string') {
    children = /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_wordpress_element__WEBPACK_IMPORTED_MODULE_6__["default"], {
      children: children
    });
  }
  const onDismissNotice = () => {
    onDismiss();
    onRemove();
  };
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
    className: classes,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_visually_hidden__WEBPACK_IMPORTED_MODULE_7__["default"], {
      children: getStatusLabel(status)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsxs)("div", {
      className: "components-notice__content",
      children: [children, /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)("div", {
        className: "components-notice__actions",
        children: actions.map(({
          className: buttonCustomClasses,
          label,
          isPrimary,
          variant,
          noDefaultClasses = false,
          onClick,
          url
        }, index) => {
          let computedVariant = variant;
          if (variant !== 'primary' && !noDefaultClasses) {
            computedVariant = !url ? 'secondary' : 'link';
          }
          if (typeof computedVariant === 'undefined' && isPrimary) {
            computedVariant = 'primary';
          }
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_button__WEBPACK_IMPORTED_MODULE_8__["default"], {
            __next40pxDefaultSize: true,
            href: url,
            variant: computedVariant,
            onClick: url ? undefined : onClick,
            className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-notice__action', buttonCustomClasses),
            children: label
          }, index);
        })
      })]
    }), isDismissible && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_3__.jsx)(_button__WEBPACK_IMPORTED_MODULE_8__["default"], {
      size: "small",
      className: "components-notice__dismiss",
      icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_9__["default"],
      label: (0,_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__.__)('Close'),
      onClick: onDismissNotice
    })]
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Notice);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/popover/utils.js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/popover/utils.js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   computePopoverPosition: () => (/* binding */ computePopoverPosition),
/* harmony export */   getReferenceElement: () => (/* binding */ getReferenceElement),
/* harmony export */   placementToMotionAnimationProps: () => (/* binding */ placementToMotionAnimationProps),
/* harmony export */   positionToPlacement: () => (/* binding */ positionToPlacement)
/* harmony export */ });
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */

const POSITION_TO_PLACEMENT = {
  bottom: 'bottom',
  top: 'top',
  'middle left': 'left',
  'middle right': 'right',
  'bottom left': 'bottom-end',
  'bottom center': 'bottom',
  'bottom right': 'bottom-start',
  'top left': 'top-end',
  'top center': 'top',
  'top right': 'top-start',
  'middle left left': 'left',
  'middle left right': 'left',
  'middle left bottom': 'left-end',
  'middle left top': 'left-start',
  'middle right left': 'right',
  'middle right right': 'right',
  'middle right bottom': 'right-end',
  'middle right top': 'right-start',
  'bottom left left': 'bottom-end',
  'bottom left right': 'bottom-end',
  'bottom left bottom': 'bottom-end',
  'bottom left top': 'bottom-end',
  'bottom center left': 'bottom',
  'bottom center right': 'bottom',
  'bottom center bottom': 'bottom',
  'bottom center top': 'bottom',
  'bottom right left': 'bottom-start',
  'bottom right right': 'bottom-start',
  'bottom right bottom': 'bottom-start',
  'bottom right top': 'bottom-start',
  'top left left': 'top-end',
  'top left right': 'top-end',
  'top left bottom': 'top-end',
  'top left top': 'top-end',
  'top center left': 'top',
  'top center right': 'top',
  'top center bottom': 'top',
  'top center top': 'top',
  'top right left': 'top-start',
  'top right right': 'top-start',
  'top right bottom': 'top-start',
  'top right top': 'top-start',
  // `middle`/`middle center [corner?]` positions are associated to a fallback
  // `bottom` placement because there aren't any corresponding placement values.
  middle: 'bottom',
  'middle center': 'bottom',
  'middle center bottom': 'bottom',
  'middle center left': 'bottom',
  'middle center right': 'bottom',
  'middle center top': 'bottom'
};

/**
 * Converts the `Popover`'s legacy "position" prop to the new "placement" prop
 * (used by `floating-ui`).
 *
 * @param position The legacy position
 * @return The corresponding placement
 */
const positionToPlacement = position => {
  var _POSITION_TO_PLACEMEN;
  return (_POSITION_TO_PLACEMEN = POSITION_TO_PLACEMENT[position]) !== null && _POSITION_TO_PLACEMEN !== void 0 ? _POSITION_TO_PLACEMEN : 'bottom';
};

/**
 * @typedef AnimationOrigin
 * @type {Object}
 * @property {number} originX A number between 0 and 1 (in CSS logical properties jargon, 0 is "start", 0.5 is "center", and 1 is "end")
 * @property {number} originY A number between 0 and 1 (0 is top, 0.5 is center, and 1 is bottom)
 */

const PLACEMENT_TO_ANIMATION_ORIGIN = {
  top: {
    originX: 0.5,
    originY: 1
  },
  // open from bottom, center
  'top-start': {
    originX: 0,
    originY: 1
  },
  // open from bottom, left
  'top-end': {
    originX: 1,
    originY: 1
  },
  // open from bottom, right
  right: {
    originX: 0,
    originY: 0.5
  },
  // open from middle, left
  'right-start': {
    originX: 0,
    originY: 0
  },
  // open from top, left
  'right-end': {
    originX: 0,
    originY: 1
  },
  // open from bottom, left
  bottom: {
    originX: 0.5,
    originY: 0
  },
  // open from top, center
  'bottom-start': {
    originX: 0,
    originY: 0
  },
  // open from top, left
  'bottom-end': {
    originX: 1,
    originY: 0
  },
  // open from top, right
  left: {
    originX: 1,
    originY: 0.5
  },
  // open from middle, right
  'left-start': {
    originX: 1,
    originY: 0
  },
  // open from top, right
  'left-end': {
    originX: 1,
    originY: 1
  },
  // open from bottom, right
  overlay: {
    originX: 0.5,
    originY: 0.5
  } // open from center, center
};

/**
 * Given the floating-ui `placement`, compute the framer-motion props for the
 * popover's entry animation.
 *
 * @param placement A placement string from floating ui
 * @return The object containing the motion props
 */
const placementToMotionAnimationProps = placement => {
  const translateProp = placement.startsWith('top') || placement.startsWith('bottom') ? 'translateY' : 'translateX';
  const translateDirection = placement.startsWith('top') || placement.startsWith('left') ? 1 : -1;
  return {
    style: PLACEMENT_TO_ANIMATION_ORIGIN[placement],
    initial: {
      opacity: 0,
      scale: 0,
      [translateProp]: `${2 * translateDirection}em`
    },
    animate: {
      opacity: 1,
      scale: 1,
      [translateProp]: 0
    },
    transition: {
      duration: 0.1,
      ease: [0, 0, 0.2, 1]
    }
  };
};
function isTopBottom(anchorRef) {
  return !!anchorRef?.top;
}
function isRef(anchorRef) {
  return !!anchorRef?.current;
}
const getReferenceElement = ({
  anchor,
  anchorRef,
  anchorRect,
  getAnchorRect,
  fallbackReferenceElement
}) => {
  var _referenceElement;
  let referenceElement = null;
  if (anchor) {
    referenceElement = anchor;
  } else if (isTopBottom(anchorRef)) {
    // Create a virtual element for the ref. The expectation is that
    // if anchorRef.top is defined, then anchorRef.bottom is defined too.
    // Seems to be used by the block toolbar, when multiple blocks are selected
    // (top and bottom blocks are used to calculate the resulting rect).
    referenceElement = {
      getBoundingClientRect() {
        const topRect = anchorRef.top.getBoundingClientRect();
        const bottomRect = anchorRef.bottom.getBoundingClientRect();
        return new window.DOMRect(topRect.x, topRect.y, topRect.width, bottomRect.bottom - topRect.top);
      }
    };
  } else if (isRef(anchorRef)) {
    // Standard React ref.
    referenceElement = anchorRef.current;
  } else if (anchorRef) {
    // If `anchorRef` holds directly the element's value (no `current` key)
    // This is a weird scenario and should be deprecated.
    referenceElement = anchorRef;
  } else if (anchorRect) {
    // Create a virtual element for the ref.
    referenceElement = {
      getBoundingClientRect() {
        return anchorRect;
      }
    };
  } else if (getAnchorRect) {
    // Create a virtual element for the ref.
    referenceElement = {
      getBoundingClientRect() {
        var _rect$x, _rect$y, _rect$width, _rect$height;
        const rect = getAnchorRect(fallbackReferenceElement);
        return new window.DOMRect((_rect$x = rect.x) !== null && _rect$x !== void 0 ? _rect$x : rect.left, (_rect$y = rect.y) !== null && _rect$y !== void 0 ? _rect$y : rect.top, (_rect$width = rect.width) !== null && _rect$width !== void 0 ? _rect$width : rect.right - rect.left, (_rect$height = rect.height) !== null && _rect$height !== void 0 ? _rect$height : rect.bottom - rect.top);
      }
    };
  } else if (fallbackReferenceElement) {
    // If no explicit ref is passed via props, fall back to
    // anchoring to the popover's parent node.
    referenceElement = fallbackReferenceElement.parentElement;
  }

  // Convert any `undefined` value to `null`.
  return (_referenceElement = referenceElement) !== null && _referenceElement !== void 0 ? _referenceElement : null;
};

/**
 * Computes the final coordinate that needs to be applied to the floating
 * element when applying transform inline styles, defaulting to `undefined`
 * if the provided value is `null` or `NaN`.
 *
 * @param c input coordinate (usually as returned from floating-ui)
 * @return The coordinate's value to be used for inline styles. An `undefined`
 *         return value means "no style set" for this coordinate.
 */
const computePopoverPosition = c => c === null || Number.isNaN(c) ? undefined : Math.round(c);
//# sourceMappingURL=utils.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/shortcut/index.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/shortcut/index.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");

/**
 * Internal dependencies
 */

/**
 * Shortcut component is used to display keyboard shortcuts, and it can be customized with a custom display and aria label if needed.
 *
 * ```jsx
 * import { Shortcut } from '@wordpress/components';
 *
 * const MyShortcut = () => {
 * 	return (
 * 		<Shortcut shortcut={{ display: 'Ctrl + S', ariaLabel: 'Save' }} />
 * 	);
 * };
 * ```
 */
function Shortcut(props) {
  const {
    shortcut,
    className
  } = props;
  if (!shortcut) {
    return null;
  }
  let displayText;
  let ariaLabel;
  if (typeof shortcut === 'string') {
    displayText = shortcut;
  }
  if (shortcut !== null && typeof shortcut === 'object') {
    displayText = shortcut.display;
    ariaLabel = shortcut.ariaLabel;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", {
    className: className,
    "aria-label": ariaLabel,
    children: displayText
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Shortcut);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/component.js":
/*!*************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/component.js ***!
  \*************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Spacer: () => (/* binding */ Spacer),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/context-connect.js");
/* harmony import */ var _view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../view */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/view/component.js");
/* harmony import */ var _hook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hook */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/hook.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */

/**
 * Internal dependencies
 */





function UnconnectedSpacer(props, forwardedRef) {
  const spacerProps = (0,_hook__WEBPACK_IMPORTED_MODULE_1__.useSpacer)(props);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_view__WEBPACK_IMPORTED_MODULE_2__["default"], {
    ...spacerProps,
    ref: forwardedRef
  });
}

/**
 * `Spacer` is a primitive layout component that providers inner (`padding`) or outer (`margin`) space in-between components. It can also be used to adaptively provide space within an `HStack` or `VStack`.
 *
 * `Spacer` comes with a bunch of shorthand props to adjust `margin` and `padding`. The values of these props
 * can either be a number (which will act as a multiplier to the library's grid system base of 4px),
 * or a literal CSS value string.
 *
 * ```jsx
 * import { Spacer } from `@wordpress/components`
 *
 * function Example() {
 *   return (
 *     <View>
 *       <Spacer>
 *         <Heading>WordPress.org</Heading>
 *       </Spacer>
 *       <Text>
 *         Code is Poetry
 *       </Text>
 *     </View>
 *   );
 * }
 * ```
 */
const Spacer = (0,_context__WEBPACK_IMPORTED_MODULE_3__.contextConnect)(UnconnectedSpacer, 'Spacer');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Spacer);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/hook.js":
/*!********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/spacer/hook.js ***!
  \********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useSpacer: () => (/* binding */ useSpacer)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _utils_space__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/space */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/space.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/rtl.js");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




function isDefined(o) {
  return typeof o !== 'undefined' && o !== null;
}
function useSpacer(props) {
  const {
    className,
    margin,
    marginBottom = 2,
    marginLeft,
    marginRight,
    marginTop,
    marginX,
    marginY,
    padding,
    paddingBottom,
    paddingLeft,
    paddingRight,
    paddingTop,
    paddingX,
    paddingY,
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_0__.useContextSystem)(props, 'Spacer');
  const cx = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.useCx)();
  const classes = cx(isDefined(margin) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("margin:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(margin), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(marginY) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginY), ";margin-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginY), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(marginX) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("margin-left:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginX), ";margin-right:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginX), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(marginTop) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("margin-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginTop), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(marginBottom) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("margin-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginBottom), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(marginLeft) && (0,_utils__WEBPACK_IMPORTED_MODULE_4__.rtl)({
    marginLeft: (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginLeft)
  })(), isDefined(marginRight) && (0,_utils__WEBPACK_IMPORTED_MODULE_4__.rtl)({
    marginRight: (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(marginRight)
  })(), isDefined(padding) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("padding:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(padding), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(paddingY) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("padding-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingY), ";padding-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingY), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(paddingX) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("padding-left:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingX), ";padding-right:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingX), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(paddingTop) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("padding-top:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingTop), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(paddingBottom) && /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__.css)("padding-bottom:", (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingBottom), ";" + ( false ? 0 : ";label:classes;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"), isDefined(paddingLeft) && (0,_utils__WEBPACK_IMPORTED_MODULE_4__.rtl)({
    paddingLeft: (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingLeft)
  })(), isDefined(paddingRight) && (0,_utils__WEBPACK_IMPORTED_MODULE_4__.rtl)({
    paddingRight: (0,_utils_space__WEBPACK_IMPORTED_MODULE_3__.space)(paddingRight)
  })(), className);
  return {
    ...otherProps,
    className: classes
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/style-provider/index.js":
/*!*****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/style-provider/index.js ***!
  \*****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyleProvider: () => (/* binding */ StyleProvider),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/cache */ "./node_modules/.pnpm/@emotion+cache@11.14.0/node_modules/@emotion/cache/dist/emotion-cache.browser.development.esm.js");
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! uuid */ "./node_modules/.pnpm/uuid@9.0.1/node_modules/uuid/dist/esm-browser/v4.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */




/**
 * Internal dependencies
 */

const uuidCache = new Set();
// Use a weak map so that when the container is detached it's automatically
// dereferenced to avoid memory leak.
const containerCacheMap = new WeakMap();
const memoizedCreateCacheWithContainer = container => {
  if (containerCacheMap.has(container)) {
    return containerCacheMap.get(container);
  }

  // Emotion only accepts alphabetical and hyphenated keys so we just
  // strip the numbers from the UUID. It _should_ be fine.
  let key = uuid__WEBPACK_IMPORTED_MODULE_2__["default"]().replace(/[0-9]/g, '');
  while (uuidCache.has(key)) {
    key = uuid__WEBPACK_IMPORTED_MODULE_2__["default"]().replace(/[0-9]/g, '');
  }
  uuidCache.add(key);
  const cache = (0,_emotion_cache__WEBPACK_IMPORTED_MODULE_0__["default"])({
    container,
    key
  });
  containerCacheMap.set(container, cache);
  return cache;
};
function StyleProvider(props) {
  const {
    children,
    document
  } = props;
  if (!document) {
    return null;
  }
  const cache = memoizedCreateCacheWithContainer(document.head);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_emotion_react__WEBPACK_IMPORTED_MODULE_3__.C, {
    value: cache,
    children: children
  });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StyleProvider);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/hook.js":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/hook.js ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useSurface: () => (/* binding */ useSurface)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/context/use-context-system.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./styles */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/styles.js");
/* harmony import */ var _utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/hooks/use-cx */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function useSurface(props) {
  const {
    backgroundSize = 12,
    borderBottom = false,
    borderLeft = false,
    borderRight = false,
    borderTop = false,
    className,
    variant = 'primary',
    ...otherProps
  } = (0,_context__WEBPACK_IMPORTED_MODULE_0__.useContextSystem)(props, 'Surface');
  const cx = (0,_utils_hooks_use_cx__WEBPACK_IMPORTED_MODULE_1__.useCx)();
  const classes = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useMemo)(() => {
    const sx = {
      borders: _styles__WEBPACK_IMPORTED_MODULE_3__.getBorders({
        borderBottom,
        borderLeft,
        borderRight,
        borderTop
      })
    };
    return cx(_styles__WEBPACK_IMPORTED_MODULE_3__.Surface, sx.borders, _styles__WEBPACK_IMPORTED_MODULE_3__.getVariant(variant, `${backgroundSize}px`, `${backgroundSize - 1}px`), className);
  }, [backgroundSize, borderBottom, borderLeft, borderRight, borderTop, className, cx, variant]);
  return {
    ...otherProps,
    className: classes
  };
}
//# sourceMappingURL=hook.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/styles.js":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/surface/styles.js ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Surface: () => (/* binding */ Surface),
/* harmony export */   background: () => (/* binding */ background),
/* harmony export */   getBorders: () => (/* binding */ getBorders),
/* harmony export */   getDotted: () => (/* binding */ getDotted),
/* harmony export */   getGrid: () => (/* binding */ getGrid),
/* harmony export */   getVariant: () => (/* binding */ getVariant),
/* harmony export */   primary: () => (/* binding */ primary),
/* harmony export */   secondary: () => (/* binding */ secondary),
/* harmony export */   tertiary: () => (/* binding */ tertiary)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-react.browser.development.esm.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js");
/**
 * External dependencies
 */


/**
 * Internal dependencies
 */

const Surface = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background-color:", _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceColor, ";color:", _utils__WEBPACK_IMPORTED_MODULE_2__.COLORS.gray[900], ";position:relative;" + ( false ? 0 : ";label:Surface;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const background = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background-color:", _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundColor, ";" + ( false ? 0 : ";label:background;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvc3VyZmFjZS9zdHlsZXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBaUI2QiIsImZpbGUiOiJAd29yZHByZXNzL2NvbXBvbmVudHMvc3JjL3N1cmZhY2Uvc3R5bGVzLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG4vKipcbiAqIEludGVybmFsIGRlcGVuZGVuY2llc1xuICovXG5pbXBvcnQgeyBDT05GSUcsIENPTE9SUyB9IGZyb20gJy4uL3V0aWxzJztcbmltcG9ydCB0eXBlIHsgU3VyZmFjZVZhcmlhbnQsIFN1cmZhY2VQcm9wcyB9IGZyb20gJy4vdHlwZXMnO1xuXG5leHBvcnQgY29uc3QgU3VyZmFjZSA9IGNzc2Bcblx0YmFja2dyb3VuZC1jb2xvcjogJHsgQ09ORklHLnN1cmZhY2VDb2xvciB9O1xuXHRjb2xvcjogJHsgQ09MT1JTLmdyYXlbIDkwMCBdIH07XG5cdHBvc2l0aW9uOiByZWxhdGl2ZTtcbmA7XG5cbmV4cG9ydCBjb25zdCBiYWNrZ3JvdW5kID0gY3NzYFxuXHRiYWNrZ3JvdW5kLWNvbG9yOiAkeyBDT05GSUcuc3VyZmFjZUJhY2tncm91bmRDb2xvciB9O1xuYDtcblxuZXhwb3J0IGZ1bmN0aW9uIGdldEJvcmRlcnMoIHtcblx0Ym9yZGVyQm90dG9tLFxuXHRib3JkZXJMZWZ0LFxuXHRib3JkZXJSaWdodCxcblx0Ym9yZGVyVG9wLFxufTogUGljazxcblx0U3VyZmFjZVByb3BzLFxuXHQnYm9yZGVyQm90dG9tJyB8ICdib3JkZXJMZWZ0JyB8ICdib3JkZXJSaWdodCcgfCAnYm9yZGVyVG9wJ1xuPiApIHtcblx0Y29uc3QgYm9yZGVyU3R5bGUgPSBgMXB4IHNvbGlkICR7IENPTkZJRy5zdXJmYWNlQm9yZGVyQ29sb3IgfWA7XG5cblx0cmV0dXJuIGNzcygge1xuXHRcdGJvcmRlckJvdHRvbTogYm9yZGVyQm90dG9tID8gYm9yZGVyU3R5bGUgOiB1bmRlZmluZWQsXG5cdFx0Ym9yZGVyTGVmdDogYm9yZGVyTGVmdCA/IGJvcmRlclN0eWxlIDogdW5kZWZpbmVkLFxuXHRcdGJvcmRlclJpZ2h0OiBib3JkZXJSaWdodCA/IGJvcmRlclN0eWxlIDogdW5kZWZpbmVkLFxuXHRcdGJvcmRlclRvcDogYm9yZGVyVG9wID8gYm9yZGVyU3R5bGUgOiB1bmRlZmluZWQsXG5cdH0gKTtcbn1cblxuZXhwb3J0IGNvbnN0IHByaW1hcnkgPSBjc3NgYDtcblxuZXhwb3J0IGNvbnN0IHNlY29uZGFyeSA9IGNzc2Bcblx0YmFja2dyb3VuZDogJHsgQ09ORklHLnN1cmZhY2VCYWNrZ3JvdW5kVGludENvbG9yIH07XG5gO1xuXG5leHBvcnQgY29uc3QgdGVydGlhcnkgPSBjc3NgXG5cdGJhY2tncm91bmQ6ICR7IENPTkZJRy5zdXJmYWNlQmFja2dyb3VuZFRlcnRpYXJ5Q29sb3IgfTtcbmA7XG5cbmNvbnN0IGN1c3RvbUJhY2tncm91bmRTaXplID0gKCBzdXJmYWNlQmFja2dyb3VuZFNpemU6IHN0cmluZyApID0+XG5cdFsgc3VyZmFjZUJhY2tncm91bmRTaXplLCBzdXJmYWNlQmFja2dyb3VuZFNpemUgXS5qb2luKCAnICcgKTtcblxuY29uc3QgZG90dGVkQmFja2dyb3VuZDEgPSAoIHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZURvdHRlZDogc3RyaW5nICkgPT5cblx0W1xuXHRcdCc5MGRlZycsXG5cdFx0WyBDT05GSUcuc3VyZmFjZUJhY2tncm91bmRDb2xvciwgc3VyZmFjZUJhY2tncm91bmRTaXplRG90dGVkIF0uam9pbihcblx0XHRcdCcgJ1xuXHRcdCksXG5cdFx0J3RyYW5zcGFyZW50IDElJyxcblx0XS5qb2luKCAnLCcgKTtcblxuY29uc3QgZG90dGVkQmFja2dyb3VuZDIgPSAoIHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZURvdHRlZDogc3RyaW5nICkgPT5cblx0W1xuXHRcdFsgQ09ORklHLnN1cmZhY2VCYWNrZ3JvdW5kQ29sb3IsIHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZURvdHRlZCBdLmpvaW4oXG5cdFx0XHQnICdcblx0XHQpLFxuXHRcdCd0cmFuc3BhcmVudCAxJScsXG5cdF0uam9pbiggJywnICk7XG5cbmNvbnN0IGRvdHRlZEJhY2tncm91bmRDb21iaW5lZCA9ICggc3VyZmFjZUJhY2tncm91bmRTaXplRG90dGVkOiBzdHJpbmcgKSA9PlxuXHRbXG5cdFx0YGxpbmVhci1ncmFkaWVudCggJHsgZG90dGVkQmFja2dyb3VuZDEoXG5cdFx0XHRzdXJmYWNlQmFja2dyb3VuZFNpemVEb3R0ZWRcblx0XHQpIH0gKSBjZW50ZXJgLFxuXHRcdGBsaW5lYXItZ3JhZGllbnQoICR7IGRvdHRlZEJhY2tncm91bmQyKFxuXHRcdFx0c3VyZmFjZUJhY2tncm91bmRTaXplRG90dGVkXG5cdFx0KSB9ICkgY2VudGVyYCxcblx0XHRDT05GSUcuc3VyZmFjZUJvcmRlckJvbGRDb2xvcixcblx0XS5qb2luKCAnLCcgKTtcblxuZXhwb3J0IGNvbnN0IGdldERvdHRlZCA9IChcblx0c3VyZmFjZUJhY2tncm91bmRTaXplOiBzdHJpbmcsXG5cdHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZURvdHRlZDogc3RyaW5nXG4pID0+IGNzc2Bcblx0YmFja2dyb3VuZDogJHsgZG90dGVkQmFja2dyb3VuZENvbWJpbmVkKCBzdXJmYWNlQmFja2dyb3VuZFNpemVEb3R0ZWQgKSB9O1xuXHRiYWNrZ3JvdW5kLXNpemU6ICR7IGN1c3RvbUJhY2tncm91bmRTaXplKCBzdXJmYWNlQmFja2dyb3VuZFNpemUgKSB9O1xuYDtcblxuY29uc3QgZ3JpZEJhY2tncm91bmQxID0gW1xuXHRgJHsgQ09ORklHLnN1cmZhY2VCb3JkZXJTdWJ0bGVDb2xvciB9IDFweGAsXG5cdCd0cmFuc3BhcmVudCAxcHgnLFxuXS5qb2luKCAnLCcgKTtcblxuY29uc3QgZ3JpZEJhY2tncm91bmQyID0gW1xuXHQnOTBkZWcnLFxuXHRgJHsgQ09ORklHLnN1cmZhY2VCb3JkZXJTdWJ0bGVDb2xvciB9IDFweGAsXG5cdCd0cmFuc3BhcmVudCAxcHgnLFxuXS5qb2luKCAnLCcgKTtcblxuY29uc3QgZ3JpZEJhY2tncm91bmRDb21iaW5lZCA9IFtcblx0YGxpbmVhci1ncmFkaWVudCggJHsgZ3JpZEJhY2tncm91bmQxIH0gKWAsXG5cdGBsaW5lYXItZ3JhZGllbnQoICR7IGdyaWRCYWNrZ3JvdW5kMiB9IClgLFxuXS5qb2luKCAnLCcgKTtcblxuZXhwb3J0IGNvbnN0IGdldEdyaWQgPSAoIHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZTogc3RyaW5nICkgPT4ge1xuXHRyZXR1cm4gY3NzYFxuXHRcdGJhY2tncm91bmQ6ICR7IENPTkZJRy5zdXJmYWNlQmFja2dyb3VuZENvbG9yIH07XG5cdFx0YmFja2dyb3VuZC1pbWFnZTogJHsgZ3JpZEJhY2tncm91bmRDb21iaW5lZCB9O1xuXHRcdGJhY2tncm91bmQtc2l6ZTogJHsgY3VzdG9tQmFja2dyb3VuZFNpemUoIHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZSApIH07XG5cdGA7XG59O1xuXG5leHBvcnQgY29uc3QgZ2V0VmFyaWFudCA9IChcblx0dmFyaWFudDogU3VyZmFjZVZhcmlhbnQsXG5cdHN1cmZhY2VCYWNrZ3JvdW5kU2l6ZTogc3RyaW5nLFxuXHRzdXJmYWNlQmFja2dyb3VuZFNpemVEb3R0ZWQ6IHN0cmluZ1xuKSA9PiB7XG5cdHN3aXRjaCAoIHZhcmlhbnQgKSB7XG5cdFx0Y2FzZSAnZG90dGVkJzoge1xuXHRcdFx0cmV0dXJuIGdldERvdHRlZChcblx0XHRcdFx0c3VyZmFjZUJhY2tncm91bmRTaXplLFxuXHRcdFx0XHRzdXJmYWNlQmFja2dyb3VuZFNpemVEb3R0ZWRcblx0XHRcdCk7XG5cdFx0fVxuXHRcdGNhc2UgJ2dyaWQnOiB7XG5cdFx0XHRyZXR1cm4gZ2V0R3JpZCggc3VyZmFjZUJhY2tncm91bmRTaXplICk7XG5cdFx0fVxuXHRcdGNhc2UgJ3ByaW1hcnknOiB7XG5cdFx0XHRyZXR1cm4gcHJpbWFyeTtcblx0XHR9XG5cdFx0Y2FzZSAnc2Vjb25kYXJ5Jzoge1xuXHRcdFx0cmV0dXJuIHNlY29uZGFyeTtcblx0XHR9XG5cdFx0Y2FzZSAndGVydGlhcnknOiB7XG5cdFx0XHRyZXR1cm4gdGVydGlhcnk7XG5cdFx0fVxuXHR9XG59O1xuIl19 */");
function getBorders({
  borderBottom,
  borderLeft,
  borderRight,
  borderTop
}) {
  const borderStyle = `1px solid ${_utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBorderColor}`;
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)({
    borderBottom: borderBottom ? borderStyle : undefined,
    borderLeft: borderLeft ? borderStyle : undefined,
    borderRight: borderRight ? borderStyle : undefined,
    borderTop: borderTop ? borderStyle : undefined
  },  false ? 0 : ";label:getBorders;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
}
const primary = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)( false ? 0 : ";label:primary;",  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const secondary = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background:", _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundTintColor, ";" + ( false ? 0 : ";label:secondary;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const tertiary = /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background:", _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundTertiaryColor, ";" + ( false ? 0 : ";label:tertiary;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const customBackgroundSize = surfaceBackgroundSize => [surfaceBackgroundSize, surfaceBackgroundSize].join(' ');
const dottedBackground1 = surfaceBackgroundSizeDotted => ['90deg', [_utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundColor, surfaceBackgroundSizeDotted].join(' '), 'transparent 1%'].join(',');
const dottedBackground2 = surfaceBackgroundSizeDotted => [[_utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundColor, surfaceBackgroundSizeDotted].join(' '), 'transparent 1%'].join(',');
const dottedBackgroundCombined = surfaceBackgroundSizeDotted => [`linear-gradient( ${dottedBackground1(surfaceBackgroundSizeDotted)} ) center`, `linear-gradient( ${dottedBackground2(surfaceBackgroundSizeDotted)} ) center`, _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBorderBoldColor].join(',');
const getDotted = (surfaceBackgroundSize, surfaceBackgroundSizeDotted) => /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background:", dottedBackgroundCombined(surfaceBackgroundSizeDotted), ";background-size:", customBackgroundSize(surfaceBackgroundSize), ";" + ( false ? 0 : ";label:getDotted;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
const gridBackground1 = [`${_utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBorderSubtleColor} 1px`, 'transparent 1px'].join(',');
const gridBackground2 = ['90deg', `${_utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBorderSubtleColor} 1px`, 'transparent 1px'].join(',');
const gridBackgroundCombined = [`linear-gradient( ${gridBackground1} )`, `linear-gradient( ${gridBackground2} )`].join(',');
const getGrid = surfaceBackgroundSize => {
  return /*#__PURE__*/(0,_emotion_react__WEBPACK_IMPORTED_MODULE_0__.css)("background:", _utils__WEBPACK_IMPORTED_MODULE_1__["default"].surfaceBackgroundColor, ";background-image:", gridBackgroundCombined, ";background-size:", customBackgroundSize(surfaceBackgroundSize), ";" + ( false ? 0 : ";label:getGrid;"),  false ? 0 : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};
const getVariant = (variant, surfaceBackgroundSize, surfaceBackgroundSizeDotted) => {
  switch (variant) {
    case 'dotted':
      {
        return getDotted(surfaceBackgroundSize, surfaceBackgroundSizeDotted);
      }
    case 'grid':
      {
        return getGrid(surfaceBackgroundSize);
      }
    case 'primary':
      {
        return primary;
      }
    case 'secondary':
      {
        return secondary;
      }
    case 'tertiary':
      {
        return tertiary;
      }
  }
};
//# sourceMappingURL=styles.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/text-control/index.js":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/text-control/index.js ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TextControl: () => (/* binding */ TextControl),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _base_control__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../base-control */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/base-control/index.js");
/* harmony import */ var _utils_deprecated_36px_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/deprecated-36px-size */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/deprecated-36px-size.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function UnforwardedTextControl(props, ref) {
  const {
    __nextHasNoMarginBottom,
    __next40pxDefaultSize = false,
    label,
    hideLabelFromVision,
    value,
    help,
    id: idProp,
    className,
    onChange,
    type = 'text',
    ...additionalProps
  } = props;
  const id = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_2__["default"])(TextControl, 'inspector-text-control', idProp);
  const onChangeValue = event => onChange(event.target.value);
  (0,_utils_deprecated_36px_size__WEBPACK_IMPORTED_MODULE_3__.maybeWarnDeprecated36pxSize)({
    componentName: 'TextControl',
    size: undefined,
    __next40pxDefaultSize
  });
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_base_control__WEBPACK_IMPORTED_MODULE_4__["default"], {
    __nextHasNoMarginBottom: __nextHasNoMarginBottom,
    __associatedWPComponentName: "TextControl",
    label: label,
    hideLabelFromVision: hideLabelFromVision,
    id: id,
    help: help,
    className: className,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("input", {
      className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-text-control__input', {
        'is-next-40px-default-size': __next40pxDefaultSize
      }),
      type: type,
      id: id,
      value: value,
      onChange: onChangeValue,
      "aria-describedby": !!help ? id + '__help' : undefined,
      ref: ref,
      ...additionalProps
    })
  });
}

/**
 * TextControl components let users enter and edit text.
 *
 * ```jsx
 * import { TextControl } from '@wordpress/components';
 * import { useState } from '@wordpress/element';
 *
 * const MyTextControl = () => {
 *   const [ className, setClassName ] = useState( '' );
 *
 *   return (
 *     <TextControl
 *       __nextHasNoMarginBottom
 *       __next40pxDefaultSize
 *       label="Additional CSS Class"
 *       value={ className }
 *       onChange={ ( value ) => setClassName( value ) }
 *     />
 *   );
 * };
 * ```
 */
const TextControl = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_5__.forwardRef)(UnforwardedTextControl);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextControl);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/tooltip/index.js":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/tooltip/index.js ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TOOLTIP_DELAY: () => (/* binding */ TOOLTIP_DELAY),
/* harmony export */   Tooltip: () => (/* binding */ Tooltip),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ariakit_react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ariakit/react */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/BZZ52UJN.js");
/* harmony import */ var _ariakit_react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ariakit/react */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/RTNCFSKZ.js");
/* harmony import */ var _ariakit_react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ariakit/react */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/__chunks/QJ4LGO2N.js");
/* harmony import */ var _ariakit_react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ariakit/react */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip-anchor.js");
/* harmony import */ var _ariakit_react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ariakit/react */ "./node_modules/.pnpm/@ariakit+react-core@0.4.18_react-dom@18.3.1_react@18.3.1__react@18.3.1/node_modules/@ariakit/react-core/esm/tooltip/tooltip.js");
/* harmony import */ var clsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! clsx */ "./node_modules/.pnpm/clsx@2.1.1/node_modules/clsx/dist/clsx.mjs");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/compose */ "./node_modules/.pnpm/@wordpress+compose@7.30.0_react@18.3.1/node_modules/@wordpress/compose/build-module/hooks/use-instance-id/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/* harmony import */ var _shortcut__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../shortcut */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/shortcut/index.js");
/* harmony import */ var _popover_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../popover/utils */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/popover/utils.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/jsx-runtime.js");
/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




const TooltipInternalContext = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.createContext)({
  isNestedInTooltip: false
});
TooltipInternalContext.displayName = 'TooltipInternalContext';

/**
 * Time over anchor to wait before showing tooltip
 */
const TOOLTIP_DELAY = 700;
const CONTEXT_VALUE = {
  isNestedInTooltip: true
};
function UnforwardedTooltip(props, ref) {
  const {
    children,
    className,
    delay = TOOLTIP_DELAY,
    hideOnClick = true,
    placement,
    position,
    shortcut,
    text,
    ...restProps
  } = props;
  const {
    isNestedInTooltip
  } = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.useContext)(TooltipInternalContext);
  const baseId = (0,_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["default"])(Tooltip, 'tooltip');
  const describedById = text || shortcut ? baseId : undefined;
  const isOnlyChild = _wordpress_element__WEBPACK_IMPORTED_MODULE_2__.Children.count(children) === 1;
  // console error if more than one child element is added
  if (!isOnlyChild) {
    if (true) {
      // eslint-disable-next-line no-console
      console.error('wp-components.Tooltip should be called with only a single child element.');
    }
  }

  // Compute tooltip's placement:
  // - give priority to `placement` prop, if defined
  // - otherwise, compute it from the legacy `position` prop (if defined)
  // - finally, fallback to the default placement: 'bottom'
  let computedPlacement;
  if (placement !== undefined) {
    computedPlacement = placement;
  } else if (position !== undefined) {
    computedPlacement = (0,_popover_utils__WEBPACK_IMPORTED_MODULE_4__.positionToPlacement)(position);
    (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_5__["default"])('`position` prop in wp.components.tooltip', {
      since: '6.4',
      alternative: '`placement` prop'
    });
  }
  computedPlacement = computedPlacement || 'bottom';
  const tooltipStore = _ariakit_react__WEBPACK_IMPORTED_MODULE_6__.useTooltipStore({
    placement: computedPlacement,
    showTimeout: delay
  });
  const mounted = _ariakit_react__WEBPACK_IMPORTED_MODULE_7__.useStoreState(tooltipStore, 'mounted');
  if (isNestedInTooltip) {
    return isOnlyChild ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_ariakit_react__WEBPACK_IMPORTED_MODULE_8__.Role, {
      ...restProps,
      render: children
    }) : children;
  }

  // TODO: this is a temporary workaround to minimize the effects of the
  // Ariakit upgrade. Ariakit doesn't pass the `aria-describedby` prop to
  // the tooltip anchor anymore since 0.4.0, so we need to add it manually.
  // The `aria-describedby` attribute is added only if the anchor doesn't have
  // one already, and if the tooltip text is not the same as the anchor's
  // `aria-label`
  // See: https://github.com/WordPress/gutenberg/pull/64066
  // See: https://github.com/WordPress/gutenberg/pull/65989
  function addDescribedById(element) {
    return describedById && mounted && element.props['aria-describedby'] === undefined && element.props['aria-label'] !== text ? (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.cloneElement)(element, {
      'aria-describedby': describedById
    }) : element;
  }
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(TooltipInternalContext.Provider, {
    value: CONTEXT_VALUE,
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_ariakit_react__WEBPACK_IMPORTED_MODULE_9__.TooltipAnchor, {
      onClick: hideOnClick ? tooltipStore.hide : undefined,
      store: tooltipStore,
      render: isOnlyChild ? addDescribedById(children) : undefined,
      ref: ref,
      children: isOnlyChild ? undefined : children
    }), isOnlyChild && (text || shortcut) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)(_ariakit_react__WEBPACK_IMPORTED_MODULE_10__.Tooltip, {
      ...restProps,
      className: (0,clsx__WEBPACK_IMPORTED_MODULE_0__["default"])('components-tooltip', className),
      unmountOnHide: true,
      gutter: 4,
      id: describedById,
      overflowPadding: 0.5,
      store: tooltipStore,
      children: [text, shortcut && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(_shortcut__WEBPACK_IMPORTED_MODULE_11__["default"], {
        className: text ? 'components-tooltip__shortcut' : '',
        shortcut: shortcut
      })]
    })]
  });
}
const Tooltip = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_2__.forwardRef)(UnforwardedTooltip);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tooltip);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/base-label.js":
/*!*************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/base-label.js ***!
  \*************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   baseLabelTypography: () => (/* binding */ baseLabelTypography)
/* harmony export */ });
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */


// This is a very low-level mixin which you shouldn't have to use directly.
// Try to use BaseControl's StyledLabel or BaseControl.VisualLabel if you can.
const baseLabelTypography =  false ? 0 : {
  name: "1awj7qe-baseLabelTypography",
  styles: "font-size:11px;font-weight:500;line-height:1.4;text-transform:uppercase;label:baseLabelTypography;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvdXRpbHMvYmFzZS1sYWJlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFPc0MiLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy91dGlscy9iYXNlLWxhYmVsLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG4vLyBUaGlzIGlzIGEgdmVyeSBsb3ctbGV2ZWwgbWl4aW4gd2hpY2ggeW91IHNob3VsZG4ndCBoYXZlIHRvIHVzZSBkaXJlY3RseS5cbi8vIFRyeSB0byB1c2UgQmFzZUNvbnRyb2wncyBTdHlsZWRMYWJlbCBvciBCYXNlQ29udHJvbC5WaXN1YWxMYWJlbCBpZiB5b3UgY2FuLlxuZXhwb3J0IGNvbnN0IGJhc2VMYWJlbFR5cG9ncmFwaHkgPSBjc3NgXG5cdGZvbnQtc2l6ZTogMTFweDtcblx0Zm9udC13ZWlnaHQ6IDUwMDtcblx0bGluZS1oZWlnaHQ6IDEuNDtcblx0dGV4dC10cmFuc2Zvcm06IHVwcGVyY2FzZTtcbmA7XG4iXX0= */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
//# sourceMappingURL=base-label.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/box-sizing.js":
/*!*************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/box-sizing.js ***!
  \*************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   boxSizingReset: () => (/* binding */ boxSizingReset)
/* harmony export */ });
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/**
 * External dependencies
 */

const boxSizingReset =  false ? 0 : {
  name: "1pa5nhz-boxSizingReset",
  styles: "box-sizing:border-box;*,*::before,*::after{box-sizing:inherit;};label:boxSizingReset;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkB3b3JkcHJlc3MvY29tcG9uZW50cy9zcmMvdXRpbHMvYm94LXNpemluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFLaUMiLCJmaWxlIjoiQHdvcmRwcmVzcy9jb21wb25lbnRzL3NyYy91dGlscy9ib3gtc2l6aW5nLnRzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXNcbiAqL1xuaW1wb3J0IHsgY3NzIH0gZnJvbSAnQGVtb3Rpb24vcmVhY3QnO1xuXG5leHBvcnQgY29uc3QgYm94U2l6aW5nUmVzZXQgPSBjc3NgXG5cdGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG5cblx0Kixcblx0Kjo6YmVmb3JlLFxuXHQqOjphZnRlciB7XG5cdFx0Ym94LXNpemluZzogaW5oZXJpdDtcblx0fVxuYDtcbiJdfQ== */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
//# sourceMappingURL=box-sizing.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COLORS: () => (/* binding */ COLORS),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Internal dependencies
 */
const white = '#fff';

// Matches the grays in @wordpress/base-styles
const GRAY = {
  900: '#1e1e1e',
  800: '#2f2f2f',
  /** Meets 4.6:1 text contrast against white. */
  700: '#757575',
  /** Meets 3:1 UI or large text contrast against white. */
  600: '#949494',
  400: '#ccc',
  /** Used for most borders. */
  300: '#ddd',
  /** Used sparingly for light borders. */
  200: '#e0e0e0',
  /** Used for light gray backgrounds. */
  100: '#f0f0f0'
};

// Matches @wordpress/base-styles
const ALERT = {
  yellow: '#f0b849',
  red: '#d94f4f',
  green: '#4ab866'
};

// Should match packages/components/src/utils/theme-variables.scss
const THEME = {
  accent: `var(--wp-components-color-accent, var(--wp-admin-theme-color, #3858e9))`,
  accentDarker10: `var(--wp-components-color-accent-darker-10, var(--wp-admin-theme-color-darker-10, #2145e6))`,
  accentDarker20: `var(--wp-components-color-accent-darker-20, var(--wp-admin-theme-color-darker-20, #183ad6))`,
  /** Used when placing text on the accent color. */
  accentInverted: `var(--wp-components-color-accent-inverted, ${white})`,
  background: `var(--wp-components-color-background, ${white})`,
  foreground: `var(--wp-components-color-foreground, ${GRAY[900]})`,
  /** Used when placing text on the foreground color. */
  foregroundInverted: `var(--wp-components-color-foreground-inverted, ${white})`,
  gray: {
    /** @deprecated Use `COLORS.theme.foreground` instead. */
    900: `var(--wp-components-color-foreground, ${GRAY[900]})`,
    800: `var(--wp-components-color-gray-800, ${GRAY[800]})`,
    700: `var(--wp-components-color-gray-700, ${GRAY[700]})`,
    600: `var(--wp-components-color-gray-600, ${GRAY[600]})`,
    400: `var(--wp-components-color-gray-400, ${GRAY[400]})`,
    300: `var(--wp-components-color-gray-300, ${GRAY[300]})`,
    200: `var(--wp-components-color-gray-200, ${GRAY[200]})`,
    100: `var(--wp-components-color-gray-100, ${GRAY[100]})`
  }
};
const UI = {
  background: THEME.background,
  backgroundDisabled: THEME.gray[100],
  border: THEME.gray[600],
  borderHover: THEME.gray[700],
  borderFocus: THEME.accent,
  borderDisabled: THEME.gray[400],
  textDisabled: THEME.gray[600],
  // Matches @wordpress/base-styles
  darkGrayPlaceholder: `color-mix(in srgb, ${THEME.foreground}, transparent 38%)`,
  lightGrayPlaceholder: `color-mix(in srgb, ${THEME.background}, transparent 35%)`
};
const COLORS = Object.freeze({
  /**
   * The main gray color object.
   *
   * @deprecated Use semantic aliases in `COLORS.ui` or theme-ready variables in `COLORS.theme.gray`.
   */
  gray: GRAY,
  // TODO: Stop exporting this when everything is migrated to `theme` or `ui`
  /**
   * @deprecated Prefer theme-ready variables in `COLORS.theme`.
   */
  white,
  alert: ALERT,
  /**
   * Theme-ready variables with fallbacks.
   *
   * Prefer semantic aliases in `COLORS.ui` when applicable.
   */
  theme: THEME,
  /**
   * Semantic aliases (prefer these over raw variables when applicable).
   */
  ui: UI
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (COLORS);
//# sourceMappingURL=colors-values.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/config-values.js ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _space__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./space */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/space.js");
/* harmony import */ var _colors_values__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./colors-values */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/colors-values.js");
/**
 * Internal dependencies
 */


const CONTROL_HEIGHT = '36px';
const CONTROL_PROPS = {
  // These values should be shared with TextControl.
  controlPaddingX: 12,
  controlPaddingXSmall: 8,
  controlPaddingXLarge: 12 * 1.3334,
  // TODO: Deprecate

  controlBoxShadowFocus: `0 0 0 0.5px ${_colors_values__WEBPACK_IMPORTED_MODULE_0__.COLORS.theme.accent}`,
  controlHeight: CONTROL_HEIGHT,
  controlHeightXSmall: `calc( ${CONTROL_HEIGHT} * 0.6 )`,
  controlHeightSmall: `calc( ${CONTROL_HEIGHT} * 0.8 )`,
  controlHeightLarge: `calc( ${CONTROL_HEIGHT} * 1.2 )`,
  controlHeightXLarge: `calc( ${CONTROL_HEIGHT} * 1.4 )`
};

// Using Object.assign to avoid creating circular references when emitting
// TypeScript type declarations.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Object.assign({}, CONTROL_PROPS, {
  colorDivider: 'rgba(0, 0, 0, 0.1)',
  colorScrollbarThumb: 'rgba(0, 0, 0, 0.2)',
  colorScrollbarThumbHover: 'rgba(0, 0, 0, 0.5)',
  colorScrollbarTrack: 'rgba(0, 0, 0, 0.04)',
  elevationIntensity: 1,
  radiusXSmall: '1px',
  radiusSmall: '2px',
  radiusMedium: '4px',
  radiusLarge: '8px',
  radiusFull: '9999px',
  radiusRound: '50%',
  borderWidth: '1px',
  borderWidthFocus: '1.5px',
  borderWidthTab: '4px',
  spinnerSize: 16,
  fontSize: '13px',
  fontSizeH1: 'calc(2.44 * 13px)',
  fontSizeH2: 'calc(1.95 * 13px)',
  fontSizeH3: 'calc(1.56 * 13px)',
  fontSizeH4: 'calc(1.25 * 13px)',
  fontSizeH5: '13px',
  fontSizeH6: 'calc(0.8 * 13px)',
  fontSizeInputMobile: '16px',
  fontSizeMobile: '15px',
  fontSizeSmall: 'calc(0.92 * 13px)',
  fontSizeXSmall: 'calc(0.75 * 13px)',
  fontLineHeightBase: '1.4',
  fontWeight: 'normal',
  fontWeightHeading: '600',
  gridBase: '4px',
  cardPaddingXSmall: `${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(2)}`,
  cardPaddingSmall: `${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(4)}`,
  cardPaddingMedium: `${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(4)} ${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(6)}`,
  cardPaddingLarge: `${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(6)} ${(0,_space__WEBPACK_IMPORTED_MODULE_1__.space)(8)}`,
  elevationXSmall: `0 1px 1px rgba(0, 0, 0, 0.03), 0 1px 2px rgba(0, 0, 0, 0.02), 0 3px 3px rgba(0, 0, 0, 0.02), 0 4px 4px rgba(0, 0, 0, 0.01)`,
  elevationSmall: `0 1px 2px rgba(0, 0, 0, 0.05), 0 2px 3px rgba(0, 0, 0, 0.04), 0 6px 6px rgba(0, 0, 0, 0.03), 0 8px 8px rgba(0, 0, 0, 0.02)`,
  elevationMedium: `0 2px 3px rgba(0, 0, 0, 0.05), 0 4px 5px rgba(0, 0, 0, 0.04), 0 12px 12px rgba(0, 0, 0, 0.03), 0 16px 16px rgba(0, 0, 0, 0.02)`,
  elevationLarge: `0 5px 15px rgba(0, 0, 0, 0.08), 0 15px 27px rgba(0, 0, 0, 0.07), 0 30px 36px rgba(0, 0, 0, 0.04), 0 50px 43px rgba(0, 0, 0, 0.02)`,
  surfaceBackgroundColor: _colors_values__WEBPACK_IMPORTED_MODULE_0__.COLORS.white,
  surfaceBackgroundSubtleColor: '#F3F3F3',
  surfaceBackgroundTintColor: '#F5F5F5',
  surfaceBorderColor: 'rgba(0, 0, 0, 0.1)',
  surfaceBorderBoldColor: 'rgba(0, 0, 0, 0.15)',
  surfaceBorderSubtleColor: 'rgba(0, 0, 0, 0.05)',
  surfaceBackgroundTertiaryColor: _colors_values__WEBPACK_IMPORTED_MODULE_0__.COLORS.white,
  surfaceColor: _colors_values__WEBPACK_IMPORTED_MODULE_0__.COLORS.white,
  transitionDuration: '200ms',
  transitionDurationFast: '160ms',
  transitionDurationFaster: '120ms',
  transitionDurationFastest: '100ms',
  transitionTimingFunction: 'cubic-bezier(0.08, 0.52, 0.52, 1)',
  transitionTimingFunctionControl: 'cubic-bezier(0.12, 0.8, 0.32, 1)'
}));
//# sourceMappingURL=config-values.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/deprecated-36px-size.js":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/deprecated-36px-size.js ***!
  \***********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   maybeWarnDeprecated36pxSize: () => (/* binding */ maybeWarnDeprecated36pxSize)
/* harmony export */ });
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/deprecated */ "./node_modules/.pnpm/@wordpress+deprecated@4.30.0/node_modules/@wordpress/deprecated/build-module/index.js");
/**
 * WordPress dependencies
 */

function maybeWarnDeprecated36pxSize({
  componentName,
  __next40pxDefaultSize,
  size,
  __shouldNotWarnDeprecated36pxSize
}) {
  if (__shouldNotWarnDeprecated36pxSize || __next40pxDefaultSize || size !== undefined && size !== 'default') {
    return;
  }
  (0,_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_0__["default"])(`36px default size for wp.components.${componentName}`, {
    since: '6.8',
    version: '7.1',
    hint: 'Set the `__next40pxDefaultSize` prop to true to start opting into the new default size, which will become the default in a future version.'
  });
}
//# sourceMappingURL=deprecated-36px-size.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font-values.js":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font-values.js ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  'default.fontFamily': "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif",
  'default.fontSize': '13px',
  'helpText.fontSize': '12px',
  mobileTextMinFontSize: '16px'
});
//# sourceMappingURL=font-values.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font.js":
/*!*******************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font.js ***!
  \*******************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   font: () => (/* binding */ font)
/* harmony export */ });
/* harmony import */ var _font_values__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./font-values */ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/font-values.js");
/**
 * Internal dependencies
 */


/**
 *
 * @param {keyof FONT} value Path of value from `FONT`
 * @return {string} Font rule value
 */
function font(value) {
  var _FONT$value;
  return (_FONT$value = _font_values__WEBPACK_IMPORTED_MODULE_0__["default"][value]) !== null && _FONT$value !== void 0 ? _FONT$value : '';
}
//# sourceMappingURL=font.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/get-valid-children.js":
/*!*********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/get-valid-children.js ***!
  \*********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getValidChildren: () => (/* binding */ getValidChildren)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Gets a collection of available children elements from a React component's children prop.
 *
 * @param children
 *
 * @return An array of available children.
 */
function getValidChildren(children) {
  if (typeof children === 'string') {
    return [children];
  }
  return _wordpress_element__WEBPACK_IMPORTED_MODULE_0__.Children.toArray(children).filter(child => (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_0__.isValidElement)(child));
}
//# sourceMappingURL=get-valid-children.js.map

/***/ }),

/***/ "./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/.pnpm/@wordpress+components@30.3.0_@emotion+is-prop-valid@1.4.0_@types+react@18.3.24_react-do_049825ad170f7e5f78166b61e991cac1/node_modules/@wordpress/components/build-module/utils/hooks/use-cx.js ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useCx: () => (/* binding */ useCx)
/* harmony export */ });
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @emotion/react */ "./node_modules/.pnpm/@emotion+react@11.14.0_@types+react@18.3.24_react@18.3.1/node_modules/@emotion/react/dist/emotion-element-489459f2.browser.development.esm.js");
/* harmony import */ var _emotion_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @emotion/utils */ "./node_modules/.pnpm/@emotion+utils@1.4.2/node_modules/@emotion/utils/dist/emotion-utils.browser.esm.js");
/* harmony import */ var _emotion_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @emotion/css */ "./node_modules/.pnpm/@emotion+css@11.13.5/node_modules/@emotion/css/dist/emotion-css.development.esm.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @wordpress/element */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_3__);
/**
 * External dependencies
 */


// eslint-disable-next-line no-restricted-imports

// eslint-disable-next-line no-restricted-imports


/**
 * WordPress dependencies
 */

const isSerializedStyles = o => typeof o !== 'undefined' && o !== null && ['name', 'styles'].every(p => typeof o[p] !== 'undefined');

/**
 * Retrieve a `cx` function that knows how to handle `SerializedStyles`
 * returned by the `@emotion/react` `css` function in addition to what
 * `cx` normally knows how to handle. It also hooks into the Emotion
 * Cache, allowing `css` calls to work inside iframes.
 *
 * ```jsx
 * import { css } from '@emotion/react';
 *
 * const styles = css`
 * 	color: red
 * `;
 *
 * function RedText( { className, ...props } ) {
 * 	const cx = useCx();
 *
 * 	const classes = cx(styles, className);
 *
 * 	return <span className={classes} {...props} />;
 * }
 * ```
 */
const useCx = () => {
  const cache = (0,_emotion_react__WEBPACK_IMPORTED_MODULE_2__._)();
  const cx = (0,_wordpress_element__WEBPACK_IMPORTED_MODULE_3__.useCallback)((...classNames) => {
    if (cache === null) {
      throw new Error('The `useCx` hook should be only used within a valid Emotion Cache Context');
    }
    return (0,_emotion_css__WEBPACK_IMPORTED_MODULE_1__.cx)(...classNames.map(arg => {
      if (isS