<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_filter( 'elementor/icons_manager/additional_tabs', 'arts_add_custom_icons_elementor_library' );
if ( ! function_exists( 'arts_add_custom_icons_elementor_library')) {
	/**
	 * Add new tabs to the Elementor icon library panel for Material Icons.
	 *
	 * @param array $tabs The existing tabs in the Elementor icon library.
	 *
	 * @return array The modified tabs array with the new Material Icons tab added.
	 */
	function arts_add_custom_icons_elementor_library( $tabs ) {
		$tabs['material-icons'] = array(
			'name'          => 'material-icons',
			'label'         => esc_html__( 'Material Icons', 'rhye' ),
			'labelIcon'     => 'fab fa-google',
			'prefix'        => '',
			'displayPrefix' => 'material-icons',
			'url'           => ARTS_THEME_URL . '/css/material-icons.min.css',
			'enqueue'       => array( ARTS_THEME_URL . '/css/material-icons.min.css' ),
			'fetchJson'     => ARTS_THEME_URL . '/fonts/material-icons.json',
			'ver'           => '3.0.1',
		);

		return $tabs;
	}
}

add_action( 'elementor/controls/controls_registered', 'arts_elementor_custom_icons' );
if ( ! function_exists( 'arts_elementor_custom_icons')) {
	/**
	 * Add custom Material Icons to the Elementor icon library.
	 *
	 * @param \Elementor\Controls_Registry $controls_registry The Elementor controls registry.
	 */
	function arts_elementor_custom_icons( $controls_registry ) {
		$theme_icons = array(
			// Rhye Icons
			'icon-rhye-girl-photography'                   => 'girl-photography',
			'icon-rhye-inauguration'                       => 'inauguration',
			'icon-rhye-click'                              => 'click',
			'icon-rhye-dark-light'                         => 'dark-light',
			'icon-rhye-magazine'                           => 'magazine',
			'icon-rhye-font'                               => 'font',
			'icon-rhye-rings'                              => 'rings',
			'icon-rhye-magic-wand'                         => 'magic-wand',
			'icon-rhye-move'                               => 'move',
			'icon-rhye-repeat'                             => 'repeat',
			'icon-rhye-responsive'                         => 'responsive',
			'icon-rhye-text'                               => 'text',
			'icon-rhye-expand'                             => 'expand',
			'icon-rhye-form'                               => 'form',
			'icon-rhye-background'                         => 'background',
			'icon-rhye-file'                               => 'file',
			'icon-rhye-studio-lighting'                    => 'studio-lighting',
			'icon-rhye-value'                              => 'value',
			// Material Icons
			'material-icons ac_unit'                       => 'material-icons ac_unit',
			'material-icons access_alarm'                  => 'material-icons access_alarm',
			'material-icons access_alarms'                 => 'material-icons access_alarms',
			'material-icons access_time'                   => 'material-icons access_time',
			'material-icons accessibility'                 => 'material-icons accessibility',
			'material-icons accessible'                    => 'material-icons accessible',
			'material-icons account_balance'               => 'material-icons account_balance',
			'material-icons account_balance_wallet'        => 'material-icons account_balance_wallet',
			'material-icons account_box'                   => 'material-icons account_box',
			'material-icons account_circle'                => 'material-icons account_circle',
			'material-icons adb'                           => 'material-icons adb',
			'material-icons add'                           => 'material-icons add',
			'material-icons add_a_photo'                   => 'material-icons add_a_photo',
			'material-icons add_alarm'                     => 'material-icons add_alarm',
			'material-icons add_alert'                     => 'material-icons add_alert',
			'material-icons add_box'                       => 'material-icons add_box',
			'material-icons add_circle'                    => 'material-icons add_circle',
			'material-icons add_circle_outline'            => 'material-icons add_circle_outline',
			'material-icons add_location'                  => 'material-icons add_location',
			'material-icons add_shopping_cart'             => 'material-icons add_shopping_cart',
			'material-icons add_to_photos'                 => 'material-icons add_to_photos',
			'material-icons add_to_queue'                  => 'material-icons add_to_queue',
			'material-icons adjust'                        => 'material-icons adjust',
			'material-icons airline_seat_flat'             => 'material-icons airline_seat_flat',
			'material-icons airline_seat_flat_angled'      => 'material-icons airline_seat_flat_angled',
			'material-icons airline_seat_individual_suite' => 'material-icons airline_seat_individual_suite',
			'material-icons airline_seat_legroom_extra'    => 'material-icons airline_seat_legroom_extra',
			'material-icons airline_seat_legroom_normal'   => 'material-icons airline_seat_legroom_normal',
			'material-icons airline_seat_legroom_reduced'  => 'material-icons airline_seat_legroom_reduced',
			'material-icons airline_seat_recline_extra'    => 'material-icons airline_seat_recline_extra',
			'material-icons airline_seat_recline_normal'   => 'material-icons airline_seat_recline_normal',
			'material-icons airplanemode_active'           => 'material-icons airplanemode_active',
			'material-icons airplanemode_inactive'         => 'material-icons airplanemode_inactive',
			'material-icons airplay'                       => 'material-icons airplay',
			'material-icons airport_shuttle'               => 'material-icons airport_shuttle',
			'material-icons alarm'                         => 'material-icons alarm',
			'material-icons alarm_add'                     => 'material-icons alarm_add',
			'material-icons alarm_off'                     => 'material-icons alarm_off',
			'material-icons alarm_on'                      => 'material-icons alarm_on',
			'material-icons album'                         => 'material-icons album',
			'material-icons all_inclusive'                 => 'material-icons all_inclusive',
			'material-icons all_out'                       => 'material-icons all_out',
			'material-icons android'                       => 'material-icons android',
			'material-icons announcement'                  => 'material-icons announcement',
			'material-icons apps'                          => 'material-icons apps',
			'material-icons archive'                       => 'material-icons archive',
			'material-icons arrow_back'                    => 'material-icons arrow_back',
			'material-icons arrow_downward'                => 'material-icons arrow_downward',
			'material-icons arrow_drop_down'               => 'material-icons arrow_drop_down',
			'material-icons arrow_drop_down_circle'        => 'material-icons arrow_drop_down_circle',
			'material-icons arrow_drop_up'                 => 'material-icons arrow_drop_up',
			'material-icons arrow_forward'                 => 'material-icons arrow_forward',
			'material-icons arrow_upward'                  => 'material-icons arrow_upward',
			'material-icons art_track'                     => 'material-icons art_track',
			'material-icons aspect_ratio'                  => 'material-icons aspect_ratio',
			'material-icons assessment'                    => 'material-icons assessment',
			'material-icons assignment'                    => 'material-icons assignment',
			'material-icons assignment_ind'                => 'material-icons assignment_ind',
			'material-icons assignment_late'               => 'material-icons assignment_late',
			'material-icons assignment_return'             => 'material-icons assignment_return',
			'material-icons assignment_returned'           => 'material-icons assignment_returned',
			'material-icons assignment_turned_in'          => 'material-icons assignment_turned_in',
			'material-icons assistant'                     => 'material-icons assistant',
			'material-icons assistant_photo'               => 'material-icons assistant_photo',
			'material-icons attach_file'                   => 'material-icons attach_file',
			'material-icons attach_money'                  => 'material-icons attach_money',
			'material-icons attachment'                    => 'material-icons attachment',
			'material-icons audiotrack'                    => 'material-icons audiotrack',
			'material-icons autorenew'                     => 'material-icons autorenew',
			'material-icons av_timer'                      => 'material-icons av_timer',
			'material-icons backspace'                     => 'material-icons backspace',
			'material-icons backup'                        => 'material-icons backup',
			'material-icons battery_alert'                 => 'material-icons battery_alert',
			'material-icons battery_charging_full'         => 'material-icons battery_charging_full',
			'material-icons battery_full'                  => 'material-icons battery_full',
			'material-icons battery_std'                   => 'material-icons battery_std',
			'material-icons battery_unknown'               => 'material-icons battery_unknown',
			'material-icons beach_access'                  => 'material-icons beach_access',
			'material-icons beenhere'                      => 'material-icons beenhere',
			'material-icons block'                         => 'material-icons block',
			'material-icons bluetooth'                     => 'material-icons bluetooth',
			'material-icons bluetooth_audio'               => 'material-icons bluetooth_audio',
			'material-icons bluetooth_connected'           => 'material-icons bluetooth_connected',
			'material-icons bluetooth_disabled'            => 'material-icons bluetooth_disabled',
			'material-icons bluetooth_searching'           => 'material-icons bluetooth_searching',
			'material-icons blur_circular'                 => 'material-icons blur_circular',
			'material-icons blur_linear'                   => 'material-icons blur_linear',
			'material-icons blur_off'                      => 'material-icons blur_off',
			'material-icons blur_on'                       => 'material-icons blur_on',
			'material-icons book'                          => 'material-icons book',
			'material-icons bookmark'                      => 'material-icons bookmark',
			'material-icons bookmark_border'               => 'material-icons bookmark_border',
			'material-icons border_all'                    => 'material-icons border_all',
			'material-icons border_bottom'                 => 'material-icons border_bottom',
			'material-icons border_clear'                  => 'material-icons border_clear',
			'material-icons border_color'                  => 'material-icons border_color',
			'material-icons border_horizontal'             => 'material-icons border_horizontal',
			'material-icons border_inner'                  => 'material-icons border_inner',
			'material-icons border_left'                   => 'material-icons border_left',
			'material-icons border_outer'                  => 'material-icons border_outer',
			'material-icons border_right'                  => 'material-icons border_right',
			'material-icons border_style'                  => 'material-icons border_style',
			'material-icons border_top'                    => 'material-icons border_top',
			'material-icons border_vertical'               => 'material-icons border_vertical',
			'material-icons branding_watermark'            => 'material-icons branding_watermark',
			'material-icons brightness_1'                  => 'material-icons brightness_1',
			'material-icons brightness_2'                  => 'material-icons brightness_2',
			'material-icons brightness_3'                  => 'material-icons brightness_3',
			'material-icons brightness_4'                  => 'material-icons brightness_4',
			'material-icons brightness_5'                  => 'material-icons brightness_5',
			'material-icons brightness_6'                  => 'material-icons brightness_6',
			'material-icons brightness_7'                  => 'material-icons brightness_7',
			'material-icons brightness_auto'               => 'material-icons brightness_auto',
			'material-icons brightness_high'               => 'material-icons brightness_high',
			'material-icons brightness_low'                => 'material-icons brightness_low',
			'material-icons brightness_medium'             => 'material-icons brightness_medium',
			'material-icons broken_image'                  => 'material-icons broken_image',
			'material-icons brush'                         => 'material-icons brush',
			'material-icons bubble_chart'                  => 'material-icons bubble_chart',
			'material-icons bug_report'                    => 'material-icons bug_report',
			'material-icons build'                         => 'material-icons build',
			'material-icons burst_mode'                    => 'material-icons burst_mode',
			'material-icons business'                      => 'material-icons business',
			'material-icons business_center'               => 'material-icons business_center',
			'material-icons cached'                        => 'material-icons cached',
			'material-icons cake'                          => 'material-icons cake',
			'material-icons call'                          => 'material-icons call',
			'material-icons call_end'                      => 'material-icons call_end',
			'material-icons call_made'                     => 'material-icons call_made',
			'material-icons call_merge'                    => 'material-icons call_merge',
			'material-icons call_missed'                   => 'material-icons call_missed',
			'material-icons call_missed_outgoing'          => 'material-icons call_missed_outgoing',
			'material-icons call_received'                 => 'material-icons call_received',
			'material-icons call_split'                    => 'material-icons call_split',
			'material-icons call_to_action'                => 'material-icons call_to_action',
			'material-icons camera'                        => 'material-icons camera',
			'material-icons camera_alt'                    => 'material-icons camera_alt',
			'material-icons camera_enhance'                => 'material-icons camera_enhance',
			'material-icons camera_front'                  => 'material-icons camera_front',
			'material-icons camera_rear'                   => 'material-icons camera_rear',
			'material-icons camera_roll'                   => 'material-icons camera_roll',
			'material-icons cancel'                        => 'material-icons cancel',
			'material-icons card_giftcard'                 => 'material-icons card_giftcard',
			'material-icons card_membership'               => 'material-icons card_membership',
			'material-icons card_travel'                   => 'material-icons card_travel',
			'material-icons casino'                        => 'material-icons casino',
			'material-icons cast'                          => 'material-icons cast',
			'material-icons cast_connected'                => 'material-icons cast_connected',
			'material-icons center_focus_strong'           => 'material-icons center_focus_strong',
			'material-icons center_focus_weak'             => 'material-icons center_focus_weak',
			'material-icons change_history'                => 'material-icons change_history',
			'material-icons chat'                          => 'material-icons chat',
			'material-icons chat_bubble'                   => 'material-icons chat_bubble',
			'material-icons chat_bubble_outline'           => 'material-icons chat_bubble_outline',
			'material-icons check'                         => 'material-icons check',
			'material-icons check_box'                     => 'material-icons check_box',
			'material-icons check_box_outline_blank'       => 'material-icons check_box_outline_blank',
			'material-icons check_circle'                  => 'material-icons check_circle',
			'material-icons chevron_left'                  => 'material-icons chevron_left',
			'material-icons chevron_right'                 => 'material-icons chevron_right',
			'material-icons child_care'                    => 'material-icons child_care',
			'material-icons child_friendly'                => 'material-icons child_friendly',
			'material-icons chrome_reader_mode'            => 'material-icons chrome_reader_mode',
			'material-icons class'                         => 'material-icons class',
			'material-icons clear'                         => 'material-icons clear',
			'material-icons clear_all'                     => 'material-icons clear_all',
			'material-icons close'                         => 'material-icons close',
			'material-icons closed_caption'                => 'material-icons closed_caption',
			'material-icons cloud'                         => 'material-icons cloud',
			'material-icons cloud_circle'                  => 'material-icons cloud_circle',
			'material-icons cloud_done'                    => 'material-icons cloud_done',
			'material-icons cloud_download'                => 'material-icons cloud_download',
			'material-icons cloud_off'                     => 'material-icons cloud_off',
			'material-icons cloud_queue'                   => 'material-icons cloud_queue',
			'material-icons cloud_upload'                  => 'material-icons cloud_upload',
			'material-icons code'                          => 'material-icons code',
			'material-icons collections'                   => 'material-icons collections',
			'material-icons collections_bookmark'          => 'material-icons collections_bookmark',
			'material-icons color_lens'                    => 'material-icons color_lens',
			'material-icons colorize'                      => 'material-icons colorize',
			'material-icons comment'                       => 'material-icons comment',
			'material-icons compare'                       => 'material-icons compare',
			'material-icons compare_arrows'                => 'material-icons compare_arrows',
			'material-icons computer'                      => 'material-icons computer',
			'material-icons confirmation_number'           => 'material-icons confirmation_number',
			'material-icons contact_mail'                  => 'material-icons contact_mail',
			'material-icons contact_phone'                 => 'material-icons contact_phone',
			'material-icons contacts'                      => 'material-icons contacts',
			'material-icons content_copy'                  => 'material-icons content_copy',
			'material-icons content_cut'                   => 'material-icons content_cut',
			'material-icons content_paste'                 => 'material-icons content_paste',
			'material-icons control_point'                 => 'material-icons control_point',
			'material-icons control_point_duplicate'       => 'material-icons control_point_duplicate',
			'material-icons copyright'                     => 'material-icons copyright',
			'material-icons create'                        => 'material-icons create',
			'material-icons create_new_folder'             => 'material-icons create_new_folder',
			'material-icons credit_card'                   => 'material-icons credit_card',
			'material-icons crop'                          => 'material-icons crop',
			'material-icons crop_16_9'                     => 'material-icons crop_16_9',
			'material-icons crop_3_2'                      => 'material-icons crop_3_2',
			'material-icons crop_5_4'                      => 'material-icons crop_5_4',
			'material-icons crop_7_5'                      => 'material-icons crop_7_5',
			'material-icons crop_din'                      => 'material-icons crop_din',
			'material-icons crop_free'                     => 'material-icons crop_free',
			'material-icons crop_landscape'                => 'material-icons crop_landscape',
			'material-icons crop_original'                 => 'material-icons crop_original',
			'material-icons crop_portrait'                 => 'material-icons crop_portrait',
			'material-icons crop_rotate'                   => 'material-icons crop_rotate',
			'material-icons crop_square'                   => 'material-icons crop_square',
			'material-icons dashboard'                     => 'material-icons dashboard',
			'material-icons data_usage'                    => 'material-icons data_usage',
			'material-icons date_range'                    => 'material-icons date_range',
			'material-icons dehaze'                        => 'material-icons dehaze',
			'material-icons delete'                        => 'material-icons delete',
			'material-icons delete_forever'                => 'material-icons delete_forever',
			'material-icons delete_sweep'                  => 'material-icons delete_sweep',
			'material-icons description'                   => 'material-icons description',
			'material-icons desktop_mac'                   => 'material-icons desktop_mac',
			'material-icons desktop_windows'               => 'material-icons desktop_windows',
			'material-icons details'                       => 'material-icons details',
			'material-icons developer_board'               => 'material-icons developer_board',
			'material-icons developer_mode'                => 'material-icons developer_mode',
			'material-icons device_hub'                    => 'material-icons device_hub',
			'material-icons devices'                       => 'material-icons devices',
			'material-icons devices_other'                 => 'material-icons devices_other',
			'material-icons dialer_sip'                    => 'material-icons dialer_sip',
			'material-icons dialpad'                       => 'material-icons dialpad',
			'material-icons directions'                    => 'material-icons directions',
			'material-icons directions_bike'               => 'material-icons directions_bike',
			'material-icons directions_boat'               => 'material-icons directions_boat',
			'material-icons directions_bus'                => 'material-icons directions_bus',
			'material-icons directions_car'                => 'material-icons directions_car',
			'material-icons directions_railway'            => 'material-icons directions_railway',
			'material-icons directions_run'                => 'material-icons directions_run',
			'material-icons directions_subway'             => 'material-icons directions_subway',
			'material-icons directions_transit'            => 'material-icons directions_transit',
			'material-icons directions_walk'               => 'material-icons directions_walk',
			'material-icons disc_full'                     => 'material-icons disc_full',
			'material-icons dns'                           => 'material-icons dns',
			'material-icons do_not_disturb'                => 'material-icons do_not_disturb',
			'material-icons do_not_disturb_alt'            => 'material-icons do_not_disturb_alt',
			'material-icons do_not_disturb_off'            => 'material-icons do_not_disturb_off',
			'material-icons do_not_disturb_on'             => 'material-icons do_not_disturb_on',
			'material-icons dock'                          => 'material-icons dock',
			'material-icons domain'                        => 'material-icons domain',
			'material-icons done'                          => 'material-icons done',
			'material-icons done_all'                      => 'material-icons done_all',
			'material-icons donut_large'                   => 'material-icons donut_large',
			'material-icons donut_small'                   => 'material-icons donut_small',
			'material-icons drafts'                        => 'material-icons drafts',
			'material-icons drag_handle'                   => 'material-icons drag_handle',
			'material-icons drive_eta'                     => 'material-icons drive_eta',
			'material-icons dvr'                           => 'material-icons dvr',
			'material-icons edit'                          => 'material-icons edit',
			'material-icons edit_location'                 => 'material-icons edit_location',
			'material-icons eject'                         => 'material-icons eject',
			'material-icons email'                         => 'material-icons email',
			'material-icons enhanced_encryption'           => 'material-icons enhanced_encryption',
			'material-icons equalizer'                     => 'material-icons equalizer',
			'material-icons error'                         => 'material-icons error',
			'material-icons error_outline'                 => 'material-icons error_outline',
			'material-icons euro_symbol'                   => 'material-icons euro_symbol',
			'material-icons ev_station'                    => 'material-icons ev_station',
			'material-icons event'                         => 'material-icons event',
			'material-icons event_available'               => 'material-icons event_available',
			'material-icons event_busy'                    => 'material-icons event_busy',
			'material-icons event_note'                    => 'material-icons event_note',
			'material-icons event_seat'                    => 'material-icons event_seat',
			'material-icons exit_to_app'                   => 'material-icons exit_to_app',
			'material-icons expand_less'                   => 'material-icons expand_less',
			'material-icons expand_more'                   => 'material-icons expand_more',
			'material-icons explicit'                      => 'material-icons explicit',
			'material-icons explore'                       => 'material-icons explore',
			'material-icons exposure'                      => 'material-icons exposure',
			'material-icons exposure_neg_1'                => 'material-icons exposure_neg_1',
			'material-icons exposure_neg_2'                => 'material-icons exposure_neg_2',
			'material-icons exposure_plus_1'               => 'material-icons exposure_plus_1',
			'material-icons exposure_plus_2'               => 'material-icons exposure_plus_2',
			'material-icons exposure_zero'                 => 'material-icons exposure_zero',
			'material-icons extension'                     => 'material-icons extension',
			'material-icons face'                          => 'material-icons face',
			'material-icons fast_forward'                  => 'material-icons fast_forward',
			'material-icons fast_rewind'                   => 'material-icons fast_rewind',
			'material-icons favorite'                      => 'material-icons favorite',
			'material-icons favorite_border'               => 'material-icons favorite_border',
			'material-icons featured_play_list'            => 'material-icons featured_play_list',
			'material-icons featured_video'                => 'material-icons featured_video',
			'material-icons feedback'                      => 'material-icons feedback',
			'material-icons fiber_dvr'                     => 'material-icons fiber_dvr',
			'material-icons fiber_manual_record'           => 'material-icons fiber_manual_record',
			'material-icons fiber_new'                     => 'material-icons fiber_new',
			'material-icons fiber_pin'                     => 'material-icons fiber_pin',
			'material-icons fiber_smart_record'            => 'material-icons fiber_smart_record',
			'material-icons file_download'                 => 'material-icons file_download',
			'material-icons file_upload'                   => 'material-icons file_upload',
			'material-icons filter'                        => 'material-icons filter',
			'material-icons filter_1'                      => 'material-icons filter_1',
			'material-icons filter_2'                      => 'material-icons filter_2',
			'material-icons filter_3'                      => 'material-icons filter_3',
			'material-icons filter_4'                      => 'material-icons filter_4',
			'material-icons filter_5'                      => 'material-icons filter_5',
			'material-icons filter_6'                      => 'material-icons filter_6',
			'material-icons filter_7'                      => 'material-icons filter_7',
			'material-icons filter_8'                      => 'material-icons filter_8',
			'material-icons filter_9'                      => 'material-icons filter_9',
			'material-icons filter_9_plus'                 => 'material-icons filter_9_plus',
			'material-icons filter_b_and_w'                => 'material-icons filter_b_and_w',
			'material-icons filter_center_focus'           => 'material-icons filter_center_focus',
			'material-icons filter_drama'                  => 'material-icons filter_drama',
			'material-icons filter_frames'                 => 'material-icons filter_frames',
			'material-icons filter_hdr'                    => 'material-icons filter_hdr',
			'material-icons filter_list'                   => 'material-icons filter_list',
			'material-icons filter_none'                   => 'material-icons filter_none',
			'material-icons filter_tilt_shift'             => 'material-icons filter_tilt_shift',
			'material-icons filter_vintage'                => 'material-icons filter_vintage',
			'material-icons find_in_page'                  => 'material-icons find_in_page',
			'material-icons find_replace'                  => 'material-icons find_replace',
			'material-icons fingerprint'                   => 'material-icons fingerprint',
			'material-icons first_page'                    => 'material-icons first_page',
			'material-icons fitness_center'                => 'material-icons fitness_center',
			'material-icons flag'                          => 'material-icons flag',
			'material-icons flare'                         => 'material-icons flare',
			'material-icons flash_auto'                    => 'material-icons flash_auto',
			'material-icons flash_off'                     => 'material-icons flash_off',
			'material-icons flash_on'                      => 'material-icons flash_on',
			'material-icons flight'                        => 'material-icons flight',
			'material-icons flight_land'                   => 'material-icons flight_land',
			'material-icons flight_takeoff'                => 'material-icons flight_takeoff',
			'material-icons flip'                          => 'material-icons flip',
			'material-icons flip_to_back'                  => 'material-icons flip_to_back',
			'material-icons flip_to_front'                 => 'material-icons flip_to_front',
			'material-icons folder'                        => 'material-icons folder',
			'material-icons folder_open'                   => 'material-icons folder_open',
			'material-icons folder_shared'                 => 'material-icons folder_shared',
			'material-icons folder_special'                => 'material-icons folder_special',
			'material-icons font_download'                 => 'material-icons font_download',
			'material-icons format_align_center'           => 'material-icons format_align_center',
			'material-icons format_align_justify'          => 'material-icons format_align_justify',
			'material-icons format_align_left'             => 'material-icons format_align_left',
			'material-icons format_align_right'            => 'material-icons format_align_right',
			'material-icons format_bold'                   => 'material-icons format_bold',
			'material-icons format_clear'                  => 'material-icons format_clear',
			'material-icons format_color_fill'             => 'material-icons format_color_fill',
			'material-icons format_color_reset'            => 'material-icons format_color_reset',
			'material-icons format_color_text'             => 'material-icons format_color_text',
			'material-icons format_indent_decrease'        => 'material-icons format_indent_decrease',
			'material-icons format_indent_increase'        => 'material-icons format_indent_increase',
			'material-icons format_italic'                 => 'material-icons format_italic',
			'material-icons format_line_spacing'           => 'material-icons format_line_spacing',
			'material-icons format_list_bulleted'          => 'material-icons format_list_bulleted',
			'material-icons format_list_numbered'          => 'material-icons format_list_numbered',
			'material-icons format_paint'                  => 'material-icons format_paint',
			'material-icons format_quote'                  => 'material-icons format_quote',
			'material-icons format_shapes'                 => 'material-icons format_shapes',
			'material-icons format_size'                   => 'material-icons format_size',
			'material-icons format_strikethrough'          => 'material-icons format_strikethrough',
			'material-icons format_textdirection_l_to_r'   => 'material-icons format_textdirection_l_to_r',
			'material-icons format_textdirection_r_to_l'   => 'material-icons format_textdirection_r_to_l',
			'material-icons format_underlined'             => 'material-icons format_underlined',
			'material-icons forum'                         => 'material-icons forum',
			'material-icons forward'                       => 'material-icons forward',
			'material-icons forward_10'                    => 'material-icons forward_10',
			'material-icons forward_30'                    => 'material-icons forward_30',
			'material-icons forward_5'                     => 'material-icons forward_5',
			'material-icons free_breakfast'                => 'material-icons free_breakfast',
			'material-icons fullscreen'                    => 'material-icons fullscreen',
			'material-icons fullscreen_exit'               => 'material-icons fullscreen_exit',
			'material-icons functions'                     => 'material-icons functions',
			'material-icons g_translate'                   => 'material-icons g_translate',
			'material-icons gamepad'                       => 'material-icons gamepad',
			'material-icons games'                         => 'material-icons games',
			'material-icons gavel'                         => 'material-icons gavel',
			'material-icons gesture'                       => 'material-icons gesture',
			'material-icons get_app'                       => 'material-icons get_app',
			'material-icons gif'                           => 'material-icons gif',
			'material-icons golf_course'                   => 'material-icons golf_course',
			'material-icons gps_fixed'                     => 'material-icons gps_fixed',
			'material-icons gps_not_fixed'                 => 'material-icons gps_not_fixed',
			'material-icons gps_off'                       => 'material-icons gps_off',
			'material-icons grade'                         => 'material-icons grade',
			'material-icons gradient'                      => 'material-icons gradient',
			'material-icons grain'                         => 'material-icons grain',
			'material-icons graphic_eq'                    => 'material-icons graphic_eq',
			'material-icons grid_off'                      => 'material-icons grid_off',
			'material-icons grid_on'                       => 'material-icons grid_on',
			'material-icons group'                         => 'material-icons group',
			'material-icons group_add'                     => 'material-icons group_add',
			'material-icons group_work'                    => 'material-icons group_work',
			'material-icons hd'                            => 'material-icons hd',
			'material-icons hdr_off'                       => 'material-icons hdr_off',
			'material-icons hdr_on'                        => 'material-icons hdr_on',
			'material-icons hdr_strong'                    => 'material-icons hdr_strong',
			'material-icons hdr_weak'                      => 'material-icons hdr_weak',
			'material-icons headset'                       => 'material-icons headset',
			'material-icons headset_mic'                   => 'material-icons headset_mic',
			'material-icons healing'                       => 'material-icons healing',
			'material-icons hearing'                       => 'material-icons hearing',
			'material-icons help'                          => 'material-icons help',
			'material-icons help_outline'                  => 'material-icons help_outline',
			'material-icons high_quality'                  => 'material-icons high_quality',
			'material-icons highlight'                     => 'material-icons highlight',
			'material-icons highlight_off'                 => 'material-icons highlight_off',
			'material-icons history'                       => 'material-icons history',
			'material-icons home'                          => 'material-icons home',
			'material-icons hot_tub'                       => 'material-icons hot_tub',
			'material-icons hotel'                         => 'material-icons hotel',
			'material-icons hourglass_empty'               => 'material-icons hourglass_empty',
			'material-icons hourglass_full'                => 'material-icons hourglass_full',
			'material-icons http'                          => 'material-icons http',
			'material-icons https'                         => 'material-icons https',
			'material-icons image'                         => 'material-icons image',
			'material-icons image_aspect_ratio'            => 'material-icons image_aspect_ratio',
			'material-icons import_contacts'               => 'material-icons import_contacts',
			'material-icons import_export'                 => 'material-icons import_export',
			'material-icons important_devices'             => 'material-icons important_devices',
			'material-icons inbox'                         => 'material-icons inbox',
			'material-icons indeterminate_check_box'       => 'material-icons indeterminate_check_box',
			'material-icons info'                          => 'material-icons info',
			'material-icons info_outline'                  => 'material-icons info_outline',
			'material-icons input'                         => 'material-icons input',
			'material-icons insert_chart'                  => 'material-icons insert_chart',
			'material-icons insert_comment'                => 'material-icons insert_comment',
			'material-icons insert_drive_file'             => 'material-icons insert_drive_file',
			'material-icons insert_emoticon'               => 'material-icons insert_emoticon',
			'material-icons insert_invitation'             => 'material-icons insert_invitation',
			'material-icons insert_link'                   => 'material-icons insert_link',
			'material-icons insert_photo'                  => 'material-icons insert_photo',
			'material-icons invert_colors'                 => 'material-icons invert_colors',
			'material-icons invert_colors_off'             => 'material-icons invert_colors_off',
			'material-icons iso'                           => 'material-icons iso',
			'material-icons keyboard'                      => 'material-icons keyboard',
			'material-icons keyboard_arrow_down'           => 'material-icons keyboard_arrow_down',
			'material-icons keyboard_arrow_left'           => 'material-icons keyboard_arrow_left',
			'material-icons keyboard_arrow_right'          => 'material-icons keyboard_arrow_right',
			'material-icons keyboard_arrow_up'             => 'material-icons keyboard_arrow_up',
			'material-icons keyboard_backspace'            => 'material-icons keyboard_backspace',
			'material-icons keyboard_capslock'             => 'material-icons keyboard_capslock',
			'material-icons keyboard_hide'                 => 'material-icons keyboard_hide',
			'material-icons keyboard_return'               => 'material-icons keyboard_return',
			'material-icons keyboard_tab'                  => 'material-icons keyboard_tab',
			'material-icons keyboard_voice'                => 'material-icons keyboard_voice',
			'material-icons kitchen'                       => 'material-icons kitchen',
			'material-icons label'                         => 'material-icons label',
			'material-icons label_outline'                 => 'material-icons label_outline',
			'material-icons landscape'                     => 'material-icons landscape',
			'material-icons language'                      => 'material-icons language',
			'material-icons laptop'                        => 'material-icons laptop',
			'material-icons laptop_chromebook'             => 'material-icons laptop_chromebook',
			'material-icons laptop_mac'                    => 'material-icons laptop_mac',
			'material-icons laptop_windows'                => 'material-icons laptop_windows',
			'material-icons last_page'                     => 'material-icons last_page',
			'material-icons launch'                        => 'material-icons launch',
			'material-icons layers'                        => 'material-icons layers',
			'material-icons layers_clear'                  => 'material-icons layers_clear',
			'material-icons leak_add'                      => 'material-icons leak_add',
			'material-icons leak_remove'                   => 'material-icons leak_remove',
			'material-icons lens'                          => 'material-icons lens',
			'material-icons library_add'                   => 'material-icons library_add',
			'material-icons library_books'                 => 'material-icons library_books',
			'material-icons library_music'                 => 'material-icons library_music',
			'material-icons lightbulb_outline'             => 'material-icons lightbulb_outline',
			'material-icons line_style'                    => 'material-icons line_style',
			'material-icons line_weight'                   => 'material-icons line_weight',
			'material-icons linear_scale'                  => 'material-icons linear_scale',
			'material-icons link'                          => 'material-icons link',
			'material-icons linked_camera'                 => 'material-icons linked_camera',
			'material-icons list'                          => 'material-icons list',
			'material-icons live_help'                     => 'material-icons live_help',
			'material-icons live_tv'                       => 'material-icons live_tv',
			'material-icons local_activity'                => 'material-icons local_activity',
			'material-icons local_airport'                 => 'material-icons local_airport',
			'material-icons local_atm'                     => 'material-icons local_atm',
			'material-icons local_bar'                     => 'material-icons local_bar',
			'material-icons local_cafe'                    => 'material-icons local_cafe',
			'material-icons local_car_wash'                => 'material-icons local_car_wash',
			'material-icons local_convenience_store'       => 'material-icons local_convenience_store',
			'material-icons local_dining'                  => 'material-icons local_dining',
			'material-icons local_drink'                   => 'material-icons local_drink',
			'material-icons local_florist'                 => 'material-icons local_florist',
			'material-icons local_gas_station'             => 'material-icons local_gas_station',
			'material-icons local_grocery_store'           => 'material-icons local_grocery_store',
			'material-icons local_hospital'                => 'material-icons local_hospital',
			'material-icons local_hotel'                   => 'material-icons local_hotel',
			'material-icons local_laundry_service'         => 'material-icons local_laundry_service',
			'material-icons local_library'                 => 'material-icons local_library',
			'material-icons local_mall'                    => 'material-icons local_mall',
			'material-icons local_movies'                  => 'material-icons local_movies',
			'material-icons local_offer'                   => 'material-icons local_offer',
			'material-icons local_parking'                 => 'material-icons local_parking',
			'material-icons local_pharmacy'                => 'material-icons local_pharmacy',
			'material-icons local_phone'                   => 'material-icons local_phone',
			'material-icons local_pizza'                   => 'material-icons local_pizza',
			'material-icons local_play'                    => 'material-icons local_play',
			'material-icons local_post_office'             => 'material-icons local_post_office',
			'material-icons local_printshop'               => 'material-icons local_printshop',
			'material-icons local_see'                     => 'material-icons local_see',
			'material-icons local_shipping'                => 'material-icons local_shipping',
			'material-icons local_taxi'                    => 'material-icons local_taxi',
			'material-icons location_city'                 => 'material-icons location_city',
			'material-icons location_disabled'             => 'material-icons location_disabled',
			'material-icons location_off'                  => 'material-icons location_off',
			'material-icons location_on'                   => 'material-icons location_on',
			'material-icons location_searching'            => 'material-icons location_searching',
			'material-icons lock'                          => 'material-icons lock',
			'material-icons lock_open'                     => 'material-icons lock_open',
			'material-icons lock_outline'                  => 'material-icons lock_outline',
			'material-icons looks'                         => 'material-icons looks',
			'material-icons looks_3'                       => 'material-icons looks_3',
			'material-icons looks_4'                       => 'material-icons looks_4',
			'material-icons looks_5'                       => 'material-icons looks_5',
			'material-icons looks_6'                       => 'material-icons looks_6',
			'material-icons looks_one'                     => 'material-icons looks_one',
			'material-icons looks_two'                     => 'material-icons looks_two',
			'material-icons loop'                          => 'material-icons loop',
			'material-icons loupe'                         => 'material-icons loupe',
			'material-icons low_priority'                  => 'material-icons low_priority',
			'material-icons loyalty'                       => 'material-icons loyalty',
			'material-icons mail'                          => 'material-icons mail',
			'material-icons mail_outline'                  => 'material-icons mail_outline',
			'material-icons map'                           => 'material-icons map',
			'material-icons markunread'                    => 'material-icons markunread',
			'material-icons markunread_mailbox'            => 'material-icons markunread_mailbox',
			'material-icons memory'                        => 'material-icons memory',
			'material-icons menu'                          => 'material-icons menu',
			'material-icons merge_type'                    => 'material-icons merge_type',
			'material-icons message'                       => 'material-icons message',
			'material-icons mic'                           => 'material-icons mic',
			'material-icons mic_none'                      => 'material-icons mic_none',
			'material-icons mic_off'                       => 'material-icons mic_off',
			'material-icons mms'                           => 'material-icons mms',
			'material-icons mode_comment'                  => 'material-icons mode_comment',
			'material-icons mode_edit'                     => 'material-icons mode_edit',
			'material-icons monetization_on'               => 'material-icons monetization_on',
			'material-icons money_off'                     => 'material-icons money_off',
			'material-icons monochrome_photos'             => 'material-icons monochrome_photos',
			'material-icons mood'                          => 'material-icons mood',
			'material-icons mood_bad'                      => 'material-icons mood_bad',
			'material-icons more'                          => 'material-icons more',
			'material-icons more_horiz'                    => 'material-icons more_horiz',
			'material-icons more_vert'                     => 'material-icons more_vert',
			'material-icons motorcycle'                    => 'material-icons motorcycle',
			'material-icons mouse'                         => 'material-icons mouse',
			'material-icons move_to_inbox'                 => 'material-icons move_to_inbox',
			'material-icons movie'                         => 'material-icons movie',
			'material-icons movie_creation'                => 'material-icons movie_creation',
			'material-icons movie_filter'                  => 'material-icons movie_filter',
			'material-icons multiline_chart'               => 'material-icons multiline_chart',
			'material-icons music_note'                    => 'material-icons music_note',
			'material-icons music_video'                   => 'material-icons music_video',
			'material-icons my_location'                   => 'material-icons my_location',
			'material-icons nature'                        => 'material-icons nature',
			'material-icons nature_people'                 => 'material-icons nature_people',
			'material-icons navigate_before'               => 'material-icons navigate_before',
			'material-icons navigate_next'                 => 'material-icons navigate_next',
			'material-icons navigation'                    => 'material-icons navigation',
			'material-icons near_me'                       => 'material-icons near_me',
			'material-icons network_cell'                  => 'material-icons network_cell',
			'material-icons network_check'                 => 'material-icons network_check',
			'material-icons network_locked'                => 'material-icons network_locked',
			'material-icons network_wifi'                  => 'material-icons network_wifi',
			'material-icons new_releases'                  => 'material-icons new_releases',
			'material-icons next_week'                     => 'material-icons next_week',
			'material-icons nfc'                           => 'material-icons nfc',
			'material-icons no_encryption'                 => 'material-icons no_encryption',
			'material-icons no_sim'                        => 'material-icons no_sim',
			'material-icons not_interested'                => 'material-icons not_interested',
			'material-icons note'                          => 'material-icons note',
			'material-icons note_add'                      => 'material-icons note_add',
			'material-icons notifications'                 => 'material-icons notifications',
			'material-icons notifications_active'          => 'material-icons notifications_active',
			'material-icons notifications_none'            => 'material-icons notifications_none',
			'material-icons notifications_off'             => 'material-icons notifications_off',
			'material-icons notifications_paused'          => 'material-icons notifications_paused',
			'material-icons offline_pin'                   => 'material-icons offline_pin',
			'material-icons ondemand_video'                => 'material-icons ondemand_video',
			'material-icons opacity'                       => 'material-icons opacity',
			'material-icons open_in_browser'               => 'material-icons open_in_browser',
			'material-icons open_in_new'                   => 'material-icons open_in_new',
			'material-icons open_with'                     => 'material-icons open_with',
			'material-icons pages'                         => 'material-icons pages',
			'material-icons pageview'                      => 'material-icons pageview',
			'material-icons palette'                       => 'material-icons palette',
			'material-icons pan_tool'                      => 'material-icons pan_tool',
			'material-icons panorama'                      => 'material-icons panorama',
			'material-icons panorama_fish_eye'             => 'material-icons panorama_fish_eye',
			'material-icons panorama_horizontal'           => 'material-icons panorama_horizontal',
			'material-icons panorama_vertical'             => 'material-icons panorama_vertical',
			'material-icons panorama_wide_angle'           => 'material-icons panorama_wide_angle',
			'material-icons party_mode'                    => 'material-icons party_mode',
			'material-icons pause'                         => 'material-icons pause',
			'material-icons pause_circle_filled'           => 'material-icons pause_circle_filled',
			'material-icons pause_circle_outline'          => 'material-icons pause_circle_outline',
			'material-icons payment'                       => 'material-icons payment',
			'material-icons people'                        => 'material-icons people',
			'material-icons people_outline'                => 'material-icons people_outline',
			'material-icons perm_camera_mic'               => 'material-icons perm_camera_mic',
			'material-icons perm_contact_calendar'         => 'material-icons perm_contact_calendar',
			'material-icons perm_data_setting'             => 'material-icons perm_data_setting',
			'material-icons perm_device_information'       => 'material-icons perm_device_information',
			'material-icons perm_identity'                 => 'material-icons perm_identity',
			'material-icons perm_media'                    => 'material-icons perm_media',
			'material-icons perm_phone_msg'                => 'material-icons perm_phone_msg',
			'material-icons perm_scan_wifi'                => 'material-icons perm_scan_wifi',
			'material-icons person'                        => 'material-icons person',
			'material-icons person_add'                    => 'material-icons person_add',
			'material-icons person_outline'                => 'material-icons person_outline',
			'material-icons person_pin'                    => 'material-icons person_pin',
			'material-icons person_pin_circle'             => 'material-icons person_pin_circle',
			'material-icons personal_video'                => 'material-icons personal_video',
			'material-icons pets'                          => 'material-icons pets',
			'material-icons phone'                         => 'material-icons phone',
			'material-icons phone_android'                 => 'material-icons phone_android',
			'material-icons phone_bluetooth_speaker'       => 'material-icons phone_bluetooth_speaker',
			'material-icons phone_forwarded'               => 'material-icons phone_forwarded',
			'material-icons phone_in_talk'                 => 'material-icons phone_in_talk',
			'material-icons phone_iphone'                  => 'material-icons phone_iphone',
			'material-icons phone_locked'                  => 'material-icons phone_locked',
			'material-icons phone_missed'                  => 'material-icons phone_missed',
			'material-icons phone_paused'                  => 'material-icons phone_paused',
			'material-icons phonelink'                     => 'material-icons phonelink',
			'material-icons phonelink_erase'               => 'material-icons phonelink_erase',
			'material-icons phonelink_lock'                => 'material-icons phonelink_lock',
			'material-icons phonelink_off'                 => 'material-icons phonelink_off',
			'material-icons phonelink_ring'                => 'material-icons phonelink_ring',
			'material-icons phonelink_setup'               => 'material-icons phonelink_setup',
			'material-icons photo'                         => 'material-icons photo',
			'material-icons photo_album'                   => 'material-icons photo_album',
			'material-icons photo_camera'                  => 'material-icons photo_camera',
			'material-icons photo_filter'                  => 'material-icons photo_filter',
			'material-icons photo_library'                 => 'material-icons photo_library',
			'material-icons photo_size_select_actual'      => 'material-icons photo_size_select_actual',
			'material-icons photo_size_select_large'       => 'material-icons photo_size_select_large',
			'material-icons photo_size_select_small'       => 'material-icons photo_size_select_small',
			'material-icons picture_as_pdf'                => 'material-icons picture_as_pdf',
			'material-icons picture_in_picture'            => 'material-icons picture_in_picture',
			'material-icons picture_in_picture_alt'        => 'material-icons picture_in_picture_alt',
			'material-icons pie_chart'                     => 'material-icons pie_chart',
			'material-icons pie_chart_outlined'            => 'material-icons pie_chart_outlined',
			'material-icons pin_drop'                      => 'material-icons pin_drop',
			'material-icons place'                         => 'material-icons place',
			'material-icons play_arrow'                    => 'material-icons play_arrow',
			'material-icons play_circle_filled'            => 'material-icons play_circle_filled',
			'material-icons play_circle_outline'           => 'material-icons play_circle_outline',
			'material-icons play_for_work'                 => 'material-icons play_for_work',
			'material-icons playlist_add'                  => 'material-icons playlist_add',
			'material-icons playlist_add_check'            => 'material-icons playlist_add_check',
			'material-icons playlist_play'                 => 'material-icons playlist_play',
			'material-icons plus_one'                      => 'material-icons plus_one',
			'material-icons poll'                          => 'material-icons poll',
			'material-icons polymer'                       => 'material-icons polymer',
			'material-icons pool'                          => 'material-icons pool',
			'material-icons portable_wifi_off'             => 'material-icons portable_wifi_off',
			'material-icons portrait'                      => 'material-icons portrait',
			'material-icons power'                         => 'material-icons power',
			'material-icons power_input'                   => 'material-icons power_input',
			'material-icons power_settings_new'            => 'material-icons power_settings_new',
			'material-icons pregnant_woman'                => 'material-icons pregnant_woman',
			'material-icons present_to_all'                => 'material-icons present_to_all',
			'material-icons print'                         => 'material-icons print',
			'material-icons priority_high'                 => 'material-icons priority_high',
			'material-icons public'                        => 'material-icons public',
			'material-icons publish'                       => 'material-icons publish',
			'material-icons query_builder'                 => 'material-icons query_builder',
			'material-icons question_answer'               => 'material-icons question_answer',
			'material-icons queue'                         => 'material-icons queue',
			'material-icons queue_music'                   => 'material-icons queue_music',
			'material-icons queue_play_next'               => 'material-icons queue_play_next',
			'material-icons radio'                         => 'material-icons radio',
			'material-icons radio_button_checked'          => 'material-icons radio_button_checked',
			'material-icons radio_button_unchecked'        => 'material-icons radio_button_unchecked',
			'material-icons rate_review'                   => 'material-icons rate_review',
			'material-icons receipt'                       => 'material-icons receipt',
			'material-icons recent_actors'                 => 'material-icons recent_actors',
			'material-icons record_voice_over'             => 'material-icons record_voice_over',
			'material-icons redeem'                        => 'material-icons redeem',
			'material-icons redo'                          => 'material-icons redo',
			'material-icons refresh'                       => 'material-icons refresh',
			'material-icons remove'                        => 'material-icons remove',
			'material-icons remove_circle'                 => 'material-icons remove_circle',
			'material-icons remove_circle_outline'         => 'material-icons remove_circle_outline',
			'material-icons remove_from_queue'             => 'material-icons remove_from_queue',
			'material-icons remove_red_eye'                => 'material-icons remove_red_eye',
			'material-icons remove_shopping_cart'          => 'material-icons remove_shopping_cart',
			'material-icons reorder'                       => 'material-icons reorder',
			'material-icons repeat'                        => 'material-icons repeat',
			'material-icons repeat_one'                    => 'material-icons repeat_one',
			'material-icons replay'                        => 'material-icons replay',
			'material-icons replay_10'                     => 'material-icons replay_10',
			'material-icons replay_30'                     => 'material-icons replay_30',
			'material-icons replay_5'                      => 'material-icons replay_5',
			'material-icons reply'                         => 'material-icons reply',
			'material-icons reply_all'                     => 'material-icons reply_all',
			'material-icons report'                        => 'material-icons report',
			'material-icons report_problem'                => 'material-icons report_problem',
			'material-icons restaurant'                    => 'material-icons restaurant',
			'material-icons restaurant_menu'               => 'material-icons restaurant_menu',
			'material-icons restore'                       => 'material-icons restore',
			'material-icons restore_page'                  => 'material-icons restore_page',
			'material-icons ring_volume'                   => 'material-icons ring_volume',
			'material-icons room'                          => 'material-icons room',
			'material-icons room_service'                  => 'material-icons room_service',
			'material-icons rotate_90_degrees_ccw'         => 'material-icons rotate_90_degrees_ccw',
			'material-icons rotate_left'                   => 'material-icons rotate_left',
			'material-icons rotate_right'                  => 'material-icons rotate_right',
			'material-icons rounded_corner'                => 'material-icons rounded_corner',
			'material-icons router'                        => 'material-icons router',
			'material-icons rowing'                        => 'material-icons rowing',
			'material-icons rss_feed'                      => 'material-icons rss_feed',
			'material-icons rv_hookup'                     => 'material-icons rv_hookup',
			'material-icons satellite'                     => 'material-icons satellite',
			'material-icons save'                          => 'material-icons save',
			'material-icons scanner'                       => 'material-icons scanner',
			'material-icons schedule'                      => 'material-icons schedule',
			'material-icons school'                        => 'material-icons school',
			'material-icons screen_lock_landscape'         => 'material-icons screen_lock_landscape',
			'material-icons screen_lock_portrait'          => 'material-icons screen_lock_portrait',
			'material-icons screen_lock_rotation'          => 'material-icons screen_lock_rotation',
			'material-icons screen_rotation'               => 'material-icons screen_rotation',
			'material-icons screen_share'                  => 'material-icons screen_share',
			'material-icons sd_card'                       => 'material-icons sd_card',
			'material-icons sd_storage'                    => 'material-icons sd_storage',
			'material-icons search'                        => 'material-icons search',
			'material-icons security'                      => 'material-icons security',
			'material-icons select_all'                    => 'material-icons select_all',
			'material-icons send'                          => 'material-icons send',
			'material-icons sentiment_dissatisfied'        => 'material-icons sentiment_dissatisfied',
			'material-icons sentiment_neutral'             => 'material-icons sentiment_neutral',
			'material-icons sentiment_satisfied'           => 'material-icons sentiment_satisfied',
			'material-icons sentiment_very_dissatisfied'   => 'material-icons sentiment_very_dissatisfied',
			'material-icons sentiment_very_satisfied'      => 'material-icons sentiment_very_satisfied',
			'material-icons settings'                      => 'material-icons settings',
			'material-icons settings_applications'         => 'material-icons settings_applications',
			'material-icons settings_backup_restore'       => 'material-icons settings_backup_restore',
			'material-icons settings_bluetooth'            => 'material-icons settings_bluetooth',
			'material-icons settings_brightness'           => 'material-icons settings_brightness',
			'material-icons settings_cell'                 => 'material-icons settings_cell',
			'material-icons settings_ethernet'             => 'material-icons settings_ethernet',
			'material-icons settings_input_antenna'        => 'material-icons settings_input_antenna',
			'material-icons settings_input_component'      => 'material-icons settings_input_component',
			'material-icons settings_input_composite'      => 'material-icons settings_input_composite',
			'material-icons settings_input_hdmi'           => 'material-icons settings_input_hdmi',
			'material-icons settings_input_svideo'         => 'material-icons settings_input_svideo',
			'material-icons settings_overscan'             => 'material-icons settings_overscan',
			'material-icons settings_phone'                => 'material-icons settings_phone',
			'material-icons settings_power'                => 'material-icons settings_power',
			'material-icons settings_remote'               => 'material-icons settings_remote',
			'material-icons settings_system_daydream'      => 'material-icons settings_system_daydream',
			'material-icons settings_voice'                => 'material-icons settings_voice',
			'material-icons share'                         => 'material-icons share',
			'material-icons shop'                          => 'material-icons shop',
			'material-icons shop_two'                      => 'material-icons shop_two',
			'material-icons shopping_basket'               => 'material-icons shopping_basket',
			'material-icons shopping_cart'                 => 'material-icons shopping_cart',
			'material-icons short_text'                    => 'material-icons short_text',
			'material-icons show_chart'                    => 'material-icons show_chart',
			'material-icons shuffle'                       => 'material-icons shuffle',
			'material-icons signal_cellular_4_bar'         => 'material-icons signal_cellular_4_bar',
			'material-icons signal_cellular_connected_no_internet_4_bar' => 'material-icons signal_cellular_connected_no_internet_4_bar',
			'material-icons signal_cellular_no_sim'        => 'material-icons signal_cellular_no_sim',
			'material-icons signal_cellular_null'          => 'material-icons signal_cellular_null',
			'material-icons signal_cellular_off'           => 'material-icons signal_cellular_off',
			'material-icons signal_wifi_4_bar'             => 'material-icons signal_wifi_4_bar',
			'material-icons signal_wifi_4_bar_lock'        => 'material-icons signal_wifi_4_bar_lock',
			'material-icons signal_wifi_off'               => 'material-icons signal_wifi_off',
			'material-icons sim_card'                      => 'material-icons sim_card',
			'material-icons sim_card_alert'                => 'material-icons sim_card_alert',
			'material-icons skip_next'                     => 'material-icons skip_next',
			'material-icons skip_previous'                 => 'material-icons skip_previous',
			'material-icons slideshow'                     => 'material-icons slideshow',
			'material-icons slow_motion_video'             => 'material-icons slow_motion_video',
			'material-icons smartphone'                    => 'material-icons smartphone',
			'material-icons smoke_free'                    => 'material-icons smoke_free',
			'material-icons smoking_rooms'                 => 'material-icons smoking_rooms',
			'material-icons sms'                           => 'material-icons sms',
			'material-icons sms_failed'                    => 'material-icons sms_failed',
			'material-icons snooze'                        => 'material-icons snooze',
			'material-icons sort'                          => 'material-icons sort',
			'material-icons sort_by_alpha'                 => 'material-icons sort_by_alpha',
			'material-icons spa'                           => 'material-icons spa',
			'material-icons space_bar'                     => 'material-icons space_bar',
			'material-icons speaker'                       => 'material-icons speaker',
			'material-icons speaker_group'                 => 'material-icons speaker_group',
			'material-icons speaker_notes'                 => 'material-icons speaker_notes',
			'material-icons speaker_notes_off'             => 'material-icons speaker_notes_off',
			'material-icons speaker_phone'                 => 'material-icons speaker_phone',
			'material-icons spellcheck'                    => 'material-icons spellcheck',
			'material-icons star'                          => 'material-icons star',
			'material-icons star_border'                   => 'material-icons star_border',
			'material-icons star_half'                     => 'material-icons star_half',
			'material-icons stars'                         => 'material-icons stars',
			'material-icons stay_current_landscape'        => 'material-icons stay_current_landscape',
			'material-icons stay_current_portrait'         => 'material-icons stay_current_portrait',
			'material-icons stay_primary_landscape'        => 'material-icons stay_primary_landscape',
			'material-icons stay_primary_portrait'         => 'material-icons stay_primary_portrait',
			'material-icons stop'                          => 'material-icons stop',
			'material-icons stop_screen_share'             => 'material-icons stop_screen_share',
			'material-icons storage'                       => 'material-icons storage',
			'material-icons store'                         => 'material-icons store',
			'material-icons store_mall_directory'          => 'material-icons store_mall_directory',
			'material-icons straighten'                    => 'material-icons straighten',
			'material-icons streetview'                    => 'material-icons streetview',
			'material-icons strikethrough_s'               => 'material-icons strikethrough_s',
			'material-icons style'                         => 'material-icons style',
			'material-icons subdirectory_arrow_left'       => 'material-icons subdirectory_arrow_left',
			'material-icons subdirectory_arrow_right'      => 'material-icons subdirectory_arrow_right',
			'material-icons subject'                       => 'material-icons subject',
			'material-icons subscriptions'                 => 'material-icons subscriptions',
			'material-icons subtitles'                     => 'material-icons subtitles',
			'material-icons subway'                        => 'material-icons subway',
			'material-icons supervisor_account'            => 'material-icons supervisor_account',
			'material-icons surround_sound'                => 'material-icons surround_sound',
			'material-icons swap_calls'                    => 'material-icons swap_calls',
			'material-icons swap_horiz'                    => 'material-icons swap_horiz',
			'material-icons swap_vert'                     => 'material-icons swap_vert',
			'material-icons swap_vertical_circle'          => 'material-icons swap_vertical_circle',
			'material-icons switch_camera'                 => 'material-icons switch_camera',
			'material-icons switch_video'                  => 'material-icons switch_video',
			'material-icons sync'                          => 'material-icons sync',
			'material-icons sync_disabled'                 => 'material-icons sync_disabled',
			'material-icons sync_problem'                  => 'material-icons sync_problem',
			'material-icons system_update'                 => 'material-icons system_update',
			'material-icons system_update_alt'             => 'material-icons system_update_alt',
			'material-icons tab'                           => 'material-icons tab',
			'material-icons tab_unselected'                => 'material-icons tab_unselected',
			'material-icons tablet'                        => 'material-icons tablet',
			'material-icons tablet_android'                => 'material-icons tablet_android',
			'material-icons tablet_mac'                    => 'material-icons tablet_mac',
			'material-icons tag_faces'                     => 'material-icons tag_faces',
			'material-icons tap_and_play'                  => 'material-icons tap_and_play',
			'material-icons terrain'                       => 'material-icons terrain',
			'material-icons text_fields'                   => 'material-icons text_fields',
			'material-icons text_format'                   => 'material-icons text_format',
			'material-icons textsms'                       => 'material-icons textsms',
			'material-icons texture'                       => 'material-icons texture',
			'material-icons theaters'                      => 'material-icons theaters',
			'material-icons thumb_down'                    => 'material-icons thumb_down',
			'material-icons thumb_up'                      => 'material-icons thumb_up',
			'material-icons thumbs_up_down'                => 'material-icons thumbs_up_down',
			'material-icons time_to_leave'                 => 'material-icons time_to_leave',
			'material-icons timelapse'                     => 'material-icons timelapse',
			'material-icons timeline'                      => 'material-icons timeline',
			'material-icons timer'                         => 'material-icons timer',
			'material-icons timer_10'                      => 'material-icons timer_10',
			'material-icons timer_3'                       => 'material-icons timer_3',
			'material-icons timer_off'                     => 'material-icons timer_off',
			'material-icons title'                         => 'material-icons title',
			'material-icons toc'                           => 'material-icons toc',
			'material-icons today'                         => 'material-icons today',
			'material-icons toll'                          => 'material-icons toll',
			'material-icons tonality'                      => 'material-icons tonality',
			'material-icons touch_app'                     => 'material-icons touch_app',
			'material-icons toys'                          => 'material-icons toys',
			'material-icons track_changes'                 => 'material-icons track_changes',
			'material-icons traffic'                       => 'material-icons traffic',
			'material-icons train'                         => 'material-icons train',
			'material-icons tram'                          => 'material-icons tram',
			'material-icons transfer_within_a_station'     => 'material-icons transfer_within_a_station',
			'material-icons transform'                     => 'material-icons transform',
			'material-icons translate'                     => 'material-icons translate',
			'material-icons trending_down'                 => 'material-icons trending_down',
			'material-icons trending_flat'                 => 'material-icons trending_flat',
			'material-icons trending_up'                   => 'material-icons trending_up',
			'material-icons tune'                          => 'material-icons tune',
			'material-icons turned_in'                     => 'material-icons turned_in',
			'material-icons turned_in_not'                 => 'material-icons turned_in_not',
			'material-icons tv'                            => 'material-icons tv',
			'material-icons unarchive'                     => 'material-icons unarchive',
			'material-icons undo'                          => 'material-icons undo',
			'material-icons unfold_less'                   => 'material-icons unfold_less',
			'material-icons unfold_more'                   => 'material-icons unfold_more',
			'material-icons update'                        => 'material-icons update',
			'material-icons usb'                           => 'material-icons usb',
			'material-icons verified_user'                 => 'material-icons verified_user',
			'material-icons vertical_align_bottom'         => 'material-icons vertical_align_bottom',
			'material-icons vertical_align_center'         => 'material-icons vertical_align_center',
			'material-icons vertical_align_top'            => 'material-icons vertical_align_top',
			'material-icons vibration'                     => 'material-icons vibration',
			'material-icons video_call'                    => 'material-icons video_call',
			'material-icons video_label'                   => 'material-icons video_label',
			'material-icons video_library'                 => 'material-icons video_library',
			'material-icons videocam'                      => 'material-icons videocam',
			'material-icons videocam_off'                  => 'material-icons videocam_off',
			'material-icons videogame_asset'               => 'material-icons videogame_asset',
			'material-icons view_agenda'                   => 'material-icons view_agenda',
			'material-icons view_array'                    => 'material-icons view_array',
			'material-icons view_carousel'                 => 'material-icons view_carousel',
			'material-icons view_column'                   => 'material-icons view_column',
			'material-icons view_comfy'                    => 'material-icons view_comfy',
			'material-icons view_compact'                  => 'material-icons view_compact',
			'material-icons view_day'                      => 'material-icons view_day',
			'material-icons view_headline'                 => 'material-icons view_headline',
			'material-icons view_list'                     => 'material-icons view_list',
			'material-icons view_module'                   => 'material-icons view_module',
			'material-icons view_quilt'                    => 'material-icons view_quilt',
			'material-icons view_stream'                   => 'material-icons view_stream',
			'material-icons view_week'                     => 'material-icons view_week',
			'material-icons vignette'                      => 'material-icons vignette',
			'material-icons visibility'                    => 'material-icons visibility',
			'material-icons visibility_off'                => 'material-icons visibility_off',
			'material-icons voice_chat'                    => 'material-icons voice_chat',
			'material-icons voicemail'                     => 'material-icons voicemail',
			'material-icons volume_down'                   => 'material-icons volume_down',
			'material-icons volume_mute'                   => 'material-icons volume_mute',
			'material-icons volume_off'                    => 'material-icons volume_off',
			'material-icons volume_up'                     => 'material-icons volume_up',
			'material-icons vpn_key'                       => 'material-icons vpn_key',
			'material-icons vpn_lock'                      => 'material-icons vpn_lock',
			'material-icons wallpaper'                     => 'material-icons wallpaper',
			'material-icons warning'                       => 'material-icons warning',
			'material-icons watch'                         => 'material-icons watch',
			'material-icons watch_later'                   => 'material-icons watch_later',
			'material-icons wb_auto'                       => 'material-icons wb_auto',
			'material-icons wb_cloudy'                     => 'material-icons wb_cloudy',
			'material-icons wb_incandescent'               => 'material-icons wb_incandescent',
			'material-icons wb_iridescent'                 => 'material-icons wb_iridescent',
			'material-icons wb_sunny'                      => 'material-icons wb_sunny',
			'material-icons wc'                            => 'material-icons wc',
			'material-icons web'                           => 'material-icons web',
			'material-icons web_asset'                     => 'material-icons web_asset',
			'material-icons weekend'                       => 'material-icons weekend',
			'material-icons whatshot'                      => 'material-icons whatshot',
			'material-icons widgets'                       => 'material-icons widgets',
			'material-icons wifi'                          => 'material-icons wifi',
			'material-icons wifi_lock'                     => 'material-icons wifi_lock',
			'material-icons wifi_tethering'                => 'material-icons wifi_tethering',
			'material-icons work'                          => 'material-icons work',
			'material-icons wrap_text'                     => 'material-icons wrap_text',
			'material-icons youtube_searched_for'          => 'material-icons youtube_searched_for',
			'material-icons zoom_in'                       => 'material-icons zoom_in',
			'material-icons zoom_out'                      => 'material-icons zoom_out',
			'material-icons zoom_out_map'                  => 'material-icons zoom_out_map',
		);

		$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
		$icons = array_merge( $theme_icons, $icons );
		$controls_registry->get_control( 'icon' )->set_settings( 'options', $icons );

		wp_enqueue_style( 'rhye-icons', ARTS_THEME_URL . '/css/rhye-icons.min.css', array(), ARTS_THEME_VERSION );
	}
}
