<?php
if ( ! class_exists( 'epcl_search' ) ) {

	class epcl_search extends WP_Widget{

		function __construct(){
			$widget_ops = array('description' => esc_html__('Display Legacy Search box.', 'epcl_framework'));
			parent::__construct( false, esc_html__('(EP) Legacy Search box', 'epcl_framework'), $widget_ops);
		}

		function widget($args, $instance){
            // WP 5.9 Patch: always disable widget preview in the backend
            if ( defined( 'REST_REQUEST' ) && REST_REQUEST ) {
                return false;
            }
			extract($args);
			$title = apply_filters('widget_title', $instance['title']);
			echo $before_widget;
				if($title) echo $before_title.$title.$after_title;
				echo get_search_form();

			echo $after_widget;
		}

		function update($new_instance, $old_instance){
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}

		function form($instance){
			$defaults = array(
				'title' => '',
			);
			$instance = wp_parse_args((array)$instance, $defaults);
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>">
					<?php esc_html_e('Title:', 'epcl_framework'); ?>
					<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
				</label>
			</p>
			<?php
		}

	}

}

function epcl_register_search() {
	register_widget('epcl_search');
}

add_action('widgets_init', 'epcl_register_search');
