<?php
namespace ElementPack\Includes;


if (!defined('ABSPATH')) exit; // Exit if accessed directly
/**
 * Class WPML_Jet_Elements_Circle_Menu
 */
class WPML_ElementPack_Circle_Menu extends WPML_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'circle_menu';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 
			'title',
			'iconnav_link' => 'url',
		);
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {
			case 'title':
				return esc_html__( 'Menu Title', 'bdthemes-element-pack' );

			case 'iconnav_link':
				return esc_html__( 'Menu Link', 'bdthemes-element-pack' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'title':
				return 'LINE';

			case 'iconnav_link':
				return 'LINK';

			default:
				return '';
		}
	}

}
