<?php
namespace UiCore\Settings;

use UiCore\Data;

defined('ABSPATH') || exit();

/**
 * Portfolio settings.
 *
 * @return array
 */

$category = _x('Portfolio', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'portfolio';

return [
    self::add_visual_select([
        'id' => 144,
        'index' => 'portfolio_layout',
        'name' => _x('Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the portfolio page and archive layout.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            [
                'name' => _x('Grid', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'grid',
                'icon' => '/img/portfolio-grid.svg',
            ],
            [
                'name' => _x('Masonry', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'masonry',
                'icon' => '/img/portfolio-masonry.svg',
            ],
            [
                'name' => _x('Tiles', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'tiles',
                'icon' => '/img/portfolio-grid-tiles.svg',
            ],
            [
                'name' => _x('Masonry Tiles', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'masonry-tiles',
                'icon' => '/img/portfolio-masonry-tiles.svg',
            ],
            [
                'name' => _x('Justified', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'justified',
                'icon' => '/img/portfolio-justified.svg',
            ],
        ],
        'default' => 'masonry',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 145,
        'index' => 'portfolio_col',
        'name' => _x('Grid Columns', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the number of columns for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio grid columns', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 144,
        'visible' => [
            '!portfolio_layout' => 'justified'
        ],
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('2', 'Admin - Theme Options', 'uicore-framework'), 'value' => '2'],
            ['name' => _x('3', 'Admin - Theme Options', 'uicore-framework'), 'value' => '3'],
            ['name' => _x('4', 'Admin - Theme Options', 'uicore-framework'), 'value' => '4'],
        ],
        'default' => '3',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 146,
        'index' => 'portfolio_justified_size',
        'name' => _x('Item Size', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item size for justified tiles grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('grid item size', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 144,
        'visible' => [
            'portfolio_layout' => 'justified'
        ],
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Large', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'large'],
            ['name' => _x('Medium', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'medium'],
            ['name' => _x('Small', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'small'],
        ],
        'default' => 'medium',
        'size' => 's',
    ]),
    self::add_select([
        'id' => 147,
        'index' => 'portfolio_col_space',
        'name' => _x('Item Spacing', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item spacing for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('grid item spacing', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Extra Large', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'extra large'],
            ['name' => _x('Large', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'large'],
            ['name' => _x('Medium', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'medium'],
            ['name' => _x('Small', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'small'],
            ['name' => _x('Extra Small', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'extra small'],
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
        ],
        'default' => 'large',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 148,
        'index' => 'portfolio_hover_effect',
        'name' => _x('Item Hover Effect', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item hover effect for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('grid item hover effect', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Zoom', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'zoom'],
            ['name' => _x('Fade Light', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade light'],
            ['name' => _x('Fade Dark', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade dark'],
            ['name' => _x('Reveal', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'reveal'],
        ],
        'default' => 'zoom',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 149,
        'index' => 'portfolio_ratio',
        'name' => _x('Image Ratio', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item image ratio for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('grid item image ratio', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 144,
        'visible' => [
            '!portfolio_layout' => ['justified', 'tiles', 'masonry-tiles']
        ],
        'adv' => true,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Square', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'square'],
            ['name' => _x('Landscape', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'landscape'],
            ['name' => _x('Portrait', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'portrait'],
        ],
        'default' => 'square',
        'size' => 's',
    ]),
    self::add_input([
        'id' => 150,
        'index' => 'portfolio_img_radius',
        'name' => _x('Image Border Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the item image border radius for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('grid item image border radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'admin',
        'default' => '6',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 100,
        'step' => 1,
        'suffix' => "px",
        'size' => 's',
    ]),
    self::add_input([
        'id' => 151,
        'index' => 'portfolio_padding',
        'name' => _x('Vertical Padding', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set top/bottom spacing for portfolio page.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('vertical padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'admin',
        'default' => [
            'd' => '100',
            't' => '75',
            'm' => '45',
        ],
        'responsive' => true,
        'accept' => 'number',
        'min' => 0,
        'max' => 1000,
        'step' => 1,
        'suffix' => "px",
        'size' => 's',
    ]),
    self::add_input([
        'id' => 152,
        'index' => 'portfolio_posts_number',
        'name' => _x('Portfolio Items on Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the number of portfolio items displayed on a page.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('vertical padding', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'admin',
        'default' => '12',
        'responsive' => false,
        'accept' => 'number',
        'min' => 2,
        'max' => 100,
        'step' => 1,
        'suffix' => "",
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 153,
        'index' => 'portfolio_full_width',
        'name' => _x('Full Width', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Stretch portfolio grid to full page width.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio full width', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'default' => 'false',
    ]),
    self::add_select([
        'id' => 232,
        'index' => 'animations_portfolio',
        'name' => _x('Entrance Animation Type', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation style for portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation type', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'admin',
        'options' => [
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
            ['name' => _x('Fade', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade'],
            ['name' => _x('Fade Down', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade down'],
            ['name' => _x('Fade Up', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fade up'],
        ],
        'default' => 'none',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 233,
        'index' => 'animations_portfolio_duration',
        'name' => _x('Animation Duration', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation speed.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation duration', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'admin',
        'options' => [
            ['name' => _x('Slow', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'slow'],
            ['name' => _x('Normal', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'normal'],
            ['name' => _x('Fast', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'fast'],
        ],
        'default' => 'normal',
        'size' => 's',
    ]),
    self::add_input([
        'id' => 234,
        'index' => 'animations_portfolio_delay_child',
        'name' => _x('Delay Between Elements', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the animation delay between elements inside the portfolio grid.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('animation delay elements', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'admin',
        'default' => '200',
        'responsive' => false,
        'accept' => 'number',
        'min' => 0,
        'max' => 5000,
        'step' => 1,
        'suffix' => "ms",
        'size' => 's',
    ]),
    self::add_select([
        'id' => 154,
        'index' => 'portfolio_sidebar_id',
        'name' => _x('Portfolio Page Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar for portfolio page and archive.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio page sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'admin',
        'options' => [
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
            ['name' => _x('Blog Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Post'],
            ['name' => _x('Blog Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Archive'],
            ['name' => _x('Portfolio Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Post'],
            ['name' => _x('Portfolio Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Archive'],
            ['name' => _x('WooCommerce Shop', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Shop'],
            ['name' => _x('WooCommerce Product', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Product'],
        ],
        'default' => 'none',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 155,
        'index' => 'portfolio_sidebar',
        'name' => _x('Portfolio Page Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for portfolio page and archive.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio page sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 154,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'right'],
            ['name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'left'],
        ],
        'default' => 'left',
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 156,
        'index' => 'portfolio_sidebars',
        'name' => _x('Portfolio Page Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio page sidebar sticky', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 154,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'default' => 'true',
    ]),
    self::add_select([
        'id' => 157,
        'index' => 'portfolio_page',
        'name' => _x('Portfolio Page', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Select a custom portfolio page. If left blank, portfolio will be available at yoursite.com/portfolio.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio custom page', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'options' => Data::get_pages(),
        'default' => [
            'name'	=> 'default',
            'id'	=> 0
        ],
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 158,
        'index' => 'portfolios_sidebar_id',
        'name' => _x('Portfolio Post Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar for portfolio post.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio post sidebar', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('None', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'none'],
            ['name' => _x('Blog Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Post'],
            ['name' => _x('Blog Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Blog Archive'],
            ['name' => _x('Portfolio Post', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Post'],
            ['name' => _x('Portfolio Archive', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'Portfolio Archive'],
            ['name' => _x('WooCommerce Shop', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Shop'],
            ['name' => _x('WooCommerce Product', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'WooCommerce Product'],
        ],
        'default' => 'none',
        'size' => 'm',
    ]),
    self::add_select([
        'id' => 159,
        'index' => 'portfolios_sidebar',
        'name' => _x('Portfolio Post Sidebar Position', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar position for portfolio posts.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio post sidebar position', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 158,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'options' => [
            ['name' => _x('Right', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'right'],
            ['name' => _x('Left', 'Admin - Theme Options', 'uicore-framework'), 'value' => 'left'],
        ],
        'default' => 'left',
        'size' => 's',
    ]),
    self::add_toggle([
        'id' => 160,
        'index' => 'portfolios_sidebars',
        'name' => _x('Portfolio Post Sticky Sidebar', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the sidebar to sticky on page scroll.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio post sidebar sticky', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 158,
        'visible' => true,
        'adv' => false,
        'module' => 'frontend',
        'default' => 'true',
    ]),
    self::add_toggle([
        'id' => 329,
        'index' => 'portfolios_navigation',
        'name' => _x('Navigation', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Enable next / previous navigation at the end of the page.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio post navigation', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'default' => 'false',
    ]),
    self::add_toggle([
        'id' => 344,
        'index' => 'portfolios_loop_navigation',
        'name' => _x('Loop Posts', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('If this is active the navigation will not reach to an end', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('portfolio navigation loop', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 329,
        'visible' => true,
        'adv' => true,
        'module' => 'frontend',
        'default' => 'false',
    ]),
];