<?php
namespace UiCore\Settings;

use Uicore\Data;

defined('ABSPATH') || exit();

/**
 * General settings.
 *
 * @return array
 */

$category = _x('General', 'Admin - Theme Options', 'uicore-framework');
$category_slug = 'general';

return [
    self::add_select([
        'id' => 0,
        'index' => 'gen_layout',
        'adv' => true,
        'name' => _x('Layout', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the website layout.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('site layout', 'Admin - Theme Options Search', 'uicore-framework'),
        'module' => 'frontend',
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'full width',
        'options' => [
            'boxed' => _x('Boxed', 'Admin - Theme Options', 'uicore-framework'),
            'full width' => _x('Full Width', 'Admin - Theme Options', 'uicore-framework'),
        ],
        'size' => 's',
    ]),
    self::add_input([
        'id' => 1,
        'index' => 'gen_boxed_w',
        'adv' => true,
        'name' => _x('Boxed Container Width', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the boxed outer container width.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('site boxed width', 'Admin - Theme Options Search', 'uicore-framework'),
        'accept' => 'number',
        'dependecies' => 0,
        'responsive' => false,
        'suffix' => 'px',
        'size' => 'm',
        'min' => 640,
        'max' => 2980,
        'default' => 1300,
        'visible' =>
        array (
            'gen_layout' => 'boxed',
        ),
        'module' => 'frontend',
    ]),
    self::add_color([
        'id' => 2,
        'index' => 'gen_boxed_bg',
        'adv' => true,
        'name' => _x('Boxed Background Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the boxed inner container background color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('site background color boxed', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 0,
        'module' => 'frontend',
        'default' => '#f6f6f6',
        'visible' =>
        array (
            'gen_layout' => 'boxed',
        ),
    ]),
    self::add_background([
        'id' => 3,
        'index' => 'gen_bg',
        'adv' => true,
        'name' => _x('Body Background', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the <body> background.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('body background', 'Admin - Theme Options Search', 'uicore-framework'),
        'module' => 'frontend',
        'default' => [
            'type' => 'solid',
            'solid' => '#FFFFFF',
            'gradient' => [
            'angle' => '180',
            'color1' => '#F6F9FA',
            'color2' => '#FFFFFF',
            ],
            'image' => [
                'url' => '',
                'attachment' => 'fixed',
                'position' => [
                    'd' => 'center center',
                    't' => 'center center',
                    'm' => 'center center',
                ],
                'repeat' => 'no-repeat',
                'size' => [
                    'd' => 'cover',
                    't' => 'cover',
                    'm' => 'contain',
                ],
            ],
        ],
        'blur' => true,
        'dependecies' => NULL,
        'visible' => true,
    ]),
    self::add_input([
        'id' => 4,
        'index' => 'gen_full_w',
        'adv' => true,
        'name' => _x('Container Width', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the container maximum width.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('container width', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'number',
        'responsive' => false,
        'suffix' => 'px',
        'size' => 'm',
        'default' => 1170,
        'min' => 640,
        'max' => 2980,
    ]),
    self::add_toggle([
        'id' => 6,
        'index' => 'gen_btop',
        'adv' => true,
        'name' => _x('Back to Top', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Add a back to top button on bottom right corner.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('back top scroll', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 7,
        'index' => 'gen_btopm',
        'adv' => true,
        'name' => _x('Back to Top: Show on Mobile', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Show the back to top button on mobile devices.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('back top scroll mobile', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 6,
        'visible' =>
        array (
            'gen_btop' => 'true',
        ),
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 8,
        'index' => 'gen_404',
        'adv' => false,
        'name' => _x('404 Page', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Select a custom 404 page to overwrite the default one.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('404 page error', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'options' => Data::get_pages(),
        'default' => [
            'name'	=> 'default',
            'id'	=> 0
        ],
        'size' => 'm',
    ]),
    self::add_toggle([
        'id' => 9,
        'index' => 'gen_maintenance',
        'adv' => false,
        'name' => _x('Maintenance Mode', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Enable maintenance mode sitewide.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('maintenance mode', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 10,
        'index' => 'gen_maintenance_page',
        'adv' => false,
        'name' => _x('Maintenance Page', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Select a custom maintenance page.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('maintenance mode page', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 9,
        'visible' =>
        array (
            'gen_maintenance' => 'true',
        ),
        'module' => 'frontend',
        'size' => 'm',
        'options' => Data::get_pages(),
        'default' => [
            'name'	=> 'default',
            'id'	=> 0
        ],
    ]),
    self::add_toggle([
        'id' => 11,
        'index' => 'gen_themecolor',
        'adv' => true,
        'name' => _x('Browser Theme Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the browser toolbar color. Available on Chrome 39+ for Android.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('browser theme color toolbar', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_color([
        'id' => 12,
        'index' => 'gen_themecolor_color',
        'adv' => true,
        'name' => _x('Browser Theme Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the toolbar color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('browser theme color toolbar', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 11,
        'visible' =>
        array (
            'gen_themecolor' => 'true',
        ),
        'default' => '',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 13,
        'index' => 'gen_siteborder',
        'adv' => true,
        'name' => _x('Site Border (Passepartout)', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set a colored border around the website.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('site border', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_color([
        'id' => 14,
        'index' => 'gen_siteborder_color',
        'adv' => true,
        'name' => _x('Site Border Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the site border color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('site border color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 13,
        'visible' =>
        array (
            'gen_siteborder' => 'true',
        ),
        'default' => 'Primary',
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 15,
        'index' => 'gen_siteborder_w',
        'adv' => true,
        'name' => _x('Site Border Width', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the site border width.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('site border width', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 13,
        'visible' =>
        array (
            'gen_siteborder' => 'true',
        ),
        'default' => 30,
        'accept' => 'number',
        'suffix' => 'px',
        'min' => 0,
        'max' => 999,
        'size' => 'm',
        'responsive' => false,
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 320,
        'index' => 'gen_noise',
        'adv' => true,
        'name' => _x('Grain Overlay Effect', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a noise texture over your website.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('noise texture grain', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 321,
        'index' => 'gen_cursor',
        'adv' => true,
        'name' => _x('Custom Cursor', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Add a custom cursor to your website.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('custom cursor', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 322,
        'index' => 'gen_cursor_default',
        'adv' => true,
        'name' => _x('Keep Default Cursor', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Keeps the default system cursor behind the custom one.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('custom cursor', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'true',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 323,
        'index' => 'gen_cursor_style',
        'adv' => true,
        'name' => _x('Cursor Style', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the cursor style and effect.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('custom cursor style', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'module' => 'frontend',
        'size' => 'm',
        'default' => 'border',
        'options' => [
            [
                'name' => _x('Border', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'border',
            ],
            [
                'name' => _x('Border Dual', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'border dual',
            ],
            [
                'name' => _x('Solid', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'solid',
            ],
            [
                'name' => _x('Solid Small', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'solid small',
            ],
            [
                'name' => _x('Solid Small Alt', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'solid small alt',
            ],
        ],
    ]),
    self::add_select([
        'id' => 324,
        'index' => 'gen_cursor_hover',
        'adv' => true,
        'name' => _x('Cursor Hover Effect', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the cursor animation on link elements.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('custom cursor hover effect', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'options' => [
            [
                'name' => _x('Scale', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'scale',
            ],
            [
                'name' => _x('Difference', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'difference',
            ],
        ],
        'default' => 'scale',
        'module' => 'frontend',
        'size' => 'm',
    ]),
    self::add_color([
        'id' => 325,
        'index' => 'gen_cursor_color',
        'adv' => true,
        'name' => _x('Cursor Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the cursor color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('custom cursor color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'Accent',
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 331,
        'index' => 'gen_line',
        'adv' => true,
        'name' => _x('Grid Lines', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Add grid lines to your website background.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid lines', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => true,
        'default' => 'false',
        'module' => 'frontend',
    ]),
    self::add_select([
        'id' => 332,
        'index' => 'gen_line_width',
        'adv' => true,
        'name' => _x('Grid Width', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the grid width.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid lines width', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'default' => 'contained',
        'options' => [
            [
                'name' => _x('Contained', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'contained',
            ],
            [
                'name' => _x('Full Width', 'Admin - Theme Options', 'uicore-framework'),
                'value' => 'full width',
            ],
        ],
        'module' => 'frontend',
        'size' => 'm',
    ]),
    self::add_input([
        'id' => 333,
        'index' => 'gen_line_offset',
        'adv' => true,
        'name' => _x('Grid Width Offset', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Add x pixels to the grid width. Also supports negative values.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid line width offset', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'number',
        'responsive' => false,
        'suffix' => 'px',
        'size' => 'm',
        'min' => 1,
        'max' => 999,
        'default' => 12,
    ]),
    self::add_input([
        'id' => 334,
        'index' => 'gen_line_col',
        'adv' => true,
        'name' => _x('Grid Columns', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set number of columns for the grid.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid line column', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'number',
        'responsive' => true,
        'suffix' => '',
        'size' => 's',
        'min' => 1,
        'max' => 12,
        'default' => [
            'd' => 6,
            't' => 4,
            'm' => 3,
        ],
    ]),
    self::add_color([
        'id' => 335,
        'adv' => true,
        'index' => 'gen_line_color',
        'name' => _x('Line Color', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the grid line color.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid line color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'default' => '#eeeeee',
        'module' => 'frontend',
    ]),
    self::add_input([
        'id' => 336,
        'index' => 'gen_line_w',
        'adv' => true,
        'name' => _x('Line Weight', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the grid line weight.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid line weight', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'number',
        'responsive' => false,
        'suffix' => 'px',
        'size' => 'm',
        'min' => 1,
        'max' => 999,
        'default' => 1,

    ]),
    self::add_input([
        'id' => 337,
        'index' => 'gen_line_z',
        'adv' => true,
        'name' => _x('Z-Index', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'desc' => _x('Set the grid lines z-index. Default is 0.', 'Admin - Theme Options', 'uicore-framework'),
        'tags' => _x('grid line z-index', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => 331,
        'visible' => true,
        'module' => 'frontend',
        'accept' => 'number',
        'responsive' => false,
        'suffix' => '',
        'size' => 's',
        'min' => -999,
        'max' => 999,
        'default' => 0,
    ]),
    self::add_input([
        'id' => 370,
        'adv' => true,
        'type' => 'input',
        'index' => 'gen_btop_radius',
        'default' => '4',
        'suffix' => 'px',
        'size' => 'm',
        'min' => '0',
        'max' => '200',
        'accept' => 'number',
        'name' => _x('Back to Top Radius', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the back to top border radius.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('border back to top radius', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'responsive' => false,
        'visible' => [
            'gen_btop' => 'true',
        ],
        'module' => 'frontend',
    ]),
    self::add_background([
        'id' => 371,
        'adv' => true,
        'type' => 'bg',
        'index' => 'gen_btop_bg',
        'blur' => true,
        'index_type' => 'admin',
        'default' => [
            'blur' => 'false',
            'type' => 'White',
            'solid' => '#ffffff',
            'gradient' => [
            'angle' => '90',
            'color1' => '#19187C',
            'color2' => '#532df5',
            ],
            'image' => [
            'url' => '',
            'attachment' => 'fixed',
            'position' => [
                'd' => 'bottom center',
                't' => 'center center',
                'm' => 'center center',
            ],
            'repeat' => 'no-repeat',
            'size' => [
                'd' => 'cover',
                't' => 'cover',
                'm' => 'contain',
            ],
            ],
        ],
        'blur' => false,
        'name' => _x('Back to Top Background', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the back to top background.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('back to top background', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => [
            'gen_btop' => 'true',
        ],
        'module' => 'frontend',
    ]),
    self::add_color2([
        'id' => 372,
        'adv' => true,
        'type' => 'color2',
        'index' => 'gen_btop_color',
        'index_type' => 'admin',
        'default' => [
            'm' => 'Primary',
            'h' => 'Secondary',
        ],
        'name' => _x('Back to Top Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the back to top color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('back to top color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => [
            'gen_btop' => 'true',
        ],
        'module' => 'frontend',
    ]),
    self::add_toggle([
        'id' => 377,
        'adv' => true,
        'type' => 'toggle',
        'index' => 'gen_line_animation',
        'index_type' => 'admin',
        'default' => 'false',
        'name' => _x('Side Lines Animation', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Show / Hide the line animation.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('side grid line animation', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => [
            'gen_line' => 'true',
        ],
        'module' => 'frontend',
    ]),
    self::add_color([
        'id' => 378,
        'adv' => true,
        'type' => 'color',
        'index' => 'gen_line_animation_color',
        'index_type' => 'admin',
        'default' => 'Primary',
        'name' => _x('Side Lines Animation Color', 'Admin - Theme Options', 'uicore-framework'),
        'desc' => _x('Set the line animation color.', 'Admin - Theme Options', 'uicore-framework'),
        'category' => $category,
        'category_slug' => $category_slug,
        'tags' => _x('side grid line animation color', 'Admin - Theme Options Search', 'uicore-framework'),
        'dependecies' => NULL,
        'visible' => [
            'gen_line_animation' => 'true',
            'gen_line' => 'true',
        ],
        'module' => 'frontend',
    ]),
];