<?php
/**
 * Theme functions file
 *
 * Contains all of the Theme's setup functions, custom functions,
 * custom hooks and Theme settings.
 *
 * @package pustaka-child
 * @license license.txt
 * @since   1.0
 *
 */

add_action( 'after_setup_theme', 'pustaka_load_childtheme_languages', 5 );
function pustaka_load_childtheme_languages() {
	/* this theme supports localization */
	load_child_theme_textdomain( 'pustaka', get_stylesheet_directory_uri() . '/languages' );

}

/* Adds the child theme setup function to the 'after_setup_theme' hook. */
add_action( 'after_setup_theme', 'pustaka_child_theme_setup', 11 );

/**
 * Setup function. All child themes should run their setup within this function. The idea is to add/remove
 * filters and actions after the parent theme has been set up. This function provides you that opportunity.
 *
 * @since 1.0
 */
function pustaka_child_theme_setup() {



}
