(function($){
	'use strict'

	var paradizeIcons = ["bed-room","hour","by2-hour","by4-hour","bed-room2","star-bed","by4-hour2","star-hotel-1","star-hotel-2","by7","add-bag","add-basket","add-cart","add-cart2","add-location","air-conditioner","alarm-clock-1","alarm-clock-2","alarm-clock-3","alarm-sound","ambulance-1","anonymous-1","anonymous-2","apple","army-solider","astronaut","auto-gearbox","bag-1","bag-2","balance-1","balance-2","bald-male","balloons","banana","barbeque","barcode-scanner","barcode","baseball-cap","basket-1","basket-2","bat-man","bath-robe","battery","beanie-hat","beard-man","beer-mug","bellboy","bellhop","belt","big-shopping","bike-1","bike-2","bike-3","bikini","bitcoin-2","bitcoin-3","bitcoin-bag","bitcoin-cart","black-friday","boiled-egg","boot","botcoin-1","bow-tie","bowler-hat","bra","bread","bus-1","bus-2","bus-3","business-man","business-woman","cab","cabine-lift","caffe-bean","caffe-mug","calendar-clock","calendar","captain-america","car-1","car-2","car-3","car-service","car-wash","card-payment","cargo-ship","carnaval","carrot","cart-1","cart-2","cart-done","cart","cash-payment","celsius","chaplin","check-out","checkout-bitcoin-1","checkout-bitcoin-2","checkout-dollar-1","checkout-dollar-2","checkout-euro-1","checkout-euro-2","checkout-pound-1","checout-pound-2","cheese","chef","cherry","chess","chicken-leg","chilly","chip","circus","clear-bag","clear-basket","clear-cart","clear-cart2","clear-location","clock-1","clock-2","close-2","closr-1","cloud","cloudy-day","cloudy-fog","cloudy-night","cloudy","clown","clubs-ace-card","coat-rank","coat","coce-with-glass","coctail-glass-1","coctail-glass-2","coffe-to-go","coffe","coin-and-cash","coins-1","coins-2","coins-3","compas-rose","compass-1","compass-2","converse","convert-bitcoin","convert-curency","corn","crain-truck","credit-card-1","credit-card-2","credit-card-3","credit-card","criminal","croissant","cuppon","cylinder-hat","darth-vader","diamond-ace-card","dice","digital-alarm-clock","directions","discount-bitcoin","discount-coupon","discount-dollar","discount-euro","discount-pound","dismiss-bag","dismiss-cart","dispacher-1","dispacher-2","distance-1","distance-2","do-not-disturbe","dodgem","dollar-1","dollar-2","dollar-3","dollar-bag","dollar-cart","dollar-fall","dollar-rise","domino","donate","done-bag","done-basket","done-cat","done-location","donut","door-hanger","dress-1","dress-2","egg-holder","einstein","elevator","elvis","energy-drink","espresso","euro-1","euro-2","euro-3","euro-bag","euro-cart","euro-fall","euro-rise","exit-sign","expensive","fahrenheit","favorit-location","favorite-bag","favorite-cart","favorite-store","female-1","female-2","female-user","financial-care-1","financial-care-2","fire-fighjter","fireworks-1","fireworks-2","fog-day","fog-night","fog","fork-n-knife","formal-coat","formal-pants","free-tag-1","free-tag-2","french-fries","fried-egg","full-cart","full-cart2","full-moon","game-console","gear-box","geek-1","geek-2","gift-box","gift-box2","gift-card","gift-card2","glases-1","glases-2","global-position","globe","gps-fixed","gps-not-fixed","gps-off","grill","hailstorm-day","hailstorm-night","hailstorm","hairdryer","ham","hamburger","hanger","harry-potter","hat","heart-ace-card","heater","heels","helicopter","home-bag","home-location","hoodie","hot-dog-1","hot-offer","hotdog-2","hotel-bell","hotel-sign-1","hotel","icecream","info-point","iron-man","jack-sparrow","jacket","jason","jeans","jeep","jetplnade","juice","keep-out","kite","ladys-t-shirt","ladys-underwear","landing-plane","light-1","light-2","lightning-day","lightning-night","lightning","local-airport","local-bank","local-gas-station","local-hospital","local-library","local-monument","local-parking","local-port","local-pub","local-restaurant","local-transport","location-1","location-3","location-4","location-a","location-b","locatoin-2","locked-parking","locl-shop","loyalty-card","magic-hat","maid","male-1","male-2","mans-shoe","mans-uderweare","map-1","map-2","map-3","map-pin-1","map-pin-2","map-pin-3","map-pin-4","map-pin-5","map-pin-6","map-screen","marry-go-round","martini-glass","master-yoda","medic","metro","milk","mini-bar","mini-bus","mini-truck-2","mini-truck","mini-van","minion-1","minion-2","mirror","mobile-map","mobile-shopping-1","mobile-shopping-2","money-bag","moon-2","moon-3","motorcycle","navigation-1","navigation-2","negative-temperature","new-tag-1","new-tag-2","new-tag-3","new-tag-5","new-tga-4","no-television","nurse","old-clock","old-man","on-sale-2","on-sale","online-shopping-1","online-store","open-1","open-2","open-box","paprika","party-hat","party-ribbon","pear","pet-bottle","pickup","pie","pizza-slice","pizza","plane-1","plane-2","plane-3","plane-4","plane-front","play-stor","police-car","police","pool","pound-1","pound-2","pound-3","pound-bag","pound-cart","pound-fall","pound-rise","pozitive-temperature","predator","prisoner","punk","qr-code","rain-day","rain-night","rain-storm","raining","reception","registry-1","registry-2","registry-3","registry-list","remouve-bag","remouve-basket","remouve-cart","remouve-cart2","remouve-location","restaurant","roadster","roasted-chicken","roller-coaster","room-key","room-service-2","room-service","sale-1","sale-2","sale-tag-1","salt-n-pepper","sand-clock","sandwich","santa-claus","school-bus","scooter-2","scooter","scream","search-bag","search-cart","search-money","seatbelt","secure-shopping-1","secure-shopping-2","secure-shopping-3","sedan","send-money","shake","ship-1","ship-2","shipping-box","shipping-scedule","shipping","shirt-1","shirt-2","shopping-bag","shopping-list","shorts","shower-1","shower-2","siutecase","skeleton","skirt","slippers","slot-7","slot-machine","snooze","snow-day","snow-night","snow-rain-day","snow-rain-night","snow-rain","snow","snowing","soda-can","solider","soop","sound-off","spa-towel","spade-ace-card","speed-meter","sport-car-1","sport-shoe","spy","star-night","steak","steve-jobs","stock-of-money","stop-watch-1","stop-watch-2","store","storm-day","storm-night","stormtrooper","street-view","student","sun-glases","sun","sushi","swiming-short","swimwear","t-shirt-2","t-shirt","take-off-plane","taxi","tea-mug","telephone","television","temperatur-night","temperature-day","termometer","theatre-scene","theatre","thunder-storm-day","thunder-storm-night","thunderstorm","tic-tac-toe","ticket","tie","timer-egg","toast","toilet","tomato","tornado","towel","trafic-light-1","trafic-light-2","train-1","train-2","train-3","tram","troleybus","truck-1","truck-2","truck","tub","update-time","user","vest","vulverine","vw-bug","vw-t1","wach-4","waiter","waitress","wallet-1","wallet-2","wallet-3","watch-1","watch-2","watch-3","web-shop-1","web-shop-2","web-shop-3","wheel-swing","wind","windshield-cleaner","wine-bottle","wine-glass","winter-temperature","worker","yagermeister"];

	var iconTotal = paradizeIcons.length;
	var iconPrefix = 'koo-icon-';

	function initIconPickerUI(){
		$(".tokoo-iconpicker-shortcode").after('<div class="tokoo-iconpicker"><input class="tokoo-iconpicker__search" placeholder="Search icon"/><ul class="tokoo-iconpicker__list"></ul><div class="tokoo-iconpicker__setting"><div><label>Color</label><input type="text" name="icon-color" class="color-picker" placeholder="#333333" /></div><div><label>Size</label><input type="text" name="icon-size" placeholder="14px"/></div><button class="insert-icon button button-primary">Insert Icon</button></div></div>');
	}


	function getSuggestedIcons(query){
		return $.grep( paradizeIcons, function( icon ){
			return icon.indexOf(query) !== -1;
		});
	};

	function generateIconList( icons ){
		var iconListItem = [];
		for( var i=0; i < icons.length; i++){
			iconListItem[i] = '<li><input type="radio" name="koo-icon" value="'+iconPrefix+icons[i]+'" id="koo-icon-'+i+'"/><label for="koo-icon-'+i+'"><i class="'+iconPrefix+icons[i]+'"></i></label></li>';
		}
		return iconListItem;
	}

	function icon_shortcode( icon, color, size ) {
        return '[koo_icon name="' + icon + '" color="' + color + '" size="' + size + '"]';
    }

	$(document).ready( function() {
		initIconPickerUI();

		var tokooIconPickerTrigger = $(".tokoo-iconpicker-shortcode");
		var tokooIconPicker        = $(".tokoo-iconpicker");
		var tokooIconPickerSearch  = tokooIconPicker.find(".tokoo-iconpicker__search");
		var tokooIconPickerList    = tokooIconPicker.find(".tokoo-iconpicker__list");

		tokooIconPickerTrigger.on( "click", function(){
			tokooIconPicker.toggle();
			$('input[name=icon-color]').val('');
			$('input[name=icon-size]').val('');
			tokooIconPickerSearch.val('').focus();
		});

		// Populate all icons
		tokooIconPickerList.html("").html( generateIconList( paradizeIcons ));

		tokooIconPickerSearch.on('keyup', function(e){
			var suggestedIcon = getSuggestedIcons( $(this).val() );
			tokooIconPickerList.html("").html(generateIconList( suggestedIcon ));
			
		});

		tokooIconPicker.on('click', '.insert-icon', function( e ) {
			var icon = $('input[name=koo-icon]:checked').val();
			var color = $('input[name=icon-color]').val();
			var size = $('input[name=icon-size]').val();
    		wp.media.editor.insert( icon_shortcode( icon, color, size ) );
    		tokooIconPickerSearch.val('');
    		tokooIconPicker.hide();
			tokooIconPickerList.html("").html( generateIconList( paradizeIcons ));
    		e.preventDefault();
    	});

	} );

}(jQuery));