<?php
/**
 * Returns content for default demo
 *
 * ->Taxonomies
 * ->Posts
 * ->Options
 * ->Widgets
 * ->Menus
 * ->Media
 *
 *
 * @return array
 */
function publisher_demo_raw_content() {

	$style_id       = 'wonderful';
	$prefix         = $style_id . '-'; // prevent caching when user installs multiple demos continuously
	$demo_path      = PUBLISHER_THEME_PATH . 'includes/demos/' . $style_id . '/';
	$demo_image_url = publisher_get_demo_images_url( $style_id );

	return array(
		   
      //
      // ->Taxonomies
      //
      'taxonomy' => 
         array(
           'multi_steps' => false,
           array(
                 array(
                     'name' => 'Fashion',
                     'taxonomy' => 'category',
                     'the_id' => 'taxonomy.primary.6',
                 ),
                 array(
                     'name' => 'Food',
                     'taxonomy' => 'category',
                     'the_id' => 'taxonomy.primary.3',
                 ),
                 array(
                     'name' => 'Lifestyle',
                     'taxonomy' => 'category',
                     'the_id' => 'taxonomy.primary.2',
                 ),
                 array(
                     'name' => 'Photography',
                     'taxonomy' => 'category',
                     'the_id' => 'taxonomy.primary.5',
                 ),
                 array(
                     'name' => 'Travel',
                     'taxonomy' => 'category',
                     'the_id' => 'taxonomy.primary.4',
                 ),
             ),
         ),
      //
      // ->Posts
      //
      'posts' => 
         array(
           'multi_steps' => false,
           array(
                 array(
                     'post_type' => 'page',
                     'post_title' => 'Contact',
                     'post_content_file' => $demo_path . 'post-content.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'page_layout',
                             'meta_value' => '1-col',
                         ),
                     ),
                     'the_id' => 'posts.primary.199',
                 ),
                 array(
                     'post_type' => 'page',
                     'post_title' => 'Front Page',
                     'post_content_file' => $demo_path . 'post-content-1.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'prepare_vc_css' => true,
                     'post_meta' => array(
                         array(
                             'meta_key' => 'page_layout',
                             'meta_value' => '1-col',
                         ),
                     ),
                     'the_id' => 'posts.primary.5',
                 ),
                 array(
                     'post_title' => 'Travel Guide to Tel Aviv, Israel what is there to see and do',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.96',
                 ),
                 array(
                     'post_title' => 'Restaurant Review: The Bottomless Brunch at Eneko London',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.102',
                 ),
                 array(
                     'post_title' => 'Celebrate National Dog Day at these dog-friendly hotels in the UK',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.104',
                 ),
                 array(
                     'post_title' => 'Ski resort prices slide downhill in top European resorts',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.94',
                 ),
                 array(
                     'post_title' => 'Where to go hiking in the Brecon Beacons National Park, Wales',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.92',
                 ),
                 array(
                     'post_title' => 'Where to take the best photos in Setouchi Region, Japan and  Spread',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.84',
                 ),
                 array(
                     'post_title' => 'Camino de Santiago: Finisterre Way (Camino de Fisterra)',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.86',
                 ),
                 array(
                     'post_title' => 'Follow Agatha Christie’s footsteps along the Devon coastline',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.90',
                 ),
                 array(
                     'post_title' => 'Lewis Hamilton tops Abu Dhabi GP second practice',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.108',
                 ),
                 array(
                     'post_title' => 'Australia v England - first Test scorecard',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.113',
                 ),
                 array(
                     'post_title' => 'Gorgeous Gloves That You’ll Want to Wear All Winter Long',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.143',
                 ),
                 array(
                     'post_title' => 'Cobra unveils F8 drivers, woods and one-length irons',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.131',
                 ),
                 array(
                     'post_title' => '2018 NBA Mock Draft: First-Round Projections',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.133',
                 ),
                 array(
                     'post_title' => 'Day and Spieth go in opposite directions at Australian Open',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.127',
                 ),
                 array(
                     'post_title' => 'Does Jerry Jones Have the Juice to Unseat Roger Goodell?',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.123',
                 ),
                 array(
                     'post_title' => 'Q&A: What to do on a long stopover in Reykjavik?',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.82',
                 ),
                 array(
                     'post_title' => 'Fantasy Football Week 12 Streaming Options',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.121',
                 ),
                 array(
                     'post_title' => 'NBA Draft Dispatch: The Five-Man Race for No. 1',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.135',
                 ),
                 array(
                     'post_title' => 'Is BA’s boarding system based on the price of the fare really elitist?',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.78',
                 ),
                 array(
                     'post_title' => 'Anchovies Make Everything Taste Better',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.41',
                 ),
                 array(
                     'post_title' => 'Kickstarter has a Daddy Bag for men who are too cool for diaper bags',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.43',
                 ),
                 array(
                     'post_title' => 'Target has a 5-star robot vacuum and mop combo for under $200 and it\'s kind of a big deal',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.47',
                 ),
                 array(
                     'post_title' => 'Our Best Thanksgiving Turkey Recipes',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.39',
                 ),
                 array(
                     'post_title' => 'How To Spread The Monochrome Magic',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.37',
                 ),
                 array(
                     'post_title' => 'Take Your Office Looks to Party Effortlessly',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.21',
                 ),
                 array(
                     'post_title' => 'How To Stay Fit Without Hitting The Gym',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.23',
                 ),
                 array(
                     'post_title' => 'What The Stars Wore At The MTV Video Music Awards',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.31',
                 ),
                 array(
                     'post_title' => 'Our Best and Brightest Cherry Recipes',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.49',
                 ),
                 array(
                     'post_title' => 'Recipes for Nowruz, the Persian New Year',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.51',
                 ),
                 array(
                     'post_title' => 'Icy-Cold Desserts From Mark Bittman and More',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.66',
                 ),
                 array(
                     'post_title' => 'The 20 Most Popular Nigella Lawson Recipes on Cooking',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.72',
                 ),
                 array(
                     'post_title' => 'The Only Black Friday Sales That Fashion Girls Will Actually Shop',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.145',
                 ),
                 array(
                     'post_title' => 'Not Really Seasonal, But We Can\'t Stop Eating Them Anyway',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.64',
                 ),
                 array(
                     'post_title' => 'Kim Severson\'s Most Popular Recipes',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.59',
                 ),
                 array(
                     'post_title' => '17 Vegetarian Main Dishes You Should Make This Summer',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.55',
                 ),
                 array(
                     'post_title' => 'Our Most Popular Desserts of 2017',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.57',
                 ),
                 array(
                     'post_title' => 'Where to experience the Dutch Golden Age in Amsterdam',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.80',
                 ),
                 array(
                     'post_title' => 'These Meghan Markle-Approved Jeans Are on Sale at Nordstrom',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.149',
                 ),
                 array(
                     'post_title' => 'So Many Delicious Ways to Do Brussels Sprouts',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.45',
                 ),
                 array(
                     'post_title' => '32 Bright and Beautiful Summer Pastas and Perfect Food',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.53',
                 ),
                 array(
                     'post_title' => 'The 8 Best Subscription Boxes for Guys  Spread Magic Cocktail Tea',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.167',
                 ),
                 array(
                     'post_title' => 'Ditch Your Denims This Summer for These Comfy Pants Summer You’ll Use',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.11',
                 ),
                 array(
                     'post_title' => 'The Dapper Dude\'s Guide To Dressing To Impress',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.13',
                 ),
                 array(
                     'post_title' => 'Be Holiday Ready With These 9 Versatile Pieces for Curves',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.147',
                 ),
                 array(
                     'post_title' => 'Lancaster Insurance Classic Motor Show 2017: what we saw at the NEC on the weekend',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.17',
                 ),
                 array(
                     'post_title' => '13 Cozy Sweaters to Complement Your Curves Spread Magic',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.165',
                 ),
                 array(
                     'post_title' => '5 Kinds of Formal Shirts a Man Needs To Work His Swag at Office',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.15',
                 ),
                 array(
                     'post_title' => 'These Stretchy Jeans are a Celeb Go-To for Traveling',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.169',
                 ),
                 array(
                     'post_title' => 'Fitzpatrick falls off pace in Hong Kong',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.111',
                 ),
                 array(
                     'post_title' => 'Ways To Denimize Your Kid’s Closet This Season',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.27',
                 ),
                 array(
                     'post_title' => 'How to navigate the weird and wonderful world',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.88',
                 ),
                 array(
                     'post_title' => 'V&A Acquires WeChat as the First Social Media Platform',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.171',
                 ),
                 array(
                     'post_title' => 'Would you pass the new driving test? Try these new questions being introduced on December',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.19',
                 ),
                 array(
                     'post_title' => 'BlindSpot Speakeasy Cocktail Tea reviewed',
                     'post_format' => 'video',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.106',
                 ),
                 array(
                     'post_title' => 'Navy Is The New Black When It Comes To Footwear',
                     'post_format' => 'video',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.174',
                 ),
                 array(
                     'post_title' => '7 Shearling Coats So You Feel Nice and Toasty This Winter',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.161',
                 ),
                 array(
                     'post_title' => 'Bring The Retro Back With Fun Backpacks',
                     'post_format' => 'video',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.35',
                 ),
                 array(
                     'post_title' => 'These Topshop Items Are Guaranteed to Sell Out This Week',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.159',
                 ),
                 array(
                     'post_title' => 'What Aurélie Bidermann Packs in Her Suitcase for Thanksgiving',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.155',
                 ),
                 array(
                     'post_title' => 'The Winter Coats Petites Always Look Amazing In',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.151',
                 ),
                 array(
                     'post_title' => '6 Little White Dresses to Wear All Winter Long',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.153',
                 ),
                 array(
                     'post_title' => 'Our Most Popular Weeknight Recipes of 2017',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.61',
                 ),
                 array(
                     'post_title' => '15 Luxury Hotel-Quality Bathrobes You Can Buy Online Monochrome',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.6%%',
                     ),
                     'the_id' => 'posts.primary.163',
                 ),
                 array(
                     'post_title' => 'Time For Guys To Go The Indigo Way Speakeasy Cocktail Tea',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.25',
                 ),
                 array(
                     'post_title' => '20 Versatile Summer Recipes You\'ll Use',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.3%%',
                     ),
                     'the_id' => 'posts.primary.74',
                 ),
                 array(
                     'post_title' => 'How To Spread The Monochrome Magic',
                     'post_format' => 'video',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.33',
                 ),
                 array(
                     'post_title' => 'Trends To Look Forward To In Autumn-Winter 2017',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.29',
                 ),
                 array(
                     'post_title' => 'A Deep Dive Inside the Creation of the LeBron 15',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.5%%',
                     ),
                     'the_id' => 'posts.primary.139',
                 ),
                 array(
                     'post_title' => 'Our 10 Most Popular Thanksgiving Stuffing and Dressing Recipes',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.2%%',
                     ),
                     'the_id' => 'posts.primary.68',
                 ),
                 array(
                     'post_title' => 'Has your Ryanair flight been cancelled? A guide to your rights',
                     'post_content_file' => $demo_path . 'post-content-2.txt',
                     'post_excerpt_file' => $demo_path . 'post-excerpt.txt',
                     'thumbnail_id' => '%%media.primary.thumb-1%%',
                     'post_terms' => array(
                         'category' => '%%taxonomy.primary.4%%',
                     ),
                     'the_id' => 'posts.primary.100',
                 ),
                 array(
                     'post_type' => 'better-banner',
                     'post_title' => '336x280',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'type',
                             'meta_value' => 'image',
                         ),
                         array(
                             'meta_key' => 'img',
                             'meta_value' => '%%bf_product_demo_media_url:{media.primary.ad-336x280-sidebar}:\'full\'%%',
                         ),
                         array(
                             'meta_key' => 'url',
                             'meta_value' => '#',
                         ),
                         array(
                             'meta_key' => 'caption',
                             'meta_value' => '- Advertisement -',
                         ),
                         array(
                             'meta_key' => 'campaign',
                             'meta_value' => '%%posts.primary.none%%',
                         ),
                     ),
                     'the_id' => 'posts.primary.405',
                 ),
                 array(
                     'post_type' => 'better-banner',
                     'post_title' => '970 x 250',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'type',
                             'meta_value' => 'image',
                         ),
                         array(
                             'meta_key' => 'img',
                             'meta_value' => '%%bf_product_demo_media_url:{media.primary.ad-970x250-index}:\'full\'%%',
                         ),
                         array(
                             'meta_key' => 'url',
                             'meta_value' => '#',
                         ),
                         array(
                             'meta_key' => 'caption',
                             'meta_value' => '- Advertisement -',
                         ),
                         array(
                             'meta_key' => 'campaign',
                             'meta_value' => '%%posts.primary.none%%',
                         ),
                     ),
                     'the_id' => 'posts.primary.408',
                 ),
                 array(
                     'post_type' => 'better-banner',
                     'post_title' => 'baner header',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'type',
                             'meta_value' => 'image',
                         ),
                         array(
                             'meta_key' => 'img',
                             'meta_value' => '%%bf_product_demo_media_url:{media.primary.ad-728x90}:\'full\'%%',
                         ),
                         array(
                             'meta_key' => 'url',
                             'meta_value' => '#',
                         ),
                         array(
                             'meta_key' => 'campaign',
                             'meta_value' => '%%posts.primary.none%%',
                         ),
                     ),
                     'the_id' => 'posts.primary.181',
                 ),
                 array(
                     'post_type' => 'better-banner',
                     'post_title' => '300 x 250',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'type',
                             'meta_value' => 'image',
                         ),
                         array(
                             'meta_key' => 'img',
                             'meta_value' => '%%bf_product_demo_media_url:{media.primary.ad-300x250-post}:\'full\'%%',
                         ),
                         array(
                             'meta_key' => 'url',
                             'meta_value' => '#',
                         ),
                         array(
                             'meta_key' => 'caption',
                             'meta_value' => '- Advertisement -',
                         ),
                         array(
                             'meta_key' => 'campaign',
                             'meta_value' => '%%posts.primary.none%%',
                         ),
                     ),
                     'the_id' => 'posts.primary.182',
                 ),
                 array(
                     'post_type' => 'better-banner',
                     'post_title' => '728 x 90',
                     'post_meta' => array(
                         array(
                             'meta_key' => 'type',
                             'meta_value' => 'image',
                         ),
                         array(
                             'meta_key' => 'img',
                             'meta_value' => '%%bf_product_demo_media_url:{media.primary.ad-728x90-header}:\'full\'%%',
                         ),
                         array(
                             'meta_key' => 'url',
                             'meta_value' => '#',
                         ),
                         array(
                             'meta_key' => 'caption',
                             'meta_value' => '- Advertisement -',
                         ),
                         array(
                             'meta_key' => 'campaign',
                             'meta_value' => '%%posts.primary.none%%',
                         ),
                     ),
                     'the_id' => 'posts.primary.183',
                 ),
             ),
         ),
      //
      // ->Options
      //
      'options' => 
         array(
           'multi_steps' => false,
           array(
                 array(
                     'type' => 'option',
                     'option_name' => 'bs_' . 'publisher_theme_options',
                     'option_value_file' => $demo_path . 'options.json',
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'bs_' . 'publisher_theme_options',
                     'option_value' => array(
                         'logo_image' => '%%bf_product_demo_media_url:{media.primary.logo-main}:\'full\'%%',
                         'logo_image_retina' => '',
                     ),
                     'merge_options' => true,
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'bs_' . 'publisher_theme_options_current_style',
                     'option_value' => $style_id,
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'bs_' . 'publisher_theme_options_current_demo',
                     'option_value' => $style_id,
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'page_on_front',
                     'option_value' => '%%posts.primary.5%%',
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'show_on_front',
                     'option_value' => 'page',
                 ),
                 array(
                     'type' => 'option',
                     'option_name' => 'better_ads_manager',
                     'option_value' => array(
                         'ad_post_top_type' => 'banner',
                         'ad_post_top_banner' => '%%posts.primary.182%%',
                         'ad_post_top_align' => 'left',
                         'header_aside_logo_type' => 'banner',
                         'header_aside_logo_banner' => '%%posts.primary.183%%',
                     ),
                     'merge_options' => true,
                 ),
             ),
         ),
      //
      // ->Widgets
      //
      'widgets' => 
         array(
           'multi_steps' => false,
           array(
                 'primary-sidebar' => array(
                     'remove_all_widgets' => true,
                     array(
                         'widget_id' => 'bs-thumbnail-listing-1',
                         'widget_settings' => array(
                             'title' => 'Popular Posts',
                             'count' => '5',
                             'order_by' => 'comment_count',
                             'columns' => 1,
                             'pagination-show-label' => '1',
                             'listing-settings' => array(
                                 'title-limit' => '60',
                                 'subtitle' => '0',
                                 'subtitle-limit' => '0',
                                 'subtitle-location' => 'before-meta',
                                 'meta' => array(
                                     'show' => '1',
                                     'author' => '0',
                                     'date' => '1',
                                     'date-format' => 'standard',
                                     'view' => '0',
                                     'share' => '0',
                                     'comment' => '0',
                                     'review' => '1',
                                 ),
                             ),
                             'disable_duplicate' => '0',
                             'paginate' => 'none',
                         ),
                     ),
                     array(
                         'widget_id' => 'better-social-counter',
                         'widget_settings' => array(
                             'style' => 'style-7',
                             'order' => array(
                                 'facebook' => '1',
                                 'twitter' => '1',
                                 'google' => '1',
                                 'youtube' => '1',
                             ),
                             'columns' => '4',
                         ),
                     ),
                     array(
                         'widget_id' => 'bs-subscribe-newsletter',
                         'widget_settings' => array(
                             'image' => '%%bf_product_demo_media_url:{media.primary.newsletter}:\'full\'%%',
                             'show-powered' => '0',
                         ),
                     ),
                     array(
                         'widget_id' => 'better-ads',
                         'widget_settings' => array(
                             'type' => 'banner',
                             'banner' => '%%posts.primary.405%%',
                             'columns' => '1',
                         ),
                     ),
                 ),
                 'footer-1' => array(
                     'remove_all_widgets' => true,
                     array(
                         'widget_id' => 'bs-about',
                         'widget_settings' => array(
                             'content' => 'Publisher is the useful and powerful WordPress Newspaper Magazine and Blog theme with great attention to details, incredible features and everything else you need to create outstanding websites.
         <br>
         Contact us: <span style="color: #9c745a">contact@yoursite.com</span>',
                             'logo_img' => '%%bf_product_demo_media_url:{media.primary.logo-footer}:\'full\'%%',
                         ),
                     ),
                 ),
                 'footer-2' => array(
                     'remove_all_widgets' => true,
                     array(
                         'widget_id' => 'bs-popular-categories',
                         'widget_settings' => array(
                             'exclude' => array(
                                 '',
                             ),
                         ),
                     ),
                 ),
                 'footer-3' => array(
                     'remove_all_widgets' => true,
                     array(
                         'widget_id' => 'bs-thumbnail-listing-1',
                         'widget_settings' => array(
                             'title' => 'Latest Posts',
                             'count' => '3',
                             'columns' => 1,
                             'pagination-show-label' => '1',
                             'listing-settings' => array(
                                 'title-limit' => '60',
                                 'subtitle' => '0',
                                 'subtitle-limit' => '0',
                                 'subtitle-location' => 'before-meta',
                                 'meta' => array(
                                     'show' => '1',
                                     'author' => '0',
                                     'date' => '1',
                                     'date-format' => 'standard',
                                     'view' => '0',
                                     'share' => '0',
                                     'comment' => '0',
                                     'review' => '1',
                                 ),
                             ),
                             'disable_duplicate' => '0',
                             'paginate' => 'none',
                         ),
                     ),
                 ),
             ),
         ),
      //
      // ->Menus
      //
      'menus' => 
         array(
           'multi_steps' => false,
           array(
                 array(
                     'menu-location' => 'main-menu',
                     'menu-name' => 'Main Navigation',
                     'recently-edit' => true,
                     'items' => array(
                         array(
                             'item_type' => 'page',
                             'title' => 'Home',
                             'page_id' => '%%posts.primary.5%%',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.6%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.3%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.4%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.5%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.2%%',
                             'taxonomy' => 'category',
                         ),
                     ),
                 ),
                 array(
                     'menu-location' => 'footer-menu',
                     'menu-name' => 'Footer Navigation',
                     'items' => array(
                         array(
                             'item_type' => 'page',
                             'title' => 'Home',
                             'page_id' => '%%posts.primary.5%%',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.6%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.3%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.2%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.5%%',
                             'taxonomy' => 'category',
                         ),
                         array(
                             'item_type' => 'term',
                             'term_id' => '%%taxonomy.primary.4%%',
                             'taxonomy' => 'category',
                         ),
                     ),
                 ),
                 array(
                     'menu-location' => 'top-menu',
                     'menu-name' => 'Topbar Navigation',
                     'items' => array(
                         array(
                             'item_type' => 'custom',
                             'target' => '',
                             'title' => 'RTL',
                             'url' => '#',
                         ),
                         array(
                             'item_type' => 'page',
                             'title' => 'Contact',
                             'page_id' => '%%posts.primary.199%%',
                         ),
                     ),
                 ),
             ),
         ),
      //
      // ->Media
      //
      'media' => 
         array(
           'multi_steps' => true,
           array(
                 'file' => $demo_image_url . $prefix . 'logo.png',
                 'the_id' => 'media.primary.logo-main',
             ),
           array(
                 'file' => $demo_image_url . $prefix . 'newsletter.png',
                 'the_id' => 'media.primary.newsletter',
             ),
           array(
                 'file' => $demo_image_url . $prefix . '970x250-index.jpg',
                 'the_id' => 'media.primary.ad-970x250-index',
             ),
           array(
                 'file' => $demo_image_url . $prefix . '336x280-sidebar.jpg',
                 'the_id' => 'media.primary.ad-336x280-sidebar',
             ),
           array(
                 'file' => $demo_image_url . $prefix . '728x90-header.jpg',
                 'the_id' => 'media.primary.ad-728x90-header',
             ),
           array(
                 'file' => $demo_image_url . $prefix . '300x250-post.jpg',
                 'the_id' => 'media.primary.ad-300x250-post',
             ),
           array(
                 'file' => $demo_image_url . $prefix . '728x90.png',
                 'the_id' => 'media.primary.ad-728x90',
             ),
           array(
                 'file' => $demo_image_url . $prefix . 'thumb-1.png',
                 'resize' => true,
                 'the_id' => 'media.primary.thumb-1',
             ),
           array(
                 'file' => $demo_image_url . $prefix . 'quote-avatar.png',
                 'the_id' => 'media.primary.quote-avatar',
             ),
           array(
                 'file' => $demo_image_url . $prefix . 'logo-footer.png',
                 'resize' => true,
                 'the_id' => 'media.primary.logo-footer',
             ),
         ),	);
}
