<?php

if ( ! function_exists( 'prowess_select_include_woocommerce_shortcodes' ) ) {
	function prowess_select_include_woocommerce_shortcodes() {
		foreach ( glob( QODE_FRAMEWORK_MODULES_ROOT_DIR . '/woocommerce/shortcodes/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
	}
	
	if ( prowess_select_core_plugin_installed() ) {
		add_action( 'prowess_core_action_include_shortcodes_file', 'prowess_select_include_woocommerce_shortcodes' );
	}
}

if ( ! function_exists( 'prowess_select_set_product_list_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for product shortcodes to set our icon for Visual Composer shortcodes panel
	 */
	function prowess_select_set_product_list_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-product-info';
		$shortcodes_icon_class_array[] = '.icon-wpb-product-list';
		$shortcodes_icon_class_array[] = '.icon-wpb-product-list-carousel';
		$shortcodes_icon_class_array[] = '.icon-wpb-product-list-simple';
		
		return $shortcodes_icon_class_array;
	}
	
	if ( prowess_select_core_plugin_installed() ) {
		add_filter( 'prowess_core_filter_add_vc_shortcodes_custom_icon_class', 'prowess_select_set_product_list_icon_class_name_for_vc_shortcodes' );
	}
}

// Load woo elementor widgets
if ( ! function_exists( 'prowess_select_include_woo_elementor_widgets_files' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function prowess_select_include_woo_elementor_widgets_files() {
		if ( prowess_select_core_plugin_installed() ) {
			foreach ( glob( QODE_FRAMEWORK_MODULES_ROOT_DIR . '/woocommerce/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}

	add_action( 'elementor/widgets/widgets_registered', 'prowess_select_include_woo_elementor_widgets_files' );
}