<?php
class ProwessSelectElementorProductList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_product_list'; 
	}

	public function get_title() {
		return esc_html__( 'Product List', 'prowess-core' );
	}

	public function get_icon() {
		return 'prowess-elementor-custom-icon prowess-elementor-product-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'prowess-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'prowess-core'), 
					'masonry' => esc_html__( 'Masonry', 'prowess-core')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'hover_type',
			[
				'label'     => esc_html__( 'Hover Type', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'add-to-cart-below-image' => esc_html__( 'Add to cart below image', 'prowess-core'), 
					'add-to-cart-over-image' => esc_html__( 'Add to cart over image', 'prowess-core')
				),
				'default' => 'add-to-cart-below-image'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Products', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'prowess-core'), 
					'2' => esc_html__( 'Two', 'prowess-core'), 
					'3' => esc_html__( 'Three', 'prowess-core'), 
					'4' => esc_html__( 'Four', 'prowess-core'), 
					'5' => esc_html__( 'Five', 'prowess-core'), 
					'6' => esc_html__( 'Six', 'prowess-core')
				),
				'default' => '4'
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'prowess-core'), 
					'medium' => esc_html__( 'Medium', 'prowess-core'), 
					'normal' => esc_html__( 'Normal', 'prowess-core'), 
					'small' => esc_html__( 'Small', 'prowess-core'), 
					'tiny' => esc_html__( 'Tiny', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'prowess-core'), 
					'ID' => esc_html__( 'ID', 'prowess-core'), 
					'menu_order' => esc_html__( 'Menu Order', 'prowess-core'), 
					'name' => esc_html__( 'Post Name', 'prowess-core'), 
					'rand' => esc_html__( 'Random', 'prowess-core'), 
					'title' => esc_html__( 'Title', 'prowess-core'), 
					'on-sale' => esc_html__( 'On Sale', 'prowess-core')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'prowess-core'), 
					'DESC' => esc_html__( 'DESC', 'prowess-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'taxonomy_to_display',
			[
				'label'     => esc_html__( 'Choose Sorting Taxonomy', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'If you would like to display only certain products, this is where you can select the criteria by which you would like to choose which products to display', 'prowess-core' ),
				'options' => array(
					'category' => esc_html__( 'Category', 'prowess-core'), 
					'tag' => esc_html__( 'Tag', 'prowess-core'), 
					'id' => esc_html__( 'Id', 'prowess-core')
				),
				'default' => 'category'
			]
		);

		$this->add_control(
			'taxonomy_values',
			[
				'label'     => esc_html__( 'Enter Taxonomy Values', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Separate values (category slugs, tags, or post IDs) with a comma', 'prowess-core' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Proportions', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'full' => esc_html__( 'Original', 'prowess-core'), 
					'square' => esc_html__( 'Square', 'prowess-core'), 
					'landscape' => esc_html__( 'Landscape', 'prowess-core'), 
					'portrait' => esc_html__( 'Portrait', 'prowess-core'), 
					'medium' => esc_html__( 'Medium', 'prowess-core'), 
					'large' => esc_html__( 'Large', 'prowess-core'), 
					'shop_catalog' => esc_html__( 'Shop Catalog', 'prowess-core'), 
					'shop_single' => esc_html__( 'Shop Single', 'prowess-core'), 
					'shop_thumbnail' => esc_html__( 'Shop Thumbnail', 'prowess-core')
				),
				'default' => 'full'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_info_style',
			[
				'label' => esc_html__( 'Product Info Style', 'prowess-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'product_info_skin',
			[
				'label'     => esc_html__( 'Product Info Skin', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'prowess-core'), 
					'light' => esc_html__( 'Light', 'prowess-core'), 
					'dark' => esc_html__( 'Dark', 'prowess-core')
				),
				'default' => 'default'
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'h1' => esc_html__( 'h1', 'prowess-core'), 
					'h2' => esc_html__( 'h2', 'prowess-core'), 
					'h3' => esc_html__( 'h3', 'prowess-core'), 
					'h4' => esc_html__( 'h4', 'prowess-core'), 
					'h5' => esc_html__( 'h5', 'prowess-core'), 
					'h6' => esc_html__( 'h6', 'prowess-core')
				),
				'default' => 'h4',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'none' => esc_html__( 'None', 'prowess-core'), 
					'capitalize' => esc_html__( 'Capitalize', 'prowess-core'), 
					'uppercase' => esc_html__( 'Uppercase', 'prowess-core'), 
					'lowercase' => esc_html__( 'Lowercase', 'prowess-core'), 
					'initial' => esc_html__( 'Initial', 'prowess-core'), 
					'inherit' => esc_html__( 'Inherit', 'prowess-core')
				),
				'default' => '',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label'     => esc_html__( 'Excerpt Length', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of characters', 'prowess-core' ),
				'condition' => [
					'display_excerpt' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'button_skin',
			[
				'label'     => esc_html__( 'Button Skin', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default' => esc_html__( 'Default', 'prowess-core'), 
					'light' => esc_html__( 'Light', 'prowess-core'), 
					'dark' => esc_html__( 'Dark', 'prowess-core')
				),
				'default' => 'default',
				'condition' => [
					'display_button' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'shader_background_color',
			[
				'label'     => esc_html__( 'Shader Background Color', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'info_bottom_text_align',
			[
				'label'     => esc_html__( 'Product Info Text Alignment', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'left' => esc_html__( 'Left', 'prowess-core'), 
					'center' => esc_html__( 'Center', 'prowess-core'), 
					'right' => esc_html__( 'Right', 'prowess-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'info_bottom_margin',
			[
				'label'     => esc_html__( 'Product Info Bottom Margin (px)', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'product_info',
			[
				'label' => esc_html__( 'Product Info', 'prowess-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'display_title',
			[
				'label'     => esc_html__( 'Display Title', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_category',
			[
				'label'     => esc_html__( 'Display Category', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'prowess-core'), 
					'yes' => esc_html__( 'Yes', 'prowess-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'display_excerpt',
			[
				'label'     => esc_html__( 'Display Excerpt', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'prowess-core'), 
					'yes' => esc_html__( 'Yes', 'prowess-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'display_rating',
			[
				'label'     => esc_html__( 'Display Rating', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core'), 
					'yes' => esc_html__( 'Yes', 'prowess-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_price',
			[
				'label'     => esc_html__( 'Display Price', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_button',
			[
				'label'     => esc_html__( 'Display Button', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {
		$default_atts = array(
			'type'                    => 'standard',
			'hover_type'              => 'add-to-cart-below-image',
			'number_of_posts'         => '8',
			'number_of_columns'       => '4',
			'space_between_items'     => 'normal',
			'orderby'                 => 'date',
			'order'                   => 'ASC',
			'taxonomy_to_display'     => 'category',
			'taxonomy_values'         => '',
			'image_size'              => 'full',
			'display_title'           => 'yes',
			'product_info_skin'       => '',
			'title_tag'               => 'h4',
			'title_transform'         => '',
			'display_category'        => 'no',
			'display_excerpt'         => 'no',
			'excerpt_length'          => '20',
			'display_rating'          => 'yes',
			'display_price'           => 'yes',
			'display_button'          => 'yes',
			'button_skin'             => 'default',
			'shader_background_color' => '',
			'info_bottom_text_align'  => '',
			'info_bottom_margin'      => ''
		);
		$params       = shortcode_atts( $default_atts, $this->get_settings_for_display() );
		
		$params['class_name']     = 'pli';
		$params['type']           = ! empty( $params['type'] ) ? $params['type'] : $default_atts['type'];
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $default_atts['title_tag'];
		
		$additional_params                   = array();
		$additional_params['holder_classes'] = $this->getHolderClasses( $params, $default_atts );
		
		$queryArray                        = $this->generateProductQueryArray( $params );
		$query_result                      = new \WP_Query( $queryArray );
		$additional_params['query_result'] = $query_result;
		
		$params['this_object'] = $this;

		echo prowess_select_get_woo_shortcode_module_template_part( 'templates/product-list', 'product-list', $params['type'], $params, $additional_params );
	}

	private function getHolderClasses( $params, $default_atts ) {
		$holderClasses   = array();
		$holderClasses[] = ! empty( $params['type'] ) ? 'qodef-' . $params['type'] . '-layout' : 'qodef-' . $default_atts['type'] . '-layout';
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'qodef-' . $params['space_between_items'] . '-space' : 'qodef-' . $default_atts['space_between_items'] . '-space';
		$holderClasses[] = $this->getColumnNumberClass( $params );
		$holderClasses[] = ! empty( $params['product_info_skin'] ) ? 'qodef-product-info-' . $params['product_info_skin'] : '';
		$holderClasses[] = ! empty( $params['hover_type'] ) ? 'qodef-product-' . $params['hover_type'] : '';

		return implode( ' ', $holderClasses );
	}

	private function getColumnNumberClass( $params ) {
		$columnsNumber = '';
		$columns       = $params['number_of_columns'];
		
		switch ( $columns ) {
			case 1:
				$columnsNumber = 'qodef-one-column';
				break;
			case 2:
				$columnsNumber = 'qodef-two-columns';
				break;
			case 3:
				$columnsNumber = 'qodef-three-columns';
				break;
			case 4:
				$columnsNumber = 'qodef-four-columns';
				break;
			case 5:
				$columnsNumber = 'qodef-five-columns';
				break;
			case 6:
				$columnsNumber = 'qodef-six-columns';
				break;
			default:
				$columnsNumber = 'qodef-four-columns';
				break;
		}
		
		return $columnsNumber;
	}

	private function generateProductQueryArray( $params ) {
		$queryArray = array(
			'post_status'         => 'publish',
			'post_type'           => 'product',
			'ignore_sticky_posts' => 1,
			'posts_per_page'      => $params['number_of_posts'],
			'orderby'             => $params['orderby'],
			'order'               => $params['order']
		);
		
		if ( $params['orderby'] === 'on-sale' ) {
			$queryArray['no_found_rows'] = 1;
			$queryArray['post__in']      = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'category' ) {
			$queryArray['product_cat'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'tag' ) {
			$queryArray['product_tag'] = $params['taxonomy_values'];
		}
		
		if ( $params['taxonomy_to_display'] !== '' && $params['taxonomy_to_display'] === 'id' ) {
			$idArray                = $params['taxonomy_values'];
			$ids                    = explode( ',', $idArray );
			$queryArray['post__in'] = $ids;
		}
		
		return $queryArray;
	}

	public function getItemClasses( $params ) {
		$itemClasses = array();
		
		$image_size_meta = get_post_meta( get_the_ID(), 'qodef_product_featured_image_size', true );
		
		if ( ! empty( $image_size_meta ) ) {
			$itemClasses[] = $image_size_meta;
		}
		
		return implode( ' ', $itemClasses );
	}

	public function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_transform'];
		}
		
		return implode( ';', $styles );
	}

	public function getShaderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['shader_background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['shader_background_color'];
		}
		
		return implode( ';', $styles );
	}

	public function getTextWrapperStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['info_bottom_text_align'] ) ) {
			$styles[] = 'text-align: ' . $params['info_bottom_text_align'];
		}
		
		if ( $params['info_bottom_margin'] !== '' ) {
			$styles[] = 'margin-bottom: ' . prowess_select_filter_px( $params['info_bottom_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ProwessSelectElementorProductList() );