<?php
class ProwessSelectElementorProductListSimple extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_product_list_simple'; 
	}

	public function get_title() {
		return esc_html__( 'Product List - Simple', 'prowess-core' );
	}

	public function get_icon() {
		return 'prowess-elementor-custom-icon prowess-elementor-product-list-simple';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'prowess-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'sale' => esc_html__( 'Sale', 'prowess-core'), 
					'best-sellers' => esc_html__( 'Best Sellers', 'prowess-core'), 
					'featured' => esc_html__( 'Featured', 'prowess-core')
				),
				'default' => 'sale'
			]
		);

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number of Products', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of products to show (default value is 4)', 'prowess-core' )
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'prowess-core'), 
					'ID' => esc_html__( 'ID', 'prowess-core'), 
					'menu_order' => esc_html__( 'Menu Order', 'prowess-core'), 
					'name' => esc_html__( 'Post Name', 'prowess-core'), 
					'rand' => esc_html__( 'Random', 'prowess-core'), 
					'title' => esc_html__( 'Title', 'prowess-core')
				),
				'default' => 'title',
				'condition' => [
					'type' => array( 'sale', 'featured' )
				]
			]
		);

		$this->add_control(
			'sort_order',
			[
				'label'     => esc_html__( 'Order', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'prowess-core'), 
					'DESC' => esc_html__( 'DESC', 'prowess-core')
				),
				'default' => 'ASC',
				'condition' => [
					'type' => array( 'sale', 'featured' )
				]
			]
		);

		$this->add_control(
			'display_title',
			[
				'label'     => esc_html__( 'Display Title', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'h1' => esc_html__( 'h1', 'prowess-core'), 
					'h2' => esc_html__( 'h2', 'prowess-core'), 
					'h3' => esc_html__( 'h3', 'prowess-core'), 
					'h4' => esc_html__( 'h4', 'prowess-core'), 
					'h5' => esc_html__( 'h5', 'prowess-core'), 
					'h6' => esc_html__( 'h6', 'prowess-core')
				),
				'default' => 'h5',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess-core'), 
					'none' => esc_html__( 'None', 'prowess-core'), 
					'capitalize' => esc_html__( 'Capitalize', 'prowess-core'), 
					'uppercase' => esc_html__( 'Uppercase', 'prowess-core'), 
					'lowercase' => esc_html__( 'Lowercase', 'prowess-core'), 
					'initial' => esc_html__( 'Initial', 'prowess-core'), 
					'inherit' => esc_html__( 'Inherit', 'prowess-core')
				),
				'default' => 'uppercase',
				'condition' => [
					'display_title' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'display_rating',
			[
				'label'     => esc_html__( 'Display Rating', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'display_price',
			[
				'label'     => esc_html__( 'Display Price', 'prowess-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess-core'), 
					'no' => esc_html__( 'No', 'prowess-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['class_name']     = 'pls';

		$params['title_tag']    = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h5';
		$params['title_styles'] = $this->getTitleStyles( $params );
		
		$queryArray             = $this->generateProductQueryArray( $params );
		$query_result           = new \WP_Query( $queryArray );
		$params['query_result'] = $query_result;
		
		echo prowess_select_get_woo_shortcode_module_template_part( 'templates/product-list-template', 'product-list-simple', '', $params );
	}

	private function getHolderClasses( $params ) {
		$holderClasses   = '';
		$productListType = $params['type'];
		
		switch ( $productListType ) {
			case 'sale':
				$holderClasses = 'qodef-pls-sale';
				break;
			case 'best-sellers':
				$holderClasses = 'qodef-pls-best-sellers';
				break;
			case 'featured':
				$holderClasses = 'qodef-pls-featured';
				break;
			default:
				$holderClasses = 'qodef-pls-sale';
				break;
		}
		
		return $holderClasses;
	}

	private function generateProductQueryArray( $params ) {
		switch ( $params['type'] ) {
			case 'sale':
				$args = array(
					'post_status'    => 'publish',
					'post_type'      => 'product',
					'posts_per_page' => $params['number'],
					'orderby'        => $params['orderby'],
					'order'          => $params['sort_order'],
					'no_found_rows'  => 1,
					'post__in'       => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);
				break;
			case 'best-sellers':
				$args = array(
					'post_status'         => 'publish',
					'post_type'           => 'product',
					'ignore_sticky_posts' => 1,
					'posts_per_page'      => $params['number'],
					'meta_key'            => 'total_sales',
					'orderby'             => 'meta_value_num'
				);
				break;
			case 'featured':
				$args = array(
					'post_status'    => 'publish',
					'post_type'      => 'product',
					'posts_per_page' => $params['number'],
					'orderby'        => $params['orderby'],
					'order'          => $params['sort_order'],
					'tax_query' => array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => 'featured',
                        ),
                	),

				);
				break;
		}
		
		return $args;
	}

	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_transform'];
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ProwessSelectElementorProductListSimple() );