<?php
class ProwessSelectElementorTTEventInfo extends \Elementor\Widget_Base {

	public function get_name() {
		return 'tt_event_info_holder';
	}

	public function get_title() {
		return esc_html__( 'Timetable Event Info Holder', 'prowess' );
	}

	public function get_icon() {
		return 'prowess-elementor-custom-icon prowess-elementor-tt-event-info-holder';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'prowess' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'content',
			[
				'label'     => esc_html__( 'Label', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter accordion section title', 'prowess' )
			]
		);
		$repeater->add_control(
			'value',
			[
				'label'       => esc_html__( 'Value', 'prowess' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
			]
		);
		
		$this->add_control(
			'tt_items_list',
			[
				'label'     => esc_html__( 'Timetable Event Info Table Item', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'prowess' )
			]
		);

		$this->end_controls_section();
	}
	public function render() {
		$params = $this->get_settings_for_display();

		?>

		<ul class="tt_event_items_list">
			<?php foreach ( $params['tt_items_list'] as $item ) {
				$item['type'] = 'info';

				echo prowess_select_execute_shortcode( 'tt_item', $item, $item['content'] );
			} ?>
		</ul>
		<?php
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ProwessSelectElementorTTEventInfo() );