<?php

if ( ! function_exists( 'prowess_select_set_timetable_event_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for Timetable shortcodes to set our icon for Visual Composer shortcodes panel
	 */
	function prowess_select_set_timetable_event_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-tt-event-hours';
		$shortcodes_icon_class_array[] = '.icon-wpb-tt-event-info-holder';

		return $shortcodes_icon_class_array;
	}

	if ( prowess_select_core_plugin_installed() ) {
		add_filter( 'prowess_core_filter_add_vc_shortcodes_custom_icon_class', 'prowess_select_set_timetable_event_icon_class_name_for_vc_shortcodes' );
	}
}

// Load Timetable elementor widgets
if ( ! function_exists( 'prowess_select_include_tt_event_elementor_widgets_files' ) ) {
	/**
	 * Loads all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function prowess_select_include_tt_event_elementor_widgets_files() {
		if ( prowess_select_core_plugin_installed() ) {
			foreach ( glob( QODE_FRAMEWORK_MODULES_ROOT_DIR . '/timetable-schedule/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}

	add_action( 'elementor/widgets/widgets_registered', 'prowess_select_include_tt_event_elementor_widgets_files' );
}