<?php
class ProwessSelectElementorBlogList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_blog_list'; 
	}

	public function get_title() {
		return esc_html__( 'Blog List', 'prowess' );
	}

	public function get_icon() {
		return 'prowess-elementor-custom-icon prowess-elementor-blog-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'prowess' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'prowess'), 
					'boxed' => esc_html__( 'Boxed', 'prowess'), 
					'masonry' => esc_html__( 'Masonry', 'prowess'), 
					'simple' => esc_html__( 'Simple', 'prowess'), 
					'minimal' => esc_html__( 'Minimal', 'prowess')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Number of Posts', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'1' => esc_html__( 'One', 'prowess'), 
					'2' => esc_html__( 'Two', 'prowess'), 
					'3' => esc_html__( 'Three', 'prowess'), 
					'4' => esc_html__( 'Four', 'prowess'), 
					'5' => esc_html__( 'Five', 'prowess')
				),
				'default' => '3',
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry' )
				]
			]
		);

		$this->add_control(
			'space_between_items',
			[
				'label'     => esc_html__( 'Space Between Items', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'large' => esc_html__( 'Large', 'prowess'), 
					'medium' => esc_html__( 'Medium', 'prowess'), 
					'normal' => esc_html__( 'Normal', 'prowess'), 
					'small' => esc_html__( 'Small', 'prowess'), 
					'tiny' => esc_html__( 'Tiny', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'normal',
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry' )
				]
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'prowess'), 
					'ID' => esc_html__( 'ID', 'prowess'), 
					'menu_order' => esc_html__( 'Menu Order', 'prowess'), 
					'name' => esc_html__( 'Post Name', 'prowess'), 
					'rand' => esc_html__( 'Random', 'prowess'), 
					'title' => esc_html__( 'Title', 'prowess')
				),
				'default' => 'title'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'prowess'), 
					'DESC' => esc_html__( 'DESC', 'prowess')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'category',
			[
				'label'     => esc_html__( 'Category', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one category slug (leave empty for showing all categories)', 'prowess' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'full' => esc_html__( 'Original', 'prowess'), 
					'prowess_select_square' => esc_html__( 'Square', 'prowess'), 
					'prowess_select_landscape' => esc_html__( 'Landscape', 'prowess'), 
					'prowess_select_portrait' => esc_html__( 'Portrait', 'prowess'), 
					'thumbnail' => esc_html__( 'Thumbnail', 'prowess'), 
					'medium' => esc_html__( 'Medium', 'prowess'), 
					'large' => esc_html__( 'Large', 'prowess')
				),
				'default' => 'full',
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_info',
			[
				'label' => esc_html__( 'Post Info', 'prowess' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess'), 
					'h1' => esc_html__( 'h1', 'prowess'), 
					'h2' => esc_html__( 'h2', 'prowess'), 
					'h3' => esc_html__( 'h3', 'prowess'), 
					'h4' => esc_html__( 'h4', 'prowess'), 
					'h5' => esc_html__( 'h5', 'prowess'), 
					'h6' => esc_html__( 'h6', 'prowess')
				),
				'default' => 'h4'
			]
		);

		$this->add_control(
			'title_transform',
			[
				'label'     => esc_html__( 'Title Text Transform', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'prowess'), 
					'none' => esc_html__( 'None', 'prowess'), 
					'capitalize' => esc_html__( 'Capitalize', 'prowess'), 
					'uppercase' => esc_html__( 'Uppercase', 'prowess'), 
					'lowercase' => esc_html__( 'Lowercase', 'prowess'), 
					'initial' => esc_html__( 'Initial', 'prowess'), 
					'inherit' => esc_html__( 'Inherit', 'prowess')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'excerpt_length',
			[
				'label'     => esc_html__( 'Text Length', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Number of words', 'prowess' ),
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry', 'simple' )
				]
			]
		);

		$this->add_control(
			'post_info_image',
			[
				'label'     => esc_html__( 'Enable Post Info Image', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry' )
				]
			]
		);

		$this->add_control(
			'post_info_section',
			[
				'label'     => esc_html__( 'Enable Post Info Section', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'standard', 'boxed', 'masonry' )
				]
			]
		);

		$this->add_control(
			'post_info_author',
			[
				'label'     => esc_html__( 'Enable Post Info Author', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'no',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'post_info_date',
			[
				'label'     => esc_html__( 'Enable Post Info Date', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'yes',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'post_info_category',
			[
				'label'     => esc_html__( 'Enable Post Info Category', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'prowess'), 
					'no' => esc_html__( 'No', 'prowess')
				),
				'default' => 'no',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'post_info_comments',
			[
				'label'     => esc_html__( 'Enable Post Info Comments', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'prowess'), 
					'yes' => esc_html__( 'Yes', 'prowess')
				),
				'default' => 'no',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'post_info_like',
			[
				'label'     => esc_html__( 'Enable Post Info Like', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'prowess'), 
					'yes' => esc_html__( 'Yes', 'prowess')
				),
				'default' => 'no',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'post_info_share',
			[
				'label'     => esc_html__( 'Enable Post Info Share', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'prowess'), 
					'yes' => esc_html__( 'Yes', 'prowess')
				),
				'default' => 'no',
				'condition' => [
					'post_info_section' => array( 'yes' )
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'additional_features',
			[
				'label' => esc_html__( 'Additional Features', 'prowess' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'pagination_type',
			[
				'label'     => esc_html__( 'Pagination Type', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no-pagination' => esc_html__( 'None', 'prowess'), 
					'standard-shortcodes' => esc_html__( 'Standard', 'prowess'), 
					'load-more' => esc_html__( 'Load More', 'prowess'), 
					'infinite-scroll' => esc_html__( 'Infinite Scroll', 'prowess')
				),
				'default' => 'no-pagination'
			]
		);

		$this->add_control(
			'box_shadow',
			[
				'label'     => esc_html__( 'Box shadow', 'prowess' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'no', 'prowess'), 
					'boxed-shadow' => esc_html__( 'yes', 'prowess')
				),
				'default' => '',
				'condition' => [
					'type' => array( 'boxed' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$default_atts = array(
			'type'                  => 'standard',
			'number_of_posts'       => '-1',
			'number_of_columns'     => '3',
			'space_between_items'   => 'normal',
			'category'              => '',
			'orderby'               => 'title',
			'order'                 => 'ASC',
			'image_size'            => 'full',
			'title_tag'             => 'h4',
			'title_transform'       => '',
			'excerpt_length'        => '40',
			'post_info_section'     => 'yes',
			'post_info_image'       => 'yes',
			'post_info_author'      => 'no',
			'post_info_date'        => 'yes',
			'post_info_category'    => 'no',
			'post_info_comments'    => 'no',
			'post_info_like'        => 'no',
			'post_info_share'       => 'no',
			'pagination_type'       => 'no-pagination',
			'box_shadow'            => '',
		);
		$params       = shortcode_atts( $default_atts, $this->get_settings_for_display() );

		$queryArray             = $this->generateQueryArray( $params );
		$query_result           = new \WP_Query( $queryArray );
		$params['query_result'] = $query_result;
		
		$params['holder_data']    = $this->getHolderData( $params );
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['module']         = 'list';
		
		$params['max_num_pages'] = $query_result->max_num_pages;
		$params['paged']         = isset( $query_result->query['paged'] ) ? $query_result->query['paged'] : 1;
		
		$params['this_object'] = $this;
		
		ob_start();
		
		prowess_select_get_module_template_part( 'shortcodes/blog-list/holder', 'blog', $params['type'], $params );
		
		$html = ob_get_contents();
		
		ob_end_clean();
		
		echo prowess_select_get_module_part($html);
	}

	public function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['type'] ) ? 'qodef-bl-' . $params['type'] : 'qodef-bl-standard';
        $holderClasses[] = ! empty( $params['box_shadow'] ) ? 'qodef-bl-boxed-' . $params['box_shadow'] : '';
		$holderClasses[] = $this->getColumnNumberClass( $params['number_of_columns'] );
		$holderClasses[] = ! empty( $params['space_between_items'] ) ? 'qodef-' . $params['space_between_items'] . '-space' : 'qodef-normal-space';
		$holderClasses[] = ! empty( $params['pagination_type'] ) ? 'qodef-bl-pag-' . $params['pagination_type'] : 'qodef-bl-pag-no-pagination';
		
		return implode( ' ', $holderClasses );
	}

	public function getColumnNumberClass( $params ) {
		switch ( $params ) {
			case 1:
				$classes = 'qodef-bl-one-column';
				break;
			case 2:
				$classes = 'qodef-bl-two-columns';
				break;
			case 3:
				$classes = 'qodef-bl-three-columns';
				break;
			case 4:
				$classes = 'qodef-bl-four-columns';
				break;
			case 5:
				$classes = 'qodef-bl-five-columns';
				break;
			default:
				$classes = 'qodef-bl-three-columns';
				break;
		}

		return $classes;
	}

	public function getHolderData( $params ) {
		$dataString = '';
		
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		$query_result = $params['query_result'];

		$params['max_num_pages'] = $query_result->max_num_pages;

		if ( ! empty( $paged ) ) {
			$params['next-page'] = $paged + 1;
		}

		foreach ( $params as $key => $value ) {
			if ( $key !== 'query_result' && $value !== '' ) {
				$new_key = str_replace( '_', '-', $key );

				if ( $key == 'box_shadow' && $value == '' ) {
					$value = 'no'; // Breaks pagination if left empty
				}

				$dataString .= ' data-' . $new_key . '=' . esc_attr( str_replace( ' ', '', $value ) );
			}
		}

		return $dataString;
	}

	public function generateQueryArray( $params ) {
		$queryArray = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'orderby'        => $params['orderby'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'post__not_in'   => get_option( 'sticky_posts' )
		);

		if ( ! empty( $params['category'] ) ) {
			$queryArray['category_name'] = $params['category'];
		}

		if ( ! empty( $params['next_page'] ) ) {
			$queryArray['paged'] = $params['next_page'];
		} else {
			$query_array['paged'] = 1;
		}

		return $queryArray;
	}

	public function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_transform'] ) ) {
			$styles[] = 'text-transform: ' . $params['title_transform'];
		}
		
		return implode( ';', $styles );
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new ProwessSelectElementorBlogList() );