<?php

if ( ! function_exists( 'prowess_select_map_post_audio_meta' ) ) {
	function prowess_select_map_post_audio_meta() {
		$audio_post_format_meta_box = prowess_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'prowess' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		prowess_select_create_meta_box_field(
			array(
				'name'          => 'qodef_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'prowess' ),
				'description'   => esc_html__( 'Choose audio type', 'prowess' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'prowess' ),
					'self'            => esc_html__( 'Self Hosted', 'prowess' )
				)
			)
		);
		
		$qodef_audio_embedded_container = prowess_select_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'qodef_audio_embedded_container'
			)
		);
		
		prowess_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'prowess' ),
				'description' => esc_html__( 'Enter audio URL', 'prowess' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		prowess_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'prowess' ),
				'description' => esc_html__( 'Enter audio link', 'prowess' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'prowess_select_meta_boxes_map', 'prowess_select_map_post_audio_meta', 23 );
}