<?php
	/**
	 * CWS Twitter Widget Class
	 */
class Prospect_Twitter_Widget extends WP_Widget {

	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Widget Title', 'prospect' ),
				'atts'	=> 'id="widget-title"',
				'type' => 'text',
			),
			'icon'	=> array(
				'title'			=> esc_html__( 'Widget Icon', 'prospect' ),
				'type'			=> 'select',
				'addrowclasses' => 'fai',
				'source' 		=> 'fa'
			),
			'add_custom_color'	=> array(
				'title'			=> esc_html__( 'Add Custom Color', 'prospect' ),
				'type'			=> 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts'			=> 'data-options="e:color;"'
			),
			'color'	=> array(
				'title'					=> esc_html__( 'Custom Color', 'prospect' ),
				'type'					=> 'text',
				'atts'					=> 'data-default-color="' . PROSPECT_THEME_COLOR . '"'
			),
			'number' => array(
				'type' => 'number',
				'title' => esc_html__( 'Post count', 'prospect' ),
				'value' => '4',
			),
			'visible_number' => array(
				'type' => 'number',
				'title' => esc_html__( 'Posts per slide', 'prospect' ),
				'value' => '2',
			)
		);
	}

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_prospect_twitter', 'description' => esc_html__( 'Prospect Twitter Widget', 'prospect' ) );
		parent::__construct( 'prospect-twitter', esc_html__( 'Prospect Twitter', 'prospect' ), $widget_ops );
	}

	public function widget( $args, $instance ) {
		extract( $args );
		extract(shortcode_atts(array(
			'title' => '',
			'icon'				=> '',
			'add_custom_color'	=> false,
			'color'				=> PROSPECT_THEME_COLOR,
			'number' => 4,
			'visible_number' => 2
		), $instance));
		$title = esc_html( $title );
		$icon = esc_attr( $icon );
		$add_custom_color = (bool)$add_custom_color;
		$color = esc_attr( $color );
		$number = (int)$number;
		$visible_number = (int)$visible_number;

		$title = apply_filters( 'widget_title', $title );

		$custom_color = $add_custom_color && !empty( $color );
		$widget_styles = "";
		if ( $custom_color ){
			$widget_styles .= "#$widget_id a:not(.prospect_button):not(.prospect_icon):hover,
								#$widget_id input[type='submit']{
				color: $color;
			}
			#$widget_id input[type='submit'],
			#$widget_id .latest_tweets .tweet:before,
			#$widget_id .owl-pagination .owl-page{
				border-color: $color;
			}
			#$widget_id input[type='submit']:hover,
			#$widget_id .owl-pagination .owl-page.active,
			#$widget_id .widgettitle:after{
				background-color: $color;
			}";
		}
		$before_widget = $custom_color ? preg_replace( "#class=\"(.+)\"#", "class=\"$1 custom_color\"", $before_widget ) : $before_widget;

		echo $before_widget;
		if ( !empty( $widget_styles ) ){
			echo "<style type='text/css'>$widget_styles</style>";
		}

		$number = (int)$number;
		$visible_number = (int)$visible_number;
		$visible_number = $visible_number == 0 ? $number : $visible_number;
		$retrieved_tweets_number = 0;
		$is_plugin_installed = function_exists( 'getTweets' );
		$tweets = $is_plugin_installed ? getTweets( $number ) : array();
		$retrieved_tweets_number = count( $tweets );
		$is_carousel = $retrieved_tweets_number > $visible_number;
		if ( $is_carousel ){
			wp_enqueue_script( 'owl_carousel' );
		}

		if ( !empty( $icon ) ){
			echo $before_title . "<i class='widget_icon fa fa-$icon'></i>" . $title . $after_title;				
		}
		else{
			echo !empty( $title ) ? $before_title . $title . $after_title : "";
		}

		if ( !empty( $tweets ) ){
			if ( isset( $tweets['error'] ) && !empty( $tweets['error'] ) ){
				echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Twitter applyed with error', 'prospect' ) . "' type='error']" . esc_html( $tweets['error'] ) . "[/cws_sc_msg_box]" );
			}
			else{
				if ( $is_carousel ){
					echo "<ul class='latest_tweets widget_carousel bullets_nav'>";
					$groups_count = ceil( $retrieved_tweets_number / $visible_number );
					for ( $i = 0; $i < $groups_count; $i++ ){
						echo "<li>";
							echo "<ul>";
								for( $j = $i * $visible_number; ( ( $j < ( $i + 1 ) * $visible_number ) && ( $j < $retrieved_tweets_number ) ); $j++ ){
									$tweet = $tweets[$j];
									$tweet_text = isset( $tweet['text'] ) ? $tweet['text'] : "";
									$tweet_entitties = isset( $tweet['entities'] ) ? $tweet['entities'] : array();
									$tweet_urls = isset( $tweet_entitties['urls'] ) && is_array( $tweet_entitties['urls'] ) ? $tweet_entitties['urls'] : array();
									foreach ( $tweet_urls as $tweet_url ) {
										$display_url = isset( $tweet_url['display_url'] ) ? $tweet_url['display_url'] : "";
										$received_url = isset( $tweet_url['url'] ) ? $tweet_url['url'] : "";
										$html_url = "<a href='$received_url'>$display_url</a>";
										$tweet_text = substr_replace( $tweet_text, $html_url, strpos( $tweet_text, $received_url ), strlen( $received_url ) );
									}
									$tweet_date = $tweet['created_at'];
									echo "<li class='tweet'>";
										echo "<div class='text'>" . $tweet_text . "</div>";
										echo "<div class='date'>";
											echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
										echo "</div>";	
									echo "</li>";						
								}
							echo "</ul>";
						echo "</li>";
					}
					echo "</ul>";
				}
				else{
					echo "<ul class='latest_tweets'>";
						foreach ( $tweets as $tweet ) {
							echo "<li class='tweet'>";
								$tweet_text = isset( $tweet['text'] ) ? $tweet['text'] : "";
								$tweet_entitties = isset( $tweet['entities'] ) ? $tweet['entities'] : array();
								$tweet_urls = isset( $tweet_entitties['urls'] ) && is_array( $tweet_entitties['urls'] ) ? $tweet_entitties['urls'] : array();
								foreach ( $tweet_urls as $tweet_url ) {
									$display_url = isset( $tweet_url['display_url'] ) ? $tweet_url['display_url'] : "";
									$received_url = isset( $tweet_url['url'] ) ? $tweet_url['url'] : "";
									$html_url = "<a href='$received_url'>$display_url</a>";
									$tweet_text = substr_replace( $tweet_text, $html_url, strpos( $tweet_text, $received_url ), strlen( $received_url ) );
								}
								$tweet_date = $tweet['created_at'];
								echo "<div class='text'>" . $tweet_text . "</div>";
								echo "<div class='date'>";
									echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
								echo "</div>";
							echo "</li>";
						}
					echo "</ul>";
				}
			}
		}
		else{
			if ( !$is_plugin_installed ){
				echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Plugin not installed', 'prospect' ) . "' type='warn']" . esc_html__( 'Please install and activate required plugin ', 'prospect' ) . "<a href='https://ru.wordpress.org/plugins/oauth-twitter-feed-for-developers/'>" . esc_html__( "oAuth Twitter Feed for Developers", 'prospect' ) . "</a>[/cws_sc_msg_box]" );
			}
		}
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	public function form( $instance ) {
		$this->init_fields();
		$args[0] = $instance;
		cws_mb_fillMbAttributes( $args, $this->fields );
		echo prospect_mb_print_layout( $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
	}

}
?>