<?php
	/**
	 * Prospect Text Widget Class
	 */
class Prospect_Text_Widget extends WP_Widget {
	
	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title'	=> esc_html__( 'Widget Title', 'prospect' ),
				'atts'	=> 'id="widget-title"',
				'type'	=> 'text',
			),
			'icon'	=> array(
				'title'			=> esc_html__( 'Widget Icon', 'prospect' ),
				'type'			=> 'select',
				'addrowclasses' => 'fai',
				'source' 		=> 'fa'
			),
			'add_custom_color'	=> array(
				'title'			=> esc_html__( 'Add Custom Color', 'prospect' ),
				'type'			=> 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts'			=> 'data-options="e:color;"'
			),
			'color'	=> array(
				'title'					=> esc_html__( 'Custom Color', 'prospect' ),
				'type'					=> 'text',
				'atts'					=> 'data-default-color="' . PROSPECT_THEME_COLOR . '"'
			),
			'text'				=> array(
				'title'			=> esc_html__( 'Widget Content', 'prospect' ),
				'type'			=> 'textarea',
				'atts'			=> 'rows="8"',
				'default'		=> ''
			)
		);
	}
	public function __construct() {
		$widget_ops = array( 'classname' => 'widget-prospect-text', 'description' => esc_html__( 'Prospect Text Widget', 'prospect' ) );
		parent::__construct( 'prospect-text', esc_html__( 'Prospect Text', 'prospect' ), $widget_ops );
	}
	public function widget( $args, $instance ) {
		extract( $args );
		extract(shortcode_atts(array(
			'title' 			=> '',
			'icon'				=> '',
			'add_custom_color'	=> false,
			'color'				=> PROSPECT_THEME_COLOR,
			'text'				=> '',
			'text_align'		=> 'left',
			'add_button'		=> '',
			'button_url'		=> '',
			'button_text'		=> '',
		), $instance));
		$title = esc_html( $title );
		$icon = esc_html( $icon );
		$button_text = esc_html( $button_text );
		$button_url = esc_url( $button_url );
		$add_custom_color =(bool)$add_custom_color;
		$add_button =(bool)$add_button;
		$color = esc_attr( $color );
		$custom_color = $add_custom_color && !empty( $color );
		$text_align = esc_html( $text_align );

		$title = apply_filters( 'widget_title', $title );

		$widget_styles = "";
		$widget_styles .= "#$widget_id a:not(.prospect_button):not(.prospect_icon):hover,
							#$widget_id input[type='submit']{
			color: $color;
		}
		#$widget_id input[type='submit']:hover{
			color: #fff;
		}
		#$widget_id input[type='submit'],
		#$widget_id .owl-pagination .owl-page{
			border-color: $color;
		}
		#$widget_id input[type='submit']:hover,
		#$widget_id .owl-pagination .owl-page.active,
		#$widget_id .widgettitle:after{
			background-color: $color;
		}
		#$widget_id{
			text-align: $text_align;
		}";

		$widget_styles = json_encode($widget_styles);

		$before_widget = $custom_color ? preg_replace( "#class=\"(.+)\"#", "class=\"$1 custom_color render_styles\" data-style='".esc_attr($widget_styles)."' ", $before_widget ) : $before_widget;
		echo $before_widget;
		if ( !empty( $title ) || !empty( $icon )){
			echo $before_title;
			if ( !empty( $icon ) ){ echo '<i class="widget_icon ' . $icon . '"> </i>'; }
			if ( !empty( $title )){ echo $title; }
			echo $after_title;
		}
		$content = apply_filters( 'the_content', $text );
		if ( !empty( $content ) ){
			echo "<div class='cws_widget_content'>";
				echo $content;
			echo "</div>";
		}
		$button_url_f ='';
		$button_url_f = !empty($button_url) ? $button_url : '#';
		echo "<a href='$button_url_f'>$button_text</a>";
		echo $after_widget;
	}
	public function update( $new_instance, $instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}
	public function form( $instance ) {
		$this->init_fields();
		$args[0] = $instance;
		cws_mb_fillMbAttributes( $args, $this->fields );
		echo prospect_mb_print_layout( $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
	}
}
?>