<?php
	/**
	 * CWS Social Widget Class
	 */
class Prospect_Social_Widget extends WP_Widget {

	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Widget Title', 'prospect' ),
				'atts'	=> 'id="widget-title"',
				'type' => 'text',
			),
			'icon'	=> array(
				'title'			=> esc_html__( 'Widget Icon', 'prospect' ),
				'type'			=> 'select',
				'addrowclasses' => 'fai',
				'source' 		=> 'fa'
			),
			'add_custom_color'	=> array(
				'title'			=> esc_html__( 'Add Custom Color', 'prospect' ),
				'type'			=> 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts'			=> 'data-options="e:color;"'
			),
			'color'	=> array(
				'title'					=> esc_html__( 'Custom Color', 'prospect' ),
				'type'					=> 'text',
				'atts'					=> 'data-default-color="' . PROSPECT_THEME_COLOR . '"'
			)
		);
	}

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget-prospect-social', 'description' => esc_html__( 'Prospect Social Widget', 'prospect' ) );
		parent::__construct( 'prospect-social', esc_html__( 'Prospect Social', 'prospect' ), $widget_ops );
	}

	public function widget( $args, $instance ) {
		extract( $args );
		extract(shortcode_atts(array(
			'title' => '',
			'icon'				=> '',
			'add_custom_color'	=> false,
			'color'				=> PROSPECT_THEME_COLOR
		), $instance));
		$title = esc_html( $title );
		$icon = esc_attr( $icon );
		$add_custom_color = (bool)$add_custom_color;
		$color = esc_attr( $color );

		$title = apply_filters( 'widget_title', $title );

		$custom_color = $add_custom_color && !empty( $color );
		$widget_styles = "";
		if ( $custom_color ){
			$widget_styles .= "#$widget_id a:not(.prospect_button):not(.prospect_icon):hover,
								#$widget_id input[type='submit']{
				color: $color;
			}
			#$widget_id input[type='submit'],
			#$widget_id .social_icon{
				border-color: $color;
			}
			#$widget_id .social_icon .figure_wrap svg{
				fill: $color;
			}
			#$widget_id input[type='submit']:hover,
			#$widget_id .widgettitle:after{
				background-color: $color;
			}
			#$widget_id .social_icon:hover .figure_wrap svg,
			#$widget_id .social_icon .figure_wrap svg{
				stroke: $color;
			}";
		}
		$before_widget = $custom_color ? preg_replace( "#class=\"(.+)\"#", "class=\"$1 custom_color\"", $before_widget ) : $before_widget;

		echo $before_widget;
		if ( !empty( $widget_styles ) ){
			echo "<style type='text/css'>$widget_styles</style>";
		}
		if ( !empty( $title ) ){
			echo $before_title;
			if ( !empty( $icon ) ){
				echo "<i class='widget_icon $icon'></i>";
			}
			echo $title;
			echo $after_title;
		}
		$social_links = prospect_render_social_links ();
		if ( !empty( $social_links ) ){
			echo "<div class='widget_social'>";
				echo $social_links;
			echo "</div>";
		}
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	public function form( $instance ) {
		$this->init_fields();
		$args[0] = $instance;
		cws_mb_fillMbAttributes( $args, $this->fields );
		echo prospect_mb_print_layout( $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
	}

}
?>