<?php
new prospect_Metaboxes();

class prospect_Metaboxes {
	public $mb_page_layout = array();

	public function __construct() {
		if ( is_customize_preview() ) {
			$this->mb_page_layout = $this->getPageLayout();
		}
		$this->init();
	}

	private function getPageLayout() {
		return array(
			'header_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Customize Header', 'prospect' ),
				'atts' => 'data-options="e:header_covers_slider;e:menu_font_color;e:menu_opacity;e:header_logo_light;e:menu_bg_color;e:default_header_image"',
			),
			'header_covers_slider' => array(
				'title' => esc_html__( 'Header Covers Slider', 'prospect' ),
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox disable'
			),
			'header_logo_light' => array(
				'type' => 'select',
				'title' => esc_html__( 'Logo', 'prospect' ),
				'addrowclasses' => 'disable',
				'source' => array(
					'black' => array( esc_html__( 'Black', 'prospect' ), true),
					'white' => array( esc_html__( 'White', 'prospect' ), false),
					'none' => array( esc_html__( 'None', 'prospect' ), false)
				)
			),
			'menu_opacity' => array(
				'title' => esc_html__( 'Header Opacity', 'prospect' ),
				'type' => 'number',
				'atts' => " min='0' max='100'",
				'addrowclasses' => 'disable',
				'value'	=> '100'
			),
			'menu_bg_color' => array(
				'title' 		=> esc_html__( 'Background Color', 'prospect' ),						
				'type' 			=> 'text',
				'addrowclasses' => 'disable',
				'atts' 			=> 'data-default-color="#ffffff"',
				'value'			=> '#ffffff'
			),
			'menu_font_color' => array(
				'title' 		=> esc_html__( 'Override Font Color', 'prospect' ),
				'tooltip' => array(
					'title' => esc_html__( 'Override Font Color', 'prospect' ),
					'content' => esc_html__( 'Override Font Color', 'prospect' ),
				),
				'type' 			=> 'text',
				'addrowclasses' => 'disable',
				'atts' 			=> 'data-default-color="#1c3545;"',
				'value'			=> '#1c3545'
			),
			'default_header_image'	=> array(
				'title'	=> esc_html__( 'Header Image', 'prospect' ),
				'type'	=> 'media'
			),
			'sb_layout' => array(
				'title' => esc_html__('Sidebar Position', 'prospect' ),
				'type' => 'radio',
				'subtype' => 'images',
				'value' => array(
					'default'=>	array( esc_html__('Default', 'prospect' ), true, 'd:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/default.png' ),
					'left' => 	array( esc_html__('Left', 'prospect' ), false, 'e:sidebar1;d:sidebar2',	get_template_directory_uri() . '/img/fw_img/left.png' ),
					'right' => 	array( esc_html__('Right', 'prospect' ), false, 'e:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/right.png' ),
					'both' => 	array( esc_html__('Double', 'prospect' ), false, 'e:sidebar1;e:sidebar2', get_template_directory_uri() . '/img/fw_img/both.png' ),
					'none' => 	array( esc_html__('None', 'prospect' ), false, 'd:sidebar1;d:sidebar2', get_template_directory_uri() . '/img/fw_img/none.png' )
				),
			),
			'sidebar1' => array(
				'title' => esc_html__('Select a sidebar', 'prospect' ),
				'type' => 'select',
				'addrowclasses' => 'disable',
				'source' => 'sidebars',
			),
			'sidebar2' => array(
				'required' => array( 'sb_layout', '=', 'both' ),
				'title' => esc_html__('Select right sidebar', 'prospect' ),
				'type' => 'select',
				'addrowclasses' => 'disable',
				'source' => 'sidebars',
			),
			'sb_foot_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Customize footer', 'prospect' ),
				'atts' => 'data-options="e:footer-sidebar-top"',
			),
			'footer-sidebar-top' => array(
				'title' => esc_html__('Footer Widgets area', 'prospect' ),
				'type' => 'select',
				'addrowclasses' => 'disable',
				'source' => 'sidebars',
			),
			'sb_slider_override' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Add Image Slider', 'prospect' ),
				'atts' => 'data-options="e:slider_shortcode"',
			),
			'slider_shortcode' => array(
				'title' => esc_html__( 'Slider shortcode', 'prospect' ),
				'addrowclasses' => 'disable',
				'type' => 'text',
				'default' => ''
			),
		);
	}

	private function init() {
		add_action( 'add_meta_boxes', array($this, 'post_addmb') );
		add_action( 'add_meta_boxes_cws_portfolio', array($this, 'portfolio_addmb') );
		add_action( 'add_meta_boxes_cws_staff', array($this, 'staff_addmb') );
		add_action( 'add_meta_boxes_megamenu_item', array($this, 'mgmenu_addmb') );

		add_action( 'admin_enqueue_scripts', array($this, 'mb_script_enqueue') );
		add_action( 'save_post', array($this, 'post_metabox_save'), 11, 2 );
	}

	public function portfolio_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Portfolio Options', array($this, 'mb_portfolio_callback'), 'cws_portfolio', 'normal', 'high' );
	}

	public function staff_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Staff Options', array($this, 'mb_staff_callback'), 'cws_staff', 'normal', 'high' );
	}

	public function mgmenu_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Megamenu Options', array($this, 'mb_mgmenu_callback'), 'megamenu_item', 'normal', 'high' );
	}

	public function post_addmb() {
		add_meta_box( 'cws-post-metabox-id', 'CWS Post Options', array($this, 'mb_post_callback'), 'post', 'normal', 'high' );
		add_meta_box( 'cws-post-metabox-id', 'CWS Page Options', array($this, 'mb_page_callback'), 'page', 'normal', 'high' );
	}

	public function mb_staff_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'is_clickable' => array(
				'type' => 'checkbox',
				'title' => esc_html__('Clickable link', 'prospect' ),
			),
			'social_group' => array(
				'type' => 'group',
				'addrowclasses' => 'group',
				'title' => esc_html__('Social networks', 'prospect' ),
				'button_title' => esc_html__('Add new social network', 'prospect' ),
				'layout' => array(
					'title' => array(
						'type' => 'text',
						'atts' => 'data-role="title"',
						'title' => esc_html__('Social account title', 'prospect' ),
					),
					'icon' => array(
						'type' => 'select',
						'addrowclasses' => 'fai',
						'source' => 'fa',
						'title' => esc_html__('Select the icon for this social contact', 'prospect' )
					),
					'url' => array(
						'type' => 'text',
						'title' => esc_html__('Url to your account', 'prospect' ),
					),
				),
			)
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr);
		echo prospect_mb_print_layout($mb_attr, 'cws_mb_');
	}

	public function mb_mgmenu_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'fw_mgmenu' => array(
				'type' => 'checkbox',
				'title' => esc_html__('Disable Full Width Megamenu', 'prospect' ),
				'atts' => 'data-options="e:mgmenu_width;e:mgmenu_pos"',
				'addrowclasses' => 'grid-col-12',
			),
			'mgmenu_width' => array(
				'title' 		=> esc_html__( 'Set Fixed Width (in px)', 'prospect' ),
				'type' 			=> 'text',
				'addrowclasses' => 'disable grid-col-12',
				'value'			=> '1170',
			),
			'mgmenu_pos' => array(
				'title' 		=> esc_html__( 'Dropdown Position', 'prospect' ),
				'type' 			=> 'select',
				'addrowclasses' => 'disable grid-col-12',
				'source' => array(
					'center' => array(esc_html__( 'Center', 'prospect' ), true),
					'left' => array(esc_html__( 'Left', 'prospect' ), false),
					'right' => array(esc_html__( 'Right', 'prospect' ), false),
				),
			),
		);
		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr);
		echo prospect_mb_print_layout($mb_attr, 'cws_mb_');
	}

	public function mb_page_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = $this->getPageLayout();

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr);
		echo prospect_mb_print_layout($mb_attr, 'cws_mb_');
	}

	public function mb_portfolio_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'show_related' => array(
				'title' => esc_html__( 'Show related projects', 'prospect' ),
				'type' => 'checkbox',
				'atts' => 'checked data-options="e:related_projects_options;e:rpo_title;e:rpo_cols;e:rpo_items_count"',
			),
			'related_projects_options' => array(
				'type' => 'label',
				'title' => esc_html__( 'Related projects options', 'prospect' ),
			),
			'rpo_title' => array(
				'type' => 'text',
				'title' => esc_html__( 'Title', 'prospect' ),
				'value' => esc_html__( 'Related projects', 'prospect' )
				),
			'rpo_cols' => array(
				'type' => 'select',
				'title' => esc_html__( 'Columns', 'prospect' ),
				'source' => array(
					'1' => array(esc_html__( 'one', 'prospect' ), false),
					'2' => array(esc_html__( 'two', 'prospect' ), false),
					'3' => array(esc_html__( 'three', 'prospect' ), false),
					'4' => array(esc_html__( 'four', 'prospect' ), true),
					),
				),
			'rpo_items_count' => array(
				'type' => 'number',
				'title' => esc_html__( 'Items count', 'prospect' ),
				'value' => '4'
			),
			'img_size' => array(
				'type' => 'select',
				'title' => esc_html__( 'Image Size', 'prospect' ),
				'source' => array(
					'1' => array(esc_html__( 'Boxed', 'prospect' ), true),
					'2' => array(esc_html__( 'Full Width', 'prospect' ), false),
					),
				),
			'enable_hover' => array(
				'title' => esc_html__( 'Enable hover effect', 'prospect' ),
				'type' => 'checkbox',
				'atts' => 'checked data-options="e:link_options;e:link_options_url;e:link_options_fancybox"',
			),
			'link_options' => array(
				'type' => 'label',
				'title' => esc_html__( 'Link options', 'prospect' ),
			),
			'link_options_url' => array(
				'type' => 'text',
				'title' => esc_html__( 'Custom url', 'prospect' ),
				'default' => ''
			),
			'link_options_fancybox' => array(
				'type' => 'checkbox',
				'title' => esc_html__( 'Open in fancybox', 'prospect' ),
				'atts' => 'checked'
			)
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr);
		echo prospect_mb_print_layout($mb_attr, 'cws_mb_');
	}

	public function mb_post_callback( $post ) {
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );

		$mb_attr = array(
			'gallery' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Gallery options', 'prospect' ),
				'layout' => array(
					'gallery' => array(
						'title' => esc_html__( 'Gallery', 'prospect' ),
						'type' => 'gallery'
					)
				)
			),
			'video' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Video options', 'prospect' ),
				'layout' => array(
					'video' => array(
						'title' => esc_html__( 'Url to video file', 'prospect' ),
						'type' => 'text'
					)
				)
			),
			'audio' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Audio options', 'prospect' ),
				'layout' => array(
					'audio' => array(
						'title' => esc_html__( 'Self-hosted/soundclod audio url.', 'prospect' ),
						'subtitle' => esc_html__( 'Ex.: /wp-content/uploads/audio.mp3 or http://soundcloud.com/...', 'prospect' ),
						'type' => 'text'
					)
				)
			),
			'link' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Link options', 'prospect' ),
				'layout' => array(
					'link' => array(
						'title' => esc_html__( 'Url', 'prospect' ),
						'type' => 'text'
					)
				)
			),
			'quote' => array(
				'type' => 'tab',
				'init' => 'closed',
				'title' => esc_html__( 'Quote options', 'prospect' ),
				'layout' => array(
					'quote[quote]' => array(
						'title' => esc_html__( 'Quote', 'prospect' ),
						'subtitle' => esc_html__( 'Enter the quote', 'prospect' ),
						'atts' => 'rows="5"',
						'type' => 'textarea'
					),
					'quote[author_name]' => array(
						'title' => esc_html__( 'Author Name', 'prospect' ),
						'type' => 'text'
					),
					'quote[author_status]' => array(
						'title' => esc_html__( 'Author Status', 'prospect' ),
						'type' => 'text'
					)
				)
			)
		);

		$cws_stored_meta = get_post_meta( $post->ID, 'cws_mb_post' );
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr);
		echo prospect_mb_print_layout($mb_attr, 'cws_mb_');

		$mb_attr_all = array(
			'single_img' => array(
				'title' => esc_html__( 'Show featured image on single post', 'prospect' ),
				'type' => 'checkbox',
				'addrowclasses' => 'checkbox',
				'atts' => 'checked',
			),
		);
		cws_mb_fillMbAttributes($cws_stored_meta, $mb_attr_all);
		echo prospect_mb_print_layout($mb_attr_all, 'cws_mb_');
	}

	public function mb_script_enqueue($a) {
		global $pagenow;
		global $typenow;
		if( ($a == 'widgets.php' || $a == 'post-new.php' || $a == 'post.php' || $a == 'edit-tags.php') && ('customize.php' !== $pagenow) ) {
			if($typenow != 'product'){
				wp_enqueue_script('select2-js', get_template_directory_uri() . '/includes/core/assets/js/select2/select2.js', array('jquery') );
				wp_enqueue_style('select2-css', get_template_directory_uri() . '/includes/core/assets/js/select2/select2.css', false, '2.0.0' );
			}
			wp_enqueue_script('prospect-metaboxes-js', get_template_directory_uri() . '/includes/core/assets/js/metaboxes.js', array('jquery') );
			wp_enqueue_style('prospect-metaboxes-css', get_template_directory_uri() . '/includes/core/assets/css/metaboxes.css', false, '2.0.0' );
			wp_enqueue_media();
			wp_enqueue_style( 'wp-color-picker');
			wp_enqueue_script( 'wp-color-picker');
			wp_enqueue_style( 'mb_post_css' );
		}
	}

	public function post_metabox_save( $post_id, $post )
	{
		if ( in_array($post->post_type, array('post', 'page', 'cws_portfolio', 'cws_staff', 'megamenu_item')) ) {
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
				return;

			if ( !isset( $_POST['mb_nonce']) || !wp_verify_nonce($_POST['mb_nonce'], 'cws_mb_nonce') )
				return;

			if ( !current_user_can( 'edit_post', $post->ID ) )
				return;

			$save_array = array();

			foreach($_POST as $key => $value) {
				if (0 === strpos($key, 'cws_mb_')) {
					if ('on' === $value) {
						$value = '1';
					}
					if (is_array($value)) {
						foreach ($value as $k => $val) {
							if (is_array($val)) {
								$save_array[substr($key, 7)][$k] = $val;
							} else {
								$save_array[substr($key, 7)][$k] = esc_html($val);
							}
						}
					} else {
						$save_array[substr($key, 7)] = esc_html($value);
					}
				}
			}
			if (!empty($save_array)) {
				update_post_meta($post_id, 'cws_mb_post', $save_array);
			}
		}
	}
}
?>